<?xml version="1.0"?>
<!-- 
NAME
    kumonitr.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_monitor_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton	11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng	08/02/02 - add grantee parse param
    htseng	07/26/02 - add more parse params
    htseng	04/22/02 - htseng_ad_export
    htseng	04/08/02 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="MONITOR_T">
  <xsl:if test="MONITOR=1">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">MONITORING</xsl:with-param>
    <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
    <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
    <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
   </xsl:call-template>
   <xsl:text> ALTER TABLE </xsl:text>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="BASE_OBJ/OWNER_NAME"/>
    <xsl:with-param name="Object" select="BASE_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:text> MONITORING </xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
