<?xml version="1.0"?>
<!-- 
NAME
    kupswhis.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_psw_hist_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    rapayn      11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      03/28/03 - fix bug 2872854
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      04/03/02 - htseng_rmgr_obj_support
    htseng	11/27/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="PSW_HIST_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_PSWMG_IMPORT.IMPORT_HISTORY</xsl:with-param>
   <xsl:with-param name="ObjectType">PASSWORD_HISTORY</xsl:with-param>
   <xsl:with-param name="Grantee" select="NAME"/>
  </xsl:call-template>
  <xsl:apply-templates select="HIST_LIST"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text> SYS.DBMS_PSWMG_IMPORT.IMPORT_HISTORY(HIST_REC,i);</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text> END;</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>/</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="HIST_LIST">
  <xsl:for-each select="HIST_LIST_ITEM">
   <xsl:if test="(position() mod 200)= 1">
    <!-- pass 200 records at most for each call, so it won't run out memory  -->
    <xsl:if test="position() != 1">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;    </xsl:text>
     </xsl:if>
     <xsl:text> SYS.DBMS_PSWMG_IMPORT.IMPORT_HISTORY(HIST_REC,i);</xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:text> END;</xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>/</xsl:text>
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
    </xsl:if>
    <!-- position() !=1 -->
    <xsl:text> DECLARE</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;    </xsl:text>
    </xsl:if>
    <xsl:text> SUBTYPE HIST_RECORD IS SYS.DBMS_PSWMG_IMPORT.ARRAYOFHISTORYRECORDS;</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;    </xsl:text>
    </xsl:if>
    <xsl:text> HIST_REC HIST_RECORD;</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;    </xsl:text>
    </xsl:if>
    <xsl:text> i number := 0;</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text> BEGIN</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
   </xsl:if>
   <!-- position() mod 200 =1 -->
   <xsl:text> i := i+1; </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text> HIST_REC(i).USERNAME := '</xsl:text>
   <xsl:value-of select="UNAME"/>
   <xsl:text>';</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text> HIST_REC(i).PASSWORD := '</xsl:text>
   <xsl:value-of select="PASSWORD"/>
   <xsl:text>';</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text> HIST_REC(i).PASSWD_DATE := '</xsl:text>
   <xsl:value-of select="PASSWORD_DATE"/>
   <xsl:text>';</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
