<?xml version="1.0"?>
<!--

 Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 

NAME
    kuscnstr.xsl
DESCRIPTION
    Generate SXML for constraints

MODIFIED        MM/DD/YY
    rapayne    12/15/08 - add IGNORE_NAME_DIFFERENCES attribute for CM
    rapayne    05/05/08 - backout change of SET NULL.
    rapayne    03/01/08 - Add COMPUTE_CONSTR_DEF attrib for CM
                                       Change SET_NULL to SET NULL
    rapayne    01/28/08 - fix flags check for foreign key constraints.
    lbarton     11/27/07 - bug 6474004: RELY
    rapayne     12/04/06 - Integrate EM specific changes
    lbarton     11/03/06 - USING_INDEX transform param
    lbarton     06/23/06 - PARSE_EXPRESSIONS param 
    lbarton     03/27/06 - bug 5118027: CONSTRAINTS and REF_CONSTRAINTS params 
                           for SXML 
    lbarton     11/08/05 - bug 4724986: declare parameter to EnableDisable 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     09/15/05 - bugfix in USING_INDEX processing 
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     11/01/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kusidxwk.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="USING_INDEX">1</xsl:param>
 <!-- Parameters to direct diffing of constraints -->
 <xsl:param name="MATCH_CONSTR_BY_DEFINITION">0</xsl:param>
 <xsl:param name="IGNORE_NAME_DIFFERENCES">0</xsl:param>
 <!-- Templates -->
 <xsl:template name="TableConstraints">
  <!-- *******************************************************************
Template: TableConstraints
Current node: TABLE_T or IONT
******************************************************************** -->
  <xsl:if test="$CONSTRAINTS!=0">
   <xsl:call-template name="CheckConstraints">
    <xsl:with-param name="Property" select="PROPERTY"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$CONSTRAINTS!=0 or (PROPERTY mod 128)>=64 or local-name(.)='IONT'">
   <xsl:call-template name="PKConstraints">
    <xsl:with-param name="Property" select="PROPERTY"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$CONSTRAINTS!=0">
   <xsl:call-template name="UKConstraints">
    <xsl:with-param name="Property" select="PROPERTY"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$REF_CONSTRAINTS!=0">
   <xsl:call-template name="FKConstraints">
    <xsl:with-param name="Property" select="PROPERTY"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$CONSTRAINTS!=0">
   <xsl:call-template name="ScopeConstraints"/>
   <xsl:call-template name="RowidConstraints"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CheckConstraints">
  <xsl:param name="Property">0</xsl:param>
  <!-- *******************************************************************
Template: CheckConstraints
Current node: TABLE_T
Parameters:
  Property: TABLE_T/PROPERTY
******************************************************************** -->
  <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE='1']">
   <xsl:element name="CHECK_CONSTRAINT_LIST">
    <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[CONTYPE='1']">
     <xsl:element name="CHECK_CONSTRAINT_LIST_ITEM">
      <xsl:if test="$MAKE_DIFF_READY=1">
       <xsl:attribute name="MATCH_CONSTR_BY_DEFINITION"><xsl:value-of select="$MATCH_CONSTR_BY_DEFINITION"/></xsl:attribute>
       <xsl:attribute name="IGNORE_NAME_DIFFERENCES"><xsl:value-of select="$IGNORE_NAME_DIFFERENCES"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="$MAKE_DIFF_READY=1">
       <xsl:attribute name="NAME"><xsl:value-of select="NAME"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="8>(FLAGS mod 16)">
       <xsl:element name="NAME">
        <xsl:value-of select="NAME"/>
       </xsl:element>
      </xsl:if>
      <xsl:choose>
       <xsl:when test="$PARSE_EXPRESSIONS=1 and PARSED_COND">
        <xsl:element name="PARSED_CONDITION">
         <xsl:copy-of select="PARSED_COND/*"/>
        </xsl:element>
       </xsl:when>
       <xsl:otherwise>
        <xsl:element name="CONDITION">
         <xsl:value-of select="CONDITION"/>
        </xsl:element>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="ConstraintState">
       <xsl:with-param name="Property" select="$Property"/>
      </xsl:call-template>
     </xsl:element>
    </xsl:for-each>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ConstraintState">
  <xsl:param name="Property">0</xsl:param>
  <!-- *******************************************************************
Template: ConstraintState
Current node: CON_LIST_ITEM
Parameters:
  Property: TABLE_T/PROPERTY
******************************************************************** -->
  <xsl:if test="FLAGS">
   <xsl:if test="(FLAGS mod 2)=1">
    <xsl:element name="DEFERRABLE"/>
    <xsl:if test="(FLAGS mod 4)>=2">
     <xsl:element name="INITIALLY_DEFERRED"/>
    </xsl:if>
   </xsl:if>
  </xsl:if>
  <xsl:if test="FLAGS">
   <xsl:if test="(FLAGS mod 64)>=32">
    <xsl:element name="RELY"/>
   </xsl:if>
  </xsl:if>
  <xsl:call-template name="EnableDisable">
   <xsl:with-param name="ConNode" select="."/>
  </xsl:call-template>
  <xsl:if test="not ($SEGMENT_ATTRIBUTES=0) and
                not ($PHYSICAL_PROPERTIES=0) and
                not ($USING_INDEX=0)">
   <!-- using_index_clause (much of this logic is from kuconstr.xsl) -->
   <!-- index for other than
       (a) temporary index
           (obj$.flags bit 02 = temporary object)
           with system generated name ('SYS_C')
       or 
       (b) IOT (obj$.property bit 64) primary key (contype=2)
    -->
   <!--xsl:if test="IND and
                not (((IND/BASE_OBJ/FLAGS mod 4)>=2 and
                      starts-with(IND/SCHEMA_OBJ/NAME,'SYS_C')) or
                     (($Property mod 128)>=64 and CONTYPE='2'))"-->
   <xsl:if test="IND and
                not (((IND/BASE_OBJ/FLAGS mod 4)>=2) or
                     (($Property mod 128)>=64 and CONTYPE='2'))">
    <xsl:element name="USING_INDEX">
     <xsl:choose>
      <!-- Non-system-generated name
         and (pkoid (obj$.property bit 4096 = has pk-based OID column)
              or unnamed ('SYS_C') constraint index
                 marked system-generated (obj$.flags bit 4 = system-generated)
      -->
      <xsl:when test="not(starts-with(IND/SCHEMA_OBJ/NAME,'SYS_C')) and
                     ((($Property mod 8192)>=4096 and CONTYPE='2') or 
                      (starts-with(NAME,'SYS_C') and
                       (IND/SCHEMA_OBJ/FLAGS mod 8)>=4))">
       <!-- full INDEX SXML clause -->
       <xsl:call-template name="DoIndex">
        <xsl:with-param name="IndNode" select="IND"/>
        <xsl:with-param name="ConstraintIndex">1</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <!-- not a temporary index -->
      <xsl:when test="2>(IND/BASE_OBJ/FLAGS mod 4)">
       <!-- index properties -->
       <xsl:call-template name="IndexProperties">
        <xsl:with-param name="IndNode" select="IND"/>
        <xsl:with-param name="ConstraintIndex">1</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="PKConstraints">
  <xsl:param name="Property">0</xsl:param>
  <!-- *******************************************************************
Template: PKConstraints
Current node: TABLE_T or IONT
Parameters:
  Property: TABLE_T/PROPERTY
******************************************************************** -->
  <!-- CONTYPE 2 = primary key
 -->
  <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE='2']">
   <xsl:element name="PRIMARY_KEY_CONSTRAINT_LIST">
    <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[CONTYPE='2']">
     <xsl:element name="PRIMARY_KEY_CONSTRAINT_LIST_ITEM">
      <xsl:if test="$MAKE_DIFF_READY=1">
       <xsl:attribute name="MATCH_CONSTR_BY_DEFINITION"><xsl:value-of select="$MATCH_CONSTR_BY_DEFINITION"/></xsl:attribute>
       <xsl:attribute name="IGNORE_NAME_DIFFERENCES"><xsl:value-of select="$IGNORE_NAME_DIFFERENCES"/></xsl:attribute>
      <xsl:attribute name="NAME"><xsl:value-of select="NAME"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="8>(FLAGS mod 16)">
       <xsl:element name="NAME">
        <xsl:value-of select="NAME"/>
       </xsl:element>
      </xsl:if>
      <xsl:call-template name="ConstraintColumnList">
       <xsl:with-param name="ColListNode" select="COL_LIST"/>
      </xsl:call-template>
      <xsl:call-template name="ConstraintState">
       <xsl:with-param name="Property" select="$Property"/>
      </xsl:call-template>
     </xsl:element>
    </xsl:for-each>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ConstraintColumnList">
  <xsl:param name="ColListNode" select="''"/>
  <!-- *******************************************************************
Template: ConstraintColumnList - Generate the simple column list
  with NAME element only
Parameters:
  ColListNode: COL_LIST node or SRC_COL_LIST node or TGT_COL_LIST node
******************************************************************** -->
  <xsl:element name="COL_LIST">
   <xsl:if test="$MAKE_DIFF_READY=1">
    <xsl:attribute name="COMPUTE_CONSTR_DEF">TRUE</xsl:attribute>
   </xsl:if>
   <xsl:for-each select="$ColListNode/COL_LIST_ITEM |
                         $ColListNode/SRC_COL_LIST_ITEM |
                         $ColListNode/TGT_COL_LIST_ITEM">
    <xsl:element name="COL_LIST_ITEM">
     <xsl:call-template name="ColName">
      <xsl:with-param name="ColNode" select="COL"/>
     </xsl:call-template>
     <!-- Add Any Supplemental Log Group NOLOG element -->
     <xsl:if test="(SPARE1 mod 2)=1">
      <xsl:element name="NOLOG"/>
     </xsl:if>
    </xsl:element>
   </xsl:for-each>
  </xsl:element>
 </xsl:template>
 <xsl:template name="UKConstraints">
  <xsl:param name="Property">0</xsl:param>
  <!-- *******************************************************************
Template: UKConstraints
Current node: TABLE_T
Parameters:
  Property: TABLE_T/PROPERTY
******************************************************************** -->
  <!-- CONTYPE 3 = unique key
      OID_OR_SETID non-0 = hidden unique constraint on OID column 
                        or nested tbl column's SETID column
 -->
  <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE='3' and
                                 COL_LIST/COL_LIST_ITEM/OID_OR_SETID='0']">
   <xsl:element name="UNIQUE_KEY_CONSTRAINT_LIST">
    <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[CONTYPE='3' and
                                 COL_LIST/COL_LIST_ITEM/OID_OR_SETID='0']">
     <xsl:element name="UNIQUE_KEY_CONSTRAINT_LIST_ITEM">
      <xsl:if test="$MAKE_DIFF_READY=1">
       <xsl:attribute name="MATCH_CONSTR_BY_DEFINITION"><xsl:value-of select="$MATCH_CONSTR_BY_DEFINITION"/></xsl:attribute>
       <xsl:attribute name="IGNORE_NAME_DIFFERENCES"><xsl:value-of select="$IGNORE_NAME_DIFFERENCES"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="$MAKE_DIFF_READY=1">
       <xsl:attribute name="NAME"><xsl:value-of select="NAME"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="8>(FLAGS mod 16)">
       <xsl:element name="NAME">
        <xsl:value-of select="NAME"/>
       </xsl:element>
      </xsl:if>
      <xsl:call-template name="ConstraintColumnList">
       <xsl:with-param name="ColListNode" select="COL_LIST"/>
      </xsl:call-template>
      <xsl:call-template name="ConstraintState">
       <xsl:with-param name="Property" select="$Property"/>
      </xsl:call-template>
     </xsl:element>
    </xsl:for-each>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="FKConstraints">
  <xsl:param name="Property">0</xsl:param>
  <!-- *******************************************************************
Template: FKConstraints
Current node: TABLE_T
Parameters:
  Property: TABLE_T/PROPERTY
******************************************************************** -->
  <!-- CONTYPE 4 = foreign key
 -->
  <xsl:if test="CON2_LIST/CON2_LIST_ITEM[CONTYPE='4']">
   <xsl:element name="FOREIGN_KEY_CONSTRAINT_LIST">
    <xsl:for-each select="CON2_LIST/CON2_LIST_ITEM[CONTYPE='4']">
     <xsl:element name="FOREIGN_KEY_CONSTRAINT_LIST_ITEM">
      <xsl:if test="$MAKE_DIFF_READY=1">
       <xsl:attribute name="MATCH_CONSTR_BY_DEFINITION"><xsl:value-of select="$MATCH_CONSTR_BY_DEFINITION"/></xsl:attribute>
       <xsl:attribute name="IGNORE_NAME_DIFFERENCES"><xsl:value-of select="$IGNORE_NAME_DIFFERENCES"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="$MAKE_DIFF_READY=1">
       <xsl:attribute name="NAME"><xsl:value-of select="NAME"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="not((FLAGS mod 16)>=8)">
       <xsl:element name="NAME">
        <xsl:value-of select="NAME"/>
       </xsl:element>
      </xsl:if>
      <xsl:choose>
       <!-- A referential constraint on a REF whose referenced object table
           has an OID based on a PRIMARY KEY may specify multiple source
           columns (one for each 'exploded' col/attr of the potentially
           compound Primary key). The source col/attr names were 'corrected'
           to specify the actual REF item when the metadata was collected,
           however only 1 source column must be used in the constraint.
            Example:
              create type type1 as object (a1 number, a2 number);
              create table table1 of type1 (primary key(a1, a2))
                object identifier primary key;
                create table table2 (c1 ref type1,
                   foreign key (c1) references table1);

               Foreign key source columns generated:
                 c1.a1, c1.a2
              each having column property  0x00200000 (2097152)
                  attribute column of a user-defined ref.
             Corrected columns names stored, respectively:
               c1,    c1
        -->
       <xsl:when test="(SRC_COL_LIST/SRC_COL_LIST_ITEM/COL/PROPERTY mod 4194304)>=2097152">
        <xsl:element name="COL_LIST">
         <xsl:if test="$MAKE_DIFF_READY=1">
          <xsl:attribute name="COMPUTE_CONSTR_DEF">TRUE</xsl:attribute>
         </xsl:if>
         <xsl:element name="COL_LIST_ITEM">
          <xsl:call-template name="ColName">
           <xsl:with-param name="ColNode" select="SRC_COL_LIST/SRC_COL_LIST_ITEM/COL"/>
          </xsl:call-template>
         </xsl:element>
        </xsl:element>
       </xsl:when>
       <xsl:otherwise>
        <xsl:call-template name="ConstraintColumnList">
         <xsl:with-param name="ColListNode" select="SRC_COL_LIST"/>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:element name="REFERENCES">
       <xsl:if test="$MAKE_DIFF_READY=1">
        <xsl:attribute name="COMPUTE_CONSTR_DEF">TRUE</xsl:attribute>
       </xsl:if>
       <xsl:apply-templates select="SCHEMA_OBJ"/>
       <!-- A referential constraint on a REF whose referenced object table
           has an OID based on a PRIMARY KEY may specify multiple target
           columns (one for each col/attr of the potentially compound Primary
           key - see above example).  Do not emit the target col/attr list
           if the ref attribute property exists for the [first] source col
           (unneeded since it references the Primary key).
        -->
       <xsl:if test="(SRC_COL_LIST/SRC_COL_LIST_ITEM/COL/PROPERTY mod 4194304)&lt;2097152">
        <xsl:call-template name="ConstraintColumnList">
         <xsl:with-param name="ColListNode" select="TGT_COL_LIST"/>
        </xsl:call-template>
       </xsl:if>
       <!-- ON DELETE -->
       <xsl:if test="REFACT">
        <xsl:element name="ON_DELETE">
         <xsl:choose>
          <xsl:when test="REFACT='1'">CASCADE</xsl:when>
          <xsl:when test="REFACT='2'">SET_NULL</xsl:when>
          <!-- set default is in kuconstr.xsl but not in SQL Ref Manual -->
          <xsl:otherwise>SET_DEFAULT</xsl:otherwise>
         </xsl:choose>
        </xsl:element>
       </xsl:if>
       <!-- end of REFERENCES -->
      </xsl:element>
      <xsl:call-template name="ConstraintState">
       <xsl:with-param name="Property" select="$Property"/>
      </xsl:call-template>
      <!-- end of FOREIGN_KEY_CONSTRAINT_LIST_ITEM -->
     </xsl:element>
    </xsl:for-each>
    <!-- end of FOREIGN_KEY_CONSTRAINT_LIST -->
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ScopeConstraints">
  <!-- *******************************************************************
Template: ScopeConstraints
Current node: TABLE_T
******************************************************************** -->
  <!-- PKREFs with reftyp=1
       reftyp    number not null                          /* REF type flag */
                                                   /* 0x01 = REF is scoped */
                                           /* 0x02 = REF stored with rowid */
                                           /* 0x04 = Primary key based ref */
                            /* 0x08 = Allow unscoped Primary key based ref */
  ... Except that SCOPE is skipped if col. list FOREIGN KEY for that REF ...
  foreignkey    number,               /* 1= scoped REF is also a foreign key */
    -->
  <xsl:if test="PKREF_LIST/PKREF_LIST_ITEM[(REFTYP mod 2)=1 and FOREIGNKEY=0]">
   <xsl:element name="SCOPE_CONSTRAINT_LIST">
    <xsl:for-each select="PKREF_LIST/PKREF_LIST_ITEM[
                                          (REFTYP mod 2)=1 and FOREIGNKEY=0]">
     <xsl:element name="SCOPE_CONSTRAINT_LIST_ITEM">
      <xsl:element name="COL">
       <xsl:value-of select="NAME"/>
      </xsl:element>
      <xsl:element name="REFERENCES">
       <xsl:apply-templates select="SCHEMA_OBJ"/>
      </xsl:element>
      <!-- end of SCOPE_CONSTRAINT_LIST_ITEM -->
     </xsl:element>
    </xsl:for-each>
    <!-- end of SCOPE_CONSTRAINT_LIST -->
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="RowidConstraints">
  <!-- *******************************************************************
Template: RowidConstraints
Current node: TABLE_T
******************************************************************** -->
  <!-- PKREFs with reftyp=2
       reftyp    number not null                          /* REF type flag */
                                                   /* 0x01 = REF is scoped */
                                           /* 0x02 = REF stored with rowid */
                                           /* 0x04 = Primary key based ref */
                            /* 0x08 = Allow unscoped Primary key based ref */
    -->
  <xsl:if test="PKREF_LIST/PKREF_LIST_ITEM[(REFTYP mod 4)=2]">
   <xsl:element name="ROWID_CONSTRAINT_LIST">
    <xsl:for-each select="PKREF_LIST/PKREF_LIST_ITEM[(REFTYP mod 4)=2]">
     <xsl:element name="ROWID_CONSTRAINT_LIST_ITEM">
      <xsl:element name="COL">
       <xsl:call-template name="ColOrAttrName">
        <xsl:with-param name="ColNode" select="."/>
       </xsl:call-template>
      </xsl:element>
      <xsl:if test="(REFTYP mod 16)>=8">
       <xsl:element name="ALLOW_PRIMARY_KEY"/>
      </xsl:if>
      <!-- end of ROWID_CONSTRAINT_LIST_ITEM -->
     </xsl:element>
    </xsl:for-each>
    <!-- end of ROWID_CONSTRAINT_LIST -->
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="SupplementalLogging">
  <!-- *******************************************************************
Template: SupplementalLogging (implemented as a constraint
Current node: TABLE_T
******************************************************************** -->
  <!--
    supplemental log groups (w/ keys) (12),
    supplemental log data (no keys) (14,15,16,17)
 -->
  <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE='12' or
                                        CONTYPE='14' or
                                        CONTYPE='15' or
                                        CONTYPE='16' or
                                        CONTYPE='17']">
   <xsl:element name="SUPPLEMENTAL_LOGGING">
    <!-- group list -->
    <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE='12']">
     <xsl:element name="GROUP_LIST">
      <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[CONTYPE='12']">
       <!-- sort is required to get reproducible results in lrgs -->
       <xsl:sort select="CON_NUM" data-type="number"/>
       <xsl:element name="GROUP_LIST_ITEM">
        <xsl:element name="NAME">
         <xsl:value-of select="NAME"/>
        </xsl:element>
        <xsl:call-template name="ConstraintColumnList">
         <xsl:with-param name="ColListNode" select="COL_LIST"/>
        </xsl:call-template>
        <xsl:if test="(FLAGS mod 128)>=64">
         <xsl:element name="ALWAYS"/>
        </xsl:if>
       </xsl:element>
      </xsl:for-each>
     </xsl:element>
    </xsl:if>
    <!-- id list -->
    <xsl:if test="CON1_LIST/CON1_LIST_ITEM[CONTYPE='14' or
                                          CONTYPE='15' or
                                          CONTYPE='16' or
                                          CONTYPE='17']">
     <xsl:element name="ID_LIST">
      <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[CONTYPE='14' or
                                                    CONTYPE='15' or
                                                    CONTYPE='16' or
                                                    CONTYPE='17']">
       <!-- sort is required to get reproducible results in lrgs -->
       <xsl:sort select="CON_NUM" data-type="number"/>
       <xsl:element name="ID_LIST_ITEM">
        <xsl:element name="COLUMNS">
         <xsl:choose>
          <xsl:when test="CONTYPE='14'">PRIMARY_KEY</xsl:when>
          <xsl:when test="CONTYPE='15'">UNIQUE</xsl:when>
          <xsl:when test="CONTYPE='16'">FOREIGN_KEY</xsl:when>
          <xsl:when test="CONTYPE='17'">ALL</xsl:when>
         </xsl:choose>
        </xsl:element>
       </xsl:element>
      </xsl:for-each>
     </xsl:element>
    </xsl:if>
   </xsl:element>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
