<?xml version="1.0"?>
<!--

 Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 

NAME
    kuscomm.xsl
DESCRIPTION
    Templates for common and utility functions (XML-SXML conversion)

MODIFIED        MM/DD/YY
    ebatbout    09/15/08 - bug 6075698: add input parameter, ExternalTable, to
                           ColumnDefinition template.  Additional info will be
                           written to sxml doc. for the external table case.
                           add support to TYPE_NUM template for STRMTABLE_T
                           xml document
    rapayne     01/05/08 - bug 7605276: in 11.2 (i.e., with edition support)
                           the original owner# is now stored in obj$.spare3 -
                           while obj$.owner# now contains the internal adjunct
                           schema when editions have been enabled.
    rapayne     10/12/08 - bug 7413914 - fix char_semantics for varrays and nested tables.
    rapayne     10/07/08 - bug 7438241 - fix udt generation for pls_types.
    rapayne     02/12/08 - Support CHAR_SEMANTICS
                         - Add ParentNode to TypeName and TYPE_NUM 
                           templates to make them more general purpose.
    rapayne     02/10/08 - add SUPERTYPE_OBJ to schema_obj template
    lbarton     01/24/08 - Bug 6724820: add VERSION param
    lbarton     12/12/07 - bug 6682373: char semantics
    abodge      01/22/07 - add ADD_TBLCOL_NUM parameter
    rapayne     12/04/06 - Integrate EM specific changes
    lbarton     11/20/06 - remove ENABLE VALIDATE
    lbarton     09/28/06 - bugfix: named not null constraint
    htseng      05/23/06 - add virtual support 
    lbarton     03/27/06 - move EnableDisable from kuxcnstr to here 
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     11/01/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top-level parameters -->
 <xsl:param name="MAKE_DIFF_READY">0</xsl:param>
 <xsl:param name="ADD_TBLCOL_NUM">0</xsl:param>
 <xsl:param name="VERSION">9999999999</xsl:param>
 <xsl:param name="LRG">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="/">
  <!-- *******************************************************************
Top level template for all objects
******************************************************************** -->
  <xsl:apply-templates/>
 </xsl:template>
 <xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
   <xsl:apply-templates/>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="SCHEMA_OBJ | BASE_OBJ | SUPERTYPE_OBJ">
  <!-- *******************************************************************
Template: SCHEMA_OBJ | BASE_OBJ
 This template puts out SCHEMA and NAME elements
******************************************************************** -->
  <xsl:element name="SCHEMA">
   <xsl:variable name="Owner">
     <xsl:choose>
       <xsl:when test="not(string(OWNER_NAME2))">
         <xsl:value-of select="OWNER_NAME"/>
       </xsl:when>
       <xsl:otherwise>
         <xsl:value-of select="OWNER_NAME2"/>
       </xsl:otherwise>
     </xsl:choose>
   </xsl:variable>
   <xsl:value-of select="$Owner"/>
  </xsl:element>
  <xsl:element name="NAME">
   <xsl:value-of select="NAME"/>
  </xsl:element>
 </xsl:template>
 <xsl:template name="SimpleColumnList">
  <xsl:param name="ColListNode" select="''"/>
  <!-- *******************************************************************
Template: SimpleColumnList
Parameters:
 ColListNode - COL_LIST node
 This template puts out a simple column_list (names only).
 Assumes that NAME is a child of COL_LIST_ITEM
******************************************************************** -->
  <xsl:element name="COL_LIST">
   <xsl:for-each select="$ColListNode/COL_LIST_ITEM">
    <xsl:element name="COL_LIST_ITEM">
     <xsl:element name="NAME">
      <xsl:value-of select="NAME"/>
     </xsl:element>
    </xsl:element>
   </xsl:for-each>
  </xsl:element>
 </xsl:template>
 <xsl:template name="ColNameType">
  <xsl:param name="ColListItem" select="''"/>
  <!-- *******************************************************************
Template: ColNameType - put out NAME and DATATYPE
Parameters:
  ColListItem - COL_LIST_ITEM
******************************************************************** -->
  <xsl:call-template name="ColName">
   <xsl:with-param name="ColNode" select="$ColListItem"/>
  </xsl:call-template>
  <xsl:call-template name="TypeName">
   <xsl:with-param name="TypeNumNode" select="$ColListItem/TYPE_NUM"/>
   <xsl:with-param name="ParentNode" select="$ColListItem"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="ColName">
  <xsl:param name="ColNode" select="''"/>
  <!-- *******************************************************************
Template: ColName - put out NAME
Parameters:
  ColNode - Parent of NAME and ATTRNAME
******************************************************************** -->
  <xsl:element name="NAME">
   <xsl:call-template name="ColOrAttrName">
    <xsl:with-param name="ColNode" select="$ColNode"/>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="ColOrAttrName">
  <xsl:param name="ColNode" select="''"/>
  <!-- *******************************************************************
Template: ColOrAttrName - put out content of NAME
Parameters:
  ColNode - Parent of NAME and ATTRNAME
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ColNode/ATTRNAME">
    <xsl:value-of select="$ColNode/ATTRNAME"/>
   </xsl:when>
   <xsl:when test="$ColNode/NAME='SYS_NC_ROWINFO$'">
    <!-- SQL Ref Manual says to use pseudocolumn OBJECT_VALUE instead of
          SYS_NC_ROWINFO$ -->
    <xsl:text>OBJECT_VALUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$ColNode/NAME"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="TypeName">
  <xsl:param name="TypeNumNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: TypeName
 This template puts out DATATYPE and type name
Parameters:
 TypeNumNode - TYPE_NUM node
ParentNode - Node containing TYPEMD, PRECISION_NUM, SCALE, CHARSETFORM
******************************************************************** -->
  <DATATYPE>
   <xsl:choose>
    <xsl:when test="$TypeNumNode='1' or $TypeNumNode='9'">
     <xsl:choose>
      <xsl:when test="$ParentNode/CHARSETFORM='2'">
       <xsl:text>NVARCHAR2</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>VARCHAR2</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$TypeNumNode='96'">
     <xsl:choose>
      <xsl:when test="$ParentNode/CHARSETFORM='2'">
       <xsl:text>NCHAR</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>CHAR</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$TypeNumNode='3' or
                                $TypeNumNode='246'">INTEGER</xsl:when>
    <xsl:when test="$TypeNumNode='4' or 
                                $TypeNumNode='21' or
                                $TypeNumNode='22'">FLOAT</xsl:when>
    <xsl:when test="$TypeNumNode='7'">DECIMAL</xsl:when>
    <xsl:when test="$TypeNumNode='2'">
     <xsl:choose>
      <xsl:when test="($ParentNode/PRECISION_NUM)
             and not($ParentNode/SCALE)">FLOAT</xsl:when>
      <xsl:otherwise>NUMBER</xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$TypeNumNode='100'">BINARY_FLOAT</xsl:when>
    <xsl:when test="$TypeNumNode='101'">BINARY_DOUBLE</xsl:when>
    <xsl:when test="$TypeNumNode='8'">LONG</xsl:when>
    <xsl:when test="$TypeNumNode='24'">LONG_RAW</xsl:when>
    <xsl:when test="$TypeNumNode='23' or
                                $TypeNumNode='95'">RAW</xsl:when>
    <xsl:when test="$TypeNumNode='12'">DATE</xsl:when>
    <xsl:when test="$TypeNumNode='180'">TIMESTAMP</xsl:when>
    <xsl:when test="$TypeNumNode='181'">TIMESTAMP_WITH_TIMEZONE</xsl:when>
    <xsl:when test="$TypeNumNode='231'">TIMESTAMP_WITH_LOCAL_TIMEZONE</xsl:when>
    <xsl:when test="$TypeNumNode='182'">INTERVAL_YEAR_TO_MONTH</xsl:when>
    <xsl:when test="$TypeNumNode='183'">INTERVAL_DAY_TO_SECOND</xsl:when>
    <xsl:when test="$TypeNumNode='178'">TIME</xsl:when>
    <xsl:when test="$TypeNumNode='179'">TIME_WITH_TIMEZONE</xsl:when>
    <xsl:when test="$TypeNumNode='113'">BLOB</xsl:when>
    <xsl:when test="$TypeNumNode='112'">
     <xsl:choose>
      <xsl:when test="$ParentNode/CHARSETFORM='2'">
       <xsl:text>NCLOB</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>CLOB</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$TypeNumNode='114'">BFILE</xsl:when>
    <xsl:when test="$TypeNumNode='69'">ROWID</xsl:when>
    <xsl:when test="$TypeNumNode='208'">UROWID</xsl:when>
    <xsl:when test="$TypeNumNode='105'">MLSLABEL</xsl:when>
    <xsl:when test="$TypeNumNode='121'">UDT</xsl:when>
    <xsl:when test="$TypeNumNode='108' ">
     <xsl:choose>
      <xsl:when test="($ParentNode/PROPERTIES mod 65536)>=32768">
       <xsl:text>REF</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>UDT</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$TypeNumNode='122'">NESTED_TABLE</xsl:when>
    <xsl:when test="$TypeNumNode='123'">VARRAY</xsl:when>
    <xsl:when test="$TypeNumNode='111'">REF</xsl:when>
    <xsl:when test="$TypeNumNode='58'">
     <xsl:choose>
      <xsl:when test="$TypeNumNode/../TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS' and
         $ParentNode/TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE'">XMLTYPE</xsl:when>
      <!-- First test is valid for table metadata and the second test is valid
           for stream metadata -->
      <xsl:when test="($TypeNumNode/../TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS' and
         $ParentNode/TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE') or
         ($ParentNode/TYPEMD/OWNER_NAME='SYS' and 
          $ParentNode/TYPEMD/NAME='XMLTYPE')">XMLTYPE</xsl:when>
      <xsl:otherwise>OPAQUE</xsl:otherwise>
     </xsl:choose>
    </xsl:when>
   </xsl:choose>
  </DATATYPE>
 </xsl:template>
 <xsl:template name="ColumnDefinition">
  <xsl:param name="ExternalTable">0</xsl:param>
  <!-- *******************************************************************
Template: ColumnDefinition - Emit the column_definition
Current Node: {TABLE_T | CLUSTER_T}/COL_LIST/COL_LIST_ITEM
******************************************************************** -->
  <!-- Column NAME -->
  <xsl:choose>
   <!-- The input parameter, ExternalTable, will be set to 1 when the transform
        parameter, HIDDEN_COLUMNS, is TRUE -->
   <xsl:when test="$ExternalTable=0">
    <xsl:call-template name="ColName">
     <xsl:with-param name="ColNode" select="."/>
    </xsl:call-template>
    </xsl:when>
   <xsl:otherwise>
    <xsl:element name="NAME">
     <xsl:choose>
      <xsl:when test="ATTRNAME">
       <xsl:value-of select="ATTRNAME"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="NAME"/> 
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$ADD_TBLCOL_NUM=1">
   <!-- Add COL_NUM needed to perform SXML Diff -->
   <xsl:element name="COL_NUM">
    <xsl:value-of select="COL_NUM"/>
   </xsl:element>
  </xsl:if>
  <!-- DATATYPE and related elements (LENGTH, PRECISION, SCALE,
      TYPE_PROPERTIES -->
  <xsl:apply-templates select="TYPE_NUM">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:apply-templates>
  <!-- SORT -->
  <xsl:if test="(PROPERTY mod 268435456)>= 134217728">
   <xsl:element name="SORT"/>
  </xsl:if>
  <!-- DEFAULT/VIRTUAL COLUMN -->
  <xsl:if test="DEFLENGTH !=0">
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 131072)>= 65536 and (PROPERTY mod 512)&lt;256">
     <xsl:element name="VIRTUAL">
      <xsl:apply-templates select="DEFAULT_VAL"/>
     </xsl:element>
     <xsl:if test="(PROPERTY mod 64)>= 32">
      <xsl:element name="HIDDEN"/>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="DEFAULT">
      <xsl:apply-templates select="DEFAULT_VAL"/>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <!-- NOT_NULL
   CONTYPE  7: NOT NULL
           11: NOT NULL on ADT type column
 -->
  <xsl:if test="CON/CONTYPE='7' or CON/CONTYPE='11'">
   <xsl:element name="NOT_NULL">
    <xsl:choose>
     <xsl:when test="(CON/FLAGS mod 16) >= 8"/>
     <xsl:when test="CON/NAME">
      <NAME>
       <xsl:value-of select="CON/NAME"/>
      </NAME>
     </xsl:when>
    </xsl:choose>
    <xsl:call-template name="EnableDisable">
     <xsl:with-param name="ConNode" select="CON"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- ENCRYPT -->
  <xsl:if test="(PROPERTY mod 134217728)>=67108864">
   <xsl:element name="ENCRYPT">
    <xsl:element name="USING">
     <xsl:choose>
      <xsl:when test="../../ENCALG='1'">3DES168</xsl:when>
      <xsl:when test="../../ENCALG='2'">AES128</xsl:when>
      <xsl:when test="../../ENCALG='3'">AES192</xsl:when>
      <xsl:when test="../../ENCALG='4'">AES256</xsl:when>
     </xsl:choose>
    </xsl:element>
    <xsl:if test="(PROPERTY mod 1073741824)>=536870912">
     <xsl:element name="NOSALT"/>
    </xsl:if>
   </xsl:element>
  </xsl:if>
  <xsl:if test="$ExternalTable!=0">
   <xsl:element name="SEGCOL_NUM">
    <xsl:value-of select="SEGCOL_NUM"/>
   </xsl:element>
   <xsl:element name="INTCOL_NUM">
    <xsl:value-of select="INTCOL_NUM"/>
   </xsl:element>
   <xsl:if test="(PROPERTY mod 131072)>=65536">
    <xsl:element name="VIRTUAL"/>
   </xsl:if>
   <xsl:if test="ATTRNAME">
    <xsl:element name="INTERNAL_NAME">
     <xsl:value-of select="NAME"/>
    </xsl:element>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template match="DEFAULT_VAL">
  <!-- *******************************************************************
Template: DEFAULT_VAL - column default
******************************************************************** -->
  <xsl:call-template name="Trim_string">
   <xsl:with-param name="String" select="."/>
   <xsl:with-param name="TrimAllWS">1</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="TYPE_NUM">
  <xsl:param name="ParentNode">0</xsl:param>
  <!-- *******************************************************************
Template: TYPE_NUM - Emit column datatype and related elements
Current Node: TABLE_T/COL_LIST/COL_LIST_ITEM/TYPE_NUM or
              STRMTABLE_T/COL_LIST/COL_LIST_ITEM/TYPE_NUM
 ParentNode = Node containing TYPEMD, LENGTH, CHARSETFORM,etc
                     (i.e., use to assume current node was correct)
******************************************************************** -->
  <!-- first the datatype -->
  <xsl:call-template name="TypeName">
   <xsl:with-param name="TypeNumNode" select="."/>
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
  <!-- optional LENGTH -->
  <!-- CHAR, NCHAR, VARCHAR2, NVARCHAR2 -->
  <xsl:if test=".='1' or .='96' or .='9'">
   <xsl:choose>
    <xsl:when test="($ParentNode/CHARSETFORM='2' or (../PROPERTY mod 16777216)>=8388608)
               and $ParentNode/SPARE3">
     <xsl:element name="LENGTH">
      <xsl:value-of select="$ParentNode/SPARE3"/>
     </xsl:element>
    </xsl:when>
    <xsl:when test="($ParentNode/CHARSETFORM='2' or (../PROPERTY mod 16777216)>=8388608)
               and $ParentNode/CHARLENGTH">
     <xsl:element name="LENGTH">
      <xsl:value-of select="$ParentNode/CHARLENGTH"/>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:if test="$ParentNode/LENGTH">
      <xsl:element name="LENGTH">
       <xsl:value-of select="$ParentNode/LENGTH"/>
      </xsl:element>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
   <!-- char semantics (CHAR and VARCHAR2 only)
        Note: PROPERTIES must be checked for TYPE objects -->
   <xsl:if test="($ParentNode/CHARSETFORM!='2') and
                   (($ParentNode/PROPERTY mod 16777216)>=8388608 or
                    ($ParentNode/PROPERTIES mod 8192)>=4096)">
    <xsl:element name="CHAR_SEMANTICS"/>
   </xsl:if>
  </xsl:if>
  <!-- LENGTH: RAW, UROWID -->
  <xsl:if test=".='23' or .='95' or .='208'">
   <xsl:element name="LENGTH">
    <xsl:value-of select="$ParentNode/LENGTH"/>
   </xsl:element>
  </xsl:if>
  <!-- optional PRECISION, SCALE -->
  <!--   2: NUMBER
      178: TIME
      179: TIME_WITH_TIMEZONE
      180: TIMESTAMP
      181: TIMESTAMP_WITH_TIMEZONE
      182: INTERVAL_YEAR_TO_MONTH
      183: INTERVAL_DAY_TO_SECOND
      231: TIMESTAMP_WITH_LOCAL_TIMEZONE
 -->
  <xsl:if test=".='2'
            or .=    '4'
            or .=    '7'
            or .='178'
            or .='179'
            or .='180'
            or .='181'
            or .='182'
            or .='183'
            or .='231'">
   <xsl:if test="$ParentNode/PRECISION_NUM">
    <xsl:element name="PRECISION">
     <xsl:value-of select="$ParentNode/PRECISION_NUM"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="$ParentNode/SCALE">
    <xsl:element name="SCALE">
     <xsl:value-of select="$ParentNode/SCALE"/>
    </xsl:element>
   </xsl:if>
  </xsl:if>
  <!-- TYPE_PROPERTIES for UDTs
       58: OPAQUE
      121: UDT
      122: NESTED_TABLE
      123: VARRAY
      111: REF
  -->
  <xsl:if test="(.='58'
             or .='108'
             or .='121'
             or .='122'
             or .='123'
             or .='111')">
   <xsl:element name="TYPE_PROPERTIES">
    <xsl:choose>
     <xsl:when test="$ParentNode/TYPEMD/SYN_NAME">
      <xsl:if test="$ParentNode/TYPEMD/SYN_OWNER">
       <xsl:element name="SCHEMA">
        <xsl:value-of select="$ParentNode/TYPEMD/SYN_OWNER"/>
       </xsl:element>
      </xsl:if>
      <xsl:element name="NAME">
       <xsl:value-of select="$ParentNode/TYPEMD/SYN_NAME"/>
      </xsl:element>
     </xsl:when>
     <!-- If this is a stream table document,then the type name and owner
          is found under TYPEMD, and not TYPEMD/SCHEMA_OBJ
      -->
     <xsl:when test="$ParentNode/TYPEMD and (../../../../STRMTABLE_T)">
      <xsl:element name="SCHEMA">
       <xsl:value-of select="$ParentNode/TYPEMD/OWNER_NAME"/>
      </xsl:element>
      <xsl:element name="NAME">
       <xsl:value-of select="$ParentNode/TYPEMD/NAME"/>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="$ParentNode/TYPEMD/SCHEMA_OBJ"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="Trim_string">
  <xsl:param name="String"/>
  <xsl:param name="TrimAllWS">0</xsl:param>
  <!-- *******************************************************************
Template: Trim_string - trim trailing white space, then output string
 (copied from kucolumn.xsl)
     Parameters:   String = the string to trim
                   TrimAllWS = 0: only trim trailing space (default)
                               1: trim all trailing whitespace
     TrimAllWS is designed to handle default values that are stored
     in the dictionary with a trailing new-line, e.g.,

       create table foo( a number default 1
                    );

     The default value is stored as "1<NL>".
     Since pretty-printing introduces a new-line before the trailing right
     paren, failure to trim the new-line in the default value can cause
     a blank line in the generated DDL:

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1

         );

     Trimming the new-line fixes the problem in this case, but it doesn't
     if the column default value includes a comment and the column is not the
     last item before the right paren: in that case the comma separator
     appears right after the comment, i.e., it becomes part of the comment.  
     (Since XSL does not allow the string "dash-dash" inside xsl comments,
     in this and subsequent examples the comment string is represented "- -").

       create table foo(a number default 1 - - this is a comment
                    , constraint bar foreign key ...
                    );

     We would generate

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1 - - this is a comment,
         CONSTRAINT "BAR" FOREIGN KEY ...
         );

     The code below causes the least harm but is still not perfect, e.g.,

       create table foo(a number default 1 - - this is a comment
                    );

     still results in a blank line

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1 - - this is a comment

         );

     (All this would be much easier if xsl allowed us to keep state.)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$TrimAllWS=1 and contains($String,'--')=0 and
string-length(normalize-space(substring($String,string-length($String),1)))=0">
    <xsl:call-template name="Trim_string">
     <xsl:with-param name="String" select="substring($String,1,string-length($String)-1)"/>
     <xsl:with-param name="TrimAllWS">1</xsl:with-param>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="substring($String,string-length($String),1)=' '">
    <xsl:value-of select="substring($String,1,string-length($String)-1)"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$String"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="EnableDisable">
  <xsl:param name="ConNode" select="''"/>
  <!-- *******************************************************************
Template: EnableDisable - common processing for ENABLE [NOVALIDATE]
                                                DISABLE [VALIDATE]
11/20/06: We only generate DISABLE and NOVALIDATE.  ENABLE and VALIDATE
       are the defaults.
Parameters:
  ConNode: CON_LIST_ITEM
******************************************************************** -->
  <!-- DISABLE -->
  <!-- ENABLED is NULL or 0 if disabled -->
  <xsl:choose>
   <xsl:when test="$ConNode/ENABLED">
    <xsl:if test="$ConNode/ENABLED='0'">
     <xsl:element name="DISABLE"/>
    </xsl:if>
   </xsl:when>
   <!-- ENABLED is NULL, i.e., disabled -->
   <xsl:otherwise>
    <xsl:element name="DISABLE"/>
   </xsl:otherwise>
  </xsl:choose>
  <!-- NOVALIDATE -->
  <xsl:choose>
   <xsl:when test="$ConNode/FLAGS">
    <xsl:if test="($ConNode/FLAGS mod 8) &lt; 4">
     <xsl:element name="NOVALIDATE"/>
    </xsl:if>
   </xsl:when>
   <!-- FLAGS is NULL, i.e., novalidate -->
   <xsl:otherwise>
    <xsl:element name="NOVALIDATE"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
