<?xml version="1.0"?>
<!--
NAME
    kusdblk.xsl
DESCRIPTION
    Convert mdapi DBLINK_T document to DB_LINK document (SXML)

MODIFIED       MM/DD/YY
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    rapayne    11/03/05 - Bug 4715313: Reformat with XMLSpy
    htseng     12/04/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <!-- Top-level parameters -->
 <xsl:param name="LRG">0</xsl:param>
 <!-- *******************************************************************
Template: DBLINK_T - top-level template for DB_LINK.
  This template puts out
   - the opening DB_LINK element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="DBLINK_T">
  <xsl:element name="DB_LINK">
  <!-- See note about xmlns attribute in kustable.xsl --> 
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:if test="(FLAG mod 2)= 1">
    <xsl:element name="SHARED"/>
   </xsl:if>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="NAME"/>
   </xsl:element>
   <xsl:element name="TYPE">
    <xsl:choose>
     <xsl:when test="USERID">
      <xsl:choose>
       <xsl:when test="USERID = 'CURRENT_USER'">
        <xsl:text>CURRENT_USER</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:text>FIXED_USER</xsl:text>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>CONNECTED_USER</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:if test="USERID != 'CURRENT_USER'">
    <xsl:element name="FIXED_USER">
     <xsl:element name="NAME">
      <xsl:value-of select="USERID"/>
     </xsl:element>
     <!-- undocumented VALUE element required for reg tests -->
     <xsl:if test="$LRG!=0">
      <xsl:element name="VALUE">
       <xsl:value-of select="PASSWORDX"/>
      </xsl:element>
     </xsl:if>
    </xsl:element>
   </xsl:if>
   <xsl:if test="AUTHUSR">
    <xsl:element name="AUTHENTICATING_USER">
     <xsl:element name="NAME">
      <xsl:value-of select="AUTHUSR"/>
     </xsl:element>
     <!-- undocumented VALUE element required for reg tests -->
     <xsl:if test="$LRG!=0">
      <xsl:element name="VALUE">
       <xsl:value-of select="AUTHPWDX"/>
      </xsl:element>
     </xsl:if>
    </xsl:element>
   </xsl:if>
   <xsl:if test="HOST">
    <xsl:element name="REMOTE_HOST">
     <xsl:value-of select="HOST"/>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
