<?xml version="1.0"?>
<!-- 
NAME
    kuseq.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_sequence_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	  MM/DD/YY
    rapayne       11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng        08/02/02 - add grantee parse param
    htseng        07/26/02 - add more pparse params
    htseng        09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	  05/31/01 - Creation 

 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="SEQUENCE_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">SEQUENCE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text> CREATE SEQUENCE  </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:text> MINVALUE </xsl:text>
  <xsl:value-of select="MINVALUE"/>
  <xsl:text> MAXVALUE </xsl:text>
  <xsl:value-of select="MAXVALUE"/>
  <xsl:text> INCREMENT BY </xsl:text>
  <xsl:value-of select="INCRE"/>
  <xsl:text> START WITH </xsl:text>
  <xsl:value-of select="HIGHWATER"/>
  <xsl:choose>
   <xsl:when test="CACHE=0">
    <xsl:text> NOCACHE </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> CACHE </xsl:text>
    <xsl:value-of select="CACHE"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="SEQ_ORDER=1">
    <xsl:text> ORDER </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> NOORDER </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="CYCLE=1">
    <xsl:text> CYCLE </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> NOCYCLE </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
