<?xml version="1.0"?>
<!--
 Copyright (c) 2005, 2008, Oracle and/or its affiliates. All rights reserved.
NAME
    kusidxwd.xsl
DESCRIPTION
    Common functions for converting INDEX (SXML) to DDL
MODIFIED        MM/DD/YY
    lbarton     09/12/08 - bug 7362930: UNUSABLE index (sub)partitions
    lbarton     01/17/08 - Bug 6724820: table compression
    rapayne     10/15/07 - Support LOCAL_PARTITIONING for bitmap join indexes
    lbarton     10/18/06 - import kuscommc
    lbarton     09/15/06 - COLUMN_EXPRESSION
    sdavidso    05/09/06 - support invisible index attribute 
    sdavidso    05/01/06 - support parameters in domain index partitions
    htseng      01/04/06 - add transform partitinoning param
    lbarton     11/11/05 - Initial version
-->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <xsl:import href="kusparsd.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PARTITIONING">1</xsl:param>
 <!-- Templates -->
 <xsl:template name="DoIndex">
  <!-- *******************************************************************
Template: DoIndex - used for INDEX and USING_INDEX in constraints
  This template puts out
   - CREATE [ { UNIQUE | BITMAP } ] INDEX schema.name
  then calls one of
   - ClusterIndex
   - BitmapJoinIndex
   - TableIndex
Parameters:
 IndNode - INDEX node or USING_INDEX node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <xsl:text>  CREATE </xsl:text>
  <xsl:if test="$IndNode/sxml:UNIQUE">UNIQUE </xsl:if>
  <xsl:if test="$IndNode/sxml:BITMAP">BITMAP </xsl:if>
  <xsl:text>INDEX </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="$IndNode"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="$IndNode/sxml:CLUSTER_INDEX">
    <xsl:call-template name="ClusterIndex">
     <xsl:with-param name="IndNode" select="$IndNode/sxml:CLUSTER_INDEX"/>
     <xsl:with-param name="CluNode" select="$IndNode/sxml:CLUSTER_INDEX/sxml:ON_CLUSTER"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="$IndNode/sxml:BITMAP_JOIN_INDEX">
    <xsl:call-template name="BitmapJoinIndex">
     <xsl:with-param name="IndNode" select="$IndNode/sxml:BITMAP_JOIN_INDEX"/>
     <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="TableIndex">
     <xsl:with-param name="IndNode" select="$IndNode/sxml:TABLE_INDEX"/>
     <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <xsl:call-template name="UnusableIndexPartitions">
   <xsl:with-param name="IndNode" select="$IndNode"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="ClusterIndex">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="CluNode" select="''"/>
  <!-- *******************************************************************
Template: ClusterIndex
Parameters:
 IndNode - CLUSTER_INDEX node or USING_INDEX node
 CluNode - ON_CLUSTER node
******************************************************************** -->
  <xsl:text> ON CLUSTER </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="$CluNode"/>
  </xsl:call-template>
  <xsl:if test="($SEGMENT_ATTRIBUTES=1) and ($IndNode/sxml:INDEX_ATTRIBUTES)">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:call-template name="IndexAttributes">
    <xsl:with-param name="AttNode" select="$IndNode/sxml:INDEX_ATTRIBUTES"/>
   </xsl:call-template>
   <!-- PARALLEL -->
   <xsl:call-template name="DoParallel">
    <xsl:with-param name="AttNode" select="$IndNode/sxml:INDEX_ATTRIBUTES"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="IndexAttributes">
  <xsl:param name="AttNode" select="''"/>
  <xsl:param name="BJIndex">0</xsl:param>
  <!-- *******************************************************************
Template: IndexAttributes
Parameters:
 AttNode - INDEX_ATTRIBUTES node
 BJIndex - 1 = this is a bitmap join index
******************************************************************** -->
  <!-- For bitmap join indexes the REVERSE keyword has already been emitted -->
  <xsl:if test="$AttNode/sxml:REVERSE and $BJIndex!=1"> REVERSE</xsl:if>
  <xsl:if test="$AttNode/sxml:INVISIBLE"> INVISIBLE</xsl:if>
  <xsl:call-template name="PhysicalAttributes">
   <xsl:with-param name="ParentNode" select="$AttNode"/>
  </xsl:call-template>
  <xsl:if test="$AttNode/sxml:TABLESPACE and $TABLESPACE!=0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> TABLESPACE "</xsl:text>
   <xsl:value-of select="$AttNode/sxml:TABLESPACE"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoParallel">
  <xsl:param name="AttNode" select="''"/>
  <!-- *******************************************************************
Template: DoParallel
Parameters:
 AttNode - INDEX_ATTRIBUTES node
******************************************************************** -->
  <!-- old syntax -->
  <xsl:apply-templates select="$AttNode/sxml:PARALLEL_DEGREE"/>
  <!-- new syntax -->
  <xsl:apply-templates select="$AttNode/sxml:PARALLEL"/>
 </xsl:template>
 <xsl:template name="BitmapJoinIndex">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: BitmapJoinIndex
Parameters:
 IndNode - BITMAP_JOIN_INDEX node or USING_INDEX node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:text> ON </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="$IndNode/sxml:ON_TABLE"/>
  </xsl:call-template>
  <xsl:if test="$IndNode/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:text> (</xsl:text>
   <xsl:for-each select="$IndNode/sxml:COL_LIST/sxml:COL_LIST_ITEM">
    <xsl:call-template name="MakeJoinTableAlias">
     <xsl:with-param name="JoinTableListNode" select="$IndNode/sxml:JOIN_TABLE_LIST"/>
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <xsl:text>."</xsl:text>
    <xsl:value-of select="sxml:COL"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="sxml:DESC"> DESC</xsl:if>
    <xsl:if test="position()!=last()">,</xsl:if>
   </xsl:for-each>
   <xsl:text>)</xsl:text>
  </xsl:if>
  <xsl:if test="$IndNode/sxml:INDEX_ATTRIBUTES/sxml:REVERSE"> REVERSE </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:text> FROM</xsl:text>
  <xsl:for-each select="$IndNode/sxml:JOIN_TABLE_LIST/sxml:JOIN_TABLE_LIST_ITEM">
   <xsl:text> </xsl:text>
   <xsl:call-template name="SchemaName">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:text> "T</xsl:text>
   <xsl:value-of select="position()"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="position()!=last()">,</xsl:if>
  </xsl:for-each>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:text> WHERE </xsl:text>
  <xsl:for-each select="$IndNode/sxml:WHERE_LIST/sxml:WHERE_LIST_ITEM">
   <xsl:call-template name="MakeJoinTableAlias">
    <xsl:with-param name="JoinTableListNode" select="$IndNode/sxml:JOIN_TABLE_LIST"/>
    <xsl:with-param name="ParentNode" select="sxml:JOIN_LIST/sxml:JOIN_LIST_ITEM[1]"/>
   </xsl:call-template>
   <xsl:text>."</xsl:text>
   <xsl:value-of select="sxml:JOIN_LIST/sxml:JOIN_LIST_ITEM[1]/sxml:COL"/>
   <xsl:text>"=</xsl:text>
   <xsl:call-template name="MakeJoinTableAlias">
    <xsl:with-param name="JoinTableListNode" select="$IndNode/sxml:JOIN_TABLE_LIST"/>
    <xsl:with-param name="ParentNode" select="sxml:JOIN_LIST/sxml:JOIN_LIST_ITEM[2]"/>
   </xsl:call-template>
   <xsl:text>."</xsl:text>
   <xsl:value-of select="sxml:JOIN_LIST/sxml:JOIN_LIST_ITEM[2]/sxml:COL"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="position()!=last()">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text> AND </xsl:text>
   </xsl:if>
  </xsl:for-each>
  <xsl:if test="($SEGMENT_ATTRIBUTES=1) and ($IndNode/sxml:INDEX_ATTRIBUTES)">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:call-template name="IndexAttributes">
    <xsl:with-param name="AttNode" select="$IndNode/sxml:INDEX_ATTRIBUTES"/>
    <xsl:with-param name="BJIndex">1</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$IndNode/sxml:LOCAL_PARTITIONING">
   <xsl:call-template name="LocalPartitionedIndex">
    <xsl:with-param name="PartNode" select="$IndNode/sxml:LOCAL_PARTITIONING"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="MakeJoinTableAlias">
  <xsl:param name="JoinTableListNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: MakeJoinTableAlias
Parameters:
 JoinTableListNode - JOIN_TABLE_LIST
 ParentNode - parent of SCHEMA and NAME
******************************************************************** -->
  <xsl:text>"T</xsl:text>
  <xsl:for-each select="$JoinTableListNode/sxml:JOIN_TABLE_LIST_ITEM">
   <xsl:if test="sxml:SCHEMA=$ParentNode/sxml:SCHEMA and
                 sxml:NAME=$ParentNode/sxml:NAME">
    <xsl:value-of select="position()"/>
    <xsl:text>"</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="TableIndex">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: TableIndex
Parameters:
 IndNode - TABLE_INDEX node or USING_INDEX node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:text> ON </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="$IndNode/sxml:ON_TABLE"/>
  </xsl:call-template>
  <!-- column list -->
  <xsl:if test="$IndNode/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:text> (</xsl:text>
   <xsl:for-each select="$IndNode/sxml:COL_LIST/sxml:COL_LIST_ITEM">
    <xsl:choose>
     <xsl:when test="sxml:COLUMN_EXPRESSION">
      <xsl:apply-templates select="sxml:COLUMN_EXPRESSION"/>
     </xsl:when>
     <xsl:when test="contains(sxml:NAME,'&quot;')">
      <xsl:value-of select="sxml:NAME"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>"</xsl:text>
      <xsl:value-of select="sxml:NAME"/>
      <xsl:text>"</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="sxml:DESC"> DESC</xsl:if>
    <xsl:if test="position()!=last()">,</xsl:if>
   </xsl:for-each>
   <xsl:text>)</xsl:text>
  </xsl:if>
  <!-- Index properties -->
  <xsl:call-template name="IndexProperties">
   <xsl:with-param name="IndNode" select="$IndNode"/>
   <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="IndexProperties">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: IndexProperties
Parameters:
 IndNode - INDEX node or USING_INDEX node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:choose>
   <!-- Domain Index -->
   <xsl:when test="$IndNode/sxml:DOMAIN_INDEX_PROPERTIES">
    <xsl:call-template name="DomainIndex">
     <xsl:with-param name="IndNode" select="$IndNode/sxml:DOMAIN_INDEX_PROPERTIES"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="($SEGMENT_ATTRIBUTES=1) and ($IndNode/sxml:INDEX_ATTRIBUTES)">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:call-template name="IndexAttributes">
      <xsl:with-param name="AttNode" select="$IndNode/sxml:INDEX_ATTRIBUTES"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="($PARTITIONING=1) and ($IndNode/sxml:GLOBAL_PARTITIONING)">
     <xsl:call-template name="GlobalPartitionedIndex">
      <xsl:with-param name="IndNode" select="$IndNode"/>
      <xsl:with-param name="PartNode" select="$IndNode/sxml:GLOBAL_PARTITIONING"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="($PARTITIONING=1) and ($IndNode/sxml:LOCAL_PARTITIONING)">
     <xsl:call-template name="LocalPartitionedIndex">
      <xsl:with-param name="PartNode" select="$IndNode/sxml:LOCAL_PARTITIONING"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="($SEGMENT_ATTRIBUTES=1) and ($IndNode/sxml:INDEX_ATTRIBUTES/sxml:KEYCOMPRESS)">
     <xsl:text> COMPRESS </xsl:text>
     <xsl:value-of select="$IndNode/sxml:INDEX_ATTRIBUTES/sxml:KEYCOMPRESS"/>
    </xsl:if>
    <!-- PARALLEL -->
    <xsl:if test="$SEGMENT_ATTRIBUTES=1">
     <xsl:call-template name="DoParallel">
      <xsl:with-param name="AttNode" select="$IndNode/sxml:INDEX_ATTRIBUTES"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DomainIndex">
  <xsl:param name="IndNode" select="''"/>
  <!-- *******************************************************************
Template: DomainIndex
Parameters:
 IndNode - INDEX node or USING_INDEX node
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> INDEXTYPE IS </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="$IndNode/sxml:INDEXTYPE"/>
  </xsl:call-template>
  <!-- TBS: PARALLEL -->
  <xsl:if test="$IndNode/sxml:PARAMETERS">
   <xsl:text> PARAMETERS ('</xsl:text>
   <xsl:value-of select="$IndNode/sxml:PARAMETERS"/>
   <xsl:text>')</xsl:text>
  </xsl:if>
  <xsl:if test="$IndNode/sxml:LOCAL_PARTITIONING">
   <xsl:call-template name="LocalPartitionedIndex">
    <xsl:with-param name="PartNode" select="$IndNode/sxml:LOCAL_PARTITIONING"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GlobalPartitionedIndex">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <!-- *******************************************************************
Template: GlobalPartitionedIndex
Parameters:
  IndNode - INDEX or IND
  PartNode - GLOBAL_PARTITIONING node
******************************************************************** -->
  <xsl:text> GLOBAL PARTITION BY </xsl:text>
  <xsl:choose>
   <xsl:when test="$PartNode/sxml:RANGE_PARTITIONING">
    <xsl:text>RANGE </xsl:text>
    <xsl:call-template name="IndRangeHashPartitioning">
     <xsl:with-param name="PartitioningNode" select="$PartNode/sxml:RANGE_PARTITIONING"/>
     <xsl:with-param name="PartType">RANGE</xsl:with-param>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="$PartNode/sxml:HASH_PARTITIONING">
    <xsl:text>HASH </xsl:text>
    <xsl:call-template name="IndRangeHashPartitioning">
     <xsl:with-param name="PartitioningNode" select="$PartNode/sxml:HASH_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="IndRangeHashPartitioning">
  <xsl:param name="PartitioningNode" select="''"/>
  <xsl:param name="PartType" select="''"/>
  <!-- *******************************************************************
Template: IndRangeHashPartitioning
Parameters:
  PartitioningNode: RANGE_PARTITIONING or HASH_PARTITIONING
  PartType: RANGE or other
******************************************************************** -->
  <xsl:call-template name="ColumnList">
   <xsl:with-param name="ColListNode" select="$PartitioningNode/sxml:COL_LIST"/>
  </xsl:call-template>
  <xsl:call-template name="IndexPartitionList">
   <xsl:with-param name="PartListNode" select="$PartitioningNode/sxml:PARTITION_LIST"/>
   <xsl:with-param name="PartType" select="$PartType"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="LocalPartitionedIndex">
  <xsl:param name="PartNode" select="''"/>
  <!-- *******************************************************************
Template: LocalPartitionedIndex
Parameters:
  PartNode - LOCAL_PARTITIONING node
******************************************************************** -->
  <xsl:text> LOCAL</xsl:text>
  <xsl:call-template name="IndexPartitionList">
   <xsl:with-param name="PartListNode" select="$PartNode/sxml:PARTITION_LIST"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="IndexPartitionList">
  <xsl:param name="PartListNode" select="''"/>
  <xsl:param name="PartType" select="''"/>
  <!-- *******************************************************************
Template: IndexPartitionList
Parameters:
  PartType: RANGE or other
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text>(</xsl:text>
  <xsl:for-each select="$PartListNode/sxml:PARTITION_LIST_ITEM">
   <xsl:text>PARTITION "</xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="$PartType='RANGE'">
    <xsl:text> VALUES LESS THAN (</xsl:text>
    <xsl:value-of select="sxml:VALUES"/>
    <xsl:text>)</xsl:text>
    <xsl:apply-templates select="sxml:KEYCOMPRESS"/>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="sxml:SEGMENT_ATTRIBUTES">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:call-template name="SegmentAttributes">
      <xsl:with-param name="ParentNode" select="sxml:SEGMENT_ATTRIBUTES"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:TABLESPACE">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:text> TABLESPACE "</xsl:text>
     <xsl:value-of select="sxml:TABLESPACE"/>
     <xsl:text>" </xsl:text>
    </xsl:when>
    <xsl:when test="sxml:PARAMETERS">
     <xsl:text> PARAMETERS ('</xsl:text>
     <xsl:value-of select="sxml:PARAMETERS"/>
     <xsl:text>')</xsl:text>
    </xsl:when>
   </xsl:choose>
   <xsl:if test="sxml:SUBPARTITION_LIST">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text> (</xsl:text>
    <xsl:for-each select="sxml:SUBPARTITION_LIST/sxml:SUBPARTITION_LIST_ITEM">
     <xsl:text> SUBPARTITION "</xsl:text>
     <xsl:value-of select="sxml:NAME"/>
     <xsl:text>"</xsl:text>
     <xsl:if test="sxml:TABLESPACE">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa; </xsl:text>
      </xsl:if>
      <xsl:text> TABLESPACE "</xsl:text>
      <xsl:value-of select="sxml:TABLESPACE"/>
      <xsl:text>"</xsl:text>
     </xsl:if>
     <xsl:if test="position()!=last()">
      <xsl:text>,</xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa; </xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:for-each>
    <xsl:text>) </xsl:text>
   </xsl:if>
   <xsl:if test="position()!=last()">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template name="UnusableIndexPartitions">
  <xsl:param name="IndNode" select="''"/>
  <!-- *******************************************************************
Template: UnusableIndexPartitions process unusable local (sub)partitions of table indexes
Parameters:
  indNode - INDEX
******************************************************************** -->
  <xsl:if test="local-name($IndNode)='INDEX'">
   <xsl:for-each select="$IndNode/sxml:TABLE_INDEX/sxml:LOCAL_PARTITIONING/sxml:PARTITION_LIST/sxml:PARTITION_LIST_ITEM">
    <xsl:call-template name="SetIndexPartitionUnusable">
     <xsl:with-param name="IndNode" select="$IndNode"/>
     <xsl:with-param name="PartNode" select="."/>
    </xsl:call-template>
    <xsl:for-each select="sxml:SUBPARTITION_LIST/sxml:SUBPARTITION_LIST_ITEM">
     <xsl:call-template name="SetIndexPartitionUnusable">
      <xsl:with-param name="IndNode" select="$IndNode"/>
      <xsl:with-param name="PartNode" select="."/>
     </xsl:call-template>
    </xsl:for-each>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>
 <xsl:template name="SetIndexPartitionUnusable">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <!-- *******************************************************************
Template: SetIndexPartitionUnusable - if the (sub)partition is unusable,
  emit ALTER INDEX ... MODIFY (SUB)PARTITION ... UNUSABLE
Parameters:
  indNode - INDEX
  PartNode - the (sub)partition
******************************************************************** -->
  <xsl:if test="sxml:UNUSABLE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> ALTER INDEX </xsl:text>
   <xsl:call-template name="SchemaName">
    <xsl:with-param name="ParentNode" select="$IndNode"/>
   </xsl:call-template>
   <xsl:choose>
    <xsl:when test="local-name($PartNode)='PARTITION_LIST_ITEM'"> MODIFY PARTITION "</xsl:when>
    <xsl:when test="local-name($PartNode)='SUBPARTITION_LIST_ITEM'"> MODIFY SUBPARTITION "</xsl:when>
   </xsl:choose>
   <xsl:value-of select="$PartNode/sxml:NAME"/>
   <xsl:text>" UNUSABLE</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
    <!-- Terminate the SQL statement -->
   </xsl:if>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
