<?xml version="1.0"?>
<!--
NAME
    kusque.xsl
DESCRIPTION
    Convert mdapi QUEUES_T document to QUEUE document (SXML)

MODIFIED        MM/DD/YY
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng     12/09/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <!-- *******************************************************************
Template: QUEUES_T - top-level template for QUEUE.
  This template puts out
   - the opening AQ_QUEUE element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="QUEUES_T">
  <xsl:element name="AQ_QUEUE">
  <!-- See note about xmlns attribute in kustable.xsl --> 
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   </xsl:element>
   <xsl:element name="QUEUE_TABLE">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
    </xsl:element>
    <xsl:element name="NAME">
     <xsl:value-of select="BASE_OBJ/NAME"/>
    </xsl:element>
   </xsl:element>
   <xsl:choose>
    <xsl:when test="USAGE=1">
     <xsl:element name="EXCEPTION_QUEUE"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="MAX_RETRIES">
      <xsl:value-of select="MAX_RETRIES"/>
     </xsl:element>
     <xsl:element name="RETRY_DELAY">
      <xsl:value-of select="RETRY_DELAY"/>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:element name="RETENTION">
    <xsl:value-of select="RETENTION"/>
   </xsl:element>
   <!-- documentation says dependency_tracking is reserved for future use,
      defaults to FALSE and must not be TRUE,
      but reg tests require it so we create the element when necessary  -->
   <xsl:if test="PROPERTIES=1">
    <xsl:element name="DEPENDENCY_TRACKING"/>
   </xsl:if>
   <xsl:if test="string-length(QUEUE_COMMENT)!=0">
    <xsl:element name="COMMENT">
     <xsl:value-of select="QUEUE_COMMENT"/>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
