<?xml version="1.0"?>
<!--
    Copyright (c) 2005, 2006, Oracle. All rights reserved.  
NAME
    kusroled.xsl
DESCRIPTION
    Convert mdapi ROLE_T document to ROLE document (SXML)

MODIFIED        MM/DD/YY
    lbarton     11/29/06 - import kuscommd
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      25/02/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- Top level imports -->
 <!-- *******************************************************************
Template: ROLE - top-level template for ROLE.
  This template puts out
   - CREATE ROLE  name

******************************************************************** -->
 <xsl:template match="sxml:ROLE">
  <xsl:text> CREATE ROLE "</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>" </xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:TYPE= 'APPLICATION'">
    <xsl:text>IDENTIFIED USING "</xsl:text>
    <xsl:value-of select="sxml:PACKAGE/sxml:SCHEMA"/>
    <xsl:text>"."</xsl:text>
    <xsl:value-of select="sxml:PACKAGE/sxml:NAME"/>
    <xsl:text>"</xsl:text>
   </xsl:when>
   <xsl:when test="sxml:TYPE='GLOBAL'">
    <xsl:text>IDENTIFIED GLOBALLY </xsl:text>
   </xsl:when>
   <xsl:when test="sxml:TYPE='EXTERNAL'">
    <xsl:text>IDENTIFIED EXTERNALLY </xsl:text>
   </xsl:when>
   <xsl:when test="sxml:TYPE='LOCAL' and sxml:VALUE">
    <xsl:text>IDENTIFIED BY VALUES '</xsl:text>
    <xsl:value-of select="sxml:VALUE"/>
    <xsl:text>' </xsl:text>
   </xsl:when>
   <xsl:when test="sxml:TYPE='LOCAL' and sxml:PASSWORD">
    <xsl:text>IDENTIFIED BY </xsl:text>
    <xsl:value-of select="sxml:PASSWORD"/>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
