<?xml version="1.0"?>
<!--

 Copyright (c) 2005, 2009, Oracle and/or its affiliates.All rights reserved. 

NAME
    kustabld.xsl
DESCRIPTION
    Convert TABLE document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    rapayne     12/24/08 - bug 759589: add $STATISTICS support from CM code stream.
    lbarton     01/24/08 - Bug 6724820: move VERSION param to kuscommc.xsl
    abodge      01/21/07 - reorder_columns when processing relational tables
    lbarton     10/10/06 - use kustablc
    slynn       11/20/06 - Remove unimplemented keywords
    slynn       10/12/06 - smartfile->securefile
    slynn       07/31/06 - change csce keywords
    jforsyth    03/03/06 - add templates for LOBENCRYPT, COMPRESS, 
                           and SHARE 
    htseng      05/24/06 - add virtual column support 
    kkunchit    11/01/05 - project-18204: inode: LOCAL/NOLOCAL support 
    mbaloglu    12/23/05 - Add Template for SYNC/ASYNC 
    lbarton     03/27/06 - bug 5118027: CONSTRAINTS and REF_CONSTRAINTS params 
                           for SXMLDDL 
    htseng      12/16/05 - add transform param 
    lbarton     11/11/05 - bug 4724986: split off kusidxwd.xsl 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton     09/14/05 - SXML syntax changes required by XML schema 
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     01/17/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kustablc.xsl"/>
 <xsl:import href="kusidxwd.xsl"/>
 <xsl:import href="kuscnstd.xsl"/>
 <xsl:import href="kustbphd.xsl"/>
 <xsl:import href="kuspard.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PHYSICAL_PROPERTIES">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <xsl:param name="PARTITIONING">1</xsl:param>
 <xsl:param name="OID">0</xsl:param>
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- Parameter to place columns in original order (CM) -->
 <xsl:param name="REORDER_COLUMNS">0</xsl:param>
 <!-- Params for genetrating table statistics ddl (Change Mgr) -->
 <xsl:param name="STATISTICS">0</xsl:param>
 <!-- Params for genetrating comments ddl (Change Mgr) -->
 <xsl:param name="COMMENTS">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:TABLE">
  <!-- *******************************************************************
Template: TABLE - top-level template for tables.
  This template puts out
   - CREATE [ GLOBAL TEMPORARY ] TABLE schema.name
 then applies the template for the type of table this is
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$STATISTICS=1">
    <xsl:if test="string(sxml:STATISTICS/sxml:ROWCNT)">
    <xsl:text>BEGIN &#10;</xsl:text>
     <xsl:call-template name="CreateTableStats"/>
     <xsl:call-template name="CreateTablePartStats"/>
     <xsl:text>END;&#10;</xsl:text>
    </xsl:if>
  </xsl:when>
   <xsl:otherwise>
  <xsl:text>  CREATE </xsl:text>
  <xsl:if test="sxml:GLOBAL_TEMPORARY">
   <xsl:text>GLOBAL TEMPORARY </xsl:text>
  </xsl:if>
  <xsl:text>TABLE </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <!-- one of the following will match -->
  <xsl:apply-templates select="sxml:RELATIONAL_TABLE"/>
  <xsl:apply-templates select="sxml:OBJECT_TABLE"/>
  <xsl:apply-templates select="sxml:XMLTYPE_TABLE"/>
    <xsl:if test="$COMMENTS=1 and sxml:COMMENTS">
     <xsl:call-template name="CommentsOn">
      <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:RELATIONAL_TABLE">
  <!-- *******************************************************************
Template: RELATIONAL_TABLE
 calls CreRelTable - for relational tables
******************************************************************** -->
  <xsl:call-template name="CreRelTable"/>
 </xsl:template>
 <xsl:template match="sxml:OBJECT_TABLE">
  <!-- *******************************************************************
Template: OBJECT_TABLE
  calls CreObjTable - for object tables and XMLType tables
******************************************************************** -->
  <xsl:call-template name="CreObjTable"/>
 </xsl:template>
 <xsl:template match="sxml:XMLTYPE_TABLE">
  <!-- *******************************************************************
Template: XMLTYPE_TABLE
  calls CreObjTable - for object tables and XMLType tables
******************************************************************** -->
  <xsl:call-template name="CreObjTable"/>
 </xsl:template>
 <xsl:template name="CreRelTable">
  <!-- *******************************************************************
Template: CreRelTable - processing for relational tables
Current node: TABLE
******************************************************************** -->
  <!-- column list -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text>(</xsl:text>
  <xsl:choose>
   <xsl:when test="$REORDER_COLUMNS=1">
    <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
     <xsl:sort select="@col-num" data-type="number"/>
     <xsl:call-template name="CreateRelationalTable">
     </xsl:call-template>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
     <xsl:call-template name="CreateRelationalTable">
     </xsl:call-template>
    </xsl:for-each>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="Constraints">
   <xsl:with-param name="ParentNode" select="."/>
   <xsl:with-param name="IOT">
    <xsl:choose>
     <xsl:when test="sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE">1</xsl:when>
     <xsl:when test="sxml:TABLE_PROPERTIES//sxml:INDEX_ORGANIZED_TABLE">1</xsl:when>
     <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
  </xsl:call-template>
  <xsl:text>   )</xsl:text>
  <xsl:apply-templates select="sxml:ON_COMMIT"/>
  <xsl:apply-templates select="sxml:PHYSICAL_PROPERTIES"/>
  <xsl:apply-templates select="sxml:TABLE_PROPERTIES"/>
 </xsl:template>
 <xsl:template name="CreObjTable">
  <!-- *******************************************************************
Template: CreObjTable - processing for object tables
Current node: TABLE
******************************************************************** -->
  <xsl:text>OF </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="sxml:OF_TYPE"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <!-- object table substitution -->
  <xsl:apply-templates select="sxml:SUBSTITUTABLE"/>
  <!-- object properties
       - column/attribute defaults
       - constraints
  -->
  <xsl:if test="sxml:OBJECT_COLUMN_PROPERTIES or
                (sxml:FOREIGN_KEY_CONSTRAINT_LIST and $REF_CONSTRAINTS!=0) or
                (sxml:PRIMARY_KEY_CONSTRAINT_LIST and
                ($CONSTRAINTS!=0 or 
                sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE))
                or
                ((sxml:CHECK_CONSTRAINT_LIST or
                sxml:UNIQUE_KEY_CONSTRAINT_LIST or
                sxml:SCOPE_CONSTRAINT_LIST or
                sxml:ROWID_CONSTRAINT_LIST or
                sxml:SUPPLEMENTAL_LOGGING) and $CONSTRAINTS!=0)">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>  (</xsl:text>
   <xsl:if test="sxml:OBJECT_COLUMN_PROPERTIES">
    <xsl:call-template name="ObjectColumnProperties">
     <xsl:with-param name="ColListNode" select="sxml:OBJECT_COLUMN_PROPERTIES/sxml:COL_LIST"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:call-template name="Constraints">
    <xsl:with-param name="ParentNode" select="."/>
    <xsl:with-param name="IOT">
     <xsl:choose>
      <xsl:when test="sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE">1</xsl:when>
      <xsl:when test="sxml:TABLE_PROPERTIES//sxml:INDEX_ORGANIZED_TABLE">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
   </xsl:call-template>
   <xsl:text>  )</xsl:text>
  </xsl:if>
  <!-- XMLType storage, XMLSchema spec -->
  <xsl:if test="sxml:XMLTYPE_STORAGE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>  XMLTYPE</xsl:text>
   <xsl:apply-templates select="sxml:XMLTYPE_STORAGE"/>
   <xsl:if test="$PRETTY=1 and sxml:XMLSCHEMA">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:apply-templates select="sxml:XMLSCHEMA"/>
   <xsl:apply-templates select="sxml:ELEMENT"/>
   <xsl:apply-templates select="sxml:ID"/>
   <xsl:call-template name="XMLTypeAllowDisallowDDL"/>
  </xsl:if>
  <xsl:apply-templates select="sxml:ON_COMMIT"/>
  <xsl:if test="$OID!=0">
   <!-- OID clause -->
   <xsl:apply-templates select="sxml:OID"/>
  </xsl:if>
  <!-- OID index clause -->
  <xsl:apply-templates select="sxml:OIDINDEX"/>
  <!-- physical properties -->
  <xsl:apply-templates select="sxml:PHYSICAL_PROPERTIES"/>
  <!-- table properties -->
  <xsl:apply-templates select="sxml:TABLE_PROPERTIES"/>
 </xsl:template>
 <xsl:template match="sxml:SUBSTITUTABLE">
  <!-- *******************************************************************
Template: SUBSTITUTABLE
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:if test=".='N'"> NOT</xsl:if>
  <xsl:text> SUBSTITUTABLE AT ALL LEVELS</xsl:text>
 </xsl:template>
 <xsl:template name="ObjectColumnProperties">
  <xsl:param name="ColListNode" select="''"/>
  <!-- *******************************************************************
Template: ObjectColumnProperties
Parameters:
 ColListNode - COL_LIST
******************************************************************** -->
  <xsl:for-each select="$ColListNode/sxml:COL_LIST_ITEM">
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
   </xsl:call-template>
   <xsl:text> </xsl:text>
   <xsl:apply-templates select="sxml:DEFAULT"/>
   <xsl:apply-templates select="sxml:NOT_NULL"/>
   <xsl:if test="position()!=last() or
                (../../sxml:FOREIGN_KEY_CONSTRAINT_LIST and $REF_CONSTRAINTS!=0) or
                (../../sxml:PRIMARY_KEY_CONSTRAINT_LIST and
                ($CONSTRAINTS!=0 or 
                sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE))
                or
                ((../../sxml:CHECK_CONSTRAINT_LIST or
                ../../sxml:UNIQUE_KEY_CONSTRAINT_LIST or
                ../../sxml:SCOPE_CONSTRAINT_LIST or
                ../../sxml:ROWID_CONSTRAINT_LIST or
                ../../sxml:SUPPLEMENTAL_LOGGING) and $CONSTRAINTS!=0)">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:ON_COMMIT">
  <!-- *******************************************************************
Template: ON_COMMIT
******************************************************************** -->
  <xsl:text> ON COMMIT </xsl:text>
  <xsl:value-of select="."/>
  <xsl:text> ROWS</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:OID">
  <!-- *******************************************************************
Template: OID
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='SYSTEM_GENERATED'">
    <xsl:text> OBJECT IDENTIFIER IS SYSTEM GENERATED </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:when test=".='PRIMARY_KEY'">
    <xsl:text> OBJECT IDENTIFIER IS PRIMARY KEY </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="$OID!=0">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> OID '</xsl:text>
     <xsl:value-of select="."/>
     <xsl:text>'</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:OIDINDEX">
  <!-- *******************************************************************
Template: OIDINDEX
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> OIDINDEX </xsl:text>
  <xsl:if test="sxml:NAME">
   <xsl:value-of select="sxml:NAME"/>
  </xsl:if>
  <xsl:if test="sxml:PCTFREE or sxml:PCTUSED or 
               sxml:INITRANS or sxml:STORAGE or sxml:TABLESPACE">
   <xsl:text> (</xsl:text>
   <xsl:call-template name="DoSegmentAttributes">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:text>)</xsl:text>
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CreateRelationalTable">
  <!-- *******************************************************************
Template: CreateRelationalTable - processing for relational tables
Current node: COL_LIST_ITEM
******************************************************************** -->
  <!-- column list -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="sxml:NAME"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <xsl:call-template name="Datatype"/>
  <xsl:apply-templates select="sxml:VIRTUAL"/>
  <xsl:apply-templates select="sxml:HIDDEN"/>
  <xsl:apply-templates select="sxml:DEFAULT"/>
  <xsl:apply-templates select="sxml:NOT_NULL"/>
  <xsl:apply-templates select="sxml:ENCRYPT"/>
  <xsl:if test="position()!=last() or
                (../../sxml:FOREIGN_KEY_CONSTRAINT_LIST and $REF_CONSTRAINTS!=0) or
                (../../sxml:PRIMARY_KEY_CONSTRAINT_LIST and
                ($CONSTRAINTS!=0 or 
                ../../sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE or
                ../../sxml:TABLE_PROPERTIES//sxml:INDEX_ORGANIZED_TABLE))
                or
                ((../../sxml:CHECK_CONSTRAINT_LIST or
                ../../sxml:UNIQUE_KEY_CONSTRAINT_LIST or
                ../../sxml:SCOPE_CONSTRAINT_LIST or
                ../../sxml:ROWID_CONSTRAINT_LIST or
                ../../sxml:SUPPLEMENTAL_LOGGING) and $CONSTRAINTS!=0)">,</xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CreateTableStats">
  <!-- *******************************************************************
Template: CreateTableStats
******************************************************************** -->
  <!-- Add DDL to import statistics in SXML document.  These will be 
      generated as DBMS_STATS calls to set statistics.  This template
      is called in the context of a TABLE_T.
   -->
  <xsl:text> DBMS_STATS.SET_TABLE_STATS(OWNNAME=>'</xsl:text>
  <xsl:value-of select="sxml:SCHEMA"/>
  <xsl:text>', </xsl:text>
  <xsl:text>TABNAME=>'</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>', </xsl:text>
  <xsl:text>NUMROWS=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:ROWCNT"/>
  <xsl:text>, </xsl:text>
  <xsl:text>NUMBLKS=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:BLKCNT"/>
  <xsl:text>, </xsl:text>
  <xsl:text>AVGRLEN=></xsl:text>
  <xsl:value-of select="sxml:STATISTICS/sxml:AVGRLN"/>
  <xsl:text>); &#10; </xsl:text>
 </xsl:template>
</xsl:stylesheet>
