<?xml version="1.0"?>
<!-- Copyright (c) 2000, 2009, Oracle and/or its affiliates. 
All rights reserved. -->
<!--
NAME
    kustorag.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of storage parameters
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED        MM/DD/YY
    lbarton     06/15/09 - more archive compression syntax changes
    rapayne     06/05/09 - suppress compression clause when SEGMENT_ATTRIBUTES are not enabled.
    lbarton     11/20/08 - archive level compression
    lbarton     03/18/09 - deferred storage and compression
    adalee      03/09/09 - new cache hints in addition to BUFFER_POOL
    lbarton     02/18/09 - bug 8252494: more deferred segment creation
    tbhukya     12/10/08 - Bug 7630483: table parallel instances 
    mbastawa    02/25/08 - fixed the result cache bit fields
    lbarton     01/16/08 - Bug 6724820: table compression
    sdavidso    07/25/07 - OLTP Compression factoring - partition default
    lbarton     08/02/07 - RESULT_CACHE
    sdavidso    05/16/07 - OLTP Compression factoring
    slynn       10/12/06 - smartfile->securefile
    weizhang    06/12/06 - proj 18567: support LOBRETENTION and MAXSIZE
    lbarton     01/25/06 - add comments 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      10/19/05 - bug 4120481: fix 9.2 for emit MONITOR 
    lbarton     05/11/04 - Bug 3617842: SAMPLE and PCTSPACE 
    htseng      03/30/04 - bug 3531991: table ROWDEPENDENCIES  
    lbarton     10/21/02 - add PARALLEL, RESET_PARALLEL params
    lbarton     08/02/02 - transportable export
    lbarton     06/13/02 - don't emit MONITOR if EXPORT flag on
    lbarton     01/04/02 - remove extra )
    dgagne      11/05/01 - remove row movement from partitions
    dgagne      10/15/01 - add heap segment compression support
    dgagne      06/14/01 - add support for tablespace, rollback, and
                           materialized view
    lbarton	10/30/00 - fix STORAGE and TABLESPACE tests
    gclaborn    11/03/00 - change name
    lbarton	10/05/00 - bugfix: parallel
    lbarton	06/23/00 - MONITORING
    lbarton	06/12/00 - parallel clause
    lbarton	05/15/00 - Params for new API
    lbarton	04/06/00 - Partitioning support
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Templates -->
 <xsl:template match="PCT_FREE | DEFPCTFREE">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <!-- *******************************************************************
Template: PCT_FREE | DEFPCTFREE
 Emit PCTFREE, PCTUSED (for tables only), INITRANS, MAXTRANS
Parameters:
 ADT_type: "TABLE" or "INDEX"
******************************************************************** -->
  <xsl:text>PCTFREE </xsl:text>
  <xsl:value-of select="."/>
  <xsl:if test="not($ADT_type='INDEX')">
   <xsl:text> PCTUSED </xsl:text>
   <xsl:value-of select="../PCT_USED"/>
   <xsl:value-of select="../DEFPCTUSED"/>
  </xsl:if>
  <xsl:text> INITRANS </xsl:text>
  <xsl:value-of select="../INITRANS"/>
  <xsl:value-of select="../DEFINITRANS"/>
  <xsl:text> MAXTRANS </xsl:text>
  <xsl:value-of select="../MAXTRANS"/>
  <xsl:value-of select="../DEFMAXTRANS"/>
  <xsl:text> </xsl:text>
 </xsl:template>
 <xsl:template name="DoParallel">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="FlagsParent" select="''"/>
  <xsl:param name="SetParallel">-1</xsl:param>
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <!-- *******************************************************************
Template: DoParallel
  Emit a bunch of things:
   ROWDEPENDENCIES
   MONITORING
   PARALLEL
Parameters:
 ADT_type: "TABLE" or "INDEX"
 FlagsParent: Parent of FLAGS node (also parent of PROPERTY2)
 SetParallel: user-specified value for PARALLEL (if > 0)
 MVIEW_LOG: 1 = generate attributes for materialized view log
******************************************************************** -->
  <xsl:if test="$PRETTY=1 and 
		(not($ADT_type='INDEX') and 
		(($FlagsParent/FLAGS mod 16)>=8 or
                ($FlagsParent/PROPERTY2 mod 1024)>=512 or
                ($FlagsParent/PROPERTY2 mod 2048)>=1024 or
		($MVIEW_LOG=0 and ($FlagsParent/FLAGS mod 4194304)>=2097152))
		or $FlagsParent/DEGREE)">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <!-- ROWDEF 0x0800000 -->
  <xsl:if test="$FlagsParent/FLAGS mod 16777216>=8388608">
   <xsl:text>ROWDEPENDENCIES </xsl:text>
  </xsl:if>
  <xsl:if test="not($ADT_type='INDEX')">
   <xsl:if test="($FlagsParent/PROPERTY2 mod 1024)=512">RESULT_CACHE(MODE FORCE) </xsl:if>
   <xsl:if test="($FlagsParent/PROPERTY2 mod 2048)=1024">RESULT_CACHE(MODE MANUAL) </xsl:if>
   <xsl:if test="($FlagsParent/FLAGS mod 16)>=8">CACHE </xsl:if>
   <xsl:if test="$EXPORT=0">
    <xsl:if test="$MVIEW_LOG=0 and ($FlagsParent/FLAGS mod 4194304)>=2097152">MONITORING </xsl:if>
   </xsl:if>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="0>$SetParallel">
    <xsl:choose>
     <xsl:when test="$FlagsParent/DEGREE">
      <xsl:text>PARALLEL </xsl:text>
      <xsl:choose>
       <!-- old syntax: PARALLEL (DEGREE n INSTANCES m) -->
       <xsl:when test="32767>$FlagsParent/INSTANCES">
        <xsl:text>(</xsl:text>
        <xsl:choose>
         <xsl:when test="$FlagsParent/DEGREE=32767">DEGREE DEFAULT</xsl:when>
         <xsl:otherwise>
          <xsl:text>DEGREE </xsl:text>
          <xsl:value-of select="$FlagsParent/DEGREE"/>
         </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
         <xsl:when test="32767>$FlagsParent/INSTANCES">
          <xsl:text> INSTANCES </xsl:text>
          <xsl:value-of select="$FlagsParent/INSTANCES"/>
         </xsl:when>
        </xsl:choose>
        <xsl:text>) </xsl:text>
       </xsl:when>
       <xsl:when test="(32767>$FlagsParent/DEGREE) and ($FlagsParent/INSTANCES=32767)">
        <xsl:text>(DEGREE </xsl:text>
        <xsl:value-of select="$FlagsParent/DEGREE"/>
        <xsl:text> INSTANCES DEFAULT) </xsl:text>
       </xsl:when>
       <!-- new syntax PARALLEL [n] -->
       <xsl:otherwise>
        <xsl:if test="32767>$FlagsParent/DEGREE">
         <xsl:value-of select="$FlagsParent/DEGREE"/>
         <xsl:text> </xsl:text>
        </xsl:if>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:otherwise>
      <xsl:if test="$FlagsParent/INSTANCES">
       <xsl:text>PARALLEL </xsl:text>
       <xsl:choose>
        <xsl:when test="32767>=$FlagsParent/INSTANCES">
         <xsl:text>(</xsl:text>
         <xsl:choose>
          <xsl:when test="$FlagsParent/INSTANCES=32767"> INSTANCES DEFAULT</xsl:when>
          <xsl:when test="32767>$FlagsParent/INSTANCES">
           <xsl:text> INSTANCES </xsl:text>
           <xsl:value-of select="$FlagsParent/INSTANCES"/>
          </xsl:when>
         </xsl:choose>
         <xsl:text>) </xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <!-- user-specified value -->
   <xsl:otherwise>
    <xsl:choose>
     <xsl:when test="$SetParallel=0">
      <xsl:text>NOPARALLEL </xsl:text>
     </xsl:when>
     <xsl:when test="$SetParallel>32767">
      <xsl:text>PARALLEL </xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>PARALLEL </xsl:text>
      <xsl:value-of select="$SetParallel"/>
      <xsl:text> </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="STORAGE">
  <xsl:param name="PARTITION">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:param name="ObjType">0</xsl:param>
  <xsl:param name="Dataobjnum">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: STORAGE - 
Parameters:
 PARTITION: 1 = storage for a partition
 Nested: 1 = nested table
 BlkSize: value of BLOCKSIZE
 ObjType: null or 'MVIEW' (when called by kumview.xsl)
 Dataobjnum: DATAOBJ_NUM node
 Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:call-template name="NamedStorage">
   <xsl:with-param name="PARTITION" select="$PARTITION"/>
   <xsl:with-param name="Nested" select="$Nested"/>
   <xsl:with-param name="BlkSize" select="$BlkSize"/>
   <xsl:with-param name="ObjType" select="$ObjType"/>
   <xsl:with-param name="Node" select="current()"/>
   <xsl:with-param name="Dataobjnum" select="$Dataobjnum"/>
   <xsl:with-param name="Pctspace" select="$Pctspace"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="NamedStorage">
  <xsl:param name="PARTITION">0</xsl:param>
  <xsl:param name="Nested">0</xsl:param>
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:param name="ObjType">0</xsl:param>
  <xsl:param name="Node" select="''"/>
  <xsl:param name="Dataobjnum">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: NamedStorage - emit STORAGE params and TABLESPACE
Parameters:
 PARTITION: 1 = storage for a partition
 Nested: 1 = nested table
 BlkSize: value of BLOCKSIZE
 ObjType: ROLLBACK, TABLESPACE or ignored
 Node: STORAGE node
 Dataobjnum: DATAOBJ_NUM node
 Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:if test="$STORAGE=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> STORAGE(</xsl:text>
    <!-- special segment attributes for transportable tablespaces -->
    <xsl:if test="$TRANSPORTABLE=1 and $Dataobjnum!=0">
     <xsl:text>SEG_FILE </xsl:text>
     <xsl:value-of select="$Node/FILE_NUM"/>
     <xsl:text> SEG_BLOCK </xsl:text>
     <xsl:value-of select="$Node/BLOCK_NUM"/>
     <xsl:text> OBJNO_REUSE </xsl:text>
     <xsl:value-of select="$Dataobjnum"/>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> </xsl:text>
    </xsl:if>
    <!-- If supplied - always output INITIAL -->
    <xsl:if test="$Node/DEFINIEXTS or $Node/INIEXTS or $Node/DFLINIT">
     <xsl:text>INITIAL </xsl:text>
     <xsl:choose>
      <xsl:when test="$Node/INIEXTS">
       <xsl:call-template name="DoIniNext">
        <xsl:with-param name="Size" select="$Node/INIEXTS"/>
        <xsl:with-param name="BlkSize" select="$BlkSize"/>
        <xsl:with-param name="Pctspace" select="$Pctspace"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$Node/DFLINIT">
       <xsl:call-template name="DoIniNext">
        <xsl:with-param name="Size" select="$Node/DFLINIT"/>
        <xsl:with-param name="BlkSize" select="$BlkSize"/>
        <xsl:with-param name="Pctspace" select="$Pctspace"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="DoIniNext">
        <xsl:with-param name="Size" select="$Node/DEFINIEXTS"/>
        <xsl:with-param name="BlkSize" select="$BlkSize"/>
        <xsl:with-param name="Pctspace" select="$Pctspace"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
    <!-- If supplied - always output NEXT -->
    <xsl:if test="$Node/DEFEXTSIZE or $Node/EXTSIZE or $Node/DFLINCR">
     <xsl:text> NEXT </xsl:text>
     <xsl:choose>
      <xsl:when test="$Node/EXTSIZE">
       <xsl:call-template name="DoIniNext">
        <xsl:with-param name="Size" select="$Node/EXTSIZE"/>
        <xsl:with-param name="BlkSize" select="$BlkSize"/>
        <xsl:with-param name="Pctspace" select="$Pctspace"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$Node/DFLINCR">
       <xsl:call-template name="DoIniNext">
        <xsl:with-param name="Size" select="$Node/DFLINCR"/>
        <xsl:with-param name="BlkSize" select="$BlkSize"/>
        <xsl:with-param name="Pctspace" select="$Pctspace"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="DoIniNext">
        <xsl:with-param name="Size" select="$Node/DEFEXTSIZE"/>
        <xsl:with-param name="BlkSize" select="$BlkSize"/>
        <xsl:with-param name="Pctspace" select="$Pctspace"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
    <!-- If supplied - always output MINEXTENTS -->
    <xsl:if test="$Node/DEFMINEXTS or $Node/MINEXTS or $Node/DFLMINEXT">
     <xsl:text> MINEXTENTS </xsl:text>
     <xsl:value-of select="$Node/MINEXTS"/>
     <xsl:value-of select="$Node/DFLMINEXT"/>
     <xsl:value-of select="$Node/DEFMINEXTS"/>
    </xsl:if>
    <!-- If supplied - always output MAXEXTENTS -->
    <xsl:if test="$Node/DEFMAXEXTS or $Node/MAXEXTS or $Node/DFLMAXEXT">
     <xsl:text> MAXEXTENTS </xsl:text>
     <xsl:value-of select="$Node/MAXEXTS"/>
     <xsl:value-of select="$Node/DFLMAXEXT"/>
     <xsl:value-of select="$Node/DEFMAXEXTS"/>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <!-- If supplied and not ROLLBACK - output PCTINCREASE -->
    <xsl:if test="$ObjType != 'ROLLBACK'">
     <xsl:if test="$Node/DEFEXTPCT or $Node/EXTPCT or $Node/DFLEXTPCT">
      <xsl:text> PCTINCREASE </xsl:text>
      <xsl:value-of select="$Node/EXTPCT"/>
      <xsl:value-of select="$Node/DFLEXTPCT"/>
      <xsl:value-of select="$Node/DEFEXTPCT"/>
     </xsl:if>
    </xsl:if>
    <!-- If supplied and not ROLLBACK or TABLESPACE
         - output FREELIST, FREELIST GROUPS, BUFFER_POOL, 
           FLASH_CACHE and CELL_FLASH_CACHE -->
    <xsl:if test="($ObjType != 'ROLLBACK') or
                  ($ObjType != 'TABLESPACE')">
     <xsl:if test="2097152 > ($Node/FLAGS mod 4194304) ">
      <!-- non 11glob: FREELISTS and FREELIST GROUPS clause -->
      <xsl:if test="$Node/DEFLISTS > 0 or $Node/LISTS">
       <xsl:text> FREELISTS </xsl:text>
       <xsl:value-of select="$Node/LISTS"/>
       <xsl:value-of select="$Node/DEFLISTS"/>
      </xsl:if>
      <xsl:if test="$Node/DEFGROUPS > 0 or $Node/GROUPS">
       <xsl:text> FREELIST GROUPS </xsl:text>
       <xsl:value-of select="$Node/GROUPS"/>
       <xsl:value-of select="$Node/DEFGROUPS"/>
      </xsl:if>
     </xsl:if>
     <!-- MAXSIZE clause -->
     <!-- 11g: BITMAPRANGES => MAXSIZE -->
     <xsl:if test="$Node/BITMAPRANGES and ($Node/FLAGS mod 8388608)>=4194304
                   or $Node/DEFMAXSIZE">
      <xsl:call-template name="DoMAXSIZE">
       <xsl:with-param name="MaxSize" select="$Node/BITMAPRANGES | $Node/DEFMAXSIZE"/>
       <xsl:with-param name="BlkSize" select="$BlkSize"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$Node/CACHEHINT or $Node/DEFBUFPOOL">
      <xsl:apply-templates select="$Node/CACHEHINT | $Node/DEFBUFPOOL"/>
     </xsl:if>
    </xsl:if>
    <!-- output OPTIMAL if ROLLBACK and OPTIMAL supplied -->
    <xsl:if test="$ObjType = 'ROLLBACK'">
     <xsl:if test="$Node/OPTIMAL">
      <xsl:text> OPTIMAL </xsl:text>
      <xsl:value-of select="$Node/OPTIMAL"/>
     </xsl:if>
    </xsl:if>
    <xsl:text>)</xsl:text>
   </xsl:if>
   <!-- end if storage -->
   <xsl:if test="$TABLESPACE=1">
    <xsl:if test="not($Nested='1')">
     <xsl:apply-templates select="$Node/../TS_NAME"/>
    </xsl:if>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoIniNext">
  <xsl:param name="Size">0</xsl:param>
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: DoIniNext emit the numeric value for INITIAL, NEXT, etc.
Parameters:
 Size: size value in blocks
 BlkSize: value of BLOCKSIZE
 Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($Pctspace)!=0 and $Pctspace!=100">
    <xsl:value-of select="round($Size*$BlkSize*$Pctspace*0.01)"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$Size*$BlkSize"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="TS_NAME | DEFTS_NAME">
  <!-- *******************************************************************
Template: TS_NAME | DEFTS_NAME - emit TABLESPACE ts_name
******************************************************************** -->
  <xsl:if test="$TABLESPACE=1 and $SEGMENT_ATTRIBUTES=1">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> TABLESPACE "</xsl:text>
   <xsl:value-of select="."/>
   <xsl:text>" </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="CACHEHINT | DEFBUFPOOL | BFP_STG">
  <!-- *******************************************************************
Template: CACHEHINT | DEFBUFPOOL - 
          emit BUFFER_POOL/FLASH_CACHE/CELL_FLASH_CACHE
******************************************************************** -->
  <!-- BUFFER_POOL is the least significant 2 bits (bit [0-1]) -->
  <xsl:text> BUFFER_POOL </xsl:text>
  <xsl:choose>
   <xsl:when test="(. mod 4)=1">KEEP</xsl:when>
   <xsl:when test="(. mod 4)=2">RECYCLE</xsl:when>
   <xsl:otherwise>DEFAULT</xsl:otherwise>
  </xsl:choose>
  <!-- new cachehint FLASH_CACHE/ CELL_FLASH_CACHE requires 11.2 comp -->
  <xsl:if test="$VERSION>=1102000000">
   <!-- FLASH_CACHE is the next 2 bits (bit [2-3]) -->
   <xsl:text> FLASH_CACHE </xsl:text>
   <xsl:choose>
    <xsl:when test="floor((. mod 16) div 4)=1">KEEP</xsl:when>
    <xsl:when test="floor((. mod 16) div 4)=2">NONE</xsl:when>
    <xsl:otherwise>DEFAULT</xsl:otherwise>
   </xsl:choose>
   <!-- CELL_FLASH_CACHE is the next 2 bits (bit [4-5]) -->
   <xsl:text> CELL_FLASH_CACHE </xsl:text>
   <xsl:choose>
    <xsl:when test="floor((. mod 64) div 16)=1">KEEP</xsl:when>
    <xsl:when test="floor((. mod 64) div 16)=2">NONE</xsl:when>
    <xsl:otherwise>DEFAULT</xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="LISTS | GROUPS">
  <!-- *******************************************************************
Template: LISTS | GROUPS
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".=0">1</xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="."/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoMAXSIZE">
  <!-- *******************************************************************
Template: DoMAXSIZE
Parameters:
 MaxSize: Maxsimum Size
 BlkSize: Block Size
******************************************************************** -->
  <xsl:param name="MaxSize">0</xsl:param>
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:choose>
   <xsl:when test="$MaxSize=0"/>
   <!-- do nothing if KTSDFMSZP or KTSDFMSZ -->
   <xsl:when test="$MaxSize=4294967295 or $MaxSize=2147483645"/>
   <!-- export UNLIMITED if larger than KTSMXMSZ * SSTPBLCK -->
   <xsl:when test="($MaxSize * $BlkSize) >= (2147483646 * 512)">
    <xsl:text> MAXSIZE UNLIMITED</xsl:text>
   </xsl:when>
   <!-- export in the format of MB if larger than SB4MAXVAL -->
   <xsl:when test="($MaxSize * $BlkSize) > 2147483647">
    <xsl:text> MAXSIZE </xsl:text>
    <xsl:value-of select="floor(($MaxSize * $BlkSize) div 1048576)"/>
    <xsl:text>M</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> MAXSIZE </xsl:text>
    <xsl:value-of select="$MaxSize * $BlkSize"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoDefStorage">
  <xsl:param name="Node" select="''"/>
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: DoDefStorage - Utility template for default clauses
Parameters:
 Node: parent of DEFINIEXTS, etc.
 BlkSize: value of BLOCKSIZE
 Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:if test="$STORAGE=1 and $SEGMENT_ATTRIBUTES=1">
   <xsl:if test="$Node/DEFINIEXTS or
                 $Node/DEFEXTSIZE or 
                 $Node/DEFMINEXTS or 
                 $Node/DEFMAXEXTS or 
                 $Node/DEFEXTPCT or 
                 ($Node/DEFLISTS and $Node/DEFLISTS!=0) or 
                 ($Node/DEFGROUPS and $Node/DEFGROUPS!=0) or 
                 ($Node/DEFMAXSIZE and $Node/DEFMAXSIZE!=0) or
                 $Node/DEFBUFPOOL">
    <xsl:choose>
     <xsl:when test="$Node/DEFBLOCKSIZE>0">
      <xsl:call-template name="NamedStorage">
       <xsl:with-param name="PARTITION" select="0"/>
       <xsl:with-param name="Nested" select="0"/>
       <xsl:with-param name="BlkSize" select="$Node/DEFBLOCKSIZE"/>
       <xsl:with-param name="ObjType" select="'TABLE'"/>
       <xsl:with-param name="Node" select="$Node"/>
       <xsl:with-param name="Pctspace" select="$Pctspace"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="NamedStorage">
       <xsl:with-param name="PARTITION" select="0"/>
       <xsl:with-param name="Nested" select="0"/>
       <xsl:with-param name="BlkSize" select="$BlkSize"/>
       <xsl:with-param name="ObjType" select="'TABLE'"/>
       <xsl:with-param name="Node" select="$Node"/>
       <xsl:with-param name="Pctspace" select="$Pctspace"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template match="DEFLOGGING">
  <!-- *******************************************************************
Template: DEFLOGGING
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".=1"> LOGGING </xsl:when>
   <xsl:when test=".=2"> NOLOGGING </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoSegCompress">
  <xsl:param name="Compress">0</xsl:param>
  <!-- *******************************************************************
Template: DoSegCompress - emit [NO]COMPRESS for leaf partition
                          or non-partitioned table
             seg$.spare1:
                   /* #define KTSSEGM_FLAG_COMPRESSED 0x0800    (2048) */
                   /* #define KTSSEGM_FLAG_OLTP  0x1000000  (16777216) */
                   /* #define KTSSEGM_FLAG_ARCH1 0x2000000  (33554432) */
                   /* #define KTSSEGM_FLAG_ARCH2 0x4000000  (67108864) */
                   /* #define KTSSEGM_FLAG_ARCH3 0x8000000 (134217728) */
          (names defined in ktscts.h)
  OLTP compression only valid in 11.1 and later
  archive compression only valid in 11.2 and later
Parameters:
  Compress: Node with the compression bit
******************************************************************** -->
  <xsl:variable name="flagCompressed">2048</xsl:variable>
  <xsl:variable name="isCompressed" select="($Compress mod ($flagCompressed * 2))>=$flagCompressed"/>
  <xsl:variable name="flagOLTPCompressed">16777216</xsl:variable>
  <xsl:variable name="isOLTPCompressed" select="($Compress mod ($flagOLTPCompressed * 2))>=$flagOLTPCompressed"/>
  <xsl:variable name="flagArch1">33554432</xsl:variable>
  <xsl:variable name="compressLevel" select="floor(($Compress mod ($flagArch1 * 8)) div $flagArch1)"/>
  <xsl:variable name="isArchCompressed" select="$compressLevel!=0"/>
  <xsl:call-template name="DoCompressSyntax">
   <xsl:with-param name="isCompressed" select="$isCompressed"/>
   <xsl:with-param name="isOLTPCompressed" select="$isOLTPCompressed"/>
   <xsl:with-param name="isArchCompressed" select="$isArchCompressed"/>
   <xsl:with-param name="compressLevel" select="$compressLevel"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoPartOBJCompress">
  <xsl:param name="Compress">0</xsl:param>
  <!-- *******************************************************************
Template: DoPartOBJCompress - emit [NO]COMPRESS default value
          for subpartitions of a composite partitioned table
  [from dpart.bsq]
  /*  compression attribute of the partition */
  /*            following bit patterns are possible: */
  /*            00000000 : Compression not specified */
  /*            00000001 : Compression enabled for direct load operations */
  /*            00000010 : Compression disabled      */
  /*            00000101 : Compression enabled for all operations */
  /*            00001001 : Archive Compression: level 1 */
  /*            00010001 : Archive Compression: level 2 */
  /*            00011001 : Archive Compression: level 3 */
  /*            00100001 : Archive Compression: level 4 */
  /*            00101001 : Archive Compression: level 5 */
  /*            00110001 : Archive Compression: level 6 */
  /*            00111001 : Archive Compression: level 7 */
  /*            All other bit patterns are incorrect. */
  These are stored in byte 4 of partobj$.spare2 or byte 0 of tabcompart$.spare2
Parameters:
  Compress: byte containing the partition compression attribute
******************************************************************** -->
  <xsl:variable name="locCompress" select="floor($Compress)"/>
  <xsl:variable name="flagCompressed">1</xsl:variable>
  <xsl:variable name="isCompressed" select="($locCompress mod ($flagCompressed * 2))>=$flagCompressed"/>
  <xsl:variable name="flagOLTPCompressed">4</xsl:variable>
  <xsl:variable name="isOLTPCompressed" select="($Compress mod ($flagOLTPCompressed * 2))>=$flagOLTPCompressed"/>
  <xsl:variable name="flagArch1">8</xsl:variable>
  <xsl:variable name="compressLevel" select="floor(($locCompress mod ($flagArch1 * 8)) div $flagArch1)"/>
  <xsl:variable name="isArchCompressed" select="$compressLevel!=0"/>
  <!-- emit nothing if compression not specified -->
  <xsl:if test="$locCompress!=0">
   <xsl:call-template name="DoCompressSyntax">
    <xsl:with-param name="isCompressed" select="$isCompressed"/>
    <xsl:with-param name="isOLTPCompressed" select="$isOLTPCompressed"/>
    <xsl:with-param name="isArchCompressed" select="$isArchCompressed"/>
    <xsl:with-param name="compressLevel" select="$compressLevel"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoTSCompress">
  <xsl:param name="Compress">0</xsl:param>
  <!-- *******************************************************************
Template: DoTSCompress - emit [NO]COMPRESS value for tablespaces
             ts$.flags:
              /* #define KTT_COMPRESSED               0x40 (64)              */
              /* #define KTT_OLTP_COMPRESSION   0x10000(65536)   */
#define KTT_ARCH1_COMPRESSION  ((ub4)0x20000)    /* Archive compressed table */
#define KTT_ARCH2_COMPRESSION  ((ub4)0x40000)    /* Archive compressed table */
#define KTT_ARCH3_COMPRESSION  ((ub4)0x80000)    /* Archive compressed table */
Parameters:
  Compress: Node with the compression bits
******************************************************************** -->
  <xsl:variable name="locCompress" select="floor($Compress)"/>
  <xsl:variable name="flagCompressed">64</xsl:variable>
  <xsl:variable name="isCompressed" select="($locCompress mod ($flagCompressed * 2))>=$flagCompressed"/>
  <xsl:variable name="flagOLTPCompressed">65536</xsl:variable>
  <xsl:variable name="isOLTPCompressed" select="($Compress mod ($flagOLTPCompressed * 2))>=$flagOLTPCompressed"/>
  <xsl:variable name="flagArch1">131072</xsl:variable>
  <xsl:variable name="compressLevel" select="floor(($locCompress mod ($flagArch1 * 8)) div $flagArch1)"/>
  <xsl:variable name="isArchCompressed" select="$compressLevel!=0"/>
  <xsl:call-template name="DoCompressSyntax">
   <xsl:with-param name="isCompressed" select="$isCompressed"/>
   <xsl:with-param name="isOLTPCompressed" select="$isOLTPCompressed"/>
   <xsl:with-param name="isArchCompressed" select="$isArchCompressed"/>
   <xsl:with-param name="compressLevel" select="$compressLevel"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoCompressSyntax">
  <xsl:param name="isCompressed" select="false()"/>
  <xsl:param name="isOLTPCompressed" select="false()"/>
  <xsl:param name="isArchCompressed" select="false()"/>
  <xsl:param name="compressLevel">0</xsl:param>
  <!-- *******************************************************************
Template: DoCompressSyntax - common template to emit [NO]COMPRESS 
Parameters:
  isCompressed
  isOLTPCompressed
  isArchCompressed - archive compressed
  compressLevel - archive compression level
Implicit input:
  VERSION
Notes:
  Archive level compression is new in 11.2 and has a unique block format
  which is not supported in earlier versions.  Consequently, if VERSION
  is earlier than 11.2, we must specify NOCOMPRESS.
  On the other hand, the block formats for OLTP compression (new in 11.1)
  and DIRECT_LOAD are the same, so if VERSION < 11.1 we can specify COMPRESS.
  (Update: in 11.2 COMPRESS FOR ALL OPERATIONS is renamed COMPRESS FOR OLTP;
   COMPRESS FOR DIRECT_LOAD_OPERATIONS is renamed COMPRESS FOR BASIC.)
******************************************************************** -->
<!-- When segment_attributes are disabled then we should not emit the COMPRESS clause -->
<xsl:if test="$SEGMENT_ATTRIBUTES=1">
  <xsl:choose>
   <xsl:when test=" $isCompressed and $isArchCompressed">
    <xsl:choose>
     <xsl:when test="$VERSION>=1102000000">
      <xsl:choose>
       <xsl:when test="$compressLevel=1">COMPRESS FOR QUERY LOW </xsl:when>
       <xsl:when test="$compressLevel=2">COMPRESS FOR QUERY HIGH </xsl:when>
       <xsl:when test="$compressLevel=3">COMPRESS FOR ARCHIVE LOW </xsl:when>
       <xsl:when test="$compressLevel=4">COMPRESS FOR ARCHIVE HIGH </xsl:when>
       <xsl:otherwise>
        <xsl:text>**INVALID COMPRESSION VALUE (</xsl:text>
        <xsl:value-of select="$compressLevel"/>
        <xsl:text>)** </xsl:text>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:otherwise>NOCOMPRESS </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="$isCompressed and $isOLTPCompressed">
    <xsl:choose>
     <xsl:when test="$VERSION>=1102000000">COMPRESS FOR OLTP </xsl:when>
     <xsl:when test="$VERSION>=1100000000">COMPRESS FOR ALL OPERATIONS </xsl:when>
     <xsl:otherwise>COMPRESS </xsl:otherwise>
     </xsl:choose>
   </xsl:when>
   <xsl:when test="$isCompressed">
    <xsl:text>COMPRESS </xsl:text>
    <xsl:if test="$VERSION>=1102000000">BASIC </xsl:if>
   </xsl:when>
   <xsl:otherwise>NOCOMPRESS </xsl:otherwise>
  </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoDeferredStg">
  <xsl:param name="DeferredStg" select="''"/>
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:param name="lobStorage" select="false()"/>
  <!-- *******************************************************************
Template: DoDeferredStg - generate storage params when seg creation deferred
Current node: TABLE_T, INDEX_T
Parameters:
  DeferredStg - DEFERRED_STORAGE node
  Pctspace - value of the PCTSPACE param; defaults to 100
  lobStorage - TRUE = this is storage for LOB 
******************************************************************** -->
  <!-- compress and logging not valid for lob storage -->
  <xsl:if test="not($lobStorage) and $DeferredStg">
   <!-- compression -->
   <xsl:call-template name="DoCompressSyntax">
    <xsl:with-param name="isCompressed" select="($DeferredStg/FLAGS_STG mod 8)>=4"/>
    <xsl:with-param name="isOLTPCompressed" select="$DeferredStg/CMPFLAG_STG=2"/>
    <xsl:with-param name="isArchCompressed" select="$DeferredStg/CMPFLAG_STG=3"/>
    <xsl:with-param name="compressLevel" select="$DeferredStg/CMPLVL_STG"/>
   </xsl:call-template>
   <!-- treat logging the same as for non-deferred tables -->
   <xsl:call-template name="DoLogging">
    <xsl:with-param name="FlagsNode" select="FLAGS"/>
   </xsl:call-template>
  </xsl:if>
  <!-- STORAGE: use values in deferred_seg$ -->
  <xsl:variable name="hasINITIAL" select="$DeferredStg and $DeferredStg/INITIAL_STG"/>
  <xsl:variable name="hasNEXT" select="$DeferredStg and $DeferredStg/NEXT_STG"/>
  <xsl:variable name="hasMINEXT" select="$DeferredStg and $DeferredStg/MINEXT_STG"/>
  <xsl:variable name="hasMAXEXT" select="$DeferredStg and $DeferredStg/MAXEXT_STG"/>
  <xsl:variable name="hasPCTINC" select="$DeferredStg and $DeferredStg/PCTINC_STG"/>
  <xsl:variable name="hasFREELISTS" select="$DeferredStg and $DeferredStg/FRLINS_STG"/>
  <xsl:variable name="hasFREELIST_GROUPS" select="$DeferredStg and $DeferredStg/MAXINS_STG"/>
  <xsl:variable name="hasBUFFER_POOL" select="$DeferredStg and $DeferredStg/BFP_STG"/>
  <!-- variables to help with pretty-printing -->
  <xsl:variable name="hasLine1" select="$hasINITIAL or $hasNEXT or $hasMINEXT or $hasMAXEXT"/>
  <xsl:variable name="hasLine2" select="$hasPCTINC or $hasFREELISTS or $hasFREELIST_GROUPS or $hasBUFFER_POOL"/>
  <xsl:if test="$STORAGE=1 and ($hasLine1 or $hasLine2)">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> STORAGE(</xsl:text>
   <xsl:call-template name="DoDeferredStgParam">
    <xsl:with-param name="ParamName">INITIAL</xsl:with-param>
    <xsl:with-param name="ParamVal" select="$DeferredStg/INITIAL_STG"/>
    <xsl:with-param name="testval" select="$hasINITIAL"/>
    <xsl:with-param name="mult" select="BLOCKSIZE"/>
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
   <xsl:call-template name="DoDeferredStgParam">
    <xsl:with-param name="ParamName">NEXT</xsl:with-param>
    <xsl:with-param name="ParamVal" select="$DeferredStg/NEXT_STG"/>
    <xsl:with-param name="testval" select="$hasNEXT"/>
    <xsl:with-param name="mult" select="BLOCKSIZE"/>
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
   <xsl:call-template name="DoDeferredStgParam">
    <xsl:with-param name="ParamName">MINEXTENTS</xsl:with-param>
    <xsl:with-param name="ParamVal" select="$DeferredStg/MINEXT_STG"/>
    <xsl:with-param name="testval" select="$hasMINEXT"/>
   </xsl:call-template>
   <xsl:call-template name="DoDeferredStgParam">
    <xsl:with-param name="ParamName">MAXEXTENTS</xsl:with-param>
    <xsl:with-param name="ParamVal" select="$DeferredStg/MAXEXT_STG"/>
    <xsl:with-param name="testval" select="$hasMAXEXT"/>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1 and $hasLine1 and $hasLine2">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:call-template name="DoDeferredStgParam">
    <xsl:with-param name="ParamName">PCTINCREASE</xsl:with-param>
    <xsl:with-param name="ParamVal" select="$DeferredStg/PCTINC_STG"/>
    <xsl:with-param name="testval" select="$hasPCTINC"/>
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
   <xsl:call-template name="DoDeferredStgParam">
    <xsl:with-param name="ParamName">FREELISTS</xsl:with-param>
    <xsl:with-param name="ParamVal" select="$DeferredStg/FRLINS_STG"/>
    <xsl:with-param name="testval" select="$hasFREELISTS"/>
   </xsl:call-template>
   <xsl:call-template name="DoDeferredStgParam">
    <xsl:with-param name="ParamName">FREELIST GROUPS</xsl:with-param>
    <xsl:with-param name="ParamVal" select="$DeferredStg/MAXINS_STG"/>
    <xsl:with-param name="testval" select="$hasFREELIST_GROUPS"/>
   </xsl:call-template>
   <xsl:if test="$hasBUFFER_POOL">
    <xsl:apply-templates select="$DeferredStg/BFP_STG"/>
   </xsl:if>
   <xsl:text>)</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoDeferredStgParam">
  <xsl:param name="ParamName" select="''"/>
  <xsl:param name="ParamVal" select="''"/>
  <xsl:param name="testval" select="''"/>
  <xsl:param name="mult">1</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: DoDeferredStgParam - Utility template to emit a single
  STORAGE param
Parameters:
  ParamName - name, e.g., INITIAL
  ParamVal - value if any
  testval - true if ParamVal is valid
  mult - factor to multiply ParamVal (e.g., INITIAL is stored as
         a number of blocks, so mult would be the blocksize)
  Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:if test="$testval">
   <xsl:text> </xsl:text>
   <xsl:value-of select="$ParamName"/>
   <xsl:text> </xsl:text>
   <xsl:call-template name="DoIniNext">
    <xsl:with-param name="Size" select="$ParamVal"/>
    <xsl:with-param name="BlkSize" select="$mult"/>
    <xsl:with-param name="Pctspace" select="$Pctspace"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
