<?xml version="1.0"?>
<!--
NAME
    kutrigc.xsl
DESCRIPTION
    Templates for common and utility functions used by both kustrigd.xsl
    and kuatrig.xsl
NOTE
    Because these templates may be applied to SXML difference documents,
    they must be aware of the @src and @value1 attributes.
MODIFIED        MM/DD/YY
    lbarton     06/02/08 - bug 6767780: view trigger on nested table col
    lbarton     01/02/07 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <xsl:template  name="CreTrigger">
  <!-- *******************************************************************
Template: CreTrigger
Current node: TRIGGER
  This template puts out
   - CREATE TRIGGER schema.name
******************************************************************** -->
  <xsl:text>  CREATE OR REPLACE TRIGGER </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="sxml:TRIGGER_TYPE"/>
  <!-- one of the following three will match -->
  <xsl:apply-templates select="sxml:DDL_EVENT[not(@src='1')]"/>
  <xsl:apply-templates select="sxml:DML_EVENT[not(@src='1')]"/>
  <xsl:apply-templates select="sxml:DATABASE_EVENT[not(@src='1')]"/>
  <!-- when_condition -->
  <xsl:if test="sxml:WHEN_CONDITION[not(@src='1')]">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> WHEN (</xsl:text>
   <xsl:value-of select="sxml:WHEN_CONDITION"/>
   <xsl:text>)</xsl:text>
  </xsl:if>
  <xsl:if test="sxml:PLSQL_BLOCK[not(@src='1')]">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> </xsl:text>
   <xsl:value-of select="sxml:PLSQL_BLOCK"/>
  </xsl:if>
  <xsl:if test="sxml:CALL_PROCEDURE[not(@src='1')]">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> CALL </xsl:text>
   <xsl:value-of select="sxml:CALL_PROCEDURE"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:TRIGGER_TYPE">
 <!-- *******************************************************************
Template: TRIGGER_TYPE - This template puts out one of
    BEFORE
    AFTER
    INSTEAD OF
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='BEFORE'"> BEFORE </xsl:when>
   <xsl:when test=".='AFTER'"> AFTER </xsl:when>
   <xsl:when test=".='INSTEAD_OF'"> INSTEAD OF </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:DATABASE_EVENT">
 <!-- *******************************************************************
Template: DATABASE_EVENT
******************************************************************** -->
  <xsl:apply-templates select="sxml:EVENT_LIST"/>
  <xsl:text> ON DATABASE</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:DDL_EVENT">
 <!-- *******************************************************************
Template: DDL_EVENT
******************************************************************** -->
  <xsl:apply-templates select="sxml:EVENT_LIST"/>
  <xsl:apply-templates select="sxml:DATABASE[not(@src='1')]"/>
  <xsl:apply-templates select="sxml:SCHEMA[not(@src='1')]"/>
 </xsl:template>
 <xsl:template match="sxml:DML_EVENT">
 <!-- *******************************************************************
Template: DML_EVENT
******************************************************************** -->
  <xsl:apply-templates select="sxml:EVENT_LIST"/>
  <xsl:text> ON </xsl:text>
  <xsl:apply-templates select="sxml:NESTED_TABLE_COLUMN[not(@src='1')]"/>
  <xsl:call-template name="TargetSchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:apply-templates select="sxml:REFERENCING"/>
 </xsl:template>
 <xsl:template match="sxml:EVENT_LIST">
 <!-- *******************************************************************
Template: EVENT_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:EVENT_LIST_ITEM[not(@src='1')]">
   <xsl:value-of select="sxml:EVENT"/>
   <xsl:apply-templates select="sxml:COL_LIST"/>
   <xsl:if test="position()!=last()"> OR </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:COL_LIST">
 <!-- *******************************************************************
Template: COL_LIST
******************************************************************** -->
  <xsl:text> OF </xsl:text>
  <xsl:for-each select="sxml:COL_LIST_ITEM[not(@src='1')]">
   <xsl:value-of select="sxml:NAME"/>
   <xsl:if test="position()!=last()">, </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:DATABASE">
 <!-- *******************************************************************
Template: DATABASE
******************************************************************** -->
  <xsl:text> ON DATABASE</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:SCHEMA">
 <!-- *******************************************************************
Template: SCHEMA
******************************************************************** -->
  <xsl:text> ON "</xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>".SCHEMA</xsl:text>
 </xsl:template>
 <xsl:template match="sxml:NESTED_TABLE_COLUMN">
 <!-- *******************************************************************
Template: NESTED_TABLE_COLUMN
******************************************************************** -->
  <xsl:text>NESTED TABLE </xsl:text>
  <xsl:value-of select="."/>
  <xsl:text> OF </xsl:text>
 </xsl:template>
 <xsl:template match="sxml:REFERENCING">
 <!-- *******************************************************************
Template: REFERENCING
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> REFERENCING </xsl:text>
  <xsl:if test="sxml:NEW_AS[not(@src='1')]">
   <xsl:text>NEW AS </xsl:text>
   <xsl:value-of select="sxml:NEW_AS"/>
   <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:if test="sxml:OLD_AS[not(@src='1')]">
   <xsl:text>OLD AS </xsl:text>
   <xsl:value-of select="sxml:OLD_AS"/>
   <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:if test="sxml:PARENT_AS[not(@src='1')]">
   <xsl:text>PARENT AS </xsl:text>
   <xsl:value-of select="sxml:PARENT_AS"/>
   <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:if test="sxml:FOR_EACH_ROW[not(@src='1')]">
   <xsl:text>FOR EACH ROW</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:DISABLE">
 <!-- *******************************************************************
Template: DISABLE
******************************************************************** -->
  <xsl:text>&#xa;</xsl:text>
  <xsl:text>  ALTER TRIGGER </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select=".."/>
  </xsl:call-template>
  <xsl:text> DISABLE</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
