<?xml version="1.0" encoding="utf-8"?>
<!--
 Copyright (c) 2007, 2008, Oracle and/or its affiliates.All rights reserved. 
NAME
    kustype.xsl
DESCRIPTION
    Convert mdapi TYPE_T document to TYPE_SPEC document (SXML)

MODIFIED        MM/DD/YY
    rapayne     10/30/08 - bug 7506545: fix CONSTRUCTOR function and make
                           parameter and element list optional.
    rapayne     10/08/08 - bug 7438241: fix RETURN clause and pls_type processing.
    rapayne     10/25/07 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kuscommc.xsl"/>
 <xsl:import href="kustbphy.xsl"/>
 <xsl:import href="kuspar.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="SPECIFICATION">1</xsl:param>
 <xsl:param name="BODY">1</xsl:param>
 <xsl:param name="PHYSICAL_PROPERTIES">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <xsl:param name="PARTITIONING">1</xsl:param>
 <xsl:param name="OID">0</xsl:param>
 <xsl:param name="PARSE_EXPRESSIONS">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="FULL_TYPE_T">
  <!-- *******************************************************************
Template: FULL_TYPE_T - top-level template for type objects.
******************************************************************** -->
  <xsl:if test="$SPECIFICATION=1">
   <xsl:apply-templates select="TYPE_T"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="TYPE_T">
  <!-- *******************************************************************
Template: TYPE_T - top-level template for type objects.
  This template puts out
   - the opening TYPE  element (with xmlns and version attributes)
   - SCHEMA and NAME elements
  then calls one of

******************************************************************** -->
  <xsl:element name="TYPE_SPEC">
   <!-- XMLSpy and the lpx XSL processor have different ways of
      generating the xmlns attribute for the top-level item.
      XMLSpy, citing http://www.w3.org/TR/xslt#creating-attributes,
      does it by inheriting the default target namespace from the stylesheet
      element, and ignoring any xsl:attribute whose name is"xmlns".
      The lpx XSL processor, which DBMS_METADATA uses, does
      the exact reverse. This stylesheet is coded to work in both environments.
      It's possible it may fail when run on other processors.
-->
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <!-- OID clause -->
   <xsl:if test="$OID=1">
    <xsl:element name="OID">
     <xsl:value-of select="SCHEMA_OBJ/OID"/>
    </xsl:element>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="(PROPERTIES mod 512)>=256">
     <xsl:element name="INCOMPLETE"/>
    </xsl:when>
    <xsl:when test="TYPE_NUM = 108">
     <xsl:call-template name="ObjectType">
  </xsl:call-template>
    </xsl:when>
    <xsl:when test="TYPE_NUM = 122">
     <xsl:choose>
      <xsl:when test="PROPERTIES mod 65536 >= 32768">
       <xsl:call-template name="VarrayType">
        <xsl:with-param name="VNode" select="COLLECTION"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="NestedTableType">
        <xsl:with-param name="VNode" select="COLLECTION"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
 <xsl:template name="ObjectType">
  <!-- *******************************************************************
Template: OBJECT_SXML - process type objects.
******************************************************************** -->
  <xsl:element name="OBJECT">
   <xsl:if test="PROPERTIES mod 32768 >= 16384">
    <xsl:element name="AUTHID_CURRENT_USER"/>
   </xsl:if>
   <xsl:if test="SUPERTYPE_OBJ">
    <xsl:element name="UNDER">
     <xsl:apply-templates select="SUPERTYPE_OBJ"/>
    </xsl:element>
   </xsl:if>
   <!-- Process optional SQLJ _OBJECT_TYPE clause -->
   <xsl:if test="EXTERNNAME">
    <xsl:element name="SQLJ_OBJECT_TYPE">
     <xsl:element name="NAME">
      <xsl:value-of select="EXTERNNAME"/>
     </xsl:element>
     <xsl:choose>
      <xsl:when test="EXTERNTYPE = 1">
       <xsl:element name="SQLDATA"/>
      </xsl:when>
      <xsl:when test="EXTERNTYPE = 2">
       <xsl:element name="CUSTOMDATUM"/>
      </xsl:when>
      <xsl:when test="EXTERNTYPE = 5">
       <xsl:element name="ORADATA"/>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:if>
   <xsl:if test="ATTR_LIST/ATTR_LIST_ITEM[XFLAGS='0']">
    <xsl:call-template name="AttributeList">
     <xsl:with-param name="ListNode" select="ATTR_LIST"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="METHOD_LIST/METHOD_LIST_ITEM">
    <xsl:call-template name="ElementList">
     <xsl:with-param name="ListNode" select="METHOD_LIST"/>
    </xsl:call-template>
   </xsl:if>
   <!-- process end properties for object types (i.e.,  NOT FINAL and NOT INSTANTIABLE) -->
   <xsl:if test="(PROPERTIES mod 16)>=8">
    <xsl:element name="NOT_FINAL"/>
   </xsl:if>
   <xsl:if test="PROPERTIES mod 131072 >= 65536">
    <xsl:element name="NOT_INSTANTIABLE"/>
   </xsl:if>
  </xsl:element>
 </xsl:template>
 <xsl:template name="VarrayType">
  <xsl:param name="VNode" select="''"/>
  <!-- *******************************************************************
Template: VarrayType - process VARRAY types
Parameters:
     VNode  - <COLLECTION>
******************************************************************** -->
  <xsl:element name="VARRAY">
   <xsl:element name="LIMIT">
    <xsl:value-of select="$VNode/UPPER_BOUND"/>
   </xsl:element>
   <xsl:apply-templates select="$VNode/TYPEMD/TYPE_NUM">
    <xsl:with-param name="ParentNode" select="$VNode"/>
   </xsl:apply-templates>
  </xsl:element>
 </xsl:template>
 <xsl:template name="NestedTableType">
  <xsl:param name="VNode" select="''"/>
  <!-- *******************************************************************
Template: NestedTableType - process Nested Table  types
Parameters:
     VNode  - <COLLECTION>
******************************************************************** -->
  <xsl:element name="NESTED_TABLE">
   <xsl:apply-templates select="$VNode/TYPEMD/TYPE_NUM">
    <xsl:with-param name="ParentNode" select="$VNode"/>
   </xsl:apply-templates>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AttributeList">
  <xsl:param name="ListNode" select="''"/>
  <!-- *******************************************************************
Template: AttributeList- process type attribute list
Parameters:
    ListNode  - <ATTR_LIST>
******************************************************************** -->
  <xsl:element name="ATTRIBUTE_LIST">
   <xsl:for-each select="$ListNode/ATTR_LIST_ITEM">
    <!-- We only are going to process local attribute and NOT ones
that have been inherited from a supertype. We must retain the characteristic of a subtype
-->
    <xsl:if test="XFLAGS = '0'">
     <xsl:call-template name="DoAttribute">
      <xsl:with-param name="AttrNode" select="."/>
     </xsl:call-template>
    </xsl:if>
   </xsl:for-each>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DoAttribute">
  <xsl:param name="AttrNode" select="''"/>
  <!-- *******************************************************************
Template: DoAttribute- process next type attribute
Parameters:
    AttrNode  - <ATTR_LIST_ITEM>
******************************************************************** -->
  <xsl:element name="ATTRIBUTE_LIST_ITEM">
   <xsl:element name="NAME">
    <xsl:value-of select="$AttrNode/NAME"/>
   </xsl:element>
   <xsl:apply-templates select="$AttrNode/TYPEMD/TYPE_NUM">
    <xsl:with-param name="ParentNode" select="$AttrNode"/>
   </xsl:apply-templates>
   <xsl:if test="($AttrNode/EXTERNNAME)">
    <xsl:element name="EXTERNAL_NAME">
     <xsl:value-of select="$AttrNode/EXTERNNAME"/>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:template>
 <xsl:template name="ElementList">
  <xsl:param name="ListNode" select="''"/>
  <!-- *******************************************************************
Template: ElementList- process type Method list
Parameters:
    ListNode  - <METHOD_LIST>
******************************************************************** -->
  <xsl:element name="ELEMENT_LIST">
   <xsl:for-each select="$ListNode/METHOD_LIST_ITEM">
    <xsl:call-template name="DoElement">
     <xsl:with-param name="ElementNode" select="."/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DoElement">
  <xsl:param name="ElementNode" select="''"/>
  <!-- *******************************************************************
Template: DoElement- process next ELEMENT
Parameters:
    ElementNode  - <METHOD_LIST_ITEM>
******************************************************************** -->
  <xsl:element name="ELEMENT_LIST_ITEM">
   <!-- Generate inheritance flag elements -->
   <xsl:if test="8>($ElementNode/PROPERTIES mod 16)">
    <xsl:element name="FINAL"/>
   </xsl:if>
   <xsl:if test="$ElementNode/PROPERTIES mod 131072 >= 65536">
    <xsl:element name="NOT_INSTANTIABLE"/>
   </xsl:if>
   <xsl:if test="$ElementNode/PROPERTIES mod 262144 >= 131072">
    <xsl:element name="OVERRIDING"/>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="$ElementNode/PROPERTIES mod  1024>= 512">
     <xsl:call-template name="DoProgram">
      <xsl:with-param name="MethodNode" select="$ElementNode"/>
      <xsl:with-param name="ProgramType">FUNCTION</xsl:with-param>
      <xsl:with-param name="ProgramSubtype">MAP_MEMBER</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$ElementNode/PROPERTIES mod  4096>= 2048">
     <xsl:call-template name="DoProgram">
      <xsl:with-param name="MethodNode" select="$ElementNode"/>
      <xsl:with-param name="ProgramType">FUNCTION</xsl:with-param>
      <xsl:with-param name="ProgramSubtype">ORDER_MEMBER</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$ElementNode/PROPERTIES mod  64>= 32">
     <xsl:call-template name="DoConstructor">
      <xsl:with-param name="MethodNode" select="$ElementNode"/>
     </xsl:call-template>
    </xsl:when>
    <!-- NOTE: SXML does not support the deprecated pragma_clause. -->
    <xsl:otherwise>
     <!-- Otherwise process as a subprogram_spec:
           MEMBER/STATIC procedure or function
-->
     <xsl:call-template name="DoProgram">
      <xsl:with-param name="MethodNode" select="$ElementNode"/>
      <xsl:with-param name="ProgramType">
       <xsl:choose>
        <xsl:when test="$ElementNode/PROPERTIES mod 2048 >= 1024">PROCEDURE</xsl:when>
        <xsl:otherwise>FUNCTION</xsl:otherwise>
       </xsl:choose>
      </xsl:with-param>
      <xsl:with-param name="ProgramSubtype">
       <xsl:choose>
        <xsl:when test="($ElementNode/PROPERTIES mod 16 >= 8) and
                          (not($ElementNode/PROPERTIES mod 512>=256))">STATIC</xsl:when>
        <xsl:otherwise>MEMBER</xsl:otherwise>
       </xsl:choose>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DoProgram">
  <xsl:param name="MethodNode" select="''"/>
  <xsl:param name="ProgramType" select="''"/>
  <xsl:param name="ProgramSubtype" select="''"/>
  <!-- *******************************************************************
Template: DoProgram- process current FUNCTION/PROCEDURE
Parameters:
    MethodNode  - <METHOD_LIST_ITEM>
ProgramType - FUNCTION or PROCEDURE
ProgramSubtype - STATIC or MEMBER
******************************************************************** -->
  <xsl:element name="{$ProgramSubtype}">
   <xsl:element name="{$ProgramType}">
    <xsl:element name="NAME">
     <xsl:value-of select="$MethodNode/NAME"/>
    </xsl:element>
    <xsl:if test="$MethodNode/PARAMETERS_NUM > 1 or
                 ($MethodNode/PARAMETERS_NUM = 1 and
                  not($MethodNode/ARGUMENT_LIST/ARGUMENT_LIST_ITEM[last()]/ARGUMENT = 'SELF'))">
     <xsl:call-template name="MethodParamList">
      <xsl:with-param name="ArgList" select="$MethodNode/ARGUMENT_LIST"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="$ProgramType = 'FUNCTION'">
     <xsl:call-template name="DoFunctionReturn">
      <xsl:with-param name="MethodNode" select="$MethodNode"/>
      <xsl:with-param name="ReturnNode" select="ARGUMENT_LIST/ARGUMENT_LIST_ITEM[POSITION_NUM=0]"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="MethodParamList">
  <xsl:param name="ArgList" select="''"/>
  <!-- *******************************************************************
Template: MethodParamList - this template loops through and process the entire parameter list for the specified method.
Parameters:
    ArgList  - ARGUMENT_LIST -******************************************************************** -->
  <xsl:element name="PARAMETER_LIST">
   <xsl:for-each select="$ArgList/ARGUMENT_LIST_ITEM[POSITION_NUM!=0]">
    <xsl:sort select="POSITION_NUM" data-type="number"/>
    <xsl:if test="./ARGUMENT!='SELF'">
     <xsl:element name="PARAMETER_LIST_ITEM">
      <xsl:element name="NAME">
       <xsl:value-of select="ARGUMENT"/>
      </xsl:element>
      <xsl:call-template name="DoParameterDefinition">
       <xsl:with-param name="ArgNode" select="."/>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
   </xsl:for-each>
  </xsl:element>
 </xsl:template>
 <xsl:template name="PLSDatatype">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: PLSDatatype
Parameters:
    ParentNode  - <ARGUMENT_LIST_ITEM>
******************************************************************** -->
  <xsl:element name="DATATYPE">
   <xsl:choose>
    <xsl:when test="$ParentNode/PLS_TYPE">
     <xsl:value-of select="$ParentNode/PLS_TYPE"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>UDT</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
  <xsl:if test="$ParentNode/TYPE_NAME">
   <xsl:element name="TYPE_PROPERTIES">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$ParentNode/TYPE_OWNER"/>
    </xsl:element>
    <xsl:element name="NAME">
     <xsl:value-of select="$ParentNode/TYPE_NAME"/>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoConstructor">
  <xsl:param name="MethodNode" select="''"/>
  <!-- *******************************************************************
Template: DoConstructor
Parameters:
    MethodNode  - <METHOD_LIST_ITEM>
******************************************************************** -->
  <xsl:element name="CONSTRUCTOR_FUNCTION">
   <xsl:call-template name="PLSDatatype">
    <xsl:with-param name="ParentNode" select="$MethodNode"/>
   </xsl:call-template>
       <xsl:if test="$MethodNode/PARAMETERS_NUM > 1 or
                 ($MethodNode/PARAMETERS_NUM = 1 and
                  not($MethodNode/ARGUMENT_LIST/ARGUMENT_LIST_ITEM[last()]/ARGUMENT = 'SELF'))">
    <xsl:call-template name="MethodParamList">
     <xsl:with-param name="ArgList" select="$MethodNode/ARGUMENT_LIST"/>
    </xsl:call-template>
   </xsl:if>
   <!-- Constructors must return self -->
   <xsl:element name="RETURN_SELF"/>
   <xsl:if test="$MethodNode/PROCJAVA or $MethodNode/C">
    <xsl:call-template name="DoCallSpec">
     <xsl:with-param name="MethodNode" select="$MethodNode"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DoFunctionReturn">
  <xsl:param name="MethodNode" select="''"/>
  <xsl:param name="ReturnNode" select="''"/>
  <!-- *******************************************************************
Template: DoFunctionReturn - this template processes the RETURN clause for function methods
Parameters:
    MethodNode  - <METHOD_LIST_ITEM> 
    ReturnNode   - <ARGUMENT_LIST_ITEM> 
-******************************************************************** -->
  <xsl:element name="RETURN">
   <xsl:call-template name="PLSDatatype">
    <xsl:with-param name="ParentNode" select="$ReturnNode"/>
   </xsl:call-template>
  </xsl:element>
  <!-- Generate CALL_SPEC if appropriate -->
  <xsl:if test="$MethodNode/PROCJAVA">
   <xsl:call-template name="DoCallSpec">
    <xsl:with-param name="MethodNode" select="$MethodNode"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoCallSpec">
  <xsl:param name="MethodNode" select="''"/>
  <!-- *******************************************************************
Template: DoCallSpec - this template processes the CALL_SPEC clause for function methods
Parameters:
    MethodNode  - <METHOD_ITEM_LIST> 
-******************************************************************** -->
  <xsl:element name="CALL_SPEC">
   <xsl:element name="LANGUAGE">
    <xsl:variable name="LangType">
     <xsl:choose>
      <xsl:when test="$MethodNode/PROCJAVA">JAVA</xsl:when>
      <xsl:when test="$MethodNode/PROCCC">C</xsl:when>
      <xsl:otherwise>UNKNOWN</xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:element name="{$LangType}">
         </xsl:element>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:choose>
     <xsl:when test="$MethodNode/PROCJAVA">
      <xsl:value-of select="$MethodNode/PROCJAVA/USERSIGNATURE"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="$MethodNode/PROCEDUREINFO/PROCEDURENAME"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <!-- still need to complete PROCEDURE info: LIBRARY, WITH_CONTEXT, PARAMETER_LIST-->
  </xsl:element>
 </xsl:template>
 <xsl:template name="DoParameterDefinition">
  <xsl:param name="ArgNode" select="''"/>
  <!-- *******************************************************************
Template: DoParameterDefinition - this template processes the Method parameter definition:
     <NAME>
        [OUT] [IN_OUT]
        [NO_COPY]
       <DATATYPE>
          [TYPE_PROPERTIES] 
     This template is in lieu of applying TYPE_NUM because argument$ stores things a little differently.
Parameters:
    ArgNode  - <ARGUMENTLIST_ITEM> 
-******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ArgNode/IN_OUT = 1">
    <xsl:element name="OUT"/>
   </xsl:when>
   <xsl:when test="$ArgNode/IN_OUT = 2">
    <xsl:element name="IN_OUT"/>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="$ArgNode/NOCOPY">
   <xsl:element name="NOCOPY"/>
  </xsl:if>
  <!-- generate DATATYPE node: -->
  <xsl:element name="DATATYPE">
   <!-- The argument's datatype will be in one of 2 places:
         PLS_TYPE   - for Scalar types
         TYPE_OWNER/NAME- for UDTs
-->
   <xsl:choose>
    <xsl:when test="$ArgNode/PLS_TYPE">
     <xsl:value-of select="PLS_TYPE"/>
    </xsl:when>
    <xsl:otherwise>UDT</xsl:otherwise>
   </xsl:choose>
  </xsl:element>
  <xsl:if test="$ArgNode/TYPE_NAME">
   <xsl:element name="TYPE_PROPERTIES">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="$ArgNode/TYPE_OWNER"/>
    </xsl:element>
    <xsl:element name="NAME">
     <xsl:value-of select="$ArgNode/TYPE_NAME"/>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template match="TYPE_BODY_T">
  <!-- *******************************************************************
Template: TYPE_BODY_T - top-level template for type body objects.
  This template puts out
   - the opening TYPE_BODY  element (with xmlns and version attributes)
   - SCHEMA and NAME elements
  Then simply dumps the PLSQL_BODY from source$.
******************************************************************** -->
  <xsl:element name="TYPE_BODY">
   <!-- XMLSpy and the lpx XSL processor have different ways of
      generating the xmlns attribute for the top-level item.
      XMLSpy, citing http://www.w3.org/TR/xslt#creating-attributes,
      does it by inheriting the default target namespace from the stylesheet
      element, and ignoring any xsl:attribute whose name is"xmlns".
      The lpx XSL processor, which DBMS_METADATA uses, does
      the exact reverse. This stylesheet is coded to work in both environments.
      It's possible it may fail when run on other processors.
-->
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <xsl:element name="PLSQL_BLOCK">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:for-each select="SOURCE_LINES/SOURCE_LINES_ITEM">
     <xsl:if test="./LINE != 1">
      <xsl:value-of select="./SOURCE"/>
     </xsl:if>
    </xsl:for-each>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
