<?xml version="1.0"?>
<!--

 Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kusviewd.xsl
DESCRIPTION
    Convert VIEW (SXML) document to creation DDL.

MODIFIED        MM/DD/YY
    rapayne    05/04/09 - Add READ ONLY for PARSED_SUBQUERY
    rapayne    12/09/08 - add COMMENTS support from CM code stream.
    lbarton    01/10/07 - PARSED_QUBQUERY
    akruglik   09/07/06 - Column Map Views got rechristened as Editioning Views
    rapayne    06/07/06 - add support for editioning views.
    lbarton    03/27/06 - bug 5118027: CONSTRAINTS and REF_CONSTRAINTS params 
                          for SXMLDDL 
    sdavidso   11/02/05 - fix inconsistent stylesheet format 
    htseng     09/08/05 - separate schemaname and name in under_clause 
    lbarton    08/10/05 - lbarton_mddiff
    htseng     05/16/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kuscnstd.xsl"/>
 <xsl:import href="kusparsd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="FORCE">1</xsl:param>
 <xsl:param name="REPLACE">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <!-- Params for genetrating comments ddl (Change Mgr) -->
 <xsl:param name="COMMENTS">0</xsl:param>
 <!-- *******************************************************************
Template: top-level template for VIEW.
******************************************************************** -->
 <xsl:template match="sxml:VIEW">
  <xsl:text>CREATE</xsl:text>
  <xsl:if test="$REPLACE=1">
   <xsl:text> OR REPLACE</xsl:text>
  </xsl:if>
  <xsl:if test="$FORCE=1"> FORCE</xsl:if>
  <xsl:if test="sxml:EDITIONING_VIEW">
    <xsl:text> EDITIONING </xsl:text>
  </xsl:if>
  <xsl:text> VIEW </xsl:text>
  <xsl:text>"</xsl:text>
  <xsl:value-of select="sxml:SCHEMA"/>
  <xsl:text>"."</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>" </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="sxml:COL_LIST">
    <!-- relational_view_clause -->
    <xsl:text>( "</xsl:text>
    <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
     <xsl:value-of select="sxml:NAME"/>
     <xsl:if test="position()!=last()">", "</xsl:if>
    </xsl:for-each>
    <xsl:text>"</xsl:text>
    <xsl:if test="sxml:CHECK_CONSTRAINT_LIST or
                  sxml:PRIMARY_KEY_CONSTRAINT_LIST or
                  sxml:UNIQUE_KEY_CONSTRAINT_LIST or
                  sxml:FOREIGN_KEY_CONSTRAINT_LIST or
                  sxml:SCOPE_CONSTRAINT_LIST or
                  sxml:ROWID_CONSTRAINT_LIST">
     <xsl:text>, </xsl:text>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:call-template name="Constraints">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <xsl:text> ) </xsl:text>
   </xsl:when>
   <xsl:when test="sxml:OF_TYPE">
    <!-- object_view_clause -->
    <xsl:apply-templates select="sxml:OF_TYPE"/>
    <!-- constraints -->
    <xsl:call-template name="Constraints">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
   </xsl:when>
   <!-- XML_type_view_clause -->
   <xsl:when test="sxml:OF_XMLTYPE">
    <xsl:apply-templates select="sxml:OF_XMLTYPE"/>
   </xsl:when>
  </xsl:choose>
  <!-- SUBQUERY or PARSED_SUBQUERY -->
  <xsl:apply-templates select="sxml:SUBQUERY"/>
  <xsl:apply-templates select="sxml:PARSED_SUBQUERY"/>
  <!-- READ_ONLY -->
  <xsl:if test="sxml:READ_ONLY and sxml:PARSED_SUBQUERY">
    <xsl:text> WITH READ ONLY </xsl:text>
  </xsl:if>
  <!-- COMMENTS -->
  <xsl:if test="$COMMENTS=1 and sxml:COMMENTS">
   <xsl:call-template name="CommentsOn">
    <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:SUBQUERY">
 <!-- *******************************************************************
Template: SUBQUERY
******************************************************************** -->
   <xsl:text> AS </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:value-of select="."/>
 </xsl:template>
 <xsl:template match="sxml:PARSED_SUBQUERY">
 <!-- *******************************************************************
Template: PARSED_SUBQUERY
******************************************************************** -->
   <xsl:text> AS </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:apply-templates select="*[1]">
    <xsl:with-param name="InnerQuery">0</xsl:with-param>
   </xsl:apply-templates>
 </xsl:template>
 <!-- *******************************************************************
Template: OF_TYPE
******************************************************************** -->
 <xsl:template match="sxml:OF_TYPE">
  <xsl:text> OF </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:apply-templates select="sxml:WITH_OBJECT_IDENTIFIER"/>
  <xsl:apply-templates select="sxml:UNDER"/>
 </xsl:template>
 <!-- *******************************************************************
Template: WITH_OBJECT_IDENTIFIER
******************************************************************** -->
 <xsl:template match="sxml:WITH_OBJECT_IDENTIFIER">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> WITH OBJECT IDENTIFIER (</xsl:text>
  <xsl:for-each select="sxml:ATTRIBUTE_LIST/sxml:ATTRIBUTE_LIST_ITEM">
   <xsl:value-of select="sxml:NAME"/>
   <xsl:if test="position()!=last()">,</xsl:if>
  </xsl:for-each>
  <xsl:text>) </xsl:text>
 </xsl:template>
 <!-- *******************************************************************
Template: UNDER
******************************************************************** -->
 <xsl:template match="sxml:UNDER">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> UNDER </xsl:text>
  <xsl:if test="sxml:SCHEMA">
   <xsl:value-of select="sxml:SCHEMA"/>
   <xsl:text>.</xsl:text>
  </xsl:if>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text> </xsl:text>
 </xsl:template>
 <!-- *******************************************************************
Template: OF_XMLTYPE
******************************************************************** -->
 <xsl:template match="sxml:OF_XMLTYPE">
  <xsl:text> OF XMLTYPE </xsl:text>
  <xsl:apply-templates select="sxml:XMLSCHEMA"/>
  <xsl:apply-templates select="sxml:ELEMENT"/>
  <xsl:apply-templates select="sxml:ID"/>
  <xsl:apply-templates select="sxml:WITH_OBJECT_IDENTIFIER"/>
 </xsl:template>
</xsl:stylesheet>
