Rem
Rem $Header: ordisysc.sql 23-mar-2006.11:20:33 lburgess Exp $
Rem
Rem ordisysc.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ordisysc.sql - Create schema script for ORD components
Rem
Rem    DESCRIPTION
Rem      Creates the schemas needed to run Oracle Multimedia and Spatial.   
Rem      
Rem      Run this script like this:
Rem        ordisysc.sql <ORDIM_TABLESPACE> <SPATIAL_TABLESPACE> 
Rem
Rem    NOTES
Rem      Must be run connected as SYSDBA 
Rem      

define ordim_tbs    = &1
define spatial_tbs  = &2

-- 
-- Create and lock ORDSYS 
--

create user ordsys identified by ordsys default tablespace &ordim_tbs;
alter user ORDSYS account lock password expire;

--
-- Create and lock ORDData
-- ORDData contains the DICOM repository
--
create user orddata identified by orddata default tablespace &ordim_tbs;
alter user ORDDATA account lock password expire;

-- Create and lock ORDPLUGINS 
--

create user ordplugins identified by ordplugins default tablespace &ordim_tbs;
alter user ORDPLUGINS account lock password expire;

--
-- Create and lock SI_INFORMTN_SCHEMA
--

create user SI_INFORMTN_SCHEMA identified by si_informtn_schema default
   tablespace &ordim_tbs;
alter user SI_INFORMTN_SCHEMA account lock password expire;


--
-- Create and lock MDSYS
--

create user MDSYS identified by mdsys default tablespace &spatial_tbs;
alter user MDSYS account lock password expire;
