#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle and/or its affiliates. All rights reserved.
#
#  $Id:oracle_sage_config.pl 
#
#
# NAME  
#   oracle_sage_celldisk_metrics.pl
#
# DESC 
#
# This script gets all the Cell Disk metrics of the CELL.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 09/18/08 - 
#    spalapu 09/18/08 - fix latency metrics from microsecs to millisecs. Divide
#                       by 1000)
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/27/08 - 
#    spalapu 08/27/08 - replace sagemonitor with cellmonitor
#    spalapu 08/26/08 - 
#    spalapu 08/26/08 - removed sage from plug-in and added exadata. Also,
#                       fixed realm reports to remove targer_guid from realm
#                       reports. Creating new files from oracle_sage_cell
#    spalapu 07/17/08 - 
#    spalapu 07/17/08 - fix conversion of collectiontime to secs
#    loliu   06/17/08 - Bug 7172818: do not need to convert throughput to MB
#    spalapu 05/23/08 - Add osstimestamp for celldisk metrics
#    spalapu 05/01/08 - Change cumulative value to Cumulative
#    spalapu 04/25/08 - 
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - 
#    spalapu 03/17/08 - 
#    spalapu 03/13/08 - change object_type to objectType
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
# 

use XML::Parser;
use Class::Struct;
require emx::oracle_cell::oracle_cell_common;

our %celldisks;  # Hash of celldisks

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list metriccurrent where objectType=".'\"CELLDISK\"'."'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
my $myinf;
my $read_throughput;
my $write_throughput;
my $read_reqs;
my $write_reqs;
$parser->parse( $xmlout);

       foreach $celldisk (keys %celldisks)
       {
          $read_throughput=0;
          $write_throughput=0;
          $read_reqs=0;
          $write_reqs=0;
          $read_throughput =$celldisks{$celldisk}{CD_IO_BY_R_LG} + $celldisks{$celldisk}{CD_IO_BY_R_SM};
          $write_throughput=$celldisks{$celldisk}{CD_IO_BY_W_LG} + $celldisks{$celldisk}{CD_IO_BY_W_SM};
          $read_reqs=$celldisks{$celldisk}{CD_IO_RQ_R_LG} + $celldisks{$celldisk}{CD_IO_RQ_R_SM};
          $write_reqs=$celldisks{$celldisk}{CD_IO_RQ_W_LG} + $celldisks{$celldisk}{CD_IO_RQ_W_SM};
#Since the latency times are in microsecs it is required to convert it into millisecs.
          $celldisks{$celldisk}{CD_IO_TM_R_SM} =  $celldisks{$celldisk}{CD_IO_TM_R_SM}/1000;
          $celldisks{$celldisk}{CD_IO_TM_R_LG} =  $celldisks{$celldisk}{CD_IO_TM_R_LG}/1000;
          $celldisks{$celldisk}{CD_IO_TM_W_SM} =  $celldisks{$celldisk}{CD_IO_TM_W_SM}/1000;
          $celldisks{$celldisk}{CD_IO_TM_W_LG} =  $celldisks{$celldisk}{CD_IO_TM_W_LG}/1000;
          print "em_result=".$celldisks{$celldisk}{name}."|".$cellname."|".$realmname."|".$osstimestamp."|".$read_throughput."|".$celldisks{$celldisk}{CD_IO_BY_R_SM_time}."|".$write_throughput."|".$celldisks{$celldisk}{CD_IO_BY_W_SM_time}."|".$read_reqs."|".$celldisks{$celldisk}{CD_IO_RQ_R_SM_time}."|".$write_reqs."|".$celldisks{$celldisk}{CD_IO_RQ_W_SM_time}."|".$celldisks{$celldisk}{CD_IO_RQ_R_SM}."|".$celldisks{$celldisk}{CD_IO_TM_R_SM}."|".$celldisks{$celldisk}{CD_IO_RQ_W_SM}."|".$celldisks{$celldisk}{CD_IO_TM_W_SM}."|".$celldisks{$celldisk}{CD_IO_RQ_R_LG}."|".$celldisks{$celldisk}{CD_IO_TM_R_LG}."|".$celldisks{$celldisk}{CD_IO_RQ_W_LG}."|".$celldisks{$celldisk}{CD_IO_TM_W_LG}."|"."\n";
       }

#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    $myinf="";
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
         $osstimestamp = $attrs{ossStartTimestamp};
      }
    }
    elsif ($element eq "cli-output")
    {
       $myinf="cli-output";
    }
    elsif ($element eq "name")
    {
       $myinf="name";
    }
    elsif ($element eq "metricType")
    {
       $myinf="metric_type";
    }
    elsif ($element eq "metricValue")
    {
       $myinf="metric_value";
    }
    elsif ($element eq "collectionTime")
    {
       $myinf="collection_time";
    }
    elsif ($element eq "metricObjectName")
    {
       $myinf="object_name";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "metric")
    {
      if ($realmname eq "") {
        $realmname="NONE";
      }
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "name" )
{
  $name=$name.$data;
}
elsif ($myinf eq "metric_type" )
{
  $metric_type=$metric_type.$data;
}
elsif ($myinf eq "metric_value" )
{
  $metric_value=$metric_value.$data;
  if ($metric_type eq "Cumulative")
  {
     $collection_time = $collection_time/1000;
     $celldisks{$object_name}{name} = $object_name;
     $celldisks{$object_name}{$name} = $metric_value;
     $celldisks{$object_name}{$name."_time"} = $collection_time;
  }
  $name="";
  $metric_type="";
  $metric_value="";
  $collection_time="";
  $object_name="";

}
elsif ($myinf eq "collection_time" )
{
  #convert to secs from millsecs
  $data= $data; 
  $collection_time=$collection_time.$data;
}
elsif ($myinf eq "object_name" )
{
  $object_name=$object_name.$data;

}
}
}
