#
# Copyright (c) 2001, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#  $Id:oracle_sage_common.pl 
#
#
# NAME  
#   oracle_sage_common.pl
#
# DESC 
#
# This script gets all the static configuration of the Symmetrix.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 08/04/09 - Add ping command for AIX
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/26/08 - 
#    spalapu 08/26/08 - removed sage from plug-in and added exadata. Also,
#                       fixed realm reports to remove targer_guid from realm
#                       reports. Creating new files from oracle_sage_cell
#    spalapu 05/01/08 - Move common code from *metrics.pl to here
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - remove ipaddr4
#    spalapu 03/17/08 - 
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
# 
use strict;

my $ipaddr;
my $numPackets;
my $osType;
my $maxTtl;

sub doPing {
my ($ipaddress1,$ipaddress2, $ipaddress3) = @_;
$ipaddr="";
if (execPing($ipaddress1) == 0) {
  $ipaddr=$ipaddress1;
}
elsif (execPing($ipaddress2) == 0) {
  $ipaddr=$ipaddress2;
}
elsif (execPing($ipaddress3) == 0) {
  $ipaddr=$ipaddress3;
}
return $ipaddr;
}

sub execPing
{
  my ($target) = @_;

 $osType = get_osType();
 $numPackets=2;
 $maxTtl=10;
  my $r;
  
  if ($osType eq "SOL")
  { 
      $ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin";
      if(!($r = `ping -s -t $maxTtl $target 64 $numPackets`)) 
      { 
  	return 1;
      }
  } elsif ($osType eq "LNX") {
      if(!($r = `/bin/ping $target -s 64 -c $numPackets -t $maxTtl 2>/dev/null`)) 
      {
        return 1;
      }
  } elsif ($osType eq "AIX") {
#      if(!($r = `ping $target -s 64 -c $numPackets -T $maxTtl 2>/dev/null`)) 
      if(!($r = `/usr/sbin/ping -c $numPackets -T $maxTtl $target 2>/dev/null`)) 
      {
        return 1;
      }
  } else {
      $ENV{PATH} = "/usr/bin:/usr/sbin";
      if(!($r = `ping -t $maxTtl $target 64 $numPackets`)) 
      {
  	return 1;
      }
  }				 
 return 0; 
}

sub get_osType
{
    if (( $^O eq "Windows_NT") ||
	( $^O eq "MSWin32")) {
	return "WIN";
    }

    my $os = `uname -s`;
    my $ver = `uname -r`;
    chomp ($os);

    if ( $os eq "SunOS" ) {
        if ( chomp($ver) !~ /^4./ ) {
            return "SOL";
        }
    } elsif ( $os eq "HP-UX" ) {
        return "HP";
    } elsif ( $os eq "Linux" ) {
        return "LNX";
    } elsif ( $os eq "AIX" ) {
        return "AIX";
    } elsif ( $os eq "OSF1" ) {
        return "OSF1";
    } elsif ( $os eq "Darwin" ) {
        return "MAC OS X";
    } else {
        # Unsupported Operating System
        return -1;
    }
}

#public static final long MEGA = 1048576;    // 2 ** 20;
#    public static final long GIGA = 1073741824; // 2 ** 30;

sub get_size_in_bytes
{
  my ($sizestr) = @_;
  my $mpos;
  my $gpos;
  my $size;
 
  if ($sizestr =~ m/\s* */) {
    $size="";
  }

  $mpos = index($sizestr,"M");
  if ($mpos != -1 ) {
    $size = substr($sizestr,0,$mpos);
    $size = $size*1048576;
  } else {
    $gpos = index($sizestr,"G");
    if ($gpos != -1 ) {
      $size = substr($sizestr,0,$gpos);
      $size = $size*1073741824;
    } 
    else {
      $size=$sizestr;
    }
  }
  $size = sprintf("%d",$size);
  return $size;
}

sub get_size_in_mb
{
  my ($sizestr) = @_;
  my $mpos;
  my $gpos;
  my $size;

  if ($sizestr !~ m/[0-9]+M?G?/) {
    return "";
  }

  $mpos = index($sizestr,"M");
  if ($mpos != -1 ) {
    $size = substr($sizestr,0,$mpos);
  } else {
    $gpos = index($sizestr,"G");
    if ($gpos != -1 ) {
      $size = substr($sizestr,0,$gpos);
      $size = $size*1024;
    } 
    else {
      $size=$sizestr/1048576;
    }
  }
  $size = sprintf("%d",$size);
  return $size;
}

sub get_size_in_gb
{
  my ($sizestr) = @_;
  my $mpos;
  my $gpos;
  my $size;

  if ($sizestr !~ m/[0-9]+M?G?/) {
    return "";
  }

  $mpos = index($sizestr,"G");
  if ($mpos != -1 ) {
    $size = substr($sizestr,0,$mpos);
  } else {
    $gpos = index($sizestr,"M");
    if ($gpos != -1 ) {
      $size = substr($sizestr,0,$gpos);
      $size = $size/1024;
    } 
    else {
      $size=$sizestr/1073741824;
    }
  }
  $size = sprintf("%d",$size);
  return $size;
}
1;
