#!/usr/bin/perl

#
# Copyright (c) 2001, 2009, Oracle and/or its affiliates.All rights reserved. 
#
#  $Id:oracle_sage_config.pl 
#
#
# NAME  
#   oracle_sage_config.pl
#
# DESC 
#
# This script gets all the static configuration of the Oracle Sage Cell.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 03/04/09 - remove bmcconfigured
#    spalapu 09/11/08 - 
#    spalapu 09/11/08 - remove whitespace for snmpsubscriber to be retrieved
#                       properly
#    spalapu 08/29/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/27/08 - 
#    spalapu 08/27/08 - replace sagemonitor with cellmonitor
#    spalapu 08/26/08 - 
#    spalapu 08/26/08 - removed sage from plug-in and added exadata. Also,
#                       fixed realm reports to remove targer_guid from realm
#                       reports. Creating new files from oracle_sage_cell
#    loliu   06/18/08 - Bug 7172844: added offload efficiency to cell
#                       configuration metadata and report
#    spalapu 05/01/08 - remove metricretention and rename it to metrichistory -
#                       dkulvete review
#    spalapu 04/29/08 - add metric history days
#    spalapu 03/28/08 - change ifs to elsifs where possible
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - 
#    spalapu 03/17/08 - 
#    spalapu 03/06/08 - add kernelVersion, ossVersion and counts
#    spalapu 02/15/08 - change xml tags for attributes
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
# 

use XML::Parser;
require emx::oracle_cell::oracle_cell_common;

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list cell detail'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
my $result;
my $myinf;
$parser->parse( $xmlout);
#print "em_result=$result\n";


#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    $myinf="";
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
         $result = $result.$attrs{cell}."|".$attrs{realm}."|";
      }
    }
    elsif ($element eq "id")
    {
       $myinf="id";
    }
    elsif ($element eq "makeModel")
    {
       $myinf="makemodel";
    }
    elsif ($element eq "status")
    {
       $myinf="status";
    }
    elsif ($element eq "location")
    {
       $myinf="location";
    }
    elsif ($element eq "bmcType")
    {
       $myinf="bmctype";
    }
    elsif ($element eq "ipBlock")
    {
       $myinf="ipblock";
    }
    elsif ($element eq "fanCount")
    {
       $myinf="fancount";
    }
    elsif ($element eq "powerCount")
    {
       $myinf="powercount";
    }
    elsif ($element eq "metricHistoryDays")
    {
       $myinf="metrichistorydays";
    }
    elsif ($element eq "snmpSubscriber")
    {
       $myinf="snmpsubscriber";
    }
    elsif ($element eq "smtpServer")
    {
       $myinf="smtpserver";
    }
    elsif ($element eq "smtpPort")
    {
       $myinf="smtpport";
    }
    elsif ($element eq "ipaddress1")
    {
       $myinf="ipaddress1";
    }
    elsif ($element eq "ipaddress2")
    {
       $myinf="ipaddress2";
    }
    elsif ($element eq "ipaddress3")
    {
       $myinf="ipaddress3";
    }
    elsif ($element eq "ipaddress4")
    {
       $myinf="ipaddress4";
    }
    elsif ($element eq "kernelVersion")
    {
       $myinf="kernelversion";
    }
    elsif ($element eq "cellVersion")
    {
       $myinf="cellversion";
    }
    elsif ($element eq "interconnectCount")
    {
       $myinf="interconnectcount";
    }
    elsif ($element eq "cpuCount")
    {
       $myinf="cpucount";
    }
    elsif ($element eq "offloadEfficiency")
    {
       $myinf="offloadefficiency";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "cell")
    {
      if ($realmname eq "") {
        $realmname="NONE";
      }

      ($totalfancount,$dummy) = split(/\//, $fancount);
      ($totalpowercount,$dummy) = split(/\//, $powercount);
      print "em_result=$cellname|$status|$realmname|$id|$makemodel|$location|$bmctype|$ipblock|$totalfancount|$totalpowercount|$metrichistory|$snmpsubscriber|$smtpserver|$smtpport|$ipaddress1|$ipaddress2|$ipaddress3|$ipaddress4|$kernelversion|$cellversion|$interconnectcount|$cpucount|$offloadefficiency\n";

      $id="";
      $makemodel="";
      $status="";
      $location="";
      $bmctype="";
      $ipblock="";
      $fancount="";
      $powercount="";
      $metrichistory="";
      $snmpsubscriber="";
      $smtpserver="";
      $smtpport="";
      $ipaddress1="";
      $ipaddress2="";
      $ipaddress3="";
      $ipaddress4="";
      $kernelversion="";
      $cellversion="";
      $interconnectcount="";
      $cpucount="";
      $offloadefficiency="";
      $result="";
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if ($myinf eq "snmpsubscriber")
{
  $data =~ s/^\s+//;
}
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "id" )
{
  $id=$id.$data;
}
elsif ($myinf eq "status" )
{
  $status=$status.$data;
}
elsif ($myinf eq "makemodel" )
{
  $makemodel=$makemodel.$data;
}
elsif ($myinf eq "location" )
{
  $location=$location.$data;
}
elsif ($myinf eq "bmctype" )
{
  $bmctype=$bmctype.$data;
}
elsif ($myinf eq "ipblock" )
{
  $ipblock=$ipblock.$data;
}
elsif ($myinf eq "fancount" )
{
  $fancount=$fancount.$data;
}
elsif ($myinf eq "powercount" )
{
  $powercount=$powercount.$data;
}
elsif ($myinf eq "snmpsubscriber" )
{
  $snmpsubscriber=$snmpsubscriber.$data;
}
elsif ($myinf eq "smtpserver" )
{
  $smtpserver=$smtpserver.$data;
}
elsif ($myinf eq "smtpport" )
{
  $smtpport=$smtpport.$data;
}
elsif ($myinf eq "ipaddress1" )
{
  $ipaddress1=$ipaddress1.$data;
}
elsif ($myinf eq "ipaddress2" )
{
  $ipaddress2=$ipaddress2.$data;
}
elsif ($myinf eq "ipaddress3" )
{
  $ipaddress3=$ipaddress3.$data;
}
elsif ($myinf eq "ipaddress4" )
{
  $ipaddress4=$ipaddress4.$data;
}
elsif ($myinf eq "kernelversion" )
{
  $kernelversion=$kernelversion.$data;
}
elsif ($myinf eq "cellversion" )
{
  $cellversion=$cellversion.$data;
}
elsif ($myinf eq "interconnectcount" )
{
  $interconnectcount=$interconnectcount.$data;
}
elsif ($myinf eq "cpucount" )
{
  $cpucount=$cpucount.$data;
}
elsif ($myinf eq "metrichistorydays" )
{
  $metrichistory=$metrichistory.$data;
}
elsif ($myinf eq "offloadefficiency" )
{
  $offloadefficiency=$offloadefficiency.$data;
}
}
}

