#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle. All rights reserved.
#
#  $Id:oracle_sage_database_metrics.pl 
#
#
# NAME  
#   oracle_sage_database_metrics.pl
#
# DESC 
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/27/08 - 
#    spalapu 08/27/08 - replace sagemonitor with cellmonitor
#    spalapu 08/26/08 - 
#    spalapu 08/26/08 - removed sage from plug-in and added exadata. Also,
#                       fixed realm reports to remove targer_guid from realm
#                       reports. Creating new files from oracle_sage_cell
#    spalapu 07/17/08 - 
#    spalapu 07/17/08 - fix conversion of collectiontime to secs
#    loliu   06/20/08 - Bug 7191050: Added iormtimestamp. Fixed IO request
#                       timestamp.
#    spalapu 05/01/08 - Change cumulative value to Cumulative
#    spalapu 04/25/08 - 
#    spalapu 04/17/08 - Split IO Requests into Small and Large from current
#                       Read and Write
#    spalapu 04/03/08 - remove uneccesary fields
#    spalapu 03/28/08 - change ifs to elsifs where possible
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - 
#    spalapu 03/17/08 - 
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
#
#IORM_DATABASE
#-------------
#DB_IO_RQ_SM
#DB_IO_RQ_LG
#DB_IO_WT_SM
#DB_IO_WT_LG
#DB_IO_WT_SM_RQ
#DB_IO_WT_LG_RQ
# 

use XML::Parser;
use Class::Struct;
require emx::oracle_cell::oracle_cell_common;

our %databases;  # Hash of databases

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list metriccurrent where objectType=".'\"IORM_DATABASE\"'."'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
my $myinf;
my $io_requests;
my $io_wait_requests;
my $io_wait_per_request;
$parser->parse( $xmlout);

       foreach $database (keys %databases)
       {
          print "em_result=".$databases{$database}{name}."|".$cellname."|".$realmname."|".$iormtimestamp."|Database*_Statistics|INTER_DATABASE|".$databases{$database}{DB_IO_RQ_SM}."|".$databases{$database}{DB_IO_WT_SM}."|".$databases{$database}{DB_IO_RQ_LG}."|". $databases{$database}{DB_IO_WT_LG}."|".$databases{$database}{DB_IO_RQ_SM_time}."\n";
       }

#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    #Oracle Sage Cell Properties.
    $myinf="";
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
         $iormtimestamp = $attrs{iormResetTimestamp};
         $iormtimestamp = $iormtimestamp/1000;
      }
    }
    elsif ($element eq "cli-output")
    {
       $myinf="cli-output";
    }
    elsif ($element eq "name")
    {
       $myinf="name";
    }
    elsif ($element eq "metricType")
    {
       $myinf="metric_type";
    }
    elsif ($element eq "metricValue")
    {
       $myinf="metric_value";
    }
    elsif ($element eq "collectionTime")
    {
       $myinf="collection_time";
    }
    elsif ($element eq "metricObjectName")
    {
       $myinf="object_name";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "metric")
    {
      if ($realmname eq "") {
        $realmname="NONE";
      }
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "name" )
{
  $name=$name.$data;
}
elsif ($myinf eq "metric_type" )
{
  $metric_type=$metric_type.$data;
}
elsif ($myinf eq "metric_value" )
{
  $metric_value=$metric_value.$data;
  if ($metric_type eq "Cumulative")
  {
     $collection_time = $collection_time/1000;
     $databases{$object_name}{name} = $object_name;
     $databases{$object_name}{$name} = $metric_value;
     $databases{$object_name}{$name."_time"} = $collection_time;
  }
  $name="";
  $metric_type="";
  $metric_value="";
  $collection_time="";
  $object_name="";

}
elsif ($myinf eq "collection_time" )
{
  $data=$data;
  $collection_time=$collection_time.$data;
}
elsif ($myinf eq "object_name" )
{
  $object_name=$object_name.$data;

}
}
}
