#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle. All rights reserved.
#
#  $Id:oracle_sage_disk_config.pl 
#
#
# NAME  
#   oracle_sage_disk_config.pl
#
# DESC 
#
# This script gets all the static configuration of the disks of the Oracle Sage Cell.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/27/08 - 
#    spalapu 08/27/08 - replace sagemonitor with cellmonitor
#    spalapu 08/26/08 - 
#    spalapu 08/26/08 - removed sage from plug-in and added exadata. Also,
#                       fixed realm reports to remove targer_guid from realm
#                       reports. Creating new files from oracle_sage_cell
#    loliu   06/12/08 - Bug 7165455: Fixed blank columns
#    spalapu 04/07/08 - Rearrange columns for Bug 6933251
#    spalapu 03/28/08 - change ifs to elsifs where possible
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - 
#    spalapu 03/17/08 - 
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
# 

use XML::Parser;
require emx::oracle_cell::oracle_cell_common;

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list physicaldisk detail'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
my $result;
my $myinf;
$parser->parse( $xmlout);
#print "em_result=$result\n";


#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    $myinf="";
    #Oracle Sage Cell Properties.
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
      }
    }
    elsif ($element eq "name")
    {
       $myinf="name";
    }
    elsif ($element eq "status")
    {
       $myinf="status";
    }
    elsif ($element eq "id")
    {
       $myinf="id";
    }
    elsif ($element eq "makeModel")
    {
       $myinf="makemodel";
    }
    elsif ($element eq "luns")
    {
       $myinf="lun";
    }
    elsif ($element eq "errorCount")
    {
       $myinf="ErrorCount";
    }
    elsif ($element eq "ctrlFirmWare")
    {
       $myinf="ctrlfirmware";
    }
    elsif ($element eq "ctrlHwVersion")
    {
       $myinf="ctrlhwversion";
    }
    elsif ($element eq "physicalInterface")
    {
       $myinf="physinterface";
    }
    elsif ($element eq "physicalFirmware")
    {
       $myinf="physfirmware";
    }
    elsif ($element eq "physicalSize")
    {
       $myinf="physsize";
    }
    elsif ($element eq "physicalSerial")
    {
       $myinf="physserial";
    }
    elsif ($element eq "physicalUseType")
    {
       $myinf="physusetype";
    }
    elsif ($element eq "physicalPort")
    {
       $myinf="physport";
    }
    elsif ($element eq "physicalInsertTime")
    {
       $myinf="physinserttime";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "physicaldisk")
    {
      if ($realmname eq "") {
        $realmname="NONE";
      }

      $physsize=get_size_in_gb($physsize);
      print "em_result=$name|$cellname|$realmname|$status|$physsize|$id|$makemodel|$lun|$errorcount|$physinserttime|$ctrlfirmware|$ctrlhwversion|$physinterface|$physfirmware|$physserial|$physusetype|$physport|\n";
      $name="";
      $status="";
      $id="";
      $makemodel="";
      $lun="";
      $errorcount="";
      $ctrlfirmware="";
      $ctrlhwversion="";
      $physinterface="";
      $physfirmware="";
      $physsize="";
      $physserial="";
      $physusetype="";
      $physport="";
      $physinserttime="";
      $result="";
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "name" )
{
  $name=$name.$data;
}
elsif ($myinf eq "status" )
{
  $status=$status.$data;
}
if ($myinf eq "id" )
{
  $id=$id.$data;
}
elsif ($myinf eq "makemodel" )
{
  $makemodel=$makemodel.$data;
}
elsif ($myinf eq "lun" )
{
  $lun=$lun.$data;
#  if ($lun eq "")
#  {
#    $lun="NA";
#  }
}
elsif ($myinf eq "errorcount" )
{
  $errorcount=$errorcount.$data;
}
elsif ($myinf eq "ctrlfirmware" )
{
  $ctrlfirmware=$ctrlfirmware.$data;
}
elsif ($myinf eq "ctrlhwversion" )
{
  $ctrlhwversion=$ctrlhwversion.$data;
}
elsif ($myinf eq "physinterface" )
{
  $physinterface=$physinterface.$data;
}
elsif ($myinf eq "physfirmware" )
{
  $physfirmware=$physfirmware.$data;
}
elsif ($myinf eq "physsize" )
{
  $physsize=$physsize.$data;
}
elsif ($myinf eq "physserial" )
{
  $physserial=$physserial.$data;
}
elsif ($myinf eq "physusetype" )
{
  $physusetype=$physusetype.$data;
}
elsif ($myinf eq "physport" )
{
  $physport=$physport.$data;
}
elsif ($myinf eq "physinserttime" )
{
  $physinserttime=$physinserttime.$data;
}
}
}

