#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle. All rights reserved.
#
#  $Id:oracle_sage_config.pl 
#
#
# NAME  
#   oracle_sage_griddisk_config.pl
#
# DESC 
#
# This script gets all the static configuration of the Oracle Sage Cell.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/27/08 - 
#    spalapu 08/27/08 - replace sagemonitor with cellmonitor
#    spalapu 08/26/08 - 
#    spalapu 08/26/08 - removed sage from plug-in and added exadata. Also,
#                       fixed realm reports to remove targer_guid from realm
#                       reports. Creating new files from oracle_sage_cell
#    spalapu 07/17/08 - 
#    spalapu 07/15/08 - change dbclient, owner to availableTo
#    spalapu 03/28/08 - change ifs to elsifs where possible
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - 
#    spalapu 03/17/08 - 
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
# 

use XML::Parser;
require emx::oracle_cell::oracle_cell_common;

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list griddisk detail'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
my $result;
my $myinf;
$parser->parse( $xmlout);
#print "em_result=$result\n";


#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    $myinf="";
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
      }
    }
    elsif ($element eq "name")
    {
       $myinf="name";
    }
    elsif ($element eq "status")
    {
       $myinf="status";
    }
    elsif ($element eq "creationTime")
    {
       $myinf="creationtime";
    }
    elsif ($element eq "cellDisk")
    {
       $myinf="celldisk";
    }
    elsif ($element eq "offset")
    {
       $myinf="offset";
    }
    elsif ($element eq "availableTo")
    {
       $myinf="availableto";
    }
    elsif ($element eq "size")
    {
       $myinf="size";
    }
    elsif ($element eq "errorCount")
    {
       $myinf="errorcount";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "griddisk")
    {

      if ($realmname eq "") {
        $realmname="NONE";
      }
      $size=get_size_in_gb($size);
      $offset=get_size_in_mb($offset);
      print "em_result=$name|$cellname|$realmname|$status|$size|$creationtime|$celldisk|$offset|$errorcount|$availableto\n";
      $name="";
      $status="";
      $creationtime="";
      $celldisk="";
      $offset="";
      $availableto="";
      $size="";
      $errorcount="";
      $result="";
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "name" )
{
  $name=$name.$data;
}
elsif ($myinf eq "status" )
{
  $status=$status.$data;
}
elsif ($myinf eq "creationtime" )
{
  $creationtime=$creationtime.$data;
}
elsif ($myinf eq "celldisk" )
{
  $celldisk=$celldisk.$data;
}
elsif ($myinf eq "offset" )
{
  $offset=$offset.$data;
}
elsif ($myinf eq "availableto" )
{
  $availableto=$availableto.$data;
}
elsif ($myinf eq "size" )
{
  $size=$size.$data;
}
elsif ($myinf eq "errorcount" )
{
  $errorcount=$errorcount.$data;
}
}
}

