#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle and/or its affiliates. All rights reserved.
#
#  $Id:oracle_sage_config.pl 
#
#
# NAME  
#   oracle_sage_interconnect_metrics.pl
#
# DESC 
#
# This script gets all the Cell Disk metrics of the SAGE CELL.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 09/18/08 - 
#    spalapu 09/16/08 - fix osstimestamp and order of values
#    spalapu 09/12/08 - 
#    spalapu 09/12/08 - 
# 

use XML::Parser;
use Class::Struct;
require emx::oracle_cell::oracle_cell_common;

our %interconnects;  # Hash of interconnects

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list metriccurrent where objectType=".'\"HOST_INTERCONNECT\"'."'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
$parser->parse( $xmlout);

       foreach $interconnect (keys %interconnects)
       {
          print "em_result=".$interconnects{$interconnect}{name}."|".$cellname."|".$realmname."|".$osstimestamp."|".$interconnects{$interconnect}{N_MB_SENT}."|".$interconnects{$interconnect}{N_MB_SENT_time}."|".$interconnects{$interconnect}{N_MB_DROP}."|".$interconnects{$interconnect}{N_MB_DROP_time}."|".$interconnects{$interconnect}{N_MB_RESENT}."|".$interconnects{$interconnect}{N_MB_RESENT_time}."|".$interconnects{$interconnect}{N_MB_RECEIVED}."|".$interconnects{$interconnect}{N_MB_RECEIVED_time}."|".$interconnects{$interconnect}{N_MB_RDMA_DROP}."|".$interconnects{$interconnect}{N_MB_RDMA_DROP_time}."|".$interconnects{$interconnect}{N_RDMA_RETRY_TM}."|".$interconnects{$interconnect}{N_RDMA_RETRY_TM_time}."|"."\n";
       }

#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    $myinf="";
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
         $osstimestamp = $attrs{ossStartTimestamp};
      }
    }
    elsif ($element eq "cli-output")
    {
       $myinf="cli-output";
    }
    elsif ($element eq "name")
    {
       $myinf="name";
    }
    elsif ($element eq "metricType")
    {
       $myinf="metric_type";
    }
    elsif ($element eq "metricValue")
    {
       $myinf="metric_value";
    }
    elsif ($element eq "collectionTime")
    {
       $myinf="collection_time";
    }
    elsif ($element eq "metricObjectName")
    {
       $myinf="object_name";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "metric")
    {
      if ($realmname eq "") {
        $realmname="NONE";
      }
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "name" )
{
  $name=$name.$data;
}
elsif ($myinf eq "metric_type" )
{
  $metric_type=$metric_type.$data;
}
elsif ($myinf eq "metric_value" )
{
  $metric_value=$metric_value.$data;
  if ($metric_type eq "Cumulative")
  {
     $collection_time = $collection_time/1000;
     $interconnects{$object_name}{name} = $object_name;
     $interconnects{$object_name}{$name} = $metric_value;
     $interconnects{$object_name}{$name."_time"} = $collection_time;
  }
  $name="";
  $metric_type="";
  $metric_value="";
  $collection_time="";
  $object_name="";

}
elsif ($myinf eq "collection_time" )
{
  #convert to secs from millsecs
  $data= $data; 
  $collection_time=$collection_time.$data;
}
elsif ($myinf eq "object_name" )
{
  $object_name=$object_name.$data;

}
}
}
