#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle and/or its affiliates. All rights reserved.
#
#  $Id:oracle_sage_iorm_config.pl 
#
#
# NAME  
#   oracle_sage_iorm_config.pl
#
# DESC 
#
# This script gets all the static configuration of the Oracle Sage Cell.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 09/17/08 - 
#    spalapu 09/16/08 - remove latency
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/27/08 - 
#    spalapu 08/27/08 - replace sagemonitor with cellmonitor
#    spalapu 08/26/08 - 
#    spalapu 08/26/08 - removed sage from plug-in and added exadata. Also,
#                       fixed realm reports to remove targer_guid from realm
#                       reports. Creating new files from oracle_sage_cell
#    spalapu 03/28/08 - change ifs to elsifs where possible
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - 
#    spalapu 03/17/08 - 
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
# 

use XML::Parser;
use Class::Struct;
require emx::oracle_cell::oracle_cell_common;

struct iormconfigStruct =>
{
   name  => '$',
   level =>  '$',
   allocation =>  '$',
   role =>  '$',
};


$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list iormplan detail'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
$result;
$myinf;
$name;
$status;
$latency;
%iormconfigdb_map;
%iormconfigcat_map;
$parser->parse( $xmlout);
foreach $iormconfigname (keys (%iormconfigdb_map))
{
   my $i;
   my $iormconfig = $iormconfigdb_map{$iormconfigname};
   print "em_result=".$name."|".$cellname."|".$realmname."|".$status."|INTER-DATABASE"."|".$iormconfig->name."|";
   for($i= 1;$i<= 8; $i++) 
   {
     if ($i==$iormconfig->level)
     {
       print $iormconfig->allocation."|";
     }
     else
     {
       print "|";
     }
   }
   print $iormconfig->role."|\n";
}

foreach $iormconfigname (keys (%iormconfigcat_map))
{
   my $i;
   my $iormconfig = $iormconfigcat_map{$iormconfigname};
   print "em_result=".$name."|".$cellname."|".$realmname."|".$status."|CATEGORY"."|".$iormconfig->name."|";
   for($i= 1;$i<= 8; $i++) 
   {
     if ($i==$iormconfig->level)
     {
       print $iormconfig->allocation."|";
     }
     else
     {
       print "|";
     }
   }
   print $iormconfig->role."|\n";
}

#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    $myinf="";
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
         if ($realmname eq "") {
           $realmname="NONE";
         }
      }
    }
    elsif ($element eq "directive")
    {
      if( %attrs )
      {
         my $iormconfig = iormconfigStruct->new(); 
         my $level;
         my $allocation;
         $iormconfig->name($attrs{name});
         $iormconfig->role($attrs{role}); 
         $iormconfig->level($attrs{level});
         $iormconfig->allocation($attrs{allocation}."%");
         if($plantype eq "catPlan") 
         {
           $iormconfigcat_map{$iormconfig->name} =  $iormconfig;
         }
         else 
         {
           $iormconfigdb_map{$iormconfig->name} =  $iormconfig;
         }
      }
    }
    elsif ($element eq "name")
    {
       $myinf="name";
    }
    elsif ($element eq "status")
    {
       $myinf="status";
    }
    elsif ($element eq "latency")
    {
       $myinf="latency";
    }
    elsif ($element eq "catPlan")
    {
       $plantype=$element;
    }
    elsif ($element eq "dbPlan")
    {
       $plantype=$element;
    }
}


sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "name" )
{
  $name=$name.$data;
}
elsif ($myinf eq "status" )
{
  $status=$status.$data;
}
elsif ($myinf eq "latency" )
{
  $latency=$latency.$data;
}
}
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
}

