#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle and/or its affiliates. All rights reserved.
#
#  $Id:oracle_sage_iormboost_metrics.pl 
#
#
# NAME  
#   oracle_sage_iormboost_metrics.pl
#
# DESC 
#
# This script gets all the offload metrics of the Oracle Cell.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 09/08/08 - 
#    spalapu 09/03/08 - adding the iormboost metric collection
#    spalapu 08/14/08 - iormboost_metrics
# 

use XML::Parser;
require emx::oracle_cell::oracle_cell_common;

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list cell detail'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
my $result;
my $myinf;
$parser->parse( $xmlout);


#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    $myinf="";
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
         $result = $result.$attrs{cell}."|".$attrs{realm}."|";
      }
    }
    elsif ($element eq "iormBoost")
    {
       $myinf="iormboost";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "cell")
    {
      if ($realmname eq "") {
        $realmname="NONE";
      }
      print "em_result=".$cellname."|".$realmname."|".$iormboost."\n";
      $iormboost="";
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "iormboost" )
{
  $iormboost=$iormboost.$data;
  $iormboost = int($iormboost);
}
}
}

