#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle. All rights reserved.
#
#  $Id:oracle_sage_lun_config.pl 
#
#
# NAME  
#   oracle_sage_lun_config.pl
#
# DESC 
#
# This script gets all the static lun configuration of the Oracle Sage Cell.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/27/08 - 
#    spalapu 08/27/08 - replace sagemonitor with cellmonitor
#    spalapu 08/26/08 - 
#    spalapu 08/26/08 - removed sage from plug-in and added exadata. Also,
#                       fixed realm reports to remove targer_guid from realm
#                       reports. Creating new files from oracle_sage_cell
#    spalapu 04/08/08 - reorder fields as per metadata file
#    spalapu 03/28/08 - change ifs to elsifs where possible
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - 
#    spalapu 03/17/08 - 
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
# 

use XML::Parser;
require emx::oracle_cell::oracle_cell_common;

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list lun detail'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
my $result;
my $myinf;
$parser->parse( $xmlout);
#print "em_result=$result\n";


#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    $myinf="";
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
      }
    }
    elsif ($element eq "name")
    {
       $myinf="name";
    }
    elsif ($element eq "status")
    {
       $myinf="status";
    }
    elsif ($element eq "id")
    {
       $myinf="id";
    }
    elsif ($element eq "cellDisk")
    {
       $myinf="celldisk";
    }
    elsif ($element eq "raidLevel")
    {
       $myinf="raidlevel";
    }
    elsif ($element eq "deviceName")
    {
       $myinf="devicename";
    }
    elsif ($element eq "lunUID")
    {
       $myinf="lunuid";
    }
    elsif ($element eq "lunSize")
    {
       $myinf="lunsize";
    }
    elsif ($element eq "lunAutoCreate")
    {
       $myinf="lunautocreate";
    }
    elsif ($element eq "physicalDrives")
    {
       $myinf="physicaldisks";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "lun")
    {
      if ($realmname eq "") {
        $realmname="NONE";
      }
      $lunsize=get_size_in_gb($lunsize);
      print "em_result=$name|$cellname|$realmname|$id|$status|$celldisk|$errorcount|$raidlevel|$devicename|$lunsize|$lunautocreate|$physicaldisks|$lunuid|\n";
      $name="";
      $id="";
      $status="";
      $celldisk="";
      $errorcount="";
      $raidlevel="";
      $devicename="";
      $lunsize="";
      $lunuid="";
      $lunautocreate="";
      $physicaldisks="";
      $result="";
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "name" )
{
  $name=$name.$data;
}
elsif ($myinf eq "id" )
{
  $id=$id.$data;
}
elsif ($myinf eq "status" )
{
  $status=$status.$data;
}
elsif ($myinf eq "celldisk" )
{
  $celldisk=$celldisk.$data;
}
elsif ($myinf eq "errorcount" )
{
  $errorcount=$errorcount.$data;
}
elsif ($myinf eq "raidlevel" )
{
  $raidlevel=$raidlevel.$data;
}
elsif ($myinf eq "devicename" )
{
  $devicename=$devicename.$data;
}
elsif ($myinf eq "lunsize" )
{
  $lunsize=$lunsize.$data;
}
elsif ($myinf eq "lunuid" )
{
  $lunuid=$lunuid.$data;
}
elsif ($myinf eq "lunautocreate" )
{
  $lunautocreate=$lunautocreate.$data;
}
elsif ($myinf eq "physicaldisks" )
{
  $physicaldisks=$physicaldisks.$data;
}
}
}

