#!/usr/bin/perl

#
# Copyright (c) 2001, 2008, Oracle. All rights reserved.
#
#  $Id:oracle_cell_cell_metrics.pl 
#
#
# NAME  
#   oracle_cell_cell_metrics.pl
#
# DESC 
#
# This script gets all the static configuration of the Oracle Cell.   
#
# NOTES
#
# MODIFIED  (MM/DD/YY)
#    spalapu 08/28/08 - 
#    spalapu 08/28/08 - 
#    spalapu 08/27/08 - 
#    spalapu 08/27/08 - replace sagemonitor with cellmonitor
#    spalapu 08/26/08 - 
#    spalapu 05/27/08 - changing rounding to show upto 2 decimals
#    spalapu 04/28/08 - move metric collection to metric_value bloc
#    spalapu 03/26/08 - Add NIC metrics
#    spalapu 03/19/08 - Add Copyright statements
#    spalapu 03/18/08 - 
#    spalapu 03/17/08 - 
#    spalapu 03/13/08 - change object_type to objectType
#    spalapu 02/13/08 - new file
#   spalapud 10/07/06 	Created the file.
# 

use XML::Parser;
use Class::Struct;
require emx::oracle_cell::oracle_cell_common;

our %cells;  # Hash of cells

$ipaddress=doPing(@ARGV);

if($ipaddress eq "") {
  print "em_error=Failed to ping Cell\n";
  exit -1;
}
my $command = "ssh -l cellmonitor $ipaddress cellcli  -xml -e 'list metriccurrent where objectType=".'\"CELL\"'."'";

my $xmlout = `$command`;

my $parser = XML::Parser->new( Handlers => {
                                      Start=>\&handle_start,
                                      End=>\&handle_end,
				      Char=> \&characterData,
                                     });
my $myinf;
$parser->parse( $xmlout);

       foreach $cell (keys %cells)
       {
          print "em_result=".$cellname."|".$realmname."|".$cells{$cell}{CL_CPUT}."|".$cells{$cell}{CL_FANS}."|".$cells{$cell}{CL_RUNQ}."|".$cells{$cell}{CL_TEMP}."|".$cells{$cell}{N_NIC_NW}."|".$cells{$cell}{N_NIC_RCV_SEC}."|".$cells{$cell}{N_NIC_TRANS_SEC}."|"."\n";
       }

#-----------------------------------------------------------------
# FUNCTIONS :  handle_start
#
#
# DESC : Does node based parsing of the XML output.
#
# ARGUMENTS :
#		elements : Node elements in the XML 
#  		attrs 	 : Attributes of the elements.
#
#
#-----------------------------------------------------------------

sub handle_start {
    my( $expat, $element, %attrs  ) = @_;
    $myinf="";
    if ($element eq "context")
    {
      if( %attrs )
      {
         $cellname = $attrs{cell};
         $realmname = $attrs{realm};
      }
    }
    elsif ($element eq "name")
    {
       $myinf="name";
    }
    elsif ($element eq "metricType")
    {
       $myinf="metric_type";
    }
    elsif ($element eq "metricValue")
    {
       $myinf="metric_value";
    }
    elsif ($element eq "collectionTime")
    {
       $myinf="collection_time";
    }
    elsif ($element eq "metricObjectName")
    {
       $myinf="object_name";
    }
}

sub handle_end {
    my( $expat, $element, %attrs  ) = @_;
    if ($element eq "metric")
    {
      if ($realmname eq "") {
        $realmname="NONE";
      }
    }
}

sub characterData {
my( $parseinst, $data ) = @_;
$space=" ";
$data =~ s/\n//g;
if (($data !~ m/^\s/) and ($data ne "\""))
{
if ($myinf eq "name" )
{
  $name=$name.$data;
}
elsif ($myinf eq "metric_type" )
{
  $metric_type=$metric_type.$data;
}
elsif ($myinf eq "metric_value" )
{
  $metric_value=$metric_value.$data;

  if (!($object_name eq "")) 
  {
  $cells{$object_name}{name} = $object_name;
  $cells{$object_name}{$name} = sprintf("%.2f",$metric_value);
  $cells{$object_name}{$name."_time"} = $collection_time;
  }
  $name="";
  $metric_type="";
  $metric_value="";
  $collection_time="";
  $object_name="";
}
elsif ($myinf eq "collection_time" )
{
  $collection_time=$collection_time.$data;
}
elsif ($myinf eq "object_name" )
{
  $object_name=$object_name.$data;

}
}
}
