<?xml version="1.0"?>
<!--
 Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved. 

   NAME
     rspfmt_ext2raw_transformer_v11_2_0.xsl - XSLT to transform external property based Database response file format to internal format

   DESCRIPTION
     <short description of component this file declares/defines>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
      sangkuma 05/20/09 - Updating property defaulting code
      sangkuma 03/30/09 - Removing backward compatible code
      sangkuma 03/04/09 - Retaining the names of other OUI session variables
      sangkuma 02/22/09 - Changing oracle.install.*.ORACLE_* variables to
                          ORACLE_*
      sangkuma 01/05/09 - Using the MYORACLESUPPORT_* convention
      sangkuma 11/10/08 - Changing METALINK to MYORACLESUPPORT
      sangkuma 11/02/08 - Modifying to integrate with new OUIs OCM
      jaikrish 07/28/08 - Changes for bug fix 7186623
      msubbann 05/12/08 - Take out ORACLE_HOME_NAME property
      poosrini 05/08/08 - 
      msubbann 03/25/08 - Get rid of confirm password related entries
      aqazi    03/18/08 - b_useRegistration will be forced to take same value
                          as b_acceptLicense. This applies to OCM
      sangkuma 03/12/08 - Setting OPER Group
      sangkuma 03/11/08 - change the property name of
                          oracle.install.OPERGroupNameUsed to
                          UNIX_GROUP_NAME
      msubbann 03/10/08 - oracle_install_db_QuickInstallOption is now a boolean
      pvallam  02/21/08 - corrected the key entry for security settings 
      msubbann 02/19/08 - Use InstallType in place of InstallTypeShortDesc
      msubbann 02/13/08 - Add oracle.install.customComponents
      pvallam  02/05/08 - updating the character set option
      poosrini 02/04/08 - Added missing end tag for xsl:template
      msubbann 01/24/08 - Fix toValueList template to avoid null values
      sangkuma 12/06/07 - XSLT to transform external Database response file format to internal format
      sangkuma 12/06/07 - Created
-->
<xsl:stylesheet 
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
      version="1.0">
<xsl:template match="properties">
<beanstore>
	<DBSetupBean>
		<ORACLE_HOSTNAME><xsl:value-of select="ORACLE_HOSTNAME"/></ORACLE_HOSTNAME>
		<SELECTED_LANGUAGES>
			<xsl:call-template name="toValueList">
				<xsl:with-param name="stringList" select="SELECTED_LANGUAGES"></xsl:with-param>
			</xsl:call-template>
		</SELECTED_LANGUAGES>
		<CentralInventorySettings>
		    <INVENTORY_LOCATION><xsl:value-of select="INVENTORY_LOCATION"/></INVENTORY_LOCATION>      
    		<UNIX_GROUP_NAME><xsl:value-of select="UNIX_GROUP_NAME"/></UNIX_GROUP_NAME>
    	</CentralInventorySettings>
    	<OCMSettings>
			<MYORACLESUPPORT_USERNAME><xsl:value-of select="MYORACLESUPPORT_USERNAME"/></MYORACLESUPPORT_USERNAME>
			<MYORACLESUPPORT_PASSWORD><xsl:value-of select="MYORACLESUPPORT_PASSWORD"/></MYORACLESUPPORT_PASSWORD>
			<PROXY_HOST><xsl:value-of select="PROXY_HOST"/></PROXY_HOST>
			<PROXY_PORT><xsl:value-of select="PROXY_PORT"/></PROXY_PORT>
			<PROXY_USER><xsl:value-of select="PROXY_USER"/></PROXY_USER>
			<PROXY_PWD><xsl:value-of select="PROXY_PWD"/></PROXY_PWD>
			<SECURITY_UPDATES_VIA_MYORACLESUPPORT><xsl:value-of select="SECURITY_UPDATES_VIA_MYORACLESUPPORT"/></SECURITY_UPDATES_VIA_MYORACLESUPPORT>
			<DECLINE_SECURITY_UPDATES><xsl:value-of select="DECLINE_SECURITY_UPDATES"/></DECLINE_SECURITY_UPDATES>
    	</OCMSettings>
    	<DBInstallSettings>
			<ORACLE_HOME><xsl:value-of select="ORACLE_HOME"/></ORACLE_HOME>
			<ORACLE_BASE><xsl:value-of select="ORACLE_BASE"/></ORACLE_BASE>
			<oracle_install_db_InstallEdition>
		      <xsl:choose>
		         <xsl:when test="string-length(oracle.install.db.installType) > 0"><xsl:value-of select="oracle.install.db.installType"/></xsl:when>
		         <xsl:when test="string-length(oracle.install.db.InstallEdition) > 0"><xsl:value-of select="oracle.install.db.InstallEdition"/></xsl:when>
	          </xsl:choose>
	        </oracle_install_db_InstallEdition>
            <oracle_install_db_CustomInstall><xsl:value-of select="oracle.install.db.isCustomInstall"/></oracle_install_db_CustomInstall>            
			<oracle_install_db_CustomComponents>
				<xsl:call-template name="toValueList">
					<xsl:with-param name="stringList" select="oracle.install.db.customComponents"></xsl:with-param>
				</xsl:call-template>
	      	</oracle_install_db_CustomComponents>
			<oracle_install_OSDBA><xsl:value-of select="oracle.install.db.DBA_GROUP"/></oracle_install_OSDBA>
			<oracle_install_OSOPER><xsl:value-of select="oracle.install.db.OPER_GROUP"/></oracle_install_OSOPER>
			<CLUSTER_NODES>
				<xsl:call-template name="toValueList">
					<xsl:with-param name="stringList" select="oracle.install.db.CLUSTER_NODES"></xsl:with-param>
				</xsl:call-template>
	      	</CLUSTER_NODES>
	      	<xsl:variable name="installOption" select="oracle.install.option"/>
			<oracle_install_db_InstallOption><xsl:value-of select="$installOption"/></oracle_install_db_InstallOption>
			<!-- 
			   if ConfigSettings contains only StarterDatabaseSettings
			      and StarterDatabaseSettings contains only (GeneralDatabaseSettings and StorageSettings)
			      and GeneralDatabaseSettings/DatabasePassword contains only ALL
			      and StorageSettings/FileSystemStorageSettings contains only DataLocation 
			   then
			      QuickInstallerOption = 1
			   else 
			      QuickInstallerOption = 2
			   end if
			 -->      
			<!-- xsl:choose>
			      <xsl:when test="count(../*)=1 and count(./*)=2 and GeneralDatabaseSettings and StorageSettings and GeneralDatabaseSettings/DatabasePassword/ALL and count(GeneralDatabaseSettings/DatabasePassword/*)=1 and StorageSettings/FileSystemStorageSettings/DataLocation and count(StorageSettings/FileSystemStorageSettings/*)=1">1
			      </xsl:when>
			  	<xsl:otherwise>2</xsl:otherwise>
		    </xsl:choose-->
			<xsl:variable name="storageType" select="oracle.install.db.config.starterdb.storageType"/>
			<oracle_install_db_StorageType>
	          <xsl:choose>
	              <xsl:when test="$storageType='FILE_SYSTEM_STORAGE'">1</xsl:when>
	              <xsl:when test="$storageType='ASM_STORAGE'">2</xsl:when>
	              <xsl:otherwise>0</xsl:otherwise>
	          </xsl:choose>
			</oracle_install_db_StorageType>
			<oracle_install_db_ConfigTabSelected>0</oracle_install_db_ConfigTabSelected>
			<oracle_install_db_SID><xsl:value-of select="oracle.install.db.config.starterdb.SID"/></oracle_install_db_SID>
			<oracle_install_db_GlobalDBName><xsl:value-of select="oracle.install.db.config.starterdb.globalDBName"/></oracle_install_db_GlobalDBName>
			<oracle_install_db_LoadExampleSchemas><xsl:value-of select="oracle.install.db.config.starterdb.installExampleSchemas"/></oracle_install_db_LoadExampleSchemas>
			<oracle_install_db_CharSetOption>3</oracle_install_db_CharSetOption>
			<oracle_install_db_CharacterSet><xsl:value-of select="oracle.install.db.config.starterdb.characterSet"/></oracle_install_db_CharacterSet>
			<oracle_install_db_AllocatedMemory><xsl:value-of select="oracle.install.db.config.starterdb.memoryLimit"/></oracle_install_db_AllocatedMemory>
			<oracle_install_db_AutoMemoryOption><xsl:value-of select="oracle.install.db.config.starterdb.memoryOption"/></oracle_install_db_AutoMemoryOption>
			<xsl:variable name="enableSecuritySettings" select="oracle.install.db.config.starterdb.enableSecuritySettings"/>
			<oracle_install_db_SecureConfigDisabled>
				<xsl:choose>
				<xsl:when test="$enableSecuritySettings = 'false'">true</xsl:when>
				   <xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</oracle_install_db_SecureConfigDisabled>
			<oracle_install_db_InstallOptionSelected>1</oracle_install_db_InstallOptionSelected>
			<oracle_install_db_StarterDatabaseType><xsl:value-of select="oracle.install.db.config.starterdb.type"/></oracle_install_db_StarterDatabaseType>
	      
			<xsl:variable name="genericPassword" select="oracle.install.db.config.starterdb.password.ALL"/>
			<oracle_install_db_UseSamePassword><xsl:choose><xsl:when test="string-length($genericPassword)>0">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></oracle_install_db_UseSamePassword>		
			<xsl:choose>
				<xsl:when test="string-length($genericPassword)>0">
					<oracle_install_db_SuperAdminSamePasswdForAll><xsl:value-of select="$genericPassword"/></oracle_install_db_SuperAdminSamePasswdForAll>
				</xsl:when>
			</xsl:choose>
			<oracle_install_db_SuperAdminPasswords>
				<xsl:choose>
				<xsl:when test="string-length($genericPassword)>0">
				   <value><xsl:value-of select="$genericPassword"/></value>
				   <value><xsl:value-of select="$genericPassword"/></value>
				   <value><xsl:value-of select="$genericPassword"/></value>
				   <value><xsl:value-of select="$genericPassword"/></value>
				</xsl:when>
				<xsl:otherwise>
				   <value><xsl:value-of select="oracle.install.db.config.starterdb.password.SYS"/></value>
				   <value><xsl:value-of select="oracle.install.db.config.starterdb.password.SYSTEM"/></value>
				   <value><xsl:value-of select="oracle.install.db.config.starterdb.password.SYSMAN"/></value>
				   <value><xsl:value-of select="oracle.install.db.config.starterdb.password.DBSNMP"/></value>
				</xsl:otherwise>
				</xsl:choose>
			</oracle_install_db_SuperAdminPasswords>
			<oracle_install_db_RecoveryBackUpPassword><xsl:value-of select="oracle.install.db.config.starterdb.automatedBackup.ospwd"/></oracle_install_db_RecoveryBackUpPassword>
			<oracle_install_db_RecoveryBackUpUsername><xsl:value-of select="oracle.install.db.config.starterdb.automatedBackup.osuid"/></oracle_install_db_RecoveryBackUpUsername>
			<oracle_install_db_EnableAutoBackup><xsl:value-of select="oracle.install.db.config.starterdb.automatedBackup.enable"/></oracle_install_db_EnableAutoBackup>
			<oracle_install_db_MountPointLocation><xsl:value-of select="oracle.install.db.config.starterdb.fileSystemStorage.dataLocation"/></oracle_install_db_MountPointLocation>
			<oracle_install_db_ASMSNMPUserPassword><xsl:value-of select="oracle.install.db.config.asm.ASMSNMPPassword"/></oracle_install_db_ASMSNMPUserPassword>
			<oracle_install_db_DiskGroupNameForASM><xsl:value-of select="oracle.install.db.config.asm.diskGroup"/></oracle_install_db_DiskGroupNameForASM>
			<xsl:variable name="recoveryLocation" select="oracle.install.db.config.starterdb.fileSystemStorage.recoveryLocation"/>
			<oracle_install_db_RecoveryBackUpLocation><xsl:value-of select="$recoveryLocation"/></oracle_install_db_RecoveryBackUpLocation>
			<oracle_install_db_UseFileSystemForRecovery>
			    <xsl:choose>
			       <xsl:when test="string-length($recoveryLocation) > 0">true</xsl:when>
			       <xsl:otherwise>false</xsl:otherwise>
			    </xsl:choose>
			</oracle_install_db_UseFileSystemForRecovery>
			<xsl:variable name="control" select="oracle.install.db.config.starterdb.control"/>
			<oracle_install_db_UseDBControl><xsl:choose><xsl:when test="$control='GRID_CONTROL'">false</xsl:when><xsl:otherwise>true</xsl:otherwise></xsl:choose></oracle_install_db_UseDBControl>
			<oracle_install_db_EMCentralAgentSelected><xsl:value-of select="oracle.install.db.config.starterdb.gridcontrol.gridControlServiceURL"/></oracle_install_db_EMCentralAgentSelected>
			<oracle_install_db_EMSMTPServer><xsl:value-of select="oracle.install.db.config.starterdb.dbcontrol.SMTPServer"/></oracle_install_db_EMSMTPServer>
			<oracle_install_db_EMEmailAddress><xsl:value-of select="oracle.install.db.config.starterdb.dbcontrol.emailAddress"/></oracle_install_db_EMEmailAddress>
			<oracle_install_db_ReceiveEmailNotification><xsl:value-of select="oracle.install.db.config.starterdb.dbcontrol.enableEmailNotification"/></oracle_install_db_ReceiveEmailNotification>      
	
			<RemoveHomes>false</RemoveHomes>
			<RESTART_REMOTE_SYSTEM>false</RESTART_REMOTE_SYSTEM>
			<RESTART_SYSTEM>false</RESTART_SYSTEM>
	    </DBInstallSettings>
	</DBSetupBean>
</beanstore>
</xsl:template>
<xsl:template name="toValueList">
	<xsl:param name="stringList"/>
	<xsl:if test="$stringList and string-length($stringList) > 0">
		<xsl:choose>
		   <xsl:when test="contains($stringList, ',')">
	           <value><xsl:value-of select="substring-before($stringList,',')" /></value>
	           <xsl:call-template name="toValueList">
		           <xsl:with-param name="stringList" select="substring-after($stringList,',')" />
	           </xsl:call-template>
	       </xsl:when>
		    <xsl:otherwise>
		       <value><xsl:value-of select="$stringList" /></value>
		    </xsl:otherwise>
	 	</xsl:choose>		
	 </xsl:if>
</xsl:template>
</xsl:stylesheet>
