<?xml version="1.0"?>
<!--
 Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 

   NAME
     rspfmt_raw2ext_transformer_v11_2_0_1.xsl - XSLT to transform internal database response file format to external property file format

   DESCRIPTION
     <short description of component this file declares/defines>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
      rmallego 02/17/10 - adding comment section for INVENTORY_LOCATION
      rochang  10/23/09 - XbranchMerge dschrein_bug_8808422_rm_odp_ode_net from
                          main
      rmallego 07/15/09 - XbranchMerge rmallego_bug-8679371 from main
      dschrein 08/19/09 - remove ode_net and odp_net
      pvallam  04/07/09 - updating the format of response file version
      sangkuma 03/04/09 - Retaining the names of other OUI session variables
      sangkuma 02/22/09 - Changing oracle.install.*.ORACLE_* variables to
                          ORACLE_*
      dschrein 02/17/09 - correct list of comps in comments section
      sangkuma 01/05/09 - Using the MYORACLESUPPORT_* convention
      sangkuma 12/30/08 - Fixing comments for product languages property
      sangkuma 11/10/08 - Changing METALINK to MYORACLESUPPORT
      sangkuma 11/02/08 - Modifying to integrate with new OUIs OCM
      poosrini 06/24/08 - text changes in comments sections
      msubbann 05/28/08 - Add comment for memoryLimit
      msubbann 05/12/08 - Take off ORACLE_HOME_NAME
      poosrini 04/09/08 - upgrade - no SID is needed
      msubbann 03/21/08 - Correct the logic for storageType variable
      aqazi    03/19/08 - b_useRegistration will be forced to take same valueas
                          b_acceptLicense. This applies to OCM
      sangkuma 03/12/08 - Setting OPER Group
      sangkuma 03/11/08 - change the property name of
                          oracle.install.OPERGroupNameUsed to
                          UNIX_GROUP_NAME
      msubbann 02/19/08 - Use InstallType in place of InstallTypeShortDesc
      msubbann 02/13/08 - Add oracle.install.customComponents
      pvallam  02/07/08 - updating character set key
      poosrini 01/24/08 -
      sangkuma 12/06/07 - XSLT to transform internal database response file format to external format
      sangkuma 12/06/07 - Creation
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" indent="false"></xsl:output>
<xsl:template match="beanstore">
#-------------------------------------------------------------------------------
# Do not change the following system generated value. 
#-------------------------------------------------------------------------------
oracle.install.responseFileVersion=/oracle/install/rspfmt_dbinstall_response_schema_v11_2_0

#-------------------------------------------------------------------------------
# The installation option can be one of the following
# 1. INSTALL_DB_SWONLY
# 2. INSTALL_DB_AND_CONFIG
# 3. UPGRADE_DB
#-------------------------------------------------------------------------------
oracle.install.option=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_InstallOption"/>

#-------------------------------------------------------------------------------
# This variable holds the hostname of the system as set by the user. 
# It can be used to force the installation to use an alternative   
# hostname rather than using the first hostname found on the system
# (e.g., for systems with multiple hostnames and network interfaces).
#-------------------------------------------------------------------------------
ORACLE_HOSTNAME=<xsl:value-of select="DBSetupBean/ORACLE_HOSTNAME"/>

#-------------------------------------------------------------------------------
# Unix group to be set for the inventory directory.  
#-------------------------------------------------------------------------------
UNIX_GROUP_NAME=<xsl:value-of select="DBSetupBean/CentralInventorySettings/UNIX_GROUP_NAME"/>

#-------------------------------------------------------------------------------
# Specify the location which holds the inventory files.
# This is an optional parameter if installing on
# Windows based Operating System.
#-------------------------------------------------------------------------------
INVENTORY_LOCATION=<xsl:value-of select="DBSetupBean/CentralInventorySettings/INVENTORY_LOCATION"/>

#-------------------------------------------------------------------------------
# Specify the languages in which the components will be installed.             
#
# en   : English                  ja   : Japanese                  
# fr   : French                   ko   : Korean                    
# ar   : Arabic                   es   : Latin American Spanish    
# bn   : Bengali                  lv   : Latvian                   
# pt_BR: Brazilian Portuguese     lt   : Lithuanian                
# bg   : Bulgarian                ms   : Malay                     
# fr_CA: Canadian French          es_MX: Mexican Spanish           
# ca   : Catalan                  no   : Norwegian                 
# hr   : Croatian                 pl   : Polish                    
# cs   : Czech                    pt   : Portuguese                
# da   : Danish                   ro   : Romanian                  
# nl   : Dutch                    ru   : Russian                   
# ar_EG: Egyptian                 zh_CN: Simplified Chinese        
# en_GB: English (Great Britain)  sk   : Slovak                    
# et   : Estonian                 sl   : Slovenian                 
# fi   : Finnish                  es_ES: Spanish                   
# de   : German                   sv   : Swedish                   
# el   : Greek                    th   : Thai                      
# iw   : Hebrew                   zh_TW: Traditional Chinese       
# hu   : Hungarian                tr   : Turkish                   
# is   : Icelandic                uk   : Ukrainian                 
# in   : Indonesian               vi   : Vietnamese                
# it   : Italian                                                   
#
# Example : SELECTED_LANGUAGES=en,fr,ja
#-------------------------------------------------------------------------------
SELECTED_LANGUAGES=<xsl:call-template name="toStringList"><xsl:with-param name="valueList" select="DBSetupBean/SELECTED_LANGUAGES"/></xsl:call-template>

#-------------------------------------------------------------------------------
# Complete path of the Oracle Home  
#-------------------------------------------------------------------------------
ORACLE_HOME=<xsl:value-of select="DBSetupBean/DBInstallSettings/ORACLE_HOME"/>

#-------------------------------------------------------------------------------
# Complete path of the Oracle Base. 
#-------------------------------------------------------------------------------
ORACLE_BASE=<xsl:value-of select="DBSetupBean/DBInstallSettings/ORACLE_BASE"/>

#-------------------------------------------------------------------------------
# Installation Edition of the component.                        
#                                                             
# The value should contain only one of these choices.        
# EE     : Enterprise Edition                                
# SE     : Standard Edition                                  
# SEONE  : Standard Edition One
# PE     : Personal Edition (WINDOWS ONLY)
#-------------------------------------------------------------------------------
oracle.install.db.InstallEdition=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_InstallEdition"/>

#-------------------------------------------------------------------------------
# This property is considered only if InstallEdition is EE.
#
# true  : Components mentioned as part of 'customComponents' property
#         are considered for install.
# false : Value for 'customComponents' is not considered.
#-------------------------------------------------------------------------------
oracle.install.db.isCustomInstall=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_CustomInstall"/>

#-------------------------------------------------------------------------------
# This property is considered only if 'IsCustomInstall' is set to true 
#
# Description: List of Enterprise Edition Options you would like to install.
#
#              The following choices are available. You may specify any
#              combination of these choices.  The components you choose should
#              be specified in the form "internal-component-name:version"
#              Below is a list of components you may specify to install.
#        
#              oracle.oraolap:11.2.0.0.2 - Oracle OLAP
#              oracle.rdbms.dm:11.2.0.0.2 - Oracle Data Mining RDBMS Files
#              oracle.rdbms.dv:11.2.0.0.2 - Oracle Database Vault option
#              oracle.rdbms.lbac:11.2.0.0.2 - Oracle Label Security
#              oracle.rdbms.partitioning:11.2.0.0.2 - Oracle Partitioning
#              oracle.rdbms.rat:11.2.0.0.2 - Oracle Real Application Testing
#              oracle.clrintg.ode_net_2:11.2.0.0.2 - Oracle Database Extensions for .NET 2.0 (Windows)
#-------------------------------------------------------------------------------
oracle.install.db.customComponents=<xsl:call-template name="toStringList"><xsl:with-param name="valueList" select="DBSetupBean/DBInstallSettings/oracle_install_db_CustomComponents"/></xsl:call-template>

###############################################################################
#                                                                             #
# PRIVILEGED OPERATING SYSTEM GROUPS                                          #
# ------------------------------------------                                  #
# Provide values for the OS groups to which OSDBA and OSOPER privileges       #
# needs to be granted. If the install is being performed as a member of the   #
# group "dba", then that will be used unless specified otherwise below.       #
#                                                                             #
# The value to be specified for OSDBA and OSOPER group is only for UNIX based #
# Operating System.                                                           #
#                                                                             #
###############################################################################

#-------------------------------------------------------------------------------
oracle.install.db.DBA_GROUP=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_OSDBA"/>

#-------------------------------------------------------------------------------
oracle.install.db.OPER_GROUP=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_OSOPER"/>

#-------------------------------------------------------------------------------
# This variable represents the cluster node names selected by the .  
# user for installation                                      
# Example : oracle.install.db.CLUSTER_NODES=node1,node2
#-------------------------------------------------------------------------------
oracle.install.db.CLUSTER_NODES=<xsl:call-template name="toStringList"><xsl:with-param name="valueList" select="DBSetupBean/DBInstallSettings/CLUSTER_NODES"/></xsl:call-template>

#-------------------------------------------------------------------------------
# One of the following
# - GENERAL_PURPOSE                              
# - TRANSACTION_PROCESSING                       
# - DATAWAREHOUSE                                
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.type=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_StarterDatabaseType"/>

#-------------------------------------------------------------------------------
# Global Database Name 
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.globalDBName=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_GlobalDBName"/>

#-------------------------------------------------------------------------------
# The Starter Database SID 
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.SID=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_SID"/>

#-------------------------------------------------------------------------------
# Database character set
#                                               
#  One of the following
#  AL32UTF8, WE8ISO8859P15, WE8MSWIN1252, EE8ISO8859P2,
#  EE8MSWIN1250, NE8ISO8859P10, NEE8ISO8859P4, BLT8MSWIN1257,
#  BLT8ISO8859P13, CL8ISO8859P5, CL8MSWIN1251, AR8ISO8859P6,
#  AR8MSWIN1256, EL8ISO8859P7, EL8MSWIN1253, IW8ISO8859P8,
#  IW8MSWIN1255, JA16EUC, JA16EUCTILDE, JA16SJIS, JA16SJISTILDE,
#  KO16MSWIN949, ZHS16GBK, TH8TISASCII, ZHT32EUC, ZHT16MSWIN950,
#  ZHT16HKSCS, WE8ISO8859P9, TR8MSWIN1254, VN8MSWIN1258
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.characterSet=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_CharacterSet"/>
#-------------------------------------------------------------------------------
# Specify the total memory allocation for the database. (in MB)
# Value should be at least 256 MB, and should not exceed the  
# total physical memory available on the system.
# Example: oracle.install.db.config.starterdb.memoryLimit=40
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.memoryLimit=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_AllocatedMemory"/>
oracle.install.db.config.starterdb.memoryOption=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_AutoMemoryOption"/>

#-------------------------------------------------------------------------------
# This variable controls whether to load Example Schemas onto
# the starter database or not.
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.installExampleSchemas=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_LoadExampleSchemas"/>

#-------------------------------------------------------------------------------
# This include enabling audit settings, configuring password  
# profiles and revoking some grants to public. These settings 
# are provided by default.  You may choose to disable all.    
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.enableSecuritySettings=<xsl:choose><xsl:when test="DBSetupBean/DBInstallSettings/oracle_install_db_SecureConfigDisabled = 'true'">false</xsl:when><xsl:otherwise>true</xsl:otherwise></xsl:choose>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.password.ALL=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_SuperAdminSamePasswdForAll"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.password.SYS=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_SuperAdminPasswords/value[1]"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.password.SYSTEM=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_SuperAdminPasswords/value[2]"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.password.SYSMAN=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_SuperAdminPasswords/value[3]"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.password.DBSNMP=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_SuperAdminPasswords/value[4]"/>

#-------------------------------------------------------------------------------
# Can be one of the following 
# 1. GRID_CONTROL
# 2. DB_CONTROL
# 
oracle.install.db.config.starterdb.control=<xsl:choose><xsl:when test="DBSetupBean/DBInstallSettings/oracle_install_db_UseDBControl = 'true'">DB_CONTROL</xsl:when><xsl:otherwise>GRID_CONTROL</xsl:otherwise></xsl:choose>

#-------------------------------------------------------------------------------
# Determines the Management Service to use if Grid Control   
# is selected to manage the database.      
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.gridcontrol.gridControlServiceURL=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_EMCentralAgentSelected"/>

#-------------------------------------------------------------------------------
# Determines whether to receive email notification for       
# critical alerts when using DB control.   
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.dbcontrol.enableEmailNotification=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_ReceiveEmailNotification"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.dbcontrol.emailAddress=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_EMEmailAddress"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.dbcontrol.SMTPServer=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_EMSMTPServer"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.automatedBackup.enable=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_EnableAutoBackup"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.automatedBackup.osuid=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_RecoveryBackUpUsername"/>

#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.automatedBackup.ospwd=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_RecoveryBackUpPassword"/>

#-------------------------------------------------------------------------------
# Can be one of the following
# - FILE_SYSTEM_STORAGE
# - ASM_STORAGE
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.storageType=<xsl:choose><xsl:when test="DBSetupBean/DBInstallSettings/oracle_install_db_StorageType = 1">FILE_SYSTEM_STORAGE</xsl:when><xsl:when test="DBSetupBean/DBInstallSettings/oracle_install_db_StorageType = 2">ASM_STORAGE</xsl:when></xsl:choose>

#-------------------------------------------------------------------------------
# Database file location:                  
# directory for datafiles, control files, redo logs.         
#
# Applicable only when oracle.install.db.config.starterdb.storage=FILE_SYSTEM_STORAGE 
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.fileSystemStorage.dataLocation=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_MountPointLocation"/>

#-------------------------------------------------------------------------------
# Backup and recovery location 
#
# Applicable only when oracle.install.db.config.starterdb.storage=FILE_SYSTEM_STORAGE 
#-------------------------------------------------------------------------------
oracle.install.db.config.starterdb.fileSystemStorage.recoveryLocation=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_RecoveryBackUpLocation"/>

#-------------------------------------------------------------------------------
# Name of ASM disk group to be used for storage.
#
# Applicable only when oracle.install.db.config.starterdb.storageType=ASM_STORAGE
#-------------------------------------------------------------------------------
oracle.install.db.config.asm.diskGroup=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_DiskGroupNameForASM"/>

#-------------------------------------------------------------------------------
# Password for ASMSNMP user of the ASM instance.                  
#
# Applicable only when oracle.install.db.config.starterdb.storage=ASM_STORAGE 
#-------------------------------------------------------------------------------
oracle.install.db.config.asm.ASMSNMPPassword=<xsl:value-of select="DBSetupBean/DBInstallSettings/oracle_install_db_ASMSNMPUserPassword"/>

#------------------------------------------------------------------------------
# Specify the My Oracle Support Account Username.
#
#  Example   : MYORACLESUPPORT_USERNAME=metalink
#------------------------------------------------------------------------------
MYORACLESUPPORT_USERNAME=<xsl:value-of select="DBSetupBean/OCMSettings/MYORACLESUPPORT_USERNAME"/>

#------------------------------------------------------------------------------
# Specify the My Oracle Support Account Username password.
#
# Example    : MYORACLESUPPORT_PASSWORD=password
#------------------------------------------------------------------------------
MYORACLESUPPORT_PASSWORD=<xsl:value-of select="DBSetupBean/OCMSettings/MYORACLESUPPORT_PASSWORD"/>

#------------------------------------------------------------------------------
# Specify whether to enable the user to set the password for
# My Oracle Support credentials. The value can be either true or false.
# If left blank it will be assumed to be false.
#
# Example    : SECURITY_UPDATES_VIA_MYORACLESUPPORT=true
#------------------------------------------------------------------------------
SECURITY_UPDATES_VIA_MYORACLESUPPORT=<xsl:value-of select="DBSetupBean/OCMSettings/SECURITY_UPDATES_VIA_MYORACLESUPPORT"/>

#------------------------------------------------------------------------------
# Specify whether user doesn't want to configure Security Updates.
# The value for this variable should be true if you don't want to configure
# Security Updates, false otherwise.
#
# The value can be either true or false. If left blank it will be assumed
# to be false.
#
# Example    : DECLINE_SECURITY_UPDATES=false
#------------------------------------------------------------------------------
DECLINE_SECURITY_UPDATES=<xsl:value-of select="DBSetupBean/OCMSettings/DECLINE_SECURITY_UPDATES"/>

#------------------------------------------------------------------------------
# Specify the Proxy server name. Length should be greater than zero.
#
# Example    : PROXY_HOST=proxy.domain.com 
#------------------------------------------------------------------------------
PROXY_HOST=<xsl:value-of select="DBSetupBean/OCMSettings/PROXY_HOST"/>

#------------------------------------------------------------------------------
# Specify the proxy port number. Should be Numeric and atleast 2 chars.
#
# Example    : PROXY_PORT=25 
#------------------------------------------------------------------------------
PROXY_PORT=<xsl:value-of select="DBSetupBean/OCMSettings/PROXY_PORT"/>

#------------------------------------------------------------------------------
# Specify the proxy user name. Leave PROXY_USER and PROXY_PWD
# blank if your proxy server requires no authentication.
#
# Example    : PROXY_USER=username
#------------------------------------------------------------------------------
PROXY_USER=<xsl:value-of select="DBSetupBean/OCMSettings/PROXY_USER"/>

#------------------------------------------------------------------------------
# Specify the proxy password. Leave PROXY_USER and PROXY_PWD  
# blank if your proxy server requires no authentication.
#
# Example    : PROXY_PWD=password
#------------------------------------------------------------------------------
PROXY_PWD=<xsl:value-of select="DBSetupBean/OCMSettings/PROXY_PWD"/>
</xsl:template>
<xsl:template name="toStringList">
<xsl:param name="valueList"/>
<xsl:variable name="valueCount" select="count($valueList/value)"/>
<xsl:for-each select="$valueList/value"><xsl:value-of select="."/><xsl:if test="$valueCount > position()">,</xsl:if></xsl:for-each>	
</xsl:template>
</xsl:stylesheet>
