# $Header: emagent/sysman/admin/scripts/Ptdpm12.pm /st_emagent_10.2.0.4.2db11.2/1 2008/11/07 01:47:21 nparaddi Exp $
#
# Package : Ptdpm12.pm
#
# Copyright (c) 2002, 2008, Oracle and/or its affiliates.All rights reserved. 
#
#   NAME
#       Ptdpm12.pm
#
#   DESCRIPTION
#       Collects Mounted File System Details
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      anusharm   11/24/05 - Backport anusharm_bug-4743802 from main 
#      anusharm   11/17/05 - adding ocfs to filesystems 
#      mgoodric   09/27/04 - code cleanup 
#      mgoodric   09/23/04 - ignore autofs files systems
#      mgoodric   03/21/04 - Linux cleanup
#      mgoodric   06/16/03 - fix converting Solaris timezone to JAVA timezones
#      mgoodric   05/11/03 - added -debug tracing
#      mgoodric   04/08/03 - fix finding MAC address
#      rlal       02/25/03 - EM 4.0 changed for Linux
#      goramamo   10/23/02 - removed mount time
#      goramamo   08/16/02 - Mount option fix
#      xxu        06/25/02 - remove /usr/local/bin/perl
#      vkhizder   06/20/02 - vkhizder_compare_fix_2420795_collection_script_changes
#      goramamo   06/11/02 - Creation (GIT5)
#
##*************************************************************

use strict;

package Ptdpm12;

use Carp;
require 5.005;

#require 5.6.1;
require Exporter;

use Ptdpm0;
use Ptdpm2;
use Ptdpm3;
use Ptdpm11;

#******************************************
#     Global Variables
#******************************************

use constant NIL => '';

@Ptdpm12::FS = ('nfs', 'ocfs', 'ocfs2', 'ufs', 'vxfs', 'jfs', 'ext3', 'ext2');

#******************************************
#   Export Subroutines
#******************************************

@Ptdpm12::ISA    = ('Exporter');
@Ptdpm12::EXPORT = qw(
  &getMountedFileSystemDetails
  );

#******************************************
#   Exported Subroutines
#******************************************

sub getMountedFileSystemDetails
{
    debugTrace('Calling... getMountedFileSystemDetails()');

    my @fsdata = ();
    my $file   = getEtcMnttabLocation();
    if ($file eq NIL)
    { 
        return @fsdata;
    }

    my @att       = ();
    my @autofs    = ();
    my $automount = NIL;
    my $flag      = 'false';
    my $rest      = NIL;
    my $i         = 0;
    my $j         = 0;

    debugTrace('Opening... ' . $file);
    open(MNT, $file);
    LOOP: while (<MNT>)
    {
        # /dev/hda1 / ext3 rw 0 0
        # automount(pid1633) /home autofs rw,fd=5,pgrp=1633,minproto=2,maxproto=4 0 0
        # host1:/vol/home1/user /home/user nfs rw,tcp,intr,timeo=600,rsize=8192,wsize=8192,addr=0.0.0.0 0 0

        @att = split (' ', $_);
        $flag = doesContain($att[2]);
        if ($flag eq 'true')
        {
            foreach $automount (@autofs)
            {
                next LOOP if ($att[1] =~ m~^$automount/~);
            }
            $fsdata[$i][0] = joinValue($Ptdpm2::RESOURCE_NAME_TAG,  $att[0]);
            $fsdata[$i][1] = joinValue($Ptdpm2::MOUNT_LOCATION_TAG, $att[1]);
            $fsdata[$i][2] = joinValue($Ptdpm2::TYPE_TAG,           $att[2]);
            $fsdata[$i][3] = joinValue($Ptdpm2::MOUNT_OPTIONS_TAG,  NIL);
            ($att[3], $rest) = split (",dev=", $att[3], 2);
            if (!(index($att[3], "dev=") > -1))
            {
                $fsdata[$i][3] = joinValue($Ptdpm2::MOUNT_OPTIONS_TAG, $att[3]);
            }
            $i++;
        }
        elsif ($att[2] eq 'autofs')
        {
            $autofs[$j++] = $att[1];
        }
    }
    close(MNT);

    return @fsdata;
}

#******************************************
#   Non-Exported Subroutines
#******************************************

sub doesContain($)
{
    my ($str)  = @_;
    my $i      = 0;
    my $flag   = 'false';
    my $NoOfFS = scalar(@Ptdpm12::FS);

    for ($i = 0 ; $i < $NoOfFS ; $i++)
    {
        if ($str eq $Ptdpm12::FS[$i])
        {
            $flag = 'true';
            last;
        }

    }

    return $flag;
}

1;

# End of the Program
