# $Header: emagent/sysman/admin/scripts/Ptdpm14.pm /st_emagent_10.2.0.4.2db11.2/1 2008/11/07 01:47:21 nparaddi Exp $
#
# Package : Ptdpm14.pm
#
# Copyright (c) 2002, 2008, Oracle and/or its affiliates.All rights reserved. 
#
#   NAME
#       Ptdpm14.pm
#
#   DESCRIPTION
#       Collects Network Interface details
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      jashukla   06/03/08 - Bug 7144619 remove internal identifiers
#      mgoodric   11/22/05 - Backport mgoodric_bug-4716787 from main 
#      mgoodric   11/03/05 - fix for incorrect RHEL-4 NIC info
#      mgoodric   09/27/04 - code cleanup
#      mgoodric   03/20/04 - Fix MASK,BROADCAST_ADDRESS for lo
#      mgoodric   05/11/03 - added -debug tracing
#      rlal       04/18/03 - bug 2873199, 2906734 and 2893883
#      mgoodric   04/08/03 - fix finding MAC address
#      rlal       02/25/03 - EM 4.0 changed for Linux
#      goramamo   12/12/02 - Changes for SPARC III+ machines
#      goramamo   09/03/02 - goramamo_nic_flags_correction
#      goramamo   09/03/02 - Created by removing the code in Ptdpm1.pm
#                            for better maintenance
#
##*************************************************************

use strict;

package Ptdpm14;

use Carp;
require 5.005;

#require 5.6.1;
require Exporter;

use Ptdpm0;
use Ptdpm2;
use Ptdpm3;

#******************************************
#   Export Subroutines
#******************************************

@Ptdpm14::ISA    = ('Exporter');
@Ptdpm14::EXPORT = qw(
  &getNetworkInterfaceDetails
);

#******************************************
#     Global Variables
#******************************************

use constant NIL => '';

#******************************************
#   Exported Subroutines
#******************************************

sub getNetworkInterfaceDetails
{
    debugTrace('Calling... getNetworkInterfaceDetails()');

    my @nicdata = ();

    # $nicdata[j+0] = $Ptdpm2::NIC_NAME_TAG;
    # $nicdata[j+1] = $Ptdpm2::FLAGS_TAG;
    # $nicdata[j+2] = $Ptdpm2::MAX_TRANSFER_UNIT_TAG;
    # $nicdata[j+3] = $Ptdpm2::INET_ADDRESS_TAG;
    # $nicdata[j+4] = $Ptdpm2::MASK_TAG;
    # $nicdata[j+5] = $Ptdpm2::BROADCAST_ADDRESS_TAG;
    # $nicdata[j+6] = $Ptdpm2::MAC_ADDRESS_TAG;
    # $nicdata[j+7] = $Ptdpm2::HOSTNAME_ALIASES_TAG;

    my $bcad  = NIL;
    my $mac   = NIL;
    my $MTU   = NIL;
    my $flags = NIL;
    my $inet  = NIL;
    my $mask  = NIL;
    my @nic1  = ();
    my @nic4  = ();
    my @nic7  = ();
    my $i     = 0;
    my $j     = 0;
    my $l     = 0;
    my $n     = 0;

    my @nicdetail = ();
    my $NAME_IDX  = 0;
    my $INET_IDX  = 1;
    my $MTU_IDX   = 2;    # RHEL-4 may have moved it to line 3

    my @nic      = getNICDetails();
    my $NoOfNICs = scalar(@nic);

    # eth0      Link encap:Ethernet  HWaddr 00:80:3F:2B:B8:86
    # eth1      Link encap:Ethernet  HWaddr 00:80:3F:2B:B8:87
    # lo        Link encap:Local Loopback
    # sit0      Link encap:IPv6-in-IPv4

    for ($i = 0 ; $i < $NoOfNICs ; $i++)
    {
        @nic1 = split(' ', $nic[$i]);

        chomp(@nicdetail = `$Ptdpm0::IFCONFIG $nic1[$NAME_IDX]`);
        my $NoOfLines = scalar(@nicdetail);

        # eth0      Link encap:Ethernet  HWaddr 00:80:3F:2B:B8:86
        #           inet addr:140.87.100.69  Bcast:140.87.103.255  Mask:255.255.252.0
        #           inet6 addr: fe80::280:3fff:fe2b:b886/64 Scope:Link
        #           UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
        #           RX packets:181859269 errors:0 dropped:0 overruns:0 frame:0
        #           TX packets:6821750 errors:0 dropped:0 overruns:0 carrier:0
        #           collisions:0 txqueuelen:1000
        #           RX bytes:2313532567 (2.1 GiB)  TX bytes:1079842107 (1.0 GiB)
        #           Base address:0x2000 Memory:dd200000-dd220000

        for ($MTU_IDX = 1 ; $MTU_IDX < $NoOfLines ; $MTU_IDX++)
        {
            last if ($nicdetail[$MTU_IDX] =~ m/MTU:/);
        }
        $MTU_IDX = -1 if ($MTU_IDX == $NoOfLines);

        for ($INET_IDX = 1 ; $INET_IDX < $NoOfLines ; $INET_IDX++)
        {
            last if ($nicdetail[$INET_IDX] =~ m/inet addr:/);
        }
        $INET_IDX = -1 if ($INET_IDX == $NoOfLines);

        $flags = NIL;
        $MTU   = NIL;

        # UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
        if ($MTU_IDX != -1)
        {

            # Sort the flags in alphabetical order to make comparison easier
            #  in: UP BROADCAST RUNNING MULTICAST
            # out: BROADCAST,MULTICAST,RUNNING,UP
            @nic4  = split(' ', left("MTU:", $nicdetail[$MTU_IDX]));
            @nic7  = sort(@nic4);
            $flags = trim(join(",", @nic7));
            $MTU   = right("MTU:", left("Metric:", $nicdetail[$MTU_IDX]));
        }

        $inet = NIL;
        $mask = NIL;
        $bcad = NIL;

        # inet addr:140.87.100.69  Bcast:140.87.103.255  Mask:255.255.252.0
        if ($INET_IDX != -1)
        {
            $inet = right("inet addr:", left("Mask:", $nicdetail[$INET_IDX]));
            $inet = left(' ', $inet) if ($inet =~ m/ /);
            $mask = right("Mask:", $nicdetail[$INET_IDX])
              if ($nicdetail[$INET_IDX] =~ m/Mask:/);
            $bcad = right("Bcast:", left("Mask:", $nicdetail[$INET_IDX]))
              if ($nicdetail[$INET_IDX] =~ m/Bcast:/);
        }

        $mac = NIL;

        # eth0      Link encap:Ethernet  HWaddr 00:80:3F:2B:B8:86
        $mac = right("HWaddr", $nicdetail[$NAME_IDX])
          if ($nicdetail[$NAME_IDX] =~ m/ HWaddr /);

        my $aliases = NIL;

        # 123.123.123.123    host.example.com host
        $aliases = getAdminEntries("hosts $inet") if ($inet =~ m/\./);
        my @hosts     = split(' ', $aliases);
        my $NoOfHosts = scalar(@hosts);
        my @hostnames = ();
        $n = 0;
        for ($l = 0 ; $l < $NoOfHosts ; $l++)
        {

            if ((index($aliases, $Ptdpm0::hostname) > -1) && ($n == 0))
            {
                $hostnames[$n++] = $Ptdpm0::hostname;
            }
            elsif ($hosts[$l] eq $inet || $hosts[$l] eq $Ptdpm0::hostname) { }
            else
            {
                $hostnames[$n++] = $hosts[$l];
            }
        }

        $aliases = join(',', @hostnames);

        $nicdata[$j++] = joinValue($Ptdpm2::NIC_NAME_TAG,          $nic1[$NAME_IDX]);
        $nicdata[$j++] = joinValue($Ptdpm2::FLAGS_TAG,             $flags);
        $nicdata[$j++] = joinValue($Ptdpm2::MAX_TRANSFER_UNIT_TAG, $MTU);
        $nicdata[$j++] = joinValue($Ptdpm2::INET_ADDRESS_TAG,      $inet);
        $nicdata[$j++] = joinValue($Ptdpm2::MASK_TAG,              $mask);
        $nicdata[$j++] = joinValue($Ptdpm2::BROADCAST_ADDRESS_TAG, $bcad);
        $nicdata[$j++] = joinValue($Ptdpm2::MAC_ADDRESS_TAG,       $mac);
        $nicdata[$j++] = joinValue($Ptdpm2::HOSTNAME_ALIASES_TAG,  $aliases);
    }

    return @nicdata;
}

1;

# End of the Program
