# $Header: emagent/sysman/admin/scripts/Ptdpm15.pm /st_emagent_10.2.0.4.2db11.2/1 2008/11/07 01:47:21 nparaddi Exp $
#
# Package : Ptdpm15.pm
#
# Copyright (c) 2002, 2008, Oracle and/or its affiliates.All rights reserved. 
#
#   NAME
#       Ptdpm15.pm
#
#   DESCRIPTION
#       Checks NOT NULL colums and throws error messages
#       returns empty array
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      mgoodric   11/17/04 - add MGMT_HC_xxx tablenames 
#      mgoodric   09/27/04 - code cleanup 
#      mgoodric   03/21/04 - Linux cleanup
#      mgoodric   04/08/03 - fix finding MAC address
#      rmenon     10/19/02 - rmenon_bug_fixes_and_rt_changes
#      goramamo   10/12/02 - Creation
#
##*************************************************************

use strict;

package Ptdpm15;

use Carp;
require 5.005;

#require 5.6.1;
require Exporter;

use ecmErrorMsgs;
use Ptdpm2;

#******************************************
#   Export Subroutines
#******************************************

@Ptdpm15::ISA    = ('Exporter');
@Ptdpm15::EXPORT = qw(
  &verifyNotNullFields
  );

#******************************************
#     Global Variables
#******************************************

use constant NIL => '';

# List all NON NULL tags

@Ptdpm15::MGMT_HC_SYSTEM_SUMMARY   = ($Ptdpm2::HOSTNAME_TAG);

@Ptdpm15::MGMT_HC_HARDWARE_MASTER  = ();

@Ptdpm15::MGMT_HC_CPU_DETAILS      = ();

@Ptdpm15::MGMT_HC_IOCARD_DETAILS   = ();

@Ptdpm15::MGMT_HC_NIC_DETAILS      = ();

@Ptdpm15::MGMT_HC_OS_SUMMARY       = ();

@Ptdpm15::MGMT_HC_OS_PROPERTIES    = ($Ptdpm2::NAME_TAG, $Ptdpm2::TYPE_TAG);

@Ptdpm15::MGMT_HC_OS_COMPONENTS    = ($Ptdpm2::NAME_TAG, $Ptdpm2::TYPE_TAG);

@Ptdpm15::MGMT_HC_FS_MOUNT_DETAILS = (
                                      $Ptdpm2::RESOURCE_NAME_TAG, 
                                      $Ptdpm2::MOUNT_LOCATION_TAG
                                     );

@Ptdpm15::MGMT_HC_VENDOR_SUMMARY   = ($Ptdpm2::VENDOR_SOFTWARE_NAME_TAG);

@Ptdpm15::MGMT_HC_VENDOR_SW_COMPONENTS = ($Ptdpm2::NAME_TAG, $Ptdpm2::TYPE_TAG);

#******************************************
#   Exported Subroutines
#******************************************

sub verifyNotNullFields($$)
{
    my ($subcom,$data) = @_;
    my @com      = ();
    my $dataGood = 'false';

    SWITCH:
    {
        $subcom eq $Ptdpm2::MGMT_HC_SYSTEM_SUMMARY && do
        {
            @com = @Ptdpm15::MGMT_HC_SYSTEM_SUMMARY;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_HARDWARE_MASTER && do
        {
            @com = @Ptdpm15::MGMT_HC_HARDWARE_MASTER;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_CPU_DETAILS && do
        {
            @com = @Ptdpm15::MGMT_HC_CPU_DETAILS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_IOCARD_DETAILS && do
        {
            @com = @Ptdpm15::MGMT_HC_IOCARD_DETAILS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_NIC_DETAILS && do
        {
            @com = @Ptdpm15::MGMT_HC_NIC_DETAILS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_OS_SUMMARY && do
        {
            @com = @Ptdpm15::MGMT_HC_OS_SUMMARY;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_OS_PROPERTIES && do
        {
            @com = @Ptdpm15::MGMT_HC_OS_PROPERTIES;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_FS_MOUNT_DETAILS && do
        {
            @com = @Ptdpm15::MGMT_HC_FS_MOUNT_DETAILS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_OS_COMPONENTS && do
        {
            @com = @Ptdpm15::MGMT_HC_OS_COMPONENTS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_VENDOR_SUMMARY && do
        {
            @com = @Ptdpm15::MGMT_HC_VENDOR_SUMMARY;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_VENDOR_SW_COMPONENTS && do
        {
            @com = @Ptdpm15::MGMT_HC_VENDOR_SW_COMPONENTS;
            last SWITCH;
        };
        last SWITCH;
    }

    my @dat = @$data;
    $dataGood = isNull(\@dat, \@com);
    if ($dataGood eq 'false')
    {
        @dat = ();
    }

    return @dat;
}

#******************************************
#     Non-Exported Subroutines
#******************************************

sub isNull($$)
{
    my ($dat,$com) = @_;

    my $dataGood = 'true';
    my $tag      = NIL;
    my $value    = NIL;

    my $size1 = scalar(@$dat);
    my $size2 = scalar(@$com);
    if (($size1 > 0) && ($size2 > 0))
    {
        my $i = 0;
        my $j = 0;
        for ($i = 0 ; $i < $size1 ; $i++)
        {
            ($tag, $value) = split ($Ptdpm2::SEP, @$dat[$i], 2);
            chomp($tag);
            $value = NIL if (!defined $value);
            chomp($value);
            for ($j = 0 ; $j < $size2 ; $j++)
            {
                if (($tag eq @$com[$j]) && ($value eq NIL))
                {
                    throwECMError('Null', " $tag ");
                    $dataGood = 'false';
                }
            }
        }
    }

    return $dataGood;
}

1;

# End of the Program
