# $Header: emagent/sysman/admin/scripts/Ptdpm16.pm /st_emagent_10.2.0.4.2db11.2/1 2008/11/07 01:47:21 nparaddi Exp $
#
# Package : Ptdpm16.pm
#
# Copyright (c) 2002, 2008, Oracle and/or its affiliates.All rights reserved. 
#
#   NAME
#       Ptdpm16.pm
#
#   DESCRIPTION
#       Numeric Check
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      mgoodric   11/17/04 - add MGMT_HC_xxx tablenames 
#      mgoodric   09/27/04 - code cleanup 
#      mgoodric   03/21/04 - Linux cleanup
#      mgoodric   04/08/03 - fix finding MAC address
#      goramamo   10/23/02 - removed mount time
#      rmenon     10/19/02 - rmenon_bug_fixes_and_rt_changes
#      goramamo   09/03/02 - Creation
#
##*************************************************************

use strict;

package Ptdpm16;

use Carp;
require 5.005;

#require 5.6.1;
require Exporter;

use ecmErrorMsgs;
use Ptdpm2;

#******************************************
#   Export Subroutines
#******************************************

@Ptdpm16::ISA    = ('Exporter');
@Ptdpm16::EXPORT = qw(
  &verifyNumericFields
  );

#******************************************
#     Global Variables
#******************************************

use constant NIL => '';

# List all NUMBER tags

@Ptdpm16::MGMT_HC_SYSTEM_SUMMARY    = ();

@Ptdpm16::MGMT_HC_HARDWARE_MASTER   = (
                                       $Ptdpm2::CLOCK_FREQUENCY_IN_MHZ_TAG,
                                       $Ptdpm2::MEMORY_SIZE_IN_MB_TAG,
                                       $Ptdpm2::TOTAL_LOCAL_DISK_SPACE_IN_GB_TAG,
                                       $Ptdpm2::NUMBER_OF_CPUS_TAG,
                                       $Ptdpm2::NUMBER_OF_CPU_BOARDS_TAG,
                                       $Ptdpm2::NUMBER_OF_IO_DEVICES_TAG,
                                       $Ptdpm2::NUMBER_OF_FANS_TAG,
                                       $Ptdpm2::NUMBER_OF_POWER_SUPPLIES_TAG
                                      );

@Ptdpm16::MGMT_HC_CPU_DETAILS       = (
                                       $Ptdpm2::CPU_SPEED_IN_MHZ_TAG,
                                       $Ptdpm2::ECACHE_IN_MB_TAG
                                      );

@Ptdpm16::MGMT_HC_IOCARD_DETAILS    = ($Ptdpm2::FREQUENCY_IN_MHZ_TAG);

@Ptdpm16::MGMT_HC_NIC_DETAILS       = ($Ptdpm2::MAX_TRANSFER_UNIT_TAG);

@Ptdpm16::MGMT_HC_OS_SUMMARY        = ($Ptdpm2::OS_MAX_SWAP_SPACE_IN_MB_TAG);

@Ptdpm16::MGMT_HC_OS_PROPERTIES     = ();

@Ptdpm16::MGMT_HC_OS_COMPONENTS     = ();

@Ptdpm16::MGMT_HC_FS_MOUNT_DETAILS  = ();

@Ptdpm16::MGMT_HC_VENDOR_SW_SUMMARY = ();

@Ptdpm16::MGMT_HC_VENDOR_SW_COMPONENTS = ();

#******************************************
#   Exported Subroutines
#******************************************

sub verifyNumericFields($$)
{
    my ($subcom,$data) = @_;
    my @com      = ();
    my $dataGood = 'false';

    SWITCH:
    {
        $subcom eq $Ptdpm2::MGMT_HC_SYSTEM_SUMMARY && do
        {
            @com = @Ptdpm16::MGMT_HC_SYSTEM_SUMMARY;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_HARDWARE_MASTER && do
        {
            @com = @Ptdpm16::MGMT_HC_HARDWARE_MASTER;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_CPU_DETAILS && do
        {
            @com = @Ptdpm16::MGMT_HC_CPU_DETAILS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_IOCARD_DETAILS && do
        {
            @com = @Ptdpm16::MGMT_HC_IOCARD_DETAILS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_NIC_DETAILS && do
        {
            @com = @Ptdpm16::MGMT_HC_NIC_DETAILS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_OS_SUMMARY && do
        {
            @com = @Ptdpm16::MGMT_HC_OS_SUMMARY;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_OS_PROPERTIES && do
        {
            @com = @Ptdpm16::MGMT_HC_OS_PROPERTIES;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_FS_MOUNT_DETAILS && do
        {
            @com = @Ptdpm16::MGMT_HC_FS_MOUNT_DETAILS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_OS_COMPONENTS && do
        {
            @com = @Ptdpm16::MGMT_HC_OS_COMPONENTS;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_VENDOR_SUMMARY && do
        {
            @com = @Ptdpm16::MGMT_HC_VENDOR_SUMMARY;
            last SWITCH;
        };
        $subcom eq $Ptdpm2::MGMT_HC_VENDOR_SW_COMPONENTS && do
        {
            @com = @Ptdpm16::MGMT_HC_VENDOR_SW_COMPONENTS;
            last SWITCH;
        };
        last SWITCH;
    }

    my @dat = @$data;
    $dataGood = isNumeric(\@dat, \@com);
    if ($dataGood eq 'false')
    {
        @dat = ();
    }

    return @dat;
}

#******************************************
#     Non-Exported Subroutines
#******************************************

sub isNumeric($$)
{
    my ($dat,$com) = @_;
    my $out = ();

    my $tag      = NIL;
    my $value    = NIL;
    my $dataGood = 'true';

    my $size1 = scalar(@$dat);
    my $size2 = scalar(@$com);
    if (($size1 > 0) && ($size2 > 0))
    {
        my $i = 0;
        my $j = 0;
        for ($i = 0 ; $i < $size1 ; $i++)
        {
            ($tag, $value) = split ($Ptdpm2::SEP, @$dat[$i], 2);
            chomp($tag);
            $value = NIL if (!defined $value);
            chomp($value);
            for ($j = 0 ; $j < $size2 ; $j++)
            {
                if (($tag eq @$com[$j]) && ($value ne NIL))
                {
                    if (!(($value =~ /^[0-9]+$/) || ($value =~ /^\d+\.\d*$/)))
                    {
                        throwECMError('NotNumber', " $tag $value ");
                        $dataGood = 'false';
                    }
                }
            }
        }
    }

    return $dataGood;
}

1;

# End of the Program
