# $Header: emagent/sysman/admin/scripts/Ptdpm7.pm /st_emagent_10.2.0.4.2db11.2/1 2008/11/07 01:47:21 nparaddi Exp $
#
# Package : Ptdpm7.pm
#
# Copyright (c) 2002, 2008, Oracle and/or its affiliates.All rights reserved. 
#
#   NAME
#       Ptdpm7.pm
#
#   DESCRIPTION
#       Collects opertating system details
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      mgoodric   11/17/04 - add MGMT_HC_xxx tablenames 
#      mgoodric   09/27/04 - code cleanup 
#      nsharma    03/31/04 - Distribution version only calculated for Red Hat
#      mgoodric   03/19/04 - Fix rounding to 2 decimals
#      nsharma    02/03/04 - Changing UnitedLinux vendor name
#      rlal       01/26/04 - Fix for OS name and cut
#      mgoodric   05/11/03 - added -debug tracing
#      mgoodric   04/08/03 - fix finding MAC address
#      rlal       02/25/03 - EM 4.0 changed for Linux
#      goramamo   08/16/02 - 904  Changes
#      xxu        06/25/02 - remove /usr/local/bin/perl
#      goramamo   06/02/02 - GIT5 Changes
#      jmansur    05/07/02 - sort kernel params by name
#      aarasu     05/06/02 - aarasu_goramamo020506
#      goramamo   05/01/02 - Created by separating OS subroutines
#                            from Ptdpm1.pm
#
##*************************************************************

use strict;

package Ptdpm7;

use Carp;
require 5.005;

#require 5.6.1;
require Exporter;

use Ptdpm0;
use Ptdpm2;
use Ptdpm3;
use Ptdpm9;
use Ptdpm11;
use Ptdpm15;
use Ptdpm16;

#******************************************
#   Export Subroutines
#******************************************

@Ptdpm7::ISA    = ('Exporter');
@Ptdpm7::EXPORT = qw(
  &getOSSummary
  );

#******************************************
#     Global Variables
#******************************************

use constant NIL => '';

#******************************************
#   Exported Subroutines
#******************************************

sub getOSSummary
{
    debugTrace('Calling... getOSSummary()');

    #Arguments:
    #Outputs  : array containing
    #Function : returns os summary

    my @os    = ();
    my @ossum = ();
    my $i     = 0;
    my $info  = NIL;
    my $dist  = $Ptdpm2::NOT_APPLICABLE;

    if (-r "/etc/redhat-release")
    {
        chomp($os[0] = `$Ptdpm0::HEAD -1 /etc/redhat-release`);
        $info = "Red Hat";
        chomp($dist =
           `$Ptdpm0::CAT /proc/version | $Ptdpm0::CUT -f4 -d'(' | $Ptdpm0::CUT -f1 -d')'`);
    }
    elsif (-r "/etc/UnitedLinux-release")
    {
        chomp($os[0] = `$Ptdpm0::HEAD -1 /etc/UnitedLinux-release`);
        $info = "UnitedLinux";
    }
    elsif (-r "/etc/SuSE-release")
    {
        chomp($os[0] = `$Ptdpm0::HEAD -1 /etc/SuSE-release`);
        $info = "SuSE";
    }
    else
    {
        $os[0] = "Linux";
    }

    ($os[1], $os[2]) = split ('-', getOSrelease());

    my $swap = getMaxSwapSpace();
    $swap = sprintf("%.2f", trim($swap) / (1024 * 1024));
    chomp(my $mach = `$Ptdpm0::GETCONF LONG_BIT`);

    $ossum[$i++] = joinValue($Ptdpm2::OS_TAG, $os[0]);
    $ossum[$i++] = joinValue($Ptdpm2::OS_VENDOR_TAG, $info);
    $ossum[$i++] = joinValue($Ptdpm2::OS_BASE_VERSION_TAG, $os[1]);
    $ossum[$i++] = joinValue($Ptdpm2::OS_UPDATE_LEVEL_TAG, $os[2]);
    $ossum[$i++] = joinValue($Ptdpm2::OS_MAX_SWAP_SPACE_IN_MB_TAG, $swap);
    $ossum[$i++] = joinValue($Ptdpm2::OS_DISTRIBUTOR_VERSION_TAG, $dist);
    $ossum[$i++] = joinValue($Ptdpm2::OS_ADDRESS_LENGTH_IN_BITS_TAG, "${mach}-bit");

    @ossum = trim1DimArrayAfterSplit(@ossum);
    @ossum = verifyNotNullFields($Ptdpm2::MGMT_HC_OS_SUMMARY, \@ossum);
    if (scalar(@ossum) > 0)
    {
        @ossum = verifyNumericFields($Ptdpm2::MGMT_HC_OS_SUMMARY, \@ossum);
    }

    return @ossum;
}

1;

# End of the Program
