# $Header: emagent/sysman/admin/scripts/Ptdpm8.pm /st_emagent_10.2.0.4.2db11.2/1 2008/11/07 01:47:21 nparaddi Exp $
#
# Package : Ptdpm8.pm
#
# Copyright (c) 2002, 2008, Oracle and/or its affiliates.All rights reserved. 
#
#   NAME
#       Ptdpm8.pm
#
#   DESCRIPTION
#       Collects OS package and patch details
#       Also collects vendor products details
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      mgoodric   06/10/05 - replace Summary for Description 
#      mgoodric   05/26/05 - restrict length of DESCRIPTION 
#      mgoodric   05/02/05 - convert to UTC times for INSTALLATION_DATE
#      mgoodric   09/27/04 - code cleanup 
#      mgoodric   09/23/04 - fix kernel pkgs for multiple kernels
#      ranmath    09/09/04 - Incorporate mgoodric's rewrite of the script. 
#      ranmath    09/09/04 - Collect Release and Epoch for RPMs besides 
#                            Version. 
#      mgoodric   03/16/04 - Fix for rpm package dates on Linux
#      nsharma    03/24/04 - Fixing installation time for RedHat 3.0 
#      rlal       12/08/03 - Fix for bug 3239537 
#      skumar     11/30/03 - Description can be nil - fix wrong VENDOR XML 
#      mgoodric   11/05/03 - include all packages in OS Components
#      mgoodric   06/16/03 - fix converting Solaris timezone to JAVA timezones
#      mgoodric   05/11/03 - added -debug tracing
#      mgoodric   04/07/03 - fix finding MAC address
#      rlal       02/26/03 - Changes for EM 4.0 Linux
#      goramamo   11/21/02 - Remove hardcode of /var/sadm/pkg
#      goramamo   07/01/22 - Fix to report unique OS Patches 
#      goramamo   07/01/02 - Bug 2441807 ( Zero byte pkginfo file )
#      xxu        06/25/02 - remove /usr/local/bin/perl
#      vkhizder   06/20/02 - vkhizder_compare_fix_2420795_collection_script_changes
#      goramamo   06/20/02 - OS and other s/w collection
#      goramamo   05/01/02 - Creation
#
#*************************************************************

use strict;

package Ptdpm8;

use Carp;
require 5.005;

#require 5.6.1;
require Exporter;

use ecmErrorMsgs;
use Ptdpm0;
use Ptdpm2;
use Ptdpm3;
use Ptdpm11;

#******************************************
#   Export Subroutines
#******************************************

@Ptdpm8::ISA    = ('Exporter');
@Ptdpm8::EXPORT = qw(
  &getSoftwareComponents
  );

#******************************************
#     Global Variables
#******************************************

use constant NIL => '';

#******************************************
#     Exported Subroutines
#******************************************

sub getSoftwareComponents($)
{
    debugTrace('Calling... getSoftwareComponents()');

    my ($comp) = @_;
    my %prods = ();

    %prods  = getProdDetails($comp, NIL);

    return %prods;
}

#******************************************
#     Non-Exported Subroutines
#******************************************

sub getProdDetails($$)
{
    debugTrace('Calling... getProdDetails()');

    my ($prodflag,$pkgloc) = @_;
    my %prods      = ();
    my @dlist      = ();

    my $index       = NIL;
    my $vendor      = NIL;
    my $prodname    = $Ptdpm2::UNKNOWN;
    my $prodvers    = NIL;
    my $prodrel     = NIL;
    my $prodepoch   = NIL;
    my $proddate    = NIL;
    my $prodsum     = NIL;

    my $prodtag     = '0';

    my $pkg         = NIL;
    my $version     = NIL;
    my $instdate    = NIL;

    my $sep         = ' : ';
    my $size        = 0;
    my $level       = 3;
    my $k           = 0;
    my $tz          = $ENV{'TZ'};

    my $queryformat = "Name: %{NAME}\n"."Vendor: %{VENDOR}\n"."Version: %{VERSION}\n"."Release: %{RELEASE}\n"."Epoch: %{EPOCH}\n"."Install Date: %{INSTALLTIME:date}\n"."Summary: %{SUMMARY}\n";
    
    $ENV{'TZ'} = 'UTC';

    chomp(@dlist = `$Ptdpm0::RPM -qa --queryformat "$queryformat"`);

    $size = scalar(@dlist);

    while ($k < $size)
    {
        if ($dlist[$k] =~ m/^Name:/)
        {
            $prodname  = right('Name:', $dlist[$k++]);
            $prodname  = $Ptdpm2::UNKNOWN if ($prodname eq NIL);

            $vendor    = right('Vendor:', $dlist[$k++]);
            $vendor    = NIL if ($vendor eq '(none)');

            $prodvers  = right('Version:', $dlist[$k++]);
            $prodrel   = right('Release:', $dlist[$k++]);
            $prodepoch = right('Epoch:', $dlist[$k++]);
            $version   = $prodvers;
            $version  .= '-'.$prodrel if ($prodrel ne NIL);
            $version   = $prodepoch.':'.$version if ($prodepoch ne '(none)');

            $proddate  = right('Install Date:', $dlist[$k++]);
            $instdate  = convRpmTimeToYYYYMMDD_hhmmss_Zone($proddate);

            $prodsum   = right('Summary:', $dlist[$k++]);
    
            if ($prodflag eq 'VENDOR')
            {
                $level = 0;
    
                $index = $vendor.$sep.$prodname.$sep.$version;
    
                $prods{$index}{$level}{$prodtag}{$Ptdpm2::VENDOR_NAME_TAG}                       = $vendor;
                $prods{$index}{$level}{$prodtag}{$Ptdpm2::VENDOR_SOFTWARE_NAME_TAG}              = $prodname;
                $prods{$index}{$level}{$prodtag}{$Ptdpm2::VENDOR_SOFTWARE_VERSION_TAG}           = $version;
                $prods{$index}{$level}{$prodtag}{$Ptdpm2::VENDOR_SOFTWARE_INSTALLATION_DATE_TAG} = $instdate;
                $prods{$index}{$level}{$prodtag}{$Ptdpm2::VENDOR_SOFTWARE_DESCRIPTION_TAG}       = NIL;
                $prods{$index}{$level}{$prodtag}{$Ptdpm2::VENDOR_SOFTWARE_LOCATION_TAG}          = NIL;
                $prods{$index}{$level}{$prodtag}{$Ptdpm2::VENDOR_SOFTWARE_SPECIFIC_INFORMATION_TAG} = NIL;
            }

            $level = 1;
                
            $index = $vendor.$sep.$prodname.$sep.$version;
    
            $prods{$index}{$level}{$pkg}{$Ptdpm2::NAME_TAG}              = $prodname;
            $prods{$index}{$level}{$pkg}{$Ptdpm2::TYPE_TAG}              = 'Package';
            $prods{$index}{$level}{$pkg}{$Ptdpm2::VERSION_TAG}           = $version;
            $prods{$index}{$level}{$pkg}{$Ptdpm2::INSTALLATION_DATE_TAG} = $instdate;
            $prods{$index}{$level}{$pkg}{$Ptdpm2::DESCRIPTION_TAG}       = trunc($prodsum);

            next;
        }

        $k++;
    }

    $ENV{'TZ'} = $tz;

    %prods = showProperValues(%prods);

    return %prods;
}

sub showProperValues
{
    my (%prods) = @_;
    my $i       = NIL;
    my $j       = NIL;
    my $k       = NIL;
    my $l       = NIL;
    my @sortin  = ();
    my @sortout = ();
    my $size    = 0;

    for $i (sort keys %prods)
    {
        for $j (sort keys %{$prods{$i}})
        {
            for $k (sort keys %{$prods{$i}{$j}})
            {
                for $l (sort keys %{$prods{$i}{$j}{$k}})
                {

                    #print STDERR "$i $j $k $l $prods{$i}{$j}{$k}{$l}\n"; # debug
                    if ($l eq $Ptdpm2::VENDOR_SOFTWARE_LOCATION_TAG)
                    {
                        @sortin = split (',', $prods{$i}{$j}{$k}{$l});
                        @sortout = sortuniq(@sortin);
                        $prods{$i}{$j}{$k}{$l} = join (',', @sortout);
                    }
                    elsif (($l eq $Ptdpm2::INSTALLATION_DATE_TAG)
                           && ($prods{$i}{$j}{$k}{$l} =~ m/,/))
                    {
                        @sortin = split (',', $prods{$i}{$j}{$k}{$l});
                        @sortout = sortuniq(@sortin);
                        $size    = scalar(@sortout) - 1;
                        $prods{$i}{$j}{$k}{$l} = $sortout[$size];
                    }
                    elsif ($l eq $Ptdpm2::VENDOR_SOFTWARE_INSTALLATION_DATE_TAG)
                    {
                        @sortin = split (',', $prods{$i}{$j}{$k}{$l});
                        @sortout = sortuniq(@sortin);
                        $prods{$i}{$j}{$k}{$l} = $sortout[0];
                    }
                }
            }
        }
    }

    return %prods;
}

1;

# End of the Program
