#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/cluster_node_information.pl /st_emagent_10.2.0.4.2db11.2/4 2009/03/06 03:49:16 ajdsouza Exp $
#
# cluster_node_information.pl
# 
# Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      cluster_node_information.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajdsouza    01/28/09 - use perlbin/script env vars
#    ajdsouza    12/07/07 - Creation
# 

use strict;
use warnings;
use Data::Dumper;
use File::Spec::Functions;
use File::Basename;
use File::Path;
#this module is not available in emagent 10.2.0.4
my $hostNameSub = 'hostOSD::getHostName';
my $hostDomainSub = 'hostOSD::getDomainName';
eval "use hostOSD; 1 " or undef $hostNameSub and undef $hostDomainSub
 and EMD_PERL_WARN("hostOSD perl module is not available");
use Sys::Hostname;
require "emd_common.pl";

my $scriptsDir;
my $perlBin;

if ( $ENV{EM_SCRIPTS_DIR} )
{
 $scriptsDir = $ENV{EM_SCRIPTS_DIR};
}

if ( $ENV{EM_PERLBIN_DIR} )
{
 $perlBin = $ENV{EM_PERLBIN_DIR};
}

exit 1 unless $scriptsDir and $perlBin;

# build the path to the em state directory
$scriptsDir =  catfile($scriptsDir,'has');
my $has_metrics_script =  catfile($scriptsDir,'has_metrics.pl');

stat $has_metrics_script;

if ( $has_metrics_script and -e $has_metrics_script )
{
 
      my $perlexe;

      for my $pl ( ( 'perl', 'perl.exe', 'perl.bat' ) )
      {
        my $tmpdir = catfile($perlBin,$pl);

        stat $tmpdir if $tmpdir;

        if ( $tmpdir and -e $tmpdir and -r $tmpdir )
        {
          $perlexe =  $tmpdir;
          last;
        }

      }
      
      if ( not $perlexe )
      {
        $perlexe = catfile($perlBin,'perl');
      }


      my $results =
`$perlexe $has_metrics_script property nodename__clustername__crshome__nodelist__nodestatus`;

      my $nm;
      my $cn;
      my $ch;
      my $nl;
      my $ns;
      my @resarray = split /\n/,$results if $results;

      for my $row ( @resarray )
      {
         $row =~ s/\s+//;
         next unless $row;
         next unless $row =~ /^em_result=/;

         my ( $vals ) = ( $row =~ /^em_result=(.+)/);

         next unless $vals;
         #em_result=nm|cn|ch|nl|ns
         my @valarray = ( $vals =~ /^([^\|]*)\|([^\|]*)\|([^\|]*)\|([^\|]*)\|([^\|]*)/)
            if $vals =~ /^[^\|]*\|[^\|]*\|[^\|]*\|[^\|]*\|([^\|]*)/;

         next unless @valarray;
         next if @valarray < 5;

         $nm = $valarray[0] if defined $valarray[0];
         $cn = $valarray[1] if defined $valarray[1];
         $ch = $valarray[2] if defined $valarray[2];
         $nl = $valarray[3] if defined $valarray[3];
         $ns = $valarray[4] if defined $valarray[4];

         last;
      }

      if ( not $nm )
      {
         if ( $cn or $ch or $nl )
         {
           $nm = $ENV{SHORT_HOSTNAME} if $ENV{SHORT_HOSTNAME};

           #$nm = hostOSD::getHostName() unless $nm;
           #this module is not available in emagent 10.2.0.4
           #my $subOSDHost = "hostOSD::getHostName";
           #my $subref = \&$subOSDHost;

           if ( $hostNameSub and not $nm )
           {
             my $fnref = \&$hostNameSub;
             $nm =  &$fnref;
           }

           $nm = hostname unless $nm;
           $nm = $ENV{LONG_HOSTNAME} if $ENV{LONG_HOSTNAME} and not $nm;
           $nm = $ENV{HOST} if $ENV{HOST} and not $nm;
           $nm = $ENV{EM_TARGET_NAME} if $ENV{EM_TARGET_NAME} and not $nm;

           if ( not $nm )
           {
             print "em_error=Failed to get node name or host name for node\n";
             EMD_PERL_ERROR("WARN:cluster_node_information.pl:Failed to get node name or host name for node");
             exit 1;
           }
           else
           {
             chomp $nm;
           }
         }
      }


      if ( $nm )
      {
        $cn = '' unless $cn;
        $ch = '' unless $ch;
        $nl = '' unless $nl;
        $ns = '' unless $ns;

        print  "em_result=$nm|$cn|$ch|$nl|$ns\n";
      }

}


exit 0;
