#!/usr/local/bin/perl
# 
# $Header: os_response.pl 30-dec-2004.19:27:27 afontana Exp $
#
# os_response.pl
# 
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      os_response.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    afontana    12/30/04 - add retries 
#    afontana    12/27/04 - change tries to retries 
#    afontana    11/13/04 - afontana_beacon_regressions_for_services
#    afontana    11/13/04 - Creation
#

use ParseStdin;
use Time::HiRes qw(gettimeofday tv_interval);
use strict;

ParseStdin::initStdin();

my $txnName =  ParseStdin::getParameter("TxnName");
my $beaconName = ParseStdin::getParameter("BeaconName");
my $command = ParseStdin::getParameter("Command");
my $numRetries = ParseStdin::getParameter("NumRetries", "0");
my $retryInterval = ParseStdin::getParameter("RetryInterval", "30");

my $result;
my $time;
my $status = 0;
my $numActualTries = 0;
my $return = "";

while ($status == 0 && $numActualTries < ($numRetries + 1))
{
  sleep($retryInterval) if ($numActualTries != 0);

  $numActualTries += 1;
  my $t0 = [gettimeofday];
  $result = `$command`;
  my $t1 = [gettimeofday];
  next if ($?);
  $time = tv_interval($t0, $t1);
  $status = 1;
}

print "em_result=";
#TxnName
  print ($txnName . "|") if $txnName;
#BeaconName
  print ($beaconName . "|") if $beaconName;
#Status
  print ($status . "|");
#Total Time
  print (($time * 1000) ."|");
#Number of Retries
  print (($numActualTries - 1) . "|");

if ($result)
{
  my $count = 0;
  my @values = (split m/\n/o, $result, 11);
  foreach my $value (@values)
  {
    print ($value . "|");
    $count += 1;
    exit 0 if ($count == 10);
  }
}
