## java.mk
.SUFFIXES: .java .class

.java.class:
	$(JAVAC) -g -classpath $(MAKE_CLASSPATH) $<

JAVA_HOME=$(ORACLE_HOME)/jdk
JAVAC=$(JAVA_HOME)/bin/javac
JAVA=$(JAVA_HOME)/bin/java

# jdk12 classpath
JDK12_CLASSPATH = ".$(PATHSEP)${JAVA_HOME}$(DIRSEP)jre$(DIRSEP)lib$(DIRSEP)rt.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)jdbc$(DIRSEP)lib$(DIRSEP)ojdbc5.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)sqlj$(DIRSEP)lib$(DIRSEP)runtime12.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)sqlj$(DIRSEP)lib$(DIRSEP)translator15.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)vbjorb.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)vbjapp.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)javavm$(DIRSEP)lib$(DIRSEP)aurora.zip$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)servlet.jar$(PATHSEP)$(CLASSPATH)"

# jre12 classpath
JRE12_CLASSPATH = ".$(PATHSEP)${JAVA_HOME}$(DIRSEP)jre$(DIRSEP)lib$(DIRSEP)rt.jar$(PATHSEP)${ORACLE_HOME}$(DIRSEP)lib$(DIRSEP)aurora_index.jar(PATHSEP)$(CLASSPATH)"

# services
ifdef ENABLETEST_IPV6

  GIOP_SERVICE=sess_iiop://${IPV6HOST}:2481:${ORACLE_SID}
  GIOPS_SERVICE=sess_iiop://${IPV6HOST}:2482:${ORACLE_SID}
  HTTP_SERVICE=http://${IPV6HOST}:7777
  HTTPS_SERVICE=https://${IPV6HOST}:9000
  JDBC_SERVICE=jdbc:oracle:thin:@${IPV6HOST}:${ORACLE_PORT}:${ORACLE_SID}
  KPRB_SERVICE=jdbc:oracle:kprb:
  OCI8_SERVICE=jdbc:oracle:oci8:@
  SERVICE=$(GIOP_SERVICE)

else

  GIOP_SERVICE=sess_iiop://localhost:2481:${ORACLE_SID}
  GIOPS_SERVICE=sess_iiop://localhost:2482:${ORACLE_SID}
  HTTP_SERVICE=http://localhost:7777
  HTTPS_SERVICE=https://localhost:9000
  JDBC_SERVICE=jdbc:oracle:thin:@localhost:${ORACLE_PORT}:${ORACLE_SID}
  KPRB_SERVICE=jdbc:oracle:kprb:
  OCI8_SERVICE=jdbc:oracle:oci8:@
  SERVICE=$(GIOP_SERVICE)

endif

ifndef SYSPASSWD

  SYSPASSWD=change_on_install

endif

# transaction
UT_NAME=/test/UserTransaction/testut
DS_NAME=/test/DataSource/testds

# demo account(s)
HRuser=HR
HRpwd=HR

USER=scott
PASS=tiger
