#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/rac/clsInterconn.pl /st_emdbsa_11.2/3 2009/03/09 11:30:34 ajdsouza Exp $
#
# clsInterconn.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      clsInterconn.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajdsouza    12/07/09 - Bug Fix 7686990, added back ORACLE_HOME from Bug Fix# 6723959
#    ajdsouza    09/08/08 - 
#    rsamaved    08/11/08 - work around extra text in parsing
#    ajdsouza    08/09/06 - fix bug 5378241,5184611,5732015
#    xuliu       04/05/05 - using qualified hostname 
#    xuliu       10/07/04 - xuliu_mov_rac_f
#    xuliu       07/08/04 - xuliu_rac_interconn
#    xuliu       07/01/04 - Creation
# 
use strict;
use warnings;
use File::Spec::Functions;
use File::Basename;
use File::Path;
use Data::Dumper;
use locale;
use siha::Common;
require "emd_common.pl";

my %crsidx;

my $crsHome = $ENV{EM_CRS_HOME};
my $o;

$crsHome = $ENV{CRS_HOME} unless $crsHome;

siha::Common::exit_fail("clsInterconn.pl:Ignore cluster interconnect metric: no CRS_HOME is found in the cluster\n")
 unless $crsHome and $crsHome !~ /#CRS_HOME#/;


my $tmppath = catfile($crsHome,'bin');
$ENV{PATH}="$tmppath:$ENV{PATH}";
my %command_args = (exit_failure_list => [()]);

# bug 6723959 
my $oldOH = $ENV{ORACLE_HOME} if $ENV{ORACLE_HOME};
$ENV{ORACLE_HOME} = $crsHome if $crsHome;
$o = siha::Common::runsystemcommand('oifcfg getif','',%command_args);

siha::Common::exit_fail
 ("clsInterconn.pl:Failed executing oifcfg getif")
  if $command_args{command_return_status};

$o =~ s/^\s+|\s+$// if $o;
chomp($o) if $o;

siha::Common::exit_fail('clsInterconn.pl:Failed to get any results from oifcfg getif')
 unless $o;

my @lines = split /\n/, $o;

for my $ln (@lines) 
{
    # $ln is in format of "if_name  subnet  scope  type"
    # e.g. <xxxxx:> eth0  10.10.10.0  global  cluster_interconnect

    $ln =~ s/^\s+|\s+$//g;

    next unless $ln;

    next if $ln =~ /PRIF\-/;

    # remove the Only in GPNp prefied to the interface name
    $ln =~ s/Only in GPnP//ig;
    $ln =~ s/^\s+|\s+$//g;
    $ln =~ s/^://;
    $ln =~ s/^\s+|\s+$//g;

    my @attrs = split /  /, $ln;

    siha::Common::warn_message("clsInterconn.pl:Unknown format of the output from oifcfg getif: $ln")
      and next unless scalar(@attrs) >= 2;

    siha::Common::warn_message("clsInterconn.pl:Unknown format of the output from oifcfg getif: $ln")
      and next if scalar(@attrs) >= 6;

    if ($attrs[2] !~ /global/i)
    {
        ($attrs[2]) = gethostbyname($attrs[2]); # fully qualified host name
    }

    if ($attrs[3] =~ /cluster_interconnect/i)
    {
        $attrs[3] = 'NO';
    }
    elsif ($attrs[3] =~ /public/i)
    {
        $attrs[3] = 'YES';
    }
    else
    {
        $attrs[3] = '';
    }

    EMD_PERL_DEBUG("clsInterconn.pl:$attrs[0]|$attrs[2]|$attrs[1]||$attrs[3]|");

    # make sure no duplicate keys
    next if $crsidx{"$attrs[0]_$attrs[2]"};

    $crsidx{"$attrs[0]_$attrs[2]"} = 1;

    siha::Common::warn_message("clsInterconn.pl: Failed to get interface name from $ln")
     unless $attrs[0];

    siha::Common::warn_message("clsInterconn.pl: Failed to get node name from $ln")
     unless $attrs[2];

    siha::Common::warn_message("clsInterconn.pl: Failed to get subnet from $ln")
     unless $attrs[1];

    siha::Common::warn_message("clsInterconn.pl: Failed to get if interface type is public/private from $ln")
     unless $attrs[3];

    # output in format of if_name|node|subnet|ip|public
    print "em_result=$attrs[0]|$attrs[2]|$attrs[1]||$attrs[3]\n";
}

exit 0;


END
{

  $ENV{ORACLE_HOME} = $oldOH if $oldOH;

  siha::Common::save_systemcmdoutput or
   warn "clsInterconn.pl:Failed to save the test results from clsInterconn.pl\n";

}
