#!/usr/local/bin/perl
# 
# $Header: servicePerf.pl 19-jun-2008.11:15:31 nachen Exp $
#
# servicePerf.pl
# 
# Copyright (c) 2006, 2008, Oracle. All rights reserved.  
#
#    NAME
#      servicePerf.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#    Collect service performance metric, collected every 5 min for rac and single instance dbs
#    get list of services from gv$services table, for each service query gv$servicemetric_history table
#    use cpupercall and dbtimepercall to calculate throughput and average response time
#    For rac databases values will be calculated on the composite target
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nachen      06/19/08 - XbranchMerge nachen_bug-7144603 from st_emdbsa_11.1
#    nachen      06/06/08 - fix internal references security issue
#    sadattaw    01/23/07 - calculating cpuload % instead of throughput
#    sadattaw    01/23/07 - calculating cpuload % instead of throughput
#    sadattaw    01/23/07 - calculating cpuload % instead of throughput
#    sadattaw    01/10/07 - add min, max and % cpu load
#    sadattaw    11/16/06 - implement review comments
#    sadattaw    10/11/06 - script to collect service performance metric for
#                           rac and single instance db
#    sadattaw    10/11/06 - Creation
# 

use strict;
use DBI qw(:sql_types);
use Cwd;

require "$ENV{EMDROOT}/sysman/admin/scripts/db/dbstate.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/rac/collectSrvPerf.pl";


# For TESTING: comment out stdin args
my %stdinArgs = get_stdinvars();
my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
my $databaseName = $stdinArgs{"EM_TARGET_DBNAME"};
my $address = $ENV{EM_TARGET_ADDRESS};
my $usr_role = $ENV{EM_TARGET_ROLE};

collect_service_metric($username, $password, $databaseName, $address, $usr_role);

