BEGIN

DECLARE
    l_target_types              MGMT_IP_TARGET_TYPES;
    l_param_values              MGMT_IP_PARAM_VALUE_LIST;
    l_target_type               MGMT_IP_TARGET_TYPES;
    l_report_guid               RAW(16);
    l_element_guid              RAW(16);
    l_report_order              NUMBER;
    l_curr_order                NUMBER;
    l_curr_row                  NUMBER;
    l_report_title_nlsid        VARCHAR2(128);
    l_report_owner              VARCHAR2(10);

    BEGIN
    l_target_type := MGMT_IP_TARGET_TYPES();
    l_target_type.extend(1);
    l_target_type(1) := 'oracle_cell';
    l_report_owner := mgmt_user.get_repository_owner;

   -------------------------------------------------------------------------
   --Exadata Cell Performance
   -------------------------------------------------------------------------
    l_report_order := 1 ;
    l_report_title_nlsid := 'Cell Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Cell Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(19);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'   WITH REALM as '||
'   (SELECT distinct realmname FROM '||
'                mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2  '||
'          WHERE s1.ecm_snapshot_id=s2.snapshot_guid and '||  
'                is_current=''Y'' and '||
'                target_guid=??EMIP_BIND_TARGET_GUID??) ,'|| 
'   CELL_INFO as              '||
'        (SELECT name ,m1.realmname FROM MGMT_EMX_CELL_C_CONFIG m1,REALM r  WHERE m1.ecm_snapshot_id in  '||
'            ( SELECT ecm_snapshot_id FROM MGMT_EMX_CELL_C_CONFIG s1, mgmt_ecm_gen_snapshot s2  '||
'               WHERE target_type = ''oracle_cell''  '||
'               AND IS_CURRENT = ''Y''  '||
'               AND s2.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'               AND s1.ecm_snapshot_id=s2.snapshot_guid) ),'||
'   CELL_PERF_INFO as             '||
'       (SELECT  t11.name ,collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, CELL_INFO t11 ,mgmt_metrics_composite_keys m2'||
'           WHERE m1.target_type = ''oracle_cell'' '||
'           AND m1.key_value = t11.name '||
'           AND m1.key_value2 = t10.realmname  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m2.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'         AND (metric_name = ''Cell_Statistics'' or metric_name=''Cell_Summary_Statistics'' or metric_name = ''CellOffload_Statistics'' or metric_name = ''CellIORMBoost_Statistics'') '||
'         AND (metric_column = ''cl_cput'' OR metric_column = ''cl_fans'' '||
'              OR metric_column = ''cl_runq'' OR metric_column = ''cl_temp'' '||
'         OR metric_column = ''max_celldisk_reads'' OR metric_column = ''avg_celldisk_reads'' '||
'         OR metric_column = ''max_celldisk_writes'' OR metric_column = ''avg_celldisk_writes'' '||
'         OR metric_column = ''max_celldisk_read_requests'' OR metric_column = ''avg_celldisk_read_requests'' OR metric_column = ''avg_celldisk_small_read_latency'' '||
'         OR metric_column = ''cl_offloadefficiency'' OR metric_column = ''cl_iormboost''  '||
'         OR metric_column = ''max_celldisk_write_requests'' OR metric_column = ''avg_celldisk_write_requests'' ) ) '||
'   SELECT t1.name "Cell", '||
'  	 round(NVL(t12.value,0),3) "Offload Efficiency",'||
'  	 round(NVL(t13.value,0),3) "IORM Boost",'||
'  	 round(NVL(t1.value,0),3) "CPU Busy %",'||
'      round(NVL(t3.value,0),3) "Top Reads(MB/Sec)" , '||
'      round(NVL(t4.value,0),3) "Avg Reads (MB/Sec)" , '||
'     round(NVL(t5.value,0),3) "Top Writes (MB/Sec)" , '||
'      round(NVL(t6.value,0),3) "Avg Writes (MB/Sec)" , '||
'      round(NVL(t7.value,0),3) "Top Read Reqs/Sec" , '||
'      round(NVL(t8.value,0),3) "Avg Read Reqs/Sec" , '||
'      round(NVL(t9.value,0),3) "Top Write Reqs/Sec", '||
'      round(NVL(t10.value,0),3) "Avg Write Reqs/Sec", '||
'      round(NVL(t11.value,0),3) "Small IO Read Latency (msecs)", '||
'  	 t1.collection_timestamp "Collection Timestamp",'||
'         ''oracle_cell'' , '||
'	 t1.target_name "Target Name" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=cl*_cput$metric=Cell*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 1", '||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=max*_celldisk*_reads$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 2" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_reads$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 3" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=max*_celldisk*_writes$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 4" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_writes$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 5" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=max*_celldisk*_read*_requests$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 6" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_read*_requests$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 7" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=max*_celldisk*_write*_requests$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 8" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_write*_requests$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 9" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_small*_read*_latency$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 10" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=cl*_offloadefficiency$metric=CellOffload*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 11" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=cl*_iormboost$metric=CellIORMBoost*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 12" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'    FROM  '||
'      (SELECT name,target_name, key_value,value,collection_timestamp,composite_key '||
'       FROM cell_perf_info '||
'       WHERE metric_column = ''cl_cput'') t1,  '||
'      (SELECT  name,target_name,key_value,value ,composite_key'||
'       FROM cell_perf_info'||
'       WHERE metric_column = ''cl_runq'') t2,  '||
'     (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''max_celldisk_reads'') t3,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_reads'') t4,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''max_celldisk_writes'') t5,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_writes'') t6 ,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''max_celldisk_read_requests'') t7,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_read_requests'') t8 ,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''max_celldisk_write_requests'') t9,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_write_requests'') t10,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_small_read_latency'') t11,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''cl_offloadefficiency'') t12,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''cl_iormboost'') t13'||
' WHERE '||
'      t1.name = t2.name'||
'      AND t1.target_name=t2.target_name'||
'      AND t2.name = t3.key_value'||
'      AND t2.target_name=t3.target_name'||
'      AND t2.name = t4.key_value'||
'      AND t2.target_name=t4.target_name      '||
'      AND t2.name = t5.key_value'||
'      AND t2.target_name=t5.target_name      '||
'      AND t2.name = t6.key_value'||
'      AND t2.target_name=t6.target_name      '||
'      AND t2.name = t7.key_value'||
'      AND t2.target_name=t7.target_name      '||
'      AND t2.name = t8.key_value'||
'      AND t2.target_name=t8.target_name      '||
'      AND t2.name = t9.key_value'||
'      AND t2.target_name=t9.target_name      '||
'      AND t2.name = t10.key_value'||
'      AND t2.target_name=t10.target_name     '||
'      AND t2.name = t11.key_value'||
'      AND t2.target_name=t11.target_name    '||
'      AND t2.name = t12.key_value'||
'      AND t2.target_name=t12.target_name    '||
'      AND t2.name = t13.key_value'||
'      AND t2.target_name=t13.target_name'    
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '14'
      );

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '16');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Celldisk Performance');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','14');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','15');

      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex14',
      '28'
      );
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '17');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '18');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '19');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8', '20');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex9', '21');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex10', '22');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex11', '23');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex12', '24');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex13', '25');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex2', '26');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3', '27');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );

   l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? ' 
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm Performance
   -------------------------------------------------------------------------
    l_report_order := 1 ;
    l_report_title_nlsid := 'Realm Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Realm Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(26);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'   WITH REALM as '||
'   (SELECT distinct realmname FROM '||
'                mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2  '||
'          WHERE s1.ecm_snapshot_id=s2.snapshot_guid and '||  
'                is_current=''Y'' and '||
'                target_guid=??EMIP_BIND_TARGET_GUID??) ,'|| 
'   CELL_INFO as              '||
'        (SELECT name ,m1.realmname FROM MGMT_EMX_CELL_C_CONFIG m1,REALM r  WHERE m1.ecm_snapshot_id in  '||
'            ( SELECT snapshot_guid FROM mgmt_ecm_gen_snapshot s1  '||
'               WHERE s1.snapshot_type = ''CELL_Config''  '||
'               AND s1.is_current = ''Y'')  '||
'               AND m1.realmname = r.realmname  '||
'               AND name like ??EMIP_BIND_PARAM1?? || ''%'' ) ,'||
'   CELL_PERF_INFO as             '||
'       (SELECT  distinct t11.name ,collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, CELL_INFO t11 ,mgmt_metrics_composite_keys m2'||
'           WHERE m1.target_type = ''oracle_cell'' '||
'           AND (m1.key_value = t11.name ) '||
'           AND m1.key_value2 = t10.realmname  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = m2.target_guid  '||
'         AND (metric_name = ''Cell_Statistics'' or metric_name=''Cell_Summary_Statistics''  or metric_name=''CellOffload_Statistics'' or metric_name=''CellIORMBoost_Statistics'') '||
'         AND (metric_column = ''cl_cput'' OR metric_column = ''cl_fans'' '||
'              OR metric_column = ''cl_runq'' OR metric_column = ''cl_temp'' '||
'         OR metric_column = ''max_celldisk_reads'' OR metric_column = ''avg_celldisk_reads'' '||
'         OR metric_column = ''max_celldisk_writes'' OR metric_column = ''avg_celldisk_writes'' '||
'         OR metric_column = ''cl_offloadefficiency'' OR metric_column = ''cl_iormboost'' '||
'         OR metric_column = ''max_celldisk_read_requests'' OR metric_column = ''avg_celldisk_read_requests'' OR metric_column = ''avg_celldisk_small_read_latency'' '||
'         OR metric_column = ''max_celldisk_write_requests'' OR metric_column = ''avg_celldisk_write_requests'' ) ) '||
'   SELECT t1.name "Cell", '||
'  	 round(NVL(t12.value,0),3) "Offload Efficiency",'||
'  	 round(NVL(t13.value,0),3) "IORM Boost",'||
'  	 round(NVL(t1.value,0),3) "CPU Busy %",'||
'      round(NVL(t3.value,0),3) "Top Reads(MB/Sec)" , '||
'      round(NVL(t4.value,0),3) "Avg Reads (MB/Sec)" , '||
'     round(NVL(t5.value,0),3) "Top Writes (MB/Sec)" , '||
'      round(NVL(t6.value,0),3) "Avg Writes (MB/Sec)" , '||
'      round(NVL(t7.value,0),3) "Top Read Reqs/Sec" , '||
'      round(NVL(t8.value,0),3) "Avg Read Reqs/Sec" , '||
'      round(NVL(t9.value,0),3) "Top Write Reqs/Sec", '||
'      round(NVL(t10.value,0),3) "Avg Write Reqs/Sec", '||
'      round(NVL(t11.value,0),3) "Small IO Latency", '||
'  	 t1.collection_timestamp "Collection Timestamp",'||
'         ''oracle_cell'' , '||
'	 t1.target_name "Target Name" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=cl*_cput$metric=Cell*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 1" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=max*_celldisk*_reads$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 2" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_reads$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 3" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=max*_celldisk*_writes$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 4" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_writes$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 5" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=max*_celldisk*_read*_requests$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 6" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_read*_requests$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 7" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=max*_celldisk*_write*_requests$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 8" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_write*_requests$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 9" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=avg*_celldisk*_small*_read*_latency$metric=Cell*_Summary*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 10" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=cl*_offloadefficiency$metric=CellOffload*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 11" ,'||
'        concat(concat(concat(''/em/console/monitoring/metricDetail$showRealTime=yes$type=oracle*_cell$pageType=byDay$target='',t1.target_name),''$metricColumn=cl*_iormboost$metric=CellIORMBoost*_Statistics$keyValue=''), t1.composite_key) as "Metric Detail URL 12" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'    FROM  '||
'   (SELECT name,target_name, key_value,value,collection_timestamp,composite_key '||
'     FROM cell_perf_info'||
'     WHERE metric_column = ''cl_cput'') t1,'||
'    (SELECT  name,target_name, key_value,value,collection_timestamp,composite_key'||
'     FROM cell_perf_info'||
'     WHERE metric_column = ''cl_runq'') t2,'||
'     (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''max_celldisk_reads'') t3,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_reads'') t4,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''max_celldisk_writes'') t5,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_writes'') t6 ,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''max_celldisk_read_requests'') t7,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_read_requests'') t8 ,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''max_celldisk_write_requests'') t9,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_write_requests'') t10, '||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''avg_celldisk_small_read_latency'') t11,'||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''cl_offloadefficiency'') t12, '||
'    (select name,target_name, key_value,value,collection_timestamp,composite_key FROM cell_perf_info'||
'     where'||
'     metric_column = ''cl_iormboost'') t13'||
' WHERE'||
'      t1.name = t2.name'||
'      AND t1.target_name=t2.target_name'||
'      AND t2.name = t3.key_value'||
'      AND t2.target_name=t3.target_name'||
'      AND t2.name = t4.key_value'||
'      AND t2.target_name=t4.target_name      '||
'      AND t2.name = t5.key_value'||
'      AND t2.target_name=t5.target_name      '||
'      AND t2.name = t6.key_value'||
'      AND t2.target_name=t6.target_name      '||
'      AND t2.name = t7.key_value'||
'      AND t2.target_name=t7.target_name      '||
'      AND t2.name = t8.key_value'||
'      AND t2.target_name=t8.target_name      '||
'      AND t2.name = t9.key_value'||
'      AND t2.target_name=t9.target_name      '||
'      AND t2.name = t10.key_value'||
'      AND t2.target_name=t10.target_name     '||
'      AND t2.name = t11.key_value'||
'      AND t2.target_name=t11.target_name     '||
'      AND t2.name = t12.key_value'||
'      AND t2.target_name=t12.target_name    '||
'      AND t2.name = t13.key_value'||
'      AND t2.target_name=t13.target_name'
     );


    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'no search conducted.');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '14'
      );

      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4',
      '16'
      );
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Celldisk Performance');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','14');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','15');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex14',
      '28'
      );
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '17');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '18');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '19');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8', '20');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex9', '21');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex10', '22');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex11', '23');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex12', '24');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex13', '25');
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex2', '26');
      l_param_values(26) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3', '27');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );

   -------------------------------------------------------------------------
   --CELL Celldisk Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Celldisk Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(20);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       CELLDISK_INFO as              '||
'       (SELECT name ,cellname,lun,m1.realmname FROM MGMT_EMX_CELL_CD_CONFIG m1  WHERE m1.ecm_snapshot_id in   '||
'                ( SELECT ecm_snapshot_id FROM MGMT_EMX_CELL_CD_CONFIG s1, mgmt_ecm_gen_snapshot s2   '||
'                   WHERE target_type = ''oracle_cell'' '||
'                   AND s1.ecm_snapshot_id=s2.snapshot_guid '||
'                   AND s2.target_guid = ??EMIP_BIND_TARGET_GUID?? '||
'                   AND s2.is_current=''Y''))  ,'||
'       CELLDISK_PERF_INFO as             '||
'       (SELECT  t11.name ,t11.cellname,t11.lun ,collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, CELLDISK_INFO t11,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND (m1.key_value = t11.name AND m1.key_value LIKE  ??EMIP_BIND_PARAM2?? || ''%'') '||
'           AND (m1.key_value2 = t11.cellname AND m1.key_value2 LIKE  ??EMIP_BIND_PARAM1?? || ''%'') '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m2.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m1.metric_name = ''CellDisk_Statistics''   '||
'           AND (metric_column = ''c_read_throughput'' OR metric_column = ''c_write_throughput'' '||
'                OR metric_column = ''c_read_requests'' OR metric_column = ''c_write_requests'' OR metric_column = ''c_sm_read_latency'') ) '||
'  SELECT t1.name  "Celldisk",  '||
'         t1.cellname "Cellname",  '||
'         t1.lun "LUN",  '||
'         round(NVL(t1.value,0),3) "Read Throughput (MB/Sec)" , '||
'         round(NVL(t2.value,0),3) "Write Throughput (MB/Sec)" , '||
'         round(NVL(t3.value,0),3) "Read Requests/Sec" , '||
'         round(NVL(t4.value,0),3) "Write Requests/Sec" , '||
'         round(NVL(t5.value,0),3) "Small Read Latency/Req (msec)" , '||
'         t1.collection_timestamp "Collection Timestamp", '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_read*_throughput$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_write*_throughput$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 2" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_read*_requests$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 3" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_write*_requests$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 4" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_sm*_read*_latency$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 5" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select name,Cellname,lun,target_name,key_value,value,collection_timestamp,composite_key FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_read_throughput'') t1, '||
'       (select name,Cellname,target_name,value FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_write_throughput'') t2, '||
'       (select name,Cellname,target_name,value FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_read_requests'') t3, '||
'       (select name,Cellname,target_name,value FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_write_requests'') t4, '||
'       (select name,Cellname,target_name,value FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_sm_read_latency'') t5 '||
' WHERE '||
'        t1.name = t2.name '||
'        AND t2.name = t3.name '||
'        AND t3.name = t4.name '||
'        AND t4.name = t5.name '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '9'
      );
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4',
      '11'
      );
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5',
      '12'
      );
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6',
      '13'
      );
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7',
      '14'
      );
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Performance');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','1');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','9');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','10');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm LUN Performance');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','1,2');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','9');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','10');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Griddisk Performance');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','1,0');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','9');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','10');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex9',
      '16'
      );
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8',
      '15'
      );
 
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
   );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm celldisk performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Celldisk Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm Celldisk Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm Celldisk Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(30);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       CELLDISK_INFO as              '||
'       (SELECT distinct name ,cellname,lun,m1.realmname FROM MGMT_EMX_CELL_CD_CONFIG m1  WHERE m1.ecm_snapshot_id in   '||
'                ( SELECT snapshot_guid FROM mgmt_ecm_gen_snapshot s1  '||
'                   WHERE s1.snapshot_type = ''CELL_Config'' '||
'                   AND s1.is_current = ''Y'')  '||
'                   AND cellname LIKE  ??EMIP_BIND_PARAM1?? || ''%''  '||
'                   AND name LIKE  ??EMIP_BIND_PARAM2?? || ''%'' ) , '||
'       CELLDISK_PERF_INFO as             '||
'       (SELECT  distinct t11.name ,t11.cellname,t11.lun ,collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, CELLDISK_INFO t11,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND (m1.key_value = t11.name AND m1.key_value LIKE  ??EMIP_BIND_PARAM2?? || ''%'') '||
'           AND (m1.key_value2 = t11.cellname AND m1.key_value2 LIKE  ??EMIP_BIND_PARAM1?? || ''%'') '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = m2.target_guid '||
'           AND m1.metric_name = ''CellDisk_Statistics''   '||
'           AND (metric_column = ''c_read_throughput'' OR metric_column = ''c_write_throughput'' '||
'                OR metric_column = ''c_read_requests'' OR metric_column = ''c_write_requests'') ) '||
'  SELECT t1.cellname  "Cellname",  '||
'         t1.name "Celldisk",  '||
'         t1.lun "LUN",  '||
'         round(NVL(t1.value,0),3) "Read Throughput (MB/Sec)" , '||
'         round(NVL(t2.value,0),3) "Write Throughput (MB/Sec)" , '||
'         round(NVL(t3.value,0),3) "Read Requests/Sec" , '||
'         round(NVL(t4.value,0),3) "Write Requests/Sec" , '||
'         t1.collection_timestamp "Collection Timestamp", '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_read*_throughput$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_write*_throughput$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 2" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_read*_requests$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 3" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_write*_requests$metric=CellDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 4" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select name,Cellname,lun,target_name,key_value,value,collection_timestamp,composite_key FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_read_throughput'') t1, '||
'       (select name,Cellname,target_name,value FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_write_throughput'') t2, '||
'       (select name,Cellname,target_name,value FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_read_requests'') t3, '||
'       (select name,Cellname,target_name,value FROM celldisk_perf_info  '||
'        where '||
'        metric_column = ''c_write_requests'') t4 '||
' WHERE '||
'        t1.name = t2.name '||
'        AND t1.cellname = t2.cellname '||
'        AND t1.target_name = t2.target_name '||
'        AND t2.name = t3.name '||
'        AND t2.cellname = t3.cellname '||
'        AND t2.target_name = t3.target_name '||
'        AND t3.name = t4.name '||
'        AND t3.cellname = t4.cellname '||
'        AND t3.target_name = t4.target_name '||
' Order By t1.cellname,t1.name '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'Celldisk');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by Celldisk');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'Celldisk Name,Cell Name,LUN,Read Throughput (MB/Sec),Write Throughput (MB/Sec),Read Reqs/sec,Write Reqs/Sec');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '8'
      );
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4',
      '10'
      );
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5',
      '11'
      );
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6',
      '12'
      );
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7',
      '13'
      );
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Griddisk Performance');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','0,1');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','8');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','9');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm LUN Performance');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','0,2');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','8');
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','9');
      l_param_values(26) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Performance');
      l_param_values(27) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(28) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','8');
      l_param_values(29) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','9');
      l_param_values(30) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8',
      '14'
      );
 
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL Griddisk Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Griddisk Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Griddisk Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );


    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(12);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       GRIDDISK_INFO as              '||
'       (SELECT name ,cellname,m1.realmname,ecm_snapshot_id FROM MGMT_EMX_CELL_GD_CONFIG m1  WHERE m1.ecm_snapshot_id in   '||
'                ( SELECT ecm_snapshot_id FROM MGMT_EMX_CELL_GD_CONFIG s1, mgmt_ecm_gen_snapshot s2   '||
'                   WHERE target_type = ''oracle_cell'' '||
'                   AND s1.ecm_snapshot_id=s2.snapshot_guid '||
'                   AND s2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'                   AND s2.is_current=''Y'')),  '||
'      GD_STAT_METRICS as '||
'         (select target_name, target_guid, metric_guid, metric_column from mgmt_metrics m, mgmt_targets t '||
'            where m.metric_name = ''GridDisk_Statistics'' and t.target_type = ''oracle_cell'' and m.type_meta_ver = t.type_meta_ver and (m.category_prop_1 = t.category_prop_1 or m.category_prop_1 = '' '') and (m.category_prop_2 = t.category_prop_2 or m.category_prop_2 = '' '') and (m.category_prop_3 = t.category_prop_3 or m.category_prop_3 = '' '') and  (m.category_prop_4 = t.category_prop_4 or m.category_prop_4 = '' '') and (m.category_prop_5 = t.category_prop_5 or m.category_prop_5 = '' '') '||
' AND (metric_column = ''c_read_throughput'' OR metric_column = ''c_write_throughput''  '||
'                OR metric_column = ''c_read_requests'' OR metric_column = ''c_write_requests'')) , '||
'       GRIDDISK_PERF_INFO as              '||
'       (SELECT t11.realmname,t11.ecm_snapshot_id,t11.name,t11.cellname,metric_column,target_name,composite_key,value,collection_timestamp '||
'           FROM mgmt_current_metrics m1,REALM t10, GRIDDISK_INFO t11,GD_STAT_METRICS gm, mgmt_metrics_composite_keys ck '||
'           WHERE '||
'           ck.key_part1_value = t11.name '||
'           AND ck.key_part2_value = t11.cellname '||
'           AND ck.key_part3_value = t10.realmname   '||
'           AND m1.key_value = ck.composite_key '||
'           AND m1.target_guid = ck.target_guid   '||
'           AND m1.metric_guid = gm.metric_guid  '||
'           AND m1.target_guid = gm.target_guid), '||
'      DISK_PATH_METRIC as '||
'         (select target_name, target_guid, metric_guid, metric_column from mgmt_metrics m, mgmt_targets t '||
'            where m.metric_name = ''Disk_Path'' and t.target_type = ''osm_instance'' and m.type_meta_ver = t.type_meta_ver and (m.category_prop_1 = t.category_prop_1 or m.category_prop_1 = '' '') and (m.category_prop_2 = t.category_prop_2 or m.category_prop_2 = '' '') and (m.category_prop_3 = t.category_prop_3 or m.category_prop_3 = '' '') and  (m.category_prop_4 = t.category_prop_4 or m.category_prop_4 = '' '') and (m.category_prop_5 = t.category_prop_5 or m.category_prop_5 = '' '')), '||
'      ASM_DISK_INFO as '||
'         (select  dpm1.target_name asm_tname, c1.string_value group_name, c2.string_value disk_name, c3.string_value disk_path '||
'            from mgmt_current_metrics c1, mgmt_current_metrics c2, mgmt_current_metrics c3, DISK_PATH_METRIC dpm1, DISK_PATH_METRIC dpm2, DISK_PATH_METRIC dpm3 '||
'            where c1.target_guid = dpm1.target_guid and c2.target_guid = dpm2.target_guid and c3.target_guid = dpm3.target_guid and c1.key_value = c2.key_value and c2.key_value = c3.key_value and c1.target_guid = c2.target_guid and c2.target_guid = c3.target_guid and c1.metric_guid = dpm1.metric_guid and dpm1.metric_column = ''group_name'' and c2.metric_guid = dpm2.metric_guid and dpm2.metric_column = ''disk_name'' and c3.metric_guid = dpm3.metric_guid and dpm3.metric_column = ''disk_path'') '||
'  SELECT t1.name  "Griddisk",  '||
'         t1.cellname "Cellname",  '||
'         ad.disk_name "ASM Disk",  '||
'         round(NVL(t1.value,0),3) "Read Throughput (MB/Sec)" , '||
'         round(NVL(t2.value,0),3) "Write Throughput (MB/Sec)" , '||
'         round(NVL(t3.value,0),3) "Read Requests/Sec" , '||
'         round(NVL(t4.value,0),3) "Write Requests/Sec" , '||
'         t1.collection_timestamp "Collection Timestamp", '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         replace(utl_url.escape(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/database/osm/diskGroup?type=osm_instance'', chr(38)),''target=''),ad.asm_tname),chr(38)),''oname=''),ad.group_name),chr(38)),''mname=''),ad.disk_name),chr(38)),''event=diskPerformanceTab'')), ''+'', ''%2B''), '||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_read*_throughput$metric=GridDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_write*_throughput$metric=GridDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 2" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_read*_requests$metric=GridDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 3" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_write*_requests$metric=GridDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 4" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'    ((((((select realmname,ecm_snapshot_id,name,Cellname,target_name,value,collection_timestamp,composite_key FROM griddisk_perf_info '||
'            where metric_column = ''c_read_throughput'') t1 inner join '||
'         (select name,Cellname,target_name,value FROM griddisk_perf_info where metric_column = ''c_write_throughput'') t2 on t1.name = t2.name) inner join '||
'         (select name,Cellname,target_name,value FROM griddisk_perf_info where metric_column = ''c_read_requests'') t3 on t2.name = t3.name) inner join '||
'         (select name,Cellname,target_name,value FROM griddisk_perf_info where metric_column = ''c_write_requests'') t4 on t3.name = t4.name) inner join '||
'         mgmt_emx_cell_c_config c on (t1.ecm_snapshot_id=c.ecm_snapshot_id and t1.cellname = c.name and t1.realmname = c.realmname)) left outer join '||
'         ASM_DISK_INFO ad on ((instr(ad.disk_path, t1.name) > 0) and (instr(ad.disk_path, decode(sign(instr(c.ipaddress1, ''/'')), 1, substr(c.ipaddress1, 1, instr(c.ipaddress1, ''/'') - 1), c.ipaddress1)) > 0))) '||
'  ORDER BY '||
'    t1.name'
     );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '8');
     l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3', '10');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '11');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '12');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '13');
  
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Performance');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','1');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','8');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','9');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '14');
     l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8', '15');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm griddisk performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Griddisk Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm Griddisk Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm Griddisk Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => ' Realm Griddisk Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(29);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       GRIDDISK_INFO as              '||
'       (SELECT distinct name ,cellname,celldisk,m1.realmname,ecm_snapshot_id FROM MGMT_EMX_CELL_GD_CONFIG m1  WHERE m1.ecm_snapshot_id in   '||
'                ( SELECT snapshot_guid FROM mgmt_ecm_gen_snapshot s1   '||
'                   WHERE s1.snapshot_type = ''CELL_Config'' '||
'                   AND s1.is_current = ''Y'')  '||
'                   AND cellname LIKE  ??EMIP_BIND_PARAM1?? || ''%''  '||
'                   AND celldisk LIKE  ??EMIP_BIND_PARAM2?? || ''%''  '||
'                   AND name LIKE  ??EMIP_BIND_PARAM3?? || ''%'' ) , '||
'      GD_STAT_METRICS as '||
'         (select target_name, target_guid, metric_guid, metric_column from mgmt_metrics m, mgmt_targets t '||
'            where m.metric_name = ''GridDisk_Statistics'' and t.target_type = ''oracle_cell'' and m.type_meta_ver = t.type_meta_ver and (m.category_prop_1 = t.category_prop_1 or m.category_prop_1 = '' '') and (m.category_prop_2 = t.category_prop_2 or m.category_prop_2 = '' '') and (m.category_prop_3 = t.category_prop_3 or m.category_prop_3 = '' '') and  (m.category_prop_4 = t.category_prop_4 or m.category_prop_4 = '' '') and (m.category_prop_5 = t.category_prop_5 or m.category_prop_5 = '' '') '||
' AND (metric_column = ''c_read_throughput'' OR metric_column = ''c_write_throughput''  '||
'                OR metric_column = ''c_read_requests'' OR metric_column = ''c_write_requests'')) , '||
'      GRIDDISK_PERF_INFO as              '||
'       (SELECT t11.realmname,t11.ecm_snapshot_id,t11.name,t11.cellname,t11.celldisk,metric_column,target_name,composite_key,value,collection_timestamp '||
'           FROM mgmt_current_metrics m1,REALM t10, GRIDDISK_INFO t11,GD_STAT_METRICS gm, mgmt_metrics_composite_keys ck '||
'           WHERE '||
'           ck.key_part1_value = t11.name '||
'           AND ck.key_part2_value = t11.cellname '||
'           AND ck.key_part3_value = t10.realmname   '||
'           AND m1.key_value = ck.composite_key '||
'           AND m1.target_guid = ck.target_guid   '||
'           AND m1.metric_guid = gm.metric_guid  '||
'           AND m1.target_guid = gm.target_guid), '||
'      DISK_PATH_METRIC as '||
'         (select target_name, target_guid, metric_guid, metric_column from mgmt_metrics m, mgmt_targets t '||
'            where m.metric_name = ''Disk_Path'' and t.target_type = ''osm_instance'' and m.type_meta_ver = t.type_meta_ver and (m.category_prop_1 = t.category_prop_1 or m.category_prop_1 = '' '') and (m.category_prop_2 = t.category_prop_2 or m.category_prop_2 = '' '') and (m.category_prop_3 = t.category_prop_3 or m.category_prop_3 = '' '') and  (m.category_prop_4 = t.category_prop_4 or m.category_prop_4 = '' '') and (m.category_prop_5 = t.category_prop_5 or m.category_prop_5 = '' '')), '||
'      ASM_DISK_INFO as '||
'         (select  dpm1.target_name asm_tname, c1.string_value group_name, c2.string_value disk_name, c3.string_value disk_path '||
'            from mgmt_current_metrics c1, mgmt_current_metrics c2, mgmt_current_metrics c3, DISK_PATH_METRIC dpm1, DISK_PATH_METRIC dpm2, DISK_PATH_METRIC dpm3 '||
'            where c1.target_guid = dpm1.target_guid and c2.target_guid = dpm2.target_guid and c3.target_guid = dpm3.target_guid and c1.key_value = c2.key_value and c2.key_value = c3.key_value and c1.target_guid = c2.target_guid and c2.target_guid = c3.target_guid and c1.metric_guid = dpm1.metric_guid and dpm1.metric_column = ''group_name'' and c2.metric_guid = dpm2.metric_guid and dpm2.metric_column = ''disk_name'' and c3.metric_guid = dpm3.metric_guid and dpm3.metric_column = ''disk_path'') '||
'  SELECT distinct t1.name  "Griddisk",  '||
'         t1.cellname "Cellname",  '||
'         t1.celldisk "Celldisk",  '||
'         ad.disk_name "ASM Disk", '||
'         round(NVL(t1.value,0),3) "Read Throughput (MB/Sec)" , '||
'         round(NVL(t2.value,0),3) "Write Throughput (MB/Sec)" , '||
'         round(NVL(t3.value,0),3) "Read Requests/Sec" , '||
'         round(NVL(t4.value,0),3) "Write Requests/Sec" , '||
'         t1.collection_timestamp "Collection Timestamp" , '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         replace(utl_url.escape(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/database/osm/diskGroup?type=osm_instance'', chr(38)),''target=''),ad.asm_tname),chr(38)),''oname=''),ad.group_name),chr(38)),''mname=''),ad.disk_name),chr(38)),''event=diskPerformanceTab'')), ''+'', ''%2B''), '||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_read*_throughput$metric=GridDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_write*_throughput$metric=GridDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 2" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_read*_requests$metric=GridDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 3" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_write*_requests$metric=GridDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 4" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'    ((((((select realmname,ecm_snapshot_id,name,celldisk,cellname,target_name,value,collection_timestamp,composite_key FROM griddisk_perf_info '||
'            where metric_column = ''c_read_throughput'') t1 inner join '||
'         (select ecm_snapshot_id,name,cellname,target_name,value FROM griddisk_perf_info where metric_column = ''c_write_throughput'') t2 on (t1.name = t2.name and t1.cellname = t2.cellname and t1.target_name = t2.target_name and t1.ecm_snapshot_id=t2.ecm_snapshot_id)) inner join '||
'         (select ecm_snapshot_id,name,cellname,target_name,value FROM griddisk_perf_info where metric_column = ''c_read_requests'') t3 on (t2.name = t3.name and t2.cellname = t3.cellname and t2.target_name = t3.target_name and t2.ecm_snapshot_id=t3.ecm_snapshot_id)) inner join '||
'         (select ecm_snapshot_id,name,cellname,target_name,value FROM griddisk_perf_info where metric_column = ''c_write_requests'') t4 on (t3.name = t4.name and t3.cellname = t4.cellname and t3.target_name = t4.target_name and t3.ecm_snapshot_id=t4.ecm_snapshot_id)) inner join '||
'         mgmt_emx_cell_c_config c on (t1.ecm_snapshot_id=c.ecm_snapshot_id and t1.cellname = c.name and t1.realmname = c.realmname)) left outer join '||
'         ASM_DISK_INFO ad on ((instr(ad.disk_path, t1.name) > 0) and (instr(ad.disk_path, decode(sign(instr(c.ipaddress1, ''/'')), 1, substr(c.ipaddress1, 1, instr(c.ipaddress1, ''/'') - 1), c.ipaddress1)) > 0))) '||
'  ORDER BY t1.cellname,t1.name'
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2,3');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'Celldisk');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by Celldisk');
    l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt3',
        'Griddisk');
    l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip3',
        'Search by Griddisk');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'Griddisk Name,Celldisk Name,Cell Name,Status,Error Count');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '9'
      );
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Performance');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','1');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','9');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','10');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Celldisk Performance');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','1,2');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','9');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','10');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '11');
 
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '12');
      l_param_values(26) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '13');
      l_param_values(27) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '14');
      l_param_values(28) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8', '15');
      l_param_values(29) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex9', '16');
 
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL Host Interconnect Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Host Interconnect Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Host Interconnect Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );


    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(13);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       INTERCONNECT_PERF_INFO as             '||
'       (SELECT  collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND (m1.key_value LIKE  ??EMIP_BIND_PARAM2?? || ''%'') '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m2.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m1.metric_name = ''HostInterConnect_Statistics''   '||
'           AND (metric_column = ''c_mb_sent'' OR metric_column = ''c_mb_dropped'' '||
'                OR metric_column = ''c_mb_resent'' OR metric_column = ''c_mb_received'' '||
'                OR metric_column = ''c_mb_rdma_dropped'' OR metric_column = ''c_rdma_retry_latency'') ) '||
'  SELECT t1.key_value  "Hostname",  '||
'         t1.key_value2 "Cellname",  '||
'         round(NVL(t1.value,0),3) "MB Sent/Sec)" , '||
'         round(NVL(t2.value,0),3) "MB Dropped/Sec)" , '||
'         round(NVL(t3.value,0),3) "MB Resent/Sec" , '||
'         round(NVL(t4.value,0),3) "MB Received/Sec" , '||
'         round(NVL(t5.value,0),3) "MB RDMA Dropped/Sec" , '||
'         round(NVL(t4.value,0),3) "RDMBA Retry Latency msec" , '||
'         t1.collection_timestamp "Collection Timestamp", '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_sent$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_dropped$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 2" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_resent$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 3" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_received$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 4" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_rdma*_dropped$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 5" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_rdma*_retry*_latency$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 6" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select target_name,key_value,key_value2,value,collection_timestamp,composite_key FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_sent'') t1, '||
'       (select target_name,value ,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_dropped'') t2, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_resent'') t3, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_received'') t4, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_rdma_dropped'') t5, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_rdma_retry_latency'') t6 '||
' WHERE '||
'        t1.key_value = t2.key_value '||
'        AND t1.key_value2 = t2.key_value2 '||
'        AND t2.key_value = t3.key_value '||
'        AND t2.key_value2 = t3.key_value2 '||
'        AND t2.key_value = t4.key_value '||
'        AND t2.key_value2 = t4.key_value2 '||
'        AND t2.key_value = t5.key_value '||
'        AND t2.key_value2 = t5.key_value2 '||
'        AND t2.key_value = t6.key_value '||
'        AND t2.key_value2 = t6.key_value2 '
     );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '9');
     l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3', '11');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '12');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '13');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '14');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '15');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8', '16');
  
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Performance');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','1');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','9');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','10');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex9', '17');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm host interconnect performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Host Interconnect Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm Host Interconnect Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm Host Interconnect Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Realm Host Interconnect Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(22);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       INTERCONNECT_PERF_INFO as             '||
'       (SELECT  metric_column,target_name,key_value,key_value2, key_value3,value,collection_timestamp,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND (m1.key_value LIKE  ??EMIP_BIND_PARAM2?? || ''%'') '||
'           AND (m1.key_value2 LIKE  ??EMIP_BIND_PARAM1?? || ''%'') '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = m2.target_guid  '||
'           AND m1.metric_name = ''HostInterConnect_Statistics''   '||
'           AND (metric_column = ''c_mb_sent'' OR metric_column = ''c_mb_dropped'' '||
'                OR metric_column = ''c_mb_resent'' OR metric_column = ''c_mb_received'' '||
'                OR metric_column = ''c_mb_rdma_dropped'' OR metric_column = ''c_rdma_retry_latency'') ) '||
'  SELECT t1.key_value  "Hostname",  '||
'         t1.key_value2 "Cellname",  '||
'         round(NVL(t1.value,0),3) "MB Sent/Sec)" , '||
'         round(NVL(t2.value,0),3) "MB Dropped/Sec)" , '||
'         round(NVL(t3.value,0),3) "MB Resent/Sec" , '||
'         round(NVL(t4.value,0),3) "MB Received/Sec" , '||
'         round(NVL(t5.value,0),3) "MB RDMA Dropped/Sec" , '||
'         round(NVL(t4.value,0),3) "RDMBA Retry Latency msec" , '||
'         t1.collection_timestamp "Collection Timestamp", '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_sent$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_dropped$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 2" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_resent$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 3" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_received$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 4" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_mb*_rdma*_dropped$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 5" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=c*_rdma*_retry*_latency$metric=HostInterConnect*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 6" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select target_name,key_value,key_value2,value,collection_timestamp,composite_key FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_sent'') t1, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_dropped'') t2, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_resent'') t3, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_received'') t4, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_mb_rdma_dropped'') t5, '||
'       (select target_name,value,key_value,key_value2 FROM interconnect_perf_info  '||
'        where '||
'        metric_column = ''c_rdma_retry_latency'') t6 '||
'     WHERE '||
'        t1.key_value = t2.key_value '||
'        AND t1.key_value2 = t2.key_value2 '||
'        AND t1.target_name = t2.target_name '||
'        AND t1.key_value = t3.key_value '||
'        AND t1.key_value2 = t3.key_value2 '||
'        AND t1.target_name = t3.target_name '||
'        AND t1.key_value = t4.key_value '||
'        AND t1.key_value2 = t4.key_value2 '||
'        AND t1.target_name = t4.target_name '||
'        AND t1.key_value = t5.key_value '||
'        AND t1.key_value2 = t5.key_value2 '||
'        AND t1.target_name = t5.target_name '||
'        AND t1.key_value = t6.key_value '||
'        AND t1.key_value2 = t6.key_value2 '||
'        AND t1.target_name = t6.target_name '||
' Order By t1.key_value2,t1.key_value '
     );
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'Hostname');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by Hostname');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '9'
      );
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Performance');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','1');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','9');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','10');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3', '11');
 
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '12');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '13');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '14');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '15');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8', '16');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex9', '17');

 
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL LUN Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'LUN Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'LUN Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(16);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       LUN_INFO as              '||
'       (SELECT name ,cellname,celldisk,m1.realmname FROM MGMT_EMX_CELL_L_CONFIG m1  WHERE m1.ecm_snapshot_id in   '||
'                ( SELECT ecm_snapshot_id FROM MGMT_EMX_CELL_L_CONFIG s1, mgmt_ecm_gen_snapshot s2   '||
'                   WHERE target_type = ''oracle_cell'' '||
'                   AND s1.ecm_snapshot_id=s2.snapshot_guid '||
'                   AND s2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'                   AND s2.is_current=''Y'')),  '||
'       LUN_PERF_INFO as             '||
'       (SELECT  t11.name ,t11.cellname,t11.celldisk,collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, LUN_INFO t11,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND m1.key_value = t11.name  '||
'           AND m1.key_value2 = t11.cellname  '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m2.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.metric_name = ''LUN_Statistics''   '||
'           AND (metric_column = ''LUN_Status'' )) '||
'  SELECT t1.name  "LUN",  '||
'         t1.cellname "Cellname",  '||
'         t1.celldisk "Celldisk",  '||
'         t1.value "Status",  '||
'         t1.collection_timestamp "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=LUN*_Status$metric=LUN*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select name,Cellname,celldisk,target_name,key_value,value,collection_timestamp,composite_key FROM lun_perf_info  '||
'        where '||
'        metric_column = ''LUN_Status'') t1 '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '5'
      );
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Physical Disk Performance');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','1,0');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','5');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','6');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Performance');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','1');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','5');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','6');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Celldisk Performance');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','1,2');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','5');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','6');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '7');
 
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5',
      '8'
      );
 
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm LUN performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm LUN Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm LUN Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm LUN Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'LUN Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(29);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       LUN_INFO as              '||
'       (SELECT distinct name ,cellname,celldisk,m1.realmname FROM MGMT_EMX_CELL_L_CONFIG m1  WHERE m1.ecm_snapshot_id in   '||
'                ( SELECT ecm_snapshot_id FROM mgmt_ecm_gen_snapshot s1   '||
'                   WHERE s1.snapshot_type = ''CELL_Config'' '||
'                   AND s1.is_current = ''Y'')  '||
'                   AND cellname LIKE  ??EMIP_BIND_PARAM1?? || ''%''  '||
'                   AND celldisk LIKE  ??EMIP_BIND_PARAM3?? || ''%''  '||
'                   AND name LIKE  ??EMIP_BIND_PARAM2?? || ''%'' ) , '||
'       LUN_PERF_INFO as             '||
'       (SELECT  distinct t11.name ,t11.cellname,t11.celldisk,collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, LUN_INFO t11,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND (m1.key_value = t11.name AND m1.key_value LIKE  ??EMIP_BIND_PARAM2?? || ''%'') '||
'           AND (m1.key_value2 = t11.cellname AND m1.key_value2 LIKE  ??EMIP_BIND_PARAM1?? || ''%'') '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = m2.target_guid  '||
'           AND m1.metric_name = ''LUN_Statistics''   '||
'           AND (metric_column = ''LUN_Status'' )) '||
'  SELECT t1.name  "LUN",  '||
'         t1.celldisk "Celldisk",  '||
'         t1.cellname "Cellname",  '||
'         t1.value "Status" , '||
'         t1.collection_timestamp "Collection Timestamp" , '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=LUN*_Status$metric=LUN*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select name,Cellname,celldisk,target_name,key_value,value,collection_timestamp,composite_key FROM lun_perf_info  '||
'        where '||
'        metric_column = ''LUN_Status'') t1 '||
' Order By t1.cellname,t1.name '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2,3');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'Lun');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by Lun');
    l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt3',
        'Celldisk');
    l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip3',
        'Search by Celldisk');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'LUN Name,Celldisk Name,Cell Name,Status,Error Count');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '5'
      );
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Celldisk Performance');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','2,1');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','5');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','6');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Performance');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','2');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','5');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','6');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Physical Disk Performance');
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','2,0');
      l_param_values(26) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','5');
      l_param_values(27) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','6');
      l_param_values(28) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '7');
 
      l_param_values(29) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5',
      '8'
      );
 
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL Physicaldisk Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Physical Disk Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'LUN Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(12);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       DISK_INFO as              '||
'       (SELECT name ,cellname,luns,m1.realmname FROM MGMT_EMX_CELL_PD_CONFIG m1  WHERE m1.ecm_snapshot_id in   '||
'                ( SELECT ecm_snapshot_id FROM MGMT_EMX_CELL_PD_CONFIG s1, mgmt_ecm_gen_snapshot s2   '||
'                   WHERE target_type = ''oracle_cell'' '||
'                   AND s1.ecm_snapshot_id=s2.snapshot_guid '||
'                   AND s2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'                   AND s2.is_current=''Y'')),  '||
'       DISK_PERF_INFO as             '||
'       (SELECT  t11.name ,t11.cellname,t11.luns,collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, DISK_INFO t11,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND m1.key_value = t11.name  '||
'           AND m1.key_value2 = t11.cellname  '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m2.target_guid = ??EMIP_BIND_TARGET_GUID??  '||
'           AND m1.metric_name = ''PhysicalDisk_Statistics''   '||
'           AND (metric_column = ''PhysicalDisk_Status'' )) '||
'  SELECT t1.name  "Physical Disk",  '||
'         t1.cellname "Cellname",  '||
'         t1.luns "LUNs",  '||
'         t1.value "Status",  '||
'         t1.collection_timestamp "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=PhysicalDisk*_Status$metric=PhysicalDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select name,Cellname,luns,target_name,key_value,value,collection_timestamp,composite_key FROM disk_perf_info  '||
'        where '||
'        metric_column = ''PhysicalDisk_Status'') t1 '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '5'
      );
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm LUN Performance');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','1,2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','5');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','6');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Performance');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','1');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','5');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','6');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '7');
 
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5',
      '8'
      );
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm physical disk performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Physical Disk Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm Physicaldisk Performance
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm Physical Disk Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'LUN Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(25);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       DISK_INFO as              '||
'       (SELECT distinct name ,cellname,luns,m1.realmname FROM MGMT_EMX_CELL_PD_CONFIG m1  WHERE m1.ecm_snapshot_id in   '||
'                ( SELECT snapshot_guid FROM mgmt_ecm_gen_snapshot s1   '||
'                   WHERE s1.snapshot_type = ''CELL_Config'' '||
'                   AND s1.is_current = ''Y'')  '||
'                   AND m1.cellname LIKE  ??EMIP_BIND_PARAM1?? || ''%''  '||
'                   AND m1.luns LIKE  ??EMIP_BIND_PARAM2?? || ''%''  '||
'                   AND m1.name LIKE  ??EMIP_BIND_PARAM3?? || ''%'' ) , '||
'       DISK_PERF_INFO as             '||
'       (SELECT  distinct t11.name ,t11.cellname,t11.luns,collection_timestamp,metric_column,target_name,key_value,key_value2, key_value3,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10, DISK_INFO t11,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND (m1.key_value = t11.name AND m1.key_value LIKE  ??EMIP_BIND_PARAM3?? || ''%'') '||
'           AND (m1.key_value2 = t11.cellname AND m1.key_value2 LIKE  ??EMIP_BIND_PARAM1?? || ''%'') '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = m2.target_guid  '||
'           AND m1.metric_name = ''PhysicalDisk_Statistics''   '||
'           AND (metric_column = ''PhysicalDisk_Status'' )) '||
'  SELECT t1.name  "Physical Disk",  '||
'         t1.luns "LUNs",  '||
'         t1.cellname "Cellname",  '||
'         t1.value "Status" , '||
'         t1.collection_timestamp "Collection Timestamp",  '||
'         t1.collection_timestamp "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'         t1.target_name "Target Name" ,'||
'         concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name), ''$metricColumn=PhysicalDisk*_Status$metric=PhysicalDisk*_Statistics$keyValue=''),t1.composite_key) as "Metric Detail URL 1" ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select name,Cellname,luns,target_name,key_value,value,collection_timestamp,composite_key FROM disk_perf_info  '||
'        where '||
'        metric_column = ''PhysicalDisk_Status'') t1 '||
' Order By t1.cellname,t1.name '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2,3');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'LUN');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by LUN');
    l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt3',
        'Disk');
    l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip3',
        'Search by Disk');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'Disk Name,LUN Name,Cell Name,Status');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '5'
      );
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm LUN Performance');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','2,1');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','6');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','7');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Performance');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','2');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','6');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','7');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '8');
 
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5',
      '9'
      );
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

 -------------------------------------------------------------------------
   --CELL IORM Database Performance
 -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'IORM Database Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(11);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       IORM_PERF_INFO as             '||
'       (SELECT  target_name,key_value,key_value2, key_value3,collection_timestamp,metric_column,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND m1.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'           AND m2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND (m1.metric_name = ''Database_Statistics'' )  '||
'           AND (metric_column = ''c_io_sm_requests'' OR metric_column = ''c_wait_time_per_sm_request''  '||
'                Or metric_column = ''c_io_lg_requests'' OR metric_column = ''c_wait_time_per_lg_request'' ) ) '||
'  SELECT t1.key_value2  "Cellname",  '||
'         t1.key_value "Database Name",  '||
'         NVL(t1.value,0) "Small IO Reqs/Sec",  '||
'         NVL(t2.value ,0)"Small IO Wait Time/Req (msec)",  '||
'         NVL(t3.value,0) "Large IO Reqs/Sec",  '||
'         NVL(t4.value ,0)"Large IO Wait Time/Req (msec)",  '||
'         t1.collection_timestamp "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       t1.target_name ,  '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_sm*_requests$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key)  , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_sm*_request$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_lg*_requests$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key)  , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_lg*_request$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
/*
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.key_value,'' '')) as emxCellStringAggCollectType)) "Name",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.value,'' '')) as emxCellStringAggCollectType)) "IO Reqs/Sec",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t2.value,'' '')) as emxCellStringAggCollectType)) "IO Wait Reqs/Sec",  '||
'         ''oracle_cell'' , '||
'       emxCellStringAggCollect(CAST(COLLECT(t1.target_name) as emxCellStringAggCollectType)) ,  '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_requests$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key)) as emxCellStringAggCollectType)) , '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=C*_IO*_Wait*_Requests$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key))as emxCellStringAggCollectType)) '||
*/
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_sm_requests'') t1, '||
'       (select key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_sm_request'') t2, '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_lg_requests'') t3, '||
'       (select key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_lg_request'') t4 '||
' WHERE '||
'        t1.key_value = t2.key_value '||
'        AND t1.key_value2 = t2.key_value2 '||
'        AND t1.key_value3 = t2.key_value3 '||
'        AND t2.key_value = t3.key_value '||
'        AND t2.key_value2 = t3.key_value2 '||
'        AND t2.key_value3 = t3.key_value3 '||
'        AND t3.key_value = t4.key_value '||
'        AND t3.key_value2 = t4.key_value2 '||
'        AND t3.key_value3 = t4.key_value3 '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '7'
      );

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3', '9');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '10');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Performance');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','7');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','8');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7',
      '13'
      );
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '11');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '12');
/*
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD( 
        'oracle.sysman.eml.ip.render.elem.TableRender.useSeparateRowsColumns','Name,IO Reqs/Sec,IO Wait Reqs/Sec,');
*/
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );
    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm iorm database performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm IORM Database Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
 -------------------------------------------------------------------------
   --CELL Realm IORM Database Performance
 -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm IORM Database Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(18);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       IORM_PERF_INFO as             '||
'       (SELECT  distinct target_name,key_value,key_value2, key_value3,collection_timestamp,metric_column,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
--'           AND (m1.key_value = t11.name ) '||
'           AND m1.key_value2  LIKE  ??EMIP_BIND_PARAM1?? || ''%''  '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = m2.target_guid  '||
'           AND (m1.metric_name = ''Database_Statistics'' )  '||
'           AND (metric_column = ''c_io_sm_requests'' OR metric_column = ''c_wait_time_per_sm_request''  '||
'                Or metric_column = ''c_io_lg_requests'' OR metric_column = ''c_wait_time_per_lg_request'' ) ) '||
'  SELECT t1.key_value2  "Cellname",  '||
'         t1.key_value "Database Name",  '||
'         NVL(t1.value,0) "Small IO Reqs/Sec",  '||
'         NVL(t2.value ,0)"Small IO Wait Time/Req (msec)",  '||
'         NVL(t3.value,0) "Large IO Reqs/Sec",  '||
'         NVL(t4.value ,0)"Large IO Wait Time/Req (msec)",  '||
'       to_char(t1.collection_timestamp,''MON DD YYYY HH:MI:SS AM'') "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       t1.target_name,  '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_sm*_requests$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key) , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_sm*_request$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_lg*_requests$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key) , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_lg*_request$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
/*
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.key_value,'' '')) as emxCellStringAggCollectType)) "Database Name",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.value,'' '')) as emxCellStringAggCollectType)) "IO Reqs/Sec",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t2.value,'' '')) as emxCellStringAggCollectType)) "IO Wait Time/Req (msec)",  '||
'       emxCellStringAggCollect(CAST(COLLECT(to_char(t1.collection_timestamp,''MON DD YYYY HH:MI:SS AM'')) as emxCellStringAggCollectType)) "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       emxCellStringAggCollect(CAST(COLLECT(t1.target_name) as emxCellStringAggCollectType)) ,  '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_requests$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key)) as emxCellStringAggCollectType)) , '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=C*_IO*_Wait*_Requests$metric='',''Database*_Statistics'')),''$keyValue=''),t1.composite_key))as emxCellStringAggCollectType)) ,'||
'        emxCellStringAggCollect(CAST(COLLECT(concat(''/em/console/metrics/allMetrics$type=oracle*_cell$target='',t1.target_name)) as emxCellStringAggCollectType)) '||
*/
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_sm_requests'') t1, '||
'       (select target_name,key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_sm_request'') t2, '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_lg_requests'') t3, '||
'       (select target_name,key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_lg_request'') t4 '||
' WHERE '||
'        t1.key_value = t2.key_value '||
'        AND t1.key_value2 = t2.key_value2 '||
'        AND t1.key_value3 = t2.key_value3 '||
'        AND t1.target_name = t2.target_name '||
'        AND t2.key_value = t3.key_value '||
'        AND t2.key_value2 = t3.key_value2 '||
'        AND t2.key_value3 = t3.key_value3 '||
'        AND t2.target_name = t3.target_name '||
'        AND t3.key_value = t4.key_value '||
'        AND t3.key_value2 = t4.key_value2 '||
'        AND t3.key_value3 = t4.key_value3 '||
'        AND t3.target_name = t4.target_name '
--'     GROUP BY t1.key_value2 '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '7');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3', '9');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '10');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '11');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '12');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Performance');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','7');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','8');
/*
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD( 
        'oracle.sysman.eml.ip.render.elem.TableRender.useSeparateRowsColumns','Name,IO Reqs/Sec,IO Wait Reqs/Sec,Wait Per Req (Msec),Collection Timestamp');
*/
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '13');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

 -------------------------------------------------------------------------
   --CELL IORM Category Performance
 -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'IORM Category Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(11);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       IORM_PERF_INFO as             '||
'       (SELECT  target_name,key_value,key_value2, key_value3,collection_timestamp,metric_column,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND m1.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'           AND m2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND (m1.metric_name = ''Category_Statistics'' )  '||
'           AND (metric_column = ''c_io_sm_requests'' OR metric_column = ''c_wait_time_per_sm_request''  '||
'                Or metric_column = ''c_io_lg_requests'' OR metric_column = ''c_wait_time_per_lg_request'' ) ) '||
'  SELECT t1.key_value2  "Cellname",  '||
'         t1.key_value "Category Name",  '||
'         NVL(t1.value,0) "Small IO Reqs/Sec",  '||
'         NVL(t2.value ,0)"Small IO Wait Time/Req (msec)",  '||
'         NVL(t3.value,0) "Large IO Reqs/Sec",  '||
'         NVL(t4.value ,0)"Large IO Wait Time/Req (msec)",  '||
'         t1.collection_timestamp "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       t1.target_name ,  '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_sm*_requests$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key)  , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_sm*_request$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_lg*_requests$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key)  , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_lg*_request$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_sm_requests'') t1, '||
'       (select key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_sm_request'') t2, '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_lg_requests'') t3, '||
'       (select key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_lg_request'') t4 '||
' WHERE '||
'        t1.key_value = t2.key_value '||
'        AND t1.key_value2 = t2.key_value2 '||
'        AND t1.key_value3 = t2.key_value3 '||
'        AND t2.key_value = t3.key_value '||
'        AND t2.key_value2 = t3.key_value2 '||
'        AND t2.key_value3 = t3.key_value3 '||
'        AND t3.key_value = t4.key_value '||
'        AND t3.key_value2 = t4.key_value2 '||
'        AND t3.key_value3 = t4.key_value3 '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '7'
      );

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3',
      '9'
      );
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '10');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '11');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '12');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Performance');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','7');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','8');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7',
      '13'
      );
/*
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD( 
        'oracle.sysman.eml.ip.render.elem.TableRender.useSeparateRowsColumns','Name,IO Reqs/Sec,IO Wait Reqs/Sec,');
*/
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );
    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm iorm category performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm IORM Category Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
 -------------------------------------------------------------------------
   --CELL Realm IORM Category Performance
 -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm IORM Category Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(18);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       IORM_PERF_INFO as             '||
'       (SELECT  distinct target_name,key_value,key_value2, key_value3,collection_timestamp,metric_column,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
--'           AND (m1.key_value = t11.name ) '||
'           AND m1.key_value2  LIKE  ??EMIP_BIND_PARAM1?? || ''%''  '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = m2.target_guid  '||
'           AND (m1.metric_name = ''Category_Statistics'' )  '||
'           AND (metric_column = ''c_io_sm_requests'' OR metric_column = ''c_wait_time_per_sm_request''  '||
'                Or metric_column = ''c_io_lg_requests'' OR metric_column = ''c_wait_time_per_lg_request'' ) ) '||
'  SELECT t1.key_value2  "Cellname",  '||
'         NVL(t1.key_value,'' '') "Category Name",  '||
'         NVL(t1.value,0) "Small IO Reqs/Sec",  '||
'         NVL(t2.value ,0)"Small IO Wait Time/Req (msec)",  '||
'         NVL(t3.value,0) "Large IO Reqs/Sec",  '||
'         NVL(t4.value ,0)"Large IO Wait Time/Req (msec)",  '||
'       to_char(t1.collection_timestamp,''MON DD YYYY HH:MI:SS AM'') "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       t1.target_name,  '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_sm*_requests$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key) , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_sm*_request$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_lg*_requests$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key) , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_lg*_request$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$target='',t1.target_name)  '||
/*
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.key_value,'' '')) as emxCellStringAggCollectType)) "Category Name",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.value,'' '')) as emxCellStringAggCollectType)) "IO Reqs/Sec",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t2.value,'' '')) as emxCellStringAggCollectType)) "IO Wait Time/Req (msec)",  '||
'       emxCellStringAggCollect(CAST(COLLECT(to_char(t1.collection_timestamp,''MON DD YYYY HH:MI:SS AM'')) as emxCellStringAggCollectType)) "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       emxCellStringAggCollect(CAST(COLLECT(t1.target_name) as emxCellStringAggCollectType)) ,  '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_requests$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key)) as emxCellStringAggCollectType)) , '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_request$metric='',''Category*_Statistics'')),''$keyValue=''),t1.composite_key))as emxCellStringAggCollectType)) ,'||
'        emxCellStringAggCollect(CAST(COLLECT(concat(''/em/console/metrics/allMetrics$type=oracle*_cell$target='',t1.target_name)) as emxCellStringAggCollectType)) '||
*/
'  FROM   '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_sm_requests'') t1, '||
'       (select target_name,key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_sm_request'') t2, '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_lg_requests'') t3, '||
'       (select target_name,key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_lg_request'') t4 '||
' WHERE '||
'        t1.key_value = t2.key_value '||
'        AND t1.key_value2 = t2.key_value2 '||
'        AND t1.key_value3 = t2.key_value3 '||
'        AND t1.target_name = t2.target_name '||
'        AND t2.key_value = t3.key_value '||
'        AND t2.key_value2 = t3.key_value2 '||
'        AND t2.key_value3 = t3.key_value3 '||
'        AND t2.target_name = t3.target_name '||
'        AND t3.key_value = t4.key_value '||
'        AND t3.key_value2 = t4.key_value2 '||
'        AND t3.key_value3 = t4.key_value3 '||
'        AND t3.target_name = t4.target_name '
--'     GROUP BY t1.key_value2 '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '7');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3',
      '9'
      );
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '10');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Performance');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','7');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','8');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '11');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '12');
/*
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD( 
        'oracle.sysman.eml.ip.render.elem.TableRender.useSeparateRowsColumns','Name,IO Reqs/Sec,IO Wait Reqs/Sec,Wait Per Req (Msec),Collection Timestamp');
*/
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7',
      '13'
      );
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

 -------------------------------------------------------------------------
   --CELL IORM ConsumerGroup Performance
 -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'IORM Consumer Group Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(11);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       IORM_PERF_INFO as             '||
'       (SELECT  target_name,key_value,key_value2, key_value3,collection_timestamp,metric_column,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
'           AND m1.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'           AND m2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND (m1.metric_name = ''ConsumerGroup_Statistics'' )  '||
'           AND (metric_column = ''c_io_sm_requests'' OR metric_column = ''c_wait_time_per_sm_request''  '||
'                Or metric_column = ''c_io_lg_requests'' OR metric_column = ''c_wait_time_per_lg_request'' ) ) '||
'  SELECT t1.key_value2  "Cellname",  '||
'         t1.key_value "DB Name.Consumer Group Name",  '||
'         NVL(t1.value,0) "Small IO Reqs/Sec",  '||
'         NVL(t2.value ,0)"Small IO Wait Time/Req (msec)",  '||
'         NVL(t3.value,0) "Large IO Reqs/Sec",  '||
'         NVL(t4.value ,0)"Large IO Wait Time/Req (msec)",  '||
'       to_char(t1.collection_timestamp,''MON DD YYYY HH:MI:SS AM'') "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       t1.target_name,  '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_sm*_requests$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key) , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_sm*_request$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_lg*_requests$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key) , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_lg*_request$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
/*
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.key_value,'' '')) as emxCellStringAggCollectType)) "Name",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.value,'' '')) as emxCellStringAggCollectType)) "IO Reqs/Sec",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t2.value,'' '')) as emxCellStringAggCollectType)) "IO Wait Reqs/Sec",  '||
'         ''oracle_cell'' , '||
'       emxCellStringAggCollect(CAST(COLLECT(t1.target_name) as emxCellStringAggCollectType)) ,  '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_requests$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key)) as emxCellStringAggCollectType)) , '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_wait*_time*_per*_request$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key))as emxCellStringAggCollectType)) '||
*/
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$pageType$target='',t1.target_name)  '||
'  FROM   '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_sm_requests'') t1, '||
'       (select target_name,key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_sm_request'') t2, '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_lg_requests'') t3, '||
'       (select target_name,key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_lg_request'') t4 '||
' WHERE '||
'        t1.key_value = t2.key_value '||
'        AND t1.key_value2 = t2.key_value2 '||
'        AND t1.key_value3 = t2.key_value3 '||
'        AND t1.target_name = t2.target_name '||
'        AND t2.key_value = t3.key_value '||
'        AND t2.key_value2 = t3.key_value2 '||
'        AND t2.key_value3 = t3.key_value3 '||
'        AND t2.target_name = t3.target_name '||
'        AND t3.key_value = t4.key_value '||
'        AND t3.key_value2 = t4.key_value2 '||
'        AND t3.key_value3 = t4.key_value3 '||
'        AND t3.target_name = t4.target_name '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed',
      '7'
      );

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3',
      '9'
      );
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '10');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Performance');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','7');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','8');
/*
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD( 
        'oracle.sysman.eml.ip.render.elem.TableRender.useSeparateRowsColumns','Name,IO Reqs/Sec,IO Wait Reqs/Sec,');
*/
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7',
      '13'
      );
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '11');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '12');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );
    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(6);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm consumergroup performance'' as " ", target_name , '||
      ' ''oracle_cell'',''''  from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm IORM Consumer Group Performance');

      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','3');

      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
 -------------------------------------------------------------------------
   --CELL Realm IORM ConsumerGroup Performance
 -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm IORM Consumer Group Performance';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Performance.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(18);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
'  WITH  '||
'       REALM as  '||
'       (SELECT distinct realmname FROM  '||
'                    mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2   '||
'              WHERE s1.ecm_snapshot_id=s2.snapshot_guid and  '||
'                is_current=''Y'' and '||
'                    target_guid= ??EMIP_BIND_TARGET_GUID??)  ,'||
'       IORM_PERF_INFO as             '||
'       (SELECT  distinct target_name,key_value,key_value2, key_value3,collection_timestamp,metric_column,value,composite_key '||
'           FROM mgmt$metric_current m1,REALM t10,mgmt_metrics_composite_keys m2 '||
'           WHERE target_type = ''oracle_cell'' '||
--'           AND (m1.key_value = t11.name ) '||
'           AND m1.key_value2  LIKE  ??EMIP_BIND_PARAM1?? || ''%''  '||
'           AND m1.key_value3 = t10.realmname  '||
'           AND m1.key_value3 = m2.key_part3_value  '||
'           AND m1.key_value2 = m2.key_part2_value  '||
'           AND m1.key_value = m2.key_part1_value  '||
'           AND m1.target_guid = m2.target_guid  '||
'           AND (m1.metric_name = ''ConsumerGroup_Statistics'' )  '||
'           AND (metric_column = ''c_io_sm_requests'' OR metric_column = ''c_wait_time_per_sm_request''  '||
'                Or metric_column = ''c_io_lg_requests'' OR metric_column = ''c_wait_time_per_lg_request'' ) ) '||
'  SELECT t1.key_value2  "Cellname",  '||
'         NVL(t1.key_value,'' '')  "DB Name.Consumer Group Name",  '||
'         NVL(t1.value,0) "Small IO Reqs/Sec",  '||
'         NVL(t2.value ,0)"Small IO Wait Time/Req (msec)",  '||
'         NVL(t3.value,0) "Large IO Reqs/Sec",  '||
'         NVL(t4.value ,0)"Large IO Wait Time/Req (msec)",  '||
'       to_char(t1.collection_timestamp,''MON DD YYYY HH:MI:SS AM'') "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       t1.target_name,  '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_sm*_requests$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key) , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_sm*_request$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_lg*_requests$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key) , '||
'        concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_lg*_request$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key) ,'||
'        concat(''/em/console/metrics/allMetrics$type=oracle*_cell$target='',t1.target_name)  '||
/*
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.key_value,'' '')) as emxCellStringAggCollectType)) "Database Name.Consumer Group Name",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t1.value,'' '')) as emxCellStringAggCollectType)) "IO Reqs/Sec",  '||
'         emxCellStringAggCollect(CAST(COLLECT(NVL(t2.value,'' '')) as emxCellStringAggCollectType)) "IO Wait Time/Req (msec)",  '||
'       emxCellStringAggCollect(CAST(COLLECT(to_char(t1.collection_timestamp,''MON DD YYYY HH:MI:SS AM'')) as emxCellStringAggCollectType)) "Collection Timestamp",  '||
'         ''oracle_cell'' , '||
'       emxCellStringAggCollect(CAST(COLLECT(t1.target_name) as emxCellStringAggCollectType)) ,  '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_io*_requests$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key)) as emxCellStringAggCollectType)) , '||
'        emxCellStringAggCollect(CAST(COLLECT(concat(concat(concat(concat(''/em/console/monitoring/metricDetail$type=oracle*_cell$pageType=byDay$target='',t1.target_name),concat(''$metricColumn=c*_wait*_time*_per*_request$metric='',''ConsumerGroup*_Statistics'')),''$keyValue=''),t1.composite_key))as emxCellStringAggCollectType)) ,'||
'        emxCellStringAggCollect(CAST(COLLECT(concat(''/em/console/metrics/allMetrics$type=oracle*_cell$target='',t1.target_name)) as emxCellStringAggCollectType)) '||
*/
'  FROM   '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_sm_requests'') t1, '||
'       (select target_name,key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_sm_request'') t2, '||
'       (select target_name,key_value,key_value2,key_value3,value,collection_timestamp,composite_key FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_io_lg_requests'') t3, '||
'       (select target_name,key_value,key_value2,key_value3,value FROM iorm_perf_info  '||
'        where '||
'        metric_column = ''c_wait_time_per_lg_request'') t4 '||
' WHERE '||
'        t1.key_value = t2.key_value '||
'        AND t1.key_value2 = t2.key_value2 '||
'        AND t1.key_value3 = t2.key_value3 '||
'        AND t1.target_name = t2.target_name '||
'        AND t2.key_value = t3.key_value '||
'        AND t2.key_value2 = t3.key_value2 '||
'        AND t2.key_value3 = t3.key_value3 '||
'        AND t2.target_name = t3.target_name '||
'        AND t3.key_value = t4.key_value '||
'        AND t3.key_value2 = t4.key_value2 '||
'        AND t3.key_value3 = t4.key_value3 '||
'        AND t3.target_name = t4.target_name '
--'     GROUP BY t1.key_value2 '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '7');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex3',
      '9'
      );
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex4', '10');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Performance');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','7');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','8');
/*
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD( 
        'oracle.sysman.eml.ip.render.elem.TableRender.useSeparateRowsColumns','Name,IO Reqs/Sec,IO Wait Reqs/Sec,Wait Per Req (Msec),Collection Timestamp');
*/
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7',
      '13'
      );
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '11');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '12');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL Cell Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Cell Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Cell Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row :=  1 ;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
      

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
    'oracle.sysman.eml.ip.render.elem.sqlStatement',
    '   SELECT start_timestamp "Configuration Collection Time" '||
    '   From mgmt_ecm_gen_snapshot '||
    '   Where '||
    '   is_current=''Y'' '||
    '   and target_guid = ??EMIP_BIND_TARGET_GUID?? '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.nameValueDisplay',
      '2');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
    'oracle.sysman.eml.ip.render.elem.sqlStatement',
    '   WITH CELLDISKCOUNT as  '||
    '   (SELECT cellname,count(name) as numcelldisk,sum(cdsize) as celldisksize  FROM '||
    '           MGMT_EMX_CELL_CD_CONFIG p1  '||
    '    WHERE '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM '||
    '                  mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.target_guid=??EMIP_BIND_TARGET_GUID??) '||
    '          GROUP BY p1.cellname ) ,'||
    '   GRIDDISKCOUNT as  '||
    '   (SELECT cellname,count(name) as numgriddisk,sum(gdsize) as griddisksize  FROM '||
    '           MGMT_EMX_CELL_GD_CONFIG p1 '||
    '    WHERE '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM  '||
    '           mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.target_guid=??EMIP_BIND_TARGET_GUID??) '||
    '          GROUP BY p1.cellname ), '||
    '   LUNCOUNT as  '||
    '   (SELECT cellname,count(name) as numlun,sum(lunsize) as lunsize  FROM '||
    '           MGMT_EMX_CELL_L_CONFIG p1  '||
    '    WHERE '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM '||
    '                  mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.target_guid=??EMIP_BIND_TARGET_GUID??) '||
    '          GROUP BY p1.cellname ), '||
    '   PHYSDISKCOUNT as  '||
    '   (SELECT cellname,count(name) as numdisk,sum(physsize) as disksize  FROM '||
    '           MGMT_EMX_CELL_PD_CONFIG p1 '||
    '    WHERE '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM '||
    '                  mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.target_guid=??EMIP_BIND_TARGET_GUID??) '||
    '          GROUP BY p1.cellname ) '||
    '   SELECT Name "Cell Name",  '||
    '          p1.status  "Status at Last Collection", '||
    '          nvl(p1.id,''Not Set'')  "Id" ,'||
    '          p1.kernelversion "Kernel Version",'||
    '          p1.ossversion "OSS Version",'||
    '          nvl(p1.makemodel ,''Not Set'')"Make Model", '||
    '          nvl(p1.location,''Not Set'') "Location", '||
    '          p1.bmctype "BMC Type", '||
    '          p1.ipblock "IP Block", '||
    '          p1.cpucount "CPU Count", '||
    '          p1.interconnectcount "Interconnect Count", '||
    '          nvl(p1.fancount,0) "Fan Count", '||
    '          nvl(p1.powercount,0) "Power Count", '||
    '          nvl(p1.metrichistorydays,0) "Metric History Days", '||
    '          nvl(p1.snmpsubscriber,''Not Set'') "Snmp Subscriber", '||
    '          nvl(p1.smtpserver,''Not Set'') "Smtp Server", '||
    '          nvl(p1.smtpport,''Not Set'') "Smtp Port", '||
    '          p1.interconnectcount "Interconnect Count", '||
    '          p1.ipaddress1 "IP Address 1", '||
    '          p1.ipaddress2 "IP Address 2", '||
    '          p1.ipaddress3 "IP Address 3", '||
    '          p1.ipaddress4 "IP Address 4",'||
    '          nvl(gd.griddisksize,0) "Total Griddisk Size (GB)", '||
    '          nvl(pd.disksize,0)  "Total Physicaldisk Size (GB)", '||
    '          nvl(cd.numcelldisk,0) "Celldisks", '||
    '          nvl(gd.numgriddisk,0) "Gridisks", '||
    '          nvl(l.numlun,0) "LUNS", '||
    '          nvl(pd.numdisk,0) "Physicaldisks" '||
    '   FROM   MGMT_EMX_CELL_C_CONFIG p1 , CELLDISKCOUNT cd,GRIDDISKCOUNT gd, '||
    '          LUNCOUNT l, PHYSDISKCOUNT pd '||
    '   WHERE '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM'||
    '                   mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.target_guid=??EMIP_BIND_TARGET_GUID??) and '||
    '           p1.name = cd.cellname (+)  and '||
    '           cd.cellname = l.cellname  (+) and '||
    '           l.cellname = pd.cellname   (+)and '||
    '           pd.cellname = gd.cellname   (+) '

     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.nameValueDisplay',
      '2');


    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1;
    
 l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(5);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm configuration'' as " ", target_name , '||
      ' ''oracle_cell'' from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );

   -------------------------------------------------------------------------
   --CELL Realm  Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Realm Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(28);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
    'oracle.sysman.eml.ip.render.elem.sqlStatement',
    '   WITH REALM as '||
    '   (SELECT distinct realmname FROM '||
    '           mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2 '||
    '    WHERE  s1.ecm_snapshot_id=s2.snapshot_guid and '||  
'                is_current=''Y'' and '||
    '           s2.target_guid=??EMIP_BIND_TARGET_GUID??) ,'||
    '   CELLDISKCOUNT as  '||
    '   (SELECT distinct p1.realmname ,cellname,count(name) as numcelldisk,sum(cdsize) as celldisksize  FROM '||
    '           MGMT_EMX_CELL_CD_CONFIG p1 , REALM r  '||
    '    WHERE '||
    '           p1.cellname like  ??EMIP_BIND_PARAM1?? || ''%''  and '||
    '           p1.realmname=r.realmname and '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM '||
    '                  mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' ) '||
    '          GROUP BY p1.realmname,p1.cellname ) ,'||
    '   GRIDDISKCOUNT as  '||
    '   (SELECT distinct p1.realmname ,cellname,count(name) as numgriddisk,sum(gdsize) as griddisksize  FROM '||
    '           MGMT_EMX_CELL_GD_CONFIG p1 , REALM r '||
    '    WHERE '||
    '           p1.cellname like  ??EMIP_BIND_PARAM1?? || ''%''  and '||
    '           p1.realmname=r.realmname and '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM  '||
    '           mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' ) '||
    '          GROUP BY p1.realmname,p1.cellname ), '||
    '   LUNCOUNT as  '||
    '   (SELECT distinct p1.realmname ,cellname,count(name) as numlun,sum(lunsize) as lunsize  FROM '||
    '           MGMT_EMX_CELL_L_CONFIG p1 , REALM r '||
    '    WHERE '||
    '           p1.cellname like  ??EMIP_BIND_PARAM1?? || ''%''  and '||
    '           p1.realmname=r.realmname and '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM '||
    '                  mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' ) '||
    '          GROUP BY p1.realmname,p1.cellname ), '||
    '   PHYSDISKCOUNT as  '||
    '   (SELECT distinct p1.realmname ,start_timestamp,cellname,count(name) as numdisk,sum(physsize) as disksize,target_name  FROM '||
    '           MGMT_EMX_CELL_PD_CONFIG p1 , REALM r , mgmt_ecm_gen_snapshot m1'||
    '    WHERE '||
    '           p1.cellname like  ??EMIP_BIND_PARAM1?? || ''%''  and '||
    '           p1.realmname=r.realmname and '||
    '           p1.ecm_snapshot_id in '||
    '           (SELECT snapshot_guid FROM '||
    '                  mgmt_ecm_gen_snapshot s2 '||
    '           WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' ) and '||
    '          p1.ecm_snapshot_id = m1.snapshot_guid '||
    '          GROUP BY p1.realmname,p1.cellname,start_timestamp,target_name ) '||
    '   SELECT pd.cellname "Cell Name",  '||
    '          nvl(gd.griddisksize,0) "Griddisk Size (GB)", '||
    '          nvl(pd.disksize,0) "Physicaldisk Size (GB)", '||
    '          nvl(cd.numcelldisk,0) "Celldisks", '||
    '          nvl(gd.numgriddisk,0) "Griddisks", '||
--    '          nvl(l.numlun ,0)"LUNS", '||
    '          nvl(pd.numdisk,0) "Physicaldisks", '||
    '          pd.start_timestamp "Collection Timestamp" ,'||
    '          ''oracle_cell'' , '||
    '          (SELECT target_name FROM mgmt_targets WHERE '||
    '           target_guid = ??EMIP_BIND_TARGET_GUID??),  '||
    '   concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),pd.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),pd.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
    '   FROM   CELLDISKCOUNT cd,GRIDDISKCOUNT gd, '||
    '          LUNCOUNT l, PHYSDISKCOUNT pd '||
    '   WHERE '||
    '         pd.cellname = l.cellname (+)and '||
    '         pd.realmname = l.realmname (+)and '||
    '         l.cellname = cd.cellname (+)and '||
    '         l.realmname = cd.realmname (+)and '||
    '         cd.cellname = gd.cellname (+)and '||
    '         cd.realmname = gd.realmname (+) '

     );


    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'CELL');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
--        'Cell,Griddisk Size (GB),Physicaldisk Size (GB),Celldisks,Griddisks,LUN,Physicaldisks');
        'Cell,Griddisk Size (GB),Physicaldisk Size (GB),Celldisks,Griddisks,Physicaldisks');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','7');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Griddisk Configuration');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','7');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','8');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle4', 'Realm Celldisk Configuration');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes4','0');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex4','7');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex4','8');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle5', 'Realm Griddisk Configuration');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes5','0');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex5','7');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex5','8');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle6', 'Realm Physical Disk Configuration');
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes6','0');
      l_param_values(26) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex6','7');
      l_param_values(27) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex6','8');
      l_param_values(28) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7',
      '9'
      );

/*
      l_param_values(28) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle6', 'Realm LUN Configuration');
      l_param_values(29) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes6','0');
      l_param_values(30) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex6','7');
      l_param_values(31) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex6','8');
*/
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL Celldisk Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Celldisk Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Celldisk Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(15);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     ' WITH TARGET_NAME as '||
     '  (select target_name FROM mgmt_targets where target_guid = ??EMIP_BIND_TARGET_GUID??) '||
      'select Cellname "Cell Name", Name "Celldisk Name", '||
      '  cdsize "Size (GB)", lun "LUN", devicepartition "Device Partition" ,'||
      ' (select start_timestamp  FROM mgmt_ecm_gen_snapshot where target_guid = ??EMIP_BIND_TARGET_GUID?? and IS_CURRENT=''Y'') "Collection Timestamp",'||
      ' ''oracle_cell'' , '||
      ' tn.target_name, '||
    '   concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),tn.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),tn.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
      '       FROM   MGMT_EMX_CELL_CD_CONFIG p1 ,MGMT_ECM_GEN_SNAPSHOT p2, TARGET_NAME tn'|| 
      '              where '||
      '            p1.ecm_snapshot_id=p2.snapshot_guid '||
      '            AND p2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
      '            ANd p2.Is_CURReNT = ''Y'' '||
      '            Order By Cellname,name  '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Griddisk Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','0,1');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','6');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','6');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','7');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle4', 'Realm LUN Configuration');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes4','0,3');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex4','6');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex4','7');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Configuration');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','6');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','7');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6',
      '8'
      );

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(5);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm celldisk configuration'' as " ", target_name , '||
      ' ''oracle_cell'' from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Celldisk Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',  
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm Celldisk Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm Celldisk Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Realm Celldisk Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(26);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'select Cellname "Cell Name", Name "Celldisk Name", '||
      '  cdsize "Size (GB)", lun "LUN", devicepartition "Device Partition" ,'||
      ' to_char(m1.start_timestamp,''MON DD YYYY HH:MI:SS AM'') "Collection Timestamp", ''oracle_cell'' , '||
     '  (select target_name FROM mgmt_targets where target_guid = ??EMIP_BIND_TARGET_GUID??) ,'||
    '   concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),m1.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),m1.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
      '       FROM   MGMT_EMX_CELL_CD_CONFIG p1, mgmt_ecm_gen_snapshot m1  '|| 
      '              where '||
      '              Cellname like ??EMIP_BIND_PARAM1?? || ''%'' ' ||
      '              AND name like ??EMIP_BIND_PARAM2?? || ''%'' ' ||
      '              AND realmname=(select distinct realmname FROM '||
      '                mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2 '||
      '                        where s1.ecm_snapshot_id=s2.snapshot_guid and '||
'                is_current=''Y'' and '||
      '                target_guid=??EMIP_BIND_TARGET_GUID??) and '||
      '              p1.ecm_snapshot_id in (SELECT snapshot_guid '||
      '              FROM mgmt_ecm_gen_snapshot s2 '||
--      '              WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' and s2.target_guid=??EMIP_BIND_TARGET_GUID??) and '||
      '              WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' ) and '||
      '              p1.ecm_snapshot_id = m1.snapshot_guid  '||
      '              Order By cellname,name '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'Celldisk');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by Celldisk');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'Cell Name,Celldisk Name,,Size (GB),LUN, Device Partition');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Griddisk Configuration');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','0,1');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','6');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','6');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','7');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle4', 'Realm LUN Configuration');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes4','0,3');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex4','6');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex4','7');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Configuration');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','6');
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','7');

      l_param_values(26) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6',
      '8'
      );
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL Griddisk Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Griddisk Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Griddisk Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(12);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     'select  p1.name "Griddisk Name", p1.celldisk "Celldisk", p1.cellname "Cell Name", '||
        'p1.gdsize "Size (GB)", p1.offset "Lowest Offset (MB)", p1.availableto "Available To", '||
        'dinfo.disk_name "ASM Disk", p2.start_timestamp "Collection Timestamp", ''oracle_cell'' ,  tn.target_name, '||
        'replace(utl_url.escape(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/database/osm/diskGroup?type=osm_instance'', chr(38)),''target=''),dinfo.asm_tname),chr(38)),''oname=''),dinfo.group_name),chr(38)),''mname=''),dinfo.disk_name),chr(38)),''event=diskProp'')), ''+'', ''%2B''), '||
        'concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),tn.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),tn.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
     'from (((mgmt_targets tn inner join mgmt_emx_cell_gd_config p1 on tn.target_guid = ??EMIP_BIND_TARGET_GUID??) '||
       'inner join mgmt_ecm_gen_snapshot p2 '||
       'on (p1.ecm_snapshot_id=p2.snapshot_guid and p2.target_guid=??EMIP_BIND_TARGET_GUID?? and p2.snapshot_type = ''CELL_Config'' and p2.is_current = ''Y'') '||
       'inner join MGMT_EMX_CELL_C_CONFIG c '||
       'on p1.ecm_snapshot_id=c.ecm_snapshot_id and p1.cellname = c.name) '||
       'left outer join '||
         '(with dpm as '||
           '(select target_name, target_guid, metric_guid, metric_column from mgmt_metrics m, mgmt_targets t '||
             'where m.metric_name = ''Disk_Path'' and t.target_type = ''osm_instance'' and m.type_meta_ver = t.type_meta_ver and (m.category_prop_1 = t.category_prop_1 or m.category_prop_1 = '' '') and (m.category_prop_2 = t.category_prop_2 or m.category_prop_2 = '' '') and (m.category_prop_3 = t.category_prop_3 or m.category_prop_3 = '' '') and  (m.category_prop_4 = t.category_prop_4 or m.category_prop_4 = '' '') and (m.category_prop_5 = t.category_prop_5 or m.category_prop_5 = '' '')) '||
         'select  dpm1.target_name asm_tname, c1.string_value group_name, c2.string_value disk_name, c3.string_value disk_path '||
         'from mgmt_current_metrics c1, mgmt_current_metrics c2, mgmt_current_metrics c3, dpm dpm1, dpm dpm2, dpm dpm3 '||
         'where c1.target_guid = dpm1.target_guid and c2.target_guid = dpm2.target_guid and c3.target_guid = dpm3.target_guid and c1.key_value = c2.key_value and c2.key_value = c3.key_value and c1.target_guid = c2.target_guid and c2.target_guid = c3.target_guid and c1.metric_guid = dpm1.metric_guid and dpm1.metric_column = ''group_name'' and c2.metric_guid = dpm2.metric_guid and dpm2.metric_column = ''disk_name'' and c3.metric_guid = dpm3.metric_guid and dpm3.metric_column = ''disk_path'') dinfo '||
      'on ((instr(dinfo.disk_path, p1.name) > 0) and (instr(dinfo.disk_path, decode(sign(instr(c.ipaddress1, ''/'')), 1, substr(c.ipaddress1, 1, instr(c.ipaddress1, ''/'') - 1), c.ipaddress1)
) > 0))) '||
      'order by p1.cellname, p1.celldisk, p1.name'
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','8');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Celldisk Configuration');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','2,1');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','8');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','9');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Configuration');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','2');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','8');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','9');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '10');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8', '11');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );
    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(5);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm griddisk configuration'' as " ", target_name , '||
      ' ''oracle_cell'' from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Griddisk Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',  
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm Griddisk Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm Griddisk Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Realm Griddisk Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(25);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     'select  p1.name "Griddisk Name", p1.celldisk "Celldisk", p1.cellname "Cell Name", '||
        'p1.gdsize "Size (GB)", p1.offset "Lowest Offset (MB)", p1.availableto "Available To", '||
        'dinfo.disk_name "ASM Disk", p2.start_timestamp "Collection Timestamp", ''oracle_cell'' ,  p2.target_name, '||
        'replace(utl_url.escape(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/database/osm/diskGroup?type=osm_instance'', chr(38)),''target=''),dinfo.asm_tname),chr(38)),''oname=''),dinfo.group_name),chr(38)),''mname=''),dinfo.disk_name),chr(38)),''event=diskProp'')), ''+'', ''%2B''), '||
        'concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),p2.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),p2.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
     'from ((mgmt_emx_cell_gd_config p1 inner join mgmt_ecm_gen_snapshot p2 '||
       'on (p1.ecm_snapshot_id=p2.snapshot_guid and p2.snapshot_type = ''CELL_Config'' and p2.is_current = ''Y'' and p1.cellname like ??EMIP_BIND_PARAM1?? || ''%'' and p1.celldisk like ??EMIP_BIND_PARAM2?? || ''%'' and p1.name like ??EMIP_BIND_PARAM3?? || ''%'' and ' ||
         'p1.realmname=(select distinct realmname FROM mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2 where s1.ecm_snapshot_id=s2.snapshot_guid and is_current=''Y'' and target_guid=??EMIP_BIND_TARGET_GUID??)) ' ||
       'inner join MGMT_EMX_CELL_C_CONFIG c '||
       'on p1.ecm_snapshot_id=c.ecm_snapshot_id and p1.cellname = c.name and p1.realmname = c.realmname) '||
       'left outer join '||
         '(with dpm as '||
           '(select target_name, target_guid, metric_guid, metric_column from mgmt_metrics m, mgmt_targets t '||
             'where m.metric_name = ''Disk_Path'' and t.target_type = ''osm_instance'' and m.type_meta_ver = t.type_meta_ver and (m.category_prop_1 = t.category_prop_1 or m.category_prop_1 = '' '') and (m.category_prop_2 = t.category_prop_2 or m.category_prop_2 = '' '') and (m.category_prop_3 = t.category_prop_3 or m.category_prop_3 = '' '') and  (m.category_prop_4 = t.category_prop_4 or m.category_prop_4 = '' '') and (m.category_prop_5 = t.category_prop_5 or m.category_prop_5 = '' '')) '||
         'select  dpm1.target_name asm_tname, c1.string_value group_name, c2.string_value disk_name, c3.string_value disk_path '||
         'from mgmt_current_metrics c1, mgmt_current_metrics c2, mgmt_current_metrics c3, dpm dpm1, dpm dpm2, dpm dpm3 '||
         'where c1.target_guid = dpm1.target_guid and c2.target_guid = dpm2.target_guid and c3.target_guid = dpm3.target_guid and c1.key_value = c2.key_value and c2.key_value = c3.key_value and c1.target_guid = c2.target_guid and c2.target_guid = c3.target_guid and c1.metric_guid = dpm1.metric_guid and dpm1.metric_column = ''group_name'' and c2.metric_guid = dpm2.metric_guid and dpm2.metric_column = ''disk_name'' and c3.metric_guid = dpm3.metric_guid and dpm3.metric_column = ''disk_path'') dinfo '||
      'on ((instr(dinfo.disk_path, p1.name) > 0) and (instr(dinfo.disk_path, decode(sign(instr(c.ipaddress1, ''/'')), 1, substr(c.ipaddress1, 1, instr(c.ipaddress1, ''/'') - 1), c.ipaddress1)) > 0))) '||
      'order by p1.cellname, p1.name'
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2,3');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'Celldisk');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by Celldisk');
    l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt3',
        'Griddisk');
    l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip3',
        'Search by Griddisk');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'Griddisk Name,Celldisk Name,Cell Name,Size (GB),Lowest Offset (MB) ');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','8');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Celldisk Configuration');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','2,1');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','8');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','9');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Configuration');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','2');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','8');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','9');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex7', '10');
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex8', '11');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL LUN Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'LUN Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'LUN Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );


    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(15);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     ' WITH TARGET_NAME as '||
     '  (select target_name FROM mgmt_targets where target_guid = ??EMIP_BIND_TARGET_GUID??) '||
     'select  Name "LUN Name",Celldisk "Celldisk",CellName "Cell Name", '||
     '        lunsize "Total Size (GB)", raidlevel "Raid Level" ,'||
      ' (select start_timestamp  FROM mgmt_ecm_gen_snapshot where target_guid = ??EMIP_BIND_TARGET_GUID?? and IS_CURRENT=''Y'') "Collection Timestamp",'||
'            ''oracle_cell'', '||
      ' tn.target_name, '||
    '   concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),tn.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),tn.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
'             FROM   MGMT_EMX_CELL_L_CONFIG p1 ,MGMT_ECM_GEN_SNAPSHOT p2,TARGET_NAME tn'|| 
'                    where  '||
      '            p1.ecm_snapshot_id=p2.snapshot_guid '||
      '            AND p2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
      '            ANd p2.Is_CURReNT = ''Y'' '||
      '            Order By Cellname,name  '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','6');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Physical Disk Configuration');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','2,0');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','6');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','7');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Celldisk Configuration');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','2,1');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','6');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','7');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Configuration');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','2');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','6');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','7');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '8');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(5);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm LUN configuration'' as " ", target_name , '||
      ' ''oracle_cell'' from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm LUN Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',  
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm LUN Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm LUN Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'LUN Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(28);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     'select  Name "LUN Name",Celldisk "Celldisk",CellName "Cell Name", '||
     '        lunsize "Total Size (GB)", raidlevel "Raid Level" ,'||
      ' m1.start_timestamp "Collection Timestamp", ''oracle_cell'' , '||
     '  (select target_name FROM mgmt_targets where target_guid = ??EMIP_BIND_TARGET_GUID??) ,'||
    '   concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),m1.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),m1.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
'             FROM   MGMT_EMX_CELL_L_CONFIG p1 , mgmt_ecm_gen_snapshot m1 '|| 
'                    where  '||
'                    Cellname like ??EMIP_BIND_PARAM1?? || ''%'' ' ||
'                    AND Name like ??EMIP_BIND_PARAM2?? || ''%'' ' ||
'                    AND Celldisk like ??EMIP_BIND_PARAM3?? || ''%'' ' ||
'                    AND realmname=(select distinct realmname FROM  '||
'		               mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2 '||
'			       where s1.ecm_snapshot_id=s2.snapshot_guid and '||
'                is_current=''Y'' and '||
'			       target_guid=??EMIP_BIND_TARGET_GUID??) '||
'                   and '||
'                    p1.ecm_snapshot_id in (SELECT snapshot_guid '||
'                    FROM mgmt_ecm_gen_snapshot s2  '||
'                    WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' ) and '||
'                    p1.ecm_snapshot_id = m1.snapshot_guid '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2,3');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'LUN');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by LUN');
    l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt3',
        'Celldisk');
    l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip3',
        'Search by Celldisk');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'LUN Name,Celldisk Name,Cell Name,Size (GB),Raid Level');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','6');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Physical Disk Configuration');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
--        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','2,1,0');
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','2,0');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','6');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','7');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm Celldisk Configuration');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','2,1');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','6');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','7');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Configuration');
      l_param_values(25) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','2');
      l_param_values(26) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','6');
      l_param_values(27) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','7');

      l_param_values(28) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex6', '8');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
      );

   -------------------------------------------------------------------------
   --CELL Physical Disk Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Physical Disk Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Physical Disk Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );


    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(11);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     ' WITH TARGET_NAME as '||
     '  (select target_name FROM mgmt_targets where target_guid = ??EMIP_BIND_TARGET_GUID??) '||
     ' select  Name "Physicaldisk Name ",luns  "LUN/s", CellName "Cell Name", '||
     '            physsize "Size (GB)", '||
     '  (select start_timestamp  FROM mgmt_ecm_gen_snapshot where target_guid = ??EMIP_BIND_TARGET_GUID?? and IS_CURRENT=''Y'') "Collection Timestamp",'||
     '           ''oracle_cell'', '||
      ' tn.target_name, '||
    '   concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),tn.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),tn.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
     '             FROM   MGMT_EMX_CELL_PD_CONFIG p1 ,MGMT_ECM_GEN_SNAPSHOT p2,TARGET_NAME tn '||
     '                    where '||
      '            p1.ecm_snapshot_id=p2.snapshot_guid '||
      '            AND p2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
      '            ANd p2.Is_CURReNT = ''Y'' '||
      '            Order By Cellname,name  '
     );

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm LUN Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','2,1');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','5');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','6');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Configuration');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','2');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','5');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','6');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','5');

      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '7');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );

    l_curr_order := l_curr_order + 1 ;
    l_curr_row := l_curr_row + 1 ;
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(5);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm physical disk configuration'' as " ", target_name , '||
      ' ''oracle_cell'' from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Physical Disk Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',  
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm Physical Disk Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm Physical Disk Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'Physical Disk Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(24);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     ' select  Name "Physicaldisk Name ",luns  "LUN/s", CellName "Cell Name", '||
     '            physsize "Size (GB)", '||
      ' m1.start_timestamp "Collection Timestamp", ''oracle_cell'' , '||
     '           (select target_name FROM mgmt_targets where target_guid = ??EMIP_BIND_TARGET_GUID??) , '||
    '   concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),m1.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),m1.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'') '||
     '             FROM   MGMT_EMX_CELL_PD_CONFIG p1, mgmt_ecm_gen_snapshot m1 '||
     '                    where '||
     '                    CellName like ??EMIP_BIND_PARAM1?? || ''%'' ' ||
     '                    AND luns like ??EMIP_BIND_PARAM2?? || ''%'' ' ||
     '                    AND Name like ??EMIP_BIND_PARAM3?? || ''%'' ' ||
     '                    AND realmname=(select distinct realmname FROM '||
     '		               mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2'||
     '			       where s1.ecm_snapshot_id=s2.snapshot_guid and'||
'                is_current=''Y'' and '||
     '			       target_guid=??EMIP_BIND_TARGET_GUID??)'||
     '                    and'||
     '                    p1.ecm_snapshot_id in (SELECT snapshot_guid'||
     '                    FROM mgmt_ecm_gen_snapshot s2 '||
     '                    WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' ) and '||
     '                    p1.ecm_snapshot_id = m1.snapshot_guid '
     );

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2,3');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'LUN');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by LUN');
    l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt3',
        'Physical Disk');
    l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip3',
        'Search by Physical Disk');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'Disk Name,LUN,Cell Name,Size (GB),Error Count,a,b');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle2', 'Realm LUN Configuration');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes2','2,1');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex2','5');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex2','6');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle3', 'Realm Configuration');
      l_param_values(20) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes3','2');
      l_param_values(21) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex3','5');
      l_param_values(22) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex3','6');
      l_param_values(23) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','5');
      l_param_values(24) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex5', '7');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );

   -------------------------------------------------------------------------
   --CELL IO Resource Manager Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'IO Resource Manager Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'IO Resource Manager Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );


    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(9);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     ' WITH TARGET_NAME as '||
     '  (select target_name FROM mgmt_targets where target_guid = ??EMIP_BIND_TARGET_GUID??) '||
     '  select    CellName "Cell Name", '||
     '            directivetype "Plan Type", '||
     '           dbcatname  "Name",  '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level1,'' '')) as emxCellStringAggCollectType)) "Level 1" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level2,'' '')) as emxCellStringAggCollectType)) "Level 2" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level3,'' '')) as emxCellStringAggCollectType)) "Level 3" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level4,'' '')) as emxCellStringAggCollectType)) "Level 4" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level5,'' '')) as emxCellStringAggCollectType)) "Level 5" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level6,'' '')) as emxCellStringAggCollectType)) "Level 6" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level7,'' '')) as emxCellStringAggCollectType)) "Level 7" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level8,'' '')) as emxCellStringAggCollectType)) "Level 8" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(role,'' '')) as emxCellStringAggCollectType)) "Role",  '||
     '           emxCellStringAggCollect(CAST(COLLECT( to_char(t1.start_timestamp,''MON DD YYYY HH::MI:SS AM''))  as emxCellStringAggCollectType)) "Collection Timestamp",  '||
     '           ''oracle_cell'',  '||
      ' tn.target_name "tgt", '||
    '   emxCellStringAggCollect(CAST(COLLECT(to_char(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),tn.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),tn.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'')))as  emxCellStringAggCollectType )) "Config URL" '||
     '           FROM   MGMT_EMX_CELL_IORM_CONFIG p1 ,MGMT_ECM_GEN_SNAPSHOT p2,TARGET_NAME tn,'||
     '                  (select start_timestamp  FROM mgmt_ecm_gen_snapshot where target_guid = ??EMIP_BIND_TARGET_GUID?? and IS_CURRENT=''Y'') t1 '||
     '           where '||
      '            p1.ecm_snapshot_id=p2.snapshot_guid '||
      '            AND p2.target_guid=??EMIP_BIND_TARGET_GUID?? '||
      '            ANd p2.is_current = ''Y'' '||
     '			 Group By cellname,directivetype,dbcatname,tn.target_name '
     );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','13');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','14');
      l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','13');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDefault1',' ');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD( 
        'oracle.sysman.eml.ip.render.elem.TableRender.useSeparateRowsColumns','Name,Level 1,Level 2,Level 3,Level 4,Level 5,Level 6,Level 7,Level 8,Role,Collection Timestamp');

      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex14', '15');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
    l_curr_order := l_curr_order + 1;
    l_curr_row := l_curr_row + 1 ;
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(5);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'Select ''Click here for realm IO resource manager configuration'' as " ", target_name , '||
      ' ''oracle_cell'' from mgmt_targets '||
      '  Where target_guid = ??EMIP_BIND_TARGET_GUID?? '
    );
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm IO Resource Manager Configuration');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','2');
      l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','1');
      l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed', '1');
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',  
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   -------------------------------------------------------------------------
   --CELL Realm IO Resource Manager Configuration
   -------------------------------------------------------------------------
    l_report_order := l_report_order + 1 ;
    l_report_title_nlsid := 'Realm IO Resource Manager Configuration';
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                => l_report_title_nlsid,
      p_description_nlsid          => 'IO Resource Manager Configuration.',
      p_owner                      => l_report_owner,
      p_category_nlsid             => 'Storage',
      p_sub_category_nlsid         => 'CELL',
      p_late_binding_target_types  => l_target_type,
      p_late_binding_multi_targets => 0,
      p_show_table_of_contents     => 1,
      p_system_report              => 1,
      p_component_name             => l_target_type(1)
      );

    l_curr_order := 1;
    l_curr_row := 1;
  -- Add report so that it shows up under "reports" tab in default homepage
    mgmt_mp_homepage.add_report (
      p_target_type        => l_target_type(1),
      p_report_title       => l_report_title_nlsid,
      p_report_owner       => l_report_owner,
      p_report_order       => l_report_order
      );
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(19);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
     'oracle.sysman.eml.ip.render.elem.sqlStatement',
     '  select    CellName "Cell Name", '||
     '           directivetype "Plan Type", '||
     '           dbcatname "Name",  '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level1,'' '')) as emxCellStringAggCollectType)) "Level 1" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level2,'' '')) as emxCellStringAggCollectType)) "Level 2" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level3,'' '')) as emxCellStringAggCollectType)) "Level 3" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level4,'' '')) as emxCellStringAggCollectType)) "Level 4" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level5,'' '')) as emxCellStringAggCollectType)) "Level 5" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level6,'' '')) as emxCellStringAggCollectType)) "Level 6" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level7,'' '')) as emxCellStringAggCollectType)) "Level 7" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(level8,'' '')) as emxCellStringAggCollectType)) "Level 8" , '||
     '           emxCellStringAggCollect(CAST(COLLECT(NVL(role,'' '')) as emxCellStringAggCollectType)) "Role",  '||
     '           emxCellStringAggCollect(CAST(COLLECT(to_char(start_timestamp,''MON DD YYY HH:MI:SS AM'')) as emxCellStringAggCollectType)) "Collection Timestamp",  '||
     '           ''oracle_cell'',  '||
     '           (select target_name FROM mgmt_targets where target_guid = ??EMIP_BIND_TARGET_GUID?? ) ,'||  
    '   emxCellStringAggCollect(CAST(COLLECT(to_char(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(concat(''/em/console/ecm/generic/view?type=oracle_cell'', chr(38)),''cancelUrl=/em/console/target/homepage%24type%3Doracle%2A_cell%2A_cell%24target%3D''),m1.target_name), ''%3Fevent%3DdoLoad'') ,chr(38)),''target=''),m1.target_name),chr(38)),''snapshotType=CELL_Config''),chr(38)),''event=doLoad'')))as emxCellStringAggCollectType  )) "Config URL" '||
     '           FROM   MGMT_EMX_CELL_IORM_CONFIG p1 ,mgmt_ecm_gen_snapshot m1'||
     '           where '||
'                    Cellname like ??EMIP_BIND_PARAM1?? || ''%'' ' ||
     '               AND directivetype like ??EMIP_BIND_PARAM2?? || ''%'' ' ||
     '               AND realmname=(select distinct realmname FROM '||
     '		               mgmt_emx_cell_c_config s1, mgmt_ecm_gen_snapshot s2 '||
     '			       where s1.ecm_snapshot_id=s2.snapshot_guid and '||
'                is_current=''Y'' and '||
     '			       target_guid=??EMIP_BIND_TARGET_GUID??) '||
     '                    and '||
     '                    p1.ecm_snapshot_id in (SELECT snapshot_guid '||
     '                    FROM mgmt_ecm_gen_snapshot s2 '||
     '                    WHERE s2.is_current=''Y'' and s2.snapshot_type=''CELL_Config'' ) and '||
     '                    p1.ecm_snapshot_id = m1.snapshot_guid '||
     '			 Group By cellname,directivetype,dbcatname '
     );
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterNames',
        '1,2');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt1',
        'Cell');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip1',
        'Search by Cell target');
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterPrompt2',
        'Plan Type');
    l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterTip2',
        'Search by Plan Type');
      l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterStartEmpty', 'no');
      l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableHeaders',
        'Cell Name,Plan Type,Database Name,Priority Level 1,2,3,4,5,6,7,8,Role');
      l_param_values(9) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterEmptyTableText', 'No search conducted.');
      l_param_values(10) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterHeaderText', 'Search');
      l_param_values(11) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterDescriptionText', 'Use the following search criteria to filter the data. Leaving the search fields empty would retrieve data for all cells in this realm.');
      l_param_values(12) := MGMT_IP_PARAM_VALUE_RECORD (
        'oracle.sysman.eml.ip.render.elem.TableRender.filterButtonText', 'Go');
      l_param_values(13) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnDestHomepageReportTitle1', 'Realm Configuration');
      l_param_values(14) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestParamColumnIndexes1','0');
      l_param_values(15) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTypeIndex1','13');
      l_param_values(16) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.columnDestTargetIndex1','14');
      l_param_values(17) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.numberOfColumnsShowed','13');
      l_param_values(18) := MGMT_IP_PARAM_VALUE_RECORD( 
        'oracle.sysman.eml.ip.render.elem.TableRender.useSeparateRowsColumns','Name,Level 1,Level 2,Level 3,Level 4,Level 5,Level 6,Level 7,Level 8,Role,Collection Timestamp');
      l_param_values(19) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.columnDestURLIndex14', '15');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid        => l_report_guid,
      p_element_name_nlsid => 'table_from_sql',
      p_element_type_nlsid => 'any_target_type',
      p_header_nlslid      => '',
      p_element_order      => l_curr_order,
      p_element_row        => l_curr_row,
      p_parameters         => l_param_values,
      p_targets            => null
    );
   END;

END;
/

