-- Setup a database for running Java

-- This script can not function properly in SVRMGR.  The following 
-- lines are intended to abort the script if it is being run with
-- SVRMGR, but will be interpreted simply as remarks by SQLPLUS.
rem -
set stoponerror on
rem -
initjvm.sql must be run with SQLPLUS, not SVRMGRL


whenever sqlerror exit;

variable test_for_1335603 varchar2(30)

/*
#######################################################################
#######################################################################
  If the following   :test_for_1335603 := 'x'   statement causes
  a PLS-00553 error, and thereby terminates the sqlplus connection,
  simply restart the script in a new sqlplus session.
  This error can occur if the script is run in the same session where
  the database was started.  To avoid this problem, always start a new
  session to run scripts after starting the database.
#######################################################################
#######################################################################
*/

execute :test_for_1335603 := 'x';

whenever sqlerror continue;

-- Load support packages, including rmjvm
@@initjvma

-- try to determine whether this script is running in the same instance
-- where rmjvm.run was done

whenever sqlerror exit;

/*
#######################################################################
#######################################################################
##  If the following  rmjvm.check_for_rmjvm()  statement results in
##  ORA-00028 it means that the database has not been restarted 
##  since the rmjvm script was run.  If so, restart the database and
##  retry this script.
#######################################################################
#######################################################################
*/

call rmjvm.check_for_rmjvm();

set serveroutput on size 999999

-- State start of LOAD action
/*
#######################################################################
#######################################################################
##  If the following statement causes an
##  ORA-29539: Java system classes already installed
##  error, and thereby terminates the sqlplus connection,
##  initjvm.sql is being run in a database in which it has
##  has already been run to completion.  This is not allowed.  
#######################################################################
#######################################################################
*/
declare foo exception;
pragma exception_init(foo, -29539);
action varchar2(30) := 'LOAD';
begin
  initjvmaux.startaction_outarg(action);
  if action != 'LOAD' then
    initjvmaux.endaction;
    initjvmaux.abort_message(
        'Aborting because initjvm.sql has already been run');
    raise foo;
  end if;
exception when no_data_found then null;
end;
/

/*
#######################################################################
#######################################################################
##  The following statement may cause an
##  ORA-29554: unhandled Java out of memory condition
##  error, and thereby terminate the sqlplus connection.
##  If so, this is because there is insufficient system tablespace,
##  shared or java pool size, or some other resource value is too small.
##  An additional message describing the problem will be output by
##  the statement.
#######################################################################
#######################################################################
*/
execute initjvmaux.check_sizes_for_cjs;

whenever sqlerror continue;

begin if initjvmaux.startstep('SET_REGISTRY_LOADING') then
  initjvmaux.setloading();
  initjvmaux.endstep;
end if; end;
/

-- Roles for Security - must come before create java system
@@initjvm1

-- Prevent the script from continuing in the case where create java system
-- detects existing java classes or there is any other kind of error.
whenever sqlerror exit;

-- Load all the Java classes
begin if initjvmaux.startstep('CREATE_JAVA_SYSTEM') then
  initjvmaux.rollbacksetup;
  commit;
  initjvmaux.rollbackset;
  initjvmaux.exec('create or replace java system');
  commit;
  initjvmaux.rollbackcleanup;
  initjvmaux.endstep;
end if; end;
/

whenever sqlerror continue;

-- create view javasnm
@@initjvm3

-- Java Sanity check for installation
-- Define package dbms_java
@@initjvm2


-- Java Sanity Checks

-- Check for any Java classes that are invalid.
-- The following query should return 0 rows.

select nvl(longdbcs,name) from obj$,javasnm$ 
      where type#=29 and status != 1 and name=short(+);

-- Verify that a simple java stored procedure works, and punt if it doesn't
whenever sqlerror exit;
select dbms_java.longname('foo') from dual;
whenever sqlerror continue;

-- Prepare for use of java$rmjvm$aux3 in initjvm4
insert into java$rmjvm$aux3 (select obj# from obj$ where type#=29);

-- Find all the error messages.
-- Create the get error package for LoadJava
@@initjvm4

-- initialize Java Security 
-- Keep this first in case any of the other inits want to run java

@@jvmsec0;

-- Aurora oracle.aurora.rdbms.Server lifecycle and state --
-- Put in the entries for Dynamic registration, by default.
-- Triggers to run startup and shutdown Java code
-- The configuration data for currently registered MTS listener endpoints
-- SQLJ initialization
-- XA JSP initialization

@@initjvm5

-- Install Package for export and import support

@@jvm_exp

-- Now check whether create java system worked correctly, and if not, back
-- out of everything done in this script
variable jvmrmaction varchar2(30)

declare
  ok int;
  bad int;
begin
  :jvmrmaction := 'NONE';
  select count(*) into ok from obj$ where status=1 and type#=29;
  select count(*) into bad from obj$ where status!=1 and type#=29 and owner#=0;
  if bad > 0 or ok < 100 then
    initjvmaux.abort_message(
     'CREATE JAVA SYSTEM did not complete successfully:',
     'number of java classes with status 1: '|| ok ||', with status != 1: '|| bad);
    initjvmaux.abort_message('Backing out of java installation...');
    :jvmrmaction := 'FULL_REMOVAL';
    initjvmaux.endaction;
  end if;
end;
/

--  create preferences table
@@initprefs.sql

-- :jvmrmaction has been set to 'NONE' at this point if things are OK.
-- In that case the following inclusion will do nothing.
variable jvmudaction varchar2(30)
variable jvmudsubaction varchar2(30)
@@jvmrm

begin if :jvmrmaction = 'NONE' then
  initjvmaux.endaction;
  initjvmaux.setloaded;
 end if;
end;
/

begin if :jvmrmaction = 'NONE' then
   if dbms_java.full_ncomp_enabled = 'OK' then null; end if;
 end if;
end;
/

begin if :jvmrmaction != 'NONE' then
  dbms_output.put_line('drop package initjvmaux');
  execute immediate 'drop package initjvmaux';
  dbms_output.put_line('drop package rmjvm');
  execute immediate 'drop package rmjvm';
  dbms_output.put_line('drop table java$rmjvm$aux');
  execute immediate 'drop table java$rmjvm$aux';
  dbms_output.put_line('drop table java$rmjvm$aux2');
  execute immediate 'drop table java$rmjvm$aux2';
  dbms_output.put_line('#### Done backing out of java installation.');
 end if;
end;
/


