Rem
Rem $Header: initprefs.sql 01-dec-2002.12:41:25 etucker Exp $
Rem
Rem initprefs.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      initprefs.sql - creates the table used by Preferences
Rem
Rem    DESCRIPTION
Rem      creates the java$prefs$ table in SYS for Preferences
Rem      persistent storage.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    etucker     12/01/02  -  add sequence
Rem    etucker     11/15/02  - etucker_jdk14_jce_jsse
Rem    etucker     11/14/02 -  fix names
Rem    etucker     11/06/02 - Created
Rem

call initjvmaux.drp('drop sequence java$prefs$seq$');
call initjvmaux.drp('drop table java$prefs$');

-- Modification timestamp will cycle on Integer.MAX_VALUE
create sequence java$prefs$seq$
maxvalue 2147483647
order
cycle;

-- Persistent storage for preferences
create table java$prefs$
(
        abspath varchar2(4000),
        puser    varchar2(31),
        type    varchar2(2),
        key     varchar2(160),
        value   blob
);

-- The following should make 2 the initial value.
select java$prefs$seq$.NEXTVAL from dual;
insert into java$prefs$ values('SEQUENCE','SYS','S',
                           java$prefs$seq$.NEXTVAL,empty_blob());
commit;
