Rem
Rem $Header: javavm/install/jvm_exp.sql /st_javavm_11.2.0.1.0_gen/1 2010/02/17 16:07:02 etucker Exp $
Rem
Rem dbms_jvm_exp_perms.sql
Rem
Rem Copyright (c) 2005, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dbms_jvm_exp_perms.sql - supports export of java permissions
Rem
Rem    DESCRIPTION
Rem      This package is registered in sys.exppkgobj$.  This will enable
Rem      exporting of all permmissions.  Any permissions different from those
Rem      in the target db will be added to java$policy$ if necessary.
Rem
Rem    NOTES
Rem      import_perms can not be run alone.  It depends on the strings emitted
Rem      by the export_perms() output to create the beginning table.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    etucker     02/17/10 - XbranchMerge etucker_bug-9016295 from main
Rem    etucker     02/08/10 - add public synonmy for backward compatiblity
Rem    etucker     04/02/07 - disable problems
Rem    etucker     06/30/05 - check for enabled 
Rem    etucker     06/28/05 - fix query 
Rem    etucker     06/13/05 - add version check for backward compat 
Rem    etucker     06/08/05 - remove set stuff 
Rem    etucker     05/06/05 - etucker_bug-3993297
Rem    etucker     05/06/05 - more support 
Rem    etucker     05/02/05 - Created
Rem

create or replace package DBMS_JVM_EXP_PERMS AUTHID CURRENT_USER as
  TYPE temp_rec is record (
       kind        dba_java_policy.kind%TYPE,
       grantee     dba_java_policy.grantee%TYPE,
       type_schema dba_java_policy.type_schema%TYPE,
       type_name   dba_java_policy.type_name%TYPE,
       name        dba_java_policy.name%TYPE,
       action      dba_java_policy.action%TYPE,
       enabled     dba_java_policy.enabled%TYPE
       );
     
  TYPE temp_java_policy is table of temp_rec;

  function create_exp(objid IN number, 
                      version in varchar2, 
                      new_block OUT PLS_INTEGER) return varchar2;

  function grant_exp (objid IN NUMBER,
                      isdba IN PLS_INTEGER,
                      grantor OUT VARCHAR2,
                      version IN VARCHAR2,
                      new_block OUT PLS_INTEGER) RETURN varchar2;

  function audit_exp (objid IN NUMBER,
                      version IN VARCHAR2,
                      new_block OUT PLS_INTEGER) RETURN varchar2;

  function drop_exp (objid IN NUMBER,
                     version IN VARCHAR2,
                     new_block OUT PLS_INTEGER) RETURN varchar2;

  function audit_sysprivs_exp (version IN VARCHAR2,
                               new_block OUT PLS_INTEGER ) RETURN varchar2;
  function grant_sysprivs_exp(version IN varchar2,
                              new_block OUT PLS_INTEGER
                             ) return varchar2;
  procedure import_jvm_perms(pcol temp_java_policy);
  function  export_perms(state IN OUT PLS_INTEGER, new_block OUT PLS_INTEGER)
                        return varchar2;
end DBMS_JVM_EXP_PERMS;
/
show errors;

create or replace package body DBMS_JVM_EXP_PERMS as
  EXP_END    CONSTANT PLS_INTEGER := 999999;
  EXP_START  CONSTANT PLS_INTEGER := 0;
  cursor policy_q is select kind, grantee, type_schema,type_name,
                            name,action, enabled from dba_java_policy where
                            enabled='ENABLED';
  zone PLS_INTEGER := EXP_START;


  function grant_sysprivs_exp(version IN varchar2,
                              new_block OUT PLS_INTEGER
                             ) return varchar2 as

  comm_str    varchar2(4000);
  Begin
    -- Check version is >= 10.2
    if version < '10.02.00.00.00' then
      return '';
    end if;

    sys.dbms_zhelp_ir.check_sys_priv(DBMS_ZHELP_IR.KZSSTA);
  
    <<exp_done>>
    if zone = EXP_END then
      zone := EXP_START;
      if policy_q%ISOPEN = TRUE then
        close policy_q;
      end if;
      return '';
    end if;
     
    comm_str := export_perms(zone, new_block);
  
    if comm_str is null then
      zone := EXP_END;
      goto exp_done;
    else
      zone := zone + 1;
      return comm_str;
    end if;
  exception
    when others then 
      zone := EXP_START;
      raise; 
  end grant_sysprivs_exp;

  function create_exp(objid IN number, 
                      version in varchar2, 
                      new_block OUT PLS_INTEGER) return varchar2 as
  Begin
    return '';
  end create_exp;

  function grant_exp (objid IN NUMBER,
                      isdba IN PLS_INTEGER,
                      grantor OUT VARCHAR2,
                      version IN VARCHAR2,
                      new_block OUT PLS_INTEGER) RETURN varchar2 as
  Begin
    return '';
  end grant_exp;

  function audit_exp (objid IN NUMBER,
                      version IN VARCHAR2,
                      new_block OUT PLS_INTEGER) RETURN varchar2 as
  Begin
    return '';
  end audit_exp;

  function audit_sysprivs_exp (version IN VARCHAR2,
                               new_block OUT PLS_INTEGER ) RETURN varchar2 as
  Begin
    return '';
  end audit_sysprivs_exp;

  function drop_exp (objid IN NUMBER,
                     version IN VARCHAR2,
                     new_block OUT PLS_INTEGER) RETURN varchar2 as
  Begin
    return '';
  end drop_exp;

 -- uses the temp_java_perms table built by the first part of import
 -- and adds permissions and policy permissions as necessary.
  procedure import_jvm_perms(pcol temp_java_policy) as

  row_count number;

  key       number;

  POLICYPERM CONSTANT varchar2(50) := 
        'oracle.aurora.rdbms.security.PolicyTablePermission';
  
  class  varchar2(500);
 
  action varchar2(200);

  pol_seq number :=0 ;
  run_seq number :=0 ;

  Begin

    -- Check privs 
    sys.dbms_zhelp_ir.check_sys_priv(DBMS_ZHELP_IR.KZSSTA);

    -- we need to disable the RESTRICTion on RuntimePermission#LoadLibrary
    select seq into pol_seq from dba_java_policy 
           where kind = 'RESTRICT' and type_schema='SYS'
           and type_name = POLICYPERM and 
           name = '0:java.lang.RuntimePermission#loadLibrary.*' and
           enabled='ENABLED';

    if(pol_seq != 0) then
        dbms_java.disable_permission(pol_seq);
    end if;
    
    select seq into run_seq from dba_java_policy
           where kind = 'RESTRICT' and type_schema='SYS'
           and type_name = 'java.lang.RuntimePermission' and 
           name = 'loadLibrary.*' and  enabled='ENABLED';

    if(run_seq != 0) then
        dbms_java.disable_permission(run_seq);
    end if;


    -- This is the main loop that goes through each record 
    -- and check the target dba_java_policy table to see if there is
    -- a like permission there already.  If not then the permission
    -- is created.
        
    for i in pcol.FIRST .. pcol.LAST
    loop
        -- Check if permission is already in dba_java_policy
        select count(*) into row_count from dba_java_policy d where
        pcol(i).kind = d.kind and 
        pcol(i).grantee = d.grantee and
        pcol(i).type_schema = d.type_schema and 
        pcol(i).type_name = d.type_name and
        (pcol(i).name = d.name or (pcol(i).name is null and d.name is null)
         or ((d.name ='*' or d.name is null) and pcol(i).name != null)) and
        (pcol(i).action = d.action or (pcol(i).action is null and 
        d.action is null) or ((d.action = '*' or d.action is null) and
        pcol(i).action != null));
        -- If this is non-zero then we must grant or restrict
        if row_count = 0 then
          -- GRANT
          if pcol(i).kind = 'GRANT' then
          -- Policy Permissions are handled differently
            if pcol(i).type_name = POLICYPERM then
              if(instr(pcol(i).name,'0',1,1) = 0) then
                class := pcol(i).name;
                action := '';
              else
                class := substr(pcol(i).name,3,instr(pcol(i).name,'#',1,1)-3);
                action := substr(pcol(i).name,instr(pcol(i).name,'#',1,1)+1);
              end if;
              dbms_java.grant_policy_permission(pcol(i).grantee, 
                pcol(i).type_schema, class, action, key);
            else -- regular grants
              dbms_java.grant_permission(pcol(i).grantee, 
                pcol(i).type_schema||':'||pcol(i).type_name, 
                pcol(i).name, pcol(i).action,key);
            end if;
          else -- RESTRICT
            if pcol(i).type_name = POLICYPERM then
              dbms_java.restrict_permission(pcol(i).grantee,
                pcol(i).type_schema||':'||POLICYPERM, pcol(i).name,'',key);
            else
               dbms_java.restrict_permission(pcol(i).grantee,
                pcol(i).type_schema||':'||pcol(i).type_name,
                pcol(i).name, pcol(i).action,key);
            end if;
          end if;
          if pcol(i).enabled = 'DISABLE' then 
            dbms_java.disable_permission(key);
          end if;
        else
          goto end_loop;
        end if;
    <<end_loop>>
    null;
    end loop; 

    -- reenable the RESTRICTions run_seq must be first!
    if(run_seq != 0) then
       dbms_java.enable_permission(run_seq);
    end if;
    if( pol_seq != 0) then
       dbms_java.enable_permission(pol_seq);
    end if;
  exception
    WHEN OTHERS THEN
     raise;
  end import_jvm_perms;

  function export_perms(state IN OUT PLS_INTEGER, new_block OUT PLS_INTEGER)
        return varchar2 as

  kind        varchar2(8);
  grantee     varchar2(30);
  type_schema varchar2(30);
  type_name   varchar2(4000);
  name        varchar2(4000);
  action      varchar2(4000);
  enabled     varchar2(8);
       
  Begin
-- open the dba_java_policy cursor and return temp tale creation
    IF policy_q%ISOPEN = FALSE and state = 0 THEN
      open policy_q;
      new_block := 0;
      return 'execute immediate (''CREATE TABLE TEMP_JAVA_PRIVS' ||
             ' AS SELECT KIND, GRANTEE, TYPE_SCHEMA, TYPE_NAME,' ||
             ' NAME, ACTION, ENABLED FROM DBA_JAVA_POLICY WHERE ROWNUM > 1'');';
    end if;
--  Process the insert commands for import.
    if policy_q%ISOPEN = TRUE then
      Fetch policy_q into kind, grantee, type_schema, 
                          type_name, name, action, enabled;
      if policy_q%NOTFOUND OR policy_q%NOTFOUND IS NULL THEN
        close policy_q;
        state := EXP_END -1;
    else
  -- process each row and right the inserts
       if state = 1 then 
         new_block := 1;
       else
         new_block := 0;
       end if;
       return 'INSERT INTO TEMP_JAVA_PRIVS VALUES(''' || kind || ''',''' || 
               grantee || ''',''' || type_schema || ''',''' || type_name ||
               ''',''' || name || ''',''' || action || ''',''' ||
               enabled || ''');';
      end if;
    end if;  
    if state = EXP_END-1 then 
      new_block :=1;
      return 
'DECLARE
   TJP SYS.DBMS_JVM_EXP_PERMS.TEMP_JAVA_POLICY;
   CURSOR C1 IS SELECT KIND,GRANTEE,TYPE_SCHEMA,TYPE_NAME,
                       NAME,ACTION,ENABLED FROM TEMP_JAVA_PRIVS;
BEGIN
   OPEN C1;
   FETCH C1 BULK COLLECT INTO TJP;
   CLOSE C1;
   SYS.DBMS_JVM_EXP_PERMS.IMPORT_JVM_PERMS(TJP);
   EXECUTE IMMEDIATE(''DROP TABLE TEMP_JAVA_PRIVS''); 
END;';
    end if;
-- export is done
    return '';
  end export_perms;

end DBMS_JVM_EXP_PERMS;
/ 
show errors;

DELETE FROM exppkgobj$ where package = 'DBMS_JVM_EXP_PERMS';
insert into sys.exppkgobj$ values('DBMS_JVM_EXP_PERMS', 'SYS', 1, 29, 1, 4000);
commit;



GRANT EXECUTE ON sys.dbms_jvm_exp_perms TO IMP_FULL_DATABASE;
/
GRANT EXECUTE ON sys.dbms_jvm_exp_perms TO DATAPUMP_EXP_FULL_DATABASE;
/

CREATE OR REPLACE PUBLIC SYNONYM dbms_jvm_exp_perms for sys.dbms_jvm_exp_perms;
/
