-- Complete Java downgrade of 11.2.0 database to 9.0.1
-- This script is the part of the downgrade that must be done once 9.0.1 is
-- running.  It loads system classes and support packages without
-- affecting user definitions.

whenever sqlerror exit;

variable test_for_1335603 varchar2(30)

/*
#######################################################################
#######################################################################
  If the following   :test_for_1335603 := 'x'   statement causes
  a PLS-00553 error, and thereby terminates the sqlplus connection,
  simply restart the script in a new sqlplus session.
  This error can occur if the script is run in the same session where
  the database was started.  To avoid this problem, always start a new
  session to run scripts after starting the database.
#######################################################################
#######################################################################
*/

execute :test_for_1335603 := 'x';

whenever sqlerror continue;

-- reload initjvmaux to remove dependencies on dbms_registry
@@initjvmaux

-- get rid of 9.2.0 java status tables.  Old values in these tables will
-- be confusing if the database is ever upgraded back to 9.2.0
drop table java$jvm$status;
drop table java$jvm$steps$done;

-- do a subset of initjvm as part of downgrade
-- Just use the 9.0.1 version of the script that does partial 
-- initjvm for upgrade
@@jvmursc

