-- Remove some portion of the dictionary objects created by initsec.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all java related objects
--  GRADE_REMOVAL:       remove java related objects for general up/downgrade
--  DOWNGRADE_x.y.z_TO_a.b.c: remove or massage system objects as appropriate
--                       when downgrading to release a.b.c
--  NONE:                do nothing

print jvmrmaction

--- The following form will generate errors if the view dba_java_policy
--- is not yet defined, as will typically be the case when this script is
--- called from initsec.  These errors can be ignored.

begin if :jvmrmaction = 'DOWNGRADE_8.1.7_TO_8.1.6' then

if initjvmaux.startstep('REMOVE_JAVA_DEPLOY_PERMISSIONS') then

--- remove JAVA_DEPLOY permissions
initjvmaux.exec('
declare
  CURSOR D is
    select SEQ from dba_java_policy where GRANTEE = ''JAVA_DEPLOY'' ;
  ROW integer;
begin
  open D;
  loop
    fetch D into row;
    exit when D%NOTFOUND;
    -- dbms_output.put_line(row);
    dbms_java.disable_permission(row);
    dbms_java.delete_permission(row);
  end loop;
end;
');


initjvmaux.endstep; end if;

end if; end;
/

begin if :jvmrmaction = 'DOWNGRADE_10.1.0_TO_9.2.0' then

if initjvmaux.startstep('REMOVE_JAVA_UTIL_LOGGING_LOGGINGPERM') then
  initjvmaux.exec('
    declare
      CURSOR D is 
        select SEQ from dba_java_policy where 
          ( name like ''%java.util.logging.LoggingPermission%'' and 
            type_name like ''%.PolicyTablePermission'' ) or 
          type_name = ''java.util.logging.LoggingPermission'' order by type_name;
      ROW integer;
    begin
      open D;
      loop
        fetch D into row;
        exit when D%NOTFOUND;
        -- dbms_output.put_line(row);
        dbms_java.disable_permission(row);
        dbms_java.delete_permission(row);
      end loop;
    end;
      ');
    
  initjvmaux.endstep;    
end if;

if initjvmaux.startstep('REMOVE_JAVAX_SECURITY_AUTH_AUTHPERM') then
  initjvmaux.exec('
    declare
      CURSOR D is 
        select SEQ from dba_java_policy where 
          ( name like ''%javax.security.auth.AuthPermission%'' and 
            type_name like ''%.PolicyTablePermission'' ) or 
          type_name = ''javax.security.auth.AuthPermission'' order by type_name;
      ROW integer;
    begin
      open D;
      loop
        fetch D into row;
        exit when D%NOTFOUND;
        -- dbms_output.put_line(row);
        dbms_java.disable_permission(row);
        dbms_java.delete_permission(row);
      end loop;
    end;
      ');
    
  initjvmaux.endstep;    
end if;

if initjvmaux.startstep('REMOVE_JAVA_AWT_AWTPERMISSION') then
  initjvmaux.exec('
    declare
      CURSOR D is 
        select SEQ from dba_java_policy where 
          ( name like ''%java.awt.AWTPermission%'' and 
            type_name like ''%.PolicyTablePermission'' ) or 
          type_name = ''java.awt.AWTPermission'' order by type_name;
      ROW integer;
    begin
      open D;
      loop
        fetch D into row;
        exit when D%NOTFOUND;
        -- dbms_output.put_line(row);
        dbms_java.disable_permission(row);
        dbms_java.delete_permission(row);
      end loop;
    end;
      ');
    
  initjvmaux.endstep; 
end if;

if initjvmaux.startstep('REMOVE_JAVAX_NET_SSL_SSLPERMISSION') then
  initjvmaux.exec('
    declare
      CURSOR D is 
        select SEQ from dba_java_policy where 
          ( name like ''%javax.net.ssl.SSLPermission%'' and 
            type_name like ''%.PolicyTablePermission'' ) or 
          type_name = ''javax.net.ssl.SSLPermission'' order by type_name;
      ROW integer;
    begin
      open D;
      loop
        fetch D into row;
        exit when D%NOTFOUND;
        -- dbms_output.put_line(row);
        dbms_java.disable_permission(row);
        dbms_java.delete_permission(row);
      end loop;
    end;
      ');
    
  initjvmaux.endstep;
end if;

if initjvmaux.startstep('REMOVE_JAVA_SECURITY_ALLPERMISSION') then
  initjvmaux.exec('
    declare
      CURSOR D is 
        select SEQ from dba_java_policy where 
          ( name like ''%java.security.AllPermission%'' and 
            type_name like ''%.PolicyTablePermission'' ) or 
            type_name = ''java.security.AllPermission'' order by type_name;
      ROW integer;
    begin
      open D;
      loop
        fetch D into row;
        exit when D%NOTFOUND;
        -- dbms_output.put_line(row);
        dbms_java.disable_permission(row);
        dbms_java.delete_permission(row);
      end loop;
    end;
      ');
    
  initjvmaux.endstep;
end if;
end if;end;
/

begin if :jvmrmaction = 'DOWNGRADE_9.2.0_TO_9.0.1' then

if initjvmaux.startstep('REMOVE_JAVA_DEPLOY_FILE_PERMISSIONS') then

  initjvmaux.exec('
  begin
  dbms_java.revoke_permission( ''JAVA_DEPLOY'', ''SYS:java.io.FilePermission'', ''javavm/admin/*'', ''write'' );
  dbms_java.revoke_permission( ''JAVA_DEPLOY'', ''SYS:java.io.FilePermission'', ''javavm/deploy/*'', ''read'' );
  end;
  ');

  initjvmaux.endstep;

end if;

if initjvmaux.startstep('REMOVE_SQLPERMISSION_PERMISSIONS') then

  --- remove SQLPermission related rows
  initjvmaux.exec('
    declare
      CURSOR D is 
        select SEQ from dba_java_policy where 
          ( name like ''%java.sql.SQLPermission%'' and 
            type_name like ''%.PolicyTablePermission'' ) or 
          type_name = ''java.sql.SQLPermission'' order by type_name;
      ROW integer;
    begin
      open D;
      loop
        fetch D into row;
        exit when D%NOTFOUND;
        -- dbms_output.put_line(row);
        dbms_java.disable_permission(row);
        dbms_java.delete_permission(row);
      end loop;
    end;
      ');
    
  initjvmaux.endstep; end if;
  
end if; end;
/   

begin if :jvmrmaction = 'FULL_REMOVAL' or 
         (:jvmrmaction = 'DOWNGRADE_8.1.7_TO_8.1.6' and
          initjvmaux.startstep('DROP_817_SECURITY_TABLES_ETC')) then

initjvmaux.drp('drop TABLE java$policy$shared$table');
initjvmaux.drp('drop ROLE java_deploy');

if :jvmrmaction = 'DOWNGRADE_8.1.7_TO_8.1.6' then initjvmaux.endstep; end if;

end if;end;
/

begin if :jvmrmaction = 'FULL_REMOVAL' or
         (:jvmrmaction = 'DOWNGRADE_8.1.6_TO_8.1.5' and
          initjvmaux.startstep('DROP_816_SECURITY_TABLES_ETC')) then

initjvmaux.drp('drop TABLE java$policy$');
initjvmaux.drp('drop SEQUENCE java$policy$sequence$');
initjvmaux.drp('drop VIEW dba_java_policy');
initjvmaux.drp('drop PUBLIC SYNONYM dba_java_policy');
initjvmaux.drp('drop VIEW user_java_policy');
initjvmaux.drp('drop PUBLIC SYNONYM user_java_policy');
initjvmaux.drp('drop ROLE java_admin');

if :jvmrmaction = 'DOWNGRADE_8.1.6_TO_8.1.5' then initjvmaux.endstep; end if;

end if;end;
/

begin if :jvmrmaction = 'FULL_REMOVAL' then

-- We go through and drop all shared data objects with names
-- beginning with JAVA$POLICY$SHARED$ 

initjvmaux.exec('delete from obj$ where type#=56 and name like ''JAVA$POLICY$SHARED$%''');

end if;end;
/
