set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4352 - APEX - Workspace Admin
--
-- Application Export:
--   Application:     4352
--   Name:            APEX - Workspace Admin
--   Date and Time:   14:24 Thursday May 28, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.09
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                88
--     Items:             263
--     Computations:       17
--     Validations:        54
--     Processes:          83
--     Regions:           339
--     Buttons:            64
--   Shared Components
--     Breadcrumbs:         1
--        Entries          83
--     Items:               5
--     Computations:        1
--     Processes:           0
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             2
--     Lists:              36
--     Shortcuts:           3
--     Themes:              0
--     Templates:
--        Page:             5
--        List:            13
--        Report:           4
--        Label:            3
--        Region:          13
--     Messages:            0
--     Build Options:       4
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4352;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4352);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4352);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4352,
  p_display_id=> 4352,
  p_owner => 'APEX_030200',
  p_name  => 'APEX - Workspace Admin',
  p_alias => 'A198389109950435918',
  p_page_view_logging => 'YES',
  p_default_page_template=> 6322904659084760.4352 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 6322904659084760.4352 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 60932116232746047.4352 + wwv_flow_api.g_id_offset,
  p_error_template    => 6322904659084760.4352 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_page_protection_enabled_y_n=> 'N',
  p_checksum_salt_last_reset => '20090528141912',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4500:1000:&SESSION.',
  p_flow_language     => 'fr',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => 'development_service_home_login',
  p_logout_url        => 'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_application_tab_set=> 1,
  p_logo_image => '#IMAGE_PREFIX#htmldb/apex_logo.gif',
  p_logo_image_attributes => 'width="300" height="30" alt="&PRODUCT_NAME."',
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(60874129745270430 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.09',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_csv_encoding    => 'Y',
  p_theme_id => 3,
  p_default_label_template => 107534131274292840.4352 + wwv_flow_api.g_id_offset,
  p_default_report_template => 6659715068668103.4352 + wwv_flow_api.g_id_offset,
  p_default_list_template => 77000120193659142.4352 + wwv_flow_api.g_id_offset,
  p_substitution_string_01 => 'LOGOUT',
  p_substitution_value_01  => 'Déconnexion',
  p_substitution_string_02 => 'PRODUCT_NAME',
  p_substitution_value_02  => 'Application Express',
  p_substitution_string_03 => 'MSG_COMPANY',
  p_substitution_value_03  => 'Espace de travail : &COMPANY.',
  p_substitution_string_04 => 'MSG_LANGUAGE',
  p_substitution_value_04  => 'Langue',
  p_substitution_string_05 => 'MSG_COPYRIGHT',
  p_substitution_value_05  => 'Copyright &copy; 1999, 2009, Oracle. Tous droits réservés.',
  p_substitution_string_06 => 'MSG_USER',
  p_substitution_value_06  => 'Utilisateur',
  p_substitution_string_07 => 'MSG_JSCRIPT',
  p_substitution_value_07  => 'JavaScript doit être activé lorsque vous exécutez ce produit.',
  p_substitution_string_08 => 'MSG_TBL_SUMMARY',
  p_substitution_value_08  => 'Table de mise en page',
  p_substitution_string_09 => 'DONE',
  p_substitution_value_09  => 'Terminé',
  p_substitution_string_10 => 'TOP',
  p_substitution_value_10  => 'Haut',
  p_substitution_string_11 => 'CLOSE',
  p_substitution_value_11  => 'Fermer',
  p_substitution_string_12 => 'EDIT',
  p_substitution_value_12  => 'Modifier',
  p_substitution_string_13 => 'DATE_FORMAT',
  p_substitution_value_13  => 'dd/mm/rr',
  p_substitution_string_14 => 'LONG_DATE_FORMAT',
  p_substitution_value_14  => 'fmDay dd Month yyyy',
  p_substitution_string_15 => 'TIME_FORMAT',
  p_substitution_value_15  => 'hh24:mi:ss',
  p_substitution_string_16 => 'DATE_TIME_FORMAT',
  p_substitution_value_16  => 'dd/mm/rr hh24:mi:ss',
  p_substitution_string_17 => 'DELETE_MSG',
  p_substitution_value_17  => 'Voulez-vous effectuer cette action de suppression ?',
  p_last_updated_by => 'APEX_030200',
  p_last_upd_yyyymmddhh24miss=> '20090528141912',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39889506306174688.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 10,
  p_icon_image     => '',
  p_icon_subtext   => 'Aide',
  p_icon_target    => 'javascript:popupURL(''wwv_flow_help.show_help?p_lang=&BROWSER_LANGUAGE.&p_session=&APP_SESSION.&p_flow_id=&APP_TRANSLATION_ID.&p_step_id=&APP_TRANSLATION_PAGE_ID.'');',
  p_icon_image_alt => 'Aide',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '73',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39960115843641093.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 20,
  p_icon_image     => '',
  p_icon_subtext   => 'Déconnexion',
  p_icon_target    => 'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_icon_image_alt => 'Déconnexion',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '73',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
--application/shared_components/logic/application_items/company
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 47267012470443025.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'COMPANY',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fb_flow_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 61498215760312449.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FB_FLOW_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'same as flow 4000 fb_flow_id');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fb_flow_page_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 61665618599751270.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FB_FLOW_PAGE_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 72751304929301595.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_AFTER_LOGIN_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used by Custom2 authentication for deep linking support');
 
null;
 
end;
/

--application/shared_components/logic/application_items/last_view
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 48609214118039317.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'LAST_VIEW',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
--application/shared_components/logic/application_computations/company
wwv_flow_api.create_flow_computation (
  p_id => 47267211793445016.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'COMPANY',
  p_computation_point    => 'BEFORE_HEADER',
  p_computation_type => 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'wwv_flow.get_company_name;',
  p_compute_when=> 'COMPANY',
  p_compute_when_type=> 'ITEM_IS_NULL',
  p_computation_error_message=>'Erreur lors de la définition de l''espace de travail.',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/account_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2740022841418968.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ACCOUNT STATUS',
  p_lov_query=> '.'||to_char(2740022841418968 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2740201351418968.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>2740022841418968.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Comptes verrouillés',
  p_lov_return_value=>'LOCKED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2741315831435879.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>2740022841418968.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Compte expiré',
  p_lov_return_value=>'EXPIRED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2740411765418968.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>2740022841418968.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Comptes déverrouillés',
  p_lov_return_value=>'UNLOCKED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2740609662418968.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>2740022841418968.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Mon compte',
  p_lov_return_value=>'MY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>12456720246979195.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>2740022841418968.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Comptes de développeur',
  p_lov_return_value=>'DEV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/account_lock_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6949526744661130.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ACCOUNT_LOCK_STATUS',
  p_lov_query=> '.'||to_char(6949526744661130 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6949718368661130.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>6949526744661130.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Verrouillé',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6949911078661130.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>6949526744661130.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Déverrouillé',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_build_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 128034726363912582.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION BUILD STATUS',
  p_lov_query=> '.'||to_char(128034726363912582 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>128035028761912584.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>128034726363912582.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Exécuter l''application uniquement',
  p_lov_return_value=>'RUN_ONLY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>128035201383912585.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>128034726363912582.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Exécuter et construire l''application',
  p_lov_return_value=>'RUN_AND_BUILD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_opt
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87986129403049299.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION.OPT',
  p_lov_query=> '.'||to_char(87986129403049299 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87986300136049300.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87986129403049299.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Toutes les applications',
  p_lov_return_value=>'A',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87986529393049300.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87986129403049299.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Groupe par application',
  p_lov_return_value=>'F',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/audit_naming
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUDIT_NAMING',
  p_lov_query=> '.'||to_char(27067106427412398 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27067418961412413.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Attributs d''application',
  p_lov_return_value=>'WWV_FLOWS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27067615785412414.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Modèle de page',
  p_lov_return_value=>'WWV_FLOW_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27067821285412414.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Barre de navigation',
  p_lov_return_value=>'WWV_FLOW_ICON_BAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27068018297412414.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Processus d''application',
  p_lov_return_value=>'WWV_FLOW_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27068231633412415.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Elément d''application',
  p_lov_return_value=>'WWV_FLOW_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27068428780412415.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Calcul d''application',
  p_lov_return_value=>'WWV_FLOW_COMPUTATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27068600233412415.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Onglets',
  p_lov_return_value=>'WWV_FLOW_TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27068829004412415.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Onglet parent',
  p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27069029470412416.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Liste de valeurs (LOV)',
  p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES$',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27069224657412416.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Valeurs de liste de valeurs (LOV) statique',
  p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES_DATA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192815107467123331.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Entrée d''historique des accès',
  p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192920211428952731.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Thèmes',
  p_lov_return_value=>'WWV_FLOW_THEMES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27069403307412416.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Attributs de page',
  p_lov_return_value=>'WWV_FLOW_STEPS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27069616679412416.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Bouton de page',
  p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27069821202412416.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Branchement de page',
  p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27070027988412417.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>14,
  p_lov_disp_value=>'Arguments de branchement de page',
  p_lov_return_value=>'WWV_FLOW_STEP_BRANCH_ARGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27070221339412417.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Elément de page',
  p_lov_return_value=>'WWV_FLOW_STEP_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27071724781417713.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'Calcul de page',
  p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27072029975419290.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>17,
  p_lov_disp_value=>'Validation de page',
  p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27072303095420909.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>18,
  p_lov_disp_value=>'Processus de page',
  p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27072608636422556.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>19,
  p_lov_disp_value=>'Modèle de région',
  p_lov_return_value=>'WWV_FLOW_PAGE_PLUG_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27072914523424290.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Modèle de ligne',
  p_lov_return_value=>'WWV_FLOW_ROW_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27073219717425765.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>21,
  p_lov_disp_value=>'Modèle de liste',
  p_lov_return_value=>'WWV_FLOW_LIST_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27073525951427595.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>22,
  p_lov_disp_value=>'Attributs de région',
  p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27073802879430378.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>23,
  p_lov_disp_value=>'Messages',
  p_lov_return_value=>'WWV_FLOW_MESSAGES$',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27074108074431803.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>24,
  p_lov_disp_value=>'Options de construction',
  p_lov_return_value=>'WWV_FLOW_PATCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27074413269433395.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>25,
  p_lov_disp_value=>'Développeurs d''application (administration)',
  p_lov_return_value=>'WWV_FLOW_DEVELOPERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27074718809434925.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>26,
  p_lov_disp_value=>'Listes',
  p_lov_return_value=>'WWV_FLOW_LISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27075025043436756.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>27,
  p_lov_disp_value=>'Elément de liste',
  p_lov_return_value=>'WWV_FLOW_LIST_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27075332315438853.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>28,
  p_lov_disp_value=>'ID utilisateur réel (administration)',
  p_lov_return_value=>'WWV_FLOW_EFFECTIVE_USERID_MAP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27075705781440636.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>29,
  p_lov_disp_value=>'Raccourcis',
  p_lov_return_value=>'WWV_FLOW_SHORTCUTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27076012361442576.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Texte d''aide sur élément de page',
  p_lov_return_value=>'WWV_FLOW_STEP_ITEM_HELP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27076318248444200.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>31,
  p_lov_disp_value=>'Configurations d''authentification',
  p_lov_return_value=>'WWV_FLOW_CUSTOM_AUTH_SETUPS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27076624481446067.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>32,
  p_lov_disp_value=>'Points d''entrée',
  p_lov_return_value=>'WWV_FLOW_ENTRY_POINTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27076929330447428.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>27067106427412398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>33,
  p_lov_disp_value=>'Arguments de point d''entrée',
  p_lov_return_value=>'WWV_FLOW_ENTRY_POINT_ARGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/available_applications
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 249067832108758740.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AVAILABLE.APPLICATIONS',
  p_lov_query=> 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id )'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id))'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/build_option_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 140229800819566260.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUILD OPTION STATUS',
  p_lov_query=> '.'||to_char(140229800819566260 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>140230006090566264.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>140229800819566260.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Exclure',
  p_lov_return_value=>'EXCLUDE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>140230221897566265.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>140229800819566260.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Inclure',
  p_lov_return_value=>'INCLUDE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/error_components
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ERROR COMPONENTS',
  p_lov_query=> '.'||to_char(213967127754264881 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213967320847264904.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elément numérique',
  p_lov_return_value=>'numeric_item',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213967522885264905.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Lien profond',
  p_lov_return_value=>'deep_link',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213967714663264905.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Processus de définition d''élément',
  p_lov_return_value=>'set_item_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213967927620264905.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Panneau tabulaire - Processus d''ajout',
  p_lov_return_value=>'add_rows_to_tabular_form',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213968132430264906.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Panneau tabulaire - Processus de mise à jour',
  p_lov_return_value=>'multi_row_update_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213968319995264906.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Panneau tabulaire - Processus de suppression',
  p_lov_return_value=>'multi_row_delete_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213968503762264906.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Processus d''extraction de ligne',
  p_lov_return_value=>'dml_fetch_row_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213968724423264906.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Processus de service Web',
  p_lov_return_value=>'web_service_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213968927764264907.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Processus de traitement de ligne',
  p_lov_return_value=>'dml_process_row_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6204524790478230.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Etat',
  p_lov_return_value=>'report',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213969130796264907.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Processus à la demande',
  p_lov_return_value=>'on_demand_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213991320267272102.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Calcul d''attribution de préférence à l''élément',
  p_lov_return_value=>'set_item_eq_preference_computation',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>217558320349371396.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Condition PL/SQL',
  p_lov_return_value=>'plsql_condition',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>217562125113391685.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Condition SQL',
  p_lov_return_value=>'sql_condition',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>217566117626398980.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Condition Existe ou N''existe pas',
  p_lov_return_value=>'exists_condition',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213969326112264907.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Processus d''obtention de la valeur de la clé primaire suivante ou précédente',
  p_lov_return_value=>'get_next_or_prev_pk_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213969502182264907.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Processus de définition de préférence',
  p_lov_return_value=>'set_preference_process',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213970706415268145.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Calcul d''interrogation',
  p_lov_return_value=>'query_computation',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213991925115273511.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Calcul SQL ou PL/SQL',
  p_lov_return_value=>'sql_or_plsql_computation',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>217558927275373351.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Condition de corps de fonction PL/SQL',
  p_lov_return_value=>'plsql_function_body_condition',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213992700658275906.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Calcul de corps de fonction PL/SQL',
  p_lov_return_value=>'plsql_function_body_computation',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213993708970278348.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Validation SQL d''existence ou de non existence',
  p_lov_return_value=>'exists_noexists_validation',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213994314164279816.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Validation d''erreur PL/SQL',
  p_lov_return_value=>'plsql_error_validation',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213995019705281413.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Validation de corps de fonction',
  p_lov_return_value=>'function_body_validation',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213997002867286002.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Validation de corps de fonction PL/SQL renvoyant une valeur booléenne',
  p_lov_return_value=>'function_body_returning_boolean_validation',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213998211525288587.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Branchement',
  p_lov_return_value=>'branch',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213999116719290082.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Définir un élément',
  p_lov_return_value=>'set_page_item_source',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>213999821568291451.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Définir une base de données privée virtuelle',
  p_lov_return_value=>'set_vpd',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214000123646292003.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'Effacer le cache',
  p_lov_return_value=>'clear_cache',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214000527455293116.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'Sauvegarder le statut de session',
  p_lov_return_value=>'save_session_state',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214000932650294668.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'Validation',
  p_lov_return_value=>'error_performing_validations',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214001904037295831.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'Validation',
  p_lov_return_value=>'error_performing_after_submit_processes',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214002814080298744.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'Condition d''expression PL/SQL',
  p_lov_return_value=>'check_cond_plsql_expresion',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214003320660300665.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'Fonction renvoyant une interrogation SQL',
  p_lov_return_value=>'function_returning_sql_query',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214004324469301777.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'Raccourci',
  p_lov_return_value=>'shortcut',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214004928625302922.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'Graphique SVG',
  p_lov_return_value=>'svg_chart',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214005332434304022.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'Service Web',
  p_lov_return_value=>'web_service',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214005802437304830.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'Graphique',
  p_lov_return_value=>'chart',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214007008324306555.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'Processus PL/SQL',
  p_lov_return_value=>'plsql_procedure',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214007511094307342.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'Calendrier',
  p_lov_return_value=>'calendar',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214007915250308517.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'Processus d''aide',
  p_lov_return_value=>'help',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214008318713309562.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'Région d''URL',
  p_lov_return_value=>'url_region',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214009321483310394.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'Liste',
  p_lov_return_value=>'list',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214009624600311246.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'Entrée de liste',
  p_lov_return_value=>'list_entry',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>214010231180313173.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>213967127754264881.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'Fonction SQL PL/SQL renvoyant une interrogation SQL',
  p_lov_return_value=>'function_returning_sql_query',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/expire_user_accounts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4834509455047185.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPIRE USER ACCOUNTS',
  p_lov_query=> '.'||to_char(4834509455047185 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4834812383047193.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>4834509455047185.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Activer',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4835016591047194.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>4834509455047185.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Désactiver',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_developers
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17062423464336902.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_DEVELOPERS',
  p_lov_query=> 'select htf.escape_sc(USERID) d, USERID r'||chr(10)||
'from  WWV_FLOW_developers'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/fnd_users
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17066627882357077.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FND USERS',
  p_lov_query=> 'select htf.escape_sc(user_name) d, user_name r'||chr(10)||
'from wwv_flow_fnd_user'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/icon_or_detail
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 135219829572410772.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ICON OR DETAIL',
  p_lov_query=> '.'||to_char(135219829572410772 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135220002122410781.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>135219829572410772.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Icônes',
  p_lov_return_value=>'ICON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135220205520410794.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>135219829572410772.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Détails',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/license_terms
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87991106556118398.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LICENSE.TERMS',
  p_lov_query=> '.'||to_char(87991106556118398 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87991314955118399.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87991106556118398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Je ne suis pas citoyen, ressortissant ou résident des pays suivants, ni ne suis sous le contrôle de ceux-ci : Cuba, Iran, Soudan, Irak, Libye, Corée du Nord, Syrie ou tout autre pays vers lesquels les Etats-Unis ont interdit les exportations.',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87991524166118399.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87991106556118398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Je ne téléchargerai pas les programmes, ni ne les exporterai ou réexporterai, directement ou indirectement, vers les pays cités ci-dessus, ni vers des citoyens, des ressortissants ou des résidents de ces pays.',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87991705582118400.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87991106556118398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Je ne figure pas dans les listes suivantes du département des Finances (Department of Treasury) américain : Specially Designated Nationals, Specially Designated Terrorists et Specially Designated Narcotic Traffickers. Je ne figure pas non plus dans la table suivante du département du Commerce (Department of Commerce) américain : Denial Orders.',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87991919165118400.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87991106556118398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Je ne téléchargerai pas les programmes, ni ne les exporterai ou réexporterai, directement ou indirectement, à destination de personnes figurant dans les listes ci-dessus.',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87992103676118400.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87991106556118398.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Je n''utiliserai pas les programmes, ni n''en autoriserai l''utilisation, dans un but contrevenant à la loi des Etats-Unis, y compris pour le développement, la conception, la fabrication ou la production d''armes nucléaires, chimiques ou biologiques de destruction massive.',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 75646032643247381.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS',
  p_lov_query=> 'select htf.escape_sc(schema) d, schema r'||chr(10)||
''||chr(10)||
'from   wwv_flow_company_schemas'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/login_status_codes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOGIN STATUS CODES',
  p_lov_query=> '.'||to_char(42705425134693211 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42705704364693212.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Authentification normale, réussie',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42705921465693213.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Nom utilisateur inconnu',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42706121390693213.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Compte verrouillé',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42706310776693213.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Compte expiré',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42706524529693213.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Mot de passe incorrect',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42706719666693213.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Première utilisation du mot de passe',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42706921482693213.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Nombre maximal de tentatives de connexion dépassé',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42707119263693213.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42705425134693211.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Erreur interne inconnue',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_a
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_A',
  p_lov_query=> '.'||to_char(87960028308944903 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87960228677944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87960404998944904.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87960630117944904.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87960804805944904.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87961014605944904.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87961204075944904.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87961414470944905.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87961615644944905.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87961828775944905.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87960028308944903.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_b
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_B',
  p_lov_query=> '.'||to_char(87962402466946929 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87962624364946930.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87962825427946930.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87963028889946930.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87963219513946930.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87963422128946931.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87963617026946932.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87963820242946932.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87964018632946932.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87964228487946933.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87962402466946929.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_c
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_C',
  p_lov_query=> '.'||to_char(87964809046948816 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87965020267948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87965202237948817.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87965404786948817.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87965623655948817.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87965801422948818.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'40',
  p_lov_return_value=>'40',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87966019499948818.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87966204425948818.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87966405087948818.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87966620020948818.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87966830048948820.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87967016319948821.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87967217418948821.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'10000',
  p_lov_return_value=>'10000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87967415888948821.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87964809046948816.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'50000',
  p_lov_return_value=>'50000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_d
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_D',
  p_lov_query=> '.'||to_char(87968118050951423 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87968314659951424.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87968522241951424.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87968709744951424.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87968903454951425.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87969114479951425.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87969329781951426.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87969508652951427.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87969708972951427.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87969903261951427.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87968118050951423.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'10000',
  p_lov_return_value=>'10000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_or_existing_schema
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 245496725063109254.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW_OR_EXISTING_SCHEMA',
  p_lov_query=> '.'||to_char(245496725063109254 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>245497113141109261.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>245496725063109254.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Demander un nouveau schéma',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>245496930435109257.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>245496725063109254.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Utiliser un schéma existant',
  p_lov_return_value=>'NO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/operating_systems
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OPERATING.SYSTEMS',
  p_lov_query=> '.'||to_char(87980828664020704 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87981029047020705.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'HP-Tru64Unix',
  p_lov_return_value=>'HP-Tru64Unix',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87981205950020705.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'HP-UX',
  p_lov_return_value=>'HP-UX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87981403269020706.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'IBM-AIX',
  p_lov_return_value=>'IBM-AIX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87981618293020706.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Linux',
  p_lov_return_value=>'Linux',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87981814646020706.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'MS-NT',
  p_lov_return_value=>'MS-NT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87982016496020707.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'MS-WIN2000',
  p_lov_return_value=>'MS-WIN2000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87982226769020707.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'MS-XP',
  p_lov_return_value=>'MS-XP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87982430599020707.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Autre',
  p_lov_return_value=>'Other',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87982601452020707.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'UNIX',
  p_lov_return_value=>'OtherUnix',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87982816960020707.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87980828664020704.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Sun-Solaris',
  p_lov_return_value=>'Sun-Solaris',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 228539708561074614.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE MODE',
  p_lov_query=> '.'||to_char(228539708561074614 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>228539924927074625.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>228539708561074614.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dynamique',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>228540132030074635.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>228539708561074614.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Cache créé',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>228540313915074635.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>228539708561074614.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Mis en mémoire cache',
  p_lov_return_value=>'R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>130988608718459028.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>228539708561074614.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Traitement de page',
  p_lov_return_value=>'A',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131016603205684510.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>228539708561074614.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Page partielle',
  p_lov_return_value=>'P',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/person_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87979323684009856.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PERSON.TYPE',
  p_lov_query=> '.'||to_char(87979323684009856 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87979519786009857.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87979323684009856.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Employé',
  p_lov_return_value=>'E',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87979702743009857.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87979323684009856.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Sous-traitant',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/plsql_editing_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 113937100137241641.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PLSQL EDITING STATUS',
  p_lov_query=> '.'||to_char(113937100137241641 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113937313482241642.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>113937100137241641.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Autoriser la modification d''unités de programme PL/SQL',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113937510829241642.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>113937100137241641.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Ne pas autoriser la modification d''unités de programme PL/SQL',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/preference_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 42506917060665623.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PREFERENCE TYPES',
  p_lov_query=> '.'||to_char(42506917060665623 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42507201651665624.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42506917060665623.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Tri de pages',
  p_lov_return_value=>'SORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42507416214665624.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42506917060665623.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Autre',
  p_lov_return_value=>'OTHER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42507628021665624.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42506917060665623.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Valeur d''élément inter-session',
  p_lov_return_value=>'ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/privileges
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRIVILEGES',
  p_lov_query=> '.'||to_char(87973907708976827 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87974125418976828.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Administration',
  p_lov_return_value=>'ADMIN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87974326105976828.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Parcourir',
  p_lov_return_value=>'BROWSE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87974520374976829.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Créer',
  p_lov_return_value=>'CREATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87974700192976829.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Programme de chargement de données',
  p_lov_return_value=>'DATA_LOADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87974908440976829.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Moniteur de BdD',
  p_lov_return_value=>'DB_MONITOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87975104201976829.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Modifier',
  p_lov_return_value=>'EDIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87975319689976830.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Aide',
  p_lov_return_value=>'HELP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87975514156976830.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Surveiller',
  p_lov_return_value=>'MONITOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87975715979976830.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'SQL',
  p_lov_return_value=>'SQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87975929098976830.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>87973907708976827.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Gestionnaire d''utilisateurs',
  p_lov_return_value=>'USER_MANAGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/recent_time
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 876530482469714.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'RECENT TIME',
  p_lov_query=> 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/region_caching_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 42414417202633712.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REGION CACHING OPTIONS',
  p_lov_query=> '.'||to_char(42414417202633712 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42414713865633714.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42414417202633712.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Mis en mémoire cache',
  p_lov_return_value=>'CACHED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42414915904633714.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42414417202633712.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Mis en mémoire cache par l''utilisateur',
  p_lov_return_value=>'CACHED_BY_USER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42415123252633714.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42414417202633712.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Non mis en mémoire cache',
  p_lov_return_value=>'NOT_CACHED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/show_all_or_cached_pages
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 42450922059777772.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SHOW ALL OR CACHED PAGES',
  p_lov_query=> '.'||to_char(42450922059777772 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42451116170777773.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42450922059777772.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Toutes les pages',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42451322267777773.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>42450922059777772.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Pages en mémoire cache',
  p_lov_return_value=>'CACHED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/show_more_columns_checkbox
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17777219154823135.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SHOW MORE COLUMNS CHECKBOX',
  p_lov_query=> '.'||to_char(17777219154823135 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17777414218823135.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>17777219154823135.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Afficher des colonnes d''état supplémentaires',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no_returns_y_or_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 157815226475866526.4352 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES_NO_RETURNS_Y_OR_N',
  p_lov_query=> '.'||to_char(157815226475866526 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157815523644866535.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>157815226475866526.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Oui',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157815717308866538.4352 + wwv_flow_api.g_id_offset,
  p_lov_id=>157815226475866526.4352 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Non',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_.4352
prompt  ...PAGE .4352: Page zéro
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => .4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Page zéro',
  p_step_title=> '',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215451130329541858+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161842',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'1572317499226756';

wwv_flow_api.create_page_plug (
  p_id=> 1582031051259050.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4352,
  p_plug_name=> 'Application Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_07',
  p_plug_source=> s,
  p_plug_source_type=> 1463127941038372 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page .4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_2.435
prompt  ...PAGE 2.4352: Utilisation de tablespace de schéma
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_schema_rpts.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 2.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Utilisation de tablespace de schéma',
  p_step_title=> 'Utilisation de tablespace de schéma',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215667724760013351+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161842',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>2.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.schema, c.name def_tablespace'||chr(10)||
'  from wwv_flow_company_schemas a, sys.user$ b, sys.ts$ c'||chr(10)||
' where a.schema = :p2_schema and'||chr(10)||
'       b.name = :p2_schema '||chr(10)||
'   and b.datats# = c.ts#'||chr(10)||
'   and a.security_group_id = wwv_flow.get_sgid'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 5783706478780036.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4352,
  p_name=> 'Schéma',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P2_SCHEMA',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '50',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5784013471780043.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5783706478780036.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schéma :',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5784111298780043.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5783706478780036.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DEF_TABLESPACE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Tablespace par défaut :',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select t.tablespace_name name, (( select sum(bytes)'||chr(10)||
'                                    from sys.dba_free_space'||chr(10)||
'                                   where tablespace_name = t.tablespace_name'||chr(10)||
'                                ))/1024/1024 free '||chr(10)||
'                from sys.dba_tablespaces t '||chr(10)||
'              where tablespace_name in ( select distinct(tablespace_name) '||chr(10)||
'                                         ';

s:=s||'from sys.dba_segments '||chr(10)||
'                                         where owner = :P2_SCHEMA )';

wwv_flow_api.create_report_region (
  p_id=> 5784712365781713.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4352,
  p_name=> 'Tablespace(s)',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P2_SCHEMA',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '50',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5904028247808259.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5784712365781713.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5904325214808260.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5784712365781713.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'FREE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Mo libres',
  p_column_format=> '999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Chaque espace de travail a accès à un ou plusieurs schémas de base de données. Cette page présente tous les détails sur chaque schéma.';

wwv_flow_api.create_page_plug (
  p_id=> 5871829174600336.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4352,
  p_plug_name=> 'Détails de schéma',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select schema'||chr(10)||
'from   wwv_flow_company_schemas'||chr(10)||
'where  security_group_id = :flow_security_group_id'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 5873031776638945.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4352,
  p_name=> 'Schémas d''espace de travail',
  p_region_name=>'',
  p_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_05',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11670410466357416.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 07-APR-2004 15:37:37');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5873328941638951.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5873031776638945.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 1,
  p_column_heading=> 'SCHEMA',
  p_column_link=>'f?p=&APP_ID.:2:#APP_SESSION#::::P2_SCHEMA:#SCHEMA#',
  p_column_linktext=>'#SCHEMA#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5909606954839993.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'6621926453040443';

wwv_flow_api.create_page_plug (
  p_id=> 6624822428048770.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4352,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 6621926453040443 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 182271012856475081.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>182441124506115587.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:2:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Identifiez un schéma.';

wwv_flow_api.create_page_item(
  p_id=>5875420478645168.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4352,
  p_name=>'P2_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 182271012856475081.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schéma :',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(a.schema) d, a.schema r'||chr(10)||
'  from wwv_flow_company_schemas a'||chr(10)||
' where a.security_group_id = (select wwv_flow.get_sgid from dual)'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Sélectionner un schéma -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>182440902719115584.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4352,
  p_name=>'P2_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 182271012856475081.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:P2_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 41649010980957394.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4352,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur',
  p_process_when=>'P2_SCHEMA',
  p_process_when_type=>'ITEM_NOT_NULL_OR_ZERO',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 2.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_3.435
prompt  ...PAGE 3.4352: Administration d'espace de travail &PRODUCT_NAME.
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_hm.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 3.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Administration d''espace de travail &PRODUCT_NAME.',
  p_step_title=> 'Administration d''espace de travail &PRODUCT_NAME.',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215451130329541858+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161843',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>3.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 842732344294669.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4352,
  p_plug_name=> 'Administration Services',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 841126672283661 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_footer=> '<p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_required_patch=> '-274880608012467905.4352' + wwv_flow_api.g_id_offset,
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select schema'||chr(10)||
'from   wwv_flow_company_schemas'||chr(10)||
'where  security_group_id = :flow_security_group_id'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 1775115710172455.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4352,
  p_name=> 'Schémas d''espace de travail',
  p_region_name=>'',
  p_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_05',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_display_condition_type=> 'NEVER',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11670410466357416.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_comment=>'generated 07-APR-2004 15:37:37');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 1775329504172459.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1775115710172455.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 1,
  p_column_heading=> 'SCHEMA',
  p_column_link=>'f?p=&APP_ID.:2:#APP_SESSION#::::P2_SCHEMA:#SCHEMA#',
  p_column_linktext=>'#SCHEMA#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4095003141290236.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 31591625019740571.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4352,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 166211911060758908 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_required_patch=> '-274880608012467905.4352' + wwv_flow_api.g_id_offset,
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>58176271417373337.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4352,
  p_branch_action=> '1',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 1,
  p_branch_condition_type=> 'REQUEST_IN_CONDITION',
  p_branch_condition=> 'REINSTALL_DEMO_TABLES:REINSTALL_DEMO_FLOW',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 16-APR-2001 17:44 by MIKE');
 
wwv_flow_api.create_page_branch(
  p_id=>54874097760901772.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4352,
  p_branch_action=> '3',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 30-MAR-2001 16:50 by SEAN');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_4.435
prompt  ...PAGE 4.4352: Tentatives de connexion par résultat d'authentification
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 4.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Tentatives de connexion par résultat d''authentification',
  p_step_title=> 'Tentatives de connexion par résultat d''authentification',
  p_step_sub_title => 'Login Attempts By Login Result',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161843',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>4.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'count(*) attempts,'||chr(10)||
'count(distinct upper(login_name)) login_name,'||chr(10)||
'count(distinct application) application,'||chr(10)||
'count(distinct owner) owner,'||chr(10)||
'count (distinct authentication_method) authentication_method,'||chr(10)||
' count( distinct to_char(access_date,''YYYY.MM.DD'')) access_date,'||chr(10)||
' count( distinct ip_address) ip_address,'||chr(10)||
'nvl(authentication_result,0) authentication_result ,'||chr(10)||
'nvl(authentication_result,0) authent';

s:=s||'ication_result_code'||chr(10)||
'from   wwv_flow_user_access_log_v l'||chr(10)||
'where  security_group_id = :flow_security_group_id'||chr(10)||
'and access_date >= sysdate - nvl(:p4_time,1)'||chr(10)||
' and ( :P4_APPLICATION is null or application like ''%''||:P4_APPLICATION||''%'')'||chr(10)||
'and (:P4_USER is null or lower(login_name) like ''%''||lower(:P4_USER)||''%'')'||chr(10)||
'group by nvl(authentication_result,0)';

wwv_flow_api.create_report_region (
  p_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4352,
  p_name=> 'Login Attempts',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to render report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P4_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_report_total_text_format=> ' ',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 19-APR-2001 17:42:20');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42730221343843573.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ATTEMPTS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Tentatives',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_link=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.:RP,70:P70_RESULT,P70_TIME:#AUTHENTICATION_RESULT_CODE#,&P4_TIME.',
  p_column_linktext=>'#ATTEMPTS#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42713025155726001.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LOGIN_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Noms de connexion',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42713114820726001.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Applications',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42713205312726001.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Propriétaires d''application',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '13',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42713302795726001.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'AUTHENTICATION_METHOD',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Méthodes d''authentification',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '13',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42713418971726001.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ACCESS_DATE',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Jours de connexion',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42713509957726001.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'IP_ADDRESS',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Adresses IP',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42713710172726001.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'AUTHENTICATION_RESULT',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Résultat de l''authentification',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>42705425134693211 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '18',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42731413509850686.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42712731084725998.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'AUTHENTICATION_RESULT_CODE',
  p_column_display_sequence=> 9,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 42713916288726001.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 42714507572726002.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4352,
  p_plug_name=> 'Login Attempts by Login Result',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>42717220135726012.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4352,
  p_branch_action=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:RP::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>42715026364726009.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 28-NOV-2006 01:38 by SSPADAFO');
 
wwv_flow_api.create_page_branch(
  p_id=>42717409726726015.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4352,
  p_branch_action=> '70',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>42715026364726009.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4352,
  p_name=>'P4_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 42713916288726001.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre maximum de lignes à afficher par page.';

wwv_flow_api.create_page_item(
  p_id=>42715222592726010.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4352,
  p_name=>'P4_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 42713916288726001.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87968118050951423 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par application, saisissez un ID d''application et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>42715711720726010.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4352,
  p_name=>'P4_APPLICATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 42713916288726001.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Application',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par nom de connexion, saisissez un nom de connexion et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>42716223347726010.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4352,
  p_name=>'P4_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 13,
  p_item_plug_id => 42713916288726001.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de connexion',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>42736507800886950.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4352,
  p_name=>'P4_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 42713916288726001.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 42716911276726011.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>42715026364726009.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_5.435
prompt  ...PAGE 5.4352: Purger le statut de session
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_purge_session.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 5.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Purger le statut de session',
  p_step_title=> 'Purger le statut de session',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161843',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>5.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Menu:  administration';

wwv_flow_api.create_page_plug (
  p_id=> 4188003608574204.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 80,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Le statut de session assure la persistance des éléments. &PRODUCT_NAME. utilise une architecture sans état pour stocker le statut de session dans la base de données.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 41820802378409076.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4352,
  p_plug_name=> 'Statut de session',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 90,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'for c1 in (select count(*) c from wwv_flow_data where flow_instance = :flow_session) loop'||chr(10)||
'htp.p(''<span class="instructiontext">''||wwv_flow_lang.system_message(''F4350_SESSION_STATE'',:flow_session,c1.c) );'||chr(10)||
'end loop;'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4350_RESET_SESSION'') || ''</span>'');';

wwv_flow_api.create_page_plug (
  p_id=> 48658815589767957.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4352,
  p_plug_name=> 'Statut de session',
  p_region_name=>'',
  p_plug_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 48661616984968577.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4352,
  p_plug_name=> 'button box',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 48658988453771579.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5.4352,
  p_button_sequence=> 1,
  p_button_plug_id => 48658815589767957+wwv_flow_api.g_id_offset,
  p_button_name    => 'ResetCache',
  p_button_image_alt=> 'Purger le statut de session',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 174256217975087222.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 48658815589767957+wwv_flow_api.g_id_offset,
  p_button_name    => 'SessionDetails',
  p_button_image_alt=> 'Voir le statut de session',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4350:16:&SESSION.',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>48659251907771584.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4352,
  p_branch_action=> '5',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>48658988453771579.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>64907415893176849.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4352,
  p_branch_action=> '5',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>64907018269176844.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>174133405752808897.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4352,
  p_branch_action=> '5',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>174133004479808891.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_session_state';

wwv_flow_api.create_page_process(
  p_id     => 48659428631783734.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5.4352,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_SESSION_STATE',
  p_process_name=> 'reset-sessionstate',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible de purger le statut de session.',
  p_process_when_button_id=>48658988453771579.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Statut de session purgé.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 5.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_6.435
prompt  ...PAGE 6.4352: Modifications d'application par application
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 6.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par application',
  p_step_title=> 'Modifications d''application par application',
  p_step_sub_title => 'Developer by flow',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161843',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>6.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'||chr(10)||
'	codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"'||chr(10)||
'	width="#WIDTH#"'||chr(10)||
'	height="#HEIGHT#"'||chr(10)||
'	id="#CHART_NAME#">'||chr(10)||
'<param name="movie" value="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:6:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION_ID#">'||chr(10)||
'<param name="quality" value="';

s:=s||'high">'||chr(10)||
'<param name="allowScriptAccess" value="sameDomain">'||chr(10)||
'<param name="allowNetworking" value="all">'||chr(10)||
'<param name="scale" value="noscale">'||chr(10)||
'<param name="wmode" value="transparent">'||chr(10)||
'<param name="FlashVars" value="waiting=#FLASH_WAITING#&loading=#FLASH_LOADING#">'||chr(10)||
''||chr(10)||
'<embed src="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:6:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION_I';

s:=s||'D#"'||chr(10)||
'       quality="high"'||chr(10)||
'       width="#WIDTH#"'||chr(10)||
'       height="#HEIGHT#"'||chr(10)||
'       name="#CHART_NAME#"'||chr(10)||
'       scale="noscale"'||chr(10)||
'       allowScriptAccess="sameDomain" '||chr(10)||
'       allowNetworking="all"'||chr(10)||
'       type="application/x-shockwave-flash"'||chr(10)||
'       pluginspage="http://www.macromedia.com/go/getflashplayer"'||chr(10)||
'       wmode="transparent"'||chr(10)||
'       FlashVars="waiting=#FLASH_WAITING#&loading=#FLASH_LOADING#">'||chr(10)||
'</em';

s:=s||'bed>'||chr(10)||
'</object>'||chr(10)||
'#CHART_REFRESH#';

wwv_flow_api.create_page_plug (
  p_id=> 20151410294403696.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4352,
  p_plug_name=> 'Changes by Application',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'FLASH_CHART',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1 := null;
wwv_flow_api.create_flash_chart(
  p_id => 88500604994012457.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id => 6.4352,
  p_region_id => 20151410294403696.4352+wwv_flow_api.g_id_offset,
  p_default_chart_type  =>'2DPie',
  p_chart_title         =>'',
  p_chart_width         =>600,
  p_chart_height        =>400,
  p_chart_animation     =>'N',
  p_display_attr        =>'H:::RIGHT:N:',
  p_dial_tick_attr      =>'::',
  p_margins             =>':::',
  p_omit_label_interval =>null,
  p_bgtype              =>'SOLID',
  p_bgcolor1            =>'#FFFFFF',
  p_bgcolor2            =>'',
  p_gradient_rotation   =>null,
  p_color_scheme        =>'1',
  p_custom_colors       =>'',
  p_x_axis_title        =>'',
  p_x_axis_min          =>null,
  p_x_axis_max          =>null,
  p_x_axis_grid_spacing =>null,
  p_x_axis_prefix       =>'',
  p_x_axis_postfix      =>'',
  p_x_axis_group_sep    =>'N',
  p_x_axis_decimal_place=>null,
  p_y_axis_title        =>'',
  p_y_axis_min          =>null,
  p_y_axis_max          =>null,
  p_y_axis_grid_spacing =>null,
  p_y_axis_prefix       =>'',
  p_y_axis_postfix      =>'',
  p_y_axis_group_sep    =>'N',
  p_y_axis_decimal_place=>null,
  p_async_update        =>'N',
  p_async_time          =>null,
  p_names_font          =>'Arial:10:#000000',
  p_names_rotation      =>null,
  p_values_font         =>'Arial:10:#000000',
  p_values_rotation     =>null,
  p_hints_font          =>'Arial:10:#000000',
  p_legend_font         =>'Arial:10:#000000',
  p_grid_labels_font    =>'::',
  p_chart_title_font    =>'Arial:10:#000000',
  p_x_axis_title_font   =>'::',
  p_y_axis_title_font   =>'::',
  p_use_chart_xml       =>'N',
  p_chart_xml           => a1,
  p_attribute_01        =>'',
  p_attribute_02        =>'',
  p_attribute_03        =>'',
  p_attribute_04        =>'',
  p_attribute_05        =>'');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'select null l,'||chr(10)||
'       flow_id, '||chr(10)||
'       count(*) c'||chr(10)||
'from wwv_flow_builder_audit_trail'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'and audit_date >= sysdate - nvl(:P6_TIME,1)'||chr(10)||
'and flow_id is not null'||chr(10)||
'group by  ''f?p=4350:28:''||:flow_session||''::NO::P28_FLOW,P28_TIME:''||'||chr(10)||
'       flow_id||'',''||nvl(:p6_time,''1''), flow_id'||chr(10)||
'order by 3 desc';

wwv_flow_api.create_flash_chart_series(
  p_id => 88500708813012457.4352+wwv_flow_api.g_id_offset,
  p_chart_id => 88500604994012457.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_series_seq                =>10,
  p_series_name               =>'Série 1',
  p_series_query              => a1,
  p_series_query_type         =>'SQL_QUERY',
  p_series_query_parse_opt    =>'',
  p_series_query_no_data_found=>'Aucune donnée n''a été trouvée.',
  p_series_query_row_count_max=>25);
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20173213073480156.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'20157602591420307';

wwv_flow_api.create_page_plug (
  p_id=> 20173918961481824.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 20157602591420307 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20178227749493840.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>20147901426394233.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4352,
  p_branch_action=> '6',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 29-NOV-2002 17:44:45');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>20146300347394213.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4352,
  p_name=>'P6_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 20173213073480156.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>20147007203394223.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4352,
  p_name=>'P6_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 20173213073480156.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 20147514759394229.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 6.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_7.435
prompt  ...PAGE 7.4352: Sessions actives
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_active_sessions.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 7.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Sessions actives',
  p_step_title=> 'Sessions actives',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161843',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>7.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select	 "WWV_FLOW_SESSIONS$".ID as "ID", cookie session_owner, created_on,'||chr(10)||
'         count(*) item_cache_count, "WWV_FLOW_SESSIONS$".remote_addr ip_address'||chr(10)||
' from	 "WWV_FLOW_DATA" "WWV_FLOW_DATA",'||chr(10)||
'	 "WWV_FLOW_SESSIONS$" "WWV_FLOW_SESSIONS$" '||chr(10)||
' where   WWV_FLOW_DATA.FLOW_INSTANCE=WWV_FLOW_SESSIONS$.ID and'||chr(10)||
'(:P7_OWNER is null or instr(upper(cookie),upper(:P7_OWNER))>0) and'||chr(10)||
'security_group_id = :flow_secu';

s:=s||'rity_group_id'||chr(10)||
'group by "WWV_FLOW_SESSIONS$".ID, cookie, created_on, remote_addr';

wwv_flow_api.create_report_region (
  p_id=> 167550730293064019.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4352,
  p_name=> 'Active Sessions',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P7_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167550932755064021.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167550730293064019.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Session active',
  p_column_link=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:RP,:P19_ID:#ID#',
  p_column_linktext=>'#ID#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167558520774099184.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167550730293064019.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_OWNER',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Propriétaire',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167558622594099184.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167550730293064019.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED_ON',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Créé',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167551015320064022.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167550730293064019.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ITEM_CACHE_COUNT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Eléments de session',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 39597925108488657.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167550730293064019.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'IP_ADDRESS',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Adresse IP',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 167555229170082683.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4352,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 167561810432124579.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'167595421017316802';

wwv_flow_api.create_page_plug (
  p_id=> 167597603271330646.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4352,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 167595421017316802 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 167602811283361389.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4352,
  p_plug_name=> 'Active Session Count',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>167564317393131991.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:7:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez une interrogation pour le propriétaire et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>167562922206127957.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4352,
  p_name=>'P7_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 167561810432124579.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Propriétaire',
  p_post_element_text=>'&nbsp;&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 20,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>167564103290131990.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4352,
  p_name=>'P7_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 167561810432124579.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre d''utilisateurs à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>167572431041168317.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4352,
  p_name=>'P7_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 167561810432124579.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_C',
  p_lov => '.'||to_char(87964809046948816 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indique le nombre de sessions pouvant être actives dans cet espace de travail.';

wwv_flow_api.create_page_item(
  p_id=>167604213838371513.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4352,
  p_name=>'P7_ACTIVE_SESSIONS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 13,
  p_item_plug_id => 167561810432124579.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Sessions actives :',
  p_post_element_text=>'&nbsp;&nbsp;',
  p_source=>'select	 to_char(count(*),''999G999G999G990'') '||chr(10)||
' item_cache_count'||chr(10)||
' from	 WWV_FLOW_SESSIONS$'||chr(10)||
' where   '||chr(10)||
'(:P7_OWNER is null or instr(upper(cookie),upper(:P7_OWNER))>0) and'||chr(10)||
'security_group_id = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 167564806753132961.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>167564103290131990.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 7.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_8.435
prompt  ...PAGE 8.4352: Modifications d'application par développeur
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 8.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par développeur',
  p_step_title=> 'Modifications d''application par développeur',
  p_step_sub_title => 'Activity by Developer',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> -274880608012467905.4352 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161843',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>8.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_page_views as'||chr(10)||
'('||chr(10)||
'select count(*) tpv'||chr(10)||
'from   '||chr(10)||
'  wwv_flow_builder_audit_trail'||chr(10)||
'where  '||chr(10)||
'  audit_date > sysdate - nvl(:p8_time,1) and '||chr(10)||
'  security_group_id = :flow_security_group_id'||chr(10)||
')'||chr(10)||
'select the_link, developer, page_views, 100*page_views/tpv pct, round(300*page_views/tpv) graph,'||chr(10)||
'pages_visited'||chr(10)||
'from'||chr(10)||
'('||chr(10)||
'select '||chr(10)||
'''f?p=4350:42:''||:flow_session||'':::RP:P42_USER,P42_TIME:''||flow_user||'',''||:p8_time th';

s:=s||'e_link,'||chr(10)||
'  flow_user developer,'||chr(10)||
'  count(*) page_views,'||chr(10)||
'  count(distinct(page_id)) pages_visited'||chr(10)||
'from   '||chr(10)||
'  wwv_flow_builder_audit_trail'||chr(10)||
'where  '||chr(10)||
'  audit_date > sysdate - nvl(:p8_time,1) and '||chr(10)||
'  security_group_id = :flow_security_group_id'||chr(10)||
'group by '||chr(10)||
'  flow_user) d, total_page_views';

wwv_flow_api.create_report_region (
  p_id=> 6112020169674863.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4352,
  p_name=> 'Application Changes by Developer',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6112318235674872.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6112020169674863.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'THE_LINK',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6112419725674874.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6112020169674863.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DEVELOPER',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Développeur',
  p_column_html_expression=>'<a href="#THE_LINK#">#DEVELOPER#</a>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '32',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6112515986674874.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6112020169674863.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Vues de<br />page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '32',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6112607005674875.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6112020169674863.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Pourcentage',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6112710075674875.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6112020169674863.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 5,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7694513687537235.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6112020169674863.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'PAGES_VISITED',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Pages<br />distinctes',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6115202769688783.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20246225783701428.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'20255531240721952';

wwv_flow_api.create_page_plug (
  p_id=> 20258303798732957.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4352,
  p_plug_name=> 'Navigation Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 20255531240721952 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>20242415263688933.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:8:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 03-MAY-2004 15:55 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à '||chr(10)||
''||chr(10)||
'inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>20239730370683894.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4352,
  p_name=>'P8_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 6115202769688783.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'to_number(.25)',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'Depuis',
  p_source=>'to_number(.25)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>20241409376687199.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4352,
  p_name=>'P8_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 6115202769688783.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 20248609638706251.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 8.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_9.435
prompt  ...PAGE 9.4352: A propos de &PRODUCT_NAME.
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_htmldb.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 9.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'A propos de &PRODUCT_NAME.',
  p_step_title=> 'A propos de &PRODUCT_NAME.',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215451130329541858+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_patch=> -274880608012467905.4352 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>9.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'M4090422833267509';

wwv_flow_api.create_page_plug (
  p_id=> 9018510187867803.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select banner from v$version';

wwv_flow_api.create_report_region (
  p_id=> 20123129051163000.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4352,
  p_name=> 'Database version',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 2,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<p />',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune information de version de base de données n''a été trouvée',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20123710246163013.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 20123129051163000.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'BANNER',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Informations sur la version de base de données',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<table class="instructiontext">'');'||chr(10)||
''||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.PRODUCT_BUILD''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||htf.escape_sc(wwv_flows_release)||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.SCHEMA_COMPATIBILITY''));'||chr(10)||
'--wwv_htp.tableData(htf.bold(#FLOW_OWNER#.wwv_flows_version));'||chr(10)||
'htp.prn(''<td c';

s:=s||'lass="fielddatabold">''||htf.escape_sc(wwv_flows_version)||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'for c1 in (select to_char(last_ddl_time,''&DATE_TIME_FORMAT.'') lddt from all_objects where object_name = ''WWV_FLOW'' and object_type = ''PACKAGE BODY'') loop'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.LAST_DDL_TIME''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||htf.escape_sc(c1.lddt)||''</td>'');'||chr(10)||
'ht';

s:=s||'p.p(''</tr>'');'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'for c1 in (select user u from dual) loop'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.HOST_SCHEMA''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||htf.escape_sc(c1.u)||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'htp.tableRowOpen;'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.APPLICATION_OWNER''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||htf.escape_sc(''#FLOW_';

s:=s||'OWNER#'')||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.WORKSPACE_ID''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||wwv_flow_security.g_security_group_id||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.WORKSPACE_NAME''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||htf.escape_sc(wwv_flow.get_company_name)||''</td';

s:=s||'>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.CURRENT_USER''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||htf.escape_sc(v(''USER''))||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.LANGUAGE_PREFERENCE''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||htf.escape_sc(wwv_flow.g_browser_language)||''</td>'');'||chr(10)||
'wwv_htp.tableRow';

s:=s||'Close;'||chr(10)||
''||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(wwv_flow_lang.system_message(''F4350.CURRENT_TIME_ON_SERVER''));'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||to_char(sysdate,''&DATE_TIME_FORMAT.'')||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'wwv_htp.tableClose;'||chr(10)||
'htp.p(''<p />'');';

wwv_flow_api.create_page_plug (
  p_id=> 77811317279722052.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4352,
  p_plug_name=> '&PRODUCT_NAME.',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<table summary="" class="fielddata">'');'||chr(10)||
'for c1 in ('||chr(10)||
'select ''NLS_CHARACTERSET:'' n, value v '||chr(10)||
'from nls_database_parameters '||chr(10)||
'where upper(parameter)= ''NLS_CHARACTERSET'') loop'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(c1.n);'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||htf.escape_sc(c1.v)||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(''DAD CHARACTERSET:'');'||chr(10)||
'htp.prn(''<td class="fielddatabo';

s:=s||'ld">''||'||chr(10)||
'   htf.escape_sc(owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
''||chr(10)||
'for c1 in ('||chr(10)||
'select ''JOB_QUEUE_PROCESSES:''n, value v'||chr(10)||
'from v$parameter where lower(name) = ''job_queue_processes'') loop'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'wwv_htp.tableData(c1.n);'||chr(10)||
'htp.prn(''<td class="fielddatabold">''||'||chr(10)||
'   htf.escape_sc(c1.v)||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
'htp.p(''</table>'');';

wwv_flow_api.create_page_plug (
  p_id=> 198701826510091307.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4352,
  p_plug_name=> 'Character Set',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1951716890925319.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4352,
  p_branch_action=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 11-JAN-2005 10:31 by MIKE');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 9.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_10.43
prompt  ...PAGE 10.4352: Modifications d'application par développeur
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 10.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par développeur',
  p_step_title=> 'Modifications d''application par développeur',
  p_step_sub_title => 'Development activity by developer',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>10.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'||chr(10)||
'	codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"'||chr(10)||
'	width="#WIDTH#"'||chr(10)||
'	height="#HEIGHT#"'||chr(10)||
'	id="#CHART_NAME#">'||chr(10)||
'<param name="movie" value="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:10:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION_ID#">'||chr(10)||
'<param name="quality" value=';

s:=s||'"high">'||chr(10)||
'<param name="allowScriptAccess" value="sameDomain">'||chr(10)||
'<param name="allowNetworking" value="all">'||chr(10)||
'<param name="scale" value="noscale">'||chr(10)||
'<param name="wmode" value="transparent">'||chr(10)||
'<param name="FlashVars" value="waiting=#FLASH_WAITING#&loading=#FLASH_LOADING#">'||chr(10)||
''||chr(10)||
'<embed src="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:10:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION';

s:=s||'_ID#"'||chr(10)||
'       quality="high"'||chr(10)||
'       width="#WIDTH#"'||chr(10)||
'       height="#HEIGHT#"'||chr(10)||
'       name="#CHART_NAME#"'||chr(10)||
'       scale="noscale"'||chr(10)||
'       allowScriptAccess="sameDomain" '||chr(10)||
'       allowNetworking="all"'||chr(10)||
'       type="application/x-shockwave-flash"'||chr(10)||
'       pluginspage="http://www.macromedia.com/go/getflashplayer"'||chr(10)||
'       wmode="transparent"'||chr(10)||
'       FlashVars="waiting=#FLASH_WAITING#&loading=#FLASH_LOADING#">'||chr(10)||
'</';

s:=s||'embed>'||chr(10)||
'</object>'||chr(10)||
'#CHART_REFRESH#';

wwv_flow_api.create_page_plug (
  p_id=> 20251609496716290.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4352,
  p_plug_name=> 'Development activity by developer',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'FLASH_CHART',
  p_plug_display_error_message=> 'Unable to render chart. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 03-MAY-2004 15:59:49');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1 := null;
wwv_flow_api.create_flash_chart(
  p_id => 85976206711061176.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id => 10.4352,
  p_region_id => 20251609496716290.4352+wwv_flow_api.g_id_offset,
  p_default_chart_type  =>'2DPie',
  p_chart_title         =>'',
  p_chart_width         =>600,
  p_chart_height        =>500,
  p_chart_animation     =>'N',
  p_display_attr        =>'H:::RIGHT:N',
  p_dial_tick_attr      =>'',
  p_margins             =>'',
  p_omit_label_interval =>null,
  p_bgtype              =>'SOLID',
  p_bgcolor1            =>'#FFFFFF',
  p_bgcolor2            =>'',
  p_gradient_rotation   =>null,
  p_color_scheme        =>'1',
  p_custom_colors       =>'',
  p_x_axis_title        =>'',
  p_x_axis_min          =>null,
  p_x_axis_max          =>null,
  p_x_axis_grid_spacing =>null,
  p_x_axis_prefix       =>'',
  p_x_axis_postfix      =>'',
  p_x_axis_group_sep    =>'N',
  p_x_axis_decimal_place=>null,
  p_y_axis_title        =>'',
  p_y_axis_min          =>null,
  p_y_axis_max          =>null,
  p_y_axis_grid_spacing =>null,
  p_y_axis_prefix       =>'',
  p_y_axis_postfix      =>'',
  p_y_axis_group_sep    =>'N',
  p_y_axis_decimal_place=>null,
  p_async_update        =>'N',
  p_async_time          =>null,
  p_names_font          =>'Arial:10:#000000',
  p_names_rotation      =>null,
  p_values_font         =>'Arial:10:#000000',
  p_values_rotation     =>null,
  p_hints_font          =>'Arial:10:#000000',
  p_legend_font         =>'Arial:10:#000000',
  p_grid_labels_font    =>'',
  p_chart_title_font    =>'',
  p_x_axis_title_font   =>'::',
  p_y_axis_title_font   =>'::',
  p_use_chart_xml       =>'N',
  p_chart_xml           => a1,
  p_attribute_01        =>'',
  p_attribute_02        =>'',
  p_attribute_03        =>'',
  p_attribute_04        =>'',
  p_attribute_05        =>'');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'select '||chr(10)||
'''f?p=4350:42:''||:flow_session||'':::RP:P42_USER,P42_TIME:''||flow_user||'',''||:p10_time l,'||chr(10)||
'  flow_user,'||chr(10)||
'  count(*) c'||chr(10)||
'from   '||chr(10)||
'  wwv_flow_builder_audit_trail'||chr(10)||
'where  '||chr(10)||
'  audit_date > sysdate - nvl(:p10_time,1) and '||chr(10)||
'  security_group_id = :flow_security_group_id'||chr(10)||
'group by '||chr(10)||
'  flow_user'||chr(10)||
'order by c desc';

wwv_flow_api.create_flash_chart_series(
  p_id => 85976317465061178.4352+wwv_flow_api.g_id_offset,
  p_chart_id => 85976206711061176.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_series_seq                =>10,
  p_series_name               =>'Série 1',
  p_series_query              => a1,
  p_series_query_type         =>'SQL_QUERY',
  p_series_query_parse_opt    =>'',
  p_series_query_no_data_found=>'aucune donnée n''a été trouvée',
  p_series_query_row_count_max=>15);
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20253520505718816.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'20255531240721952';

wwv_flow_api.create_page_plug (
  p_id=> 20257128254730499.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4352,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 20255531240721952 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 131241908734176090.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>20263732195741193.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:10:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 03-MAY-2004 16:03 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à '||chr(10)||
'inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>20260920074737670.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4352,
  p_name=>'P10_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 131241908734176090.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '.25',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'.25',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>20261924922739085.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4352,
  p_name=>'P10_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 131241908734176090.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 10.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_11.43
prompt  ...PAGE 11.4352: Préférences utilisateur en cours
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_user_pref.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 11.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Préférences utilisateur en cours',
  p_step_title=> 'Préférences utilisateur en cours',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450104703534414+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>11.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 7259721998863622.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 9039514483954233.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'    user_id,'||chr(10)||
'    preference_name,'||chr(10)||
'    attribute_value'||chr(10)||
'from WWV_FLOW_PREFERENCES$'||chr(10)||
'where user_id = :flow_user'||chr(10)||
'and security_group_id = :flow_security_group_id'||chr(10)||
'order by 1,2';

wwv_flow_api.create_report_region (
  p_id=> 174204425706947482.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4352,
  p_name=> 'Preferences',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '10',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '1',
  p_query_num_rows_item=> 'P11_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 13-FEB-2002 11:49:27');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48842202432772499.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174204425706947482.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48842314925772499.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174204425706947482.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PREFERENCE_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Préférence',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48842420528772499.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174204425706947482.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ATTRIBUTE_VALUE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Valeur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Cet état affiche les préférences définies pour l''utilisateur en cours. Les valeurs du statut de session sont conservées entre les connexions.';

wwv_flow_api.create_page_plug (
  p_id=> 174210501299954701.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4352,
  p_plug_name=> 'Préférences utilisateur',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 174204802662947485.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 11.4352,
  p_button_sequence=> 20,
  p_button_plug_id => 174204425706947482+wwv_flow_api.g_id_offset,
  p_button_name    => 'FLOW_NEXT_PAGE',
  p_button_image   => 'smv.gif',
  p_button_image_alt=> 'Suivant',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 174205119053947487.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 11.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 174204425706947482+wwv_flow_api.g_id_offset,
  p_button_name    => 'FLOW_PREVIOUS_PAGE',
  p_button_image   => 'srmv.gif',
  p_button_image_alt=> 'Précédent',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>122221606249170943.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4352,
  p_branch_action=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 11-APR-2006 16:43 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de préférences à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>9038807211952154.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4352,
  p_name=>'P11_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 9039514483954233.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(87960028308944903 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>9040626257957650.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4352,
  p_name=>'P11_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 9039514483954233.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 9042406649961416.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>9040626257957650.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 11.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_12.43
prompt  ...PAGE 12.4352: Vues de page par jour
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 12.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par jour',
  p_step_title=> 'Vues de page par jour',
  p_step_sub_title => 'Activity by day',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>12.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'||chr(10)||
'	codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"'||chr(10)||
'	width="#WIDTH#"'||chr(10)||
'	height="#HEIGHT#"'||chr(10)||
'	id="#CHART_NAME#">'||chr(10)||
'<param name="movie" value="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:12:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION_ID#">'||chr(10)||
'<param name="quality" value=';

s:=s||'"high">'||chr(10)||
'<param name="allowScriptAccess" value="sameDomain">'||chr(10)||
'<param name="allowNetworking" value="all">'||chr(10)||
'<param name="scale" value="noscale">'||chr(10)||
'<param name="wmode" value="transparent">'||chr(10)||
'<param name="FlashVars" value="waiting=#FLASH_WAITING#&loading=#FLASH_LOADING#">'||chr(10)||
''||chr(10)||
'<embed src="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:12:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION';

s:=s||'_ID#"'||chr(10)||
'       quality="high"'||chr(10)||
'       width="#WIDTH#"'||chr(10)||
'       height="#HEIGHT#"'||chr(10)||
'       name="#CHART_NAME#"'||chr(10)||
'       scale="noscale"'||chr(10)||
'       align=""'||chr(10)||
'       allowScriptAccess="sameDomain" '||chr(10)||
'       allowNetworking="all"'||chr(10)||
'       type="application/x-shockwave-flash"'||chr(10)||
'       pluginspage="http://www.macromedia.com/go/getflashplayer"'||chr(10)||
'       wmode="transparent"'||chr(10)||
'       FlashVars="waiting=#FLASH_WAITING#&loading=#FLA';

s:=s||'SH_LOADING#">'||chr(10)||
'</embed>'||chr(10)||
'</object>'||chr(10)||
'#CHART_REFRESH#';

wwv_flow_api.create_page_plug (
  p_id=> 20541209756592026.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4352,
  p_plug_name=> 'Workspace page views by day',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'FLASH_CHART',
  p_plug_display_error_message=> 'Unable to render chart. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 04-MAY-2004 08:19:07');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1 := null;
wwv_flow_api.create_flash_chart(
  p_id => 88206325193826232.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id => 12.4352,
  p_region_id => 20541209756592026.4352+wwv_flow_api.g_id_offset,
  p_default_chart_type  =>'2DLine',
  p_chart_title         =>'',
  p_chart_width         =>800,
  p_chart_height        =>500,
  p_chart_animation     =>'alpha',
  p_display_attr        =>'H:N::N:BACK:',
  p_dial_tick_attr      =>'::',
  p_margins             =>':::',
  p_omit_label_interval =>0,
  p_bgtype              =>'SOLID',
  p_bgcolor1            =>'#FFFFFF',
  p_bgcolor2            =>'',
  p_gradient_rotation   =>null,
  p_color_scheme        =>'1',
  p_custom_colors       =>'',
  p_x_axis_title        =>'',
  p_x_axis_min          =>null,
  p_x_axis_max          =>null,
  p_x_axis_grid_spacing =>null,
  p_x_axis_prefix       =>'',
  p_x_axis_postfix      =>'',
  p_x_axis_group_sep    =>'N',
  p_x_axis_decimal_place=>null,
  p_y_axis_title        =>'',
  p_y_axis_min          =>null,
  p_y_axis_max          =>null,
  p_y_axis_grid_spacing =>null,
  p_y_axis_prefix       =>'',
  p_y_axis_postfix      =>'',
  p_y_axis_group_sep    =>'Y',
  p_y_axis_decimal_place=>null,
  p_async_update        =>'N',
  p_async_time          =>null,
  p_names_font          =>'Arial:10:#000000',
  p_names_rotation      =>45,
  p_values_font         =>'Arial:10:#000000',
  p_values_rotation     =>null,
  p_hints_font          =>'Arial:10:#000000',
  p_legend_font         =>'Arial:10:#000000',
  p_grid_labels_font    =>'Arial:10:#000000',
  p_chart_title_font    =>'Arial:10:#000000',
  p_x_axis_title_font   =>'Arial:14:#000000',
  p_y_axis_title_font   =>'Arial:14:#000000',
  p_use_chart_xml       =>'N',
  p_chart_xml           => a1,
  p_attribute_01        =>'',
  p_attribute_02        =>'',
  p_attribute_03        =>'',
  p_attribute_04        =>'',
  p_attribute_05        =>'');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'select null link,'||chr(10)||
'       trunc(TIME_STAMP) day,'||chr(10)||
'       count(*) views'||chr(10)||
'from   WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'where  security_group_id = :flow_security_group_id and page_mode != ''A'''||chr(10)||
'group by trunc(time_stamp)'||chr(10)||
'order by trunc(time_stamp)';

wwv_flow_api.create_flash_chart_series(
  p_id => 88206411502826232.4352+wwv_flow_api.g_id_offset,
  p_chart_id => 88206325193826232.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_series_seq                =>10,
  p_series_name               =>'Activité par jour',
  p_series_query              => a1,
  p_series_query_type         =>'SQL_QUERY',
  p_series_query_parse_opt    =>'PARSE_CHART_QUERY',
  p_series_query_no_data_found=>'aucune donnée n''a été trouvée',
  p_series_query_row_count_max=>200);
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20590023340617175.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'20786728673431316';

wwv_flow_api.create_page_plug (
  p_id=> 22769716309423343.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 20786728673431316 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_footer=> '<p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 12.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_13.43
prompt  ...PAGE 13.4352: Modifications d'application par jour
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 13.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par jour',
  p_step_title=> 'Modifications d''application par jour',
  p_step_sub_title => 'Developer activity by day',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>13.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'||chr(10)||
'	codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"'||chr(10)||
'	width="#WIDTH#"'||chr(10)||
'	height="#HEIGHT#"'||chr(10)||
'	id="#CHART_NAME#">'||chr(10)||
'<param name="movie" value="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:13:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION_ID#">'||chr(10)||
'<param name="quality" value=';

s:=s||'"high">'||chr(10)||
'<param name="allowScriptAccess" value="sameDomain">'||chr(10)||
'<param name="allowNetworking" value="all">'||chr(10)||
'<param name="scale" value="noscale">'||chr(10)||
'<param name="wmode" value="transparent">'||chr(10)||
'<param name="FlashVars" value="waiting=#FLASH_WAITING#&loading=#FLASH_LOADING#">'||chr(10)||
''||chr(10)||
'<embed src="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:13:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION';

s:=s||'_ID#"'||chr(10)||
'       quality="high"'||chr(10)||
'       width="#WIDTH#"'||chr(10)||
'       height="#HEIGHT#"'||chr(10)||
'       name="#CHART_NAME#"'||chr(10)||
'       scale="noscale"'||chr(10)||
'       align=""'||chr(10)||
'       allowScriptAccess="sameDomain" '||chr(10)||
'       allowNetworking="all"'||chr(10)||
'       type="application/x-shockwave-flash"'||chr(10)||
'       pluginspage="http://www.macromedia.com/go/getflashplayer"'||chr(10)||
'       wmode="transparent"'||chr(10)||
'       FlashVars="waiting=#FLASH_WAITING#&loading=#FLA';

s:=s||'SH_LOADING#">'||chr(10)||
'</embed>'||chr(10)||
'</object>'||chr(10)||
'#CHART_REFRESH#';

wwv_flow_api.create_page_plug (
  p_id=> 20640307118688390.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4352,
  p_plug_name=> 'Workspace developer activity by day',
  p_region_name=>'',
  p_plug_template=> 102452107583905002.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'FLASH_CHART',
  p_plug_display_error_message=> 'Unable to render chart. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_footer=> '<p>Modifications de développeur par jour</p>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1 := null;
wwv_flow_api.create_flash_chart(
  p_id => 88395502196434529.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id => 13.4352,
  p_region_id => 20640307118688390.4352+wwv_flow_api.g_id_offset,
  p_default_chart_type  =>'2DLine',
  p_chart_title         =>'',
  p_chart_width         =>1000,
  p_chart_height        =>500,
  p_chart_animation     =>'alpha',
  p_display_attr        =>'H:N:::BACK:',
  p_dial_tick_attr      =>'::',
  p_margins             =>':::',
  p_omit_label_interval =>null,
  p_bgtype              =>'SOLID',
  p_bgcolor1            =>'#FFFFFF',
  p_bgcolor2            =>'',
  p_gradient_rotation   =>null,
  p_color_scheme        =>'1',
  p_custom_colors       =>'',
  p_x_axis_title        =>'',
  p_x_axis_min          =>null,
  p_x_axis_max          =>null,
  p_x_axis_grid_spacing =>null,
  p_x_axis_prefix       =>'',
  p_x_axis_postfix      =>'',
  p_x_axis_group_sep    =>'N',
  p_x_axis_decimal_place=>null,
  p_y_axis_title        =>'',
  p_y_axis_min          =>null,
  p_y_axis_max          =>null,
  p_y_axis_grid_spacing =>null,
  p_y_axis_prefix       =>'',
  p_y_axis_postfix      =>'',
  p_y_axis_group_sep    =>'N',
  p_y_axis_decimal_place=>null,
  p_async_update        =>'N',
  p_async_time          =>null,
  p_names_font          =>'Arial:8:#000000',
  p_names_rotation      =>45,
  p_values_font         =>'Arial:8:#000000',
  p_values_rotation     =>null,
  p_hints_font          =>'Arial:10:#000000',
  p_legend_font         =>'Arial:8:#000000',
  p_grid_labels_font    =>'Arial:10:#000000',
  p_chart_title_font    =>'Arial:10:#000000',
  p_x_axis_title_font   =>'Arial:14:#000000',
  p_y_axis_title_font   =>'Arial:14:#000000',
  p_use_chart_xml       =>'N',
  p_chart_xml           => a1,
  p_attribute_01        =>'',
  p_attribute_02        =>'',
  p_attribute_03        =>'',
  p_attribute_04        =>'',
  p_attribute_05        =>'');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'select null link,to_char(trunc(fake_date),:DATE_FORMAT) day,count(audit_date) application_changes'||chr(10)||
'  from (select trunc(audit_date) audit_date,flow_user'||chr(10)||
'          from wwv_flow_builder_audit_trail'||chr(10)||
'         where security_group_id = :flow_security_group_id '||chr(10)||
'           and (:P13_DEVELOPER is null or :P13_DEVELOPER = ''0'' or FLOW_USER = :P13_DEVELOPER)) t,'||chr(10)||
'  		 -- The folloing inline view (d) generates';

a1:=a1||' a row (fake_date) for every day from the min date until now.'||chr(10)||
'  		 (select (select trunc(min(audit_date))'||chr(10)||
'  		 						from wwv_flow_builder_audit_trail   		 				 '||chr(10)||
'  		 				      where security_group_id = :flow_security_group_id'||chr(10)||
'  		 				   ) + rownum-1 fake_date'||chr(10)||
'  		    from all_objects'||chr(10)||
'  		   where rownum -1 < '||chr(10)||
'  		 	(select sysdate - (select trunc(min(audit_date) )'||chr(10)||
'  		 											 from wwv_flow_';

a1:=a1||'builder_audit_trail '||chr(10)||
'  		 											  where security_group_id = :flow_security_group_id'||chr(10)||
'  		 											) from dual)) d'||chr(10)||
' where trunc(d.fake_date) = t.audit_date(+)'||chr(10)||
'group by trunc(fake_date)'||chr(10)||
'order by trunc(fake_date)';

wwv_flow_api.create_flash_chart_series(
  p_id => 88395610145434530.4352+wwv_flow_api.g_id_offset,
  p_chart_id => 88395502196434529.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_series_seq                =>10,
  p_series_name               =>'Activité de développeur par jour',
  p_series_query              => a1,
  p_series_query_type         =>'SQL_QUERY',
  p_series_query_parse_opt    =>'PARSE_CHART_QUERY',
  p_series_query_no_data_found=>'aucune donnée n''a été trouvée',
  p_series_query_row_count_max=>55);
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20652831923714241.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22525421206052811.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 22523422114043579 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 125776005815289163.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>21098800366484775.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:13:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par développeur, sélectionnez un développeur et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>21093807799469041.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4352,
  p_name=>'P13_DEVELOPER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 125776005815289163.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Développeur',
  p_source=>'0',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'FLOW_DEVELOPERS',
  p_lov => 'select htf.escape_sc(USERID) d, USERID r'||chr(10)||
'from  WWV_FLOW_developers'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tous les développeurs -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>21098529401484768.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4352,
  p_name=>'P13_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 125776005815289163.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 13.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_14.43
prompt  ...PAGE 14.4352: Vues de page par heure
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 14.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par heure',
  p_step_title=> 'Vues de page par heure',
  p_step_sub_title => 'Activity by day',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>14.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20669308460751177.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'||chr(10)||
'	codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"'||chr(10)||
'	width="#WIDTH#"'||chr(10)||
'	height="#HEIGHT#"'||chr(10)||
'	id="#CHART_NAME#">'||chr(10)||
'<param name="movie" value="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:14:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION_ID#">'||chr(10)||
'<param name="quality" value=';

s:=s||'"high">'||chr(10)||
'<param name="allowScriptAccess" value="sameDomain">'||chr(10)||
'<param name="allowNetworking" value="all">'||chr(10)||
'<param name="scale" value="noscale">'||chr(10)||
'<param name="wmode" value="transparent">'||chr(10)||
'<param name="FlashVars" value="waiting=#FLASH_WAITING#&loading=#FLASH_LOADING#">'||chr(10)||
''||chr(10)||
'<embed src="#IMAGE_PREFIX#flashchart/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:14:&APP_SESSION.:FLOW_FLASH_CHART_R#REGION';

s:=s||'_ID#"'||chr(10)||
'       quality="high"'||chr(10)||
'       width="#WIDTH#"'||chr(10)||
'       height="#HEIGHT#"'||chr(10)||
'       name="#CHART_NAME#"'||chr(10)||
'       scale="noscale"'||chr(10)||
'       allowScriptAccess="sameDomain" '||chr(10)||
'       allowNetworking="all"'||chr(10)||
'       type="application/x-shockwave-flash"'||chr(10)||
'       pluginspage="http://www.macromedia.com/go/getflashplayer"'||chr(10)||
'       wmode="transparent"'||chr(10)||
'       FlashVars="waiting=#FLASH_WAITING#&loading=#FLASH_LOADING#">'||chr(10)||
'</';

s:=s||'embed>'||chr(10)||
'</object>'||chr(10)||
'#CHART_REFRESH#';

wwv_flow_api.create_page_plug (
  p_id=> 20675705351763320.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4352,
  p_plug_name=> 'Page views by hour over the last 48 hours',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 11,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'FLASH_CHART',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_footer=> '<p>Vues de page par heure au cours des dernières 48 heures. Les heures indiquées sont basées sur l''heure du serveur.</p>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1 := null;
wwv_flow_api.create_flash_chart(
  p_id => 88207811126831616.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id => 14.4352,
  p_region_id => 20675705351763320.4352+wwv_flow_api.g_id_offset,
  p_default_chart_type  =>'2DLine',
  p_chart_title         =>'',
  p_chart_width         =>1000,
  p_chart_height        =>600,
  p_chart_animation     =>'alpha',
  p_display_attr        =>'H:N:::BACK:',
  p_dial_tick_attr      =>'::',
  p_margins             =>':::',
  p_omit_label_interval =>null,
  p_bgtype              =>'SOLID',
  p_bgcolor1            =>'#FFFFFF',
  p_bgcolor2            =>'',
  p_gradient_rotation   =>null,
  p_color_scheme        =>'1',
  p_custom_colors       =>'',
  p_x_axis_title        =>'',
  p_x_axis_min          =>null,
  p_x_axis_max          =>null,
  p_x_axis_grid_spacing =>null,
  p_x_axis_prefix       =>'',
  p_x_axis_postfix      =>'',
  p_x_axis_group_sep    =>'N',
  p_x_axis_decimal_place=>null,
  p_y_axis_title        =>'',
  p_y_axis_min          =>null,
  p_y_axis_max          =>null,
  p_y_axis_grid_spacing =>null,
  p_y_axis_prefix       =>'',
  p_y_axis_postfix      =>'',
  p_y_axis_group_sep    =>'Y',
  p_y_axis_decimal_place=>null,
  p_async_update        =>'N',
  p_async_time          =>null,
  p_names_font          =>'Arial:8:#000000',
  p_names_rotation      =>null,
  p_values_font         =>'Arial:8:#000000',
  p_values_rotation     =>null,
  p_hints_font          =>'Arial:10:#000000',
  p_legend_font         =>'Arial:8:#000000',
  p_grid_labels_font    =>'Arial:10:#000000',
  p_chart_title_font    =>'Verdana:14:#000000',
  p_x_axis_title_font   =>'Arial:14:#000000',
  p_y_axis_title_font   =>'Arial:14:#000000',
  p_use_chart_xml       =>'N',
  p_chart_xml           => a1,
  p_attribute_01        =>'',
  p_attribute_02        =>'',
  p_attribute_03        =>'',
  p_attribute_04        =>'',
  p_attribute_05        =>'');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'select null link,r.hr hour,nvl(l.views,0) views'||chr(10)||
'from   '||chr(10)||
'    ('||chr(10)||
'    select '||chr(10)||
'       count(*) views,'||chr(10)||
'       to_char(time_stamp,''YYYYMMDDHH24'') long_date'||chr(10)||
'     from   '||chr(10)||
'       WWV_FLOW_ACTIVITY_LOG l'||chr(10)||
'     where'||chr(10)||
'       security_group_id = :flow_security_group_id and'||chr(10)||
'       page_mode != ''A'' and'||chr(10)||
'       time_stamp >= sysdate - 2'||chr(10)||
'     group by to_char(time_stamp,''YYYYMMDDHH24'')) l,'||chr(10)||
'     (select to_char((selec';

a1:=a1||'t (sysdate-1)+((rnum)/24) from dual),''HH24'') hr,'||chr(10)||
'     				 to_char((select (sysdate-2)+((rnum)/24) from dual),''YYYYMMDDHH24'') long_date,'||chr(10)||
'     				 rnum'||chr(10)||
'				from'||chr(10)||
'				(select rownum rnum '||chr(10)||
'				   from all_objects '||chr(10)||
'				  where rownum < 49)) r'||chr(10)||
' where l.long_date(+) = r.long_date'||chr(10)||
' order by r.rnum';

wwv_flow_api.create_flash_chart_series(
  p_id => 88207932625831616.4352+wwv_flow_api.g_id_offset,
  p_chart_id => 88207811126831616.4352+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_series_seq                =>10,
  p_series_name               =>'Vues de page',
  p_series_query              => a1,
  p_series_query_type         =>'SQL_QUERY',
  p_series_query_parse_opt    =>'PARSE_CHART_QUERY',
  p_series_query_no_data_found=>'Aucune donnée n''a été trouvée.',
  p_series_query_row_count_max=>250);
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'20786728673431316';

wwv_flow_api.create_page_plug (
  p_id=> 20791602186461507.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 20786728673431316 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>21106400138500046.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:14:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 14.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_15.43
prompt  ...PAGE 15.4352: Vues de page par jour
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 15.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par jour',
  p_step_title=> 'Vues de page par jour',
  p_step_sub_title => 'Activity by day',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>15.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20773910236399564.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select to_char(to_date(r.long_date,''YYYYMMDDHH24''),''Day'') day,'||chr(10)||
'r.hr hour,'||chr(10)||
'nvl(l.views,0) views,'||chr(10)||
'nvl(l.distinct_users,0) d_users,'||chr(10)||
'avg_elap,'||chr(10)||
' decode(nvl(l.views,0),0,1,ceil(greatest(trunc(500*l.views)/nvl(tv.total_views,.000001)))) graph'||chr(10)||
'from   '||chr(10)||
'    ('||chr(10)||
'    select '||chr(10)||
'       count(*) views,'||chr(10)||
'       count(distinct userid) distinct_users,'||chr(10)||
'       avg(elap) avg_elap,'||chr(10)||
'       to_char(time_stamp,''YYYYMMDDHH24'') ';

s:=s||'long_date'||chr(10)||
'     from   '||chr(10)||
'       WWV_FLOW_ACTIVITY_LOG l'||chr(10)||
'     where'||chr(10)||
'       security_group_id = :flow_security_group_id and'||chr(10)||
'       page_mode != ''A'' and'||chr(10)||
'       time_stamp >= sysdate - 2 and'||chr(10)||
'       (:P15_USER is null or upper(userid) like upper(:P15_USER))'||chr(10)||
'     group by to_char(time_stamp,''YYYYMMDDHH24'')) l,'||chr(10)||
'     (select to_char((select (sysdate-2)+((rnum)/24) from dual),''HH24'') hr,'||chr(10)||
'     				 to_char((s';

s:=s||'elect (sysdate-2)+((rnum)/24) from dual),''YYYYMMDDHH24'') long_date,'||chr(10)||
'     				 rnum'||chr(10)||
'				from'||chr(10)||
'				(select rownum rnum '||chr(10)||
'				   from all_objects '||chr(10)||
'				  where rownum < 49)) r,'||chr(10)||
'     (select count(*) total_views from WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'     where security_group_id = :flow_security_group_id and time_stamp >= sysdate - 2  and'||chr(10)||
'       (:P15_USER is null or userid like :P15_USER)) tv'||chr(10)||
' where l.long_date(+) ';

s:=s||'= r.long_date'||chr(10)||
' order by r.rnum';

wwv_flow_api.create_report_region (
  p_id=> 20779630705403474.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4352,
  p_name=> 'Vues de page d''espace de travail au cours des dernières 48 heures',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 11,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<p>La valeur des colonnes de temps écoulé est exprimée en secondes.</p>',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '1000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> ' width="13" height="12" ',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20782303608414579.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 20779630705403474.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'DAY',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Jour',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20780307475403490.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 20779630705403474.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'HOUR',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Heure',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20780422018403490.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 20779630705403474.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'VIEWS',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Vues de<br />page',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 21727808733455004.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 20779630705403474.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'D_USERS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Utilisateurs',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 21729309903464773.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 20779630705403474.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'AVG_ELAP',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Temps écoulé<br />moyen',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8880722287621509.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 20779630705403474.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 6,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'20786728673431316';

wwv_flow_api.create_page_plug (
  p_id=> 20789522487457853.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 20786728673431316 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 233084919420903612.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>21748719170548851.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:15:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Filtrez par utilisateur. Saisissez un nom utilisateur et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>21747331730546749.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4352,
  p_name=>'P15_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 233084919420903612.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Utilisateur',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP',
  p_named_lov=> 'FND USERS',
  p_lov => 'select htf.escape_sc(user_name) d, user_name r'||chr(10)||
'from wwv_flow_fnd_user'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>21748406234548846.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4352,
  p_name=>'P15_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 233084919420903612.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 21750414545551317.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 15.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'rp',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 15.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_16.43
prompt  ...PAGE 16.4352: Détails de statut de session
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_purge_session.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 16.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Détails de statut de session',
  p_step_title=> 'Détails de statut de session',
  p_step_sub_title => 'Session State',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>16.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 7257605029858748.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 122212014860145074.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4352,
  p_plug_name=> 'Barre de boutons',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'    d.flow_instance,'||chr(10)||
'    d.ITEM_NAME i,'||chr(10)||
'    decode(dbms_lob.getlength(d.item_value),0,null,'||chr(10)||
'       decode(d.IS_ENCRYPTED,''Y'',''*****'',d.item_value)) item_value,'||chr(10)||
'    decode(d.session_state_status,'||chr(10)||
'           ''I'',wwv_flow_lang.system_message(''F4350.INSERTED''),'||chr(10)||
'           ''U'',wwv_flow_lang.system_message(''F4350.UPDATED''),'||chr(10)||
'           wwv_flow_lang.system_message(''F4350.UNKNOWN'') )'||chr(10)||
'        sessi';

s:=s||'on_state_status,'||chr(10)||
'    d.flow_id,'||chr(10)||
'    d.name_length'||chr(10)||
'from WWV_FLOW_DATA d'||chr(10)||
'where flow_instance = :flow_session and'||chr(10)||
'  (:P16_item is null or instr(upper(d.item_name),upper(:P16_item))>0)';

wwv_flow_api.create_report_region (
  p_id=> 174245008929070421.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4352,
  p_name=> 'Session State',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucun statut de session n''a été trouvé.',
  p_query_num_rows_item=> 'P16_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 13-FEB-2002 12:09:56');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48911214298773050.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174245008929070421.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_INSTANCE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Session',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48911306992773050.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174245008929070421.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'I',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Elément',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48911429087773050.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174245008929070421.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ITEM_VALUE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Valeur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48911521183773050.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174245008929070421.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_STATE_STATUS',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Statut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48911625069773050.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174245008929070421.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_ID',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48911707628773050.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 174245008929070421.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'NAME_LENGTH',
  p_column_display_sequence=> 6,
  p_column_heading=> 'NameLength',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>174246003001070427.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4352,
  p_branch_action=> '16',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de sessions à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>28224230500976386.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4352,
  p_name=>'P16_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 122212014860145074.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,500,1000,2000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>28225008252988892.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4352,
  p_name=>'P16_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 122212014860145074.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez des critères d''interrogation sans distinction entre les majuscules et les minuscules et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>122215204948151674.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4352,
  p_name=>'P16_ITEM',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 122212014860145074.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Elément',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 28225915871991097.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 16.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'rp',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 16.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_17.43
prompt  ...PAGE 17.4352: Définir des préférences d'espace de travail
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_prefs.htm';

ph:=ph||'<script type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
'function p17_checkdisable(){ '||chr(10)||
'var ltext_0 = $x(''P17_EXPIRE_FND_USER_ACCOUNTS_0''); '||chr(10)||
'var ltext_1 = $x(''P17_EXPIRE_FND_USER_ACCOUNTS_1''); '||chr(10)||
'var ltext; '||chr(10)||
'if(ltext_0.checked == true){ltext = ltext_0}else{ltext = ltext_1} '||chr(10)||
'html_DisableOnValue(ltext,''N'',''P17_ACCOUNT_LIFETIME_DAYS'',''P17_USER_MAX_LOGIN_FAILURES'') '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 17.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Définir des préférences d''espace de travail',
  p_step_title=> 'Définir des préférences d''espace de travail',
  p_html_page_onload=>'onload="p17_checkdisable()"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161844',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>17.4352,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>17.4352,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5171608747872545.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4352,
  p_plug_name=> 'Contrôle de connexion de compte',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5177619632036569.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4352,
  p_plug_name=> 'SQL Workshop',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Fonctionnalité de contrôle des préférences pour l''espace de travail.';

wwv_flow_api.create_page_plug (
  p_id=> 5181326820057615.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4352,
  p_plug_name=> 'Définir des préférences',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 85275322133251437.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4352,
  p_plug_name=> 'Message d''espace de travail',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 113809631511815477.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4352,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 113858225820003007.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4352,
  p_plug_name=> 'Préférences',
  p_region_name=>'',
  p_plug_template=> 185388915190864903.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 11,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 113889631108061313.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 113858225820003007+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 113887204096053504.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 113858225820003007+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>113889809101061315.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4352,
  p_branch_action=> 'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>113889631108061313.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Effectuez une sélection pour déterminer si les comptes utilisateur final &PRODUCT_NAME. peuvent être invalidés ou verrouillés. Cette fonctionnalité ne s''applique qu''aux'||chr(10)||
'comptes utilisateur final créés à l''aide de l''interface de gestion des utilisateurs &PRODUCT_NAME..'||chr(10)||
' Les options disponibles sont les suivantes :'||chr(10)||
'<ul>'||chr(10)||
'<li>Activer</li>'||chr(10)||
'<li>Désactiver</li>'||chr(10)||
'</ul>'||chr(10)||
'Cette fonctionnalité offre d''autres f';

h:=h||'onctions de sécurité d''authentification pour les applications.'||chr(10)||
'Si vous sélectionnez <b>Activer</b>, les mots de passe de compte utilisateur arriveront à expiration après une période de temps configurable,'||chr(10)||
'les comptes seront verrouillés après un nombre déterminé d''échecs d''authentification et les mots de passe pourront être définis de telle sorte qu''ils arrivent à expiration après la première utili';

h:=h||'sation.'||chr(10)||
'<p>'||chr(10)||
'Si l''administrateur &PRODUCT_NAME. de cette installation a affecté la valeur Oui au paramètre d''environnement <b>Demander l''expiration et le verrouillage du compte utilisateur</b>, cela signifie que la fonctionnalité doit être activée pour tous les espaces de travail et que l''élément affichera <b>Activer</b> et ne peut pas être modifié par l''administrateur d''espace de travail.';

wwv_flow_api.create_page_item(
  p_id=>4828217458002138.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4352,
  p_name=>'P17_EXPIRE_FND_USER_ACCOUNTS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 5171608747872545.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Expiration et verrouillage de compte :',
  p_source=>'if nvl(wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS''),''N'') = ''Y'''||chr(10)||
'  then return ''Y'';'||chr(10)||
'else'||chr(10)||
'  for c1 in (select nvl(EXPIRE_FND_USER_ACCOUNTS,''N'') e '||chr(10)||
'    from WWV_FLOW_COMPANIES '||chr(10)||
'    where PROVISIONING_COMPANY_ID = :flow_security_group_id) loop'||chr(10)||
'    return c1.e;'||chr(10)||
'  end loop;'||chr(10)||
'end if;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'EXPIRE USER ACCOUNTS',
  p_lov => '.'||to_char(4834509455047185 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'onchange="p17_checkdisable()"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'nvl(wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS''),''N'') = ''Y''',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez un entier positif indiquant le nombre maximum autorisé de tentatives d''authentification consécutives en échec avant qu''un compte utilisateur final ne soit bloqué. Si vous n''indiquez pas de valeur dans ce champ, le paramètre d''environnement <b>Nombre maximum d''échecs de connexion autorisé</b> sera utilisé.';

wwv_flow_api.create_page_item(
  p_id=>4829116550011426.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4352,
  p_name=>'P17_USER_MAX_LOGIN_FAILURES',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5171608747872545.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'nvl(wwv_flow_platform.get_preference(''MAX_LOGIN_FAILURES''),15)',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'Nombre maximum d''échecs de connexion autorisé :',
  p_source=>'select fnd_user_max_login_failures from WWV_FLOW_COMPANIES where PROVISIONING_COMPANY_ID = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 3,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez un entier positif indiquant le nombre maximum de jours d''utilisation d''un mot de passe de compte utilisateur final avant que le compte n''arrive à expiration. Si vous n''indiquez pas de valeur dans ce champ, le paramètre d''environnement <b>Durée de validité du mot de passe de compte</b> sera utilisé.';

wwv_flow_api.create_page_item(
  p_id=>5483624971767521.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4352,
  p_name=>'P17_ACCOUNT_LIFETIME_DAYS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 5171608747872545.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'nvl(wwv_flow_platform.get_preference(''ACCOUNT_LIFETIME_DAYS''),45)',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'Durée de validité des comptes utilisateur final (jours) :',
  p_source=>'select account_lifetime_days from WWV_FLOW_COMPANIES where PROVISIONING_COMPANY_ID = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 3,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Entrez le message à afficher sur la page d''accueil d''Application Builder. Pour inclure le formatage, ajoutez des balises HTML standard.';

wwv_flow_api.create_page_item(
  p_id=>85276509105257181.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4352,
  p_name=>'P17_MESSAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 85275322133251437.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Message',
  p_source=>'select builder_notification_message '||chr(10)||
'from wwv_flow_companies '||chr(10)||
'where PROVISIONING_COMPANY_ID = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 70,
  p_cMaxlength=> 2000,
  p_cHeight=> 6,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez une option pour déterminer si les développeurs peuvent modifier et compiler des unités de programme PL/SQL depuis le navigateur d''objet. Les options disponibles sont les suivantes :'||chr(10)||
'<ul>'||chr(10)||
'<li>Autoriser la modification d''unités de programme PL/SQL</li>'||chr(10)||
'<li>Ne pas autoriser la modification d''unités de programme PL/SQL</li>'||chr(10)||
'</ul>'||chr(10)||
'Cette fonctionnalité est conçue pour dissuader les programm';

h:=h||'eurs de modifier le code PL/SQL directement à partir du dictionnaire de données. Si vous sélectionnez <b>Ne pas autoriser la modification d''unités de programme PL/SQL</b>, les développeurs peuvent tout de même créer et remplacer des unités de programme PL/SQL à l''aide de scripts ou du processeur de commandes SQL.';

wwv_flow_api.create_page_item(
  p_id=>113919310002206635.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4352,
  p_name=>'P17_PLSQL_EDITING',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 5177619632036569.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Modification du code PL/SQL :',
  p_source=>'if nvl(wwv_flow_platform.get_preference(''PLSQL_EDITING''),''Y'') = ''N'' then'||chr(10)||
'  return ''N'';'||chr(10)||
'else'||chr(10)||
'  for c1 in (select nvl(ALLOW_PLSQL_EDITING,''Y'') ALLOW_PLSQL_EDITING '||chr(10)||
'               from WWV_FLOW_COMPANIES '||chr(10)||
'              where PROVISIONING_COMPANY_ID = :flow_security_group_id ) loop'||chr(10)||
'    return c1.ALLOW_PLSQL_EDITING;'||chr(10)||
'  end loop;'||chr(10)||
'end if;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'PLSQL EDITING STATUS',
  p_lov => '.'||to_char(113937100137241641 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'nvl(wwv_flow_platform.get_preference(''PLSQL_EDITING''),''Y'') = ''N''',
  p_read_only_when_type=>'PLSQL_EXPRESSION',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 5488712607896482.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4352,
  p_computation_sequence => 10,
  p_computation_item=> 'P17_EXPIRE_FND_USER_ACCOUNTS',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'if nvl(wwv_flow_platform.get_preference(''EXPIRE_FND_USER_ACCOUNTS''),''N'') = ''Y'''||chr(10)||
'  then return ''Y'';'||chr(10)||
'else'||chr(10)||
'  return v(''P17_EXPIRE_FND_USER_ACCOUNTS'');'||chr(10)||
'end if;',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5225431816970359.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17.4352,
  p_validation_name => 'Expire FND User Accounts in Y/N or null',
  p_validation_sequence=> 10,
  p_validation => 'nvl(:P17_EXPIRE_FND_USER_ACCOUNTS,''N'') in (''Y'',''N'')',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Valeur hors limites.',
  p_when_button_pressed=> 113889631108061313.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 4828217458002138.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5500703800083172.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17.4352,
  p_validation_name => 'max login failures positive',
  p_validation_sequence=> 25,
  p_validation => 'declare'||chr(10)||
'    l_number number;'||chr(10)||
'begin'||chr(10)||
'    l_number := to_number( :P17_USER_MAX_LOGIN_FAILURES );'||chr(10)||
'    if l_number = abs(trunc(l_number)) then'||chr(10)||
'        return TRUE;'||chr(10)||
'    else '||chr(10)||
'        return FALSE;'||chr(10)||
'    end if;'||chr(10)||
'exception'||chr(10)||
'    when others then'||chr(10)||
'        return FALSE;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'La valeur doit être un entier positif.',
  p_validation_condition=> 'P17_USER_MAX_LOGIN_FAILURES',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 113889631108061313.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 4829116550011426.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 5501825617089452.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17.4352,
  p_validation_name => 'account lifetime positive',
  p_validation_sequence=> 45,
  p_validation => 'declare'||chr(10)||
'    l_number number;'||chr(10)||
'begin'||chr(10)||
'    l_number := to_number( :P17_ACCOUNT_LIFETIME_DAYS );'||chr(10)||
'    if l_number = abs(trunc(l_number)) then'||chr(10)||
'        return TRUE;'||chr(10)||
'    else '||chr(10)||
'        return FALSE;'||chr(10)||
'    end if;'||chr(10)||
'exception'||chr(10)||
'    when others then'||chr(10)||
'        return FALSE;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'La valeur doit être un entier positif.',
  p_validation_condition=> 'P17_ACCOUNT_LIFETIME_DAYS',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 113889631108061313.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 5483624971767521.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'if nvl(wwv_flow_platform.get_preference(''PLSQL_EDITING''),''Y'') = ''Y'' then'||chr(10)||
'  update WWV_FLOW_COMPANIES set ALLOW_PLSQL_EDITING = :P17_PLSQL_EDITING'||chr(10)||
'         where PROVISIONING_COMPANY_ID = :flow_security_group_id and '||chr(10)||
'        :P17_PLSQL_EDITING is not null;'||chr(10)||
'end if;'||chr(10)||
'--                                 '||chr(10)||
'update WWV_FLOW_COMPANIES set EXPIRE_FND_USER_ACCOUNTS = :P17_EXPIRE_FND_USER_ACCOUNTS'||chr(10)||
'       where ';

p:=p||'PROVISIONING_COMPANY_ID = :flow_security_group_id;'||chr(10)||
'--                                 '||chr(10)||
'update WWV_FLOW_COMPANIES set builder_notification_message = :P17_MESSAGE'||chr(10)||
'       where PROVISIONING_COMPANY_ID = :flow_security_group_id;'||chr(10)||
'--  '||chr(10)||
'declare '||chr(10)||
'  x number;'||chr(10)||
'begin'||chr(10)||
'  begin'||chr(10)||
'    x := to_number(ltrim(rtrim(:P17_USER_MAX_LOGIN_FAILURES)));'||chr(10)||
'  exception when others then'||chr(10)||
'    x := null;'||chr(10)||
'  end;'||chr(10)||
'  update WWV_FLOW_CO';

p:=p||'MPANIES set FND_USER_MAX_LOGIN_FAILURES = x'||chr(10)||
'       where PROVISIONING_COMPANY_ID = :flow_security_group_id;'||chr(10)||
'  --'||chr(10)||
'  begin'||chr(10)||
'    x := to_number(ltrim(rtrim(:P17_ACCOUNT_LIFETIME_DAYS)));'||chr(10)||
'  exception when others then'||chr(10)||
'    x := null;'||chr(10)||
'  end;                                            '||chr(10)||
'  update WWV_FLOW_COMPANIES set ACCOUNT_LIFETIME_DAYS = x'||chr(10)||
'       where PROVISIONING_COMPANY_ID = :flow_security_group_id;'||chr(10)||
'';

p:=p||'end;';

wwv_flow_api.create_page_process(
  p_id     => 113888522450058819.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Apply Changes',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible d''appliquer les préférences d''espace de travail.',
  p_process_when_button_id=>113889631108061313.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Préférences d''espace de travail appliquées.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 17.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_18.43
prompt  ...PAGE 18.4352: Modifications d'application par jour
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 18.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par jour',
  p_step_title=> 'Modifications d''application par jour',
  p_step_sub_title => 'Report 1',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161845',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>18.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select day, sum(application_changes) application_changes, count(distinct flow_user) developers,'||chr(10)||
'100 * (sum(application_changes) / nvl(max(c.total_views),1)) pct,'||chr(10)||
'round(300 * (sum(application_changes) / nvl(max(c.total_views),1)))  graph'||chr(10)||
'from'||chr(10)||
'('||chr(10)||
'select trunc(audit_date) day, flow_user, count(*) application_changes'||chr(10)||
'          from wwv_flow_builder_audit_trail'||chr(10)||
'         where security_group_id = :flow_s';

s:=s||'ecurity_group_id '||chr(10)||
'         group by trunc(audit_date), flow_user'||chr(10)||
'         ) x,'||chr(10)||
'(select count(*) total_views '||chr(10)||
' from wwv_flow_builder_audit_trail'||chr(10)||
' where security_group_id = :flow_security_group_id '||chr(10)||
') c'||chr(10)||
'group by day';

wwv_flow_api.create_report_region (
  p_id=> 22484219508292076.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4352,
  p_name=> 'Developer activity by day',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P18_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 22485024740292095.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 22484219508292076.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'DAY',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Jour',
  p_column_format=> '&DATE_FORMAT. Day',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '40',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 22485130042292095.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 22484219508292076.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION_CHANGES',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Modifications<br />d''application',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 22586713830268261.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 22484219508292076.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'DEVELOPERS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Développeurs',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6673313870724027.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 22484219508292076.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Pourcentage',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6667226459661442.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 22484219508292076.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 5,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22538504508142544.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 22523422114043579 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22594631969282972.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4352,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107722418224063780.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>22676605669426783.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:18:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 06-MAY-2004 14:30 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>22674527701423696.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4352,
  p_name=>'P18_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 107722418224063780.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(87960028308944903 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>22675600820425426.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4352,
  p_name=>'P18_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 107722418224063780.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 22677617443430146.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'rp',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 18.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_19.43
prompt  ...PAGE 19.4352: Détail de session
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_mg_sessions.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 19.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Détail de session',
  p_step_title=> 'Détail de session',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161845',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>19.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 108353803614971175.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 167633106238520796.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4352,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select	 CREATED_BY database_username,'||chr(10)||
'	 CREATED_ON,'||chr(10)||
'	 COOKIE application_username,'||chr(10)||
'	 ID,'||chr(10)||
'(select count(*) page_views from WWV_FLOW_ACTIVITY_LOG where SESSION_ID = :p19_id)'||chr(10)||
'         logged_page_views,'||chr(10)||
'(select max(time_stamp) mt from WWV_FLOW_ACTIVITY_LOG where SESSION_ID = :p19_id)'||chr(10)||
'         most_recent_view,'||chr(10)||
'(select count(*) c from WWV_FLOW_DATA where FLOW_INSTANCE= :p19_id)'||chr(10)||
'         session_state_';

s:=s||'items'||chr(10)||
' from	 WWV_FLOW_SESSIONS$ s'||chr(10)||
'where id = :p19_id and security_group_id = :flow_security_group_id';

wwv_flow_api.create_report_region (
  p_id=> 167635406631549268.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4352,
  p_name=> 'Session Detail',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 2,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167635702179549272.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167635406631549268.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'DATABASE_USERNAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Nom utilisateur de base de données',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167635810433549272.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167635406631549268.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED_ON',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Créé',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167635901481549272.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167635406631549268.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION_USERNAME',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Nom utilisateur d''application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167636012879549272.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167635406631549268.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Numéro d''identification de session',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167641104731586569.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167635406631549268.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'LOGGED_PAGE_VIEWS',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Vues de page journalisées',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167904414434755738.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167635406631549268.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'MOST_RECENT_VIEW',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Vue de page la plus récente',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167646206856615499.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167635406631549268.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_STATE_ITEMS',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Eléments de statut de session',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'    d.flow_instance session_id,'||chr(10)||
'    d.ITEM_NAME item_name,'||chr(10)||
'    decode(dbms_lob.getlength(d.item_value),0,null,'||chr(10)||
'       decode(d.IS_ENCRYPTED,''Y'',''*****'',d.item_value)) item_value,'||chr(10)||
'    decode(d.session_state_status,'||chr(10)||
'           ''I'',wwv_flow_lang.system_message(''F4350.INSERTED''),'||chr(10)||
'           ''U'',wwv_flow_lang.system_message(''F4350.UPDATED''),'||chr(10)||
'           wwv_flow_lang.system_message(''F4350.UNKNOW';

s:=s||'N'') )'||chr(10)||
'        session_state_status,'||chr(10)||
'    d.flow_id application'||chr(10)||
'from WWV_FLOW_DATA d'||chr(10)||
'where flow_instance = :p19_id and '||chr(10)||
'exists (select 1 from wwv_flow_sessions$ where id = :p19_id and security_group_id = :flow_security_group_id)';

wwv_flow_api.create_report_region (
  p_id=> 167653627465659374.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4352,
  p_name=> 'Valeurs d''élément de statut de session',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '1',
  p_customized_name=> 'Afficher les valeurs de statut de session',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P19_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167653926881659379.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167653627465659374.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Session',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167654030793659379.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167653627465659374.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ITEM_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom d''élément',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167654122400659379.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167653627465659374.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ITEM_VALUE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Valeur d''élément',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167654213191659379.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167653627465659374.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_STATE_STATUS',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Statut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167654300834659380.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167653627465659374.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select  l.TIME_STAMP,  '||chr(10)||
'        l.ELAP,  '||chr(10)||
'        l.FLOW_ID application,'||chr(10)||
'        (select name from wwv_flows where id = l.flow_id) application_Name,  '||chr(10)||
'        l.STEP_ID page, p.name page_name,'||chr(10)||
'        num_rows rows_processed'||chr(10)||
'from    WWV_FLOW_ACTIVITY_LOG l,'||chr(10)||
'        wwv_flow_steps p'||chr(10)||
'where   l.security_group_id = :flow_security_group_id and'||chr(10)||
'        p.id = l.step_id and'||chr(10)||
'        p.flow_id = l.flow_id ';

s:=s||'and l.session_id = :p19_id'||chr(10)||
'order by l.time_stamp desc';

wwv_flow_api.create_report_region (
  p_id=> 167911012318802431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4352,
  p_name=> 'Vues de page',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '1',
  p_customized_name=> 'Afficher l''état Vues de page',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P19_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167911302641802436.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167911012318802431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'TIME_STAMP',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Vue de page',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167911417313802436.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167911012318802431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ELAP',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Durée de génération<br />en secondes',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167911516837802436.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167911012318802431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Application',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 173541928467005502.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167911012318802431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION_NAME',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Nom d''application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167911615334802436.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167911012318802431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Page',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 167911723343802436.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167911012318802431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_NAME',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Nom de page',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 173539913445991756.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 167911012318802431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'ROWS_PROCESSED',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Lignes<br />traitées',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select	 min(user_agent) user_agent'||chr(10)||
' from	 WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'where SESSION_ID = :P19_ID and user_agent is not null';

wwv_flow_api.create_report_region (
  p_id=> 173534120886956086.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4352,
  p_name=> 'Informations de navigateur',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '1',
  p_customized_name=> 'Informations de navigateur',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P19_ROWS',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '150000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 173534427356956091.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 173534120886956086.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_AGENT',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Agent utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>167916523316824523.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4352,
  p_branch_action=> 'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-APR-2005 02:29 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>167636715289551739.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4352,
  p_name=>'P19_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 108353803614971175.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>276203117198733880.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4352,
  p_name=>'P19_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 108353803614971175.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_C',
  p_lov => '.'||to_char(87964809046948816 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>276209018153753039.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4352,
  p_name=>'P19_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 108353803614971175.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 167915918814823200.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 19.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 19.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_20.43
prompt  ...PAGE 20.4352: Modifications d'application par jour
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 20.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par jour',
  p_step_title=> 'Modifications d''application par jour',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090528141912',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>20.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22821104843817536.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 111,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'  trunc(audit_date) audit_date,'||chr(10)||
'  to_char(count(distinct flow_user),''999,999,999,999,999,990'') developers,'||chr(10)||
'  to_char(count(*),''999,999,999,999,990'') developer_changes,'||chr(10)||
'  txt_developers,'||chr(10)||
'  txt_changes'||chr(10)||
'from wwv_flow_builder_audit_trail,'||chr(10)||
'    (select wwv_flow_lang.system_message(''CHANGES'') txt_changes'||chr(10)||
'     from dual) t1,'||chr(10)||
'    (select wwv_flow_lang.system_message(''DEVELOPERS'') txt_developers'||chr(10)||
'   ';

s:=s||'  from dual) t2'||chr(10)||
'where security_group_id = :flow_security_group_id '||chr(10)||
'group by trunc(audit_date), txt_developers, txt_changes'||chr(10)||
'order by trunc(audit_date)';

wwv_flow_api.create_calendar (
  p_id=> 22824023806841842.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4352,
  p_plug_name=> 'Application Changes by Day',
  p_region_name=>'',
  p_plug_source=> s,
  p_plug_source_type  => 'CALENDAR',
  p_plug_template=> 0,
  p_plug_display_sequence=> 2,
  p_plug_display_column  => 1,
  p_plug_display_point   => 'AFTER_SHOW_ITEMS',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_display_condition_type => '',
  p_plug_display_when_condition => '',
  p_plug_display_when_cond2=>'',
  p_plug_caching => 'NOT_CACHED',
  p_plug_header=> '',
  p_plug_footer=> '',
  p_plug_override_reg_pos=>'',
  p_plug_customized=>'0',
  p_plug_customized_name=>'',
  p_translate_title=>'',
  p_plug_comment=> '',
  p_cal_id=>22824321336841849.4352 + wwv_flow_api.g_id_offset,
  p_start_date=>'',
  p_end_date=>'',
  p_begin_at_start_of_interval=>'Y',
  p_date_item=>'',
  p_display_as=>'M',
  p_display_item=>'',
  p_display_type=>'CUS',
  p_item_format=>'<span class="instructiontext">#TXT_DEVELOPERS#:#DEVELOPERS#<br />'||chr(10)||
'#TXT_CHANGES#:#DEVELOPER_CHANGES#</span>',
  p_easy_sql_owner=>'',
  p_easy_sql_table=>'',
  p_date_column=>'AUDIT_DATE',
  p_display_column=>'',
  p_start_of_week=>'19721105',
  p_day_link=>'',
  p_item_link=>'',
  p_start_time=>'',
  p_end_time=>'',
  p_time_format=>'',
  p_week_start_day=>'',
  p_week_end_day=>'',
  p_date_type_column=>'',
  p_template_id=>50595123809626578.4352 + wwv_flow_api.g_id_offset,
  p_calendar_comments=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22827416580868187.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 22523422114043579 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 20.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_21.43
prompt  ...PAGE 21.4352: Gérer les services
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_mg_service.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 21.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Gérer les services',
  p_step_title=> 'Gérer les services',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215667724760013351+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161845',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>21.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Demandez une modification de votre service actuel, par exemple un espace de stockage en base de données plus important ou l''accès à un nouveau schéma.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 820727355208089.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Fourniture d''infos de paramétrage',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 15,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => 'NEVER',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4325721035137499.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 41747811878222591.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Statut de session',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 55,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 2067103440398740 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/manage_service.gif" width="64" height="64" alt="" /></td><td>',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'41424809053067534';

wwv_flow_api.create_page_plug (
  p_id=> 41752728847227423.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Mise en mémoire cache',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 65,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 41424809053067534 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/db_64.gif" border="0" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'41758527939236654';

wwv_flow_api.create_page_plug (
  p_id=> 41760803829239203.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Espace de travail',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 75,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 41758527939236654 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/change_storage.gif" border="0" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'41778218420271753';

wwv_flow_api.create_page_plug (
  p_id=> 41780125346273738.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Journaux',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 85,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 41778218420271753 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/files_64.gif" border="0" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'41778218420271753';

wwv_flow_api.create_page_plug (
  p_id=> 41796032366332560.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Préférences d''espace de travail',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 95,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 41794724747330333 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/todo_64.gif" border="0" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'41778218420271753';

wwv_flow_api.create_page_plug (
  p_id=> 41799511503345422.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Applications',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 105,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 41800825356349455 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/prod_apex_64.gif" border="0" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'41809121808367332';

wwv_flow_api.create_page_plug (
  p_id=> 41810430812369927.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 115,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 41809121808367332 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Vous pouvez utiliser l''option Gérer les services de votre espace de travail. Vous pouvez gérer l''état de session, les fichiers journaux, l''interruption de service, les demandes de schéma, les demandes de stockage, le contenu en mémoire cache et les modèles d''application.';

wwv_flow_api.create_page_plug (
  p_id=> 42491430107461218.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Gérer les services',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select schema'||chr(10)||
'from   wwv_flow_company_schemas'||chr(10)||
'where  security_group_id = :flow_security_group_id'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 42494607906502196.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_name=> 'Schémas d''espace de travail',
  p_region_name=>'',
  p_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 2,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_03',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11670410466357416.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '1500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42494926575502200.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42494607906502196.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schéma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 42524529461189510.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4352,
  p_plug_name=> 'Etats sur le schéma d''espace de travail',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 77,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 4869427763068324 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/browse_db.gif" border="0" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 21.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_22.43
prompt  ...PAGE 22.4352: Surveiller l'activité
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 22.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Surveiller l''activité',
  p_step_title=> 'Surveiller l''activité',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161845',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>22.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 868317340432334.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4352,
  p_plug_name=> 'Vues de page',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 61339238287578026 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/chart_bar_64.gif" border="0" height="64" width="64" alt="" /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 882110638496600.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4352,
  p_plug_name=> 'Analyse de vue de page',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 882616872498402 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/search_64.gif" border="0" height="64" width="64" alt="" /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table><p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4098101886299301.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22852102269006022.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4352,
  p_plug_name=> 'Modifications d''application',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 22853420277011168 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/flashlight_wbg_64x64.png" border="0" height="64" width="64" alt="" /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'167617332155424156';

wwv_flow_api.create_page_plug (
  p_id=> 26365204158918140.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4352,
  p_plug_name=> 'Tentatives de connexion',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 26405214790138770 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/lock_64.gif" border="0" height="64" width="64" alt="" /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'41809121808367332';

wwv_flow_api.create_page_plug (
  p_id=> 41856530054539962.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4352,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 41809121808367332 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_required_role=>'FLOW: ADMIN',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 56636630435030858.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4352,
  p_plug_name=> 'Environnement',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 56633624548029155 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/client_64.gif" border="0" height="64" width="64" alt="" /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'167617332155424156';

wwv_flow_api.create_page_plug (
  p_id=> 167618427091432137.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4352,
  p_plug_name=> 'Sessions',
  p_region_name=>'',
  p_plug_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 167617332155424156 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/users_64.gif" border="0" height="64" width="64" alt="" /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>4300302793993508.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4352,
  p_branch_action=> '11',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>4300013875993507.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 22.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_23.43
prompt  ...PAGE 23.4352: Gérer les utilisateurs de &PRODUCT_NAME.
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_users.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 23.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Gérer les utilisateurs de &PRODUCT_NAME.',
  p_step_title=> 'Gérer les utilisateurs de &PRODUCT_NAME.',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450104703534414+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161845',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>23.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4096620110295138.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 23.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_24.43
prompt  ...PAGE 24.4352: Vues de page par utilisateur par application
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 24.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par utilisateur par application',
  p_step_title=> 'Vues de page par utilisateur par application',
  p_step_sub_title => 'Page Views by User by Application',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161845',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>24.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_views as ('||chr(10)||
'select count(*) tpv'||chr(10)||
'from  WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'where time_stamp >= sysdate - nvl(:P24_DATE,1)'||chr(10)||
'and   security_group_id = :flow_security_group_id and'||chr(10)||
'(userid = :p24_user or (userid = ''nobody'' and lower(:p24_user) = ''nobody'') or nvl(:p24_user,''0'') = ''0'')'||chr(10)||
')'||chr(10)||
'select the_link,'||chr(10)||
'       application,'||chr(10)||
'       page_views,'||chr(10)||
'       100*page_views/tpv pct,'||chr(10)||
'       round(300*page_views/tpv) gra';

s:=s||'ph,'||chr(10)||
'      report_rows,'||chr(10)||
'      elapsed_time'||chr(10)||
'from ('||chr(10)||
'select    ''f?p=4350:32:''||:flow_session||''::NO::P32_FLOW,P32_TIME,P32_USER:''||'||chr(10)||
'      flow_id||'',''||nvl(:P24_DATE,1)||'',''||:p24_user the_link, '||chr(10)||
'      flow_id application, '||chr(10)||
'   count(*) page_views,'||chr(10)||
'   sum(num_rows) report_rows,'||chr(10)||
'   sum(elap) elapsed_time'||chr(10)||
'from  WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'where time_stamp >= sysdate - nvl(:P24_DATE,1)'||chr(10)||
'and   security_group_id =';

s:=s||' :flow_security_group_id and'||chr(10)||
'(userid = :p24_user or (userid = ''nobody'' and lower(:p24_user) = ''nobody'') or nvl(:p24_user,''0'') = ''0'')'||chr(10)||
'group by flow_id) d, total_views';

wwv_flow_api.create_report_region (
  p_id=> 5198224326925581.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4352,
  p_name=> 'Page Views by User By Application',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P24_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5198522460925603.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5198224326925581.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'THE_LINK',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5198612931925603.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5198224326925581.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Application',
  p_column_html_expression=>'<a href="#THE_LINK#">#APPLICATION#</a>',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5198704684925603.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5198224326925581.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Vues de page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5200723119963045.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5198224326925581.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Pourcentage',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5200807123963045.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5198224326925581.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 5,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7702625771588093.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5198224326925581.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'REPORT_ROWS',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Lignes d''état',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7702731024588093.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5198224326925581.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'ELAPSED_TIME',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Temps écoulé',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5204125113982534.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 17076621049411881.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>17054211493288729.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4352,
  p_branch_action=> '24',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 31-DEC-2002 14:58:45');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez la tranche de temps de la recherche.';

wwv_flow_api.create_page_item(
  p_id=>17056418784297733.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4352,
  p_name=>'P24_DATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 5204125113982534.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'P25_DATE',
  p_source_type=> 'ITEM',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>17057607141303767.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4352,
  p_name=>'P24_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5204125113982534.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez un nom utilisateur pour limiter l''état.';

wwv_flow_api.create_page_item(
  p_id=>17067509312361248.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4352,
  p_name=>'P24_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 5204125113982534.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Utilisateur',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'FND USERS',
  p_lov => 'select htf.escape_sc(user_name) d, user_name r'||chr(10)||
'from wwv_flow_fnd_user'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tous les utilisateurs -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>138019222124310598.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4352,
  p_name=>'P24_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 5204125113982534.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 138022919485319370.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 24.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>17057607141303767.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 24.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_25.43
prompt  ...PAGE 25.4352: Vues de page par utilisateur
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 25.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par utilisateur',
  p_step_title=> 'Vues de page par utilisateur',
  p_step_sub_title => 'Top Users',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161846',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>25.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4108205827309879.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_views as'||chr(10)||
'(select count(*) tpv '||chr(10)||
'from  WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'where time_stamp >= sysdate - :P25_DATE'||chr(10)||
'and   security_group_id = :flow_security_group_id)'||chr(10)||
'select the_link, '||chr(10)||
'       developer, '||chr(10)||
'       page_views, '||chr(10)||
'       page_events,'||chr(10)||
'       page_processing,'||chr(10)||
'       100* page_views/tpv pct,'||chr(10)||
'       round(100* page_views/tpv) graph , report_rows, pages distinct_pages,applications,elapsed_time,'||chr(10)||
'   ';

s:=s||'    distinct_hours,distinct_days, last_view, first_view, nvl(cached_pages,0) cached_pages, nvl(cached_regions,0) cached_regions, average_elapsed_time, partial_page_views'||chr(10)||
'from'||chr(10)||
'('||chr(10)||
'select ''f?p=4350:24:''||:flow_session||'':::25:P24_DATE,P24_USER:\''||'||chr(10)||
'       :p25_date||''\,''||upper(userid) the_link,'||chr(10)||
'       upper(USERID) developer, '||chr(10)||
'       count(*) page_events,'||chr(10)||
'       sum(decode(page_mode,''A'',0,1)) page_vi';

s:=s||'ews,'||chr(10)||
'       sum(decode(page_mode,''A'',1,0)) page_processing,'||chr(10)||
'       sum(num_rows) report_rows,'||chr(10)||
'       count(distinct(flow_id||''.''||step_id)) pages,'||chr(10)||
'       count(distinct(flow_id)) applications,'||chr(10)||
'      sum(elap) elapsed_time,'||chr(10)||
'      avg(elap) average_elapsed_time,'||chr(10)||
'      count(distinct to_char(time_stamp,''YYYY.MM.DD.HH24'')) distinct_hours,'||chr(10)||
'      count(distinct to_char(time_stamp,''YYYY.MM.DD'')) distinct';

s:=s||'_days,'||chr(10)||
'      max(time_stamp) last_view,'||chr(10)||
'      min(time_stamp) first_view,'||chr(10)||
'      sum(decode(page_mode,''R'',1,0)) cached_pages,'||chr(10)||
'      sum(cached_regions) cached_regions,'||chr(10)||
'      sum(decode(page_mode,''P'',1,0)) partial_page_views'||chr(10)||
'from  WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'where time_stamp >= sysdate - :P25_DATE'||chr(10)||
'and   security_group_id = :flow_security_group_id'||chr(10)||
'and (:P25_SEARCH is null or instr(upper(userid),upper(:P25_';

s:=s||'SEARCH))>0 )'||chr(10)||
'group by ''f?p=4350:24:''||:flow_session||'':::25:P24_DATE,P24_USER:''||'||chr(10)||
'       :p25_date||'',''||upper(userid), upper(USERID) '||chr(10)||
') pv, total_views';

wwv_flow_api.create_report_region (
  p_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4352,
  p_name=> 'Page Views by User',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<p>La valeur des colonnes de temps écoulé est exprimée en secondes.</p>',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P25_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'N',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'POINTS',
  p_prn_paper_size=> 'CUSTOM',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'VERTICAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '8',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '8',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4895920563607372.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'THE_LINK',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'LEFT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4896019742607377.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DEVELOPER',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Développeur',
  p_column_html_expression=>'<a href="#THE_LINK#">#DEVELOPER#</a>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'LEFT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4896122975607377.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Vues de<br />page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'RIGHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 131110427595552453.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_EVENTS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Evénements<br />de page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 131110503547552453.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_PROCESSING',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Traitement<br />de page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4903527668642630.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Pourcentage',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'RIGHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4899704550617068.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 7,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:100px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'LEFT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7698305554572724.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'REPORT_ROWS',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Lignes<br />d''état',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'RIGHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7698431252572724.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'DISTINCT_PAGES',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Pages',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'RIGHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31773623851283032.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATIONS',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Applications',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'RIGHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7699422869577709.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'ELAPSED_TIME',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Ecoulé',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'RIGHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42543731481786164.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'DISTINCT_HOURS',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Heures',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'RIGHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42543809578786165.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'DISTINCT_DAYS',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Jours',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '9',
  p_print_col_align=> 'RIGHT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42773207761984374.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_VIEW',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Dernière vue',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 46230401900609906.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'FIRST_VIEW',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Première vue',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 46233520993643818.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'CACHED_PAGES',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Pages en<br />mémoire cache',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 46233629990643818.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'CACHED_REGIONS',
  p_column_display_sequence=> 19,
  p_column_heading=> 'Régions en<br />mémoire cache',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 47073100230956378.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'AVERAGE_ELAPSED_TIME',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Temps écoulé<br />moyen',
  p_column_format=> '999G999G999G999G990D0000',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 131767515815816591.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 4895603726607350.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'PARTIAL_PAGE_VIEWS',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Vues de page<br />partielle',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5180512459865310.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>131170811232636848.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4352,
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 22-APR-2006 01:14 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à '||chr(10)||
''||chr(10)||
'inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>874931239464688.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4352,
  p_name=>'P25_DATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 5180512459865310.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'to_number(.25)',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'Depuis',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>879324229481641.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4352,
  p_name=>'GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 5180512459865310.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>6402004274536482.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4352,
  p_name=>'P25_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 5180512459865310.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,25,30,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez une interrogation sans distinction entre les majuscules et les minuscules pour le titre de page ou le numéro de page et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>26289716266578932.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4352,
  p_name=>'P25_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 5180512459865310.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Rechercher',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 9900701876203315.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 25.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_26.43
prompt  ...PAGE 26.4352: Vues de page par application, détail
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 26.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par application, détail',
  p_step_title=> 'Vues de page par application, détail',
  p_step_sub_title => 'Activity by Application',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161846',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>26.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select flow_id application, '||chr(10)||
'       page_events, v, page_processing, u, p, v/u v_per_user, '||chr(10)||
'       decode(v,0,0,v/(:P26_TIME*24*60*60)) vs, '||chr(10)||
'       e,'||chr(10)||
'       m,'||chr(10)||
'       min,'||chr(10)||
'       mints, '||chr(10)||
'       maxts,'||chr(10)||
'       rr report_rows,'||chr(10)||
'       sqlerrm errors,'||chr(10)||
'       dynamic_views,'||chr(10)||
'       cached_views,'||chr(10)||
'       cached_regions'||chr(10)||
'from ('||chr(10)||
'select flow_id, '||chr(10)||
'       count(*) page_events,'||chr(10)||
'       sum(decode(page_mode,''A'',0,';

s:=s||'1)) v, '||chr(10)||
'       sum(decode(page_mode,''A'',1,0)) page_processing,'||chr(10)||
'       count(distinct userid) u,'||chr(10)||
'       avg(elap) e, max(elap) m, min(elap) min,'||chr(10)||
'       min(time_stamp) mints, max(time_stamp) maxts,'||chr(10)||
'       count(distinct(step_id)) p,'||chr(10)||
'       sum(num_rows) rr,'||chr(10)||
'       sum(decode(sqlerrm,null,0,1)) sqlerrm,'||chr(10)||
'    sum(decode(page_mode,''D'',1,''C'',1,0)) dynamic_views,'||chr(10)||
'    sum(decode(page_mode,''D'',0,''C'',0,''A'',';

s:=s||'0,''P'',1)) cached_views,'||chr(10)||
'    sum(cached_regions) cached_regions'||chr(10)||
'from wwv_flow_activity_log'||chr(10)||
'where time_stamp >= (sysdate - :P26_TIME) and '||chr(10)||
'      security_group_id = :flow_security_group_id '||chr(10)||
'group by flow_id) r'||chr(10)||
'where u > 0';

wwv_flow_api.create_report_region (
  p_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4352,
  p_name=> 'Activité par application',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<p>La valeur des colonnes de temps écoulé est exprimée en secondes.</p>',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_item=> 'P26_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_report_total_text_format=> '&nbsp;',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> ' width="13" height="12" ',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> ' width="13" height="12" ',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 29-NOV-2002 09:47:29');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 26169532637522496.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Application',
  p_column_link=>'f?p=&APP_ID.:75:&SESSION.::&DEBUG.:75:P75_FLOW,P75_TIME:#APPLICATION#,&P26_TIME.',
  p_column_linktext=>'#APPLICATION#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 131118011019576062.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_EVENTS',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Evénements<br />de page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48722404849771786.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'V',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Vues de<br />page',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 131118118187576064.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_PROCESSING',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Traitement<br />de page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48722509841771787.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'U',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Utilisateurs',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48722624974771787.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'P',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Pages',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48722702346771787.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'V_PER_USER',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Vues de page<br />par utilisateur',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48722805769771787.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'VS',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Vues<br />par seconde',
  p_column_format=> '999G990D00000',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48722908490771787.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'E',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Temps écoulé<br />moyen',
  p_column_format=> '99G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48723008018771787.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'M',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Temps écoulé<br />maximum',
  p_column_format=> '999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48723111252771787.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'MIN',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Temps écoulé<br />minimum',
  p_column_format=> '9G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48723230900771787.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'MINTS',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Première vue',
  p_column_format=> 'SINCE',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48723313897771788.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'MAXTS',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Dernière vue',
  p_column_format=> 'SINCE',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8874309988580198.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'REPORT_ROWS',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Lignes<br />d''état',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 210062721503185698.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'ERRORS',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Erreurs',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 26165003978495294.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'DYNAMIC_VIEWS',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Vues<br />dynamiques',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 26165117122495294.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'CACHED_VIEWS',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Vues en<br />mémoire cache',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48807305105018851.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 938711179274814.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'CACHED_REGIONS',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Régions en<br />mémoire cache',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4269801914876505.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107710829474029119.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>131128420332626091.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4352,
  p_branch_action=> 'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 05-DEC-2007 16:33 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à '||chr(10)||
''||chr(10)||
'inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>940505166291900.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4352,
  p_name=>'P26_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 107710829474029119.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>941213131294183.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4352,
  p_name=>'P26_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 107710829474029119.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>6444232566802604.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4352,
  p_name=>'P26_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 107710829474029119.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 9906602353212915.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 26.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 26.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_27.43
prompt  ...PAGE 27.4352: Vues de page par jour
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 27.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par jour',
  p_step_title=> 'Vues de page par jour',
  p_step_sub_title => 'Views by Day',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090528141912',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>27.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Cette page affiche un récapitulatif des activités quotidiennes des vues de page pour votre espace de travail.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 931523773240564.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4352,
  p_plug_name=> 'Activité',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'NEVER',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4317819603108750.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'20786728673431316';

wwv_flow_api.create_page_plug (
  p_id=> 22764418817405224.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 20786728673431316 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_footer=> '<p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select trunc(TIME_STAMP) ts, '||chr(10)||
'       ''<span class="instructiontext">''||'||chr(10)||
'       t.v||'':''||'||chr(10)||
'             to_char(count(*),''999,999,999,990'') ||''<br />''||'||chr(10)||
'       t.u||'':''||'||chr(10)||
'          to_char(count(distinct upper(USERID)),''999,999,999,990'')||''<br />''||'||chr(10)||
'       t.a||'':''||'||chr(10)||
'          to_char(count(distinct flow_id),''999,999,999,990'')||''<br />''||'||chr(10)||
'       t.p||'':''||'||chr(10)||
'          to_char(count(distinct step_id),';

s:=s||'''999,999,999,990'')||''</span>'' display'||chr(10)||
'    from   WWV_FLOW_ACTIVITY_LOG,'||chr(10)||
'(select wwv_flow_lang.system_message(''views'') v,'||chr(10)||
'        wwv_flow_lang.system_message(''users'') u,'||chr(10)||
'        wwv_flow_lang.system_message(''applications'') a,'||chr(10)||
'        wwv_flow_lang.system_message(''pages'') p'||chr(10)||
' from dual) t'||chr(10)||
'    where  security_group_id = :flow_security_group_id and page_mode != ''A'''||chr(10)||
'group by trunc(time_stamp), t.v, t.u';

s:=s||', t.a, t.p';

wwv_flow_api.create_calendar (
  p_id=> 233523126780054135.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4352,
  p_plug_name=> 'Page Views by Month',
  p_region_name=>'',
  p_plug_source=> s,
  p_plug_source_type  => 'CALENDAR',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column  => 1,
  p_plug_display_point   => 'AFTER_SHOW_ITEMS',
  p_plug_display_error_message=> '',
  p_plug_display_condition_type => '',
  p_plug_display_when_condition => '',
  p_plug_display_when_cond2=>'',
  p_plug_caching => 'NOT_CACHED',
  p_plug_header=> '',
  p_plug_footer=> '',
  p_plug_override_reg_pos=>'',
  p_plug_customized=>'0',
  p_plug_customized_name=>'',
  p_translate_title=>'',
  p_plug_comment=> '',
  p_cal_id=>233523432564054136.4352 + wwv_flow_api.g_id_offset,
  p_start_date=>'',
  p_end_date=>'',
  p_begin_at_start_of_interval=>'Y',
  p_date_item=>'P27_CALENDAR_DATE',
  p_display_as=>'M',
  p_display_item=>'P27_CALENDAR_DISPLAY',
  p_display_type=>'COL',
  p_item_format=>'',
  p_easy_sql_owner=>'',
  p_easy_sql_table=>'',
  p_date_column=>'TS',
  p_display_column=>'DISPLAY',
  p_start_of_week=>'19721105',
  p_day_link=>'',
  p_item_link=>'',
  p_start_time=>'',
  p_end_time=>'',
  p_time_format=>'',
  p_week_start_day=>'',
  p_week_end_day=>'',
  p_date_type_column=>'',
  p_template_id=>50595123809626578.4352 + wwv_flow_api.g_id_offset,
  p_calendar_comments=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 233524117526054144.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 27.4352,
  p_button_sequence=> 30,
  p_button_plug_id => 233523126780054135+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; Précédent',
  p_button_position=> 'TOP',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 233524921691054165.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 27.4352,
  p_button_sequence=> 30,
  p_button_plug_id => 233523126780054135+wwv_flow_api.g_id_offset,
  p_button_name    => 'Today',
  p_button_image_alt=> 'Aujourd''hui',
  p_button_position=> 'TOP',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 233525712876054167.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 27.4352,
  p_button_sequence=> 30,
  p_button_plug_id => 233523126780054135+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> 'Suivant &gt;',
  p_button_position=> 'TOP',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>233186907690029293.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4352,
  p_branch_action=> 'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 15-JUN-2006 21:56 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>233523722034054141.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4352,
  p_name=>'P27_CALENDAR_DATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 233523126780054135.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> '',
  p_item_default => 'return to_char(sysdate,''YYYYMMDD'');',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'P27_CALENDAR_DATE',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => 'Generated by Calendar wizard on 14-JUL-04');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||' wwv_flow_utilities.decrement_calendar;';

wwv_flow_api.create_page_process(
  p_id     => 233524614473054163.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 27.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Adjust Calendar Date -Previous',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors du changement de la date de calendrier.',
  p_process_when_button_id=>233524117526054144.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'Generated 14-JUL-04');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||' wwv_flow_utilities.today_calendar;';

wwv_flow_api.create_page_process(
  p_id     => 233525428769054166.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 27.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Adjust Calendar Date -Today',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors du changement de la date de calendrier.',
  p_process_when_button_id=>233524921691054165.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'Generated 14-JUL-04');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||' wwv_flow_utilities.increment_calendar;';

wwv_flow_api.create_page_process(
  p_id     => 233526206836054168.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 27.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Adjust Calendar Date -Next',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors du changement de la date de calendrier.',
  p_process_when_button_id=>233525712876054167.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'Generated 14-JUL-04');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 27.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_28.43
prompt  ...PAGE 28.4352: Purger les préférences
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_user_pref.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 28.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Purger les préférences',
  p_step_title=> 'Purger les préférences',
  p_step_sub_title => 'Manage Preferences',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161846',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>28.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 49166112971716829.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 28.4352,
  p_plug_name=> 'button box',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<span class="instructiontext">'');'||chr(10)||
'for c1 in (select count(*) c from wwv_flow_preferences$ where user_id = :flow_user and security_group_id = :flow_security_group_id) loop'||chr(10)||
'htp.p( wwv_flow_lang.system_message(''F4350_USER_PREFS'',:flow_user,c1.c));'||chr(10)||
'end loop;'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4350_RESET_PREFS'')||''</span>'');';

wwv_flow_api.create_page_plug (
  p_id=> 49166307683716829.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 28.4352,
  p_plug_name=> 'Préférences utilisateur',
  p_region_name=>'',
  p_plug_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 49166725485716829.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 28.4352,
  p_plug_name=> 'Manage Preferences',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Cet état affiche les préférences définies pour l''utilisateur en cours. Ces valeurs du statut de session sont conservées entre les connexions.';

wwv_flow_api.create_page_plug (
  p_id=> 49186429261744804.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 28.4352,
  p_plug_name=> 'Préférences',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 49167427147716830.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 28.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 49166307683716829+wwv_flow_api.g_id_offset,
  p_button_name    => 'ResetPref',
  p_button_image_alt=> 'Réinitialiser les préférences',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 49167831098716830.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 28.4352,
  p_button_sequence=> 20,
  p_button_plug_id => 49166307683716829+wwv_flow_api.g_id_offset,
  p_button_name    => 'ViewPreferences',
  p_button_image_alt=> 'Voir les préférences',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:pref:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>49179822550733432.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 28.4352,
  p_branch_action=> 'f?p=&APP_ID.:28:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 10-JAN-2007 08:52 by MIKE');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'RESET_USER_PREFERENCES';

wwv_flow_api.create_page_process(
  p_id     => 49168016057716831.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 28.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_USER_PREFERENCES',
  p_process_name=> 'reset user preferences',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible de réinitialiser les préférences utilisateur.',
  p_process_when_button_id=>49167427147716830.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Les préférences utilisateur ont été réinitialisées (enlevées).',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 28.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_29.43
prompt  ...PAGE 29.4352: Dernières vues de page
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 29.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Dernières vues de page',
  p_step_title=> 'Dernières vues de page',
  p_step_sub_title => 'Recent Page Views',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161846',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>29.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'    time_stamp,'||chr(10)||
'    elap,'||chr(10)||
'    num_rows,'||chr(10)||
'    userid,'||chr(10)||
'    flow_id,'||chr(10)||
'    step_id,'||chr(10)||
'    session_id,'||chr(10)||
'    user_agent,'||chr(10)||
'    86400 * (time_stamp - lag(time_stamp) over (order by userid, time_stamp)) thinktime,'||chr(10)||
'    sqlerrm,'||chr(10)||
'    decode(page_mode,'||chr(10)||
'        ''A'',m.m_PAGE_PROCESSING,'||chr(10)||
'        ''C'',m.m_CACHE_CREATED,'||chr(10)||
'        ''D'',m.m_DYNAMIC,'||chr(10)||
'        ''P'',m.m_PARTIAL_PAGE, '||chr(10)||
'        ''R'',m.m_CACHED,'||chr(10)||
'        page_m';

s:=s||'ode) page_mode,'||chr(10)||
'    cached_regions,'||chr(10)||
'    application_info'||chr(10)||
'from #OWNER#.WWV_FLOW_ACTIVITY_LOG,'||chr(10)||
'   (select wwv_flow_lang.system_message(''PAGE_PROCESSING'') m_PAGE_PROCESSING,'||chr(10)||
'           wwv_flow_lang.system_message(''CACHE_CREATED'') m_CACHE_CREATED,'||chr(10)||
'           wwv_flow_lang.system_message(''F4000.DYNAMIC'') m_DYNAMIC,'||chr(10)||
'           wwv_flow_lang.system_message(''PARTIAL_PAGE'') m_PARTIAL_PAGE,'||chr(10)||
'           wwv_';

s:=s||'flow_lang.system_message(''CACHED'') m_CACHED'||chr(10)||
'    from dual) m'||chr(10)||
'where security_group_id = :flow_security_group_id and '||chr(10)||
'      time_stamp >= sysdate - nvl(:p29_time,1) and'||chr(10)||
'      (nvl(:P29_PAGE_MODE,''0'')=''0'' or page_mode = :P29_PAGE_MODE) and'||chr(10)||
'      (:p29_user is null or instr(userid,upper(:p29_user)) > 0 ) and'||chr(10)||
'      (:p29_flow is null or flow_id = :p29_flow) and'||chr(10)||
'      (:p29_page is null or step_id = :p2';

s:=s||'9_page)';

wwv_flow_api.create_report_region (
  p_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4352,
  p_name=> 'Dernières vues de page',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<p>La valeur des colonnes de temps écoulé est exprimée en secondes.</p>',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P29_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_exp_filename=> 'pagelog.csv',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 29-NOV-2002 09:59:34');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48810230163772330.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'TIME_STAMP',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Date',
  p_column_format=> 'SINCE',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48810313913772330.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ELAP',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Temps de<br />vue de page',
  p_column_format=> '999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48810410207772330.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'NUM_ROWS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Interroger des lignes',
  p_column_format=> '999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48810512179772330.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'USERID',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48810615925772331.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_ID',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Application',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48810708400772331.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'STEP_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Page',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48810812142772331.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_ID',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Session',
  p_column_link=>'f?p=&FLOW_ID.:19:&SESSION.::&DEBUG.:RP,:P19_ID:#SESSION_ID#',
  p_column_linktext=>'#SESSION_ID#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2486507578206896.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'USER_AGENT',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Agent utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 43670120226089403.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'THINKTIME',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Temps<br />de réflexion',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 210056229982150295.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'SQLERRM',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Message<br />d''erreur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 228535923882060102.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_MODE',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Mode<br >de page',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>228539708561074614 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 34621625172858094.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'CACHED_REGIONS',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Régions en<br />mémoire cache ',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 266105001583439756.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 951714467347305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION_INFO',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Informations',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_print_col_width=> '7',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4280901661933171.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107708311120023876.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>130990623956463449.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4352,
  p_branch_action=> 'f?p=&APP_ID.:29:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 05-DEC-2007 13:19 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||' 	'||chr(10)||
'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à '||chr(10)||
''||chr(10)||
'inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>957402882376438.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4352,
  p_name=>'P29_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 107708311120023876.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>957907730377786.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4352,
  p_name=>'P29_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 107708311120023876.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par utilisateur, saisissez un nom utilisateur et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>1661027600956435.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4352,
  p_name=>'P29_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 107708311120023876.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Utilisateur',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 3,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par application, saisissez un ID d''application et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>22676108663323154.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4352,
  p_name=>'P29_FLOW',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 107708311120023876.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Application',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 6,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Filtrez par numéro de page. Saisissez le numéro de page et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>22676713857324576.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4352,
  p_name=>'P29_PAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 107708311120023876.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 6,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>43639705887000110.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4352,
  p_name=>'P29_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 107708311120023876.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Identifie l''événement de page journalisé';

wwv_flow_api.create_page_item(
  p_id=>130997027035511619.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4352,
  p_name=>'P29_PAGE_MODE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 45,
  p_item_plug_id => 107708311120023876.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Mode page',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'PAGE MODE',
  p_lov => '.'||to_char(228539708561074614 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tout -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 158494820430118826.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 29.4352,
  p_validation_name => 'flows is numeric',
  p_validation_sequence=> 10,
  p_validation => 'P29_FLOW',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => 'La valeur doit être numérique.',
  p_associated_item=> 22676108663323154.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 158497003245123320.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 29.4352,
  p_validation_name => 'page is numeric',
  p_validation_sequence=> 20,
  p_validation => 'P29_PAGE',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => 'La valeur doit être numérique.',
  p_associated_item=> 22676713857324576.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 961201412394966.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 29.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 29.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_30.43
prompt  ...PAGE 30.4352: Gérer le journal des activités de développeur
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_mg_logs.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 30.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Gérer le journal des activités de développeur',
  p_step_title=> 'Gérer le journal des activités de développeur',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215462122626558552+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161847',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>30.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'   c_dev pls_integer := 0;'||chr(10)||
'   c_click pls_integer := 0;'||chr(10)||
'begin'||chr(10)||
'   htp.p(''<table class="instructiontext" summary="" cellspacing="0" cellpadding="0">'');'||chr(10)||
'   -- wwv_flow_builder_audit_trail '||chr(10)||
'   select count(*) into c_dev from wwv_flow_builder_audit_trail '||chr(10)||
'   where security_group_id = :flow_security_group_id;'||chr(10)||
'   htp.prn(''<tr><td>''||wwv_flow_lang.system_message(''F4350_DEV_LOG_ENTRIES'')||''</td><td';

s:=s||' align="right" class="fielddatabold">&nbsp;'');'||chr(10)||
'   htp.prn(to_char(c_dev,''999,999,999,999,999,990''));'||chr(10)||
'   htp.prn(''</td></tr></table><p />'');'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 1004413391363499.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30.4352,
  p_plug_name=> 'Gérer le journal des activités de développeur',
  p_region_name=>'',
  p_plug_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> 'Error displaying region',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Les activités de développeur correspondent à un journal des modifications de développeur apportées à l''application au sein de cet espace de travail. Le journal trace le développeur, l''application, le composant modifié et la date. Les informations du journal de développeur sont conservées un mois. Utilisez cette page pour purger les entrées du journal des activités de développeur.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 1004623869363501.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30.4352,
  p_plug_name=> 'Activités de développeur',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Error displaying region',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_query_options => 'DERIVED_REPORT_COLUMNS',
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4322828869130307.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 6889902515000422.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 30.4352,
  p_button_sequence=> 15,
  p_button_plug_id => 1004413391363499+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2554514135549743.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 30.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 1004413391363499+wwv_flow_api.g_id_offset,
  p_button_name    => 'PURGE_DEVELOPER_LOG',
  p_button_image_alt=> 'Purger le journal de développeur',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1119314682357438.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4352,
  p_branch_action=> '30',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 29-NOV-2002 15:34 by MIKE');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete from wwv_flow_builder_audit_trail '||chr(10)||
'where security_group_id = :flow_security_group_id;';

wwv_flow_api.create_page_process(
  p_id     => 1115827233342122.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 30.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'purge builder audit',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible de purger le journal.',
  p_process_when_button_id=>2554514135549743.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Journal des activités de développeur purgé',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 30.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_31.43
prompt  ...PAGE 31.4352: Vues de page par performances de page pondérées
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 31.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par performances de page pondérées',
  p_step_title=> 'Vues de page par performances de page pondérées',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161847',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>31.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'  s number := 0;'||chr(10)||
'  d number := to_number(nvl(:P31_TIME,1)); '||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'insert into wwv_flow_temp_table ('||chr(10)||
'    c001, c002, c003, c004, c005) select flow_id, step_id, total, avgelap, weight'||chr(10)||
'from ('||chr(10)||
'select flow_id, step_id, count (*) total ,avg(elap) avgelap, avg(elap)*count(*) weight from wwv_flow_activity_log'||chr(10)||
'    where time_stamp >= (sysdate - d) '||chr(10)||
'    and security_group_id = :flow_security_group';

s:=s||'_id'||chr(10)||
'    and (:app_security_group_id = 10 or flow_id not between 4000 and 4999)'||chr(10)||
'    group by flow_id, step_id'||chr(10)||
');'||chr(10)||
''||chr(10)||
'select sum(to_number(c005)) into s from wwv_flow_temp_table;'||chr(10)||
'if nvl(s,0) = 0 then'||chr(10)||
'  s:= 1;'||chr(10)||
'end if;'||chr(10)||
'return ''select c001, c002, to_number(c003), to_number(c004), to_number(c005) n005,  '||chr(10)||
'100*to_number(c005)/to_number(''''''||s||'''''') percentage,'||chr(10)||
'round(300*to_number(c005)/to_number(''''''||s||'''''')';

s:=s||') graph '||chr(10)||
'from wwv_flow_temp_table order by to_number(c005) desc'';'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 1015807167437376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4352,
  p_name=> 'Performances pondérées',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<p>La valeur des colonnes de temps écoulé est exprimée en secondes.</p>',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_item=> 'P31_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 33783908837622330.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1015807167437376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'C001',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Application',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '21',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 33784007661622330.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1015807167437376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'C002',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Page',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 33784111252622331.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1015807167437376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'TO_NUMBER(C003)',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Vues de<br />page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_link=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.::P65_APPLICATION,P65_PAGE:#C001#,#C002#',
  p_column_linktext=>'#TO_NUMBER(C003)#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 33784207021622331.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1015807167437376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'TO_NUMBER(C004)',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Temps écoulé<br />moyen',
  p_column_format=> '999G999G999G999G999G999G990D0000',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 33784324497622331.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1015807167437376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'N005',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Performances<br />pondérées',
  p_column_format=> '999G999G999G999G999G999G990D0000',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '21',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 33784523732622331.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1015807167437376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'PERCENTAGE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Pourcentage',
  p_column_format=> '999G999G999G999G999G999G990D0000',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 33784629100622331.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1015807167437376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Graphique',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Cet état présente les pages pour lesquelles le temps écoulé multiplié par le nombre de vues de page est le plus élevé.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 1025002628483403.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4352,
  p_plug_name=> 'Performances de page pondérées',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4283706294944013.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107716719694045280.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1022424529470850.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4352,
  p_branch_action=> '31',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 29-NOV-2002 13:06 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à '||chr(10)||
''||chr(10)||
'inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>1016914440439483.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4352,
  p_name=>'P31_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 107716719694045280.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1020808945466329.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4352,
  p_name=>'P31_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 107716719694045280.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>7378721345441800.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4352,
  p_name=>'P31_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 107716719694045280.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 1021616911468627.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 31.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_32.43
prompt  ...PAGE 32.4352: Vues par page
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 32.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues par page',
  p_step_title=> 'Vues par page',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161847',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>32.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_page_views as '||chr(10)||
'('||chr(10)||
'select count(*) tpv '||chr(10)||
'from  WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'where time_stamp >= sysdate - :P32_TIME'||chr(10)||
'and   security_group_id = :flow_security_group_id and'||chr(10)||
'(userid = :p32_user or nvl(:p32_user,''0'') = ''0'') and'||chr(10)||
'flow_id = :p32_flow'||chr(10)||
')'||chr(10)||
'select page_id, '||chr(10)||
'       (select name from wwv_flow_steps where flow_id = :p32_flow and id = page_id) page_name,'||chr(10)||
'       page_views,'||chr(10)||
'       100*page_views/t';

s:=s||'pv pct, '||chr(10)||
'       round(300*page_views/tpv) graph,'||chr(10)||
'      report_rows,'||chr(10)||
'      elapsed_time'||chr(10)||
'from'||chr(10)||
'('||chr(10)||
'select step_id page_id, count(*) page_views , sum(num_rows) report_rows, sum(elap) elapsed_time'||chr(10)||
'from  WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'where time_stamp >= sysdate - :P32_TIME'||chr(10)||
'and   security_group_id = :flow_security_group_id and'||chr(10)||
'(userid = :p32_user or nvl(:p32_user,''0'') = ''0'') and'||chr(10)||
'flow_id = :p32_flow'||chr(10)||
'group by step_i';

s:=s||'d'||chr(10)||
') d, total_page_views';

wwv_flow_api.create_report_region (
  p_id=> 5470717896084547.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32.4352,
  p_name=> 'Views By Page',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 21,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5471007240084565.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5470717896084547.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Page',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5479500806145870.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5470717896084547.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom de page',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5471131441084565.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5470717896084547.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Vues de page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5472106945090809.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5470717896084547.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Pourcentage',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5472226421090810.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5470717896084547.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 5,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7706002830600313.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5470717896084547.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'REPORT_ROWS',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Lignes d''état',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7706104497600318.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 5470717896084547.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'ELAPSED_TIME',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Temps écoulé',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5476109416119971.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 17101304968296683.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>17109729518351162.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32.4352,
  p_branch_action=> '32',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 31-DEC-2002 17:55 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez la tranche de temps de la recherche.';

wwv_flow_api.create_page_item(
  p_id=>17103004407306062.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32.4352,
  p_name=>'P32_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 5476109416119971.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Identifie l''application sélectionnée.';

wwv_flow_api.create_page_item(
  p_id=>17103612025308220.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32.4352,
  p_name=>'P32_FLOW',
  p_data_type=> 'NUMBER',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 5476109416119971.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Application :',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>17104217220309693.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32.4352,
  p_name=>'P32_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5476109416119971.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez un nom utilisateur pour limiter l''état.';

wwv_flow_api.create_page_item(
  p_id=>17106013195318054.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 32.4352,
  p_name=>'P32_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 5476109416119971.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Utilisateur',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'FND USERS',
  p_lov => 'select htf.escape_sc(user_name) d, user_name r'||chr(10)||
'from wwv_flow_fnd_user'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tous les utilisateurs -',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 32.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_33.43
prompt  ...PAGE 33.4352: Modifications d'application par jour
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 33.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par jour',
  p_step_title=> 'Modifications d''application par jour',
  p_step_sub_title => 'Changes by Developer',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161847',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>33.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'  flow_user, '||chr(10)||
'  trunc(audit_date) d2, '||chr(10)||
'  count(*) c, '||chr(10)||
'  count(distinct flow_id) f'||chr(10)||
'from   '||chr(10)||
'  wwv_flow_builder_audit_trail'||chr(10)||
'where  '||chr(10)||
'  audit_date > sysdate - nvl(:p33_time,1) and '||chr(10)||
'  security_group_id = :flow_security_group_id'||chr(10)||
'group by '||chr(10)||
'  flow_user, trunc(audit_date)';

wwv_flow_api.create_report_region (
  p_id=> 1037427958531712.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33.4352,
  p_name=> 'Developer Activity by Developer by Day',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P33_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 29-NOV-2002 13:16:58');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48608519035771169.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1037427958531712.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_USER',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Développeur',
  p_column_link=>'f?p=&FLOW_ID.:42:&SESSION.::&DEBUG.::P42_USER,P42_TIME:#FLOW_USER#,&P33_TIME.',
  p_column_linktext=>'#FLOW_USER#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48608624686771169.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1037427958531712.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'D2',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Date',
  p_column_format=> '&DATE_FORMAT. Day',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48608730347771169.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1037427958531712.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'C',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Modifications',
  p_column_format=> '999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48608819644771169.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1037427958531712.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'F',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Applications',
  p_column_format=> '999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4279319191928821.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22636010938333700.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 22523422114043579 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 125778905946298681.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1037825781531715.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33.4352,
  p_branch_action=> '33',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>1039217481535006.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33.4352,
  p_name=>'P33_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 125778905946298681.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1039924061536946.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33.4352,
  p_name=>'P33_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 125778905946298681.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher dans l''état et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>55290922176823586.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33.4352,
  p_name=>'P33_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 125778905946298681.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(87960028308944903 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 1040631680539113.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 33.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_34.43
prompt  ...PAGE 34.4352: Clics externes
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 34.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Clics externes',
  p_step_title=> 'Clics externes',
  p_step_sub_title => 'External Clicks',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215673320866031164+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161847',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>34.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Vous pouvez déterminer le nombre de clics d''une application &PRODUCT_NAME. pour un site externe à l''aide de la procédure APEX_UTIL.COUNT_CLICK, ou de la version abrégée Procedure Z.';

wwv_flow_api.create_page_plug (
  p_id=> 1106902206278107.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34.4352,
  p_plug_name=> 'Clics externes',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4149031378411962.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select trunc(CLICKDATE) CLICKDATE,category, count(*) c, FLOW_USER'||chr(10)||
'from wwv_flow_clickthru_log'||chr(10)||
'where clickdate >= (sysdate - :p34_time)'||chr(10)||
'group by trunc(CLICKDATE), category, flow_user';

wwv_flow_api.create_report_region (
  p_id=> 42622608372903126.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34.4352,
  p_name=> 'External Clicks',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P34_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 97988828418145026.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42622608372903126.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CLICKDATE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Date',
  p_column_format=> '&LONG_DATE_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42622904575903127.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42622608372903126.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'CATEGORY',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Catégorie',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42623023819903127.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42622608372903126.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'C',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Nombre',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 97985417767122999.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 42622608372903126.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_USER',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 108236726284086228.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1104019911256897.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 34.4352,
  p_branch_action=> '34',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 29-NOV-2002 15:17:50');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à '||chr(10)||
''||chr(10)||
'inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>1106521121274075.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 34.4352,
  p_name=>'P34_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 108236726284086228.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1107911902280875.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 34.4352,
  p_name=>'P34_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 108236726284086228.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>42611308363827460.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 34.4352,
  p_name=>'P34_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 108236726284086228.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 1108618482282798.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 34.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 34.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_35.43
prompt  ...PAGE 35.4352: Gérer le statut de session
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_purge_session.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 35.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Gérer le statut de session',
  p_step_title=> 'Gérer le statut de session',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161847',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>35.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 49191007706757477.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35.4352,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'49193021558761543';

wwv_flow_api.create_page_plug (
  p_id=> 49199711777777630.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35.4352,
  p_plug_name=> 'Manage Session State',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 11,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 49193021558761543 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/manage_service.gif" width="64" height="64" alt="" /></td><td>',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 35.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_36.43
prompt  ...PAGE 36.4352: Modifications d'application par application, détail
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 36.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par application, détail',
  p_step_title=> 'Modifications d''application par application, détail',
  p_step_sub_title => 'Developer Activity Detail',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161847',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>36.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'  t.flow_user, '||chr(10)||
'  t.flow_id flow,'||chr(10)||
'  decode((select build_status from wwv_flows where id = t.flow_id),'||chr(10)||
'    ''RUN_ONLY'',to_char(t.page_id),'||chr(10)||
'    ''<a href="f?p=4000:4150:&SESSION.::::FB_FLOW_ID,FB_FLOW_PAGE_ID:'''||chr(10)||
'    ||t.flow_id||'',''||t.page_id||''">''||t.page_id||''</a>'') p,'||chr(10)||
'  t.audit_date d, '||chr(10)||
'  t.flow_table, '||chr(10)||
'  decode(audit_action,'||chr(10)||
'         ''I'',''<font color=green>''||wwv_flow_lang.system_message(''';

s:=s||'F4350.CREATE'')||''</font>'','||chr(10)||
'         ''D'',''<font color=red>''||wwv_flow_lang.system_message(''F4350.DELETE'')||''</font>'','||chr(10)||
'         wwv_flow_lang.system_message(''F4350.Change'')) c'||chr(10)||
'from   '||chr(10)||
'  wwv_flow_builder_audit_trail t'||chr(10)||
'where  '||chr(10)||
'  ( :P36_FLOW = null or t.flow_id = :p36_FLOW )and '||chr(10)||
'  t.audit_date >= (sysdate - nvl(:P36_TIME,1)) and '||chr(10)||
'  t.security_group_id = :flow_security_group_id';

wwv_flow_api.create_report_region (
  p_id=> 1124725262384102.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4352,
  p_name=> 'Application Changes by Application Detail',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P36_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 29-NOV-2002 15:39:02');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48515414444770551.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1124725262384102.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_USER',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '24',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 71055619410374547.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1124725262384102.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48515519339770552.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1124725262384102.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'P',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Page',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48515602653770552.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1124725262384102.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'D',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Date de modification',
  p_column_format=> 'SINCE',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '24',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 27085119727501422.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1124725262384102.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_TABLE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Composant',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_named_lov=>27067106427412398 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48515832327770552.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1124725262384102.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'C',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Action ',
  p_column_html_expression=>'<b>#C#</b>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4276519407919416.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107725205542069570.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1125120508384105.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4352,
  p_branch_action=> '36',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez la tranche de temps de la recherche.';

wwv_flow_api.create_page_item(
  p_id=>1126332390390872.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4352,
  p_name=>'P36_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 107725205542069570.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par application, sélectionnez une application et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>1127332175400336.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4352,
  p_name=>'P36_FLOW',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 107725205542069570.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Application',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'AVAILABLE.APPLICATIONS',
  p_lov => 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id )'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id))'||chr(10)||
'order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Sélectionner une application -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1127803909401633.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4352,
  p_name=>'P36_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 107725205542069570.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher dans l''état et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>23193205733374609.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4352,
  p_name=>'P36_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 17,
  p_item_plug_id => 107725205542069570.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(87962402466946929 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 9912611835225163.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 36.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 36.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_37.43
prompt  ...PAGE 37.4352: Vues de page par agent utilisateur
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 37.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vues de page par agent utilisateur',
  p_step_title=> 'Vues de page par agent utilisateur',
  p_step_sub_title => 'Browers',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161848',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>37.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4152910516424799.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 37.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_page_views as'||chr(10)||
'('||chr(10)||
'select count(*) tpv'||chr(10)||
'from wwv_flow_activity_log'||chr(10)||
'     where security_group_id = :flow_security_group_id '||chr(10)||
'       and page_mode != ''A'''||chr(10)||
'       and time_stamp >= sysdate - nvl(:P37_TIME,1)'||chr(10)||
'        and (:P37_SEARCH is null or instr(upper(user_agent),upper(:P37_SEARCH)) >0)'||chr(10)||
')'||chr(10)||
'select d.user_agent, d.page_views, 100*d.page_views/tpv pct, round(300*d.page_views/tpv) graph'||chr(10)||
'from'||chr(10)||
'('||chr(10)||
'se';

s:=s||'lect user_agent, sum(the_count) page_views'||chr(10)||
'  from'||chr(10)||
'   (select session_id, max(nvl(user_agent,'' Unknown'')) user_agent, count(*) the_count'||chr(10)||
'      from wwv_flow_activity_log l'||chr(10)||
'     where security_group_id = :flow_security_group_id '||chr(10)||
'       and page_mode != ''A'''||chr(10)||
'       and time_stamp >= sysdate - nvl(:P37_TIME,1)'||chr(10)||
'       and (:P37_SEARCH is null or instr(upper(user_agent),upper(:P37_SEARCH)) >0)'||chr(10)||
'     group';

s:=s||' by session_id)'||chr(10)||
' group by user_agent) d, total_page_views';

wwv_flow_api.create_report_region (
  p_id=> 6088213879568986.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 37.4352,
  p_name=> 'Page Views by Browser',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P37_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6088517243568991.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6088213879568986.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_AGENT',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Agent utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '70',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6088629160568991.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6088213879568986.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Vues de page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '15',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6089313317578224.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6088213879568986.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Pourcentage',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '15',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6089429955578224.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6088213879568986.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 4,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6102001637631613.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 37.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1150113046770141.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 37.4352,
  p_branch_action=> '37',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 29-NOV-2002 16:43:22');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à '||chr(10)||
''||chr(10)||
'inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>1177821232182544.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 37.4352,
  p_name=>'P37_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 6102001637631613.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1180523788192672.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 37.4352,
  p_name=>'P37_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 6102001637631613.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>6406502374573734.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 37.4352,
  p_name=>'P37_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 6102001637631613.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez une interrogation sans distinction entre les majuscules et les minuscules et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>92412525856854320.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 37.4352,
  p_name=>'P37_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 6102001637631613.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Rechercher',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 138027314206336763.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 37.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>1180523788192672.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 37.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_38.43
prompt  ...PAGE 38.4352: Modifications d'application par application
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_chng_dev.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 38.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par application',
  p_step_title=> 'Modifications d''application par application',
  p_step_sub_title => 'Developer by flow',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161848',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>38.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4195221532598321.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_page_views as'||chr(10)||
'(select count(*) tpv'||chr(10)||
'from wwv_flow_builder_audit_trail'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'and audit_date >= sysdate - nvl(:P38_TIME,1)'||chr(10)||
'and flow_id is not null)'||chr(10)||
'select the_link, application, page_views, 100*page_views/tpv pct, round(300*page_views/tpv) graph'||chr(10)||
'from '||chr(10)||
'('||chr(10)||
'select ''f?p=4350:28:''||:flow_session||''::NO::P28_FLOW,P28_TIME:''||'||chr(10)||
'       flow_id||'',''||nvl(:p';

s:=s||'38_time,''1'') the_link,'||chr(10)||
'       flow_id application, '||chr(10)||
'       count(*) page_views'||chr(10)||
'from wwv_flow_builder_audit_trail'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'and audit_date >= sysdate - nvl(:P38_TIME,1)'||chr(10)||
'and flow_id is not null'||chr(10)||
'group by  ''f?p=4350:28:''||:flow_session||''::NO::P28_FLOW,P28_TIME:''||'||chr(10)||
'       flow_id||'',''||nvl(:p38_time,''1''), flow_id'||chr(10)||
') pv, total_page_views';

wwv_flow_api.create_report_region (
  p_id=> 6450620062846391.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4352,
  p_name=> 'Application Changes by Application',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P38_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6450915114846400.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6450620062846391.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'THE_LINK',
  p_column_display_sequence=> 1,
  p_column_heading=> 'The Link',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6451032613846400.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6450620062846391.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '60',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6451129033846400.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6450620062846391.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Vues de<br />page',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6451213970846400.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6450620062846391.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Pourcentage',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '20',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6451330992846401.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 6450620062846391.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 5,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'20157602591420307';

wwv_flow_api.create_page_plug (
  p_id=> 20161017267434074.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4352,
  p_plug_name=> 'navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 20157602591420307 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20163722246444952.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1169219720138463.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4352,
  p_branch_action=> '38',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 29-NOV-2002 17:44:45');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>1171000407148095.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4352,
  p_name=>'P38_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 20163722246444952.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1172014606152176.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4352,
  p_name=>'P38_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 20163722246444952.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>6456300369869031.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4352,
  p_name=>'P38_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 20163722246444952.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 9909217245217215.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 38.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 38.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_39.43
prompt  ...PAGE 39.4352: Modèles d'application
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_mg_models.htm';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'<script src="#IMAGE_PREFIX#sc/sc_core.js" type="text/javascript"></script>';

wwv_flow_api.create_page(
  p_id     => 39.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modèles d''application',
  p_step_title=> 'Modèles d''application',
  p_step_sub_title => 'Application Models',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161848',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>39.4352,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>39.4352,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select	'||chr(10)||
'  "FLOW_ID" as "FLOW_ID",'||chr(10)||
'  "OWNER" as "OWNER",'||chr(10)||
'  "NAME" as "NAME",'||chr(10)||
'  htmldb_item.checkbox(1,m.id) as "ID",'||chr(10)||
'  "CREATED_BY" as "CREATED_BY",'||chr(10)||
'  "CREATED_ON" as "CREATED_ON",'||chr(10)||
'  decode('||chr(10)||
'    (select count(*) c from wwv_flows where id = m.flow_id),'||chr(10)||
'    1,'||chr(10)||
'    ''<img src="#IMAGE_PREFIX#check_small_black.gif" border="0" height="15" width="15" alt=""/>'','||chr(10)||
'    null)'||chr(10)||
'    application_exists,'||chr(10)||
' (select co';

s:=s||'unt(*) from WWV_FLOW_MODEL_PAGES where model_id = m.id)'||chr(10)||
'    model_pages'||chr(10)||
' from	 WWV_FLOW_MODELS m'||chr(10)||
'where (:P39_MODEL is null or instr(upper(name),upper(:P39_MODEL))>0) and'||chr(10)||
' security_group_id = :flow_security_group_id and flow_id is not null and'||chr(10)||
'(nvl(:P39_OWNER,''0'') = ''0'' or CREATED_BY = :P39_OWNER)';

wwv_flow_api.create_report_region (
  p_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 39.4352,
  p_name=> 'Application Models',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucun modèle d''application n''existe.',
  p_query_num_rows_item=> 'P39_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '40000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 238544310096033312.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Application<br />demandée',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 238544413746033312.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Parse As',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 238544520120033313.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Nom de modèle',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 238544601358033313.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 238544703214033313.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED_BY',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Propriétaire',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 238544808204033313.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED_ON',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Créé',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 238619007290342492.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION_EXISTS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'L''application<br />existe',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 238630514741382435.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 238544000220033296.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'MODEL_PAGES',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Pages<br />de modèle',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 238549921106043643.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 39.4352,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 238604330399292371.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 39.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Un modèle d''application est l''enregistrement du résultat de l''exécution de l''assistant Création d''application. Lorsque vous créez une nouvelle application, vous pouvez la baser sur un modèle d''application existant ; vous gagnez ainsi en productivité. Utilisez cette page pour supprimer les modèles d''application dont vous ne voulez pas.';

wwv_flow_api.create_page_plug (
  p_id=> 238837320883294598.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 39.4352,
  p_plug_name=> 'Modèles d''application',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 238624331663358961.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 39.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 238604330399292371+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_image_alt=> 'Supprimer ce qui est coché',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>238622212270353396.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 39.4352,
  p_branch_action=> 'f?p=&APP_ID.:39:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 17-MAY-2005 23:37 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez une interrogation sans distinction entre les majuscules et les minuscules pour le nom de modèle et cliquez sur <b>OK</b>. ';

wwv_flow_api.create_page_item(
  p_id=>238605913215296875.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 39.4352,
  p_name=>'P39_MODEL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 238604330399292371.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Modèle',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre d''utilisateurs à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>238615929754320571.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 39.4352,
  p_name=>'P39_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 238604330399292371.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_C',
  p_lov => '.'||to_char(87964809046948816 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>238623019196355386.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 39.4352,
  p_name=>'P39_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 238604330399292371.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Filtrez par propriétaire (le propriétaire étant le développeur qui a créé le modèle d''application) et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>273417703817768921.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 39.4352,
  p_name=>'P39_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 238604330399292371.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Propriétaire',
  p_source=>'0',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select distinct htf.escape_sc(created_by) d, created_by r'||chr(10)||
'from   WWV_FLOW_MODELS m'||chr(10)||
'where (:P39_MODEL is null or instr(upper(name),upper(:P39_MODEL))>0) and'||chr(10)||
' security_group_id = :flow_security_group_id and flow_id is not null'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tous les développeurs -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 116114726480666969.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 39.4352,
  p_validation_name => 'select Model(s) to delete',
  p_validation_sequence=> 10,
  p_validation => 'wwv_flow_utilities.table_to_string2(wwv_flow.g_f01) is not null',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Les modèles à supprimer doivent être indiqués.',
  p_when_button_pressed=> 238624331663358961.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 238621509499352552.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 39.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'   delete from WWV_FLOW_MODELS where id = wwv_flow.g_f01(i) and security_group_id = :flow_security_group_id;'||chr(10)||
'end loop;';

wwv_flow_api.create_page_process(
  p_id     => 238629323960375601.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 39.4352,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete model',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible de supprimer le modèle',
  p_process_when_button_id=>238624331663358961.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Modèles supprimés',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 39.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_40.43
prompt  ...PAGE 40.4352: Détails de session
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_purge_session.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 40.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Détails de session',
  p_step_title=> 'Détails de session',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161848',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>40.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select ID, SESSION_ID_HASHED, CREATED_BY, CREATED_ON,'||chr(10)||
'       COOKIE, ON_NEW_INSTANCE_FIRED_FOR, '||chr(10)||
'       replace(passed_sec_checks,'':'','': '') PASSED_SEC_CHECKS,'||chr(10)||
'       FAILED_SEC_CHECKS, SECURITY_GROUP_ID,'||chr(10)||
'   (select max(short_name) from wwv_flow_companies where s.security_group_id = PROVISIONING_COMPANY_ID) workspace_name'||chr(10)||
'  from WWV_FLOW_SESSIONS$ s'||chr(10)||
'where id = :P40_SESSION_ID';

wwv_flow_api.create_report_region (
  p_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 40.4352,
  p_name=> 'Informations de session',
  p_region_name=>'',
  p_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P40_SESSION_ID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Session introuvable.',
  p_query_num_rows_type=> 'COMPUTED_BUT_NOT_DISPLAYED',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48590718591771072.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Session',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 72923106922550909.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_ID_HASHED',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Session ID Hashed',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48590918965771072.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED_BY',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Création par',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48591007320771072.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED_ON',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Créé',
  p_column_format=> 'Day &DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48591108863771072.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COOKIE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48591227385771073.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ON_NEW_INSTANCE_FIRED_FOR',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Applications visitées',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48591313155771073.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'PASSED_SEC_CHECKS',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Succès au niveau de la sécurité',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48591428243771073.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'FAILED_SEC_CHECKS',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Echec au niveau de la sécurité',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48591516713771073.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Espace de travail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 108074901204118670.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1187818640219648.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'WORKSPACE_NAME',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Nom de l''espace de travail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 1274829139181317.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 40.4352,
  p_plug_name=> 'Session',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Menu:  administration';

wwv_flow_api.create_page_plug (
  p_id=> 11926611290734732.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 40.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'       ITEM_NAME, '||chr(10)||
'       decode(dbms_lob.getlength(d.item_value),0,null,'||chr(10)||
'          decode(d.IS_ENCRYPTED,''Y'',''*****'',d.item_value)) item_value,'||chr(10)||
'       SESSION_STATE_STATUS,'||chr(10)||
'       FLOW_ID, '||chr(10)||
'       NAME_LENGTH '||chr(10)||
'  from WWV_FLOW_DATA d'||chr(10)||
'where  flow_instance = :p40_session_id';

wwv_flow_api.create_report_region (
  p_id=> 83223704986587684.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 40.4352,
  p_name=> 'Session State',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 70,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '150',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 83224101635587697.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 83223704986587684.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ITEM_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom d''élément',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 83224215641587697.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 83223704986587684.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ITEM_VALUE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Valeur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 83224414424587697.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 83223704986587684.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_STATE_STATUS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Statut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 83224510942587697.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 83223704986587684.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 83224616342587697.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 83223704986587684.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'NAME_LENGTH',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Name Length',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 1567803922839518.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 40.4352,
  p_button_sequence=> 1,
  p_button_plug_id => 1187818640219648+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE_STATE',
  p_button_image_alt=> 'Enlever un statut',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'LEFT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 1576114883908923.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 40.4352,
  p_button_sequence=> 2,
  p_button_plug_id => 1187818640219648+wwv_flow_api.g_id_offset,
  p_button_name    => 'REMOVE_SESSION',
  p_button_image_alt=> 'Enlever une session',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'LEFT',
  p_button_redirect_url=> '',
  p_button_condition=> 'declare '||chr(10)||
'  l_user    varchar2(256);'||chr(10)||
'  l_session varchar2(256);'||chr(10)||
'  l_sgid    number;'||chr(10)||
'begin'||chr(10)||
'  wwv_flow_security.session_cookie_info_internal('||chr(10)||
'    p_user    => l_user,'||chr(10)||
'    p_session => l_session,'||chr(10)||
'    p_sgid    => l_sgid);'||chr(10)||
'  if :P40_SESSION_ID in (:FLOW_SESSION, l_session) then'||chr(10)||
'    return false;'||chr(10)||
'  else'||chr(10)||
'    return true;'||chr(10)||
'  end if;'||chr(10)||
'end;',
  p_button_condition_type=> 'FUNCTION_BODY',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1275500873182590.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 40.4352,
  p_branch_action=> '40',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 29-NOV-2002 23:25 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez la session à visualiser.';

wwv_flow_api.create_page_item(
  p_id=>1272319311168970.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 40.4352,
  p_name=>'P40_SESSION_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 1274829139181317.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Session',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select id||'' - ''||'||chr(10)||
'nvl(htf.escape_sc(cookie),wwv_flow_lang.system_message(''NULL_IN_PAREN'')) a, id from wwv_flow_sessions$ where security_group_id = :flow_security_group_id '||chr(10)||
'order by created_on desc',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1272927622171455.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 40.4352,
  p_name=>'P40_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 1274829139181317.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 1283615080262379.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 40.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'for c1 in (select id from wwv_flow_sessions$ where id = :P40_SESSION_ID and security_group_id = :flow_security_group_id) loop'||chr(10)||
'   delete from wwv_flow_data where FLOW_INSTANCE = c1.id;'||chr(10)||
'end loop;';

wwv_flow_api.create_page_process(
  p_id     => 1570021715854150.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 40.4352,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete state',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors de la suppression du statut de session (&P40_SESSION_ID.).',
  p_process_when_button_id=>1567803922839518.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Statut de session (&P40_SESSION_ID.) enlevé.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete from wwv_flow_sessions$ where id = :P40_SESSION_ID and security_group_id = :flow_security_group_id';

wwv_flow_api.create_page_process(
  p_id     => 1577101161914367.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 40.4352,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'removme session',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors de la suppression de la session.',
  p_process_when_button_id=>1576114883908923.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Session enlevée.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 40.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_41.43
prompt  ...PAGE 41.4352: Gérer le statut de construction d'application
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_build_status.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 41.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Gérer le statut de construction d''application',
  p_step_title=> 'Gérer le statut de construction d''application',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161848',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>41.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select id, name, build_status, id app_id, LAST_UPDATED_ON,'||chr(10)||
'decode(group_id,null,null,(select max(group_name) n from wwv_flow_application_groups where id = f.group_id)) Groupname'||chr(10)||
'from wwv_flows f'||chr(10)||
'where (nvl(:P41_BUILD_STATUS,''0'') = ''0'' or build_status = :P41_BUILD_STATUS) and'||chr(10)||
'      (nvl(:P41_APP_GROUP,0) = 0 or group_id = :P41_APP_GROUP) and'||chr(10)||
'       security_group_id = :flow_security_group_id and'||chr(10)||
'  ';

s:=s||'     not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id) and'||chr(10)||
'       ('||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and '||chr(10)||
'             flow_id is null and '||chr(10)||
'             security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       sele';

s:=s||'ct 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and '||chr(10)||
'             flow_id = f.id and '||chr(10)||
'             security_group_id = :flow_security_group_id )) and'||chr(10)||
'       ('||chr(10)||
'       :P41_APPLICATION is null or '||chr(10)||
'       instr(upper(name),upper(:P41_APPLICATION)) > 0 or'||chr(10)||
'       instr(id,:P41_APPLICATION) > 0'||chr(10)||
'       )';

wwv_flow_api.create_report_region (
  p_id=> 127649822246513994.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 41.4352,
  p_name=> 'Run Only Applications',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'aucune donnée n''a été trouvée',
  p_query_num_rows_item=> 'P41_DISPLAY',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '4000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 127650103647513998.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 127649822246513994.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Application',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 127650232344514000.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 127649822246513994.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 127656000821536225.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 127649822246513994.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'BUILD_STATUS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Statut de construction',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'SELECT_LIST_FROM_LOV',
  p_named_lov=>128034726363912582 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 128175511781955676.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 127649822246513994.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'APP_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 128180528890045729.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 127649822246513994.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_UPDATED_ON',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Mise à jour',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 128184022573062848.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 127649822246513994.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'GROUPNAME',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Groupe',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 127680432522658922.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 41.4352,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 127686007289679931.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 41.4352,
  p_plug_name=> 'Barre de l''outil de recherche',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 127887103676868191.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 41.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 127686007289679931+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>127687732181683054.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 41.4352,
  p_branch_action=> 'f?p=&APP_ID.:41:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour rechercher une application, saisissez une interrogation contenant son nom ou son ID, sans distinction entre les majuscules et les minuscules, et cliquez sur <b>Exécuter</b>.';

wwv_flow_api.create_page_item(
  p_id=>127686913869681884.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 41.4352,
  p_name=>'P41_APPLICATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 127686007289679931.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Application',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 12,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>127687518024683052.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 41.4352,
  p_name=>'P41_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 127686007289679931.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Identifie le statut de construction de l''application en cours. Les options sont les suivantes :<br>'||chr(10)||
'<ul><li><b>Exécuter l''application uniquement</b> - Les utilisateurs peuvent seulement exécuter l''application. Cette option est prévue pour les applications dans une instance de production.</li>'||chr(10)||
'<li><b>Exécuter et construire l''application</b> - Les développeurs et les utilisateurs peuvent à la fois e';

h:=h||'xécuter et développer l''application.</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>128039012642918076.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 41.4352,
  p_name=>'P41_BUILD_STATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 127686007289679931.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Statut de construction',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'APPLICATION BUILD STATUS',
  p_lov => '.'||to_char(128034726363912582 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tout -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez un groupe d''applications et cliquez sur le bouton <b>OK</b> pour visualiser toutes les applications qui lui sont affectées.';

wwv_flow_api.create_page_item(
  p_id=>128186301017075505.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 41.4352,
  p_name=>'P41_APP_GROUP',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 18,
  p_item_plug_id => 127686007289679931.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Groupe',
  p_source=>'0',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select group_name, id from wwv_flow_application_groups '||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by upper(group_name)',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tout -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre d''applications à afficher et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>128191126775092463.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 41.4352,
  p_name=>'P41_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 19,
  p_item_plug_id => 127686007289679931.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(87960028308944903 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'   l_id number;'||chr(10)||
'   l_build_status varchar2(255);'||chr(10)||
'begin'||chr(10)||
'for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'  l_id := wwv_flow.g_f02(i);'||chr(10)||
'  l_build_status := wwv_flow.g_f01(i);'||chr(10)||
'  if l_build_status in (''RUN_AND_BUILD'',''RUN_ONLY'') then'||chr(10)||
'  update wwv_flows'||chr(10)||
'  set build_status = l_build_status'||chr(10)||
'  where id = l_id and'||chr(10)||
'        security_group_id = :flow_security_group_id and'||chr(10)||
'        build_status != nvl(l_build_statu';

p:=p||'s,''x'') and'||chr(10)||
'        build_status is not null;'||chr(10)||
'  end if;'||chr(10)||
'end loop;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 128174803123953163.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 41.4352,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set application build status',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>127887103676868191.4352 + wwv_flow_api.g_id_offset,
  p_process_when=>'declare c pls_integer := 0; l_id number; l_build_status varchar2(255);'||chr(10)||
'begin'||chr(10)||
'for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'  l_id := wwv_flow.g_f02(i);'||chr(10)||
'  l_build_status := wwv_flow.g_f01(i);'||chr(10)||
'  if l_build_status in (''RUN_AND_BUILD'',''RUN_ONLY'') then'||chr(10)||
'  for c1 in (select 1 from wwv_flows where id = l_id and'||chr(10)||
'             security_group_id = :flow_security_group_id and'||chr(10)||
'             build_status != nvl(l_build_status,''x'') and'||chr(10)||
'             build_status is not null) loop'||chr(10)||
'    c := c + 1;'||chr(10)||
'   end loop;'||chr(10)||
'  end if;'||chr(10)||
'end loop;'||chr(10)||
'if c > 0 then return true;'||chr(10)||
'else'||chr(10)||
'  return false;'||chr(10)||
'end if;'||chr(10)||
'end;',
  p_process_when_type=>'FUNCTION_BODY',
  p_process_success_message=> 'Action traitée',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 127688120448683793.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 41.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>127687518024683052.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 41.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_42.43
prompt  ...PAGE 42.4352: Modifications d'application par développeur, détail
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 42.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modifications d''application par développeur, détail',
  p_step_title=> 'Modifications d''application par développeur, détail',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450408166535437+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161849',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>42.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'  htf.escape_sc(t.flow_user) tu, '||chr(10)||
'  t.flow_id flow,'||chr(10)||
'  t.page_id page, '||chr(10)||
'  t.audit_date d,'||chr(10)||
'  t.flow_table,  '||chr(10)||
'  decode(audit_action,'||chr(10)||
'         ''I'',i.a,'||chr(10)||
'         ''D'',d.a,'||chr(10)||
'         u.a) c'||chr(10)||
'from   '||chr(10)||
'  wwv_flow_builder_audit_trail t,'||chr(10)||
'  (select ''<span style="color:green;">''||wwv_flow_lang.system_message(''F4350.CREATE'')||''</span>'' a from dual) i,'||chr(10)||
'  (select ''<span style="color:red;">''||wwv_flow_lang.sy';

s:=s||'stem_message(''F4350.DELETE'')||''</span>'' a from dual) d,'||chr(10)||
'  (select wwv_flow_lang.system_message(''F4350.CHANGE'') a from dual) u'||chr(10)||
'  '||chr(10)||
'where  '||chr(10)||
'  (t.flow_user = :p42_user or nvl(:p42_user,''0'') = ''0'') and '||chr(10)||
'  t.audit_date >= (sysdate - nvl(:P42_TIME,1)) and'||chr(10)||
'  (nvl(:p42_application,0) = 0 or t.flow_id = :p42_application) and'||chr(10)||
'  t.security_group_id = :flow_security_group_id';

wwv_flow_api.create_report_region (
  p_id=> 17177002028637831.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4352,
  p_name=> 'Developer Activity by User',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '&nbsp;',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P42_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Télécharger en local',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 190100622100162341.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 17177002028637831.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'TU',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 70853702704688401.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 17177002028637831.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Application',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 70853832575688401.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 17177002028637831.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Page',
  p_column_link=>'f?p=4000:4150:#FLOW_SESSION#::::FB_FLOW_ID,FB_FLOW_PAGE_ID:#FLOW#,#PAGE#',
  p_column_linktext=>'#PAGE#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48648108073771409.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 17177002028637831.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'D',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Date',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 27079001672467805.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 17177002028637831.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_TABLE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Composant',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>27067106427412398 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48648309370771410.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 17177002028637831.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'C',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Action ',
  p_column_html_expression=>'<b>#C#</b>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 17191007317696154.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 265571819175286412.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>17183729171655135.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4352,
  p_branch_action=> '42',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 01-JAN-2003 11:45 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par application, sélectionnez une application et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>8007916671254951.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4352,
  p_name=>'P42_APPLICATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 23,
  p_item_plug_id => 265571819175286412.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Application',
  p_source=>'0',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'AVAILABLE.APPLICATIONS',
  p_lov => 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id )'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id))'||chr(10)||
'order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tout -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez la tranche de temps de la recherche.';

wwv_flow_api.create_page_item(
  p_id=>17177809301639896.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4352,
  p_name=>'P42_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 265571819175286412.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par développeur, sélectionnez un développeur et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>17178516227641894.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4352,
  p_name=>'P42_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 265571819175286412.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Développeur',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'FLOW_DEVELOPERS',
  p_lov => 'select htf.escape_sc(USERID) d, USERID r'||chr(10)||
'from  WWV_FLOW_developers'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tous les utilisateurs -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>17183125362654021.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4352,
  p_name=>'P42_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 265571819175286412.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>55294207893838419.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4352,
  p_name=>'P42_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 265571819175286412.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(87962402466946929 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 17188121468671856.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 42.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_43.43
prompt  ...PAGE 43.4352: Dernières sessions
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_purge_session.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 43.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Dernières sessions',
  p_step_title=> 'Dernières sessions',
  p_step_sub_title => 'Recent Sessions',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161849',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>43.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select ''<a href="f?p=&FLOW_ID.:40:''||:FLOW_SESSION||'':::40:P40_SESSION_ID:''||ID||''">''||ID||''</a>'' ID,'||chr(10)||
'    COOKIE,'||chr(10)||
'    created_on,'||chr(10)||
'   created_on s,'||chr(10)||
'    on_new_instance_fired_for,'||chr(10)||
'    security_group_id'||chr(10)||
'from WWV_FLOW_SESSIONS$'||chr(10)||
'where security_group_id = :flow_security_group_id and'||chr(10)||
'      created_on >= sysdate - nvl(:p43_time,1) and'||chr(10)||
'      (:P43_OWNER is null or instr(cookie,upper(:P43_OWNER)) > 0)';

wwv_flow_api.create_report_region (
  p_id=> 1252415192052087.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4352,
  p_name=> 'Recent Sessions',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_item=> 'P43_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 29-NOV-2002 23:03:42');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48526804973770627.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1252415192052087.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Session',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48527013487770628.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1252415192052087.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COOKIE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48527102880770628.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1252415192052087.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED_ON',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Créé',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 131192418598473695.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1252415192052087.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'S',
  p_column_display_sequence=> 4,
  p_column_heading=> '&nbsp;',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48527219937770628.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1252415192052087.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ON_NEW_INSTANCE_FIRED_FOR',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Nouvelle instance',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48527332766770628.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1252415192052087.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Espace de travail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Le statut de session est conservé dans la base de données. Cet état présente les dernières sessions, avec des liens vers des informations plus détaillées.';

wwv_flow_api.create_page_plug (
  p_id=> 1267303896126727.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4352,
  p_plug_name=> 'Sessions',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4362924601271059.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 122208606764133208.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1252821901052158.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4352,
  p_branch_action=> '43',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Limitez l''état à une tranche de temps spécifique. Indiquez la quantité de temps à inclure dans l''état et cliquez sur <b>OK</b>.<p />'||chr(10)||
'Si vous sélectionnez 1 jour, seules les dernières 24 heures s''affichent.  ';

wwv_flow_api.create_page_item(
  p_id=>1258011898081713.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4352,
  p_name=>'P43_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 122208606764133208.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Depuis',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1258827828086336.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4352,
  p_name=>'P43_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 122208606764133208.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par utilisateur, saisissez un nom utilisateur et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>1553314040747828.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4352,
  p_name=>'P43_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 122208606764133208.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Utilisateur',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher dans l''état et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>9081511993123848.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4352,
  p_name=>'P43_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 17,
  p_item_plug_id => 122208606764133208.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(87960028308944903 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 1259502333088386.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 43.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 43.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_44.43
prompt  ...PAGE 44.4352: Préférences par utilisateur
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_user_pref.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 44.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Préférences par utilisateur',
  p_step_title=> 'Préférences par utilisateur',
  p_step_sub_title => 'Preferences',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161849',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>44.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select user_id, preference_name, attribute_value, security_group_id,'||chr(10)||
'   preference_type, application'||chr(10)||
'from ('||chr(10)||
'select '||chr(10)||
'    user_id,'||chr(10)||
'    preference_name,'||chr(10)||
'    attribute_value,'||chr(10)||
'    security_group_id,'||chr(10)||
'    decode(substr(attribute_value,1,8),''fsp_sort'',''SORT'','||chr(10)||
'    decode(substr(preference_name,1,16),''PERSISTENT_ITEM_'',''ITEM'','||chr(10)||
'    decode(substr(preference_name,1,3),''FSP'','||chr(10)||
'    decode(substr(preference_name,l';

s:=s||'ength(preference_name)-4,5),''_SORT'',''SORT'',''OTHER''),'||chr(10)||
'    ''OTHER''))) preference_type,'||chr(10)||
'    decode(substr(preference_name,1,3),'||chr(10)||
'        ''FSP'','||chr(10)||
'        decode(instr(preference_name,''_''),0,null,substr(preference_name,4,instr(preference_name,''_'')-4)),'||chr(10)||
'        null'||chr(10)||
'         ) application'||chr(10)||
'from WWV_FLOW_PREFERENCES$'||chr(10)||
'where security_group_id = :flow_security_group_id and'||chr(10)||
'(:p44_name is null or instr(preferenc';

s:=s||'e_name,upper(:p44_name)) > 0) and'||chr(10)||
'    (:p44_user is null or instr(user_id,upper(:p44_user)) > 0)'||chr(10)||
') x'||chr(10)||
'where (nvl(:P44_PREFERENCE_TYPE,''0'') = ''0'' or preference_type = :P44_PREFERENCE_TYPE)';

wwv_flow_api.create_report_region (
  p_id=> 1586709431000665.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 44.4352,
  p_name=> 'Preferences',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune préférence n''a été trouvée',
  p_query_num_rows_item=> 'P44_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 01-DEC-2002 11:01:47');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48780326468772174.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1586709431000665.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48780418091772174.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1586709431000665.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PREFERENCE_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48780504780772174.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1586709431000665.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ATTRIBUTE_VALUE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Valeur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48780614972772174.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1586709431000665.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42502507916577796.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1586709431000665.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PREFERENCE_TYPE',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Type de préférence',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>42506917060665623 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 42504829995603096.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1586709431000665.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Application',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'L''état des préférences est géré au niveau utilisateur et non session.';

wwv_flow_api.create_page_plug (
  p_id=> 1589409744011516.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 44.4352,
  p_plug_name=> 'Préférences utilisateur',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4365608109275695.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 44.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 122237028244215174.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 44.4352,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1587125578000668.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4352,
  p_branch_action=> '44',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par utilisateur, saisissez un nom utilisateur et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>1592604811029036.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4352,
  p_name=>'P44_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 122237028244215174.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Utilisateur',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 12,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1593109313030282.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4352,
  p_name=>'P44_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 122237028244215174.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'OK',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de lignes à afficher dans l''état et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>9071202596092701.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4352,
  p_name=>'P44_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 17,
  p_item_plug_id => 122237028244215174.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(87960028308944903 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Identifiez un type spécifique de préférence à interroger et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>42512600015105324.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4352,
  p_name=>'P44_PREFERENCE_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 122237028244215174.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Type de préférence',
  p_source=>'0',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'PREFERENCE TYPES',
  p_lov => '.'||to_char(42506917060665623 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tout -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour filtrer par nom de préférence, saisissez une partie d''un nom de préférence et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>42516224041121716.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4352,
  p_name=>'P44_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 11,
  p_item_plug_id => 122237028244215174.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 12,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 1593816932032533.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 44.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 44.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_45.43
prompt  ...PAGE 45.4352: Purger les sessions
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_purge_session.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 45.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Purger les sessions',
  p_step_title=> 'Purger les sessions',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161849',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>45.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'   l_sessions_count pls_integer := 0;'||chr(10)||
'   l_old_sessions pls_integer := 0;'||chr(10)||
'   l_users pls_integer := 0;'||chr(10)||
'begin'||chr(10)||
'for c1 in (select count(*) c , count(distinct CREATED_BY||''.''||cookie) u'||chr(10)||
'           from wwv_flow_sessions$ '||chr(10)||
'           where security_group_id = :flow_security_group_id) loop'||chr(10)||
'   l_sessions_count := c1.c;'||chr(10)||
'   l_users := c1.u;'||chr(10)||
'end loop;'||chr(10)||
'for c1 in (select count(*) c'||chr(10)||
'           from wwv';

s:=s||'_flow_sessions$ '||chr(10)||
'           where security_group_id = :flow_security_group_id and'||chr(10)||
'                 created_on <= (sysdate - nvl(:p45_time,1)) ) loop'||chr(10)||
'           l_old_sessions := c1.c;'||chr(10)||
'end loop; '||chr(10)||
'htp.p(''<ul>'');'||chr(10)||
'--htp.p(''<li>''||wwv_flow_lang.system_message(''F4350_TOTAL_SESSIONS'',:company,l_sessions_count)||''</li>'');'||chr(10)||
'htp.p(''<li>''||wwv_flow_lang.system_message(''F4350_TOTAL_SESSIONS2'',to_char(l_session';

s:=s||'s_count,''999G999G999G999G990''))||''</li>'');'||chr(10)||
'htp.p(''<li>''||wwv_flow_lang.system_message(''F4350_DISTINCT_USERS'',l_users)||''</li>'');'||chr(10)||
'if :p45_time >=1 then'||chr(10)||
'htp.p(''<li>''||wwv_flow_lang.system_message(''F4350_SESSIONS_OLDER_THAN'',:p45_time,l_old_sessions)||''</li>'');'||chr(10)||
'else'||chr(10)||
'htp.p(''<li>''||wwv_flow_lang.system_message(''F4350_SESSIONS_OLDER_THAN_MINS'',round(:p45_time*24*60,3),l_old_sessions)||''</li>'');'||chr(10)||
'end if;'||chr(10)||
'';

s:=s||'htp.p(''</ul>'');'||chr(10)||
'end;'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 1615024869157863.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 45.4352,
  p_plug_name=> 'Purger les sessions',
  p_region_name=>'',
  p_plug_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> 'Les sessions permettent de maintenir l''état utilisateur.<p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4361214558268082.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 45.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 6896421131024683.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 45.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 1615024869157863+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:35:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 1609312917116469.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 45.4352,
  p_button_sequence=> 1,
  p_button_plug_id => 1615024869157863+wwv_flow_api.g_id_offset,
  p_button_name    => 'PURGE_SESSIONS',
  p_button_image_alt=> 'Purger les sessions',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 1613502921141984.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 45.4352,
  p_button_sequence=> 2,
  p_button_plug_id => 1615024869157863+wwv_flow_api.g_id_offset,
  p_button_name    => 'REPORT_SESSIONS',
  p_button_image_alt=> 'Communiquer les sessions',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1610017072117764.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 45.4352,
  p_branch_action=> '45',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 01-DEC-2002 11:21 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez la date à partir de laquelle purger les données de session.';

wwv_flow_api.create_page_item(
  p_id=>1608603220113714.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 45.4352,
  p_name=>'P45_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 1615024869157863.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Sessions datant de plus de :',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 3/24  t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 4/24  t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 5/24  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''10 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 10/24 t from dual union all'||chr(10)||
'select ''12 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 12/24 t from dual union all'||chr(10)||
'select ''16 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 16/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''3 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 3 t from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 4 t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 5 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'  l_user    varchar2(256);'||chr(10)||
'  l_session varchar2(256);'||chr(10)||
'  l_sgid    number;'||chr(10)||
'begin'||chr(10)||
'  wwv_flow_security.session_cookie_info_internal('||chr(10)||
'    p_user    => l_user,'||chr(10)||
'    p_session => l_session,'||chr(10)||
'    p_sgid    => l_sgid);'||chr(10)||
'  delete from wwv_flow_sessions$'||chr(10)||
'  where'||chr(10)||
'    security_group_id = :flow_security_group_id and'||chr(10)||
'    created_on <= (sysdate - nvl(:P45_TIME,1)) and'||chr(10)||
'    id not in (:FLOW_SESSION, l_sessio';

p:=p||'n);'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 1624325664290467.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 45.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'purge sessions',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors de la suppression des sessions.',
  p_process_when_button_id=>1609312917116469.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Sessions enlevées.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 45.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_46.43
prompt  ...PAGE 46.4352: Purger les préférences
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_user_pref.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 46.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Purger les préférences',
  p_step_title=> 'Purger les préférences',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215469304188572178+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role => 47302021031728224+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161849',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>46.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'  for c1 in (select count(*) c, count(distinct user_id) u'||chr(10)||
'  from WWV_FLOW_PREFERENCES$'||chr(10)||
'  where security_group_id = :flow_security_group_id) loop'||chr(10)||
'  htp.p(''<b>''||wwv_flow_lang.system_message(''F4350_SUMMARY'')||''</b><br>''||'||chr(10)||
'--wwv_flow_lang.system_message(''F4350_PREFS_EXISTS_FOR'',c1.c,c1.u,:company));'||chr(10)||
'wwv_flow_lang.system_message(''F4350_PREFS_EXISTS_FOR2'',c1.c,c1.u));'||chr(10)||
'  end loop;'||chr(10)||
'  htp.p(''<br>&nb';

s:=s||'sp;<br><b>''|| wwv_flow_lang.system_message(''F4350_SELECTED_USER'') ||''</b><br>'');'||chr(10)||
'  if :P46_USER is null then'||chr(10)||
'    htp.p( wwv_flow_lang.system_message(''F4350_NO_USER_SELECTED'')||''<p />'');'||chr(10)||
'  else'||chr(10)||
'    for c1 in (select count(*) c'||chr(10)||
'  from WWV_FLOW_PREFERENCES$'||chr(10)||
'  where security_group_id = :flow_security_group_id and '||chr(10)||
'        user_id = upper(:p46_user) ) loop'||chr(10)||
'      htp.p(wwv_flow_lang.system_message(''F435';

s:=s||'0_USER_HAS_X_PREFS'',htf.escape_sc(:p46_user),c1.c));'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 1689606689991219.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 46.4352,
  p_plug_name=> 'Purger les préférences',
  p_region_name=>'',
  p_plug_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'L''état des préférences est tenu à jour au niveau utilisateur et peut recouvrir des sessions. Les préférences peuvent être purgées une fois un utilisateur entré.';

wwv_flow_api.create_page_plug (
  p_id=> 1690324697996432.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 46.4352,
  p_plug_name=> 'Préférences',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'    user_id,'||chr(10)||
'    preference_name,'||chr(10)||
'    attribute_value,'||chr(10)||
'    security_group_id'||chr(10)||
'from WWV_FLOW_PREFERENCES$'||chr(10)||
'where security_group_id = :flow_security_group_id and'||chr(10)||
'      user_id = upper(:p46_user)'||chr(10)||
'order by preference_name';

wwv_flow_api.create_report_region (
  p_id=> 1698306052095099.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 46.4352,
  p_name=> 'User Preferences',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P46_USER',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune préférence n''a été trouvée.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48848318967772537.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1698306052095099.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48848426607772537.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1698306052095099.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PREFERENCE_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Préférence',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48848523057772537.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1698306052095099.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ATTRIBUTE_VALUE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Valeur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48848615680772537.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 1698306052095099.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Espace de travail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4364332566273336.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 46.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 6893815805013744.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 46.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 1689606689991219+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:89:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 1702529517120847.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 46.4352,
  p_button_sequence=> 1,
  p_button_plug_id => 1689606689991219+wwv_flow_api.g_id_offset,
  p_button_name    => 'PURGE_USER_PREFERENCES',
  p_button_image_alt=> 'Purger les préférences utilisateur',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P46_USER',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 1693208121019989.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 46.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 1689606689991219+wwv_flow_api.g_id_offset,
  p_button_name    => 'REPORT',
  p_button_image_alt=> 'Etat',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1691215477003220.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 46.4352,
  p_branch_action=> '46',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 01-DEC-2002 19:22 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez l''utilisateur dont les préférences doivent être purgées.';

wwv_flow_api.create_page_item(
  p_id=>1692011107011376.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 46.4352,
  p_name=>'P46_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 1689606689991219.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Utilisateur',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'POPUP',
  p_lov => 'select distinct user_id d, user_id v'||chr(10)||
'  from WWV_FLOW_PREFERENCES$'||chr(10)||
' where security_group_id = :flow_security_group_id',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete '||chr(10)||
'from WWV_FLOW_PREFERENCES$'||chr(10)||
'where security_group_id = :flow_security_group_id and'||chr(10)||
'      user_id = upper(:p46_user)';

wwv_flow_api.create_page_process(
  p_id     => 1704030340130527.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 46.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'purge preferences for user',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors de la suppression des préférences de l''utilisateur &P46_USER..',
  p_process_when_button_id=>1702529517120847.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Préférences de l''utilisateur &P46_USER. supprimées.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 1713702598169784.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 46.4352,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>1693208121019989.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 46.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_47.43
prompt  ...PAGE 47.4352: Aperçu d'espace de travail
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_wrkspc_rprt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 47.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Aperçu d''espace de travail',
  p_step_title=> 'Aperçu d''espace de travail',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215667724760013351+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> -274880608012467905.4352 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161849',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>47.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4327602812141734.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'9029510842915341';

wwv_flow_api.create_page_plug (
  p_id=> 9030700930921956.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4352,
  p_plug_name=> 'Detailed Tablespace Utilization Report',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 55,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 9029510842915341 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_footer=> '<p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||chr(10)||
'   "WWV_FLOW_COMPANIES"."PROVISIONING_COMPANY_ID" "PROVISIONING_COMPANY_ID", '||chr(10)||
'   "WWV_FLOW_COMPANIES"."SHORT_NAME" "SHORT_NAME", '||chr(10)||
'   "WWV_FLOW_COMPANIES"."FIRST_SCHEMA_PROVISIONED" "FIRST_SCHEMA_PROVISIONED"'||chr(10)||
'FROM '||chr(10)||
'   "WWV_FLOW_COMPANIES"'||chr(10)||
'WHERE (("WWV_FLOW_COMPANIES"."PROVISIONING_COMPANY_ID" =wwv_flow.get_sgid))';

wwv_flow_api.create_report_region (
  p_id=> 99910914850927778.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4352,
  p_name=> 'Workspace Information',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'STRUCTURED_QUERY',
  p_display_error_message=> '',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 99911530758927839.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 99910914850927778.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'PROVISIONING_COMPANY_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace Number',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 99911722951927841.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 99910914850927778.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Espace de travail :',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 99911926381927841.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 99910914850927778.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FIRST_SCHEMA_PROVISIONED',
  p_column_display_sequence=> 3,
  p_column_heading=> 'First Schema Provisioned',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.schema, c.name def_tablespace'||chr(10)||
'  from wwv_flow_company_schemas a, sys.user$ b, sys.ts$ c'||chr(10)||
' where a.schema = b.name'||chr(10)||
'   and b.datats# = c.ts#'||chr(10)||
'   and a.security_group_id = wwv_flow.get_sgid'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 99961202654018868.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4352,
  p_name=> '<a name="SCHEMAS">Schémas</a>',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '50',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 99961607852018878.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 99961202654018868.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schéma',
  p_column_link=>'f?p=&APP_ID.:2:#APP_SESSION#::::P2_SCHEMA:#SCHEMA#',
  p_column_linktext=>'#SCHEMA#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 175669516449932982.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 99961202654018868.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DEF_TABLESPACE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Tablespace par défaut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.name schemas2, b.name tablespaces'||chr(10)||
'  from sys.user$ a, sys.ts$ b, sys.seg$ c'||chr(10)||
' where a.user# = c.user#'||chr(10)||
'   and b.ts# = c.ts#'||chr(10)||
'   and a.name in (select schema'||chr(10)||
'                    from wwv_flow_company_schemas'||chr(10)||
'                   where security_group_id = wwv_flow.get_sgid)'||chr(10)||
'group by a.name, b.name';

wwv_flow_api.create_report_region (
  p_id=> 99998413221059858.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4352,
  p_name=> '<a name="SPACE">Schémas utilisant de l''espace dans les tablespaces</a>',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '50',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 175664602896900748.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 99998413221059858.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMAS2',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schémas',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 99998903926059875.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 99998413221059858.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TABLESPACES',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Tablespaces',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||chr(10)||
'   "WWV_FLOWS"."ID" "ID", '||chr(10)||
'   "WWV_FLOWS"."OWNER" "OWNER", '||chr(10)||
'   "WWV_FLOWS"."NAME" "NAME"'||chr(10)||
'FROM '||chr(10)||
'   "WWV_FLOWS"'||chr(10)||
'WHERE (("WWV_FLOWS"."SECURITY_GROUP_ID" =wwv_flow.get_sgid))';

wwv_flow_api.create_report_region (
  p_id=> 100034717985080115.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4352,
  p_name=> '<a name="FLOWS">Applications</a>',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 60,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'STRUCTURED_QUERY',
  p_display_error_message=> '',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '50',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100035200624080128.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100034717985080115.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100035422834080128.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100034717985080115.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Schéma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100035608185080128.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100034717985080115.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||chr(10)||
'   "WWV_FLOW_DEVELOPERS"."FLOW_ID" "FLOW_ID", '||chr(10)||
'   "WWV_FLOW_DEVELOPERS"."DEVELOPER_ROLE" "DEVELOPER_ROLE", '||chr(10)||
'   "WWV_FLOW_DEVELOPERS"."USERID" "USERID"'||chr(10)||
'FROM '||chr(10)||
'   "WWV_FLOW_DEVELOPERS"'||chr(10)||
'WHERE (("WWV_FLOW_DEVELOPERS"."SECURITY_GROUP_ID" =wwv_flow.get_sgid))';

wwv_flow_api.create_report_region (
  p_id=> 100050205481123770.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4352,
  p_name=> '<a name="DEV">Développeurs d''application</a>',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 70,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'STRUCTURED_QUERY',
  p_display_error_message=> '',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '50',
  p_query_show_nulls_as=> '- All -',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100051831440123814.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100050205481123770.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Application',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100052017236123814.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100050205481123770.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DEVELOPER_ROLE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Developer Role',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100057708173155476.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100050205481123770.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'USERID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 47.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_48.43
prompt  ...PAGE 48.4352: Demander un schéma de base de données
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_schema_request.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 48.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Demander un schéma de base de données',
  p_step_title=> 'Demander un schéma de base de données',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215667724760013351+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 4033511603675269.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> -274880608012467905.4352 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161849',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>48.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<p>'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4350_WORKSPACE_SCHEMAS'')||'' : <b>'');'||chr(10)||
'for c1 in (select schema'||chr(10)||
'           from wwv_flow_company_schemas'||chr(10)||
'           where security_group_id=:flow_security_group_id'||chr(10)||
'           order by schema) loop'||chr(10)||
'   htp.p (c1.schema);'||chr(10)||
'end loop;'||chr(10)||
'htp.p(''</b>'');'||chr(10)||
'htp.p(''</p>'');';

wwv_flow_api.create_page_plug (
  p_id=> 1993922974139464.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 48.4352,
  p_plug_name=> 'Schémas d''espace de travail',
  p_region_name=>'',
  p_plug_template=> 43831302524523552.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 12474329619420999.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 48.4352,
  p_plug_name=> 'Identifier un schéma',
  p_region_name=>'',
  p_plug_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<input type="text" style="display:none;" />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 34710406182796815.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 48.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 2006525707187473.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 48.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 12474329619420999+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 48.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 12474329619420999+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> 'Suivant >',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>245533631539678851.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 48.4352,
  p_branch_action=> 'f?p=&APP_ID.:48:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':REQUEST = P48_NEW or SR_NAME is null',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 20-MAY-2005 05:18 by SSPADAFO');
 
wwv_flow_api.create_page_branch(
  p_id=>245526615721532377.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 48.4352,
  p_branch_action=> 'f?p=&APP_ID.:66:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>2009011986193021.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 20-MAY-2005 04:54 by SSPADAFO');
 
wwv_flow_api.create_page_branch(
  p_id=>12199828843371901.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 48.4352,
  p_branch_action=> '21',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 16-DEC-2002 21:10 by RMATTAMA');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez le nom d''un schéma existant à affecter à l''espace de travail ou le nom d''un nouveau schéma à créer et à affecter à l''espace de travail.';

wwv_flow_api.create_page_item(
  p_id=>2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 48.4352,
  p_name=>'SR_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 12474329619420999.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de schéma',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov => 'declare q varchar2(32767);'||chr(10)||
'  l_flows_schema varchar2(30) := wwv_flow.g_flow_schema_owner;'||chr(10)||
'begin'||chr(10)||
'    q := ''select name n, name r from sys.user$ u where type#=1 and name <> ''''''||l_flows_schema||'''''' and name not in (''''HTMLDB_PUBLIC_USER'''',''''PUBLIC_USER'''',''''FLOWS_FILES'''',''''SCHEDULER'''',''''PEOPLE'''',''''APEX_PUBLIC_USER'''')'';'||chr(10)||
'    q := q||'' and name not in (select schema from wwv_flow_restricted_schemas where not exists (select 1 from wwv_flow_rschema_exceptions where schema_id = (select id from wwv_flow_restricted_schemas where schema = u.name))) '';'||chr(10)||
'    q := q ||'' order by 1'';'||chr(10)||
'    return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535006471295136.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>245498531773120633.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 48.4352,
  p_name=>'P48_NEW',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 12474329619420999.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'NEW_OR_EXISTING_SCHEMA',
  p_lov => '.'||to_char(245496725063109254 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="instructiontext"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 246260024880572305.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 48.4352,
  p_computation_sequence => 10,
  p_computation_item=> 'SR_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(:SR_NAME)',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2013003459199990.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'schema name not null',
  p_validation_sequence=> 5,
  p_validation => 'SR_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Le nom de schéma doit être indiqué.',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 02-DEC-2002 12:35');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2014803590209500.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'no spaces',
  p_validation_sequence=> 10,
  p_validation => 'SR_NAME',
  p_validation_type => 'ITEM_CONTAINS_NO_SPACES',
  p_error_message => 'Le nom de schéma ne doit pas contenir d''espace.',
  p_validation_condition=> 'SR_NAME',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 245516700774423917.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'no quotes in name',
  p_validation_sequence=> 15,
  p_validation => 'instr(:SR_NAME,'''''''')+instr(:SR_NAME,''"'') = 0',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Le nom de schéma ne doit pas contenir de guillemets.',
  p_validation_condition=> 'if (:P48_NEW = ''YES'' and :SR_NAME is not null) then'||chr(10)||
'   return true;'||chr(10)||
'else'||chr(10)||
'   return false;'||chr(10)||
'end if;',
  p_validation_condition_type=> 'FUNCTION_BODY',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 245518314411437321.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'schema name valid',
  p_validation_sequence=> 16,
  p_validation => 'wwv_flow_utilities.is_valid_identifier(:SR_NAME)',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Le nom de schéma n''est pas un identificateur Oracle valide.',
  p_validation_condition=> 'if (:P48_NEW = ''YES'' and :SR_NAME is not null) then'||chr(10)||
'   return true;'||chr(10)||
'else'||chr(10)||
'   return false;'||chr(10)||
'end if;',
  p_validation_condition_type=> 'FUNCTION_BODY',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 183419517126001761.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'new schema not reserved word',
  p_validation_sequence=> 20,
  p_validation => 'not wwv_flow_provision.is_reserved(:SR_NAME)',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Le nom de schéma est un mot réservé Oracle.',
  p_validation_condition=> 'if (:P48_NEW = ''YES'' and :SR_NAME is not null) then'||chr(10)||
'   return true;'||chr(10)||
'else'||chr(10)||
'   return false;'||chr(10)||
'end if;',
  p_validation_condition_type=> 'FUNCTION_BODY',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 245514313063389629.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'schema exists',
  p_validation_sequence=> 30,
  p_validation => 'select null from sys.user$ where name = upper(:SR_NAME) and type#=1',
  p_validation_type => 'EXISTS',
  p_error_message => 'Schéma non valide'||chr(10)||
'',
  p_validation_condition=> 'if (:P48_NEW = ''NO'' and :SR_NAME is not null) then'||chr(10)||
'   return true;'||chr(10)||
'else'||chr(10)||
'   return false;'||chr(10)||
'end if;',
  p_validation_condition_type=> 'FUNCTION_BODY',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 245519627009450426.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'new schema does not exist',
  p_validation_sequence=> 40,
  p_validation => 'select 1 from sys.user$ where name = upper(:SR_NAME)',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => 'Schéma non valide',
  p_validation_condition=> 'if (:P48_NEW = ''YES'' and :SR_NAME is not null) then'||chr(10)||
'   return true;'||chr(10)||
'else'||chr(10)||
'   return false;'||chr(10)||
'end if;',
  p_validation_condition_type=> 'FUNCTION_BODY',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 245520630949461024.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'new schema not a role',
  p_validation_sequence=> 50,
  p_validation => 'select null from sys.user$ where name = upper(:SR_NAME) and type#=0',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => 'Schéma non valide',
  p_validation_condition=> 'if (:P48_NEW = ''YES'' and :SR_NAME is not null) then'||chr(10)||
'   return true;'||chr(10)||
'else'||chr(10)||
'   return false;'||chr(10)||
'end if;',
  p_validation_condition_type=> 'FUNCTION_BODY',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 245521603161471970.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'schema is not restricted when admin is restricted',
  p_validation_sequence=> 60,
  p_validation => 'for c1 in (select 1 from dual where'||chr(10)||
'      wwv_flow_provisioning.restricted_schema_i(:SR_NAME,'||chr(10)||
'      wwv_flow_security.find_company_name(:WORKSPACE_ID)) = ''1'') loop'||chr(10)||
'      return false;'||chr(10)||
'end loop;'||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Schéma non valide',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 245526022863524970.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 48.4352,
  p_validation_name => 'new schema not used in existing workspace',
  p_validation_sequence=> 70,
  p_validation => 'select 1 from wwv_flow_company_schemas where schema = upper(:SR_NAME)',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => 'Schéma non valide',
  p_validation_condition=> 'declare'||chr(10)||
'   l_user_exists varchar(1) default ''N'';'||chr(10)||
'begin'||chr(10)||
'   if :P48_NEW = ''YES'''||chr(10)||
'      then '||chr(10)||
'         for c1 in ('||chr(10)||
'            select ''Y'' user_exist '||chr(10)||
'              from sys.user$ '||chr(10)||
'             where name = upper(:SR_NAME))'||chr(10)||
'         loop'||chr(10)||
'            l_user_exists := c1.user_exist;'||chr(10)||
'         end loop;'||chr(10)||
'         if l_user_exists = ''Y'''||chr(10)||
'            then return false;'||chr(10)||
'         else return true;'||chr(10)||
'         end if;'||chr(10)||
'   else'||chr(10)||
'      return false;'||chr(10)||
'   end if;'||chr(10)||
'end;',
  p_validation_condition_type=> 'FUNCTION_BODY',
  p_when_button_pressed=> 2009011986193021.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2010524107196472.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 48.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_49.43
prompt  ...PAGE 49.4352: Demander de l'espace de stockage supplémentaire
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_storage_request.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 49.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Demander de l''espace de stockage supplémentaire',
  p_step_title=> 'Demander de l''espace de stockage supplémentaire',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215667724760013351+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> -274880608012467905.4352 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161850',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>49.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2029109356277424.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 49.4352,
  p_plug_name=> 'Demander de l''espace de stockage supplémentaire',
  p_region_name=>'',
  p_plug_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Les administrateurs d''espace de travail utilisent cette page pour demander de la mémoire supplémentaire pour leur espace de travail.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 2035819099308628.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 49.4352,
  p_plug_name=> 'Stockage',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'NEVER',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4383019369316769.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 49.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.name schemas, b.name tablespaces'||chr(10)||
'  from sys.user$ a, sys.ts$ b, sys.seg$ c'||chr(10)||
' where a.user# = c.user#'||chr(10)||
'   and b.ts# = c.ts#'||chr(10)||
'   and a.name in (select schema'||chr(10)||
'                    from wwv_flow_company_schemas'||chr(10)||
'                   where security_group_id = wwv_flow.get_sgid)'||chr(10)||
'group by a.name, b.name';

wwv_flow_api.create_report_region (
  p_id=> 100110829319376668.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 49.4352,
  p_name=> 'Schémas utilisant de l''espace dans les tablespaces',
  p_region_name=>'',
  p_template=> 43831302524523552.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<ul class="noIndent">'||chr(10)||
'<li><a href="javascript:popUp(''f?p=4350:88:&SESSION.'')">Etat détaillé Utilisation de tablespace (peut prendre plusieurs secondes)</a></li>'||chr(10)||
'</ul>',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1',
  p_query_num_rows_type=> 'ROW_RANGES',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100111022652376675.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100110829319376668.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMAS',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schémas',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100111119881376675.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100110829319376668.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TABLESPACES',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Tablespaces',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 2032017105289086.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 49.4352,
  p_button_sequence=> 1,
  p_button_plug_id => 2029109356277424+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:21:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2032705116295146.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 49.4352,
  p_button_sequence=> 2,
  p_button_plug_id => 2029109356277424+wwv_flow_api.g_id_offset,
  p_button_name    => 'ADJUST_STORAGE_SIZE',
  p_button_image_alt=> 'Demander de l''espace de stockage supplémentaire',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3840802758287101.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 49.4352,
  p_branch_action=> '21',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 04-DEC-2002 14:49 by JASON');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez la quantité d''espace qui sera nécessaire.';

wwv_flow_api.create_page_item(
  p_id=>2030628749283010.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 49.4352,
  p_name=>'P49_STORAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 2029109356277424.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'declare'||chr(10)||
'    l_default number;'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select req_size'||chr(10)||
'                 from wwv_flow_workspace_req_size'||chr(10)||
'                where request_type = ''C'''||chr(10)||
'                  and default_size = ''Y'') loop'||chr(10)||
'        l_default := c1.req_size;'||chr(10)||
'        exit;'||chr(10)||
'    end loop;'||chr(10)||
'    return l_default;'||chr(10)||
'end;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'Quantité d''espace de stockage à ajouter (Mo) :',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select req_size d, req_size r'||chr(10)||
'  from wwv_flow_workspace_req_size'||chr(10)||
' where request_type = ''C'''||chr(10)||
'   and display = ''Y'''||chr(10)||
' order by to_number(d)',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 267614023564202911.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 49.4352,
  p_validation_name => 'Validate storage request size',
  p_validation_sequence=> 10,
  p_validation => 'select null '||chr(10)||
'  from wwv_flow_workspace_req_size'||chr(10)||
' where request_type = ''C'''||chr(10)||
'   and display = ''Y'''||chr(10)||
'   and req_size = :P49_STORAGE',
  p_validation_type => 'EXISTS',
  p_error_message => 'Quantité d''espace de stockage non valide exigée.',
  p_when_button_pressed=> 2032705116295146.4352 + wwv_flow_api.g_id_offset,
  p_associated_item=> 2030628749283010.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_changesize  number := :P49_STORAGE;'||chr(10)||
'begin'||chr(10)||
'  wwv_flow_provisioning.make_modification_request ('||chr(10)||
'      p_service_name        => ''CHANGE_DB_SIZE'','||chr(10)||
'      p_service_attribute_1 => l_changesize,'||chr(10)||
'      p_service_attribute_2 => wwv_flow_user_api.get_email(p_username => upper(wwv_flow.g_user)));'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 2034530050302347.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 49.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'request change of size',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors de la demande de stockage supplémentaire.',
  p_process_when_button_id=>2032705116295146.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Vous avez demandé &P49_STORAGE. Mo de stockage supplémentaire.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 49.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_50.43
prompt  ...PAGE 50.4352: Demande d'interruption de service
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_wrkspc_del.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 50.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Demande d''interruption de service',
  p_step_title=> 'Demande d''interruption de service',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215667724760013351+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> -274880608012467905.4352 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161850',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>50.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2038929273321013.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.4352,
  p_plug_name=> 'Demande d''interruption de service',
  p_region_name=>'',
  p_plug_template=> 106671321669750604.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Les administrateurs d''espace de travail utilisent cette page pour demander l''interruption de service.</p>'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 2039401699322534.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.4352,
  p_plug_name=> 'Interruption',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4384432182320517.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||chr(10)||
'   "WWV_FLOW_COMPANIES"."PROVISIONING_COMPANY_ID" "PROVISIONING_COMPANY_ID", '||chr(10)||
'   "WWV_FLOW_COMPANIES"."SHORT_NAME" "SHORT_NAME", '||chr(10)||
'   "WWV_FLOW_COMPANIES"."FIRST_SCHEMA_PROVISIONED" "FIRST_SCHEMA_PROVISIONED"'||chr(10)||
'FROM '||chr(10)||
'   "WWV_FLOW_COMPANIES"'||chr(10)||
'WHERE (("WWV_FLOW_COMPANIES"."PROVISIONING_COMPANY_ID" =wwv_flow.get_sgid))';

wwv_flow_api.create_report_region (
  p_id=> 100113926811394963.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.4352,
  p_name=> 'Workspace Information',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'STRUCTURED_QUERY',
  p_display_error_message=> '',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#htmldb/builder/request_termination.gif" border="0" width="100" height="75" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_footer=> '</td></tr></table><p />',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100114116170394967.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100113926811394963.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'PROVISIONING_COMPANY_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100114228842394967.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100113926811394963.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom de l''espace de travail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100114320671394967.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100113926811394963.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FIRST_SCHEMA_PROVISIONED',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Premier schéma paramétré',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.schema, c.name name2'||chr(10)||
'  from wwv_flow_company_schemas a, sys.user$ b, sys.ts$ c'||chr(10)||
' where a.schema = b.name'||chr(10)||
'   and b.datats# = c.ts#'||chr(10)||
'   and a.security_group_id = wwv_flow.get_sgid'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 100115402008397222.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.4352,
  p_name=> 'Schémas',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'ROW_RANGES',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100115611210397225.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100115402008397222.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schéma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 175696032163297164.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100115402008397222.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'NAME2',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Tablespace par défaut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.name schemas, b.name tablespaces'||chr(10)||
'  from sys.user$ a, sys.ts$ b, sys.seg$ c'||chr(10)||
' where a.user# = c.user#'||chr(10)||
'   and b.ts# = c.ts#'||chr(10)||
'   and a.name in (select schema'||chr(10)||
'                    from wwv_flow_company_schemas'||chr(10)||
'                   where security_group_id = wwv_flow.get_sgid)'||chr(10)||
'group by a.name, b.name';

wwv_flow_api.create_report_region (
  p_id=> 100116210319399624.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.4352,
  p_name=> 'Schémas utilisant de l''espace dans les tablespaces',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<a href="javascript:popUp(''f?p=4350:88:&SESSION.'')">Etat détaillé Utilisation de tablespace (peut prendre plusieurs secondes)</a>'||chr(10)||
'',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100116406034399626.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100116210319399624.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMAS',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schémas',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100116514592399627.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100116210319399624.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TABLESPACES',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Tablespaces',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||chr(10)||
'   "WWV_FLOWS"."ID" "ID", '||chr(10)||
'   "WWV_FLOWS"."OWNER" "OWNER", '||chr(10)||
'   "WWV_FLOWS"."NAME" "NAME"'||chr(10)||
'FROM '||chr(10)||
'   "WWV_FLOWS"'||chr(10)||
'WHERE (("WWV_FLOWS"."SECURITY_GROUP_ID" =wwv_flow.get_sgid))';

wwv_flow_api.create_report_region (
  p_id=> 100117020362402532.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.4352,
  p_name=> 'Applications',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 60,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'STRUCTURED_QUERY',
  p_display_error_message=> '',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100117232548402535.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100117020362402532.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100117301616402535.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100117020362402532.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Propriétaire',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100117422562402535.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100117020362402532.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||chr(10)||
'   "WWV_FLOW_DEVELOPERS"."USERID" "USERID",'||chr(10)||
'   decode(instr("WWV_FLOW_DEVELOPERS"."DEVELOPER_ROLE",''ADMIN''),0,'||chr(10)||
'   wwv_flow_lang.system_message(''EDIT''),'||chr(10)||
' wwv_flow_lang.system_message(''ADMIN'')||'', ''||wwv_flow_lang.system_message(''EDIT'')) privs'||chr(10)||
'FROM '||chr(10)||
'   "WWV_FLOW_DEVELOPERS"'||chr(10)||
'WHERE (("WWV_FLOW_DEVELOPERS"."SECURITY_GROUP_ID" =wwv_flow.get_sgid))';

wwv_flow_api.create_report_region (
  p_id=> 100118630059405357.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.4352,
  p_name=> 'Développeurs d''application',
  p_region_name=>'',
  p_template=> 60932116232746047.4352+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 70,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_max_columns=> 60,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_show_nulls_as=> '- All -',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 100119007737405365.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100118630059405357.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USERID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 190098612263074392.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 100118630059405357.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PRIVS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Privilèges',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 2041318322327334.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 50.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 2038929273321013+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:21:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2042126980329817.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 50.4352,
  p_button_sequence=> 20,
  p_button_plug_id => 2038929273321013+wwv_flow_api.g_id_offset,
  p_button_name    => 'REQUEST_SERVICE_TERMINATION',
  p_button_image_alt=> 'Demande d''interruption &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>2061921186384963.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.4352,
  p_branch_action=> '510',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2042126980329817.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 02-DEC-2002 13:05 by MIKE');
 
wwv_flow_api.create_page_branch(
  p_id=>2042831135331046.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.4352,
  p_branch_action=> '21',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 02-DEC-2002 12:56 by MIKE');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 50.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_51.43
prompt  ...PAGE 51.4352: Affectations de groupes d'utilisateurs
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_groups.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 51.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Affectations de groupes d''utilisateurs',
  p_step_title=> 'Affectations de groupes d''utilisateurs',
  p_step_sub_title => 'Report',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450104703534414+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161850',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>51.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4381604824312588.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 51.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select ''<a href="f?p=4350:56:''||:flow_session||'||chr(10)||
'       ''::NO::F4350_P56_USER_ID,LAST_VIEW:''||ug.user_id||'',51"><img alt="&EDIT." title="&EDIT." src="#IMAGE_PREFIX#edit_big.gif" width="24" height="24" border="0"></a>'' e,'||chr(10)||
'    g.group_name,'||chr(10)||
'    u.user_name'||chr(10)||
'from WWV_FLOW_FND_GROUP_USERS ug, wwv_flow_fnd_user_groups g, wwv_flow_fnd_user u'||chr(10)||
'where ug.security_group_id = :flow_security_group_id and g.id = ';

s:=s||'ug.group_id and'||chr(10)||
'      ug.user_id = u.user_id';

wwv_flow_api.create_report_region (
  p_id=> 63229566462407517.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 51.4352,
  p_name=> 'User Group Assignments',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '-',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune affectation d''utilisateurs à des groupes n''a été trouvée.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_required_patch=> '-274880608012467905.4352' + wwv_flow_api.g_id_offset,
  p_comment=>'generated 20-MAY-2001 21:53:46');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48728516999771821.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 63229566462407517.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'E',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48728616760771821.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 63229566462407517.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'GROUP_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom de groupe',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48728704964771822.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 63229566462407517.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'USER_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Nom utilisateur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Cet état répertorie les affectations de groupe d''utilisateurs en cours. Vous pouvez utiliser les groupes pour catégoriser les utilisateurs et gérer leurs privilèges.</p>'||chr(10)||
'<p>Pour modifier un utilisateur existant, cliquez sur l''icône de modification.</p>'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 63231316426439799.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 51.4352,
  p_plug_name=> 'Groupes d''utilisateurs',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_query_options => 'DERIVED_REPORT_COLUMNS',
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 51.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_52.43
prompt  ...PAGE 52.4352: Créer un utilisateur
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_users.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 52.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Créer un utilisateur',
  p_step_title=> 'Créer un utilisateur',
  p_step_sub_title => 'Create New User',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_group_id => 215450104703534414+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161850',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>52.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2748323936523346.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> '<a name="AC">Contrôle de compte</a>',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4149525162665290.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> 'Attributs supplémentaires',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 110,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Menu:  administration';

wwv_flow_api.create_page_plug (
  p_id=> 4208311405614354.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4597004638216477.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> '<a name="PRIV">Privilèges de développeur</a>',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':F4350_P52_WEB_PASSWORD := null;'||chr(10)||
':F4350_P52_PASSWD_CONFIRM := null;';

wwv_flow_api.create_page_plug (
  p_id=> 32837618175421491.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 100,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 63567744865578431.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> '<a name="USER">Identification utilisateur</a>',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 24-MAY-2001 18:02:15');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Cette fonction permet de contrôler l''accès des développeurs d''application, administrateurs d''espace de travail et utilisateurs finaux de &PRODUCT_NAME..</p>'||chr(10)||
'<p>Les développeurs peuvent créer et modifier des applications ainsi que des objets de base de données.</p>'||chr(10)||
'<p>Les administrateurs d''espace de travail peuvent en plus créer et modifier des comptes utilisateur, et gérer des groupes et des se';

s:=s||'rvices de développement.</p>'||chr(10)||
'<p>Les utilisateurs finaux n''ont aucun privilège de développement et sont définis pour permettre le contrôle d''accès aux applications qui n''utilisent pas de modèle d''authentification externe.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 63571066572605837.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> 'Utilisateurs',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 80,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 187400734286303164.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> 'User Management',
  p_region_name=>'',
  p_plug_template=> 185388915190864903.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 187414449357326556.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 52.4352,
  p_plug_name=> '<a name="GROUP">Groupes d''utilisateurs (pour authentification auprès du référentiel de comptes utilisateur &PRODUCT_NAME. uniquement)</a>',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 90,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 63567961253578435.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 52.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 187400734286303164+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 63568042920578435.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 52.4352,
  p_button_sequence=> 20,
  p_button_plug_id => 187400734286303164+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_image_alt=> 'Créer un utilisateur',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 39238412884699357.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 52.4352,
  p_button_sequence=> 30,
  p_button_plug_id => 187400734286303164+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE_ANOTHER',
  p_button_image_alt=> 'Créer et créer un autre',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>63570246176578443.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_branch_action=> '55',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>63568042920578435.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 24-MAY-2001 18:02:15');
 
wwv_flow_api.create_page_branch(
  p_id=>39244700248733466.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_branch_action=> 'f?p=&APP_ID.:52:&SESSION.::&DEBUG.:52,EDIT_USER_PRIVS:P52_DEVELOPER,P52_ADMIN:&P52_DEVELOPER.,&P52_ADMIN.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>39238412884699357.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 20-FEB-2003 18:24 by CBCHO');
 
wwv_flow_api.create_page_branch(
  p_id=>63570145926578443.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_branch_action=> '&LAST_VIEW.',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>63567961253578435.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 24-MAY-2001 18:02:15');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez <b>Verrouillé</b> pour interdire l''utilisation du compte. Sélectionnez <b>Déverrouillé</b> pour en autoriser l''utilisation.';

wwv_flow_api.create_page_item(
  p_id=>2748803393523351.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'P52_ACCOUNT_LOCKED',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 210,
  p_item_plug_id => 2748323936523346.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Définir la disponibilité du compte',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'ACCOUNT_LOCK_STATUS',
  p_lov => '.'||to_char(6949526744661130 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez <b>Oui</b> pour demander à l''utilisateur de ce compte de modifier immédiatement le mot de passe après s''être connecté pour la première fois au moyen du mot de passe en cours. Cette règle s''applique à l''utilisation de ce compte pour l''administration et le développement de l''espace de travail, ainsi qu''à son utilisation pour la connexion aux applications développées.';

wwv_flow_api.create_page_item(
  p_id=>2749004588523351.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'P52_CHANGE_PWD_ON_FIRST_USE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 220,
  p_item_plug_id => 2748323936523346.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Demander la modification du mot de passe à la première utilisation',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157815226475866526 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indique le nom utilisateur employé pour la connexion au système. Les noms utilisateur sont soumis aux restrictions suivantes : <ul><li>'||chr(10)||
'longueur maximum : 100 caractères</li><li>'||chr(10)||
'pas d''espaces</li>'||chr(10)||
'<li>seuls caractères spéciaux autorisés : @ et point (.)</li></ul>'||chr(10)||
'<p>Le nom utilisateur peut également être employé pour faire référence à l''activité de l''utilisateur dans les applications de surveilla';

h:=h||'nce. La variable attachée (bind variable) <code>:app_user</code> renvoie la valeur de l''utilisateur en cours lors de la construction des applications.</p>';

wwv_flow_api.create_page_item(
  p_id=>63568348763578436.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_USER_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 63567744865578431.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom utilisateur',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 100,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535006471295136.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 24-MAY-2001 18:02:15');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez le prénom de l''utilisateur, pour préciser son identité. Ce champ facultatif n''est utilisé qu''à des fins d''information.';

wwv_flow_api.create_page_item(
  p_id=>63568549286578437.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_FIRST_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 4149525162665290.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Prénom',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 24-MAY-2001 18:02:15');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez le nom de famille de l''utilisateur, pour préciser son identité. Ce champ facultatif n''est utilisé qu''à des fins d''information.';

wwv_flow_api.create_page_item(
  p_id=>63568751448578438.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_LAST_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 4149525162665290.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 24-MAY-2001 18:02:15');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Utilisez ce champ pour enregistrer des commentaires sur l''utilisateur, à des fins d''information uniquement.';

wwv_flow_api.create_page_item(
  p_id=>63568945841578439.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_DESCRIPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 4149525162665290.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Description',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 240,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 24-MAY-2001 18:02:15');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez l''adresse électronique à utiliser dans la correspondance générale, les notifications de réinitialisation des mots de passe, etc.';

wwv_flow_api.create_page_item(
  p_id=>63569221717578439.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_EMAIL_ADDRESS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 63567744865578431.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Adresse électronique',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 240,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535006471295136.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 24-MAY-2001 18:02:15');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez un mot de passe. Les mots de passe font l''objet d''une distinction entre les majuscules et les minuscules. Les développeurs peuvent modifier leur mot de passe. Ceux qui disposent du privilège d''administrateur peuvent modifier le mot de passe des utilisateurs du même espace de travail.';

wwv_flow_api.create_page_item(
  p_id=>63569351113578440.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_WEB_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 63567744865578431.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Mot de passe',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535006471295136.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 24-MAY-2001 18:02:15');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'L''utilisateur appartient aux groupes mis en évidence. Pour ajouter l''utilisateur à un groupe, cliquez sur son nom pour qu''il soit mis en évidence. Pour enlever l''utilisateur, cliquez de nouveau pour qu''il ne soit plus mis en évidence. </p> <p>'||chr(10)||
'Les groupes d''utilisateurs permettent aux développeurs de contrôler l''accès à des fonctions et fonctionnalités spécifiques par groupe d''utilisateurs. La fon';

h:=h||'ction de groupe d''utilisateurs est intégrée à Application Builder ; c''est avec l''authentification par cookie qu''elle fonctionne le mieux (et qu''elle est la plus pratique). Elle n''est pas portable dans les différents modèles d''authentification. Elle n''est utile qu''avec l''authentification INTERNAL.</p>';

wwv_flow_api.create_page_item(
  p_id=>63569543152578441.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_GROUP_IDS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 187414449357326556.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Groupes d''utilisateurs :',
  p_source_type=> 'STATIC',
  p_display_as=> 'MULTIPLESELECT',
  p_lov => 'select htf.escape_sc(group_name) d, id r'||chr(10)||
'from wwv_flow_fnd_user_groups'||chr(10)||
'where security_group_id = :flow_security_group_id order by 1',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 4,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 3,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 24-MAY-2001 18:02:15');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez la liste des schémas, séparés par des deux-points, pour lesquels ce développeur a des droits d''accès lorsqu''il utilise SQL Workshop. La liste des schémas saisie ici limite l''utilisateur à un sous-ensemble des schémas fournis pour l''espace de travail et détermine les noms de schéma que l''utilisateur visualise dans SQL Workshop.';

wwv_flow_api.create_page_item(
  p_id=>66055244597705294.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_ALLOW_ACCESS_TO_SCHEMAS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 4597004638216477.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schémas accessibles (Null pour tous)',
  p_source=>'ALLOW_ACCESS_TO_SCHEMAS',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez le schéma par défaut utilisé pour l''exploration des données, la création d''application et l''exécution de script SQL. Lors de l''utilisation d''espaces de travail où plusieurs schémas sont disponibles, le schéma indiqué ici est le schéma par défaut pour la création d''applications, l''exécution d''interrogations SQL, etc. Cette fonctionnalité ne contrôle pas la sécurité, seulement la préférence';

h:=h||' de l''utilisateur.';

wwv_flow_api.create_page_item(
  p_id=>66067229562721999.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_DEFAULT_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 4597004638216477.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schéma par défaut',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'select htf.escape_sc(schema) d, schema r'||chr(10)||
''||chr(10)||
'from   wwv_flow_company_schemas'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id'||chr(10)||
''||chr(10)||
'order by 1',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 30,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez si l''utilisateur doit disposer de privilèges de développeur. Les développeurs peuvent créer et modifier des applications et des objets de base de données.';

wwv_flow_api.create_page_item(
  p_id=>157872609565288125.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'P52_DEVELOPER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 4597004638216477.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'L''utilisateur est un développeur :',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157815226475866526 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 2,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onClick="javascript:if (document.forms[0].P52_ADMIN_0.checked) document.forms[0].P52_DEVELOPER_0.checked = true;"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez si l''utilisateur doit disposer de privilèges d''administrateur d''espace de travail. Comme les développeurs, les administrateurs d''espace de travail peuvent créer et modifier des applications et des objets de base de données. En outre, ils peuvent gérer des comptes utilisateurs, des groupes et des services de développement.';

wwv_flow_api.create_page_item(
  p_id=>157873517877290564.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'P52_ADMIN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 4597004638216477.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'L''utilisateur est un administrateur d''espace de travail :',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157815226475866526 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 2,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onClick="javascript:if (document.forms[0].P52_ADMIN_0.checked) document.forms[0].P52_DEVELOPER_0.checked = true;"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Entrez de nouveau le mot de passe.';

wwv_flow_api.create_page_item(
  p_id=>240206601092761513.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 52.4352,
  p_name=>'F4350_P52_PASSWD_CONFIRM',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 21,
  p_item_plug_id => 63567744865578431.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Confirmer le mot de passe',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535006471295136.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 63976551899006266.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_validation_name => 'F4350_P52_USER_NAME Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4350_P52_USER_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Le nom utilisateur doit être indiqué.',
  p_validation_condition=> 'SUBMIT,CREATE_ANOTHER',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 63568348763578436.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 10-JUN-2001 19:34');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 63976943003006267.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_validation_name => 'F4350_P52_EMAIL_ADDRESS Not Null',
  p_validation_sequence=> 3,
  p_validation => 'F4350_P52_EMAIL_ADDRESS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'L''adresse électronique doit être indiquée.',
  p_validation_condition=> 'SUBMIT,CREATE_ANOTHER',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 63569221717578439.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 10-JUN-2001 19:34');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 88216016849515325.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_validation_name => 'UserNameValid',
  p_validation_sequence=> 4,
  p_validation => 'F4350_P52_USER_NAME',
  p_validation2 => '< >',
  p_validation_type => 'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2',
  p_error_message => 'Nom utilisateur non valide.',
  p_validation_condition=> 'SUBMIT,CREATE_ANOTHER',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 63568348763578436.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 69047703326983643.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_validation_name => 'user doesn''t already exist',
  p_validation_sequence=> 10,
  p_validation => 'select null'||chr(10)||
'  from wwv_flow_fnd_user'||chr(10)||
' where user_name = upper(:F4350_P52_USER_NAME)'||chr(10)||
'   and security_group_id = (select wwv_flow.get_sgid from dual where rownum = 1)',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => 'L''utilisateur &F4350_P52_USER_NAME. existe déjà.',
  p_validation_condition=> 'SUBMIT,CREATE_ANOTHER',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 63568348763578436.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 240211930659779511.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_validation_name => 'Validate Password',
  p_validation_sequence=> 20,
  p_validation => ':F4350_P52_PASSWD_CONFIRM = :F4350_P52_WEB_PASSWORD',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Les mots de passe ne concordent pas  ',
  p_validation_condition=> 'SUBMIT,CREATE_ANOTHER',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> .4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 109107321494746966.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_validation_name => 'default schema in accessible schemas',
  p_validation_sequence=> 30,
  p_validation => 'instr(upper(''&F4350_P52_ALLOW_ACCESS_TO_SCHEMAS.''),:F4350_P52_DEFAULT_SCHEMA) > 0',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Le schéma par défaut doit figurer dans les schémas accessibles.',
  p_validation_condition=> ':REQUEST in (''SUBMIT'',''CREATE_ANOTHER'') and '||chr(10)||
'v(''F4350_P52_ALLOW_ACCESS_TO_SCHEMAS'') is not null',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 66067229562721999.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 25671017599539184.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_validation_name => 'strong password verification',
  p_validation_sequence=> 82,
  p_validation => 'return wwv_flow_security.strong_password_validation('||chr(10)||
'      p_username       => :F4350_P52_USER_NAME,'||chr(10)||
'      p_password       => :F4350_P52_WEB_PASSWORD,'||chr(10)||
'      p_old_password   => null,'||chr(10)||
'      p_workspace_name => wwv_flow_security.find_company_name(:WORKSPACE_ID));',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'Erreur',
  p_validation_condition=> 'SUBMIT,CREATE_ANOTHER',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> .4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_user_id number := wwv_flow_id.next_val;'||chr(10)||
'  l_p varchar2(256) := v(''F4350_P52_WEB_PASSWORD'');'||chr(10)||
'  l_change_password_on_first_use varchar2(1) := ''N'';'||chr(10)||
'begin'||chr(10)||
'if :P52_CHANGE_PWD_ON_FIRST_USE = ''Y'' then'||chr(10)||
'    l_change_password_on_first_use := ''Y'';'||chr(10)||
'end if;'||chr(10)||
'wwv_flow.update_cache_with_write(''F4350_P52_WEB_PASSWORD'',null);'||chr(10)||
'wwv_flow.update_cache_with_write(''F4350_P52_PASSWD_CONFIRM'',null);'||chr(10)||
'WWV_FLOW_FN';

p:=p||'D_USER_API.CREATE_FND_USER('||chr(10)||
'  P_USER_ID         => l_user_id,'||chr(10)||
'  P_USER_NAME       => :F4350_P52_USER_NAME,'||chr(10)||
'  P_FIRST_NAME      => :F4350_P52_FIRST_NAME,'||chr(10)||
'  P_LAST_NAME       => :F4350_P52_LAST_NAME,'||chr(10)||
'  P_DESCRIPTION     => :F4350_P52_DESCRIPTION,'||chr(10)||
'  P_EMAIL_ADDRESS   => :F4350_P52_EMAIL_ADDRESS,'||chr(10)||
'  P_WEB_PASSWORD    => l_p,'||chr(10)||
'  P_GROUP_IDS       => :F4350_P52_GROUP_IDS,'||chr(10)||
'  P_DEVELOPER_PRIVS => :F4350_P52';

p:=p||'_DEVELOPER_PRIVS,'||chr(10)||
'  P_DEFAULT_SCHEMA  => :F4350_P52_DEFAULT_SCHEMA,'||chr(10)||
'  P_ALLOW_ACCESS_TO_SCHEMAS => v(''F4350_P52_ALLOW_ACCESS_TO_SCHEMAS''),'||chr(10)||
'  P_ACCOUNT_EXPIRY  => trunc(sysdate),'||chr(10)||
'  P_ACCOUNT_LOCKED  => nvl(:P52_ACCOUNT_LOCKED,''N''),'||chr(10)||
'  p_failed_access_attempts =>   0, '||chr(10)||
'  p_change_password_on_first_use => l_change_password_on_first_use,'||chr(10)||
'  p_first_password_use_occurred => ''N'''||chr(10)||
'  );'||chr(10)||
'--'||chr(10)||
'-- Developer and A';

p:=p||'dmin roles'||chr(10)||
'--'||chr(10)||
'if :P52_ADMIN = ''N'' and :P52_DEVELOPER= ''N'' then'||chr(10)||
'  null;'||chr(10)||
'elsif :P52_ADMIN = ''Y'' then'||chr(10)||
'  wwv_flow_fnd_developer_api.edit_developer_role('||chr(10)||
'    p_id => 1,'||chr(10)||
'    p_user_id => l_user_id,'||chr(10)||
'    p_user_name => :F4350_P52_USER_NAME,'||chr(10)||
'    p_developer_roles => ''ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL'');'||chr(10)||
'else'||chr(10)||
'  wwv_flow_fnd_developer_api.edit_developer_role('||chr(10)||
'    p_id => 1,'||chr(10)||
'    p_user_id => l_us';

p:=p||'er_id,'||chr(10)||
'    p_user_name => :F4350_P52_USER_NAME,'||chr(10)||
'    p_developer_roles => ''CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL'');'||chr(10)||
'end if;'||chr(10)||
'end;'||chr(10)||
'commit;';

wwv_flow_api.create_page_process(
  p_id     => 63569943284578442.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Run Stored Procedure',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur : #SQLERRM#',
  p_process_when=>'SUBMIT,CREATE_ANOTHER',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> 'Utilisateur créé.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'Generated 24-MAY-2001 18:02:15');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F4350_P52_WEB_PASSWORD,F4350_P52_PASSWD_CONFIRM';

wwv_flow_api.create_page_process(
  p_id     => 359780407415827856.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 52.4352,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_ITEMS',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 52.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_53.43
prompt  ...PAGE 53.4352: Groupes d'utilisateurs
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_groups.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 53.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Groupes d''utilisateurs',
  p_step_title=> 'Groupes d''utilisateurs',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450104703534414+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161850',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>53.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2196105021938550.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 53.4352,
  p_plug_name=> 'button bar',
  p_region_name=>'',
  p_plug_template=> 106899209536430147.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4379928588309987.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 53.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  administration.users';

wwv_flow_api.create_page_plug (
  p_id=> 17737816309566834.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 53.4352,
  p_plug_name=> 'Gérer les groupes',
  p_region_name=>'',
  p_plug_template=> 30480828877306882.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 1940605361112440 + wwv_flow_api.g_id_offset,
  p_list_template_id=> 38499417503989888.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_footer=> '<p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_required_patch=> '-274880608012467905.4352' + wwv_flow_api.g_id_offset,
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'48204213397853092';

wwv_flow_api.create_page_plug (
  p_id=> 48225300200896559.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 53.4352,
  p_plug_name=> 'Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> .5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 48204213397853092 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select ID,'||chr(10)||
'       GROUP_NAME, '||chr(10)||
'       GROUP_DESC des'||chr(10)||
'from   WWV_FLOW_FND_USER_GROUPS'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'(:P53_GROUP is null or instr(upper(group_name),upper(:P53_GROUP))> 0)';

wwv_flow_api.create_report_region (
  p_id=> 63110845083808836.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 53.4352,
  p_name=> 'Groups',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_display_when_condition=> 'P53_VIEW',
  p_display_when_cond2=> 'DETAIL',
  p_display_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6659715068668103.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '-',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucun groupe d''utilisateurs n''existe.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width=&quot;13&quot; height=&quot;12&quot;',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'Region generated 17-MAY-2001 00:33:59');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 205716732028433952.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 63110845083808836.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 3,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48575417653770984.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 63110845083808836.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'GROUP_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom de groupe',
  p_column_link=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:54:F4350_P54_ID,LAST_VIEW:#ID#,53',
  p_column_linktext=>'#GROUP_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48575512990770984.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 63110845083808836.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'DES',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Description',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Les groupes d''utilisateurs vous permettent de limiter l''accès à différentes parties d''une application. Ils ne sont pas portables dans les différents modèles d''authentification et servent surtout lorsque l''authentification à l''aide d''informations d''identification et de connexion de compte de &PRODUCT_NAME. est utilisée.'||chr(10)||
'<p />Pour modifier un groupe d''utilisateurs existant, sélectionnez-le. Pour cré';

s:=s||'er un groupe, cliquez sur <b>Créer</b>.';

wwv_flow_api.create_page_plug (
  p_id=> 63111618781819469.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 53.4352,
  p_plug_name=> 'Groupes d''utilisateurs',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1939532588110833.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'''menu/users_64.gif'' img,'||chr(10)||
'null alt,'||chr(10)||
'''f?p=4350:54:''||:flow_session||''::NO::F4350_P54_ID,LAST_VIEW:''||ID||'',53'' link,'||chr(10)||
'GROUP_NAME'||chr(10)||
'from   WWV_FLOW_FND_USER_GROUPS'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'(:P53_GROUP is null or instr(upper(group_name),upper(:P53_GROUP))>0)';

wwv_flow_api.create_report_region (
  p_id=> 136253013192769175.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 53.4352,
  p_name=> 'Groups (Icon View)',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_display_when_condition=> 'nvl(:P53_VIEW,''ICON'') = ''ICON''',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 135116627879700031.4352+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '-',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucun groupe d''utilisateurs n''existe.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'Region generated 17-MAY-2001 00:33:59');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 136255119556780419.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 136253013192769175.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'IMG',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Img',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 136255220972780420.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 136253013192769175.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ALT',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Alt',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 136255330853780420.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 136253013192769175.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Lien',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 136253317008769178.4352 + wwv_flow_api.g_id_offset,
  p_region_id=> 136253013192769175.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'GROUP_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 2194729132936059.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 53.4352,
  p_button_sequence=> 10,
  p_button_plug_id => 2196105021938550+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_image_alt=> 'Créer &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>51105802473026585.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 53.4352,
  p_branch_action=> 'f?p=&FLOW_ID.:54:&SESSION.::&DEBUG.:54::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>2194729132936059.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 28-MAY-2003 15:30 by JASON');
 
wwv_flow_api.create_page_branch(
  p_id=>136263600341812777.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 53.4352,
  p_branch_action=> 'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 15-MAR-2005 13:41 by MIKE');
 
wwv_flow_api.create_page_branch(
  p_id=>2211021737007290.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 53.4352,
  p_branch_action=> '23',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>2210713903007289.4352+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez un format de page et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>136256632023784033.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 53.4352,
  p_name=>'P53_VIEW',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 2196105021938550.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'ICON',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Vue',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'ICON OR DETAIL',
  p_lov => '.'||to_char(135219829572410772 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez une condition de recherche de nom de groupe d''utilisateurs.';

wwv_flow_api.create_page_item(
  p_id=>136259501249803557.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 53.4352,
  p_name=>'P53_GROUP',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 2196105021938550.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Groupe',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 355525708739902293.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>136261311638806563.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 53.4352,
  p_name=>'P53_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 2196105021938550.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 63110747673808833.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 53.4352,
  p_computation_sequence => 1,
  p_computation_item=> 'F4350_P101_ID',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '',
  p_computation_comment=> 'Set the value of the item conainting the primary key to null when asked to create a new row.',
  p_compute_when => 'CREATE_ROW',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 2411429028503676.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 53.4352,
  p_computation_sequence => 10,
  p_computation_item=> 'LAST_VIEW',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '53',
  p_compute_when => 'CREATE',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 136262218910808679.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 53.4352,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>136261311638806563.4352 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 53.4352
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_54.43
prompt  ...PAGE 54.4352: Créer/modifier un groupe d'utilisateurs
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/aadm_groups.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 54.4352,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Créer/modifier un groupe d''utilisateurs',
  p_step_title=> 'Créer/modifier un groupe d''utilisateurs',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215450104703534414+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 6322904659084760.4352+ wwv_flow_api.g_id_offset,
  p_required_role=>'FLOW: ADMIN',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161851',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>54.4352,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4374909410294976.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 54.4352,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4090422833267509 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4094616517288262.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 63108043743808817.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 54.4352,
  p_plug_name=> 'Groupes d''utilisateurs (pour authentification auprès du référentiel de comptes utilisateur &PRODUCT_NAME. uniquement)',
  p_region_name=>'',
  p_plug_template=> 47252630300569314.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'generated 17-MAY-2001 00:33:59');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Vous pouvez créer des groupes d''utilisateurs pour restreindre l''accès à diverses parties d''une application. Les groupes d''utilisateurs ne sont toutefois pas portables entre les différents modèles d''authentification. Ils sont principalement utiles lorsque vous faites appel à l''authentification d''utilisateur de cookie interne.</p>'||chr(10)||
'<p>Pour créer un groupe d''utilisateurs, indiquez le nom du groupe ';

s:=s||'et donnez-en une description (facultatif).</p>';

wwv_flow_api.create_page_plug (
  p_id=> 63112545982838982.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 54.4352,
  p_plug_name=> 'Groupes d''utilisateurs',
  p_region_name=>'',
  p_plug_template=> 79598426990781464.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1939532588110833.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 187692154521667589.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 54.4352,
  p_plug_name=> 'User Groups',
  p_region_name=>'',
  p_plug_template=> 185388915190864903.4352+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1939532588110833.4352+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 63108356545808819.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 54.4352,
  p_button_sequence=> 1,
  p_button_plug_id => 187692154521667589+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:53:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 63108545013808820.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 54.4352,
  p_button_sequence=> 2,
  p_button_plug_id => 187692154521667589+wwv_flow_api.g_id_offset,
  p_button_name    => 'Delete',
  p_button_image_alt=> 'Supprimer',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(''&DELETE_MSG.'',''DELETE'');',
  p_button_condition=> 'F4350_P54_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'DELETE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 63108764367808820.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 54.4352,
  p_button_sequence=> 3,
  p_button_plug_id => 187692154521667589+wwv_flow_api.g_id_offset,
  p_button_name    => 'Apply_Changes',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'F4350_P54_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 63108953870808821.4352 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 54.4352,
  p_button_sequence=> 4,
  p_button_plug_id => 187692154521667589+wwv_flow_api.g_id_offset,
  p_button_name    => 'Create',
  p_button_image_alt=> 'Créer un groupe',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'F4350_P54_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>63107751601808817.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 54.4352,
  p_branch_action=> '53',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2206427709982874.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 54.4352,
  p_name=>'P54_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 63108043743808817.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>63109151798808823.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 54.4352,
  p_name=>'F4350_P54_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 63108043743808817.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ID',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez le nom du groupe à créer';

wwv_flow_api.create_page_item(
  p_id=>63109395349808825.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 54.4352,
  p_name=>'F4350_P54_GROUP_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 63108043743808817.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de groupe',
  p_source=>'GROUP_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535006471295136.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez la description du groupe à créer.';

wwv_flow_api.create_page_item(
  p_id=>63109742671808826.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 54.4352,
  p_name=>'F4350_P54_GROUP_DESC',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 63108043743808817.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Description',
  p_source=>'GROUP_DESC',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXTAREA_CHAR_COUNT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 4000,
  p_cHeight=> 4,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 3,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 107534131274292840.4352+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>168786622708605094.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 54.4352,
  p_name=>'P54_ORIG_GROUP_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 63108043743808817.4352+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 168796825263615287.4352 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 54.4352,
  p_computation_sequence => 10,
  p_computation_item=> 'P54_ORIG_GROUP_NAME',
  p_computation_point=> 'AFTER_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select group_name from wwv_flow_fnd_user_groups'||chr(10)||
' where id = :F4350_P54_ID',
  p_compute_when => 'F4350_P54_ID',
  p_compute_when_type=>'ITEM_IS_NOT_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 2208604422995132.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 54.4352,
  p_validation_name => 'group name not null',
  p_validation_sequence=> 10,
  p_validation => 'F4350_P54_GROUP_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Le nom de groupe doit être indiqué.',
  p_associated_item=> 63109395349808825.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 68844119894184093.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 54.4352,
  p_validation_name => 'group doesn''t already exist',
  p_validation_sequence=> 20,
  p_validation => 'select null'||chr(10)||
'  from wwv_flow_fnd_user_groups'||chr(10)||
' where group_name = :F4350_P54_GROUP_NAME'||chr(10)||
'   and security_group_id = :FLOW_SECURITY_GROUP_ID',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => 'Le groupe &F4350_P54_GROUP_NAME. existe déjà.',
  p_validation_condition=> ':REQUEST in (''Apply_Changes'',''Create'') and nvl(:P54_ORIG_GROUP_NAME,''-1x0'') != :F4350_P54_GROUP_NAME',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 63109395349808825.4352 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 111523726314084632.4352 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 54.4352,
  p_validation_name => 'Valid Group Name',
  p_validation_sequence=> 30,
  p_validation => 'F4350_P54_GROUP_NAME',
  p_validation2 => '<>',
  p_validation_ty