set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4402 - APEX -  Application Migration
--
-- Application Export:
--   Application:     4402
--   Name:            APEX -  Application Migration
--   Date and Time:   13:51 Thursday May 28, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.09
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:               137
--     Items:           1,546
--     Computations:      130
--     Validations:       102
--     Processes:         324
--     Regions:           683
--     Buttons:           219
--   Shared Components
--     Breadcrumbs:         1
--        Entries         129
--     Items:              23
--     Computations:        1
--     Processes:           4
--     Parent Tabs:         0
--     Tab Sets:            1
--        Tabs:             1
--     NavBars:             2
--     Lists:              82
--     Shortcuts:           2
--     Themes:              0
--     Templates:
--        Page:             6
--        List:            10
--        Report:           6
--        Label:            4
--        Region:          24
--     Messages:            0
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4402;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4402);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4402);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4402,
  p_display_id=> 4402,
  p_owner => 'APEX_030200',
  p_name  => 'APEX -  Application Migration',
  p_alias => 'A198398114123478785',
  p_page_view_logging => 'YES',
  p_default_page_template=> 12491335804135281.4402 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 12491335804135281.4402 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 145308009821552281.4402 + wwv_flow_api.g_id_offset,
  p_error_template    => 274979027921125346.4402 + wwv_flow_api.g_id_offset,
  p_checksum_salt_last_reset => '20090528134550',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=&APP_ID.:1:&SESSION.',
  p_flow_language     => 'fr',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => '',
  p_logout_url        => 'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_application_tab_set=> 1,
  p_logo_image => '#IMAGE_PREFIX#htmldb/apex_logo.gif',
  p_logo_image_attributes => 'width="300" height="30" alt="&PRODUCT_NAME."',
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(4992916103932440 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. ',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable at this time.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_csv_encoding    => 'Y',
  p_theme_id => 101,
  p_default_label_template => 8299228930814357.4402 + wwv_flow_api.g_id_offset,
  p_default_report_template => 16025715508464036.4402 + wwv_flow_api.g_id_offset,
  p_default_list_template => 25505514315218644.4402 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 11695812357642734.4402 + wwv_flow_api.g_id_offset,
  p_substitution_string_01 => 'ROWSRCTYPE',
  p_substitution_value_01  => 'Type de source de ligne',
  p_substitution_string_02 => 'PRODUCT_NAME',
  p_substitution_value_02  => 'Application Express',
  p_substitution_string_03 => 'MSG_COMPANY',
  p_substitution_value_03  => 'Espace de travail : &COMPANY.',
  p_substitution_string_04 => 'MSG_LANGUAGE',
  p_substitution_value_04  => 'Langue',
  p_substitution_string_05 => 'MSG_COPYRIGHT',
  p_substitution_value_05  => 'Copyright &copy; 1999, 2009, Oracle. Tous droits réservés.',
  p_substitution_string_06 => 'MSG_USER',
  p_substitution_value_06  => 'Utilisateur',
  p_substitution_string_07 => 'MSG_JSCRIPT',
  p_substitution_value_07  => 'JavaScript doit être activé lorsque vous exécutez ce produit.',
  p_substitution_string_08 => 'MSG_TBL_SUMMARY',
  p_substitution_value_08  => 'Table de mise en page',
  p_substitution_string_09 => 'DELETE_MSG',
  p_substitution_value_09  => 'Voulez-vous effectuer cette action de suppression ?',
  p_substitution_string_10 => 'TABLES',
  p_substitution_value_10  => 'Tables',
  p_substitution_string_11 => 'QUERIES',
  p_substitution_value_11  => 'Interrogations',
  p_substitution_string_12 => 'FORMS',
  p_substitution_value_12  => 'Panneaux',
  p_substitution_string_13 => 'TIME_FORMAT',
  p_substitution_value_13  => 'hh24:mi:ss',
  p_substitution_string_14 => 'MODULES',
  p_substitution_value_14  => 'Modules',
  p_substitution_string_15 => 'DATE_FORMAT',
  p_substitution_value_15  => 'dd/mm/rr',
  p_substitution_string_16 => 'DATE_TIME_FORMAT',
  p_substitution_value_16  => 'dd/mm/rr hh24:mi:ss',
  p_substitution_string_17 => 'CAPTION',
  p_substitution_value_17  => 'Légende',
  p_substitution_string_18 => 'EXPORTER',
  p_substitution_value_18  => 'Exporter for &MS_ACCESS.',
  p_substitution_string_19 => 'MS_ACCESS',
  p_substitution_value_19  => 'Microsoft Access',
  p_substitution_string_20 => 'ROWSOURCE',
  p_substitution_value_20  => 'Source de données',
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090528134451',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39893428601190517.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 10,
  p_icon_image     => '',
  p_icon_subtext   => 'Aide',
  p_icon_target    => 'javascript:popupURL(''wwv_flow_help.show_help?p_lang=&BROWSER_LANGUAGE.&p_session=&APP_SESSION.&p_flow_id=&APP_TRANSLATION_ID.&p_step_id=&APP_TRANSLATION_PAGE_ID.'');',
  p_icon_image_alt => 'Aide',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39956403114618440.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 20,
  p_icon_image     => '',
  p_icon_subtext   => 'Déconnexion',
  p_icon_target    => 'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_icon_image_alt => 'Déconnexion',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
 
end;
/

prompt  ...application processes
--
--application/shared_components/logic/application_processes/validate_sql
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'   l_status varchar2(32767);'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'       l_status := wwv_render_report3.is_valid_query('||chr(10)||
'           p_plug_source => :P42_HIDDEN_SQL,'||chr(10)||
'           p_plug_source_type => ''SQL_QUERY'', '||chr(10)||
'           p_owner => :P2_SCHEMA'||chr(10)||
'       );'||chr(10)||
'       htp.p(l_status);'||chr(10)||
''||chr(10)||
'exception'||chr(10)||
'   when others then'||chr(10)||
'      htp.p(sqlerrm);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 4688716774299999.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate_sql',
  p_process_sql_clob=> p,
  p_process_error_message=> '#SQLERRM#',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 04-SEP-2006 15:23:00');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/compile_sql_query
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'   l_status varchar2(32767);'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'       l_status := wwv_flow_sw_api.run_sql('||chr(10)||
'            p_sql_cmd => :P42_HIDDEN_SQL,'||chr(10)||
'            p_schema => :P2_SCHEMA,'||chr(10)||
'            p_print_msg => ''Y'');'||chr(10)||
''||chr(10)||
'       htp.p(l_status);'||chr(10)||
''||chr(10)||
'exception'||chr(10)||
'   when others then'||chr(10)||
'      htp.p(sqlerrm);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 5201502110119821.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'compile_sql_query',
  p_process_sql_clob=> p,
  p_process_error_message=> '#SQLERRM#',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 10-SEP-2006 15:20:00');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/compile_view
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'   l_status varchar2(32767);'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'   for c1 in ('||chr(10)||
'       select clob001 from htmldb_collections'||chr(10)||
'       where collection_name = ''PLSQL_OBJECT_SOURCE'''||chr(10)||
'   ) loop'||chr(10)||
'       l_status := wwv_flow_plsql_editor.compile('||chr(10)||
'           :OBJ_OWNER,'||chr(10)||
'           :P30_VIEW_NAME,'||chr(10)||
'           :OBJ_TYPE, '||chr(10)||
'           c1.clob001'||chr(10)||
'       );'||chr(10)||
'       htp.p(l_status);'||chr(10)||
'   end loop;'||chr(10)||
''||chr(10)||
'   htmldb_collection.truncate_collecti';

p:=p||'on('||chr(10)||
'      p_collection_name => ''PLSQL_OBJECT_SOURCE'' '||chr(10)||
'   );'||chr(10)||
''||chr(10)||
'exception'||chr(10)||
'   when others then'||chr(10)||
'      htp.p(sqlerrm);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 5221631313264694.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'compile_view',
  p_process_sql_clob=> p,
  p_process_error_message=> '#SQLERRM#',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 11-SEP-2006 15:20:00');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/alertprocess
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_counter number;'||chr(10)||
'  l_o_name  varchar2(2000);'||chr(10)||
'begin'||chr(10)||
'  htp.prn(''<body>'');'||chr(10)||
'  htp.prn(''<desc>This was just put into session in Application Item TEMPORARY_ITEM</dec>'');'||chr(10)||
'  htp.prn(''<payload id="test">''||v(''TEMPORARY_ITEM'')||''</payload>'');'||chr(10)||
'  htp.prn(''</body>'');'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 99262016635200707.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'alertprocess',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

prompt  ...application items
--
--application/shared_components/logic/application_items/company
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 5024124051039438.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'COMPANY',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4400_last_view
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 322235223353586898.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4400_LAST_VIEW',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fb_flow_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 11961301928828394.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FB_FLOW_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Identifies the flow');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fb_flow_page_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 11961713356831740.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FB_FLOW_PAGE_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Identifies the flow page');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 29191130394180095.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_AFTER_LOGIN_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used by Custom2 authentication for deep linking support');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fsp_process_state_6049310398066402
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 778553907302517468.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_PROCESS_STATE_6049310398066402',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used for stateful process management');
 
null;
 
end;
/

--application/shared_components/logic/application_items/gen_app_crumb
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 21625221246066641.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'GEN_APP_CRUMB',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/mw_application_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 271674205052460273.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MW_APPLICATION_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'P51_APPLICATION_ID for ''forms'''||chr(10)||
'P31_APPLICATION_ID for ''access''');
 
null;
 
end;
/

--application/shared_components/logic/application_items/mw_application_name
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 244089523810904023.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MW_APPLICATION_NAME',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/mw_mig_page
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 260880122352971242.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MW_MIG_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/mw_mig_type
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 259371106880664444.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MW_MIG_TYPE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'This would be used to distinguish between ''access'' and ''forms''');
 
null;
 
end;
/

--application/shared_components/logic/application_items/mw_model_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 271674030894458277.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MW_MODEL_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'P51_MODEL_ID for ''forms'''||chr(10)||
'P31_MODEL_ID for ''access''');
 
null;
 
end;
/

--application/shared_components/logic/application_items/mw_proj_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 5155418520481129.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MW_PROJ_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/mw_proj_name
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 260863722586413096.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MW_PROJ_NAME',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/mw_schema
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 272369618450899026.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MW_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/obj_name
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 2065732367350698.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OBJ_NAME',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/obj_owner
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 2066611374354151.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OBJ_OWNER',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/obj_type
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 2066103409351846.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OBJ_TYPE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/rep_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 2813630577422955.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'REP_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/rep_name
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 2813227461422010.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'REP_NAME',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/theme_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 21496400301698024.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'THEME_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/theme_next_page
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 21496803764699067.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'THEME_NEXT_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/view_name
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 3482631657882456.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'VIEW_NAME',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
--application/shared_components/logic/application_computations/company
wwv_flow_api.create_flow_computation (
  p_id => 5025409637044763.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'COMPANY',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'wwv_flow.get_company_name;',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'Impossible de calculer le nom de l''espace de travail.',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/standard/t_page_nbsp_1
wwv_flow_api.create_tab (
  p_id=> 4994327640932458.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_tab_sequence=> 10,
  p_tab_name=> 'T_PAGE&NBSP;1',
  p_tab_text => 'Page&nbsp;1',
  p_tab_step => 1,
  p_tab_also_current_for_pages => '28,36,111,117,131,132,133,134,135,136,139,140,72',
  p_tab_parent_tabset=>'',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment  => '');
 
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/0_1_returns_y_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2268411818705410.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => '0.1.RETURNS.Y.N',
  p_lov_query=> '.'||to_char(2268411818705410 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2268719044705422.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2268411818705410.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Oui',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2268911320705423.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2268411818705410.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/alignment_l_c_r
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6767129339658379.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ALIGNMENT_L_C_R',
  p_lov_query=> '.'||to_char(6767129339658379 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6767402068658388.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6767129339658379.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'à gauche',
  p_lov_return_value=>'LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6767619777658388.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6767129339658379.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'au centre',
  p_lov_return_value=>'CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6767809516658388.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6767129339658379.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'à droite',
  p_lov_return_value=>'RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_wizard_page_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6745605530658343.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP WIZARD PAGE TYPE',
  p_lov_query=> '.'||to_char(6745605530658343 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6745905457658343.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6745605530658343.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Page vierge',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6746129152658343.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6745605530658343.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Page d''état',
  p_lov_return_value=>'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6746324613658344.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6745605530658343.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Etat avec un panneau de modification sur une seconde page',
  p_lov_return_value=>'REPORTANDFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6746526869658344.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6745605530658343.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Panneau tabulaire',
  p_lov_return_value=>'TABULARFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6746711076658347.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6745605530658343.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Panneau avec fonctionnalité d''insertion, de mise à jour et de suppression',
  p_lov_return_value=>'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/assignees
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 314823628966435555.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ASSIGNEES',
  p_lov_query=> 'select Initcap(userid) d, userid r'||chr(10)||
'from   wwv_flow_developers'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/block_types_all_or_db
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 71114111955709573.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BLOCK TYPES (ALL OR DB)',
  p_lov_query=> '.'||to_char(71114111955709573 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>71114307930709575.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>71114111955709573.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tous les blocs',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>71114505124709576.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>71114111955709573.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Blocs de base de données',
  p_lov_return_value=>'DB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>71115227886714191.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>71114111955709573.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Autres blocs',
  p_lov_return_value=>'NON_DB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/block_attributes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 268418531368435734.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BLOCK_ATTRIBUTES',
  p_lov_query=> '.'||to_char(268418531368435734 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>268418811730435734.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>268418531368435734.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Eléments',
  p_lov_return_value=>'ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>268419021098435735.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>268418531368435734.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Déclencheurs de bloc',
  p_lov_return_value=>'BLOCK_TRIGGERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>268419208223435735.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>268418531368435734.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Déclencheurs d''élément',
  p_lov_return_value=>'ITEM_TRIGGERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/complete_applicable
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 69212632381189500.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COMPLETE APPLICABLE',
  p_lov_query=> '.'||to_char(69212632381189500 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>69212804159189502.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>69212632381189500.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Terminé',
  p_lov_return_value=>'COMPLETE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>69213030923189504.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>69212632381189500.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Applicable',
  p_lov_return_value=>'APPLICABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/confirm_action_checkbox_returns_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 71131114642729280.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONFIRM ACTION (CHECKBOX RETURNS Y)',
  p_lov_query=> '.'||to_char(71131114642729280 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>71131330981729281.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>71131114642729280.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Confirmer l''action',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/control_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONTROL_TYPE',
  p_lov_query=> '.'||to_char(2256220196537491 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8618000672306903.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'-Tout-',
  p_lov_return_value=>'-All-',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2256710033537514.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Champ de texte',
  p_lov_return_value=>'109',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2260803975636949.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Cadre d''objet lié',
  p_lov_return_value=>'108',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2261108131638181.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Case à cocher',
  p_lov_return_value=>'106',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2261414711640023.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Liste modifiable',
  p_lov_return_value=>'111',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2261718520641190.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Bouton',
  p_lov_return_value=>'104',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2262023022642469.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Contrôle personnalisé',
  p_lov_return_value=>'107',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2262326831643559.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Image',
  p_lov_return_value=>'103',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2262600297645319.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Séparateur de ligne',
  p_lov_return_value=>'102',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2262906877647260.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Zone de liste déroulante',
  p_lov_return_value=>'110',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2263200082654770.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Cadre d''objet',
  p_lov_return_value=>'114',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2263505622656371.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Bouton d''option',
  p_lov_return_value=>'105',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2263811163657942.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Groupe d''options',
  p_lov_return_value=>'107',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2264115665659200.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>14,
  p_lov_disp_value=>'Page ',
  p_lov_return_value=>'124',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2264420514660665.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Saut de page',
  p_lov_return_value=>'118',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2264724323661768.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'Rectangle',
  p_lov_return_value=>'101',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2265028479662955.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>17,
  p_lov_disp_value=>'Sous-panneau',
  p_lov_return_value=>'112',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2265302290664876.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>18,
  p_lov_disp_value=>'Contrôle d''onglet',
  p_lov_return_value=>'123',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2265611641667583.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>19,
  p_lov_disp_value=>'Bouton à bascule',
  p_lov_return_value=>'122',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2256520690537508.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Libellé',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>29444330609608767.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2256220196537491.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>21,
  p_lov_disp_value=>'Contrôle ActiveX',
  p_lov_return_value=>'119',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_application_page_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 22139623686037120.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE APPLICATION PAGE TYPE',
  p_lov_query=> '.'||to_char(22139623686037120 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22139901817037130.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22139623686037120.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Ajouter une page vierge à l''application',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22140103908037134.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22139623686037120.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Ajouter un état',
  p_lov_return_value=>'REPORT',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22140731738037136.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22139623686037120.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Ajouter un panneau avec fonctionnalité d''insertion, de mise à jour et de suppression',
  p_lov_return_value=>'FORM',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22140530052037136.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22139623686037120.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Ajouter un panneau tabulaire',
  p_lov_return_value=>'TABULARFORM',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>280920212112967858.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22139623686037120.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Ajouter un panneau maître-détail',
  p_lov_return_value=>'MASTERDETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22140326341037134.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22139623686037120.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Ajouter un état avec un panneau de modification sur une seconde page',
  p_lov_return_value=>'REPORTANDFORM',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_index_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 779055021223322673.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE INDEX TYPES',
  p_reference_id=> 16028009107759017,
  p_lov_query=> '.'||to_char(779055021223322673 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>779055926644322686.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>779055021223322673.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Normal',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>779056103800322686.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>779055021223322673.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Texte',
  p_lov_return_value=>'T',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_app_auth_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19566418654904504.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.APP.AUTH.OPTIONS',
  p_lov_query=> 'select d, v from ('||chr(10)||
'select '||chr(10)||
'  :product_name||''<br />''||'||chr(10)||
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/admin_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d ,''HTML DB'' v from dual'||chr(10)||
'union all'||chr(10)||
'select '||chr(10)||
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'')||''<br />''||'||chr(10)||
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/opendoor_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DATABASE'' v from dual'||chr(10)||
'union all'||chr(10)||
'select '||chr(10)||
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'')||''<br />''||'||chr(10)||
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/dbauth_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DBACCOUNT'' v from dual'||chr(10)||
')');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_app_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 278595623975456113.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE_APP_OPTIONS',
  p_lov_query=> '.'||to_char(278595623975456113 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>278595906950456118.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>278595623975456113.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A partir d''un projet de migration',
  p_lov_return_value=>'PROJECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>278596129859456119.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>278595623975456113.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'A partir d''un modèle de conception d''application existant',
  p_lov_return_value=>'MODEL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/copy_of_analyze_opts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6559316394304960.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'Copy of ANALYZE.OPTS',
  p_lov_query=> '.'||to_char(6559316394304960 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6559609247304983.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6559316394304960.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Calculer les statistiques',
  p_lov_return_value=>'COMPUTE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6559807151304993.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6559316394304960.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Estimer les statistiques',
  p_lov_return_value=>'ESTIMATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6560024790304993.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6559316394304960.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Valider la structure',
  p_lov_return_value=>'VALIDATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/copy_of_icon_detail_view_modes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 241290016427713003.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'Copy of ICON DETAIL VIEW MODES',
  p_reference_id=> 144167830179232748,
  p_lov_query=> '.'||to_char(241290016427713003 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>241290918526713047.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>241290016427713003.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Icônes',
  p_lov_return_value=>'ICON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>241291116048713048.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>241290016427713003.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Détails',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/form_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23186314994289784.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORM TYPES',
  p_lov_query=> '.'||to_char(23186314994289784 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23186609421289796.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>23186314994289784.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Panneau',
  p_lov_return_value=>'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23186832278289798.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>23186314994289784.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Panneau tabulaire',
  p_lov_return_value=>'TABULARFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23751426549888921.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>23186314994289784.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Etat et panneau',
  p_lov_return_value=>'REPORTANDFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/format_mask_dynamic
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6766305855658377.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMAT_MASK_DYNAMIC',
  p_lov_query=> 'select d, r '||chr(10)||
'  from wwv_flow_format_masks');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/format_mask_dynamic_dates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 268441300013663276.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMAT_MASK_DYNAMIC_DATES',
  p_lov_query=> 'select d, r '||chr(10)||
'  from wwv_flow_format_masks'||chr(10)||
' where t = ''D''');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/forms_components
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMS_COMPONENTS',
  p_lov_query=> '.'||to_char(331159827266175078 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331160122134175092.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Alertes',
  p_lov_return_value=>'ALERTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113499816654228536.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Bibliothèque attachée',
  p_lov_return_value=>'ATTACHEDLIBRARY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331160328106175093.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Blocs',
  p_lov_return_value=>'BLOCKS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331160510369175093.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Canevas',
  p_lov_return_value=>'CANVAS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331160729137175094.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Coordonnées',
  p_lov_return_value=>'COORDINATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331160905420175094.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Editeur',
  p_lov_return_value=>'EDITOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331161120382175094.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Listes de valeurs (LOV)',
  p_lov_return_value=>'LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331161317587175094.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Unités de programme',
  p_lov_return_value=>'PROGRAMUNIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331161500603175094.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Classe de propriété',
  p_lov_return_value=>'PROPERTYCLASS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331161924782175099.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Déclencheurs au niveau panneau',
  p_lov_return_value=>'FORM_TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331162130759175099.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Déclencheurs au niveau bloc',
  p_lov_return_value=>'BLOCK_TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113500431891232878.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Etat',
  p_lov_return_value=>'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331162319111175099.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Déclencheurs au niveau élément',
  p_lov_return_value=>'ITEM_TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331162531912175099.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>14,
  p_lov_disp_value=>'Fenêtres',
  p_lov_return_value=>'WINDOWS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331162703578175099.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Attributs visuels',
  p_lov_return_value=>'VISUALATTRIBUTES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113500020463229557.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'Paramètre de module',
  p_lov_return_value=>'MODULEPARAMETER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113500223926230617.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>17,
  p_lov_disp_value=>'Groupe d''objets',
  p_lov_return_value=>'OBJECTGROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113500602240233782.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>18,
  p_lov_disp_value=>'Menu',
  p_lov_return_value=>'MENU',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>331161728166175099.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>331159827266175078.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>19,
  p_lov_disp_value=>'Groupes d''enregistrements',
  p_lov_return_value=>'RECORDGROUPS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/home_page_navigation
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 22899924972899541.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'HOME PAGE NAVIGATION',
  p_lov_query=> '.'||to_char(22899924972899541 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22900214896899554.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22899924972899541.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste non ordonnée verticale avec puces',
  p_lov_return_value=>'Vertical Unordered List with Bullets',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#migration/mig_menu3.png" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22900432663899556.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22899924972899541.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Liste d''images verticale',
  p_lov_return_value=>'Vertical Images List',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#migration/mig_menu2.png" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22900605440899556.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22899924972899541.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Liste d''images horizontale',
  p_lov_return_value=>'Horizontal Images with Label List',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#migration/mig_menu1.png" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_languages_locales
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_LANGUAGES_LOCALES',
  p_lov_query=> '.'||to_char(19539723892904486 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19540011893904492.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Afrikaans (af)',
  p_lov_return_value=>'af',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19540226296904492.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Arabe (ar)',
  p_lov_return_value=>'ar',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19540431465904492.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Arabe (Algérie) (ar-dz)',
  p_lov_return_value=>'ar-dz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19540624106904492.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Arabe (Bahreïn) (ar-bh)',
  p_lov_return_value=>'ar-bh',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19540804432904492.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Arabe (Egypte) (ar-eg)',
  p_lov_return_value=>'ar-eg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19541028698904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Arabe (Iraq) (ar-iq)',
  p_lov_return_value=>'ar-iq',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19541206480904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Arabe (Jordanie) (ar-jo)',
  p_lov_return_value=>'ar-jo',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19541401472904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Arabe (Koweït) (ar-kw)',
  p_lov_return_value=>'ar-kw',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19541609976904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Arabe (Liban) (ar-lb)',
  p_lov_return_value=>'ar-lb',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19541821034904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Arabe (Libye) (ar-ly)',
  p_lov_return_value=>'ar-ly',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19542024113904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'Arabe (Maroc) (ar-ma)',
  p_lov_return_value=>'ar-ma',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19542212401904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'Arabe (Oman) (ar-om)',
  p_lov_return_value=>'ar-om',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19542410451904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'Arabe (Qatar) (ar-qa)',
  p_lov_return_value=>'ar-qa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19542623788904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'Arabe (Arabie Saoudite) (ar-sa)',
  p_lov_return_value=>'ar-sa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19542822816904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'Arabe (Syrie) (ar-sy)',
  p_lov_return_value=>'ar-sy',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19543011381904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'Arabe (Tunisie) (ar-tn)',
  p_lov_return_value=>'ar-tn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19543219603904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'Arabe (E.A.U.) (ar-ae)',
  p_lov_return_value=>'ar-ae',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19543429723904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'Arabe (Yémen) (ar-ye)',
  p_lov_return_value=>'ar-ye',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19543619273904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'Assamais (as)',
  p_lov_return_value=>'as',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19543810461904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'Basque (eu)',
  p_lov_return_value=>'eu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19544001638904493.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'Bélarussien (be)',
  p_lov_return_value=>'be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19544210815904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'Bengali (bn)',
  p_lov_return_value=>'bn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19544419526904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'Bulgare (bg)',
  p_lov_return_value=>'bg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19544631698904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'Catalan (ca)',
  p_lov_return_value=>'ca',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19544823392904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'Chinois (zh)',
  p_lov_return_value=>'zh',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19545014605904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'Chinois (Chine) (zh-cn)',
  p_lov_return_value=>'zh-cn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19545215648904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'Chinois (Hong Kong SAR) (zh-hk)',
  p_lov_return_value=>'zh-hk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19545407178904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>280,
  p_lov_disp_value=>'Chinois (Macao SAR) (zh-mo)',
  p_lov_return_value=>'zh-mo',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19545620517904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>290,
  p_lov_disp_value=>'Chinois (Singapour) (zh-sg)',
  p_lov_return_value=>'zh-sg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19545821247904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>300,
  p_lov_disp_value=>'Chinois (Taiwan) (zh-tw)',
  p_lov_return_value=>'zh-tw',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19546013731904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>310,
  p_lov_disp_value=>'Croate (hr)',
  p_lov_return_value=>'hr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19546227019904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>320,
  p_lov_disp_value=>'Tchèque (cs)',
  p_lov_return_value=>'cs',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19546416347904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>330,
  p_lov_disp_value=>'Danois (da)',
  p_lov_return_value=>'da',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19546602612904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>340,
  p_lov_disp_value=>'Néerlandais (Belgique) (nl-be)',
  p_lov_return_value=>'nl-be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19546822503904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>350,
  p_lov_disp_value=>'Néerlandais (Pays-Bas) (nl)',
  p_lov_return_value=>'nl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19547008612904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>360,
  p_lov_disp_value=>'Anglais (en)',
  p_lov_return_value=>'en',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19547210063904494.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>370,
  p_lov_disp_value=>'Anglais (Australie) (en-au)',
  p_lov_return_value=>'en-au',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19547418570904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>380,
  p_lov_disp_value=>'Anglais (Belize) (en-bz)',
  p_lov_return_value=>'en-bz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19547613852904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>390,
  p_lov_disp_value=>'Anglais (Canada) (en-ca)',
  p_lov_return_value=>'en-ca',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19547806697904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>400,
  p_lov_disp_value=>'Anglais (Irlande) (en-ie)',
  p_lov_return_value=>'en-ie',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19548012390904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>410,
  p_lov_disp_value=>'Anglais (Jamaïque) (en-jm)',
  p_lov_return_value=>'en-jm',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19548205369904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>420,
  p_lov_disp_value=>'Anglais (Nouvelle-Zélande) (en-nz)',
  p_lov_return_value=>'en-nz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19548413973904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>430,
  p_lov_disp_value=>'Anglais (Philippines) (en-ph)',
  p_lov_return_value=>'en-ph',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19548608174904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>440,
  p_lov_disp_value=>'Anglais (Afrique du Sud) (en-za)',
  p_lov_return_value=>'en-za',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19548802503904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>450,
  p_lov_disp_value=>'Anglais (Trinité) (en-tt)',
  p_lov_return_value=>'en-tt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19549008755904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>460,
  p_lov_disp_value=>'Anglais (Royaume-Uni) (en-gb)',
  p_lov_return_value=>'en-gb',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19549208728904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>470,
  p_lov_disp_value=>'Anglais (Etats-Unis) (en-us)',
  p_lov_return_value=>'en-us',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19549405254904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>480,
  p_lov_disp_value=>'Anglais (Zimbabwe) (en-zw)',
  p_lov_return_value=>'en-zw',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19549622214904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>490,
  p_lov_disp_value=>'Estonien (et)',
  p_lov_return_value=>'et',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19549825210904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>500,
  p_lov_disp_value=>'FYRO Macédonien (mk)',
  p_lov_return_value=>'mk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19550018532904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>510,
  p_lov_disp_value=>'Faeroese (fo)',
  p_lov_return_value=>'fo',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19550210045904495.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>520,
  p_lov_disp_value=>'Farsi (fa)',
  p_lov_return_value=>'fa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19550417300904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>530,
  p_lov_disp_value=>'Français (Suisse) (fr-ch)',
  p_lov_return_value=>'fr-ch',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19550607361904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>540,
  p_lov_disp_value=>'Finnois (fi)',
  p_lov_return_value=>'fi',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19550826372904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>550,
  p_lov_disp_value=>'Français (Belgique) (fr-be)',
  p_lov_return_value=>'fr-be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19551017747904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>560,
  p_lov_disp_value=>'Français (Canada) (fr-ca)',
  p_lov_return_value=>'fr-ca',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19551202469904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>570,
  p_lov_disp_value=>'Français (France) (fr)',
  p_lov_return_value=>'fr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19551416134904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>580,
  p_lov_disp_value=>'Français (Luxembourg) (fr-lu)',
  p_lov_return_value=>'fr-lu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19551615955904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>590,
  p_lov_disp_value=>'Français (Monaco) (fr-mc)',
  p_lov_return_value=>'fr-mc',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19551807547904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>600,
  p_lov_disp_value=>'Gaélique (gd)',
  p_lov_return_value=>'gd',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19552028770904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>610,
  p_lov_disp_value=>'Galicien (gl)',
  p_lov_return_value=>'gl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19552227119904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>620,
  p_lov_disp_value=>'Allemand (Autriche) (de-at)',
  p_lov_return_value=>'de-at',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19552400208904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>630,
  p_lov_disp_value=>'Allemand (Allemagne) (de)',
  p_lov_return_value=>'de',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19552621140904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>640,
  p_lov_disp_value=>'Allemand (Liechtenstein) (de-li)',
  p_lov_return_value=>'de-li',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19552805649904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>650,
  p_lov_disp_value=>'Allemand (Luxembourg) (de-lu)',
  p_lov_return_value=>'de-lu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19553029091904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>660,
  p_lov_disp_value=>'Allemand (Suisse) (de-ch)',
  p_lov_return_value=>'de-ch',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19553202213904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>670,
  p_lov_disp_value=>'Grec (el)',
  p_lov_return_value=>'el',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19553414759904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>680,
  p_lov_disp_value=>'Gujarati (gu)',
  p_lov_return_value=>'gu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19553603329904496.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>690,
  p_lov_disp_value=>'Hébreu (he)',
  p_lov_return_value=>'he',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19553820460904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>700,
  p_lov_disp_value=>'Hindi (hi)',
  p_lov_return_value=>'hi',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19554032626904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>710,
  p_lov_disp_value=>'Hongrois (hu)',
  p_lov_return_value=>'hu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19554216161904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>720,
  p_lov_disp_value=>'Islandais (is)',
  p_lov_return_value=>'is',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19554406393904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>730,
  p_lov_disp_value=>'Indonésien (id)',
  p_lov_return_value=>'id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19554617290904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>740,
  p_lov_disp_value=>'Italien (Italie) (it)',
  p_lov_return_value=>'it',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19554825694904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>750,
  p_lov_disp_value=>'Italien (Suisse) (it-ch)',
  p_lov_return_value=>'it-ch',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19555020306904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>760,
  p_lov_disp_value=>'Japonais (ja)',
  p_lov_return_value=>'ja',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19555206371904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>770,
  p_lov_disp_value=>'Kannada (kn)',
  p_lov_return_value=>'kn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19555406362904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>780,
  p_lov_disp_value=>'Kazakh (kk)',
  p_lov_return_value=>'kk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19555607264904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>790,
  p_lov_disp_value=>'Konkani (kok)',
  p_lov_return_value=>'kok',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19555824101904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>800,
  p_lov_disp_value=>'Coréen (ko)',
  p_lov_return_value=>'ko',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19556026805904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>810,
  p_lov_disp_value=>'Kirghiz (kz)',
  p_lov_return_value=>'kz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19556222440904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>820,
  p_lov_disp_value=>'Letton (lv)',
  p_lov_return_value=>'lv',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19556430923904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>830,
  p_lov_disp_value=>'Lituanien (lt)',
  p_lov_return_value=>'lt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19556627169904497.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>840,
  p_lov_disp_value=>'Malais (Malaisie) (ms)',
  p_lov_return_value=>'ms',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19556818337904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>850,
  p_lov_disp_value=>'Malayalam (ml)',
  p_lov_return_value=>'ml',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19557021073904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>860,
  p_lov_disp_value=>'Maltais (mt)',
  p_lov_return_value=>'mt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19557224600904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>870,
  p_lov_disp_value=>'Marathi (mr)',
  p_lov_return_value=>'mr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19557405793904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>880,
  p_lov_disp_value=>'Népalais (Inde) (ne)',
  p_lov_return_value=>'ne',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19557603709904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>890,
  p_lov_disp_value=>'Norvégien (Bokmal) (nb-no)',
  p_lov_return_value=>'nb-no',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19557821021904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>900,
  p_lov_disp_value=>'Norvégien (Bokmal) (no)',
  p_lov_return_value=>'no',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19558001272904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>910,
  p_lov_disp_value=>'Norvégien (Nynorsk) (nn-no)',
  p_lov_return_value=>'nn-no',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19558214672904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>920,
  p_lov_disp_value=>'Oriya (or)',
  p_lov_return_value=>'or',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19558417012904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>930,
  p_lov_disp_value=>'Polonais (pl)',
  p_lov_return_value=>'pl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19558623771904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>940,
  p_lov_disp_value=>'Portugais (Brésil) (pt-br)',
  p_lov_return_value=>'pt-br',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19558822426904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>950,
  p_lov_disp_value=>'Portugais (Portugal) (pt)',
  p_lov_return_value=>'pt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19559030439904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>960,
  p_lov_disp_value=>'Pendjabi (pa)',
  p_lov_return_value=>'pa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19559220463904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>970,
  p_lov_disp_value=>'Roumain (ro)',
  p_lov_return_value=>'ro',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19559420414904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>980,
  p_lov_disp_value=>'Russe (ru)',
  p_lov_return_value=>'ru',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19559607482904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>990,
  p_lov_disp_value=>'Russe (Moldova) (ru-md)',
  p_lov_return_value=>'ru-md',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19559819243904498.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'Serbe (sr)',
  p_lov_return_value=>'sr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19560031166904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1010,
  p_lov_disp_value=>'Slovaque (sk)',
  p_lov_return_value=>'sk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19560219320904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1020,
  p_lov_disp_value=>'Slovène (sl)',
  p_lov_return_value=>'sl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19560423019904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1030,
  p_lov_disp_value=>'Espagnol (Argentine) (es-ar)',
  p_lov_return_value=>'es-ar',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19560606177904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1040,
  p_lov_disp_value=>'Espagnol (Bolivie) (es-bo)',
  p_lov_return_value=>'es-bo',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19560818571904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1050,
  p_lov_disp_value=>'Espagnol (Chili) (es-cl)',
  p_lov_return_value=>'es-cl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19561011669904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1060,
  p_lov_disp_value=>'Espagnol (Colombie) (es-co)',
  p_lov_return_value=>'es-co',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19561230885904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1070,
  p_lov_disp_value=>'Espagnol (Costa Rica) (es-cr)',
  p_lov_return_value=>'es-cr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19561406292904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1080,
  p_lov_disp_value=>'Espagnol (République dominicaine) (es-do)',
  p_lov_return_value=>'es-do',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19561601665904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1090,
  p_lov_disp_value=>'Espagnol (Equateur) (es-ec)',
  p_lov_return_value=>'es-ec',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19561804889904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1100,
  p_lov_disp_value=>'Espagnol (El Salvador) (es-sv)',
  p_lov_return_value=>'es-sv',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19562023954904499.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1110,
  p_lov_disp_value=>'Espagnol (Guatemala) (es-gt)',
  p_lov_return_value=>'es-gt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19562220938904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1120,
  p_lov_disp_value=>'Espagnol (Honduras) (es-hn)',
  p_lov_return_value=>'es-hn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19562404920904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1130,
  p_lov_disp_value=>'Espagnol (Mexique) (es-mx)',
  p_lov_return_value=>'es-mx',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19562608285904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1140,
  p_lov_disp_value=>'Espagnol (Nicaragua) (es-ni)',
  p_lov_return_value=>'es-ni',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19562820117904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1150,
  p_lov_disp_value=>'Espagnol (Panama) (es-pa)',
  p_lov_return_value=>'es-pa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19563024706904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1160,
  p_lov_disp_value=>'Espagnol (Paraguay) (es-py)',
  p_lov_return_value=>'es-py',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19563207140904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1170,
  p_lov_disp_value=>'Espagnol (Pérou) (es-pe)',
  p_lov_return_value=>'es-pe',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19563402599904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1180,
  p_lov_disp_value=>'Espagnol (Porto Rico) (es-pr)',
  p_lov_return_value=>'es-pr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19563624092904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1190,
  p_lov_disp_value=>'Espagnol (Traditionnel) (es)',
  p_lov_return_value=>'es',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19563815666904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1200,
  p_lov_disp_value=>'Espagnol (Etats-Unis) (es-us)',
  p_lov_return_value=>'es-us',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19564000959904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1210,
  p_lov_disp_value=>'Espagnol (Uruguay) (es-uy)',
  p_lov_return_value=>'es-uy',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19564207177904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1220,
  p_lov_disp_value=>'Espagnol (Venezuela) (es-ve)',
  p_lov_return_value=>'es-ve',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19564417447904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1230,
  p_lov_disp_value=>'Suédois (sv)',
  p_lov_return_value=>'sv',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19564621375904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1240,
  p_lov_disp_value=>'Suédois (Finlande) (sv-fi)',
  p_lov_return_value=>'sv-fi',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19564802227904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1250,
  p_lov_disp_value=>'Tamoul (ta)',
  p_lov_return_value=>'ta',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19565014332904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1260,
  p_lov_disp_value=>'Télougou (te)',
  p_lov_return_value=>'te',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19565220889904500.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1270,
  p_lov_disp_value=>'Thaï (th)',
  p_lov_return_value=>'th',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19565402300904501.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1280,
  p_lov_disp_value=>'Turc (tr)',
  p_lov_return_value=>'tr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19565628749904501.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1290,
  p_lov_disp_value=>'Ukrainien (uk)',
  p_lov_return_value=>'uk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19565802876904501.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1300,
  p_lov_disp_value=>'Ourdou (ur)',
  p_lov_return_value=>'ur',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19566027071904501.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1310,
  p_lov_disp_value=>'Ouzbek (uz)',
  p_lov_return_value=>'uz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19566203879904501.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19539723892904486.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1320,
  p_lov_disp_value=>'Vietnamien (vi)',
  p_lov_return_value=>'vi',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/icon_detail_view_modes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 28047631397181065.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ICON DETAIL VIEW MODES',
  p_lov_query=> '.'||to_char(28047631397181065 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>28047820343181089.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>28047631397181065.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Icônes',
  p_lov_return_value=>'ICON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>28048010957181093.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>28047631397181065.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Détails',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/included_blocks
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 71133622522750477.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDED BLOCKS',
  p_lov_query=> '.'||to_char(71133622522750477 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>71133818029750477.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>71133622522750477.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Blocs inclus uniquement',
  p_lov_return_value=>'INCLUDED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>71134019860750477.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>71133622522750477.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Blocs non inclus uniquement',
  p_lov_return_value=>'NOT_INCLUDED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>71134200603750478.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>71133622522750477.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Tous les types de bloc',
  p_lov_return_value=>'ALL_TYPES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_analysis_pages
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 281095800411569999.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE_ANALYSIS_PAGES',
  p_lov_query=> '.'||to_char(281095800411569999 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>281096107722570008.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>281095800411569999.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Inclure les pages d''analyse',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_display_as2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM_DISPLAY_AS2',
  p_lov_query=> '.'||to_char(6747932423658349 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6748231335658350.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste SELECT avec liste de valeurs (LOV) instantanée',
  p_lov_return_value=>'SHOW_AS_SL_WITH_POPUP',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6748408042658350.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste de valeurs (LOV) instantanée (extrait le premier ensemble de lignes et applique un filtre)',
  p_lov_return_value=>'POPUP_FILTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6748625496658350.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Mot de passe (soumission lors de l''utilisation de Entrée)',
  p_lov_return_value=>'PASSWORD_WITH_ENTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6748819971658351.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Champ de texte (soumission de la page lors de l''utilisation de Entrée)',
  p_lov_return_value=>'TEXT_WITH_ENTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6749014044658351.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MM-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6749226845658351.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MM-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6749432134658352.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MM-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6749628856658352.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD.MM.YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6749815065658352.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD.MM.YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6750017411658352.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD.MM.YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6750202482658352.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY-MM-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6750413192658353.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY-MM-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6750622420658353.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY.DD.MM HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6750825782658353.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY.DD.MM HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6751023754658353.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY.DD.MM)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6751223530658353.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY/MM/DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6751407250658354.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY/MM/DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6751632123658354.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY/MM/DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6751818385658354.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (RR-MON-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6752026239658354.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (RR-MON-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6752210946658354.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste de valeurs (LOV) de clé instantanée, sans extraction (affiche la description, renvoie la valeur de clé sans préextraction)',
  p_lov_return_value=>'POPUP_KEY_LOV_NOFETCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6752416007658355.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (YYYY-MM-DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6752603482658355.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (RR-MON-DD)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6752808633658355.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Afficher en tant que texte (basé sur PL/SQL, n''enregistre pas le statut)',
  p_lov_return_value=>'DISPLAY_ONLY_PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6753009372658355.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-RR)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6753203859658355.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-RR HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6753426505658356.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-RR HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6753628870658356.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste SELECT',
  p_lov_return_value=>'COMBOBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6753828282658356.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Zone de texte avec compteur de caractères',
  p_lov_return_value=>'TEXTAREA_CHAR_COUNT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6754027873658356.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Zone de texte avec compteur de caractères &amp; vérificateur orthographique',
  p_lov_return_value=>'TEXTAREA_CHAR_COUNT_SPELL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6754230086658356.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Masqué',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6754417091658357.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Arrêter et démarrer un tableau HTML (affiche uniquement le libellé)',
  p_lov_return_value=>'STOP_AND_START_HTML_TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6754617399658357.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Afficher en tant que texte (basé sur liste de valeurs (LOV), n''enregistre pas le statut)',
  p_lov_return_value=>'DISPLAY_ONLY_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6754807695658357.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Afficher en tant que texte (n''enregistre pas le statut)',
  p_lov_return_value=>'DISPLAY_ONLY_HTML',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6755013634658357.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Afficher en tant que texte (échappement des caractères spéciaux, n''enregistre pas le statut)',
  p_lov_return_value=>'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6755202590658357.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Afficher en tant que texte (enregistre le statut)',
  p_lov_return_value=>'DISPLAY_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6755422790658358.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Case à cocher',
  p_lov_return_value=>'CHECKBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6755608476658358.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste de valeurs (LOV) instantanée (extrait le premier ensemble de lignes)',
  p_lov_return_value=>'POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6755823726658358.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste de multisélection',
  p_lov_return_value=>'MULTIPLESELECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6756016460658358.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Groupe de boutons d''option',
  p_lov_return_value=>'RADIOGROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6756201172658358.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Groupe de boutons d''option (avec soumission)',
  p_lov_return_value=>'RADIOGROUP_WITH_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6756401848658359.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Zone de texte',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6756613240658359.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Champ de texte',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6756816813658359.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Mot de passe',
  p_lov_return_value=>'PASSWORD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6757012385658359.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestionnaire de liste (basé sur liste de valeurs (LOV) instantanée)',
  p_lov_return_value=>'LIST_MGR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6757209425658359.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestionnaire de liste (vue uniquement)',
  p_lov_return_value=>'LIST_MGR_VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6757418760658360.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Bouton',
  p_lov_return_value=>'BUTTON',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6757603516658360.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Exploration de fichiers...',
  p_lov_return_value=>'FILE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6757802588658360.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste de valeurs (LOV) instantanée (sans extraction)',
  p_lov_return_value=>'POPUP2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6758017498658360.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestionnaire de liste (basé sur liste de valeurs (LOV) instantanée, sans extraction)',
  p_lov_return_value=>'LIST_MGR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6758208059658368.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste SELECT avec soumission',
  p_lov_return_value=>'COMBOBOX_WITH_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6758414203658368.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Afficher en tant que texte (basé sur liste de valeurs (LOV), enregistre le statut)',
  p_lov_return_value=>'DISPLAY_AND_SAVE_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6758612734658368.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Zone de texte (hauteur automatique)',
  p_lov_return_value=>'TEXTAREA-AUTO-HEIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6758818270658368.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste SELECT avec réacheminement',
  p_lov_return_value=>'COMBOBOX_WITH_JS_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6759011039658369.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Zone de texte avec vérificateur orthographique',
  p_lov_return_value=>'TEXTAREA_WITH_SPELL_CHECK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6759204638658369.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD/MM/YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6759424872658369.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (MM/DD/YYYY)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6759625030658369.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6759817007658369.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-YY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6760026103658369.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD/MM/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6760218688658370.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (MM/DD/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6760423398658370.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6760622288658370.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-YY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6760814753658370.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD/MM/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6761007880658370.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (MM/DD/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6761200975658371.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6761405963658371.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (DD-MON-YY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6761631600658371.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Champ de texte avec calculatrice instantanée',
  p_lov_return_value=>'TEXT_WITH_CALCULATOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6761806209658371.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (utiliser le masque de format d''application)',
  p_lov_return_value=>'PICK_DATE_USING_FLOW_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6762017488658371.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Groupe de boutons d''option avec réacheminement',
  p_lov_return_value=>'RADIOGROUP_WITH_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6762221132658372.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste SELECT renvoyant un réacheminement vers une URL',
  p_lov_return_value=>'COMBOBOX_WITH_URL_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6762405913658372.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste SELECT avec branchement sur une page',
  p_lov_return_value=>'COMBOBOX_WITH_BRANCH_TO_PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6762620479658373.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestionnaire de liste (basé sur liste de valeurs (LOV) instantanée, conservation de la casse)',
  p_lov_return_value=>'LIST_MGR3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6762831822658373.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Champ de texte (désactivé, n''enregistre pas le statut)',
  p_lov_return_value=>'TEXT_DISABLED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6763015644658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste de valeurs (LOV) instantanée (affiche une description, renvoie une valeur de clé)',
  p_lov_return_value=>'POPUP_KEY_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6763217310658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Champ de texte (désactivé, enregistre le statut)',
  p_lov_return_value=>'TEXT_DISABLED_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6763420301658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Zone de texte avec éditeur HTML',
  p_lov_return_value=>'TEXTAREA_WITH_CONTROLS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88335721093279223.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (utiliser le masque de format)',
  p_lov_return_value=>'PICK_DATE_USING_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108089318049047109.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747932423658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sélecteur de date (utiliser le format de date d''application)',
  p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/language_derived_from
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19567918562904506.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LANGUAGE_DERIVED_FROM',
  p_lov_query=> '.'||to_char(19567918562904506 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19568227054904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19567918562904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aucun support NLS (application non traduite)',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19568409975904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19567918562904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Utiliser la langue principale de l''application',
  p_lov_return_value=>'FLOW_PRIMARY_LANGUAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19568622313904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19567918562904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Navigateur (utiliser la préférence de langue du navigateur)',
  p_lov_return_value=>'BROWSER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19568832579904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19567918562904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>''||chr(10)||
'Préférence d''application (utiliser FSP_LANGUAGE_PREFERENCE)',
  p_lov_return_value=>'FLOW_PREFERENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19569003053904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19567918562904506.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Préférence d''élément (utiliser l''élément contenant la préférence)',
  p_lov_return_value=>'ITEM_PREFERENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_pages
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19348705994876274.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST PAGES',
  p_lov_query=> 'select id||'' ''||name n, id'||chr(10)||
'from wwv_flow_steps'||chr(10)||
'where flow_id = :FB_FLOW_ID and security_group_id = :flow_security_group_id'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_projects
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5342113361182830.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST PROJECTS',
  p_lov_query=> 'select migration_name, id'||chr(10)||
'from WWV_FLOW_MIGRATION_PROJECTS'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_applications
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 113527305075764379.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_APPLICATIONS',
  p_lov_query=> 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  id != nvl(:P88_GENERATED_APPLICATION_ID,null) and'||chr(10)||
'       security_group_id = :flow_security_group_id and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id) and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 28213431851608144.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS',
  p_lov_query=> 'select upper(c.schema) d, upper(c.schema) v'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas_qb
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4966919116932394.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS-QB',
  p_lov_query=> 'declare'||chr(10)||
'  l_mode varchar2(255) := null;'||chr(10)||
'  l_dba  boolean := false;'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  l_mode :=  ''NORMAL'';'||chr(10)||
'  for c1 in (select patch_name, patch_status'||chr(10)||
'             from wwv_flow_patches'||chr(10)||
'             where flow_id = 4500'||chr(10)||
'             and security_group_id = 10'||chr(10)||
'             and patch_status = ''INCLUDE'''||chr(10)||
'             and patch_name = ''XE'')'||chr(10)||
'  loop'||chr(10)||
'    l_mode := ''XE'';'||chr(10)||
'  end loop;'||chr(10)||
'  for c1 in (select 1 '||chr(10)||
'             from dba_role_privs '||chr(10)||
'             where grantee=upper(:APP_USER) '||chr(10)||
'             and granted_role in (''DBA'', ''SELECT_CATALOG_ROLE''))'||chr(10)||
'  loop'||chr(10)||
'    l_dba := true;'||chr(10)||
'  end loop;'||chr(10)||
'  if l_mode = ''XE'' then'||chr(10)||
'    if l_dba then'||chr(10)||
'    	q:=''select upper(u.username) d, upper(u.username) v '';'||chr(10)||
'      q:=q||''from   dba_users u '';           '||chr(10)||
'      q:=q||''where  nvl(:P1002_POPUP,0) <> 1 '';'||chr(10)||
'      if :APP_USER != ''SYS'' then'||chr(10)||
'      q:=q||''and u.username != ''''SYS'''' '';'||chr(10)||
'      end if;'||chr(10)||
'      q:=q||''union all '';'||chr(10)||
'      q:=q||''select :P1002_SCHEMA a,:P1002_SCHEMA b from dual '';'||chr(10)||
'      q:=q||''where  :P1002_POPUP = 1 '';'||chr(10)||
'      q:=q||''order by 1'';'||chr(10)||
'    end if;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  if q is null then'||chr(10)||
'    q:=''select upper(c.schema) d, upper(c.schema) v '';'||chr(10)||
'    q:=q||''from   wwv_flow_company_schemas c, ''; '||chr(10)||
'    q:=q||''       wwv_flow_fnd_user u ''; '||chr(10)||
'    q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'    q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'    q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'    q:=q||''  and  nvl(:P1002_POPUP,0) <> 1 '';'||chr(10)||
'    q:=q||''union all '';'||chr(10)||
'    q:=q||''select :P1002_SCHEMA a,:P1002_SCHEMA b from dual '';'||chr(10)||
'    q:=q||''where  :P1002_POPUP = 1 '';'||chr(10)||
'    q:=q||''order by 1'';'||chr(10)||
'  end if;'||chr(10)||
'  return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas_sc
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4967007334932394.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS-SC',
  p_lov_query=> 'declare'||chr(10)||
'  l_mode varchar2(255) := null;'||chr(10)||
'  l_dba  boolean := false;'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  l_mode :=  ''NORMAL'';'||chr(10)||
'  for c1 in (select patch_name, patch_status'||chr(10)||
'             from wwv_flow_patches'||chr(10)||
'             where flow_id = 4500'||chr(10)||
'             and security_group_id = 10'||chr(10)||
'             and patch_status = ''INCLUDE'''||chr(10)||
'             and patch_name = ''XE'')'||chr(10)||
'  loop'||chr(10)||
'    l_mode := ''XE'';'||chr(10)||
'  end loop;  '||chr(10)||
'  for c1 in (select 1 '||chr(10)||
'             from dba_role_privs '||chr(10)||
'             where grantee=upper(:APP_USER) '||chr(10)||
'             and granted_role in (''DBA'', ''SELECT_CATALOG_ROLE''))'||chr(10)||
'  loop'||chr(10)||
'    l_dba := true;'||chr(10)||
'  end loop;'||chr(10)||
'  if l_mode = ''XE'' then'||chr(10)||
'  	if l_dba then      '||chr(10)||
'      q:=''select upper(u.username) d, upper(u.username) v '';'||chr(10)||
'      q:=q||''from   dba_users u '';'||chr(10)||
'      q:=q||''where  nvl(:P1003_POPUP,0) <> 1 '';'||chr(10)||
'      if :APP_USER != ''SYS'' then'||chr(10)||
'      q:=q||''and u.username != ''''SYS'''' '';'||chr(10)||
'      end if;'||chr(10)||
'      q:=q||''union all '';'||chr(10)||
'      q:=q||''select :P1003_SCHEMA a,:P1003_SCHEMA b from dual '';'||chr(10)||
'      q:=q||''where  :P1003_POPUP = 1 '';'||chr(10)||
'      q:=q||''order by 1'';           '||chr(10)||
'    end if;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  if q is null then'||chr(10)||
'    q:=''select upper(c.schema) d, upper(c.schema) v '';'||chr(10)||
'    q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'    q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'    q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'    q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'    q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'    q:=q||''  and  nvl(:P1003_POPUP,0) <> 1 '';'||chr(10)||
'    q:=q||''union all '';'||chr(10)||
'    q:=q||''select :P1003_SCHEMA a,:P1003_SCHEMA b from dual '';'||chr(10)||
'    q:=q||''where  :P1003_POPUP = 1 '';'||chr(10)||
'    q:=q||''order by 1'';'||chr(10)||
'  end if;'||chr(10)||
'  return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_list_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23674523555471642.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_LIST_TEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''LIST'''||chr(10)||
'and name in (''Vertical Images List'',''Horizontal Images with Label List'',''Vertical Unordered List without Bullet'')'||chr(10)||
'and flow_id = 187'||chr(10)||
'order by upper(name)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_schemas
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5506106131506937.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_SCHEMAS',
  p_lov_query=> 'select username d, username r'||chr(10)||
'from   all_users'||chr(10)||
'order by username');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/maximum_rows_per_page
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAXIMUM ROWS PER PAGE',
  p_lov_query=> '.'||to_char(19349011344876284 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19349327517876285.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19349505541876288.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19349701912876288.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19349928986876288.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19350112513876289.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19350314621876289.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>45,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19350509941876289.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19350721995876289.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'75',
  p_lov_return_value=>'75',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19350914041876289.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19351126542876290.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19351308795876290.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19351512640876290.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19349011344876284.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_a
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_A',
  p_lov_query=> '.'||to_char(4967521946932394 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4967613030932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4967731506932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4967816619932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4967913039932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4968020929932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4968115166932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4968226890932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4968310568932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4968403957932395.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4968528192932396.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5000,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4968627917932396.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10000,
  p_lov_disp_value=>'10000',
  p_lov_return_value=>'10000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4968704410932396.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4967521946932394.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100000,
  p_lov_disp_value=>'100000',
  p_lov_return_value=>'100000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_b
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_B',
  p_lov_query=> '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5888521524309850.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5888718257309853.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5888903813309853.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5889109860309853.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5889315250309854.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5889515427309854.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5889710061309854.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5889908308309854.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5890109498309854.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5890312245309855.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5890505497309855.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5890701112309855.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'10000',
  p_lov_return_value=>'10000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5890929510309855.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>5888327993309845.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'50000',
  p_lov_return_value=>'50000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_link_extra_column
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6746916502658348.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_LINK_EXTRA_COLUMN',
  p_lov_query=> '.'||to_char(6746916502658348 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6747215160658348.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6746916502658348.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Utiliser une colonne supplémentaire pour afficher le lien',
  p_lov_return_value=>'LINK_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_link_to_page
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148499929862732707.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_LINK_TO_PAGE',
  p_lov_query=> '.'||to_char(148499929862732707 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148500204265732708.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>148499929862732707.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Bouton de modification propre au thème',
  p_lov_return_value=>'LINK_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148500408124732708.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>148499929862732707.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Colonne d''état',
  p_lov_return_value=>'REPORT_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148500632543732708.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>148499929862732707.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Lien personnalisé',
  p_lov_return_value=>'CUSTOM_LINK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_page_columns_p11
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6743817071658321.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_PAGE_COLUMNS P11',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols'||chr(10)||
'where  model_region_id = :P11_REGION_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_page_columns_p47
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 13439106662908793.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_PAGE_COLUMNS P47',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols'||chr(10)||
'where  model_region_id = :P47_REGION_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_parent_page_columns_p11
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6744227823658338.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_PARENT_PAGE_COLUMNS P11',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols  s'||chr(10)||
'where  model_region_id in ('||chr(10)||
'   select id from wwv_flow_model_page_regions'||chr(10)||
'   where model_page_id = ('||chr(10)||
'       select id '||chr(10)||
'       from   wwv_flow_model_pages '||chr(10)||
'       where  model_id = :P33_MODEL_ID'||chr(10)||
'       and    id  = :P11_PARENT_PAGE_ID'||chr(10)||
'))'||chr(10)||
'and column_name not like ''LINK$%''');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_parent_page_columns_p47
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 13439511856910336.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_PARENT_PAGE_COLUMNS P47',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols  s'||chr(10)||
'where  model_region_id in ('||chr(10)||
'  select id from wwv_flow_model_page_regions'||chr(10)||
'  where model_page_id = (   '||chr(10)||
'         select id '||chr(10)||
'         from   wwv_flow_model_pages '||chr(10)||
'         where  model_id = :MW_MODEL_ID'||chr(10)||
'         and    id  = :P47_PARENT_PAGE_ID'||chr(10)||
'))'||chr(10)||
'and column_name not like ''LINK$%''');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_users
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 280355617935739625.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_USERS',
  p_lov_query=> 'select distinct htf.escape_sc(m.created_by) d, m.created_by r'||chr(10)||
'from wwv_flow_models m, wwv_flow_model_pages p, wwv_flow_company_schemas s'||chr(10)||
'where m.id = p.model_id '||chr(10)||
'and   m.owner = s.schema'||chr(10)||
'and m.security_group_id = :flow_security_group_id'||chr(10)||
'and s.security_group_id = :flow_security_group_id'||chr(10)||
'and m.model_complete = ''Y'''||chr(10)||
'group by m.created_by');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_use_theme_button
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6747416812658349.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_USE_THEME_BUTTON',
  p_lov_query=> '.'||to_char(6747416812658349 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6747724917658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6747416812658349.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Utiliser un bouton de modification propre au thème',
  p_lov_return_value=>'THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/object_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 237819027746437948.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OBJECT STATUS',
  p_lov_query=> '.'||to_char(237819027746437948 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>237819217974437950.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>237819027746437948.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Valide',
  p_lov_return_value=>'VALID',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>237819502129437953.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>237819027746437948.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non valide',
  p_lov_return_value=>'INVALID',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>237819724006437953.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>237819027746437948.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Inconnu',
  p_lov_return_value=>'UNKNOWN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/orignal_or_new_or_custom
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 69216414083288226.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ORIGNAL OR NEW OR CUSTOM',
  p_lov_query=> '.'||to_char(69216414083288226 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>69216620463288226.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>69216414083288226.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Interrogation d''origine',
  p_lov_return_value=>'ORIGINAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>69218031530302696.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>69216414083288226.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Interrogation personnalisée',
  p_lov_return_value=>'CUSTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>69216804670288228.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>69216414083288226.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Interrogation améliorée',
  p_lov_return_value=>'ENHANCED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p24_column_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 281552116966737419.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P24_COLUMN_LIST',
  p_lov_query=> 'select htf.escape_sc(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner =  UPPER(:P24_SCHEMA)'||chr(10)||
'  and table_name= UPPER(:P24_TABLE_NAME)'||chr(10)||
'   and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner)'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_icons
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE ICONS',
  p_lov_query=> '.'||to_char(25461000358572316 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27927008443557504.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'APEX',
  p_lov_return_value=>'menu/prod_apex_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/prod_apex_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27928514246578089.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Application',
  p_lov_return_value=>'menu/application_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/bboard_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27928123811571390.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Graphique à barres',
  p_lov_return_value=>'menu/chart_bar_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/books_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25461723903572329.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Panneau d''affichage',
  p_lov_return_value=>'menu/bboard_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/bug_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25461506215572329.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Livres',
  p_lov_return_value=>'menu/books_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/users_business_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25461911706572329.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Bug',
  p_lov_return_value=>'menu/bug_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/calendar_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27930717624597930.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Professionnels',
  p_lov_return_value=>'menu/users_business_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/clipboard_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25549627004478874.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Calendrier',
  p_lov_return_value=>'menu/calendar_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/db_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25550216746485324.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Page de calendrier',
  p_lov_return_value=>'menu/calendar_page_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/key_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25550530252489286.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Client',
  p_lov_return_value=>'menu/client_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/disk_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27933210960614982.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Presse-papiers',
  p_lov_return_value=>'menu/clipboard_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/download_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25550807526492173.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Base de données',
  p_lov_return_value=>'menu/db_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/draw_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25551112721493680.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Développement',
  p_lov_return_value=>'menu/prod_sqldev_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/edit_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25551417223494996.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>14,
  p_lov_disp_value=>'Disque',
  p_lov_return_value=>'menu/disk_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/folder_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25551724495497041.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Télécharger en local',
  p_lov_return_value=>'menu/download_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/globe_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27936122566656168.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'Dessiner',
  p_lov_return_value=>'menu/draw_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/info_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25552000039499512.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>17,
  p_lov_disp_value=>'Dynamique',
  p_lov_return_value=>'menu/dynamic_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/lightbulb_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25555706619501355.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>18,
  p_lov_disp_value=>'Modifier',
  p_lov_return_value=>'menu/edit_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/chart_line_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25556010774502580.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>19,
  p_lov_disp_value=>'Dossier',
  p_lov_return_value=>'menu/folder_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/lock_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27938119365674134.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Dossier jaune',
  p_lov_return_value=>'menu/folder_yellow_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/mail_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25462100534572330.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>21,
  p_lov_disp_value=>'Panneau',
  p_lov_return_value=>'menu/form_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/memo_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>29268301849698547.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>22,
  p_lov_disp_value=>'Processus de formulaire',
  p_lov_return_value=>'menu/form_proc_page_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/client_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25556316315504154.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>23,
  p_lov_disp_value=>'Assistant Panneau',
  p_lov_return_value=>'menu/form_wiz_page_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/navigation_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27947623137722547.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>24,
  p_lov_disp_value=>'Globe',
  p_lov_return_value=>'menu/globe_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/news_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25556821510505685.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>25,
  p_lov_disp_value=>'Page d''accueil',
  p_lov_return_value=>'menu/home_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/package_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25557326012506996.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>26,
  p_lov_disp_value=>'Informations',
  p_lov_return_value=>'menu/info_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/page_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25558107096510945.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>27,
  p_lov_disp_value=>'Clé',
  p_lov_return_value=>'menu/key_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/pdf_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27951931149753320.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>28,
  p_lov_disp_value=>'Ampoule'||chr(10)||
'',
  p_lov_return_value=>'menu/lightbulb_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/phone_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25560204157547933.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>29,
  p_lov_disp_value=>'Graphique à courbes'||chr(10)||
'',
  p_lov_return_value=>'menu/chart_line_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/chart_pie_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25560514200550899.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Verrou externe'||chr(10)||
'',
  p_lov_return_value=>'menu/lock_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/pin_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>28462102374102568.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>31,
  p_lov_disp_value=>'Logique',
  p_lov_return_value=>'menu/login_64.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25461325295572327.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>32,
  p_lov_disp_value=>'Connexion'||chr(10)||
'',
  p_lov_return_value=>'menu/login_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/application_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25560819394552358.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>33,
  p_lov_disp_value=>'Courrier'||chr(10)||
'',
  p_lov_return_value=>'menu/mail_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/search_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25561324374563259.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>34,
  p_lov_disp_value=>'Carte'||chr(10)||
'',
  p_lov_return_value=>'menu/global_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/server_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25561629915564829.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>35,
  p_lov_disp_value=>'Mémo'||chr(10)||
'',
  p_lov_return_value=>'menu/memo_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/shapes_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25561906150567460.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>36,
  p_lov_disp_value=>'Navigation'||chr(10)||
'',
  p_lov_return_value=>'menu/navigation_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/spreadsheet_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27956109725775505.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>37,
  p_lov_disp_value=>'Page de navigation'||chr(10)||
'',
  p_lov_return_value=>'menu/navigation_page_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/todo_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25562214462569827.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>38,
  p_lov_disp_value=>'Actualités'||chr(10)||
'',
  p_lov_return_value=>'menu/news_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/users_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56856828845814360.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>39,
  p_lov_disp_value=>'Package'||chr(10)||
'',
  p_lov_return_value=>'menu/package_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/folder_yellow_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56858230839833869.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Page'||chr(10)||
'',
  p_lov_return_value=>'menu/page_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/global_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56859913440847773.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>41,
  p_lov_disp_value=>'Graphique de page'||chr(10)||
'',
  p_lov_return_value=>'menu/chart_page_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/chart_page_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56860321751850200.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>42,
  p_lov_disp_value=>'PDF'||chr(10)||
'',
  p_lov_return_value=>'menu/pdf_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/chart_bar_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56860908722855900.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>43,
  p_lov_disp_value=>'Téléphone'||chr(10)||
'',
  p_lov_return_value=>'menu/phone_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/calendar_page_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64"  title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56867325654908047.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>44,
  p_lov_disp_value=>'Graphique à secteurs'||chr(10)||
'',
  p_lov_return_value=>'menu/chart_pie_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/dynamic_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56867603621911220.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>45,
  p_lov_disp_value=>'Code PIN'||chr(10)||
'',
  p_lov_return_value=>'menu/form_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/form_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>28473627168374611.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>46,
  p_lov_disp_value=>'Imprimante',
  p_lov_return_value=>'menu/printer_64.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56867912625913730.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>47,
  p_lov_disp_value=>'Etat'||chr(10)||
'',
  p_lov_return_value=>'menu/report_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/home_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56868224053917050.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>48,
  p_lov_disp_value=>'Recherche'||chr(10)||
'',
  p_lov_return_value=>'menu/search_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/login_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56868509078931677.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>49,
  p_lov_disp_value=>'Serveur'||chr(10)||
'',
  p_lov_return_value=>'menu/server_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/prod_sqldev_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56868816350933757.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Formes'||chr(10)||
'',
  p_lov_return_value=>'menu/shapes_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/report_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56869125700936489.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>51,
  p_lov_disp_value=>'Feuille de calcul'||chr(10)||
'',
  p_lov_return_value=>'menu/spreadsheet_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/tabform_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>28475821037505347.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>52,
  p_lov_disp_value=>'Objets de prise en charge',
  p_lov_return_value=>'menu/supporting_obj_64.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56869407824940725.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>53,
  p_lov_disp_value=>'Panneau tabulaire'||chr(10)||
'',
  p_lov_return_value=>'menu/tabform_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/trafficlight_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56869716135943137.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>54,
  p_lov_disp_value=>'Liste de tâches'||chr(10)||
'',
  p_lov_return_value=>'menu/todo_64.gif',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/tree_64.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="64" height="64" title="#DISPLAY_VALUE#"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18140600744431403.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>55,
  p_lov_disp_value=>'Feux de circulation'||chr(10)||
'',
  p_lov_return_value=>'menu/trafficlight_64.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>28477411602521473.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>56,
  p_lov_disp_value=>'Corbeille',
  p_lov_return_value=>'menu/trash_64.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18140908709433629.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>57,
  p_lov_disp_value=>'Arborescence'||chr(10)||
'',
  p_lov_return_value=>'menu/tree_64.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>28478629610526666.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>58,
  p_lov_disp_value=>'Interface utilisateur',
  p_lov_return_value=>'menu/ui_64.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18141630872440099.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>25461000358572316.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>59,
  p_lov_disp_value=>'Utilisateurs'||chr(10)||
'',
  p_lov_return_value=>'menu/users_64.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_source
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6596415880390663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE SOURCE',
  p_lov_query=> '.'||to_char(6596415880390663 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6596717246390682.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6596415880390663.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Table',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6596923554390682.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6596415880390663.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Interrogation SQL',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 22078515151918053.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE TYPE',
  p_lov_query=> '.'||to_char(22078515151918053 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22078822992918064.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22078515151918053.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Vierge',
  p_lov_return_value=>'BLANK',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''BLANK'');setAction(''BLANK'');"><img src="#IMAGE_PREFIX#menu/app_wiz_blank.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIons" width="84" height="54" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22079009655918067.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22078515151918053.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Etat',
  p_lov_return_value=>'REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''REPORT'');setAction(''REPORT'');"><img src="#IMAGE_PREFIX#menu/app_wiz_report.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22079224798918067.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22078515151918053.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Panneau',
  p_lov_return_value=>'FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:javascript:setType(''FORM'');setAction(''FORM'');"><img src="#IMAGE_PREFIX#menu/app_wiz_form.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22079425635918067.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22078515151918053.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Panneau tabulaire',
  p_lov_return_value=>'TABULARFORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''TABULARFORM'');setAction(''TABULARFORM'');"><img src="#IMAGE_PREFIX#menu/app_wiz_tab_form.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22079828922918067.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22078515151918053.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Maître-détail',
  p_lov_return_value=>'MASTERDETAIL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''MASTERDETAIL'');setAction(''MASTERDETAIL'');"><img src="#IMAGE_PREFIX#menu/app_wiz_md.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22079600519918067.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22078515151918053.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Etat et panneau',
  p_lov_return_value=>'REPORTANDFORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''REPORTANDFORM'');setAction(''REPORTANDFORM'');"><img src="#IMAGE_PREFIX#menu/app_wiz_form_report.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':MW_MIG_TYPE = ''forms''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22080005050918067.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>22078515151918053.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Graphique à secteurs',
  p_lov_return_value=>'PIE_CHART',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE TYPES',
  p_lov_query=> '.'||to_char(6575418257362951 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6575711448362973.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Vierge',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6575932241362977.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Etat',
  p_lov_return_value=>'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6576110760362977.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Panneau',
  p_lov_return_value=>'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6576316945362977.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Panneau tabulaire',
  p_lov_return_value=>'TABULARFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6576530807362977.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Etat et panneau',
  p_lov_return_value=>'REPORTANDFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6576722275362977.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Graphique à barres',
  p_lov_return_value=>'BAR_CHART',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6576928321362978.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Graphique à secteurs',
  p_lov_return_value=>'PIE_CHART',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14320426249107116.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Maître-détail',
  p_lov_return_value=>'MASTERDETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>230281621768293053.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6575418257362951.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Associé à un autre bloc',
  p_lov_return_value=>'RELATED',
  p_lov_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION',
  p_lov_disp_cond=> '77',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_icons_2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 18047316880000789.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_ICONS_2',
  p_lov_query=> 'select icon_name d, icon_name r'||chr(10)||
'from WWV_FLOW_STANDARD_ICONS'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_source
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6744724810658339.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_SOURCE',
  p_lov_query=> '.'||to_char(6744724810658339 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6745016970658341.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6744724810658339.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Table',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6745208269658342.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6744724810658339.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Interrogation SQL',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6745404220658342.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6744724810658339.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Données de feuille de calcul',
  p_lov_return_value=>'SPREADSHEET',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/preserve_case_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 779187723922628339.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRESERVE.CASE.Y',
  p_reference_id=> 88034811582507798,
  p_lov_query=> '.'||to_char(779187723922628339 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>779188327836628367.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>779187723922628339.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Respecter maj/min',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/priority
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 314799204604794684.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRIORITY',
  p_lov_query=> '.'||to_char(314799204604794684 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>314799525641794689.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>314799204604794684.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>314799718960794691.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>314799204604794684.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'2',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>314799927311794692.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>314799204604794684.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'3',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>314800130270794692.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>314799204604794684.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'4',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>314800326438794693.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>314799204604794684.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/report_type_interactive_or_classic
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148634518096505157.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REPORT TYPE: INTERACTIVE OR CLASSIC',
  p_lov_query=> '.'||to_char(148634518096505157 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148634809457505157.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>148634518096505157.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Interactive',
  p_lov_return_value=>'INTERACTIVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148635018301505157.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>148634518096505157.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Classique',
  p_lov_return_value=>'CLASSIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/search_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2036623110176721.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SEARCH_TYPE',
  p_reference_id=> 246393217654948737,
  p_lov_query=> '.'||to_char(2036623110176721 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2037929223176759.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2036623110176721.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Respecter la casse',
  p_lov_return_value=>'CASE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2038109406176759.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2036623110176721.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Mot entier',
  p_lov_return_value=>'WHOLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2038329235176759.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>2036623110176721.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Rechercher une expression régulière',
  p_lov_return_value=>'REGEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/source_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6520502328008192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SOURCE TYPES',
  p_lov_query=> '.'||to_char(6520502328008192 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6520822731008222.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6520502328008192.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Table',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6521010279008227.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6520502328008192.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Interrogation',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6521202295008227.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6520502328008192.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Interrogation SQL',
  p_lov_return_value=>'SQL Query',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/source_object_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 241894613225273397.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SOURCE_OBJECT_TYPE',
  p_lov_query=> '.'||to_char(241894613225273397 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>241894832568273400.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>241894613225273397.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Interrogation SQL',
  p_lov_return_value=>'SQL Query',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>241895018506273408.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>241894613225273397.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Interrogation',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>241895204500273408.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>241894613225273397.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Table',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/standard_icon_size
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 115145707173040879.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'STANDARD_ICON_SIZE',
  p_lov_query=> '.'||to_char(115145707173040879 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>115146201225040887.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>115145707173040879.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'32x32',
  p_lov_return_value=>'32',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>115146031566040882.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>115145707173040879.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'64x64',
  p_lov_return_value=>'64',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>145547208987259826.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>115145707173040879.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'128x128',
  p_lov_return_value=>'128',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/tabs_for_800
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19566729798904505.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TABS (FOR 800)',
  p_lov_query=> '.'||to_char(19566729798904505 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19567011806904505.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19566729798904505.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Aucun onglet',
  p_lov_return_value=>'NO_TABS',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#htmldb/icons/tab_none_preview.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19567207329904505.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19566729798904505.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Un niveau d''onglets',
  p_lov_return_value=>'SINGLE_LEVEL_TABS',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#htmldb/icons/tab_1_preview.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19567402803904505.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>19566729798904505.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Deux niveaux d''onglets',
  p_lov_return_value=>'TWO_LEVEL_TABS',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#htmldb/icons/tab_2_preview.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon"/>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/tabular_form_display_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TABULAR_FORM_DISPLAY_TYPES',
  p_lov_query=> '.'||to_char(6763505062658374 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6763828443658375.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Colonne d''état standard',
  p_lov_return_value=>'WITHOUT_MODIFICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6764005501658375.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Afficher en tant que texte (basé sur liste de valeurs (LOV), n''enregistre pas le statut)',
  p_lov_return_value=>'TEXT_FROM_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6764214659658375.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Afficher en tant que texte (enregistre le statut)',
  p_lov_return_value=>'DISPLAY_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6764428704658375.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Afficher en tant que texte (échappement des caractères spéciaux, n''enregistre pas le statut)',
  p_lov_return_value=>'ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6764615041658375.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Sélecteur de date',
  p_lov_return_value=>'DATE_POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6764808473658376.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Champ de texte',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6765021286658376.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Zone de texte',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6765214134658376.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Liste SELECT (liste de valeurs (LOV) statique)',
  p_lov_return_value=>'SELECT_LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6765413782658376.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Liste SELECT (liste de valeurs (LOV) nommée)',
  p_lov_return_value=>'SELECT_LIST_FROM_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6765614697658376.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Liste SELECT (liste de valeurs (LOV) basée sur une interrogation)',
  p_lov_return_value=>'SELECT_LIST_FROM_QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6765826112658376.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Masqué ',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6766003237658377.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Liste de valeurs (LOV) instantanée (LOV nommée)',
  p_lov_return_value=>'POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6766204719658377.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6763505062658374.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Liste de valeurs (LOV) instantanée (LOV basée sur une interrogation)',
  p_lov_return_value=>'POPUP_QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/theme_list_for_ws_preferences
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19567622224904505.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'THEME LIST FOR WS PREFERENCES',
  p_lov_query=> 'select wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''<br/><img src="#IMAGE_PREFIX#themes/theme_''||t.theme_id||''/themeshot.png" alt="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" title="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" width="150" height="80" class="htmldbthemeshots" />'' display_value, t.theme_id '||chr(10)||
'from ('||chr(10)||
'    select substr(object_name,16) theme_id '||chr(10)||
'    from   user_objects '||chr(10)||
'    where  object_name like ''WWV_FLOW_THEME_%'''||chr(10)||
'    and    object_type = ''PACKAGE'''||chr(10)||
'    and    substr(object_name,16) in ('||chr(10)||
'        ''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'','||chr(10)||
'        ''11'',''12'',''13'',''14'',''15'',''16'',''17'',''18'',''19'',''20'','||chr(10)||
'        ''21'',''22'',''23'',''24'',''25'',''26'',''27'',''28'',''29'',''30'','||chr(10)||
'        ''31'',''32'',''33'',''34'',''35'',''36'',''37'',''38'',''39'',''40'','||chr(10)||
'        ''41'',''42'',''43'',''44'',''45'',''46'',''47'',''48'',''49'',''50'','||chr(10)||
'        ''51'',''52'',''53'',''54'',''55'',''56'',''57'',''58'',''59'',''60'','||chr(10)||
'        ''61'',''62'',''63'',''64'',''65'',''66'',''67'',''68'',''69'',''70'','||chr(10)||
'        ''71'',''72'',''73'',''74'',''75'',''76'',''77'',''78'',''79'',''80'','||chr(10)||
'        ''81'',''82'',''83'',''84'',''85'',''86'',''87'',''88'',''89'',''90'','||chr(10)||
'        ''91'',''92'',''93'',''94'',''95'',''96'',''97'',''98'',''99'',''100'''||chr(10)||
'    )'||chr(10)||
') t'||chr(10)||
'order by to_number(t.theme_id)'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/theme_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 21420921045690180.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'THEME_LIST',
  p_lov_query=> 'select wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''<br/><a href="f?p=4400:&P50_NEXT.:&SESSION.::::THEME_ID:''||t.theme_id||''"><img src="#IMAGE_PREFIX#themes/theme_''||t.theme_id||''/themeshot.png" alt="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" title="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" width="150" height="80" class="htmldbthemeshots" /></a>'' display_value, t.theme_id '||chr(10)||
'from ('||chr(10)||
'    select substr(object_name,16) theme_id '||chr(10)||
'    from   user_objects '||chr(10)||
'    where  object_name like ''WWV_FLOW_THEME_%'''||chr(10)||
'    and    object_type = ''PACKAGE'''||chr(10)||
'    and    substr(object_name,16) in ('||chr(10)||
'        ''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'','||chr(10)||
'        ''11'',''12'',''13'',''14'',''15'',''16'',''17'',''18'',''19'',''20'','||chr(10)||
'        ''21'',''22'',''23'',''24'',''25'',''26'',''27'',''28'',''29'',''30'','||chr(10)||
'        ''31'',''32'',''33'',''34'',''35'',''36'',''37'',''38'',''39'',''40'','||chr(10)||
'        ''41'',''42'',''43'',''44'',''45'',''46'',''47'',''48'',''49'',''50'','||chr(10)||
'        ''51'',''52'',''53'',''54'',''55'',''56'',''57'',''58'',''59'',''60'','||chr(10)||
'        ''61'',''62'',''63'',''64'',''65'',''66'',''67'',''68'',''69'',''70'','||chr(10)||
'        ''71'',''72'',''73'',''74'',''75'',''76'',''77'',''78'',''79'',''80'','||chr(10)||
'        ''81'',''82'',''83'',''84'',''85'',''86'',''87'',''88'',''89'',''90'','||chr(10)||
'        ''91'',''92'',''93'',''94'',''95'',''96'',''97'',''98'',''99'',''100'''||chr(10)||
'    )'||chr(10)||
') t'||chr(10)||
'order by to_number(t.theme_id)'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/theme_list_forms
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 252487730157991211.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'THEME_LIST_FORMS',
  p_lov_query=> 'select wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''<br/><a href="f?p=4400:&P138_NEXT.:&SESSION.::::THEME_ID:''||t.theme_id||''"><img src="#IMAGE_PREFIX#themes/theme_''||t.theme_id||''/themeshot.png" alt="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" title="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" width="150" height="80" class="htmldbthemeshots" /></a>'' display_value, t.theme_id '||chr(10)||
'from ('||chr(10)||
'    select substr(object_name,16) theme_id '||chr(10)||
'    from   user_objects '||chr(10)||
'    where  object_name like ''WWV_FLOW_THEME_%'''||chr(10)||
'    and    object_type = ''PACKAGE'''||chr(10)||
'    and    substr(object_name,16) in ('||chr(10)||
'        ''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'','||chr(10)||
'        ''11'',''12'',''13'',''14'',''15'',''16'',''17'',''18'',''19'',''20'','||chr(10)||
'        ''21'',''22'',''23'',''24'',''25'',''26'',''27'',''28'',''29'',''30'','||chr(10)||
'        ''31'',''32'',''33'',''34'',''35'',''36'',''37'',''38'',''39'',''40'','||chr(10)||
'        ''41'',''42'',''43'',''44'',''45'',''46'',''47'',''48'',''49'',''50'','||chr(10)||
'        ''51'',''52'',''53'',''54'',''55'',''56'',''57'',''58'',''59'',''60'','||chr(10)||
'        ''61'',''62'',''63'',''64'',''65'',''66'',''67'',''68'',''69'',''70'','||chr(10)||
'        ''71'',''72'',''73'',''74'',''75'',''76'',''77'',''78'',''79'',''80'','||chr(10)||
'        ''81'',''82'',''83'',''84'',''85'',''86'',''87'',''88'',''89'',''90'','||chr(10)||
'        ''91'',''92'',''93'',''94'',''95'',''96'',''97'',''98'',''99'',''100'''||chr(10)||
'    )'||chr(10)||
') t'||chr(10)||
'order by to_number(t.theme_id)'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/tracking_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 315692701788575763.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TRACKING.Y',
  p_lov_query=> '.'||to_char(315692701788575763 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>315693011339575765.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>315692701788575763.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'&nbsp;',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/true_false_returns_true_false
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 316558909921607180.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TRUE_FALSE_RETURNS_TRUE_FALSE',
  p_lov_query=> '.'||to_char(316558909921607180 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>316559227102607184.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>316558909921607180.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'True',
  p_lov_return_value=>'true',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>316559418608607187.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>316558909921607180.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'False',
  p_lov_return_value=>'false',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/true_false_returns_yes_no
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14399402420296792.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TRUE_FALSE_RETURNS_YES_NO',
  p_lov_query=> '.'||to_char(14399402420296792 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14399716540296797.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>14399402420296792.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Oui',
  p_lov_return_value=>'true',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14399901308296801.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>14399402420296792.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non',
  p_lov_return_value=>'false',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/unique
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 779206215728670740.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'UNIQUE',
  p_reference_id=> 88045300809552005,
  p_lov_query=> '.'||to_char(779206215728670740 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>779206802692670742.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>779206215728670740.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Unique',
  p_lov_return_value=>'UNIQUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/upload_file_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 76748016384925027.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'UPLOAD FILE OPTIONS',
  p_lov_query=> '.'||to_char(76748016384925027 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>76748312620925030.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>76748016384925027.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Module de panneaux (_fmb.XML)',
  p_lov_return_value=>'FMB',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4400:52:&SESSION.:FMB:&DEBUG.:52"><img src="#IMAGE_PREFIX#htmldb/builder/xml_upload2.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>76748711484925032.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>76748016384925027.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Etat Oracle Reports (.XML)',
  p_lov_return_value=>'RPT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4400:102:&SESSION.:RPT:&DEBUG.:102"><img src="#IMAGE_PREFIX#htmldb/builder/load_xml.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>76748522028925031.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>76748016384925027.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Bibliothèque PL/SQL (.PLD)',
  p_lov_return_value=>'PLD',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4400:52:&SESSION.:PLD:&DEBUG.:52"><img src="#IMAGE_PREFIX#htmldb/builder/load_ascii.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>79703010333991913.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>76748016384925027.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Menu de panneau (_mmb.XML)',
  p_lov_return_value=>'MMB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>79702822669986011.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>76748016384925027.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Bibliothèque d''objets (_olb.XML)',
  p_lov_return_value=>'OLB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/y_n_returns_y_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4991900002932438.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'Y.N.RETURNS.Y.N',
  p_lov_query=> '.'||to_char(4991900002932438 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4992022817932438.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4991900002932438.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Oui',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4992123292932438.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4991900002932438.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Non',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no_returns_y_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4992221700932438.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES.NO.RETURNS.Y.N',
  p_lov_query=> '.'||to_char(4992221700932438 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4992326341932438.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4992221700932438.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Oui',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4992416805932439.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4992221700932438.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_checkbox
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4992521041932439.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES_CHECKBOX',
  p_lov_query=> '.'||to_char(4992521041932439 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4992616669932439.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>4992521041932439.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Oui',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no_returns_n_or_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6766513696658378.4402 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES_NO_RETURNS_N_OR_Y',
  p_lov_query=> '.'||to_char(6766513696658378 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6766813651658378.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6766513696658378.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Oui',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6767008938658378.4402 + wwv_flow_api.g_id_offset,
  p_lov_id=>6766513696658378.4402 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Non',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_.4402
prompt  ...PAGE .4402: zéro
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => .4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'zéro',
  p_step_title=> 'zéro',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162006',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'6061919243182570';

wwv_flow_api.create_page_plug (
  p_id=> 6069804183216033.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_plug_name=> 'Application Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_07',
  p_plug_source=> s,
  p_plug_source_type=> 6061919243182570 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<style>'||chr(10)||
'.apex_finderbar_left .formlayout label{font-size:12px !important;}'||chr(10)||
'</style>';

wwv_flow_api.create_page_plug (
  p_id=> 57192300745493742.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_plug_name=> 'css',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page .4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_1.440
prompt  ...PAGE 1.4402: Migrations d'application
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/appmgr_overview.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 1.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TS1',
  p_name   => 'Migrations d''application',
  p_step_title=> 'Migrations d''application',
  p_step_sub_title => 'Page 1',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'ON',
  p_group_id => 5872827478268282+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162006',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4994514745932462.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_plug_name=> 'Breadcrumbs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> 'Unable to show breadcrumb.',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'5877721161285352';

wwv_flow_api.create_page_plug (
  p_id=> 5879119214294234.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 35485909554264791.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 5877721161285352 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select id, migration_name from ( select id,migration_name, last_updated_on from wwv_mig_projects where security_group_id = :FLOW_SECURITY_GROUP_ID order by last_updated_on desc ) where rownum <= 5';

wwv_flow_api.create_report_region (
  p_id=> 234201503744613519.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_name=> 'Récent',
  p_region_name=>'',
  p_template=> 35485909554264791.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_03',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'select 1 from wwv_mig_projects where rownum = 1',
  p_display_condition_type=> 'EXISTS',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'Y',
  p_query_row_template=> 71513117037862466.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'QUERY_COLUMNS',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'aucune donnée n''a été trouvée',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234201818939613530.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 234201503744613519.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 234201912175613530.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 234201503744613519.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'MIGRATION_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom de migration',
  p_column_link=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::P88_ID,MW_PROJ_ID,MW_MIG_TYPE:#ID#,#ID#,forms',
  p_column_linktext=>'#MIGRATION_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'  id,'||chr(10)||
'  MIGRATION_NAME "PROJECT NAME",'||chr(10)||
'  ''f?p=4400:''||decode(migration_type,''access'',2,51)||'||chr(10)||
'    '':''||:app_session||'||chr(10)||
'    '':''||decode(p.migration_type,''access'',''ST'','''')||'||chr(10)||
'    ''::RIR:MW_PROJ_ID,MW_MIG_TYPE,MW_SCHEMA:''||id||'||chr(10)||
'    '',''||migration_type||'',''||database_schema'||chr(10)||
'    edit_project_link,'||chr(10)||
'''f?p=4400:''||decode(migration_type,''access'',109,88)||'||chr(10)||
'    '':''||:app_session||'||chr(10)||
'    ''::NO:''||decode(mig';

s:=s||'ration_type,''access'',109,88)||'||chr(10)||
'    '':P''||decode(migration_type,''access'',109,88)||'||chr(10)||
'    ''_ID,MW_MIG_TYPE,MW_PROJ_ID:''||id||'||chr(10)||
'    '',''||migration_type||'',''||id'||chr(10)||
'    edit_project_icon_link,'||chr(10)||
'  p.MIGRATION_TYPE TYPE,'||chr(10)||
'  database_schema,'||chr(10)||
'  decode(sign(length(description) - 100), 1, substr(description, 1, 97) || ''...'',  description) description,'||chr(10)||
'  created_on,'||chr(10)||
'  created_by CREATED,'||chr(10)||
'  LAST_UPDATED_ON updated,'||chr(10)||
' ';

s:=s||' LAST_UPDATED_BY updated_by,'||chr(10)||
'  (select count(*) from wwv_mig_forms where project_id = p.id) imported_forms,'||chr(10)||
'  (select count(*) from wwv_mig_forms where project_id = p.id and SELECT_FOR_APP = ''Y'') included_forms,'||chr(10)||
'  (select f.id ||''. ''|| f.name from wwv_flows f '||chr(10)||
'   where f.id = p.generated_application_id'||chr(10)||
'   and security_group_id = :flow_security_group_id) app_name,'||chr(10)||
'  (select decode(build_status,''RUN';

s:=s||'_ONLY'',''f?p=4000:733:''||:app_session||''::::FB_FLOW_ID:''||id,'||chr(10)||
' ''f?p=4000:1:''||:app_session||'':::RIR:FB_FLOW_ID,F4000_P1_FLOW,P1_FIND,P0_FLOWPAGE,RECENT_PAGES:''||'||chr(10)||
'  id||'',''||id||'',,''||id||'';|''||'','') from wwv_flows where id = p.generated_application_id) app_link,'||chr(10)||
'         (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMMODULES fm,'||chr(10)||
'             WWV_MIG_FRM_TRIGGERS t,';

s:=s||''||chr(10)||
'             WWV_MIG_FORMS forms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              forms.project_id = p.id) +'||chr(10)||
'       (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMMODULES fm,'||chr(10)||
'             WWV_MIG_FRM_BLOCKS t,'||chr(10)||
'             WWV_MIG_FRM_BLK_TRIGGERS i,'||chr(10)||
'             WWV_MIG_FORMS fo';

s:=s||'rms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              t.id = i.block_id and'||chr(10)||
'              forms.project_id = p.id) +'||chr(10)||
'       (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMMODULES fm,'||chr(10)||
'             WWV_MIG_FRM_BLOCKS t,'||chr(10)||
'             WWV_MIG_FRM_BLK_ITEMS i,'||chr(10)||
'             WWV_MIG_FRM_B';

s:=s||'LK_ITEM_TRIGGERS it,'||chr(10)||
'             WWV_MIG_FORMS forms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              t.id = i.block_id and'||chr(10)||
'              i.id = it.item_id and'||chr(10)||
'              forms.project_id = p.id) all_triggers,'||chr(10)||
'       (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMMODULES fm,'||chr(10)||
' ';

s:=s||'            WWV_MIG_FRM_blocks t,'||chr(10)||
'             wwv_mig_frm_rev_blocks rb,'||chr(10)||
'             WWV_MIG_FORMS forms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              t.id = rb.block_id and'||chr(10)||
'              forms.project_id = p.id) blocks,'||chr(10)||
'       (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMM';

s:=s||'ODULES fm,'||chr(10)||
'             WWV_MIG_FRM_PROGRAMUNIT t,'||chr(10)||
'             WWV_MIG_FORMS forms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              forms.project_id = p.id) program_units,'||chr(10)||
'       (select count(*)'||chr(10)||
'        from   WWV_MIG_PLSQL_LIBS l'||chr(10)||
'        where  l.project_id = p.id'||chr(10)||
'        and    l.security_group_id = p.security_';

s:=s||'group_id) plls,'||chr(10)||
'       (select count(*)'||chr(10)||
'	from   WWV_MIG_FRM_MENUS m'||chr(10)||
'	where  m.project_id = p.id'||chr(10)||
'        and    m.security_group_id = p.security_group_id) menus,'||chr(10)||
'       (select count(*)'||chr(10)||
'        from   WWV_MIG_OLB l'||chr(10)||
'	where  l.project_id = p.id'||chr(10)||
'        and    l.security_group_id = p.security_group_id) olbs,'||chr(10)||
'       (select count(*)'||chr(10)||
'	from   WWV_MIG_RPTS l'||chr(10)||
'	where  l.project_id = p.id'||chr(10)||
'        and    l.se';

s:=s||'curity_group_id = p.security_group_id) reports'||chr(10)||
'from '||chr(10)||
'  WWV_MIG_PROJECTS p'||chr(10)||
'where '||chr(10)||
'  security_group_id = :flow_security_group_id ';

wwv_flow_api.create_page_plug (
  p_id=> 315094409194849040.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_plug_name=> 'Migration Projects (Detail View)',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'DYNAMIC_QUERY',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'select '||chr(10)||
'  id,'||chr(10)||
'  MIGRATION_NAME "PROJECT NAME",'||chr(10)||
'  ''f?p=4400:''||decode(migration_type,''access'',2,51)||'||chr(10)||
'    '':''||:app_session||'||chr(10)||
'    '':''||decode(p.migration_type,''access'',''ST'','''')||'||chr(10)||
'    ''::RIR:MW_PROJ_ID,MW_MIG_TYPE,MW_SCHEMA:''||id||'||chr(10)||
'    '',''||migration_type||'',''||database_schema'||chr(10)||
'    edit_project_link,'||chr(10)||
'''f?p=4400:''||decode(migration_type,''access'',109,88)||'||chr(10)||
'    '':''||:app_session||'||chr(10)||
'    ''::NO:''||decode(mig';

a1:=a1||'ration_type,''access'',109,88)||'||chr(10)||
'    '':P''||decode(migration_type,''access'',109,88)||'||chr(10)||
'    ''_ID,MW_MIG_TYPE,MW_PROJ_ID:''||id||'||chr(10)||
'    '',''||migration_type||'',''||id'||chr(10)||
'    edit_project_icon_link,'||chr(10)||
'  p.MIGRATION_TYPE TYPE,'||chr(10)||
'  database_schema,'||chr(10)||
'  decode(sign(length(description) - 100), 1, substr(description, 1, 97) || ''...'',  description) description,'||chr(10)||
'  created_on,'||chr(10)||
'  created_by CREATED,'||chr(10)||
'  LAST_UPDATED_ON updated,'||chr(10)||
' ';

a1:=a1||' LAST_UPDATED_BY updated_by,'||chr(10)||
'  (select count(*) from wwv_mig_forms where project_id = p.id) imported_forms,'||chr(10)||
'  (select count(*) from wwv_mig_forms where project_id = p.id and SELECT_FOR_APP = ''Y'') included_forms,'||chr(10)||
'  (select f.id ||''. ''|| f.name from wwv_flows f '||chr(10)||
'   where f.id = p.generated_application_id'||chr(10)||
'   and security_group_id = :flow_security_group_id) app_name,'||chr(10)||
'  (select decode(build_status,''RUN';

a1:=a1||'_ONLY'',''f?p=4000:733:''||:app_session||''::::FB_FLOW_ID:''||id,'||chr(10)||
' ''f?p=4000:1:''||:app_session||'':::RIR:FB_FLOW_ID,F4000_P1_FLOW,P1_FIND,P0_FLOWPAGE,RECENT_PAGES:''||'||chr(10)||
'  id||'',''||id||'',,''||id||'';|''||'','') from wwv_flows where id = p.generated_application_id) app_link,'||chr(10)||
'         (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMMODULES fm,'||chr(10)||
'             WWV_MIG_FRM_TRIGGERS t,';

a1:=a1||''||chr(10)||
'             WWV_MIG_FORMS forms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              forms.project_id = p.id) +'||chr(10)||
'       (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMMODULES fm,'||chr(10)||
'             WWV_MIG_FRM_BLOCKS t,'||chr(10)||
'             WWV_MIG_FRM_BLK_TRIGGERS i,'||chr(10)||
'             WWV_MIG_FORMS fo';

a1:=a1||'rms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              t.id = i.block_id and'||chr(10)||
'              forms.project_id = p.id) +'||chr(10)||
'       (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMMODULES fm,'||chr(10)||
'             WWV_MIG_FRM_BLOCKS t,'||chr(10)||
'             WWV_MIG_FRM_BLK_ITEMS i,'||chr(10)||
'             WWV_MIG_FRM_B';

a1:=a1||'LK_ITEM_TRIGGERS it,'||chr(10)||
'             WWV_MIG_FORMS forms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              t.id = i.block_id and'||chr(10)||
'              i.id = it.item_id and'||chr(10)||
'              forms.project_id = p.id) all_triggers,'||chr(10)||
'       (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMMODULES fm,'||chr(10)||
' ';

a1:=a1||'            WWV_MIG_FRM_blocks t,'||chr(10)||
'             wwv_mig_frm_rev_blocks rb,'||chr(10)||
'             WWV_MIG_FORMS forms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              t.id = rb.block_id and'||chr(10)||
'              forms.project_id = p.id) blocks,'||chr(10)||
'       (select count(*)'||chr(10)||
'        from WWV_MIG_FRM_MODULES m,'||chr(10)||
'             WWV_MIG_FRM_FORMM';

a1:=a1||'ODULES fm,'||chr(10)||
'             WWV_MIG_FRM_PROGRAMUNIT t,'||chr(10)||
'             WWV_MIG_FORMS forms'||chr(10)||
'        where m.file_id = forms.id and'||chr(10)||
'              m.id = fm.module_id and'||chr(10)||
'              fm.id = t.formmodule_id and'||chr(10)||
'              forms.project_id = p.id) program_units,'||chr(10)||
'       (select count(*)'||chr(10)||
'        from   WWV_MIG_PLSQL_LIBS l'||chr(10)||
'        where  l.project_id = p.id'||chr(10)||
'        and    l.security_group_id = p.security_';

a1:=a1||'group_id) plls,'||chr(10)||
'       (select count(*)'||chr(10)||
'	from   WWV_MIG_FRM_MENUS m'||chr(10)||
'	where  m.project_id = p.id'||chr(10)||
'        and    m.security_group_id = p.security_group_id) menus,'||chr(10)||
'       (select count(*)'||chr(10)||
'        from   WWV_MIG_OLB l'||chr(10)||
'	where  l.project_id = p.id'||chr(10)||
'        and    l.security_group_id = p.security_group_id) olbs,'||chr(10)||
'       (select count(*)'||chr(10)||
'	from   WWV_MIG_RPTS l'||chr(10)||
'	where  l.project_id = p.id'||chr(10)||
'        and    l.se';

a1:=a1||'curity_group_id = p.security_group_id) reports'||chr(10)||
'from '||chr(10)||
'  WWV_MIG_PROJECTS p'||chr(10)||
'where '||chr(10)||
'  security_group_id = :flow_security_group_id ';

wwv_flow_api.create_worksheet(
  p_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id => 1.4402,
  p_region_id => 315094409194849040.4402+wwv_flow_api.g_id_offset,
  p_name => 'Migration Projects (Detail View)',
  p_folder_id => null, 
  p_alias => '',
  p_report_id_item => '',
  p_max_row_count => '10000',
  p_max_row_count_message => 'Cette interrogation renvoie plus de 10 000 lignes. Filtrez vos données pour être sûr d''obtenir des résultats complets.',
  p_no_data_found_message => 'Aucune donnée n''a été trouvée.',
  p_max_rows_per_page    => '',
  p_search_button_label  => '',
  p_page_items_to_submit => '',
  p_sort_asc_image       => '',
  p_sort_asc_image_attr  => '',
  p_sort_desc_image      => '',
  p_sort_desc_image_attr => '',
  p_sql_query => a1,
  p_status                    =>'AVAILABLE_FOR_OWNER',
  p_allow_report_saving       =>'Y',
  p_allow_report_categories   =>'N',
  p_pagination_type           =>'ROWS_X_TO_Y',
  p_pagination_display_pos    =>'BOTTOM_RIGHT',
  p_button_template=> .4402+wwv_flow_api.g_id_offset,
  p_show_finder_drop_down     =>'Y',
  p_show_display_row_count    =>'Y',
  p_show_search_bar           =>'Y',
  p_show_search_textbox       =>'Y',
  p_show_actions_menu         =>'Y',
  p_report_list_mode          =>'TABS',
  p_show_detail_link          =>'N',
  p_show_select_columns       =>'Y',
  p_show_filter               =>'Y',
  p_show_sort                 =>'Y',
  p_show_control_break        =>'Y',
  p_show_highlight            =>'Y',
  p_show_computation          =>'Y',
  p_show_aggregate            =>'Y',
  p_show_chart                =>'Y',
  p_show_calendar             =>'N',
  p_show_flashback            =>'Y',
  p_show_reset                =>'Y',
  p_show_download             =>'Y',
  p_show_help            =>'Y',
  p_download_formats          =>'CSV',
  p_allow_exclude_null_values =>'N',
  p_allow_hide_extra_columns  =>'N',
  p_owner                     =>'MIKE');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315094723027849047.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ID',
  p_display_order          =>1,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'A',
  p_column_label           =>'Modifier',
  p_report_label           =>'Modifier',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'#EDIT_PROJECT_ICON_LINK#',
  p_column_linktext        =>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="">',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'N',
  p_allow_filtering        =>'N',
  p_allow_ctrl_breaks      =>'N',
  p_allow_aggregations     =>'N',
  p_allow_computations     =>'N',
  p_allow_charting         =>'N',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'WITHOUT_MODIFICATION',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315094819567849048.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROJECT NAME',
  p_display_order          =>2,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'B',
  p_column_label           =>'Nom de projet',
  p_report_label           =>'Nom de projet',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'#EDIT_PROJECT_LINK#',
  p_column_linktext        =>'#PROJECT NAME#',
  p_column_link_attr       =>'title="#PROJECT NAME#"',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315094929498849048.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'TYPE',
  p_display_order          =>3,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'C',
  p_column_label           =>'Type',
  p_report_label           =>'Type',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315269120548884847.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'APP_NAME',
  p_display_order          =>4,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'N',
  p_column_label           =>'Application',
  p_report_label           =>'Application',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'#APP_LINK#',
  p_column_linktext        =>'#APP_NAME#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315095003211849048.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'DATABASE_SCHEMA',
  p_display_order          =>5,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'D',
  p_column_label           =>'Schéma',
  p_report_label           =>'Schéma',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315095123549849048.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'DESCRIPTION',
  p_display_order          =>6,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'E',
  p_column_label           =>'Description',
  p_report_label           =>'Description',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315099708437890161.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'IMPORTED_FORMS',
  p_display_order          =>7,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'H',
  p_column_label           =>'Panneaux importés',
  p_report_label           =>'Panneaux importés',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315106521353026343.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'EDIT_PROJECT_LINK',
  p_display_order          =>8,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'K',
  p_column_label           =>'Lien de modification du projet',
  p_report_label           =>'Lien de modification du projet',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315209501368903267.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'INCLUDED_FORMS',
  p_display_order          =>9,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'M',
  p_column_label           =>'Panneaux',
  p_report_label           =>'Panneaux',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:51:&SESSION.::&DEBUG.::MW_PROJ_ID:#ID#',
  p_column_linktext        =>'#INCLUDED_FORMS#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_format_mask            =>'999G999G999G999G999G999G990',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315271617235044706.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'APP_LINK',
  p_display_order          =>10,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'O',
  p_column_label           =>'Lien d''application',
  p_report_label           =>'Lien d''application',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 321446706889030939.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ALL_TRIGGERS',
  p_display_order          =>11,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'P',
  p_column_label           =>'Déclencheurs',
  p_report_label           =>'Déclencheurs',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:93:&SESSION.::&DEBUG.:RIR:MW_PROJ_ID:#ID#',
  p_column_linktext        =>'#ALL_TRIGGERS#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_format_mask            =>'999G999G999G999G999G999G990',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 321448000487066876.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'BLOCKS',
  p_display_order          =>12,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'Q',
  p_column_label           =>'Blocs',
  p_report_label           =>'Blocs',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.:RIR,54:MW_PROJ_ID:#ID#',
  p_column_linktext        =>'#BLOCKS#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_format_mask            =>'999G999G999G999G999G999G990',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 321450408715088146.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROGRAM_UNITS',
  p_display_order          =>13,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'R',
  p_column_label           =>'Unités de <br />programme',
  p_report_label           =>'Unités de <br />programme',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:69:&SESSION.::&DEBUG.:RIR:MW_PROJ_ID:#ID#',
  p_column_linktext        =>'#PROGRAM_UNITS#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_format_mask            =>'999G999G999G999G999G999G990',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 71517021240949505.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PLLS',
  p_display_order          =>14,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'S',
  p_column_label           =>'PLL',
  p_report_label           =>'PLL',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:90:&SESSION.::&DEBUG.:RIR:MW_PROJ_ID:#ID#',
  p_column_linktext        =>'#PLLS#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 104443423787234843.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'MENUS',
  p_display_order          =>15,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'U',
  p_column_label           =>'MMB',
  p_report_label           =>'MMB',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:120:&SESSION.::&DEBUG.::MW_PROJ_ID:#ID#',
  p_column_linktext        =>'#MENUS#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 128365518899401801.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'OLBS',
  p_display_order          =>16,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'V',
  p_column_label           =>'Fichiers .OLB',
  p_report_label           =>'Fichiers .OLB',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:123:&SESSION.::&DEBUG.:RIR:MW_PROJ_ID:#ID#',
  p_column_linktext        =>'#OLBS#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 75213304113023012.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'REPORTS',
  p_display_order          =>17,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'T',
  p_column_label           =>'Etats',
  p_report_label           =>'Etats',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_column_link            =>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.::MW_PROJ_ID:#ID#',
  p_column_linktext        =>'#REPORTS#',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315095327888849052.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'CREATED',
  p_display_order          =>19,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'G',
  p_column_label           =>'Création par',
  p_report_label           =>'Création par',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315105426801971112.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'UPDATED',
  p_display_order          =>20,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'I',
  p_column_label           =>'Mis à jour',
  p_report_label           =>'Mis à jour',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'DATE',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_format_mask            =>'SINCE',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315105508017971113.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'UPDATED_BY',
  p_display_order          =>21,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'J',
  p_column_label           =>'Mis à jour <br />par',
  p_report_label           =>'Mis à jour <br />par',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 229075224646348513.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'CREATED_ON',
  p_display_order          =>22,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'W',
  p_column_label           =>'Créé',
  p_report_label           =>'Créé',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'DATE',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 245563223415625781.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 315094518129849040.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'EDIT_PROJECT_ICON_LINK',
  p_display_order          =>23,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'X',
  p_column_label           =>'Lien d''icône de modification du projet',
  p_report_label           =>'Lien d''icône de modification du projet',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Cliquez sur le bouton <b>Créer un projet</b> pour démarrer. Pour visualiser et suivre la migration Access ou la progression de la conversion de panneaux, cliquez sur le nom de projet.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 315211521023927797.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4402,
  p_plug_name=> 'Initiation',
  p_region_name=>'',
  p_plug_template=> 86904609451444726.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 5160704939571862.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 315094409194849040+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_image_alt=> 'Créer un projet &gt;',
  p_button_position=> 'RIGHT_OF_IR_SEARCH_BAR',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:3:P3_TYPE:forms',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>5093404006195831.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4402,
  p_branch_action=> 'f?p=&FLOW_ID.:1:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 5045106990995277.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'COMPANY',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'wwv_flow.get_company_name;',
  p_computation_error_message => 'Impossible de calculer le nom de l''espace de travail.',
  p_compute_when => 'COMPANY',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 322237519113604597.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'F4400_LAST_VIEW',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '1',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 5906424933333777.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>5093213550195829.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_2.440
prompt  ...PAGE 2.4402: Projet de migration
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_proj_page.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 2.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Projet de migration',
  p_step_title=> 'Projet de migration : &P2_MIGRATION_PROJECT. ',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12491335804135281.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162007',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>2.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5153803283476753.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'5333829890130844';

wwv_flow_api.create_page_plug (
  p_id=> 5335318939137131.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4402,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 35485909554264791.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 3,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 5333829890130844 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5336409851153412.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4402,
  p_plug_name=> 'Projet',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'DECLARE'||chr(10)||
''||chr(10)||
'  l_sum_tbls    number   := 0;'||chr(10)||
'  l_sum_qrys    number   := 0;'||chr(10)||
'  l_sum_frms    number   := 0;'||chr(10)||
'  l_sum_rpts    number   := 0;'||chr(10)||
'  l_cnt_mdbs    number   := 0;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'-- example of sm: htp.p(wwv_flow_lang.system_message(''Application''));'||chr(10)||
'htp.p(''<table cellpadding="0" cellspacing="0" border="0" class="htmldbStandard3" summary="">'');'||chr(10)||
'htp.p(''<tr><td></td><td align="left"><B>''||wwv_flow_lang.syste';

s:=s||'m_message(''OBJECTS'')||''</B></a></td><td align="right"><b>''||wwv_flow_lang.system_message(''COUNT'')||''</b></td><td><b>''||wwv_flow_lang.system_message(''VALID'')||''</b></td><td><b>''||wwv_flow_lang.system_message(''F4400_P2_INVALID'')||''</b></td><td><b>''||wwv_flow_lang.system_message(''F4400_P2_INCLUDED'')||''</b></td></tr>'');'||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- Table Header Information'||chr(10)||
'--'||chr(10)||
''||chr(10)||
'for c1 in '||chr(10)||
'('||chr(10)||
'   select distinct count(*) cnt'||chr(10)||
' ';

s:=s||'  from   wwv_mig_access'||chr(10)||
'   where  PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and    security_group_id = :flow_security_group_id'||chr(10)||
') '||chr(10)||
'LOOP '||chr(10)||
''||chr(10)||
' if :P2_DATABASE <> 0 then'||chr(10)||
'  l_cnt_mdbs := 1;'||chr(10)||
' else'||chr(10)||
'  l_cnt_mdbs := c1.cnt;'||chr(10)||
' end if;'||chr(10)||
' '||chr(10)||
'   '||chr(10)||
'htp.p(''<tr><td><img src="#IMAGE_PREFIX#migration/xm_db.gif"></td><td align="left"><a href="f?p=4400:13:&SESSION.::&DEBUG." title=''||wwv_flow_lang.system_message(''F4400_P2_DATABASES'')||''>';

s:=s||'''||wwv_flow_lang.system_message(''F4400_P2_DATABASES'')||''</a></td><td align="right">''||l_cnt_mdbs||''</td><td align="center"></td><td align="center"></td><td '||chr(10)||
'align="center"></td></tr>'');'||chr(10)||
''||chr(10)||
'END LOOP;'||chr(10)||
''||chr(10)||
'-- '||chr(10)||
'-- Count of Access table objects'||chr(10)||
'--'||chr(10)||
'for c1 in '||chr(10)||
'('||chr(10)||
'   select distinct count(*) cnt'||chr(10)||
'   from   wwv_mig_acc_tables a, wwv_mig_access b'||chr(10)||
'   where  a.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and    a.PROJECT_ID = b.PROJ';

s:=s||'ECT_ID'||chr(10)||
'   and  ( a.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'   and    a.dbid = b.dbid'||chr(10)||
'   and    a.security_group_id = :flow_security_group_id'||chr(10)||
'   and    a.security_group_id = b.security_group_id'||chr(10)||
')'||chr(10)||
'LOOP'||chr(10)||
''||chr(10)||
'if (c1.cnt > 0) then'||chr(10)||
'   htp.p(''<tr><td><img src="#IMAGE_PREFIX#migration/xm_table.gif"></td><td align="left"><a href="f?p=4400:9:&SESSION.::&DEBUG.:RP:P9_DBI';

s:=s||'D:&P2_DBID." title="&TABLES.">&TABLES.</a></td><td align="right">''||c1.cnt||''</td>''); '||chr(10)||
'   '||chr(10)||
'   --'||chr(10)||
'   -- Count of valid and invalid Oracle table objects'||chr(10)||
'   --'||chr(10)||
'   for c2 in '||chr(10)||
'   ('||chr(10)||
'select '||chr(10)||
'      count(decode( f.status,''VALID'',1))  '||chr(10)||
'       -count(decode(f.status,''VALID'',decode(h.constraint_type,null,1))) valid,'||chr(10)||
'    '||chr(10)||
'      count(decode( f.status,''INVALID'',1)) '||chr(10)||
'       +count(decode(f.status,null,1))'||chr(10)||
'     ';

s:=s||'+count(decode(f.status,''VALID'',decode(h.constraint_type,null,1))) invalid'||chr(10)||
''||chr(10)||
'from (((('||chr(10)||
''||chr(10)||
'       wwv_mig_acc_tables a LEFT OUTER JOIN sys.dba_tables b '||chr(10)||
'       on UPPER(SUBSTR(a.tblname,0,30)) LIKE UPPER(b.table_name)'||chr(10)||
'       and b.owner = UPPER(:P2_SCHEMA))'||chr(10)||
' '||chr(10)||
'       LEFT JOIN sys.dba_objects f'||chr(10)||
'       on UPPER(SUBSTR(a.tblname,0,30)) LIKE UPPER(f.object_name)'||chr(10)||
'       and f.object_type = ''TABLE'''||chr(10)||
'       an';

s:=s||'d f.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'       and f.owner = b.owner)'||chr(10)||
''||chr(10)||
'      LEFT JOIN wwv_mig_rev_tables g'||chr(10)||
'       on UPPER(a.tblname) LIKE UPPER(g.orig_table_name)'||chr(10)||
'       and g.project_id = a.project_id'||chr(10)||
'       and g.security_group_id = a.security_group_id'||chr(10)||
'      AND g.dbid = a.dbid)'||chr(10)||
''||chr(10)||
'      LEFT JOIN sys.dba_constraints h'||chr(10)||
'      on UPPER(b.table_name) LIKE UPPER(h.table_name)'||chr(10)||
'      and h.constraint_type = ''P''';

s:=s||''||chr(10)||
'      and h.owner = UPPER(:P2_SCHEMA))   '||chr(10)||
''||chr(10)||
'      where  a.project_id = :MW_PROJ_ID'||chr(10)||
'      and    a.security_group_id = :flow_security_group_id'||chr(10)||
'      and  ( a.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'   ) '||chr(10)||
'   LOOP'||chr(10)||
'   '||chr(10)||
'     -- Bug 5614257 check for no associated schema when sql script loaded'||chr(10)||
'     if (c2.valid < 0) then'||chr(10)||
'       l_sum_tbls := c2.invalid + c2.val';

s:=s||'id;'||chr(10)||
'       htp.p(''<td align="right">''||0||''</td><td align="right">''||l_sum_tbls||''</td>'');'||chr(10)||
'     else'||chr(10)||
'       htp.p(''<td align="right">''||c2.valid||''</td><td align="right">''||c2.invalid||''</td>'');'||chr(10)||
'     end if;'||chr(10)||
''||chr(10)||
'   END LOOP;'||chr(10)||
''||chr(10)||
'  --'||chr(10)||
'  -- Count of included table items'||chr(10)||
'  --'||chr(10)||
'  for c3 in '||chr(10)||
'  ('||chr(10)||
'       select distinct count(status) cnt from wwv_mig_rev_tables'||chr(10)||
'       where project_id = :MW_PROJ_ID'||chr(10)||
'       and  ';

s:=s||'( dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'       and status = ''INCLUDE'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'  htp.p(''<td align="right">''||c3.cnt||''</td></tr>'');'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'END LOOP; '||chr(10)||
''||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- Count of Access query objects'||chr(10)||
'--'||chr(10)||
'for c1 in'||chr(10)||
'('||chr(10)||
'   select distinct count(*) cnt'||chr(10)||
'   from   wwv_mig_acc_queries, wwv_mig_access'||chr(10)||
'   where  wwv_mig_acc_queries.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   ';

s:=s||'and    wwv_mig_acc_queries.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and    wwv_mig_acc_queries.DBID = wwv_mig_access.DBID'||chr(10)||
'   and  ( wwv_mig_acc_queries.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
')'||chr(10)||
'LOOP'||chr(10)||
'if (c1.cnt > 0) then'||chr(10)||
'   htp.p(''<tr><td><img src="#IMAGE_PREFIX#migration/xm_query.gif"></td><td align="left"><a href="f?p=4400:10:&SESSION.::&DEBUG.:RP:P10_DB';

s:=s||'ID:&P2_DBID." title="&QUERIES.">&QUERIES.</a></td><td align="right">''||c1.cnt||''</td>'');'||chr(10)||
'   '||chr(10)||
'   --'||chr(10)||
'   -- Count of valid and invalid Oracle view objects'||chr(10)||
'   --'||chr(10)||
'   for c2 in'||chr(10)||
'   ('||chr(10)||
'     select count(decode(h.status,''VALID'',1)) valid,'||chr(10)||
'           (count(decode(h.status,''INVALID'',1))+'||chr(10)||
'            count(decode(h.status,null,1))) invalid      '||chr(10)||
'     from (('||chr(10)||
'       wwv_mig_acc_queries a LEFT JOIN wwv_mig_rev_';

s:=s||'queries i'||chr(10)||
'       on a.project_id = i.project_id'||chr(10)||
'       and a.dbid = i.dbid'||chr(10)||
'       and a.qryid = i.qryid)'||chr(10)||
''||chr(10)||
'       LEFT JOIN sys.dba_objects h'||chr(10)||
'       on UPPER(h.object_name) = UPPER(i.mig_view_name)'||chr(10)||
'       and h.owner = UPPER(:P2_SCHEMA))'||chr(10)||
'       '||chr(10)||
'       where a.project_id = :MW_PROJ_ID'||chr(10)||
'       and a.security_group_id =  :flow_security_group_id'||chr(10)||
'       and ( a.dbid = htf.escape_sc(:P2_DATABASE) or nvl(';

s:=s||'htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'   )'||chr(10)||
'   LOOP'||chr(10)||
'     if (c2.valid < 0) then'||chr(10)||
'        l_sum_qrys := c2.invalid + c2.valid;'||chr(10)||
'   htp.p(''<td align="right">''||0||''</td><td align="right">''||l_sum_qrys||''</td>'');'||chr(10)||
'     else'||chr(10)||
'        htp.p(''<td align="right">''||c2.valid||''</td><td align="right">''||c2.invalid||''</td>'');'||chr(10)||
'     end if;'||chr(10)||
'   END LOOP;'||chr(10)||
''||chr(10)||
'  --'||chr(10)||
'  -- Count of included items'||chr(10)||
'  --'||chr(10)||
'  for c3 in '||chr(10)||
'  ('||chr(10)||
'   ';

s:=s||'    select distinct count(status) cnt from wwv_mig_rev_queries'||chr(10)||
'       where project_id = :MW_PROJ_ID'||chr(10)||
'       and  ( dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'       and status = ''INCLUDE'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'  htp.p(''<td align="right">''||c3.cnt||''</td></tr>'');'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'end if;'||chr(10)||
'END LOOP;  '||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- Count of Form objects'||chr(10)||
'--'||chr(10)||
'for c1 in '||chr(10)||
'('||chr(10)||
'   select distinct count(*) c';

s:=s||'nt'||chr(10)||
'   from   wwv_mig_acc_forms, wwv_mig_access'||chr(10)||
'   where  wwv_mig_acc_forms.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and    wwv_mig_acc_forms.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and    wwv_mig_acc_forms.DBID = wwv_mig_access.DBID'||chr(10)||
'   and  ( wwv_mig_acc_forms.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
')'||chr(10)||
'LOOP'||chr(10)||
'if (c1.cnt > 0) then'||chr(10)||
'   htp.p(''<tr><td><img src="#IMAGE_PREFI';

s:=s||'X#migration/xm_form.gif"></td><td align="left"><a href="f?p=4400:8:&SESSION.::&DEBUG.:RP:" title="&FORMS.">&FORMS.</a></td><td align="right">''||c1.cnt||''</td>'');'||chr(10)||
''||chr(10)||
'   --'||chr(10)||
'   -- Count of valid and invalid Form objects, based on valid recordsources'||chr(10)||
'   --'||chr(10)||
'   for c2 in'||chr(10)||
'   ('||chr(10)||
'       select count(decode(h.status,''VALID'',1))+ count(decode(h.status,null,decode(i.source_status,''VALID'',1))) valid,'||chr(10)||
'            ';

s:=s||'  (count(decode(h.status,''INVALID'',1))+ count(decode(h.status,null,decode(i.source_status,''INVALID'',1,null,1)))) invalid      '||chr(10)||
'from (('||chr(10)||
'       wwv_mig_acc_forms a LEFT JOIN wwv_mig_rev_forms i'||chr(10)||
'       on a.project_id = i.project_id'||chr(10)||
'       and a.dbid = i.dbid'||chr(10)||
'       and a.formid = i.formid)'||chr(10)||
''||chr(10)||
'       LEFT JOIN sys.dba_objects h'||chr(10)||
'       on UPPER(h.object_name) = UPPER(i.source_name)'||chr(10)||
'       and h.owner = ';

s:=s||'UPPER(:P2_SCHEMA))'||chr(10)||
'       '||chr(10)||
'       where a.project_id = :MW_PROJ_ID'||chr(10)||
'       and a.security_group_id =  :flow_security_group_id'||chr(10)||
'       and ( a.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'   )'||chr(10)||
'   LOOP'||chr(10)||
'     if (c2.valid < 0) then'||chr(10)||
'       l_sum_frms := c2.invalid + c2.valid;'||chr(10)||
'       htp.p(''<td align="right">''||0||''</td><td align="right">''||l_sum_frms||''</td>'');'||chr(10)||
'     e';

s:=s||'lse'||chr(10)||
'       htp.p(''<td align="right">''||c2.valid||''</td><td align="right">''||c2.invalid||''</td>'');'||chr(10)||
'     end if;'||chr(10)||
'   END LOOP;'||chr(10)||
'  '||chr(10)||
'  -- '||chr(10)||
'  -- Count of excluded objects'||chr(10)||
'  --  '||chr(10)||
'  for c3 in '||chr(10)||
'  ('||chr(10)||
'       select distinct count(status) cnt from wwv_mig_rev_forms'||chr(10)||
'       where project_id = :MW_PROJ_ID'||chr(10)||
'       and ( dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'       and stat';

s:=s||'us = ''INCLUDE'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'  htp.p(''<td align="right">''||c3.cnt||''</td></tr>'');'||chr(10)||
'  END LOOP;   '||chr(10)||
''||chr(10)||
''||chr(10)||
'end if;'||chr(10)||
'END LOOP; '||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- Count of Report objects'||chr(10)||
'--'||chr(10)||
'for c1 in '||chr(10)||
'('||chr(10)||
'   select count(*) cnt'||chr(10)||
'   from   wwv_mig_acc_reports, wwv_mig_access'||chr(10)||
'   where  wwv_mig_acc_reports.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and    wwv_mig_acc_reports.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and    wwv_mig_acc_reports.DBID = wwv_mig_';

s:=s||'access.DBID'||chr(10)||
'   and  ( wwv_mig_acc_reports.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
')'||chr(10)||
'LOOP'||chr(10)||
'if (c1.cnt > 0) then'||chr(10)||
'   htp.p(''<tr><td><img src="#IMAGE_PREFIX#migration/xm_report.gif"></td><td align="left"><a href="f?p=4400:20:&SESSION.::&DEBUG.:RP:P20_DBID:&P2_DBID." title=''||wwv_flow_lang.system_message(''QUICK_APP_REPORTS'')||''>''||wwv_flow_lang.system_message(''Q';

s:=s||'UICK_APP_REPORTS'')||''</a></td><td align="right">''||c1.cnt||''</td>'');'||chr(10)||
''||chr(10)||
'   --'||chr(10)||
'   -- Count of valid and invalid Report objects, based on valid recordsources'||chr(10)||
'   --'||chr(10)||
'   for c2 in'||chr(10)||
'   ('||chr(10)||
'       select count(decode(h.status,''VALID'',1))+ count(decode(h.status,null,decode(i.source_status,''VALID'',1))) valid,'||chr(10)||
'              (count(decode(h.status,''INVALID'',1))+ count(decode(h.status,null,decode(i.source_status,''';

s:=s||'INVALID'',1,null,1)))) invalid     '||chr(10)||
'from (('||chr(10)||
'       wwv_mig_acc_reports a LEFT JOIN wwv_mig_rev_reports i'||chr(10)||
'       on a.project_id = i.project_id'||chr(10)||
'       and a.dbid = i.dbid'||chr(10)||
'       and a.reportid = i.reportid)'||chr(10)||
''||chr(10)||
'       LEFT JOIN sys.dba_objects h'||chr(10)||
'       on UPPER(h.object_name) = UPPER(i.source_name)'||chr(10)||
'       and h.owner = UPPER(:P2_SCHEMA))'||chr(10)||
'       '||chr(10)||
'       where a.project_id = :MW_PROJ_ID'||chr(10)||
'       and a.secu';

s:=s||'rity_group_id =  :flow_security_group_id'||chr(10)||
'       and ( a.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'   )'||chr(10)||
'   LOOP'||chr(10)||
'     if (c2.valid < 0) then'||chr(10)||
'       l_sum_rpts := c2.invalid + c2.valid;'||chr(10)||
'   htp.p(''<td align="right">''||0||''</td><td align="right">''||l_sum_rpts||''</td>'');'||chr(10)||
'     else'||chr(10)||
'   htp.p(''<td align="right">''||c2.valid||''</td><td align="right">''||c2.invalid||''</t';

s:=s||'d>'');'||chr(10)||
'     end if;'||chr(10)||
'   END LOOP;'||chr(10)||
''||chr(10)||
'  --  '||chr(10)||
'  -- Count of excluded objects'||chr(10)||
'  -- '||chr(10)||
'  for c3 in '||chr(10)||
'  ('||chr(10)||
'       select distinct count(status) cnt from wwv_mig_rev_reports'||chr(10)||
'       where project_id = :MW_PROJ_ID'||chr(10)||
'       and ( dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'       and status = ''INCLUDE'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'  htp.p(''<td align="right">''||c3.cnt||''</td></tr>'');'||chr(10)||
'  END LOOP;  ';

s:=s||' '||chr(10)||
''||chr(10)||
''||chr(10)||
'end if;'||chr(10)||
'END LOOP;  '||chr(10)||
''||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- Count of modules'||chr(10)||
'--'||chr(10)||
'for c1 in'||chr(10)||
'('||chr(10)||
'   select count(*) cnt'||chr(10)||
'   from   wwv_mig_acc_modules, wwv_mig_access'||chr(10)||
'   where  wwv_mig_acc_modules.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and    wwv_mig_acc_modules.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and    wwv_mig_acc_modules.DBID = wwv_mig_access.DBID'||chr(10)||
'   and   (wwv_mig_acc_modules.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(';

s:=s||':P2_DATABASE),''0'') = ''0'')'||chr(10)||
')'||chr(10)||
'LOOP'||chr(10)||
''||chr(10)||
'if (c1.cnt > 0) then'||chr(10)||
'   htp.p(''<tr><td><img src="#IMAGE_PREFIX#migration/xm_module.gif"></td><td align="left"><a href="f?p=4400:15:&SESSION.::&DEBUG.::" title="&MODULES.">&MODULES.</a></td><td align="right">''||c1.cnt||''</td><td align="center"></td><td align="center"></td><td '||chr(10)||
'align="center"></td></tr>'');'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'END LOOP;  '||chr(10)||
''||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- Count of Pages'||chr(10)||
'--'||chr(10)||
'for c1 in'||chr(10)||
'('||chr(10)||
' ';

s:=s||'  select count(*) cnt'||chr(10)||
'   from   wwv_mig_acc_pages, wwv_mig_access'||chr(10)||
'   where  wwv_mig_acc_pages.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and    wwv_mig_acc_pages.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and    wwv_mig_acc_pages.DBID = wwv_mig_access.DBID'||chr(10)||
'   and   (wwv_mig_acc_pages.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
')'||chr(10)||
'LOOP'||chr(10)||
''||chr(10)||
'if (c1.cnt > 0) then'||chr(10)||
'   htp.p(''<tr><td><i';

s:=s||'mg src="#IMAGE_PREFIX#migration/xm_page.gif"></td><td align="left"><a href="f?p=4400:14:&SESSION.::&DEBUG.::" title=''||wwv_flow_lang.system_message(''CONFIRM.PAGES'')||''>''||wwv_flow_lang.system_message(''CONFIRM.PAGES'')||''</a>'||chr(10)||
'</td><td align="right">''||c1.cnt||''</td><td align="center"></td><td align="center"></td><td align="center"></td></tr>'');'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'END LOOP;  '||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'htp.p(''</table>'');'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 20836104170985684.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4402,
  p_plug_name=> 'Objets de base de données',
  p_region_name=>'',
  p_plug_template=> 244065612129731419.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 100,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'BEFORE_BOX_BODY',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_footer=> '<BR>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select distinct f.id, ''f?p=4000:1:''||:app_session||'||chr(10)||
'  '':::RP:FB_FLOW_ID,F4000_P1_FLOW,P1_FIND,RECENT_PAGES:''||'||chr(10)||
'  f.id||'',''||f.id||'',,'' link,'||chr(10)||
'  htf.escape_sc(f.name) name,'||chr(10)||
'  htf.escape_sc(f.owner) owner,'||chr(10)||
'  f.LAST_UPDATED_ON,'||chr(10)||
'  (select count(*) from wwv_flow_steps where flow_id = f.id) page_count,'||chr(10)||
'  f.id manage, f.last_updated_on updated,'||chr(10)||
'    lower(f.last_updated_by) last_updated_by,'||chr(10)||
'    ''<a href="''';

s:=s||'||'||chr(10)||
'    replace('||chr(10)||
'    replace('||chr(10)||
'    f.home_link,''&''||''APP_ID.'',f.id),''&''||''SESSION.'',:app_session)'||chr(10)||
'    ||''"><img src="#IMAGE_PREFIX#htmldb/icons/run_small.gif" border="0" alt="''||sm.run||''" title="''||sm.run||''"/></a>'' actions'||chr(10)||
'    '||chr(10)||
'from   wwv_flows f, wwv_mig_rev_apexapp r, (select wwv_flow_lang.system_message(''RUN'') run'||chr(10)||
'       from dual) sm'||chr(10)||
'where  '||chr(10)||
'       f.security_group_id = :flow_security_group_id';

s:=s||' and'||chr(10)||
'       f.build_status != ''RUN_ONLY'' and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id) and'||chr(10)||
'       ('||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :app_user and '||chr(10)||
'             flow_id is null and '||chr(10)||
'             security_group_id = :flow_security_g';

s:=s||'roup_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :app_user and '||chr(10)||
'             flow_id = f.id and '||chr(10)||
'             security_group_id = :flow_security_group_id))'||chr(10)||
'      and r.security_group_id = f.security_group_id'||chr(10)||
'      and r.project_id = :MW_PROJ_ID'||chr(10)||
'    --  and r.dbid = :P2_DBID'||chr(10)||
'      and r.flow_id = f.id';

wwv_flow_api.create_report_region (
  p_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4402,
  p_name=> 'Applications',
  p_region_name=>'',
  p_template=> 23957836075509199.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 130,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> '      select 1 from wwv_mig_rev_apexapp'||chr(10)||
'      where project_id = :MW_PROJ_ID'||chr(10)||
'      and security_group_id = :flow_security_group_id'||chr(10)||
'      and dbid = :P2_DBID or nvl(:P2_DBID,''0'') = ''0''',
  p_display_condition_type=> 'EXISTS',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune application n''a été trouvée.',
  p_query_num_rows_type=> 'ROWS_X_TO_Y_OF_Z',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31335728213126671.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Application',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31334816721126667.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> 'LINK',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31334926739126670.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Nom',
  p_column_link=>'#LINK#',
  p_column_linktext=>'#NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31335005219126670.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Parsing Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31335100902126671.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_UPDATED_ON',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Mis à jour',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31335232107126671.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_COUNT',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Nombre de pages',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31335317769126671.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'MANAGE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Manage',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31335423729126671.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'UPDATED',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Updated',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31335513031126671.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_UPDATED_BY',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Mis à jour par',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 31335614436126671.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 31334612409126602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'ACTIONS',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Exécuter',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>27900609722128412.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>28275820178855249.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>28275018661845397.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 01-DEC-2005 13:46 by HFARRELL');
 
wwv_flow_api.create_page_branch(
  p_id=>235495907933545527.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_branch_action=> 'f?p=&APP_ID.:33:&SESSION.:CC:&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 30,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-JUN-2006 10:42 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Nom du projet de migration.';

wwv_flow_api.create_page_item(
  p_id=>5344525612195800.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_MIGRATION_PROJECT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Projet de migration :',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 2,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Nom de la base de données associée au projet de migration.';

wwv_flow_api.create_page_item(
  p_id=>20835013390978915.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_DATABASE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&nbsp;Base de données :',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX_WITH_SUBMIT',
  p_lov => 'select htf.escape_sc(dbname) d, Dbid'||chr(10)||
'from   WWV_MIG_ACCESS '||chr(10)||
'where  project_id = :MW_PROJ_ID '||chr(10)||
'and    security_group_id = :flow_security_group_id'||chr(10)||
'order by dbid',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Tout -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>26754117783100430.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_MIGRATION_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Migration ID',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27017012676781212.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_DBCOUNT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'DB Count:',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27890714992048831.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_VIEW',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'ICON',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Vue',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'ICON DETAIL VIEW MODES',
  p_lov => '.'||to_char(28047631397181065 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27894932700082272.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'5',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27931126139949504.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>29167017216959565.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_RESULT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>29470722539652141.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_FILE_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'File Id',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>109097022215624158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>778591126383644046.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_name=>'P2_DBID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 5336409851153412.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'dbid',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 245570002140808870.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 1,
  p_computation_item=> 'F4400_LAST_VIEW',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '2',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 28381117116595979.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 5,
  p_computation_item=> 'P2_DBCOUNT',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '   select count(dbid) cnt from wwv_mig_access'||chr(10)||
'   where project_id = :MW_PROJ_ID'||chr(10)||
'   and security_group_id = :flow_security_group_id;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 20858619462134550.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 9,
  p_computation_item=> 'P2_MIGRATION_PROJECT',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select migration_name'||chr(10)||
'from   WWV_MIG_PROJECTS'||chr(10)||
'where  id = :MW_PROJ_ID and'||chr(10)||
'       security_group_id = :flow_security_group_id'||chr(10)||
'order  by 1',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 46667126470832489.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'P2_DATABASE',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'ITEM_VALUE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '0',
  p_compute_when => 'ST',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 239364406149947477.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'P2_DBID',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
' l_ans number := 0;'||chr(10)||
' l_val number := 6;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  if :P2_DBCOUNT = 1 then'||chr(10)||
'  '||chr(10)||
'    select DBID into l_ans'||chr(10)||
'    from   WWV_MIG_ACCESS '||chr(10)||
'    where  project_id = :MW_PROJ_ID'||chr(10)||
'    and    security_group_id = :flow_security_group_id;'||chr(10)||
'  '||chr(10)||
'  else  '||chr(10)||
'    l_ans := htf.escape_sc(:P2_DATABASE);'||chr(10)||
'  end if;'||chr(10)||
'  '||chr(10)||
'  return l_ans;'||chr(10)||
'  '||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 239305907076389411.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 11,
  p_computation_item=> 'P2_MIGRATION_ID',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select ID'||chr(10)||
'from   WWV_MIG_PROJECTS'||chr(10)||
'where  id = :MW_PROJ_ID and'||chr(10)||
'       security_group_id = :flow_security_group_id'||chr(10)||
'order  by 1',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 239259504512303530.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 12,
  p_computation_item=> 'P2_FILE_ID',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select ID'||chr(10)||
'FROM   WWV_FLOW_FILE_OBJECTS$'||chr(10)||
'WHERE  PATHID=:P2_MIGRATION_ID',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 239256830597169194.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 13,
  p_computation_item=> 'P2_SCHEMA',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select UPPER(database_schema) '||chr(10)||
'from   WWV_MIG_ACCESS '||chr(10)||
'where  project_id = :MW_PROJ_ID'||chr(10)||
'and    security_group_id = :flow_security_group_id',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 187312817479713564.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4402,
  p_computation_sequence => 20,
  p_computation_item=> 'MW_PROJ_NAME',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select migration_name from wwv_mig_projects'||chr(10)||
'where id = :MW_PROJ_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||chr(10)||
''||chr(10)||
'  for c1 in '||chr(10)||
'  ('||chr(10)||
'    select a.tblid tblid,'||chr(10)||
'           a.dbid dbid'||chr(10)||
'    from wwv_mig_rev_tables a LEFT JOIN sys.dba_objects b'||chr(10)||
'    on UPPER(SUBSTR(a.mig_table_name,0,30)) LIKE UPPER(b.object_name)'||chr(10)||
'    and b.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'    '||chr(10)||
'    where a.project_id = :MW_PROJ_ID'||chr(10)||
'    and  (a.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'    and a.status = ''INCLUDE';

p:=p||''''||chr(10)||
'    and b.status is null'||chr(10)||
'    and (b.object_type = ''TABLE'' or b.object_type is null)'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    update wwv_mig_rev_tables'||chr(10)||
'    set status = ''EXCLUDE'''||chr(10)||
'    where tblid = c1.tblid'||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and dbid = c1.dbid;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  '||chr(10)||
'  for c2 in '||chr(10)||
'  ('||chr(10)||
'    select distinct a.formid, a.dbid'||chr(10)||
'    from wwv_mig_rev_forms a, wwv_mig_re';

p:=p||'v_tables b LEFT JOIN sys.dba_tables c'||chr(10)||
'    on UPPER(SUBSTR(b.mig_table_name,0,30)) LIKE UPPER(c.table_name)'||chr(10)||
'    and c.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'    '||chr(10)||
'    where a.project_id = :MW_PROJ_ID'||chr(10)||
'    and a.security_group_id = :flow_security_group_id'||chr(10)||
'    and UPPER(a.source_name) LIKE UPPER(b.mig_table_name)'||chr(10)||
'    and b.project_id = a.project_id'||chr(10)||
'    and b.security_group_id = a.security_group_id'||chr(10)||
'    and a.dbid = ';

p:=p||'b.dbid'||chr(10)||
'    and a.source_type = ''TABLE'''||chr(10)||
'    and b.status = ''EXCLUDE'''||chr(10)||
'    and a.status = ''INCLUDE'''||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    update wwv_mig_rev_forms'||chr(10)||
'    set status = ''EXCLUDE'''||chr(10)||
'    where formid = c2.formid'||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and dbid = c2.dbid;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  for c3 in '||chr(10)||
'  ('||chr(10)||
'    select distinct a.reportid, a.dbid'||chr(10)||
'    from wwv_mig_rev_reports ';

p:=p||'a, wwv_mig_rev_tables b LEFT JOIN sys.dba_tables c'||chr(10)||
'    on UPPER(SUBSTR(b.mig_table_name,0,30)) LIKE UPPER(c.table_name)'||chr(10)||
'    and c.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'    '||chr(10)||
'    where a.project_id =  :MW_PROJ_ID'||chr(10)||
'    and a.security_group_id = :flow_security_group_id'||chr(10)||
'    and UPPER(a.source_name) LIKE UPPER(b.mig_table_name)'||chr(10)||
'    and b.project_id = a.project_id'||chr(10)||
'    and b.security_group_id = a.security_group_id'||chr(10)||
'   ';

p:=p||' and a.dbid = b.dbid'||chr(10)||
'    and a.source_type = ''TABLE'''||chr(10)||
'    and b.status = ''EXCLUDE'''||chr(10)||
'    and a.status = ''INCLUDE'''||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    update wwv_mig_rev_reports'||chr(10)||
'    set status = ''EXCLUDE'''||chr(10)||
'    where reportid = c3.reportid'||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and dbid = c3.dbid;'||chr(10)||
'  end loop;'||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 65744029837119336.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 70,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Update Inclusion Status for Tables',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'LOAD',
  p_process_when_type=>'REQUEST_NOT_EQUAL_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||chr(10)||
''||chr(10)||
'  for c1 in '||chr(10)||
'  ('||chr(10)||
'    select a.qryid, a.dbid'||chr(10)||
'    from wwv_mig_rev_queries a LEFT JOIN sys.dba_objects b'||chr(10)||
'    on UPPER(SUBSTR(a.mig_view_name,0,30)) LIKE UPPER(b.object_name)'||chr(10)||
'    and b.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'       '||chr(10)||
'    where a.project_id = :MW_PROJ_ID'||chr(10)||
'    and a.security_group_id = :flow_security_group_id'||chr(10)||
'    and (a.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') ';

p:=p||'= ''0'')'||chr(10)||
'    and a.status = ''INCLUDE'''||chr(10)||
'    and (b.status is NULL or b.status = ''INVALID'')'||chr(10)||
'    and (b.object_type = ''VIEW'' or b.object_type is null)'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    update wwv_mig_rev_queries'||chr(10)||
'    set status = ''EXCLUDE'''||chr(10)||
'    where qryid = c1.qryid'||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and dbid = c1.dbid;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  '||chr(10)||
'  for c2 in '||chr(10)||
'  ('||chr(10)||
'    select a.form';

p:=p||'id, a.dbid'||chr(10)||
'    from wwv_mig_rev_forms a LEFT JOIN sys.dba_objects b'||chr(10)||
'    on UPPER(SUBSTR(a.source_name,0,30)) LIKE UPPER(b.object_name)'||chr(10)||
'    and b.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'       '||chr(10)||
'    where a.project_id = :MW_PROJ_ID'||chr(10)||
'    and a.security_group_id = :flow_security_group_id'||chr(10)||
'    and  ( a.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
'    and a.status = ''INCLUDE'''||chr(10)||
'    an';

p:=p||'d (b.status is NULL or b.status = ''INVALID'')'||chr(10)||
'    and (b.object_type = ''VIEW'' or b.object_type is null)'||chr(10)||
'    and a.source_type = ''QUERY'''||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    update wwv_mig_rev_forms'||chr(10)||
'    set status = ''EXCLUDE'''||chr(10)||
'    where formid = c2.formid'||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and dbid = c2.dbid;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  for c3 in '||chr(10)||
'  ('||chr(10)||
'    select distinct a.reportid';

p:=p||', a.dbid, c.status'||chr(10)||
'    from wwv_mig_rev_reports a, wwv_mig_rev_queries b LEFT JOIN sys.dba_objects c'||chr(10)||
'    on UPPER(SUBSTR(b.mig_view_name,0,30)) LIKE UPPER(c.object_name)'||chr(10)||
'    and c.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'    '||chr(10)||
'    where a.project_id =  :MW_PROJ_ID'||chr(10)||
'    and a.security_group_id = :flow_security_group_id'||chr(10)||
'    and UPPER(a.source_name) LIKE UPPER(b.mig_view_name)'||chr(10)||
'    and b.project_id = a.project_id'||chr(10)||
'    ';

p:=p||'and b.security_group_id = a.security_group_id'||chr(10)||
'    and a.dbid = b.dbid'||chr(10)||
'    and a.source_type = ''QUERY'''||chr(10)||
'    and b.status = ''EXCLUDE'''||chr(10)||
'    and a.status = ''INCLUDE'''||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    update wwv_mig_rev_reports'||chr(10)||
'    set status = ''EXCLUDE'''||chr(10)||
'    where reportid = c3.reportid'||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and dbid = c3.dbid;'||chr(10)||
'  end loop;'||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 65767004500357995.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 80,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Update Inclusion Status for Queries',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'LOAD',
  p_process_when_type=>'REQUEST_NOT_EQUAL_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'wwv_mig_acc_load.g_projectid := :MW_PROJ_ID ;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 6855101128932936.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 2,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set proj id',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
''||chr(10)||
'l_adj_offset boolean :=false;'||chr(10)||
'l_file_id number := null;'||chr(10)||
'l_parse_as_schema varchar2(256);'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for c1 in (select id'||chr(10)||
'             from wwv_flow_file_objects$'||chr(10)||
'             where pathid = :MW_PROJ_ID )'||chr(10)||
'  loop'||chr(10)||
'     l_file_id := c1.id;'||chr(10)||
'  end loop;'||chr(10)||
'  '||chr(10)||
'  if wwv_flow_security.g_security_group_id = 10 then'||chr(10)||
'    l_parse_as_schema := wwv_flow.g_flow_schema_owner;'||chr(10)||
'  else'||chr(10)||
'    l_parse_as_schema := ';

p:=p||':APP_USER;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  wwv_flow_imp_parser.parse ('||chr(10)||
'     p_file_id          => l_file_id,'||chr(10)||
'     p_parse_as_schema  => l_parse_as_schema,'||chr(10)||
'     p_install_as_flow  => :FLOW_ID,'||chr(10)||
'     p_original_flow_id => :FLOW_ID,'||chr(10)||
'     p_adjust_offset    => l_adj_offset '||chr(10)||
'   );'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 29492505616093507.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 5,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'parse',
  p_process_sql_clob => p, 
  p_process_error_message=> 'La soumission du fichier a échoué',
  p_process_when_button_id=>29154728036593651.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'La soumission du fichier a réussi',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv ('||chr(10)||
'    p_schema => wwv_flow_user_api.get_default_schema'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 29164332406935634.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Check priv',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors de la vérification des privilèges.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':MW_MIG_TYPE := ''access'';';

wwv_flow_api.create_page_process(
  p_id     => 279483907285740103.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Set Migration Type',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'l_count    number;'||chr(10)||
'l_dbid     number;'||chr(10)||
'l_schema   varchar2(60);'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
'       '||chr(10)||
'for c2 in ('||chr(10)||
'           select dbid, database_schema from wwv_mig_access'||chr(10)||
'           where project_id = :MW_PROJ_ID'||chr(10)||
'           and security_group_id = :flow_security_group_id'||chr(10)||
'          )'||chr(10)||
'loop'||chr(10)||
'  l_dbid := c2.dbid;'||chr(10)||
'  l_schema := c2.database_schema;'||chr(10)||
''||chr(10)||
'  for c1 in (  '||chr(10)||
'            select count(tblid) cnt '||chr(10)||
'            fr';

p:=p||'om   wwv_mig_rev_tables'||chr(10)||
'            where  project_id = :MW_PROJ_ID'||chr(10)||
'            and    dbid = l_dbid  '||chr(10)||
'          )'||chr(10)||
'LOOP'||chr(10)||
'  l_count := c1.cnt;'||chr(10)||
'END LOOP;'||chr(10)||
''||chr(10)||
'if (l_count  = 0 ) then'||chr(10)||
''||chr(10)||
'  for c2 in ('||chr(10)||
'              select distinct a. tblid,'||chr(10)||
'                     a.tblname val1,  '||chr(10)||
'                     b.object_name val2,'||chr(10)||
'                     b.status status'||chr(10)||
'              from ('||chr(10)||
'                    wwv_mig_acc';

p:=p||'_tables a LEFT OUTER JOIN sys.dba_objects b  '||chr(10)||
'                    on UPPER(wwv_mig_acc_load.transform_identifier(a.tblname)) LIKE UPPER(SUBSTR(b.object_name,0,30))'||chr(10)||
'                    and b.object_type = ''TABLE'''||chr(10)||
'                    and b.owner = UPPER(l_schema)) '||chr(10)||
'                    where  a.project_id = :MW_PROJ_ID'||chr(10)||
'                    and a.dbid = l_dbid'||chr(10)||
'                    and a.security_group_i';

p:=p||'d = :flow_security_group_id'||chr(10)||
'            ) '||chr(10)||
'  LOOP'||chr(10)||
'           insert into wwv_mig_rev_tables (project_id,'||chr(10)||
'                                           dbid,'||chr(10)||
'                                           tblid,'||chr(10)||
'                                           orig_table_name,'||chr(10)||
'                                           mig_table_name,'||chr(10)||
'                                           owner,'||chr(10)||
'                           ';

p:=p||'                status)'||chr(10)||
'                                   values (:MW_PROJ_ID,'||chr(10)||
'                                           l_dbid,'||chr(10)||
'                                           c2.tblid,'||chr(10)||
'                                           c2.val1,'||chr(10)||
'                                           c2.val2,'||chr(10)||
'                                           l_schema,'||chr(10)||
'                                           decode(c2.status';

p:=p||',''VALID'',''INCLUDE'',''INSERTED''));'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  '||chr(10)||
'  for c3 in ('||chr(10)||
'               select distinct a.tblid, '||chr(10)||
'                               a.tblname,  '||chr(10)||
'                               b.table_name,'||chr(10)||
'                               d.constraint_type'||chr(10)||
'               from (('||chr(10)||
'                       wwv_mig_acc_tables a LEFT OUTER JOIN sys.dba_tables b'||chr(10)||
'                       on UPPER(wwv_mig_acc_load.transform';

p:=p||'_identifier(a.tblname)) LIKE UPPER(SUBSTR(b.table_name,0,30))'||chr(10)||
'                       and b.owner = UPPER(l_schema))'||chr(10)||
''||chr(10)||
'                       LEFT JOIN sys.dba_constraints d'||chr(10)||
'                       on UPPER(b.table_name) LIKE UPPER(d.table_name)'||chr(10)||
'                       and d.constraint_type = ''P'''||chr(10)||
'                       and d.owner = UPPER(l_schema))'||chr(10)||
'               where  a.project_id = :MW_PROJ_ID'||chr(10)||
'   ';

p:=p||'            and    a.security_group_id = :flow_security_group_id'||chr(10)||
'               and    a.dbid = l_dbid'||chr(10)||
'  )'||chr(10)||
'  loop '||chr(10)||
'      -- Exclude any tables with no primary key '||chr(10)||
'      update wwv_mig_rev_tables'||chr(10)||
'      set status = ''EXCLUDE'''||chr(10)||
'      where c3.constraint_type is null'||chr(10)||
'      and orig_table_name = c3.tblname'||chr(10)||
'      and mig_table_name = c3.table_name'||chr(10)||
'      and project_id = :MW_PROJ_ID'||chr(10)||
'      and security_gr';

p:=p||'oup_id = :flow_security_group_id'||chr(10)||
'      and dbid = l_dbid;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
''||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 239360610389929769.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert into wwv_mig_rev_tables',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Echec de l''insertion des données dans les tables d''analyse.',
  p_process_when=>'LOAD',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'l_count number;'||chr(10)||
'l_dbid     number;'||chr(10)||
'l_schema   varchar2(60);'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
'       '||chr(10)||
'l_count := 0;'||chr(10)||
''||chr(10)||
'for c2 in ('||chr(10)||
'           select dbid, database_schema from wwv_mig_access'||chr(10)||
'           where project_id = :MW_PROJ_ID'||chr(10)||
'           and security_group_id = :flow_security_group_id'||chr(10)||
'          )'||chr(10)||
'loop'||chr(10)||
'  l_dbid := c2.dbid;'||chr(10)||
'  l_schema := c2.database_schema;'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'  for c1 in '||chr(10)||
'  (  '||chr(10)||
'         select count(qryid) cnt '||chr(10)||
'';

p:=p||'         from   wwv_mig_rev_queries'||chr(10)||
'         where  project_id = :MW_PROJ_ID'||chr(10)||
'         and    dbid = l_dbid  '||chr(10)||
'         and    security_group_id = :flow_security_group_id'||chr(10)||
'  ) '||chr(10)||
'  LOOP'||chr(10)||
'	l_count := c1.cnt;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  if (l_count  = 0 ) then'||chr(10)||
'    for c2 in '||chr(10)||
'    ('||chr(10)||
'           select a.qryid,'||chr(10)||
'                  a.qryname qryname,  '||chr(10)||
'                  b.view_name viewname,'||chr(10)||
'                  a.qrysql qrysql';

p:=p||','||chr(10)||
'                  b.text text,'||chr(10)||
'                  c.status status'||chr(10)||
'           from ('||chr(10)||
'                  WWV_MIG_ACC_QUERIES a LEFT OUTER JOIN SYS.DBA_VIEWS b '||chr(10)||
'                  on UPPER(wwv_mig_acc_load.transform_identifier(a.qryname)) LIKE UPPER(SUBSTR(b.view_name,0,30))'||chr(10)||
'                  and b.owner = UPPER(:P2_SCHEMA) '||chr(10)||
'                  '||chr(10)||
'                  LEFT JOIN SYS.DBA_OBJECTS c'||chr(10)||
'            ';

p:=p||'      on UPPER(SUBSTR(b.view_name,0,30)) LIKE UPPER(SUBSTR(c.object_name,0,30))'||chr(10)||
'                  and c.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'                ) '||chr(10)||
'           where  a.project_id = :MW_PROJ_ID'||chr(10)||
'           and    a.dbid = l_dbid'||chr(10)||
'           and    security_group_id = :flow_security_group_id'||chr(10)||
'    ) '||chr(10)||
'    LOOP'||chr(10)||
' '||chr(10)||
'           insert into wwv_mig_rev_queries (project_id,'||chr(10)||
'                                    ';

p:=p||'        dbid,'||chr(10)||
'                                            qryid,'||chr(10)||
'                                            orig_qry_name,'||chr(10)||
'                                            mig_view_name,'||chr(10)||
'                                            orig_sql,'||chr(10)||
'                                            mig_sql,'||chr(10)||
'                                            owner,'||chr(10)||
'                                            status)'||chr(10)||
'       ';

p:=p||'                             values (:MW_PROJ_ID,'||chr(10)||
'                                            l_dbid,'||chr(10)||
'                                            c2.qryid,'||chr(10)||
'                                            c2.qryname,'||chr(10)||
'                                            c2.viewname,'||chr(10)||
'                                            c2.qrysql,'||chr(10)||
'                                            c2.text,'||chr(10)||
'                       ';

p:=p||'                     :P2_SCHEMA,'||chr(10)||
'                                            decode(c2.status,''VALID'',''INCLUDE'',''INSERTED''));        '||chr(10)||
'    END LOOP;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 239413021451481781.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert into wwv_mig_rev_queries',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Echec de l''insertion des données dans les tables d''analyse.',
  p_process_when=>'LOAD',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'l_count number;'||chr(10)||
'l_dbid     number;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'for c2 in ('||chr(10)||
'           select dbid, database_schema from wwv_mig_access'||chr(10)||
'           where project_id = :MW_PROJ_ID'||chr(10)||
'           and security_group_id = :flow_security_group_id'||chr(10)||
'          )'||chr(10)||
'loop'||chr(10)||
'  l_dbid := c2.dbid;'||chr(10)||
''||chr(10)||
'       '||chr(10)||
'  for c1 in (  '||chr(10)||
'           select count(reportid) cnt '||chr(10)||
'           from   wwv_mig_rev_reports'||chr(10)||
'           where  project_id = :MW_';

p:=p||'PROJ_ID'||chr(10)||
'           and    dbid = l_dbid '||chr(10)||
'           and    security_group_id = :flow_security_group_id'||chr(10)||
'          ) '||chr(10)||
'  LOOP'||chr(10)||
'    l_count := c1.cnt;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  if (l_count  = 0 ) then'||chr(10)||
''||chr(10)||
'    for c2 in ('||chr(10)||
'             select distinct reportid, repname'||chr(10)||
'             from   wwv_mig_acc_reports '||chr(10)||
'             where  dbid = l_dbid'||chr(10)||
'             and    project_id = :MW_PROJ_ID '||chr(10)||
'             and    security_g';

p:=p||'roup_id = :flow_security_group_id'||chr(10)||
'            ) '||chr(10)||
'    LOOP'||chr(10)||
''||chr(10)||
'          insert into wwv_mig_rev_reports (project_id,'||chr(10)||
'                                           dbid,'||chr(10)||
'                                           reportid,'||chr(10)||
'                                           report_name,'||chr(10)||
'                                           owner,'||chr(10)||
'                                           status)'||chr(10)||
'                           ';

p:=p||'        values (:MW_PROJ_ID,'||chr(10)||
'                                           l_dbid,'||chr(10)||
'                                           c2.reportid,'||chr(10)||
'                                           c2.repname,'||chr(10)||
'                                           :P2_SCHEMA,'||chr(10)||
'                                           ''INSERTED'');'||chr(10)||
'    END LOOP;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 241239403161424292.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert data into wwv_mig_rev_reports',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Echec de l''insertion des données dans les tables d''analyse.',
  p_process_when=>'LOAD',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'l_count    number;'||chr(10)||
'l_dbid     number;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'for c2 in ('||chr(10)||
'           select dbid, database_schema from wwv_mig_access'||chr(10)||
'           where project_id = :MW_PROJ_ID'||chr(10)||
'           and security_group_id = :flow_security_group_id'||chr(10)||
'          )'||chr(10)||
'loop'||chr(10)||
'  l_dbid := c2.dbid;'||chr(10)||
'       '||chr(10)||
'  for c1 in (  '||chr(10)||
'           select count(formid) cnt '||chr(10)||
'           from   wwv_mig_rev_forms'||chr(10)||
'           where  project_id = :MW_PR';

p:=p||'OJ_ID'||chr(10)||
'           and    dbid = l_dbid '||chr(10)||
'           and    security_group_id = :flow_security_group_id'||chr(10)||
'          ) '||chr(10)||
'  LOOP'||chr(10)||
'    l_count := c1.cnt;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  if (l_count  = 0 ) then'||chr(10)||
'  '||chr(10)||
'    for c2 in ('||chr(10)||
'             select distinct formid, formname'||chr(10)||
'             from   wwv_mig_acc_forms '||chr(10)||
'             where  dbid = l_dbid'||chr(10)||
'             and    project_id = :MW_PROJ_ID'||chr(10)||
'             and    security_group';

p:=p||'_id = :flow_security_group_id'||chr(10)||
'            ) '||chr(10)||
'    LOOP'||chr(10)||
''||chr(10)||
'          insert into wwv_mig_rev_forms (project_id,'||chr(10)||
'                                           dbid,'||chr(10)||
'                                           formid,'||chr(10)||
'                                           form_name,'||chr(10)||
'                                           owner,'||chr(10)||
'                                           status)'||chr(10)||
'                                   va';

p:=p||'lues (:MW_PROJ_ID,'||chr(10)||
'                                           l_dbid,'||chr(10)||
'                                           c2.formid,'||chr(10)||
'                                           c2.formname,'||chr(10)||
'                                           :P2_SCHEMA,'||chr(10)||
'                                           ''INSERTED'');'||chr(10)||
'    END LOOP;'||chr(10)||
''||chr(10)||
''||chr(10)||
'    for c3 in ('||chr(10)||
'            select distinct  c.formid child_formid, '||chr(10)||
'                        ';

p:=p||'     a.formid parent_formid               '||chr(10)||
'            from   wwv_mig_acc_forms_controls a, '||chr(10)||
'                   wwv_mig_acc_forms c'||chr(10)||
'            where  a.project_id = :MW_PROJ_ID'||chr(10)||
'            and    a.security_group_id = :flow_security_group_id'||chr(10)||
'            and    a.dbid = l_dbid'||chr(10)||
'            and    a.controltype = 112'||chr(10)||
'            and    a.project_id = c.project_id'||chr(10)||
'            and    a.security_group_';

p:=p||'id = c.security_group_id'||chr(10)||
'            and    a.dbid = c.dbid'||chr(10)||
'            and    a.controlname = c.formname'||chr(10)||
'    )'||chr(10)||
'    loop '||chr(10)||
'          update wwv_mig_rev_forms '||chr(10)||
'          set parent_formid = c3.parent_formid'||chr(10)||
'          where formid = c3.child_formid'||chr(10)||
'          and project_id = :MW_PROJ_ID'||chr(10)||
'          and dbid = l_dbid'||chr(10)||
'          and security_group_id = :flow_security_group_id'||chr(10)||
'          and owner = :P2_SCH';

p:=p||'EMA;'||chr(10)||
''||chr(10)||
'    end loop;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3700531343915761.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'insert data into wwv_mig_rev_forms',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Echec de l''insertion des données dans les tables d''analyse.',
  p_process_when=>'LOAD',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'  l_dbid     number;'||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'for c2 in ('||chr(10)||
'           select dbid, database_schema from wwv_mig_access'||chr(10)||
'           where project_id = :MW_PROJ_ID'||chr(10)||
'           and security_group_id = :flow_security_group_id'||chr(10)||
'          )'||chr(10)||
'loop'||chr(10)||
'  l_dbid := c2.dbid;'||chr(10)||
''||chr(10)||
'  for c1 in '||chr(10)||
'  ('||chr(10)||
'   select distinct a.reportid reportid, a.recordsource recsrc,'||chr(10)||
'       decode(a.recordsource,e.orig_table_name,''TABLE'','||chr(10)||
'                ';

p:=p||'             f.orig_qry_name,''QUERY'','||chr(10)||
'                             '' '',null,'||chr(10)||
'                             ''SQL Query'') src_type,                 '||chr(10)||
'       decode(a.recordsource,e.orig_table_name, decode(e.mig_table_name,null,e.orig_table_name,e.mig_table_name),'||chr(10)||
'                             f.orig_qry_name, decode(f.mig_view_name,''-'',f.orig_qry_name||'' was not successfully migrated to Oracle.'',f.mig_';

p:=p||'view_name)) src_name,'||chr(10)||
'       e.status stat_tab,'||chr(10)||
'       f.status stat_qry '||chr(10)||
'                   '||chr(10)||
'   from (('||chr(10)||
''||chr(10)||
'       wwv_mig_acc_reports a LEFT JOIN wwv_mig_rev_tables e'||chr(10)||
'       on UPPER(a.recordsource) = UPPER(e.orig_table_name)'||chr(10)||
'       and a.project_id = e.project_id'||chr(10)||
'       and a.dbid = e.dbid)'||chr(10)||
'       '||chr(10)||
'       LEFT JOIN wwv_mig_rev_queries f'||chr(10)||
'       on UPPER(a.recordsource) = UPPER(f.orig_qry_name)'||chr(10)||
'    ';

p:=p||'   and a.project_id = f.project_id'||chr(10)||
'       and a.dbid = f.dbid)'||chr(10)||
''||chr(10)||
'    where a.project_id = :MW_PROJ_ID'||chr(10)||
'    and a.security_group_id =  :flow_security_group_id'||chr(10)||
'    and a.dbid = l_dbid'||chr(10)||
'   )'||chr(10)||
'   LOOP'||chr(10)||
'   '||chr(10)||
'     -- Set the source_type '||chr(10)||
'     update wwv_mig_rev_reports'||chr(10)||
'     set source_type = c1.src_type'||chr(10)||
'     where project_id = :MW_PROJ_ID'||chr(10)||
'     and reportid = c1.reportid'||chr(10)||
'     and dbid = l_dbid'||chr(10)||
'     and owner =';

p:=p||' :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'     -- Set the owner'||chr(10)||
'     -- update wwv_mig_rev_reports'||chr(10)||
'     -- set owner = :P2_SCHEMA'||chr(10)||
'     -- where project_id = :MW_PROJ_ID'||chr(10)||
'     -- and reportid = c1.reportid'||chr(10)||
'     -- and dbid = l_dbid;'||chr(10)||
''||chr(10)||
'     -- Set the source_name'||chr(10)||
'     update wwv_mig_rev_reports'||chr(10)||
'     set source_name = c1.src_name'||chr(10)||
'     where project_id = :MW_PROJ_ID'||chr(10)||
'     and reportid = c1.reportid'||chr(10)||
'     and dbid = l_dbid'||chr(10)||
'     and o';

p:=p||'wner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'     update wwv_mig_rev_reports'||chr(10)||
'     set source_syntax = c1.recsrc'||chr(10)||
'     where source_type = ''SQL Query'''||chr(10)||
'     and project_id = :MW_PROJ_ID'||chr(10)||
'     and reportid = c1.reportid'||chr(10)||
'     and dbid = l_dbid'||chr(10)||
'     and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'     update wwv_mig_rev_reports'||chr(10)||
'     set source_status = ''INVALID'''||chr(10)||
'     where source_type = ''SQL Query'''||chr(10)||
'     and source_syntax = c1.recsrc'||chr(10)||
'     and project_i';

p:=p||'d = :MW_PROJ_ID'||chr(10)||
'     and reportid = c1.reportid'||chr(10)||
'     and dbid = l_dbid'||chr(10)||
'     and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'     -- Include forms based on included queries'||chr(10)||
'     update wwv_mig_rev_reports'||chr(10)||
'     set status = ''INCLUDE'''||chr(10)||
'     where source_type = ''QUERY'''||chr(10)||
'     and c1.stat_qry = ''INCLUDE'''||chr(10)||
'     and project_id = :MW_PROJ_ID'||chr(10)||
'     and reportid = c1.reportid'||chr(10)||
'     and dbid = l_dbid'||chr(10)||
'     and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'     -';

p:=p||'- Include forms based on included tables'||chr(10)||
'     update wwv_mig_rev_reports'||chr(10)||
'     set status = ''INCLUDE'''||chr(10)||
'     where source_type = ''TABLE'''||chr(10)||
'     and c1.stat_tab = ''INCLUDE'''||chr(10)||
'     and project_id = :MW_PROJ_ID'||chr(10)||
'     and reportid = c1.reportid'||chr(10)||
'     and dbid = l_dbid'||chr(10)||
'     and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'END LOOP;'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 1680826188759461.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 50,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'update wwv_mig_rev_reports recordsource Information',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'LOAD',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
' l_dbid  number;'||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'for c2 in ('||chr(10)||
'           select dbid, database_schema from wwv_mig_access'||chr(10)||
'           where project_id = :MW_PROJ_ID'||chr(10)||
'           and security_group_id = :flow_security_group_id'||chr(10)||
'          )'||chr(10)||
'loop'||chr(10)||
'  l_dbid := c2.dbid;'||chr(10)||
''||chr(10)||
'  for c1 in '||chr(10)||
'  ('||chr(10)||
'   select distinct a.formid formid, a.recordsource recsrc,'||chr(10)||
'       decode(a.recordsource,e.orig_table_name,''TABLE'','||chr(10)||
'                        ';

p:=p||'     f.orig_qry_name,''QUERY'','||chr(10)||
'                             '' '',null,'||chr(10)||
'                             ''SQL Query'') src_type,                 '||chr(10)||
'       decode(a.recordsource,e.orig_table_name, decode(e.mig_table_name,null,e.orig_table_name,e.mig_table_name),'||chr(10)||
'                             f.orig_qry_name, decode(f.mig_view_name,''-'',f.orig_qry_name||'' was not successfully migrated to Oracle.'',f.mig_view_nam';

p:=p||'e)) src_name,'||chr(10)||
'       e.status stat_tab,'||chr(10)||
'       f.status stat_qry            '||chr(10)||
'   from (('||chr(10)||
''||chr(10)||
'       wwv_mig_acc_forms a LEFT JOIN wwv_mig_rev_tables e'||chr(10)||
'       on UPPER(a.recordsource) = UPPER(e.orig_table_name)'||chr(10)||
'       and a.project_id = e.project_id'||chr(10)||
'       and a.dbid = e.dbid)'||chr(10)||
'       '||chr(10)||
'       LEFT JOIN wwv_mig_rev_queries f'||chr(10)||
'       on UPPER(a.recordsource) = UPPER(f.orig_qry_name)'||chr(10)||
'       and a.project_id';

p:=p||' = f.project_id'||chr(10)||
'       and a.dbid = f.dbid)'||chr(10)||
''||chr(10)||
'    where a.project_id = :MW_PROJ_ID'||chr(10)||
'    and a.security_group_id =  :flow_security_group_id'||chr(10)||
'    and a.dbid = l_dbid'||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'   '||chr(10)||
'    -- Set the source_type '||chr(10)||
''||chr(10)||
'    update wwv_mig_rev_forms'||chr(10)||
'    set source_type = c1.src_type'||chr(10)||
'    where project_id = :MW_PROJ_ID'||chr(10)||
'    and formid = c1.formid'||chr(10)||
'    and dbid = l_dbid'||chr(10)||
'    and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'    -- Set the sour';

p:=p||'ce_name'||chr(10)||
'    update wwv_mig_rev_forms'||chr(10)||
'    set source_name = c1.src_name'||chr(10)||
'    where project_id = :MW_PROJ_ID'||chr(10)||
'    and formid = c1.formid'||chr(10)||
'    and dbid = l_dbid'||chr(10)||
'    and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'    -- Set the source syntax'||chr(10)||
'    update wwv_mig_rev_forms'||chr(10)||
'    set source_syntax = c1.recsrc'||chr(10)||
'    where source_type = ''SQL Query'''||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and formid = c1.formid'||chr(10)||
'    and dbid = l_dbid'||chr(10)||
'    an';

p:=p||'d owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'    -- Set the status to invalid for SQL Query recordsources'||chr(10)||
'    update wwv_mig_rev_forms'||chr(10)||
'    set source_status = ''INVALID'''||chr(10)||
'    where source_syntax = c1.recsrc'||chr(10)||
'    and source_type = ''SQL Query'''||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and formid = c1.formid'||chr(10)||
'    and dbid = l_dbid'||chr(10)||
'    and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'    -- Include forms based on included queries'||chr(10)||
'    update wwv_mig_rev_fo';

p:=p||'rms'||chr(10)||
'    set status = ''INCLUDE'''||chr(10)||
'    where source_type = ''QUERY'''||chr(10)||
'    and c1.stat_qry = ''INCLUDE'''||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and formid = c1.formid'||chr(10)||
'    and dbid = l_dbid'||chr(10)||
'    and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'    -- Include forms based on included tables'||chr(10)||
'    update wwv_mig_rev_forms'||chr(10)||
'    set status = ''INCLUDE'''||chr(10)||
'    where source_type = ''TABLE'''||chr(10)||
'    and c1.stat_tab = ''INCLUDE'''||chr(10)||
'    and project_id = :MW_PRO';

p:=p||'J_ID'||chr(10)||
'    and formid = c1.formid'||chr(10)||
'    and dbid = l_dbid'||chr(10)||
'    and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'    -- Set default APEX apping to FORM object'||chr(10)||
'    update wwv_mig_rev_forms'||chr(10)||
'    set mig_type = ''FORM'''||chr(10)||
'    where source_type <> ''SQL Query'''||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and dbid = l_dbid'||chr(10)||
'    and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'END LOOP;'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 3701824641980064.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4402,
  p_process_sequence=> 60,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'update wwv_mig_rev_forms recordsource Information',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'LOAD',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 2.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_3.440
prompt  ...PAGE 3.4402: Créer un projet de migration
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/appmgr_start.htm';

ph:=ph||'<style>	#AjaxLoading{padding:5px;font-size:18px;width:200px;text-align:center;left:50%;top:5%;position:absolute;border:2px solid #666;background-color:#FFF;}'||chr(10)||
'</style>'||chr(10)||
''||chr(10)||
'<script language="JavaScript" type="text/javascript">'||chr(10)||
'var migType;'||chr(10)||
''||chr(10)||
'function initAction() '||chr(10)||
'{'||chr(10)||
'migType=$v(''P3_TYPE'');'||chr(10)||
'setItemDisplayBySource(migType);'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function setItemDisplayBySource(migType) '||chr(10)||
'{'||chr(10)||
'  if (migType==''access'') '||chr(10)||
'  {'||chr(10)||
'    ht';

ph:=ph||'ml_HideItemRow([''P3_FORMS_XML_FILE'',''P3_FORMS_MESSAGE'',''P3_FORMS_FILE_DESCRIPTION'']);'||chr(10)||
'    html_ShowItemRow([''P3_MESSAGE'',''P3_APPLICATION_EXPORT'']);'||chr(10)||
'  }'||chr(10)||
''||chr(10)||
'  else if (migType==''forms'') '||chr(10)||
'  {'||chr(10)||
'    html_ShowItemRow([''P3_FORMS_XML_FILE'',''P3_FORMS_MESSAGE'',''P3_FORMS_FILE_DESCRIPTION'']);'||chr(10)||
'    html_HideItemRow([''P3_MESSAGE'',''P3_APPLICATION_EXPORT'']);  '||chr(10)||
'  }'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function doSubmit(r)'||chr(10)||
'{'||chr(10)||
'  html_ShowElement(''AjaxLoa';

ph:=ph||'ding'');'||chr(10)||
'  window.setTimeout(''html_GetElement("wait").src = html_GetElement("wait").src'', 100);'||chr(10)||
'  flowSelectAll();'||chr(10)||
'  document.wwv_flow.p_request.value = r;'||chr(10)||
'  document.wwv_flow.submit();'||chr(10)||
'} // End doSubmit()'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 3.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Créer un projet de migration',
  p_step_title=> 'Créer un projet de migration',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_footer_text => '<div id="AjaxLoading" style="display:none;"><img src="#IMAGE_PREFIX#processing3.gif" id="wait" /></div>'||chr(10)||
'<script>'||chr(10)||
'initAction();'||chr(10)||
'</script>',
  p_autocomplete_on_off => 'ON',
  p_group_id => 5872827478268282+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 25821516221167914.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162008',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>3.4402,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>3.4402,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5089901406189380.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4402,
  p_plug_name=> 'Créer un projet de migration',
  p_region_name=>'',
  p_plug_template=> 145308009821552281.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5164220654585896.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'5877721161285352';

wwv_flow_api.create_page_plug (
  p_id=> 22185318309150806.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4402,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 35485909554264791.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 5877721161285352 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'139359500914809151';

wwv_flow_api.create_page_plug (
  p_id=> 139361423340834568.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4402,
  p_plug_name=> 'Project Progress Bar',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 139359500914809151 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 5090208060189382.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 5089901406189380+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3.4402,
  p_button_sequence=> 20,
  p_button_plug_id => 5089901406189380+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_image_alt=> 'Suivant >',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P3_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>5090520028189386.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_branch_action=> 'f?p=&APP_ID.:18:&SESSION.::&DEBUG.::P3_TYPE:&P3_TYPE.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>26942626908736981.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 2,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>259371818448752970.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_branch_action=> 'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::P3_TYPE:&P3_TYPE.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 100,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5090717885189392.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez un nom de projet unique. Il doit être unique dans votre espace de travail en cours.';

wwv_flow_api.create_page_item(
  p_id=>5090917843189398.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_MIGRATION_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de projet',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299333804814359.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => 'Enter a name of your Microsoft Access Application migration project.  A project should be created for each application you would like to migrate.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Le fichier d''export de migration est le script SQL généré par l''outil Exporter for Microsoft Access, contenant les informations de votre application Microsoft Access.';

wwv_flow_api.create_page_item(
  p_id=>5277732576800436.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_APPLICATION_EXPORT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 35,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Fichier d''export de migration',
  p_source_type=> 'STATIC',
  p_display_as=> 'FILE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''access''',
  p_field_template => 8299333804814359.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le schéma à associer au projet de migration.'||chr(10)||
'<p>'||chr(10)||
'Pour une migration Microsoft Access, ce schéma doit contenir les objets de schéma de base de données migrés de la base de données Microsoft Access que vous voulez migrer vers Oracle &PRODUCT_NAME..'||chr(10)||
'<p>'||chr(10)||
'Pour une migration Oracle Forms, ce schéma doit contenir les objets de schéma de base de données associés à l''application Oracle Forms q';

h:=h||'ue vous voulez migrer vers Oracle &PRODUCT_NAME..';

wwv_flow_api.create_page_item(
  p_id=>5501926965266936.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30.5,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schéma',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'select upper(c.schema) d, upper(c.schema) v'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299333804814359.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le type de migration à exécuter. Les options sont les suivantes :'||chr(10)||
'<ul>'||chr(10)||
'<li><b>Access</b> indique une migration Microsoft Access</li>'||chr(10)||
'<li><b>Panneaux</b> indique une conversion Oracle Forms</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>6381808970901645.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Type',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:Access;access,Forms;forms',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Sélectionner un type -',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes  => 'onChange="setItemDisplayBySource(this.value);"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299333804814359.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>20318817588637571.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FILE_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'File Id',
  p_source=>'select :P3_APPLICATION_EXPORT from dual;',
  p_source_type=> 'QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''access''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>20684501575327983.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_DELETESTATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'false',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''access''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>22511516957253936.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_MESSAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 34,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(''F4400_P3_FIND_FILE'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''access''',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez une brève description du projet de migration.';

wwv_flow_api.create_page_item(
  p_id=>26612328838945486.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_DESCRIPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Description',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 2,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>26759304932143979.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_PROJECTID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'This is the ID',
  p_source=>'wwv_mig_acc_load.g_projectid',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''access''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>77048105678192321.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_ERROR_MESSAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 180,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259641100112249030.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_FILE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'FILE_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259641705895818376.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_MESSAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'return wwv_flow_lang.system_message(''F4400_P3_FIND_FORMS_FILE'', ''javascript:popUp2(''''f?p=&APP_ID.:70:&APP_SESSION.::::'''',500,600);"class="itemlink'')',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 25,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le fichier XML du module de panneaux que vous voulez télécharger. Pour les modules de panneaux, téléchargez le fichier XML généré par l''outil de conversion Forms2XML.<br/>';

wwv_flow_api.create_page_item(
  p_id=>259642022565851587.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_XML_FILE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => '&P3_FORMS_XML_FILE.',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Fichier XML du module de panneaux',
  p_source=>'FILE_CONTENT:FILE_MIME_TYPE:FILE_NAME:FILE_UPDATED_ON:FILE_CHAR_SET:attachment:',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'FILE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_field_template => 8299333804814359.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => 'Please select a valid Forms Module XML File, which is generated by the Forms2XML conversion tool, for an Oracle Forms Module. - previous Help Text before inclusion of PL/SQL Libraries.');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259642219626888621.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_SECURITY_GROUP_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'SECURITY_GROUP_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259642432439892309.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_FILE_MIME_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'FILE_MIME_TYPE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259642613177896140.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_XML_CONTENT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'XML_CONTENT',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259642821142898520.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_FILE_CHAR_SET',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'FILE_CHAR_SET',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259643031877901559.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_FILE_UPDATED_ON',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'FILE_UPDATED_ON',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259643209976914221.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_SELECT_FOR_APP',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'SELECT_FOR_APP',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>259643424867918452.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_PROJECT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'PROJECT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P3_TYPE = ''forms''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez une brève description du fichier XML de panneaux associé au projet de conversion Oracle Forms.';

wwv_flow_api.create_page_item(
  p_id=>265603315607927610.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_name=>'P3_FORMS_FILE_DESCRIPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 105,
  p_item_plug_id => 5089901406189380.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Description',
  p_source=>'DESCRIPTION',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN_PROTECTED',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 2,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 303783022015617446.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'P3_FORMS_FILE_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'substr(:P3_FORMS_XML_FILE, instr(:P3_FORMS_XML_FILE, ''/'', -1) + 1)',
  p_compute_when => 'P3_FORMS_XML_FILE',
  p_compute_when_type=>'ITEM_IS_NOT_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 303783229634619644.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_computation_sequence => 20,
  p_computation_item=> 'P3_FORMS_FILE_DESCRIPTION',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'trim(:P3_FORMS_FILE_DESCRIPTION)',
  p_compute_when => 'P3_FORMS_XML_FILE',
  p_compute_when_type=>'ITEM_IS_NOT_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 303781506862594169.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_computation_sequence => 30,
  p_computation_item=> 'P3_FORMS_FILE_CHAR_SET',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'nvl(:P3_FORMS_FILE_CHAR_SET, owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''))',
  p_compute_when => 'P3_FORMS_XML_FILE',
  p_compute_when_type=>'ITEM_IS_NOT_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 259654203124167669.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_computation_sequence => 40,
  p_computation_item=> 'P3_FORMS_SELECT_FOR_APP',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'Y',
  p_compute_when => ':P3_TYPE = ''forms''',
  p_compute_when_type=>'PLSQL_EXPRESSION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 259654722171173110.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_computation_sequence => 50,
  p_computation_item=> 'P3_FORMS_SECURITY_GROUP_ID',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'ITEM_VALUE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'FLOW_SECURITY_GROUP_ID',
  p_compute_when => ':P3_TYPE = ''forms''',
  p_compute_when_type=>'PLSQL_EXPRESSION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 58479100377142678.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4402,
  p_computation_sequence => 60,
  p_computation_item=> 'MW_MIG_TYPE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '&P3_TYPE.',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 32177326980058038.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_validation_name => 'P3_MIGRATION_NAME Not NULL',
  p_validation_sequence=> 10,
  p_validation => 'P3_MIGRATION_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Vous devez saisir un nom de projet unique.',
  p_when_button_pressed=> 26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_associated_item=> 5090917843189398.4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 20474506389345075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_validation_name => 'P3_MIGRATION_NAME Must Be Unique',
  p_validation_sequence=> 15,
  p_validation => 'DECLARE'||chr(10)||
''||chr(10)||
'  l_cnt number := 0;'||chr(10)||
'  l_name varchar2(100);'||chr(10)||
'  l_length number := 0;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'  l_name := trim(:P3_MIGRATION_NAME);'||chr(10)||
'  l_length := length(l_name);'||chr(10)||
''||chr(10)||
'  if (l_length > 0) then'||chr(10)||
''||chr(10)||
'    for c1 in (select count(*) cnt'||chr(10)||
'               from wwv_mig_projects'||chr(10)||
'               where upper(migration_name) = upper(:P3_MIGRATION_NAME)'||chr(10)||
'               and security_group_id = :flow_security_group_id )'||chr(10)||
'    loop'||chr(10)||
'      l_cnt := c1.cnt;'||chr(10)||
'    end loop;'||chr(10)||
'    '||chr(10)||
'    if l_cnt > 0 then'||chr(10)||
'      return false;'||chr(10)||
'    else'||chr(10)||
'      return true;'||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
'    return false;'||chr(10)||
'  end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Vous devez saisir un nom de projet unique.',
  p_validation_condition=> 'P3_MIGRATION_NAME',
  p_validation_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_when_button_pressed=> 26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_associated_item=> 5090917843189398.4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 36514304723490174.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_validation_name => 'P3_DESCRIPTION Not only whitespaces',
  p_validation_sequence=> 25,
  p_validation => 'declare'||chr(10)||
'  l_desc varchar2(100);'||chr(10)||
'  l_length number;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'   l_desc := trim(:P3_DESCRIPTION);'||chr(10)||
'   l_length := length(l_desc);'||chr(10)||
''||chr(10)||
'   if (l_length > 0) then'||chr(10)||
'     return true;'||chr(10)||
'   else'||chr(10)||
'     return false;'||chr(10)||
'   end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Vous devez saisir une brève description de ce projet de migration.',
  p_validation_condition=> 'P3_DESCRIPTION',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_associated_item=> 26612328838945486.4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 11449220641741121.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_validation_name => 'P3_APPLICATION_EXPORT Not NULL',
  p_validation_sequence=> 30,
  p_validation => 'P3_APPLICATION_EXPORT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Vous devez sélectionner un fichier d''export de migration pour créer un projet de migration.',
  p_validation_condition=> ':P3_TYPE = ''access''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_when_button_pressed=> 26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_associated_item=> 5277732576800436.4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 304521512235021174.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_validation_name => 'P3_FORMS_FILE_NAME Not Null',
  p_validation_sequence=> 30,
  p_validation => 'P3_FORMS_FILE_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Sélectionnez le fichier de panneaux à télécharger. Pour les modules de panneaux, téléchargez le fichier XML généré par l''outil de conversion Forms2XML, qui contient les informations de votre module de panneaux.',
  p_validation_condition=> ':P3_FORMS_FILE_NAME is null and :P3_TYPE = ''forms''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_when_button_pressed=> 26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_associated_item=> 259642022565851587.4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 37748031982428012.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_validation_name => 'Valid Export File Check',
  p_validation_sequence=> 31,
  p_validation => 'DECLARE '||chr(10)||
'   l_length   number :=0;'||chr(10)||
'   l_file     varchar2(100);'||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'  l_file := trim(:P3_APPLICATION_EXPORT);'||chr(10)||
'  l_length := length(l_file);'||chr(10)||
''||chr(10)||
'  if (l_length > 0) then'||chr(10)||
'    return true;   '||chr(10)||
'  else'||chr(10)||
'    return false;'||chr(10)||
'  end if;'||chr(10)||
'END;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Vous n''avez pas sélectionné un fichier d''export de migration valide.',
  p_validation_condition=> ':P3_APPLICATION_EXPORT is not null and :P3_TYPE = ''access''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_when_button_pressed=> 26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_associated_item=> 5277732576800436.4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 304521819526174685.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_validation_name => 'P3_FORMS_XML_FILE check file extension',
  p_validation_sequence=> 32,
  p_validation => 'for c1 in (select SUBSTR(UPPER(:P3_FORMS_XML_FILE), INSTR(UPPER(:P3_FORMS_XML_FILE),''_FMB.XML'')) xtn'||chr(10)||
'             from dual) loop'||chr(10)||
'    return (c1.xtn is not null and c1.xtn = ''_FMB.XML'');'||chr(10)||
'end loop;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Sélectionnez un fichier XML valide du module de panneaux, généré par l''outil de conversion Forms2XML, pour un module Oracle Forms.',
  p_validation_condition=> '(:P3_FORMS_FILE_NAME is not null) and (:P3_TYPE = ''forms'') and (SUBSTR(UPPER(:P3_FORMS_XML_FILE), INSTR(UPPER(:P3_FORMS_XML_FILE),''_FMB.XML'')) is null)',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_when_button_pressed=> 26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_associated_item=> 259642022565851587.4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'  fileid number;'||chr(10)||
'BEGIN'||chr(10)||
'  '||chr(10)||
'  if (:P3_APPLICATION_EXPORT is not null) then'||chr(10)||
''||chr(10)||
'  for c1 in ('||chr(10)||
'              select id '||chr(10)||
'              from wwv_flow_file_objects$ '||chr(10)||
'              where name = :P3_APPLICATION_EXPORT'||chr(10)||
'            )'||chr(10)||
'  loop'||chr(10)||
'    fileid := c1.id;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  -- delete from WWV_FLOW_FILE_OBJECTS$ where id = fileid;      '||chr(10)||
'    if (:P3_MIGRATION_NAME is NULL) then'||chr(10)||
'      delete from wwv_flo';

p:=p||'w_file_objects$ where id = fileid;    '||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 32356505153326221.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ACCESS:cleanup wwv_flow_file_objects',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_MIGRATION_NAME is not null and :P3_TYPE = ''access''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'wwv_mig_acc_load.g_projectid := wwv_flow_id.next_val;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 29035415214814092.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_process_sequence=> 15,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ACCESS:Set Project ID',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>':P3_TYPE = ''access''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'UPDATE wwv_flow_file_objects$ '||chr(10)||
'SET pathid = wwv_mig_acc_load.g_projectid'||chr(10)||
'WHERE name = :P3_APPLICATION_EXPORT;'||chr(10)||
''||chr(10)||
'UPDATE wwv_flow_file_objects$ '||chr(10)||
'SET file_type = ''Access Application Export''    -- ''FLOW_EXPORT''    '||chr(10)||
'WHERE name = :P3_APPLICATION_EXPORT;'||chr(10)||
''||chr(10)||
'UPDATE wwv_flow_file_objects$'||chr(10)||
'SET mime_type=''application/text'''||chr(10)||
'WHERE name = :P3_APPLICATION_EXPORT;'||chr(10)||
''||chr(10)||
'UPDATE wwv_flow_file_objects$'||chr(10)||
'SET file_charset=''utf';

p:=p||'-8'''||chr(10)||
'WHERE name = :P3_APPLICATION_EXPORT;';

wwv_flow_api.create_page_process(
  p_id     => 26947526440803085.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_process_sequence=> 35,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ACCESS:Insert project id in wwv_flow_file_objects',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''access''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'    wwv_mig_frm_load_xml.g_project_id := wwv_flow_id.next_val;'||chr(10)||
''||chr(10)||
'    insert into wwv_mig_projects (id, '||chr(10)||
'                                  migration_name, '||chr(10)||
'                                  description, '||chr(10)||
'                                  migration_type, '||chr(10)||
'                                  database_schema, '||chr(10)||
'                                  security_group_id) '||chr(10)||
'    values (wwv_mig_frm_load_xml.g_';

p:=p||'project_id, '||chr(10)||
'            :P3_MIGRATION_NAME,'||chr(10)||
'            :P3_DESCRIPTION,'||chr(10)||
'            :P3_TYPE, '||chr(10)||
'            :P3_SCHEMA,'||chr(10)||
'            :FLOW_SECURITY_GROUP_ID) '||chr(10)||
'    returning id into :P3_FORMS_PROJECT_ID;'||chr(10)||
''||chr(10)||
'    commit;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 259640812616205423.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_process_sequence=> 36,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Create Forms Project',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_MIG_FORMS:P3_ID:ID|I';

wwv_flow_api.create_page_process(
  p_id     => 259644202404940358.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_process_sequence=> 37,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'FORMS:Insert Forms XML',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>26942626908736981.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if :P3_TYPE = ''access'' then'||chr(10)||
'    :MW_PROJ_ID := wwv_mig_acc_load.g_projectid;'||chr(10)||
'  elsif :P3_TYPE = ''forms'' then'||chr(10)||
'    :MW_PROJ_ID := wwv_mig_frm_load_xml.g_project_id;'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 27579001640258883.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4402,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Set proj id variable',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_4.440
prompt  ...PAGE 4.4402: Supprimer un projet
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_mngproj.htm';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 4.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Supprimer un projet',
  p_step_title=> 'Supprimer un projet',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'ON',
  p_group_id => 5872827478268282+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162008',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>4.4402,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>4.4402,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5328821635120223.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4402,
  p_plug_name=> 'Supprimer un projet',
  p_region_name=>'',
  p_plug_template=> 167406109750085964.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_footer=> '<p>La suppression du projet ne supprimera pas les applications générées.</p>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5331907726124469.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 5329109625120225.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 5328821635120223+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&MW_MIG_PAGE.:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 5329025505120224.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4402,
  p_button_sequence=> 20,
  p_button_plug_id => 5328821635120223+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_image_alt=> 'Supprimer un projet',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> 'P4_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'DELETE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>5329826748120230.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4402,
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5330014385120231.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4402,
  p_name=>'P4_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 5328821635120223.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'project_id',
  p_source=>'PROJECT_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN_PROTECTED',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>5330200783120246.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4402,
  p_name=>'P4_MIGRATION_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 5328821635120223.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de projet :',
  p_source=>'MIGRATION_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>64984201251447294.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4402,
  p_name=>'P4_MIGRATION_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 5328821635120223.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Migration Type',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN_PROTECTED',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>331997422021312408.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4402,
  p_name=>'P4_PREVIOUS_PAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 5328821635120223.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Previous Page',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN_PROTECTED',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 65100500314579469.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'MW_PROJ_NAME',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select migration_name '||chr(10)||
'from wwv_mig_projects'||chr(10)||
'where id = :P4_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 260880816380988418.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'MW_MIG_PAGE',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'if :MW_MIG_TYPE = ''access'' then'||chr(10)||
'    return 2;'||chr(10)||
'elsif :MW_MIG_TYPE = ''forms'' then'||chr(10)||
'    return 51;'||chr(10)||
'end if;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:WWV_MIG_PROJECTS:P4_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 5330618824120250.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from WWV_MIG_PROJECTS',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible d''extraire la ligne.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_MIG_PROJECTS:P4_ID:ID|D';

wwv_flow_api.create_page_process(
  p_id     => 5330801289120251.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4.4402,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of WWV_MIG_PROJECTS',
  p_process_sql_clob => p, 
  p_process_error_message=> 'La suppression du projet a échoué.',
  p_process_success_message=> 'Projet supprimé.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'delete from WWV_FLOW_FILE_OBJECTS$'||chr(10)||
'where pathid = :P4_ID;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 20292309923256849.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4.4402,
  p_process_sequence=> 35,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Cleanup WWV_FLOW_FILE_OBJECTS$',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible de nettoyer wwv_flow_file_objects$ sur suppression du projet.',
  p_process_when=>':MW_MIG_TYPE = ''access''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'4';

wwv_flow_api.create_page_process(
  p_id     => 5331005030120252.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4.4402,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>5329025505120224.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_5.440
prompt  ...PAGE 5.4402: Dialogue de recherche
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/appmgr_start.htm';

ph:=ph||'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
'<head>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" type="text/css" />'||chr(10)||
'<script src="#IMAGE_PREFIX#javascript/apex_builder.js" type="text/javascript"></script>'||chr(10)||
'<style>a{font-size:12px;}</style>'||chr(10)||
'</head>';

wwv_flow_api.create_page(
  p_id     => 5.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Dialogue de recherche',
  p_step_title=> 'Dialogue de recherche',
  p_html_page_onload=>'onload="first_field()" class="htmldbPopup"',
  p_step_sub_title => 'Search Dialog',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_welcome_text=> '<div style="padding:2px;"><table><tr><td valign="top"><img src="#IMAGE_PREFIX#magnifying_glass_white_bg.gif" /></td><td>'||chr(10)||
''||chr(10)||
'<script language="JavaScript">'||chr(10)||
'   function passBack(passVal1)'||chr(10)||
'   {'||chr(10)||
'   opener.document.getElementById("P62_DETAIL_TABLE_NAME").value = passVal1;'||chr(10)||
'   close();'||chr(10)||
'   }'||chr(10)||
'</script>',
  p_footer_text => '</td></tr></table></div>',
  p_autocomplete_on_off => 'ON',
  p_group_id => 280687701592255307+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 107477536179540544.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162008',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>5.4402,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>5.4402,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 281423008375106229.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4402,
  p_plug_name=> 'Rechercher',
  p_region_name=>'',
  p_plug_template=> 27865014543291270.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select distinct d from (select a.table_name d'||chr(10)||
'   from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
'   where 1=1'||chr(10)||
'   and a.r_owner = :MW_SCHEMA'||chr(10)||
'   and a.owner = :MW_SCHEMA'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''R'''||chr(10)||
'   and b.owner = :MW_SCHEMA'||chr(10)||
'   and b.table_name in (:P5_TABLE_NAME)'||chr(10)||
'   and b.table_name not like ''BIN$%''     '||chr(10)||
'   and b.constraint_type in (''U'',''P'')'||chr(10)||
'   a';

s:=s||'nd exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = a.owner)'||chr(10)||
'  union all'||chr(10)||
'  select a.table_name d'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
'  where 1=1'||chr(10)||
'   and a.owner = :MW_SCHEMA'||chr(10)||
'   and b.r_owner = :MW_SCHEMA'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :MW_SCHEMA'||chr(10)||
'   and b.table_name in (:P5_TABLE_NAME)'||chr(10)||
'  ';

s:=s||' and b.table_name not like ''BIN$%''      '||chr(10)||
'   and b.constraint_type =''R'''||chr(10)||
'   and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = a.owner)'||chr(10)||
'   order by 1)'||chr(10)||
'where (instr(UPPER(d),UPPER(:P5_SEARCH))>0 or :P5_SEARCH is null)';

wwv_flow_api.create_report_region (
  p_id=> 281423212385106239.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4402,
  p_name=> 'Résultats',
  p_region_name=>'',
  p_template=> 308527605517617057.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<br />',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 76759420671391228.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '200',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '100000',
  p_pagination_display_position=> 'BOTTOM_LEFT',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 281423401260106243.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 281423212385106239.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'D',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_link=>'javascript:passBack(''#D#'');',
  p_column_linktext=>'#D#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '100',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 281423529211106246.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 281423008375106229+wwv_flow_api.g_id_offset,
  p_button_name    => 'SEARCH',
  p_button_image_alt=> 'Rechercher',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 281423720777106251.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5.4402,
  p_button_sequence=> 20,
  p_button_plug_id => 281423008375106229+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Fermer',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:window.close();',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>281424430261106263.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4402,
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 28-NOV-2007 12:04 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>281423915664106252.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4402,
  p_name=>'P5_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 281423008375106229.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 20,
  p_cMaxlength=> 100,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>281424127493106258.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4402,
  p_name=>'P5_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 281423008375106229.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Table Name: ',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>281435624285242671.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4402,
  p_name=>'P5_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 281423008375106229.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schema: ',
  p_source=>'MW_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN_PROTECTED',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 5.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_6.440
prompt  ...PAGE 6.4402: &EXPORTER.
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_howexportmeta.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 6.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '&EXPORTER.',
  p_step_title=> '&EXPORTER.',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162009',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>6.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5786131626493504.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select	 "WWV_MIG_EXPORTER"."FILENAME" as "FILENAME",'||chr(10)||
'	 "WWV_MIG_EXPORTER"."DESCRIPTION" as "DESCRIPTION",'||chr(10)||
'	 "WWV_MIG_EXPORTER"."ACCESS_VERSION" as "ACCESS VERSION",'||chr(10)||
'	 "WWV_MIG_EXPORTER"."EXPORTER_VERSION" as  "EXPORTER VERSION" '||chr(10)||
' from	 "WWV_MIG_EXPORTER" "WWV_MIG_EXPORTER"'||chr(10)||
'order by WWV_MIG_EXPORTER.ACCESS_VERSION DESC, WWV_MIG_EXPORTER.EXPORTER_VERSION DESC';

wwv_flow_api.create_report_region (
  p_id=> 20729124954790479.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4402,
  p_name=> 'Télécharger en local',
  p_region_name=>'',
  p_template=> 17268536952823952.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20729405813790494.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 20729124954790479.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FILENAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Télécharger en local',
  p_column_link=>'#IMAGE_PREFIX#migration/#FILENAME#',
  p_column_linktext=>'#FILENAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20729515903790494.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 20729124954790479.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DESCRIPTION',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Description',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20729622865790494.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 20729124954790479.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ACCESS VERSION',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Version de Microsoft Access',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20729700630790494.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 20729124954790479.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'EXPORTER VERSION',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Version d''Exporter',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Téléchargez et dézippez le fichier &EXPORTER. qui correspond à votre version de &MS_ACCESS.. Par exemple, téléchargez le fichier omwb2003.zip si vous utilisez &MS_ACCESS. 2003.'||chr(10)||
'<br><br>'||chr(10)||
'&EXPORTER. vous permet d''extraire les informations de la base de données et du schéma de l''application à partir d''une base de données &MS_ACCESS.. '||chr(10)||
'<br><br>'||chr(10)||
'Application Migration Workshop d''Oracle &PRODUCT_NAME. ut';

s:=s||'ilise ensuite ces informations pour migrer l''application &MS_ACCESS. vers les panneaux et les états d''Oracle &PRODUCT_NAME..'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 20740826124150388.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4402,
  p_plug_name=> '&EXPORTER.',
  p_region_name=>'',
  p_plug_template=> 86904609451444726.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 6.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_7.440
prompt  ...PAGE 7.4402: Etat 1
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/appmgr_start.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 7.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Etat 1',
  p_step_title=> 'Etat 1',
  p_step_sub_title => 'Report 1',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'ON',
  p_group_id => 280692031983283006+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162009',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>7.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select 1 from dual';

wwv_flow_api.create_report_region (
  p_id=> 305092402661560888.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4402,
  p_name=> 'Etat 1',
  p_region_name=>'',
  p_template=> 145308009821552281.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'QUERY_COLUMNS',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '500',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 305092726510560890.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 305092402661560888.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> '1',
  p_column_display_sequence=> 1,
  p_column_heading=> '1',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 7.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_8.440
prompt  ...PAGE 8.4402: Panneaux
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_recforms.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 8.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Panneaux',
  p_step_title=> 'Panneaux',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162009',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>8.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare '||chr(10)||
'  q varchar2(32767);'||chr(10)||
'begin'||chr(10)||
'  q := '||chr(10)||
''''||chr(10)||
'select distinct'||chr(10)||
''||chr(10)||
'htmldb_item.checkbox(1, x.formid, decode(x.source_type,''''TABLE'''',decode(x.stat_tab,''''INCLUDE'''',decode(x.status,''''EXCLUDE'''',null,''''INCLUDE'''',''''CHECKED''''),''''DISABLED''''),'||chr(10)||
'''''QUERY'''',decode(x.stat_view,''''INCLUDE'''',decode(x.status,''''EXCLUDE'''',null,''''INCLUDE'''',''''CHECKED''''),''''DISABLED''''),'||chr(10)||
'''''SQL Query'''',decode(x.source_status,''''VALID'''',decode(x';

s:=s||'.status,''''EXCLUDE'''',null,''''INCLUDE'''',''''CHECKED''''),''''DISABLED''''),'||chr(10)||
'null,''''DISABLED''''),null,null,''''f01_''''||rownum,t.inc) ||'||chr(10)||
'                       htmldb_item.hidden(2,x.formid) " ", '||chr(10)||
'decode'||chr(10)||
'(x.source_type,''''TABLE'''',decode(x.stat_tab,''''INCLUDE'''',htmldb_item.select_list_from_LOV(3,x.mig_type,''''FORM TYPES'''',null,''''NO'''',null,null,''''f03_''''||rownum,u.mig), null),'||chr(10)||
'              ''''QUERY'''',decode (x.stat_vie';

s:=s||'w,''''INCLUDE'''',htmldb_item.select_list_from_LOV(3,x.mig_type,''''FORM TYPES'''',null,''''NO'''',null,null,''''f03_''''||rownum,u.mig), null),'||chr(10)||
'              ''''SQL Query'''',null) ||'||chr(10)||
'decode'||chr(10)||
'(x.source_type,''''TABLE'''',decode(x.stat_tab,''''INCLUDE'''', htmldb_item.hidden(4,x.formid), null),'||chr(10)||
'	       ''''QUERY'''',decode (x.stat_view,''''INCLUDE'''',htmldb_item.hidden(4,x.formid), null),'||chr(10)||
'              ''''SQL Query'''',null) apex_type';

s:=s||','||chr(10)||
''||chr(10)||
'       x.formid,'||chr(10)||
'       x.formname,'||chr(10)||
'       x.parent_formid,'||chr(10)||
'       x.recordsource,'||chr(10)||
'       x.dbname,'||chr(10)||
'       x.source_type,'||chr(10)||
'       x.source_name,'||chr(10)||
'       x.status,'||chr(10)||
'       decode(x.startupform, x.formname,'||chr(10)||
'              ''''<img src="#IMAGE_PREFIX#check_small_black.gif" '||chr(10)||
'              alt="''||wwv_flow_lang.system_message(''F4000.YES'')||''"/>'''','||chr(10)||
'              null) "Startup Form",'||chr(10)||
'       decode(x.status';

s:=s||'_2,''''VALID'''',''''VALID'''','||chr(10)||
'                         ''''INVALID'''',''''INVALID'''','||chr(10)||
'                         null,decode(x.source_status,''''VALID'''',''''VALID'''','||chr(10)||
'                                                     ''''INVALID'''',''''INVALID'''','||chr(10)||
'                                                     null,''''INVALID'''')) stat,'||chr(10)||
''||chr(10)||
'decode(x.source_type,''''QUERY'''', ''''<a href="f?p=4400:30:&SESSION.::NO::P30_QUERY_NAME,P30_VIEW_N';

s:=s||'AME:''''||x.recordsource||'''',''''||x.source_name||''''">''''||htmldb_item.text_from_LOV(x.source_type,''''SOURCE TYPES'''')||''''</a>'''','||chr(10)||
'                     ''''TABLE'''', ''''<a href="f?p=4400:22:&SESSION.::NO::P22_TABLE_NAME:''''||x.source_name||''''">''''||htmldb_item.text_from_LOV(x.source_type,''''SOURCE TYPES'''')||''''</a>'''','||chr(10)||
'''''SQL Query'''',''''<a href="f?p=4400:42:&SESSION.:FRM:NO:42:P42_FORM_NAME,P42_FORM_ID,P42_OBJECT_TY';

s:=s||'PE,P42_ACC_OBJ,P42_PREVIOUS:''''||x.formname||'''',''''||x.formid||'''',''''||htmldb_item.text_from_LOV(x.source_type,''''SOURCE TYPES'''')||'''',FRM,8">''''||x.source_type||''''</a>'''')'||chr(10)||
'src_type,'||chr(10)||
''||chr(10)||
'''''<div onclick="showdetail(this,''''|| x.formid ||'''')" style="cursor:hand;cursor:pointer;text-decoration:underline;font-weight:bold;">show_detail</div>'''' detail,'||chr(10)||
'           x.parent_formname,'||chr(10)||
'           x.parent_source_type'||chr(10)||
''||chr(10)||
'';

s:=s||'from('||chr(10)||
'select distinct a.formid, '||chr(10)||
'       a.formname,'||chr(10)||
'       a.recordsource,'||chr(10)||
'       c.dbname,'||chr(10)||
'       c.startupform,'||chr(10)||
'       d.mig_table_name,'||chr(10)||
'       d.status stat_tab,'||chr(10)||
'       e.mig_view_name,'||chr(10)||
'       e.status stat_view,'||chr(10)||
'       i.parent_formid,'||chr(10)||
'       ( select k.form_name from wwv_mig_rev_forms k'||chr(10)||
'         where k.formid = i.parent_formid'||chr(10)||
'         and k.project_id = :MW_PROJ_ID'||chr(10)||
'    --     and k.dbid = :';

s:=s||'P2_DBID'||chr(10)||
'         and k.security_group_id = :flow_security_group_id'||chr(10)||
'       ) parent_formname,'||chr(10)||
'       ( select k.source_type from wwv_mig_rev_forms k'||chr(10)||
'         where k.formid = i.parent_formid'||chr(10)||
'         and k.project_id = :MW_PROJ_ID'||chr(10)||
'    --     and k.dbid = :P2_DBID'||chr(10)||
'         and k.security_group_id = :flow_security_group_id'||chr(10)||
'       ) parent_source_type, '||chr(10)||
'       i.source_name,'||chr(10)||
'       i.source_type,'||chr(10)||
'    ';

s:=s||'   i.source_status,'||chr(10)||
'       i.status,'||chr(10)||
'       i.mig_type,'||chr(10)||
'       h.status status_2'||chr(10)||
''||chr(10)||
'       '||chr(10)||
'from ((((('||chr(10)||
''||chr(10)||
'       wwv_mig_acc_forms a LEFT JOIN wwv_mig_access c'||chr(10)||
'       on  a.dbid = c.dbid'||chr(10)||
'       and a.project_id = c.project_id'||chr(10)||
'       and a.security_group_id = c.security_group_id'||chr(10)||
'       and a.dbid = c.dbid )'||chr(10)||
''||chr(10)||
'      LEFT JOIN wwv_mig_rev_tables d'||chr(10)||
'       on UPPER(a.recordsource) = UPPER(d.orig_table_name)';

s:=s||''||chr(10)||
'       and a.project_id = d.project_id'||chr(10)||
'       and a.dbid = d.dbid)'||chr(10)||
''||chr(10)||
'      LEFT JOIN wwv_mig_rev_queries e'||chr(10)||
'       on UPPER(a.recordsource) = UPPER(e.orig_qry_name)'||chr(10)||
''||chr(10)||
'       and a.project_id = e.project_id'||chr(10)||
'       and a.dbid = e.dbid)'||chr(10)||
'       '||chr(10)||
'     LEFT JOIN wwv_mig_rev_forms i'||chr(10)||
'       on a.project_id = i.project_id'||chr(10)||
'       and a.dbid = i.dbid'||chr(10)||
'       and a.formid = i.formid)'||chr(10)||
''||chr(10)||
'       LEFT JOIN sys.dba_ob';

s:=s||'jects h'||chr(10)||
'       on UPPER(h.object_name) = UPPER(i.source_name)'||chr(10)||
'       and h.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'       and h.owner = c.database_schema)'||chr(10)||
''||chr(10)||
''||chr(10)||
'where  a.project_id = :MW_PROJ_ID '||chr(10)||
'and    a.security_group_id = :flow_security_group_id'||chr(10)||
'--and    a.dbid = :P2_DBID'||chr(10)||
'and    (:P8_FORM is null or instr(upper(a.formname),upper(:P8_FORM))>0)'||chr(10)||
''||chr(10)||
') x, (select wwv_flow_lang.system_message(''''F4400_INCLUDE_LABEL'''') in';

s:=s||'c from dual) t, '||chr(10)||
'(select wwv_flow_lang.system_message(''''F4400_MIGRATE_TO_LABEL'''') mig from dual) u '';'||chr(10)||
''||chr(10)||
''||chr(10)||
'return q;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4402,
  p_name=> 'Informations récapitulatives sur les panneaux',
  p_region_name=>'',
  p_template=> 17268536952823952.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<script type="text/javascript"> '||chr(10)||
'function ToggleAll(e) '||chr(10)||
'{ '||chr(10)||
'  if (e.checked) '||chr(10)||
'  { '||chr(10)||
'    CheckAll(); '||chr(10)||
'  } '||chr(10)||
'  else '||chr(10)||
'  { '||chr(10)||
'    ClearAll(); '||chr(10)||
'  } '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function Check(e) '||chr(10)||
'{ '||chr(10)||
'  e.checked = true; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function Clear(e)'||chr(10)||
'{ '||chr(10)||
'  e.checked = false; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function CheckAll() '||chr(10)||
'{ '||chr(10)||
'  var ml = document.wwv_flow; '||chr(10)||
'  var len = ml.elements.length; '||chr(10)||
'  for (var i = 0; i < len; i++) '||chr(10)||
'  { '||chr(10)||
'    var e = ml.elements[i]; '||chr(10)||
'    if (e.name == "f01") '||chr(10)||
'    { '||chr(10)||
'      if (e.disabled == false)'||chr(10)||
'      {'||chr(10)||
'        Check(e); '||chr(10)||
'      }'||chr(10)||
'    } '||chr(10)||
'  } '||chr(10)||
'  ml.f01.checked = true; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function ClearAll() '||chr(10)||
'{ '||chr(10)||
'  var ml = document.wwv_flow; '||chr(10)||
'  var len = ml.elements.length; '||chr(10)||
'  for (var i = 0; i < len; i++) '||chr(10)||
'  { '||chr(10)||
'    var e = ml.elements[i]; '||chr(10)||
'    if (e.name == "f01") '||chr(10)||
'    { '||chr(10)||
'      Clear(e); '||chr(10)||
'    } '||chr(10)||
'  } '||chr(10)||
'  ml.f01.checked = false; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
'var g_LastRowOpened = false;'||chr(10)||
'var g_LastDetailLabel = false;'||chr(10)||
'var g_ShowOnlyOne = false;'||chr(10)||
'var g_LastNewRowOpened = false;'||chr(10)||
''||chr(10)||
'function showdetail(t,i){'||chr(10)||
'	var l_TR = html_CascadeUpTill(t,''TR'');'||chr(10)||
'	var l_ThisTable = html_CascadeUpTill(t,''TABLE'');'||chr(10)||
'	if(t.innerHTML == ''hide_detail''){'||chr(10)||
'		html_GetElement(g_LastNewRowOpened).parentNode.removeChild(html_GetElement(g_LastNewRowOpened))'||chr(10)||
'		SetDetailLabel(g_LastDetailLabel);'||chr(10)||
'		g_LastDetailLabel = false;'||chr(10)||
'	  g_LastRowOpened = false;'||chr(10)||
'	  g_LastNewRowOpened = false;'||chr(10)||
'  }else{'||chr(10)||
'	  if(html_GetElement(g_LastNewRowOpened)){'||chr(10)||
'				html_GetElement(g_LastNewRowOpened).parentNode.removeChild(html_GetElement(g_LastNewRowOpened))'||chr(10)||
'  			SetDetailLabel(g_LastDetailLabel);'||chr(10)||
'  			l_ThisTable.normalize();'||chr(10)||
'	}'||chr(10)||
'	ShowHideDetailRow(t,l_ThisTable,l_TR,i);	'||chr(10)||
'	g_LastDetailLabel = t; // set the last show/hide_detail clicked'||chr(10)||
'	g_LastRowOpened = l_TR; // set the last row clicked	'||chr(10)||
'}'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function ShowHideDetailRow(pThis,pTable,pTR,pID){'||chr(10)||
'	var l_Detail = ''detail''+pID;'||chr(10)||
'	var l_NumCells = pTR.cells.length'||chr(10)||
'	if(pTR.rowIndex == pTable.rows.length-1 || pTable.rows[pTR.rowIndex+1].className != "detail"){'||chr(10)||
'		var myNewRow = pTable.insertRow(pTR.rowIndex+1);'||chr(10)||
'		g_LastNewRowOpened = myNewRow;'||chr(10)||
'		myNewRow.className = "detail";'||chr(10)||
'		var myNewCell = myNewRow.insertCell(0);'||chr(10)||
'		myNewCell.className = "t4data";'||chr(10)||
'		myNewCell.style.padding = 0;'||chr(10)||
'		myNewCell.colSpan=l_NumCells;'||chr(10)||
'                gURL = ''f?p=4400:44:&SESSION.::NO:RP:P44_REPORT_ID:''+ pID;'||chr(10)||
'		gReturn = ''<iframe src="''+gURL+''" style="border:none;width:100%;height:250px;" frameborder="0" framespacing="0" marginheight="0" marginwidth="0"></iframe>'';'||chr(10)||
'		myNewCell.innerHTML = gReturn;'||chr(10)||
'		html_ShowElement(l_Detail);'||chr(10)||
'	}else{'||chr(10)||
'		html_ToggleElement(pTable.rows[pTR.rowIndex+1]);'||chr(10)||
'	}'||chr(10)||
'	SetDetailLabel(pThis);'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function SetDetailLabel(pThis){'||chr(10)||
'	if(pThis.innerHTML == ''show_detail''){'||chr(10)||
'		pThis.innerHTML = ''hide_detail'''||chr(10)||
'	}else{'||chr(10)||
'		pThis.innerHTML = ''show_detail'''||chr(10)||
'	}'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
''||chr(10)||
'</script>',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 27093615521778199.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P8_DISPLAY',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3761621502175056.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> ' ',
  p_column_display_sequence=> 1,
  p_column_heading=> ' <input type="checkbox" name="f10" value=" " onclick="ToggleAll(this)">',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24169115417375787.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'APEX_TYPE',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Migrer vers',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_cattributes=> 'style="width: 50px;"',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3763125855186642.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FORMID',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Formid',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3763229037186644.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FORMNAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Panneau Access',
  p_column_link=>'f?p=&APP_ID.:45:&SESSION.:FRM:&DEBUG.::P45_FORM_NAME,P45_FORM_ID,P45_OBJECT_TYPE:#FORMNAME#,#FORMID#,#SOURCE_TYPE#',
  p_column_linktext=>'#FORMNAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 19470629851002476.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PARENT_FORMID',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Parent Formid',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3761914555175058.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'RECORDSOURCE',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Record Source',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3762024416175058.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'DBNAME',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Database',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3762517684175059.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'SOURCE_TYPE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Source Type',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>6520502328008192 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4564609785567181.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'SOURCE_NAME',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Nom de source',
  p_column_linktext=>'<img src="#IMAGE_PREFIX#e2.gif" border="0" alt="Modifier">',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3762228429175058.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Status',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8579111465363797.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'Startup Form',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Panneau de démarrage',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3762315327175058.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'STAT',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Statut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>3,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>237819027746437948 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 8528229671508013.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'SRC_TYPE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Type de source',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>6520502328008192 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3762405754175059.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'DETAIL',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Detail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20945320206253512.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'PARENT_FORMNAME',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Panneau parent',
  p_column_link=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.::P45_FORM_NAME,P45_FORM_ID,P45_OBJECT_TYPE:#PARENT_FORMNAME#,#PARENT_FORMID#,#PARENT_SOURCE_TYPE#',
  p_column_linktext=>'#PARENT_FORMNAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 20951011988307827.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 3761418105174987.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'PARENT_SOURCE_TYPE',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Parent Source Type',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'htp.p(''<span class="instructiontext">'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P8_FORMS_HELP''));'||chr(10)||
'htp.p(''</span><br />'');'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 6808303553822320.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4402,
  p_plug_name=> 'Panneaux',
  p_region_name=>'',
  p_plug_template=> 86904609451444726.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22750310663636939.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4402,
  p_plug_name=> 'SQL Query Tasks',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 100,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 36541431940113088 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 31241921082712866.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 34274407765184355.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4402,
  p_plug_name=> 'Barre supérieure',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3766722785214185.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8.4402,
  p_button_sequence=> 50,
  p_button_plug_id => 34274407765184355+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3767910449220064.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4402,
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>3766722785214185.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 30,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 22-JUN-2006 04:37 by HILARY');
 
wwv_flow_api.create_page_branch(
  p_id=>4832524335267733.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4402,
  p_branch_action=> 'f?p=&FLOW_ID.:8:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>22751723476640623.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4402,
  p_branch_action=> 'f?p=&APP_ID.:10:&SESSION.:COMPILE_ALL:&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 109,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'COMPILE_ALL',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>4832324802267731.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4402,
  p_name=>'P8_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 34274407765184355.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>20851130022059368.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4402,
  p_name=>'P8_OBJECT_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Object Type',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour rechercher un panneau, saisissez son nom sans distinction entre les majuscules et les minuscules et cliquez sur <b>OK</b>. Pour visualiser tous les panneaux, laissez le champ vide et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>31325705441654561.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4402,
  p_name=>'P8_FORM',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 34274407765184355.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Panneau',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de panneaux à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>31329715577714290.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4402,
  p_name=>'P8_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 34274407765184355.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'  l_dbid number := 0;'||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'  if :P8_DBID is null then'||chr(10)||
'    for c3 in ('||chr(10)||
'        select dbid from wwv_mig_access'||chr(10)||
'        where project_id = :MW_PROJ_ID'||chr(10)||
'        and security_group_id = :flow_security_group_id'||chr(10)||
'        and linkdbid is null'||chr(10)||
'    )'||chr(10)||
'    loop'||chr(10)||
'      l_dbid := c3.dbid;'||chr(10)||
'    end loop;'||chr(10)||
'  else'||chr(10)||
'    l_dbid := :P8_DBID;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'    --'||chr(10)||
'    -- First, go through all of the elements (in the ';

p:=p||'2nd array)'||chr(10)||
'    -- and set them to exclude'||chr(10)||
'    --'||chr(10)||
'    forall i in 1..htmldb_application.g_f02.count'||chr(10)||
'        update wwv_mig_rev_forms '||chr(10)||
'           set status = ''EXCLUDE'''||chr(10)||
'         where formid = htmldb_application.g_f02(i)'||chr(10)||
'           and status <> ''EXCLUDE'''||chr(10)||
'           and project_id = :MW_PROJ_ID'||chr(10)||
'           and dbid = l_dbid'||chr(10)||
'           and security_group_id = :flow_security_group_id;  '||chr(10)||
'      '||chr(10)||
'    --'||chr(10)||
' ';

p:=p||'   -- Then, go through the elements of the first array and update them'||chr(10)||
'    -- to include'||chr(10)||
'    --'||chr(10)||
'    forall i in 1..htmldb_application.g_f01.count'||chr(10)||
'           update wwv_mig_rev_forms '||chr(10)||
'           set status = ''INCLUDE'''||chr(10)||
'           where formid = htmldb_application.g_f01(i)'||chr(10)||
'           and project_id = :MW_PROJ_ID'||chr(10)||
'           and dbid = l_dbid'||chr(10)||
'           and security_group_id = :flow_security_group_id; ';

p:=p||'       '||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'    forall i in 1..htmldb_application.g_f03.count'||chr(10)||
'           update wwv_mig_rev_forms'||chr(10)||
'           set mig_type = htmldb_application.g_f03(i)'||chr(10)||
'           where formid = htmldb_application.g_f04(i)'||chr(10)||
'           and project_id = :MW_PROJ_ID'||chr(10)||
'           and dbid = l_dbid'||chr(10)||
'           and security_group_id = :flow_security_group_id;                      '||chr(10)||
''||chr(10)||
' '||chr(10)||
'--    forall i in 1..htmldb_application.g';

p:=p||'_f01.count'||chr(10)||
'--           update wwv_mig_rev_forms '||chr(10)||
'--           set mig_type = decode(htmldb_application.g_f03(i),null,''FORM'',htmldb_application.g_f03(i))'||chr(10)||
'--           where formid = htmldb_application.g_f01(i)'||chr(10)||
'--           and project_id = :MW_PROJ_ID'||chr(10)||
'--           and dbid = l_dbid'||chr(10)||
'--           and security_group_id = :flow_security_group_id;          '||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 6804623245799601.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set report object status in wwv_mig_rev_forms',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
''||chr(10)||
'  l_status   varchar2(32767);'||chr(10)||
'  l_syntax   varchar2(32767);'||chr(10)||
'  l_ans      number := 0;'||chr(10)||
'  l_length   number := 0;'||chr(10)||
'  l_dbid     number := 0;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'  for c2 in ('||chr(10)||
'       select dbid from wwv_mig_access'||chr(10)||
'       where project_id = :MW_PROJ_ID'||chr(10)||
'       and security_group_id = :flow_security_group_id'||chr(10)||
'       and linkdbid is null'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    l_dbid := c2.dbid;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  -- '||chr(10)||
'  -- Get list of S';

p:=p||'QL Queries and associated formids'||chr(10)||
'  --'||chr(10)||
'  for c1 in'||chr(10)||
'  ('||chr(10)||
'  	select source_syntax, formid  '||chr(10)||
'        from wwv_mig_rev_forms'||chr(10)||
'        where source_type = ''SQL Query'''||chr(10)||
'  	and project_id = :MW_PROJ_ID'||chr(10)||
'  	and dbid = l_dbid'||chr(10)||
'  	and security_group_id = :flow_security_group_id'||chr(10)||
'  	and owner = :P2_SCHEMA  '||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    if (c1.source_syntax is not null) then'||chr(10)||
''||chr(10)||
'         -- Remove trailing semi-colon from syntax'||chr(10)||
'  ';

p:=p||'       l_length := LENGTH(c1.source_syntax);     '||chr(10)||
'         l_ans := INSTR(c1.source_syntax,chr(59),l_length -1,1);'||chr(10)||
'         if l_ans <> 0 then'||chr(10)||
'            l_syntax := SUBSTR(c1.source_syntax,0,l_length -1);'||chr(10)||
'         else '||chr(10)||
'            l_syntax := c1.source_syntax;'||chr(10)||
'         end if; '||chr(10)||
''||chr(10)||
'         l_status := wwv_render_report3.is_valid_query('||chr(10)||
'                       p_plug_source => l_syntax,'||chr(10)||
'           ';

p:=p||'            p_plug_source_type => ''SQL_QUERY'','||chr(10)||
'                       p_owner => :P2_SCHEMA);'||chr(10)||
''||chr(10)||
'         if length(l_status) is null then'||chr(10)||
' '||chr(10)||
'           -- Save syntax'||chr(10)||
'           update wwv_mig_rev_forms'||chr(10)||
'           set source_syntax = l_syntax'||chr(10)||
'           where formid = c1.formid'||chr(10)||
'           and project_id = :MW_PROJ_ID'||chr(10)||
'           and security_group_id = :flow_security_group_id'||chr(10)||
'           and dbid = l_';

p:=p||'dbid'||chr(10)||
'           and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'           -- Save status of syntax     '||chr(10)||
'           update wwv_mig_rev_forms'||chr(10)||
'           set source_status = ''VALID'''||chr(10)||
'           where formid = c1.formid'||chr(10)||
'           and project_id = :MW_PROJ_ID'||chr(10)||
'           and security_group_id = :flow_security_group_id'||chr(10)||
'           and dbid = l_dbid'||chr(10)||
'           and owner = :P2_SCHEMA;   '||chr(10)||
''||chr(10)||
'         end if;'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  end loo';

p:=p||'p;'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 22751016896638805.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8.4402,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Compile All Invalid SQL Queries',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'COMPILE_ALL',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 8.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_9.440
prompt  ...PAGE 9.4402: Tables
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_rectables.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 9.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Tables',
  p_step_title=> 'Tables',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162009',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>9.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'htp.p(''<span class="instructiontext">'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P9_TABLES_HELP''));'||chr(10)||
'htp.p(''</span><br />'');'||chr(10)||
'end;'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 6498705725829451.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4402,
  p_plug_name=> 'Tables',
  p_region_name=>'',
  p_plug_template=> 86904609451444726.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20989705527176867.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 34279525558198945.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4402,
  p_plug_name=> 'Barre supérieure',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare '||chr(10)||
'  q varchar2(32767);'||chr(10)||
'begin'||chr(10)||
'  q := '||chr(10)||
''''||chr(10)||
'select distinct'||chr(10)||
'      x.tblid,'||chr(10)||
'      htmldb_item.checkbox(1, x.tblid||'''':''''||x.dbid,'||chr(10)||
'                     decode(x.status,''''VALID'''', '||chr(10)||
'                            decode (x.status_2,''''INCLUDE'''',''''CHECKED'''','||chr(10)||
'                                          --     ''''EXCLUDE'''',''''DISABLED''''),'||chr(10)||
'                                               ''''EXCLUDE'''', decode(x.con';

s:=s||'straint_type,''''P'''',null,''''DISABLED'''')),'||chr(10)||
'                            ''''INVALID'''',''''DISABLED'''','||chr(10)||
'                            null,''''DISABLED''''),null,null,''''f01_''''||rownum,t.inc) ||'||chr(10)||
'                     htmldb_item.hidden(2,x.tblid) " ",'||chr(10)||
'        '||chr(10)||
'       x.tblname,'||chr(10)||
'       x.table_name,'||chr(10)||
'       decode(x.constraint_type, ''''P'''','||chr(10)||
'              ''''<img src="#IMAGE_PREFIX#check_small_black.gif" '||chr(10)||
'              ';

s:=s||'alt="''||wwv_flow_lang.system_message(''F4000.YES'')||''"/>'''','||chr(10)||
'              null) pk,'||chr(10)||
'       decode(x.constraint_type2,''''R'''', '||chr(10)||
'              ''''<img src="#IMAGE_PREFIX#check_small_black.gif" '||chr(10)||
'              alt="''||wwv_flow_lang.system_message(''F4000.YES'')||''"/>'''','||chr(10)||
'              null) fk,'||chr(10)||
'       x.dbname "Database",'||chr(10)||
'       decode(x.status, ''''VALID'''', decode(x.constraint_type,''''P'''',''''VALID'''',''''INVALID''''';

s:=s||'),'||chr(10)||
'                        ''''INVALID'''',''''INVALID'''','||chr(10)||
'                        null, ''''INVALID'''' ) status,'||chr(10)||
'       decode(x.table_id,null,''''-'''','||chr(10)||
'              ''''<img src="#IMAGE_PREFIX#check_small_black.gif" '||chr(10)||
'              alt="''||wwv_flow_lang.system_message(''F4000.YES'')||''"/>'''''||chr(10)||
'              ) table_id'||chr(10)||
'from('||chr(10)||
'select distinct a.TBLID, '||chr(10)||
'                a.TBLNAME, '||chr(10)||
'                n.table_name,'||chr(10)||
'        ';

s:=s||'        d.constraint_type, '||chr(10)||
'                e.constraint_type constraint_type2, '||chr(10)||
'                b.dbname,'||chr(10)||
'                b.database_schema,'||chr(10)||
'                g.status status_2, '||chr(10)||
'                h.table_id, '||chr(10)||
'                a.dbid, '||chr(10)||
'                j.status'||chr(10)||
''||chr(10)||
'from   wwv_mig_access b, '||chr(10)||
'       wwv_mig_rev_tables g, '||chr(10)||
'       wwv_mig_acc_tables a LEFT JOIN  sys.dba_tables n'||chr(10)||
'       on UPPER(wwv_mig_acc_lo';

s:=s||'ad.transform_identifier(a.tblname)) LIKE UPPER(n.table_name) '||chr(10)||
'       and n.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'       '||chr(10)||
'       LEFT JOIN sys.dba_objects j'||chr(10)||
'       on UPPER(n.table_name) LIKE UPPER(j.object_name)'||chr(10)||
'       and j.owner = n.owner       '||chr(10)||
'       '||chr(10)||
'       LEFT JOIN wwv_flow_hnt_table_info h'||chr(10)||
'       on UPPER(j.object_name) = UPPER(h.table_name)'||chr(10)||
'       and h.schema = j.owner'||chr(10)||
'       '||chr(10)||
'       LEFT JOIN SYS.D';

s:=s||'BA_CONSTRAINTS d'||chr(10)||
'       on UPPER(j.object_name) LIKE UPPER(d.table_name)'||chr(10)||
'       and (d.constraint_type = ''''P'''')'||chr(10)||
'       and d.owner = j.owner '||chr(10)||
' '||chr(10)||
'       LEFT JOIN SYS.DBA_CONSTRAINTS e'||chr(10)||
'       on UPPER(e.table_name) LIKE UPPER(d.table_name)'||chr(10)||
'       and (e.constraint_type = ''''R'''')'||chr(10)||
'       and e.owner = d.owner'||chr(10)||
'       '||chr(10)||
'where a.project_id = :MW_PROJ_ID'||chr(10)||
'      and a.security_group_id = :flow_security_group_';

s:=s||'id'||chr(10)||
'      and b.dbid = a.dbid'||chr(10)||
'      and g.tblid = a.tblid'||chr(10)||
'      and g.dbid = a.dbid'||chr(10)||
'      and g.project_ID = a.project_id'||chr(10)||
'      and g.security_group_id = a.security_group_id'||chr(10)||
'      and (:P9_TABLES is null or instr(upper(a.tblname),upper(:P9_TABLES))>0)'';'||chr(10)||
''||chr(10)||
'   if :P9_DBID <> 0 then'||chr(10)||
'      q := q || ''   and a.dbid = :P9_DBID ) x,(select wwv_flow_lang.system_message(''''F4400_INCLUDE_LABEL'''') inc from dual';

s:=s||') t'';'||chr(10)||
'   else'||chr(10)||
'      q := q || '') x,(select wwv_flow_lang.system_message(''''F4400_INCLUDE_LABEL'''') inc from dual) t'';'||chr(10)||
'   end if;'||chr(10)||
''||chr(10)||
'return q;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4402,
  p_name=> 'Table Summary Information',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<script type="text/javascript"> '||chr(10)||
'function ToggleAll(e) '||chr(10)||
'{ '||chr(10)||
'  if (e.checked) '||chr(10)||
'  { '||chr(10)||
'    CheckAll(); '||chr(10)||
'  } '||chr(10)||
'  else '||chr(10)||
'  { '||chr(10)||
'    ClearAll(); '||chr(10)||
'  } '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function Check(e) '||chr(10)||
'{ '||chr(10)||
'  e.checked = true; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function Clear(e)'||chr(10)||
'{ '||chr(10)||
'  e.checked = false; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function CheckAll() '||chr(10)||
'{ '||chr(10)||
'  var ml = document.wwv_flow; '||chr(10)||
'  var len = ml.elements.length; '||chr(10)||
'  for (var i = 0; i < len; i++) '||chr(10)||
'  { '||chr(10)||
'    var e = ml.elements[i]; '||chr(10)||
'    if (e.name == "f01") '||chr(10)||
'    { '||chr(10)||
'      if (e.disabled == false)'||chr(10)||
'      {'||chr(10)||
'        Check(e); '||chr(10)||
'      }'||chr(10)||
'    } '||chr(10)||
'  } '||chr(10)||
'  ml.f01.checked = true; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function ClearAll() '||chr(10)||
'{ '||chr(10)||
'  var ml = document.wwv_flow; '||chr(10)||
'  var len = ml.elements.length; '||chr(10)||
'  for (var i = 0; i < len; i++) '||chr(10)||
'  { '||chr(10)||
'    var e = ml.elements[i]; '||chr(10)||
'    if (e.name == "f01")'||chr(10)||
'    { '||chr(10)||
'      Clear(e); '||chr(10)||
'    } '||chr(10)||
'  } '||chr(10)||
'  ml.f01.checked = false; '||chr(10)||
'} '||chr(10)||
'</script>',
  p_customized=> '0',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P9_DISPLAY',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 1141715315639583.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'TBLID',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Table ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249016305774358444.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> ' ',
  p_column_display_sequence=> 1,
  p_column_heading=> '<input type="checkbox" name="f10" value=" " onclick="ToggleAll(this)">',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249015814160358438.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'TBLNAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Table Access',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249015928990358442.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Table Oracle',
  p_column_link=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::P22_TABLE_NAME:#TABLE_NAME#',
  p_column_linktext=>'#TABLE_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249016000453358443.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PK',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Clé primaire',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249016130944358443.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'FK',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Clé étrangère',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249016402909358444.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'Database',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Database',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249016207574358443.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Statut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>237819027746437948 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249022113088488816.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 249015620257358424.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Valeurs par défaut de l''interface utilisateur',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 778583616631469390.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 34279525558198945+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>99338503672809715.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>778583616631469390.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 13-MAR-2006 13:49 by HILARY');
 
wwv_flow_api.create_page_branch(
  p_id=>21018817945081716.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_branch_action=> 'f?p=&FLOW_ID.:9:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2097525042559368.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_name=>'P9_QUERY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>99175930940660202.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_name=>'P9_INSERTSTATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 34279525558198945.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'false',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>105870623122594340.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_name=>'P9_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>778595302544741273.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_name=>'P9_DBID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'DBID:',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour rechercher une table, saisissez son nom sans distinction entre les majuscules et les minuscules et cliquez sur <b>OK</b>. Pour visualiser toutes les tables, laissez le champ vide et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>778670926192399058.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_name=>'P9_TABLES',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 34279525558198945.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Table',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de tables à afficher et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>778671702428401667.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_name=>'P9_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 34279525558198945.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>778672307276403068.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4402,
  p_name=>'P9_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 34279525558198945.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'  v_tblid number := 0;'||chr(10)||
'  v_dbid number  := 0;'||chr(10)||
'  v_split number := 0;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'    --'||chr(10)||
'    -- First, go through all of the elements (in the 2nd array)'||chr(10)||
'    -- and set them to exclude'||chr(10)||
'    --'||chr(10)||
'    forall i in 1..htmldb_application.g_f02.count'||chr(10)||
'        update wwv_mig_rev_tables '||chr(10)||
'           set status = ''EXCLUDE'''||chr(10)||
'           where tblid = htmldb_application.g_f02(i)'||chr(10)||
'           and status <> ''EXCLUDE''';

p:=p||''||chr(10)||
'           and project_id = :MW_PROJ_ID'||chr(10)||
'           -- and dbid = :P2_DBID'||chr(10)||
'           and security_group_id = :flow_security_group_id;  '||chr(10)||
''||chr(10)||
''||chr(10)||
'    --'||chr(10)||
'    -- Then, go through the elements of the first array and update them'||chr(10)||
'    -- to include'||chr(10)||
'    --'||chr(10)||
'    for i in 1..htmldb_application.g_f01.count'||chr(10)||
'    loop      '||chr(10)||
'        v_split := instr(htmldb_application.g_f01(i),'':'');'||chr(10)||
'        -- Extract tblid from array ';

p:=p||'item'||chr(10)||
'        v_tblid := substr(htmldb_application.g_f01(i),1,v_split-1);'||chr(10)||
'        -- Extract dbid from array item'||chr(10)||
'        v_dbid := substr(htmldb_application.g_f01(i),v_split+1); '||chr(10)||
''||chr(10)||
'        update wwv_mig_rev_tables'||chr(10)||
'        set status = ''INCLUDE'''||chr(10)||
'        where tblid = v_tblid'||chr(10)||
'        and project_id = :MW_PROJ_ID'||chr(10)||
'        and dbid = v_dbid'||chr(10)||
'        and security_group_id = :flow_security_group_id;'||chr(10)||
'    e';

p:=p||'nd loop;'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 6795832371736058.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9.4402,
  p_process_sequence=> 12,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set table object status in wwv_mig_rev_tables',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 9.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_10.44
prompt  ...PAGE 10.4402: Interrogations
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_recquery.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 10.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Interrogations',
  p_step_title=> 'Interrogations',
  p_step_sub_title => 'Queries',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162009',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>10.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'htp.p(''<span class="instructiontext">'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P10_QUERIES_HELP''));'||chr(10)||
'htp.p(''</span><br />'');'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 6806729610810917.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4402,
  p_plug_name=> 'Interrogations',
  p_region_name=>'',
  p_plug_template=> 86904609451444726.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 15,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20907800314673926.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20911927242700596.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4402,
  p_plug_name=> 'Barre supérieure',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 21305932006952157.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4402,
  p_plug_name=> 'Query Tasks',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 25,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 21304628412941720 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<div id="results"></div>';

wwv_flow_api.create_page_plug (
  p_id=> 30819323242685512.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4402,
  p_plug_name=> 'Résultats',
  p_region_name=>'',
  p_plug_template=> 244065612129731419.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare '||chr(10)||
''||chr(10)||
'  q varchar2(32767);'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
'  q := '||chr(10)||
''''||chr(10)||
'select distinct'||chr(10)||
'       htmldb_item.checkbox(1, x.qryid ||'''':''''||x.dbid,'||chr(10)||
'                     decode(x.status,''''VALID'''', '||chr(10)||
'                            decode(x.status_2,''''INCLUDE'''',''''CHECKED'''',null),'||chr(10)||
'                                              ''''INVALID'''',''''DISABLED'''','||chr(10)||
'                                              null,''''DISABLED''''),null,null,''''f01_''';

s:=s||'''||rownum,t.inc) ||'||chr(10)||
'                     htmldb_item.hidden(2,x.qryid) " ",     '||chr(10)||
'       x.qryid,'||chr(10)||
'       x.orig_qry_name,'||chr(10)||
'       --decode(x.mig_view_name,null,''''-invalid-'''',x.mig_view_name) mig_view_name,'||chr(10)||
'       x.mig_view_name,'||chr(10)||
'       decode(x.status, ''''VALID'''', ''''VALID'''','||chr(10)||
'                        ''''INVALID'''',''''INVALID'''','||chr(10)||
'                        null, ''''INVALID'''' ) status,'||chr(10)||
'       decode(x.table_id,';

s:=s||'null,null,'||chr(10)||
'              ''''<img src="#IMAGE_PREFIX#check_small_black.gif" '||chr(10)||
'              alt="''||wwv_flow_lang.system_message(''F4000.YES'')||''"/>'''''||chr(10)||
'              ) table_id       '||chr(10)||
'from('||chr(10)||
'  select distinct a.qryid, '||chr(10)||
'                a.qryname orig_qry_name,'||chr(10)||
'                g.mig_view_name,'||chr(10)||
'                b.status,'||chr(10)||
'                g.status status_2,'||chr(10)||
'                h.table_id,'||chr(10)||
'                a.dbid'||chr(10)||
' ';

s:=s||' from   wwv_mig_acc_queries a ,'||chr(10)||
'         wwv_mig_rev_queries g '||chr(10)||
''||chr(10)||
'         LEFT JOIN sys.dba_objects b'||chr(10)||
'         on UPPER(g.mig_view_name) LIKE UPPER(b.object_name)'||chr(10)||
'         and b.owner = UPPER(:P2_SCHEMA)'||chr(10)||
'       '||chr(10)||
'         LEFT JOIN wwv_flow_hnt_table_info h'||chr(10)||
'         on UPPER(g.mig_view_name) = UPPER(h.table_name)'||chr(10)||
'         and g.owner = h.schema'||chr(10)||
'       '||chr(10)||
'  where  a.project_id = :MW_PROJ_ID'||chr(10)||
'  and    a';

s:=s||'.security_group_id = :flow_security_group_id'||chr(10)||
'  and    g.qryid = a.qryid'||chr(10)||
'  and    g.dbid = a.dbid'||chr(10)||
'  and    g.project_ID = a.project_id'||chr(10)||
'  and    g.security_group_id = a.security_group_id'||chr(10)||
'  and (:P10_QUERY is null or instr(upper(a.qryname),upper(:P10_QUERY))>0)'';'||chr(10)||
''||chr(10)||
'  if :P10_DBID <> 0 then'||chr(10)||
'    q := q || ''  and a.dbid = :P10_DBID ) x, (select wwv_flow_lang.system_message(''''F4400_INCLUDE_LABEL'''') inc fr';

s:=s||'om dual) t '';'||chr(10)||
'  else'||chr(10)||
'    q := q || '') x, (select wwv_flow_lang.system_message(''''F4400_INCLUDE_LABEL'''') inc from dual) t '';'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'return q;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 57026210165178075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4402,
  p_name=> 'Query Information',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 5,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<script type="text/javascript"> '||chr(10)||
'function ToggleAll(e) '||chr(10)||
'{ '||chr(10)||
'  if (e.checked) '||chr(10)||
'  { '||chr(10)||
'    CheckAll(); '||chr(10)||
'  } '||chr(10)||
'  else '||chr(10)||
'  { '||chr(10)||
'    ClearAll(); '||chr(10)||
'  } '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function Check(e) '||chr(10)||
'{ '||chr(10)||
'  e.checked = true; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function Clear(e)'||chr(10)||
'{ '||chr(10)||
'  e.checked = false; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function CheckAll() '||chr(10)||
'{ '||chr(10)||
'  var ml = document.wwv_flow; '||chr(10)||
'  var len = ml.elements.length; '||chr(10)||
'  for (var i = 0; i < len; i++) '||chr(10)||
'  { '||chr(10)||
'    var e = ml.elements[i]; '||chr(10)||
'    if (e.name == "f01") '||chr(10)||
'    { '||chr(10)||
'      if (e.disabled == false)'||chr(10)||
'      {'||chr(10)||
'        Check(e); '||chr(10)||
'      }'||chr(10)||
'    } '||chr(10)||
'  } '||chr(10)||
'  ml.f01.checked = true; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function ClearAll() '||chr(10)||
'{ '||chr(10)||
'  var ml = document.wwv_flow; '||chr(10)||
'  var len = ml.elements.length; '||chr(10)||
'  for (var i = 0; i < len; i++) '||chr(10)||
'  { '||chr(10)||
'    var e = ml.elements[i]; '||chr(10)||
'    if (e.name == "f01") '||chr(10)||
'    { '||chr(10)||
'      Clear(e); '||chr(10)||
'    } '||chr(10)||
'  } '||chr(10)||
'  ml.f01.checked = false; '||chr(10)||
'} '||chr(10)||
'</script>',
  p_customized=> '0',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '-',
  p_query_break_cols=> '1:2',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P10_DISPLAY',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57026427200178083.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 57026210165178075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> ' ',
  p_column_display_sequence=> 1,
  p_column_heading=> '<input type="checkbox" name="f10" value=" " onclick="ToggleAll(this)">',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57026528712178083.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 57026210165178075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'QRYID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57026630626178083.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 57026210165178075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ORIG_QRY_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Interrogation Access',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57026708711178083.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 57026210165178075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'MIG_VIEW_NAME',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Vue Oracle',
  p_column_link=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:30:P30_QUERY_NAME,P30_VIEW_NAME:#ORIG_QRY_NAME#,#MIG_VIEW_NAME#',
  p_column_linktext=>'#MIG_VIEW_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57026816961178083.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 57026210165178075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Statut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>237819027746437948 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 57026914841178083.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 57026210165178075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Valeurs par défaut de l''interface utilisateur',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109126606921865735.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4402,
  p_button_sequence=> 5,
  p_button_plug_id => 20911927242700596+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>21017703077073395.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4402,
  p_branch_action=> 'f?p=&APP_ID.:10:&SESSION.:COMPILE_ALL:&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'COMPILE_ALL',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>109203901164573704.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4402,
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>109126606921865735.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 28-MAR-2006 13:57 by HILARY');
 
wwv_flow_api.create_page_branch(
  p_id=>20913600092707269.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4402,
  p_branch_action=> 'f?p=&FLOW_ID.:10:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour rechercher une interrogation, saisissez une interrogation sans distinction entre les majuscules et les minuscules pour le nom d''interrogation. Pour visualiser toutes les interrogations, laissez le champ vide et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>20912805902703900.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4402,
  p_name=>'P10_QUERY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 20911927242700596.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Interrogation',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre d''interrogations à afficher et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>20987231238165354.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4402,
  p_name=>'P10_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 20911927242700596.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>21025109279124203.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4402,
  p_name=>'P10_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 20911927242700596.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>107222513716000621.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4402,
  p_name=>'P10_DBID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'DBID: ',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>109195201501498112.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4402,
  p_name=>'P10_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'X',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'  v_qryid number := 0;'||chr(10)||
'  v_dbid number  := 0;'||chr(10)||
'  v_split number := 0;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
'    --'||chr(10)||
'    -- First, go through all of the elements (in the 2nd array)'||chr(10)||
'    -- and set them to exclude'||chr(10)||
'    --'||chr(10)||
'    forall i in 1..htmldb_application.g_f02.count'||chr(10)||
'        update wwv_mig_rev_queries '||chr(10)||
'        set status = ''EXCLUDE'''||chr(10)||
'        where qryid = htmldb_application.g_f02(i)'||chr(10)||
'        and status <> ''EXCLUDE'''||chr(10)||
'        ';

p:=p||'and project_id = :MW_PROJ_ID'||chr(10)||
'        -- and dbid = :P2_DBID'||chr(10)||
'        and security_group_id = :flow_security_group_id;        '||chr(10)||
''||chr(10)||
'    --'||chr(10)||
'    -- Then, go through the elements of the first array and update them'||chr(10)||
'    -- to include'||chr(10)||
'    --'||chr(10)||
'    for i in 1..htmldb_application.g_f01.count'||chr(10)||
'    loop'||chr(10)||
'        v_split := instr(htmldb_application.g_f01(i),'':'');'||chr(10)||
'        -- Extract qryid from array item'||chr(10)||
'        v_qryi';

p:=p||'d := substr(htmldb_application.g_f01(i),1,v_split-1);'||chr(10)||
'        -- Extract dbid from array item'||chr(10)||
'        v_dbid := substr(htmldb_application.g_f01(i),v_split+1);'||chr(10)||
'   '||chr(10)||
'        update wwv_mig_rev_queries '||chr(10)||
'        set status = ''INCLUDE'''||chr(10)||
'        where qryid = v_qryid'||chr(10)||
'        and project_id = :MW_PROJ_ID'||chr(10)||
'        and dbid = v_dbid'||chr(10)||
'        and security_group_id = :flow_security_group_id;        '||chr(10)||
'    end loop';

p:=p||';'||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 6800001728765064.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'submit status to wwv_mig_rev_queries',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'l_arr    wwv_flow_global.n_arr;'||chr(10)||
'l_arr2   wwv_flow_global.vc_arr2;'||chr(10)||
'l_test   varchar2(32378);'||chr(10)||
'x        dbms_sql.varchar2s;'||chr(10)||
'l_errs   number;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'for i in 1..htmldb_application.g_f02.count'||chr(10)||
'loop'||chr(10)||
''||chr(10)||
'  -- '||chr(10)||
'  -- Get list of view names'||chr(10)||
'  --'||chr(10)||
'  for c1 in ('||chr(10)||
'  select mig_view_name from wwv_mig_rev_queries'||chr(10)||
'  where qryid = htmldb_application.g_f02(i)'||chr(10)||
'  and project_id = :MW_PROJ_ID'||chr(10)||
'  and dbid = :P2_DBID';

p:=p||''||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    l_arr2(i) := c1.mig_view_name;'||chr(10)||
'  end loop;'||chr(10)||
' '||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
'for j in 1..l_arr2.count'||chr(10)||
'--for j in 1..3'||chr(10)||
'loop'||chr(10)||
'  if (l_arr2(j) is not null) then'||chr(10)||
'    x(1) := ''alter VIEW "''||l_arr2(j)||''" compile '';'||chr(10)||
'    wwv_flow_f4000_util.run_ddl( x, :P2_SCHEMA );'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
' -- l_test := l_test ||l_arr2(j);'||chr(10)||
'  '||chr(10)||
'  for r in ( SELECT  count(1) cnt'||chr(10)||
'             FROM  sys.dba_errors'||chr(10)||
'             WHERE  NAME = l';

p:=p||'_arr2(j) '||chr(10)||
'             AND TYPE = ''VIEW'' )'||chr(10)||
'  loop'||chr(10)||
'      l_errs := r.cnt;'||chr(10)||
'  end loop;'||chr(10)||
'  htp.p(''<div style="border:1px #aaaaaa solid;background: #eeeeee;font-size:10pt;padding:4px;margin:8px;">'');'||chr(10)||
'  if ( l_errs > 0 ) then'||chr(10)||
'      htp.p(wwv_flow_lang.system_message(p_name=>''OB_COMPILE_ERRORS'',p0=>l_errs));'||chr(10)||
'  else '||chr(10)||
'        htp.p(wwv_flow_lang.system_message(p_name=>''F4500_P11_NO_ERROR''));'||chr(10)||
'  end if;'||chr(10)||
'  ht';

p:=p||'p.p(''</div>'');'||chr(10)||
''||chr(10)||
''||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'--:P10_X := l_test;'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 110531524774346611.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4402,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'compile views',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Echec',
  p_process_when=>'COMPILE',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> 'Succès',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
''||chr(10)||
'  l_test   varchar2(32378);'||chr(10)||
'  x        dbms_sql.varchar2s;'||chr(10)||
'  l_errs   number := 0;'||chr(10)||
'  l_sum    number := 0;'||chr(10)||
'  l_dbid   number := 0;'||chr(10)||
'  l_exists number := 0;'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'  for c2 in ('||chr(10)||
'     select dbid from wwv_mig_access'||chr(10)||
'     where project_id = :MW_PROJ_ID'||chr(10)||
'     and security_group_id = :flow_security_group_id'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'   '||chr(10)||
'    l_dbid := c2.dbid;'||chr(10)||
''||chr(10)||
'    -- '||chr(10)||
'    -- Get list of view names'||chr(10)||
'    --'||chr(10)||
'    ';

p:=p||'for c1 in ('||chr(10)||
'               select mig_view_name '||chr(10)||
'               from wwv_mig_rev_queries'||chr(10)||
'               where project_id = :MW_PROJ_ID'||chr(10)||
'               and dbid = l_dbid'||chr(10)||
'               and security_group_id = :flow_security_group_id'||chr(10)||
'    )'||chr(10)||
'    loop'||chr(10)||
'      if (c1.mig_view_name is not null) then'||chr(10)||
'        '||chr(10)||
'        --'||chr(10)||
'        -- Check data dictionary for view name'||chr(10)||
'        --'||chr(10)||
'        for c3 in ('||chr(10)||
'           ';

p:=p||'        select count(*) cnt from sys.dba_objects'||chr(10)||
'                   where object_name = c1.mig_view_name'||chr(10)||
'                   and object_type = ''VIEW'''||chr(10)||
'                   and owner = :P2_SCHEMA'||chr(10)||
'        )'||chr(10)||
'        loop'||chr(10)||
'          l_exists := c3.cnt;  '||chr(10)||
'        end loop;'||chr(10)||
'        '||chr(10)||
'        -- Attempt to compile existing view'||chr(10)||
'        if l_exists <> 0 then'||chr(10)||
''||chr(10)||
'          x(1) := ''alter VIEW "''||c1.mig_view_name||';

p:=p||'''" compile '';'||chr(10)||
'          wwv_flow_f4000_util.run_ddl( x, :P2_SCHEMA );'||chr(10)||
'  '||chr(10)||
'          for r in ( '||chr(10)||
'                    SELECT  count(1) cnt'||chr(10)||
'                    FROM  sys.dba_errors'||chr(10)||
'                    WHERE  NAME = c1.mig_view_name '||chr(10)||
'                    AND TYPE = ''VIEW'' '||chr(10)||
'          )'||chr(10)||
'          loop'||chr(10)||
'            l_errs := r.cnt;'||chr(10)||
'          end loop;'||chr(10)||
''||chr(10)||
'          l_sum := htmldb_application.g_f02.count - l_e';

p:=p||'rrs;'||chr(10)||
''||chr(10)||
'          htp.p(''<div id="results" style="border:1px #aaaaaa solid;background: #eeeeee;font-size:10pt;padding:4px;margin:8px;">''); '||chr(10)||
'          htp.p(''queries were validated'');'||chr(10)||
'          htp.p(''</div>'');'||chr(10)||
''||chr(10)||
'        end if;'||chr(10)||
''||chr(10)||
'      end if;'||chr(10)||
''||chr(10)||
'    end loop;'||chr(10)||
' '||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 21315929993131394.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4402,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Compile All Invalid Queries',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'COMPILE_ALL',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 10.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_11.44
prompt  ...PAGE 11.4402: Nouvelle définition de page
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_howgenapp.htm';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
''||chr(10)||
'  function modelDisableItem(itemNode, checkItemNode, itemVal) '||chr(10)||
'  {'||chr(10)||
'    if($x(itemNode))'||chr(10)||
'    {'||chr(10)||
'      if (itemVal!=''ONLOAD'') '||chr(10)||
'      {'||chr(10)||
'        itemNode.value = itemVal;'||chr(10)||
'      }   '||chr(10)||
'      html_disableItem(itemNode, checkItemNode.checked);'||chr(10)||
'    }'||chr(10)||
'  }'||chr(10)||
'    '||chr(10)||
'  function modelDisableItem2(itemNode, checkItemNode, itemVal) '||chr(10)||
'  {'||chr(10)||
'    itemNode.value = itemVal';

ph:=ph||';'||chr(10)||
'    if (checkItemNode.checked==false) '||chr(10)||
'    {'||chr(10)||
'      if (document.getElementById(''P11_LINK_COLUMN'').value!=''LINK$'') '||chr(10)||
'      {'||chr(10)||
'                document.getElementById(''P11_LINK_TEXT'').value=''#''+document.getElementById(''P11_LINK_COLUMN'').value+''#'';'||chr(10)||
'            }    '||chr(10)||
'        }'||chr(10)||
'        html_disableItem(itemNode, checkItemNode.checked);'||chr(10)||
'    }'||chr(10)||
'    '||chr(10)||
'  function modelDisableLinkText() '||chr(10)||
'  {'||chr(10)||
'    if($x(''P11_LI';

ph:=ph||'NK_TEXT''))'||chr(10)||
'    {'||chr(10)||
'      if (document.getElementById(''P11_LINK_TEXT'').value.length==0) '||chr(10)||
'      {'||chr(10)||
'        html_disableItem(document.getElementById(''P11_LINK_TEXT''), true);'||chr(10)||
'        html_disableItem($x(''P11_LINK_COLUMN''), true);'||chr(10)||
'      } '||chr(10)||
'      else '||chr(10)||
'      {'||chr(10)||
'        document.getElementById(''P11_USE_THEME_BUTTON_0'').checked=false;'||chr(10)||
'      }'||chr(10)||
'    }'||chr(10)||
'  }'||chr(10)||
''||chr(10)||
'    htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||chr(10)||
''||chr(10)||
'  fun';

ph:=ph||'ction modelDisableItems(itemVal)'||chr(10)||
'  {'||chr(10)||
'    if (itemVal==''LINK_COLUMN'')'||chr(10)||
'    {'||chr(10)||
'      html_disableItem(''P11_LINK_COLUMN'', true);'||chr(10)||
'      html_disableItem(''P11_LINK_TEXT'', true);'||chr(10)||
'    }'||chr(10)||
'    if (itemVal == ''REPORT_COLUMN'')'||chr(10)||
'    {'||chr(10)||
'      html_disableItem(''P11_LINK_TEXT'', true);'||chr(10)||
'      html_disableItem(''P11_LINK_COLUMN'',false);'||chr(10)||
'    }'||chr(10)||
'    if (itemVal == ''CUSTOM_LINK'')'||chr(10)||
'    {'||chr(10)||
'      html_disableItem(''P11_LINK_COLUMN';

ph:=ph||''', true);'||chr(10)||
'      html_disableItem(''P11_LINK_TEXT'',false);'||chr(10)||
'    }'||chr(10)||
'  }'||chr(10)||
''||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 11.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Nouvelle définition de page',
  p_step_title=> 'Nouvelle définition de page',
  p_html_page_onload=>'onLoad="modelDisableLinkText();modelDisableItem(document.getElementById(''P11_LINK_COLUMN''), document.getElementById(''P11_USE_LINK_COLUMN_0''),''ONLOAD'');"',
  p_step_sub_title => 'New Page Definition',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'ON',
  p_group_id => 280687701592255307+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 107477536179540544.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090528134448',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>11.4402,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>11.4402,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6729919867658132.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4402,
  p_plug_name=> 'Définition de page',
  p_region_name=>'',
  p_plug_template=> 5096822001046010.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6730106581658152.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4402,
  p_plug_name=> 'Top Bar',
  p_region_name=>'',
  p_plug_template=> 8237433822756984.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6730312066658152.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4402,
  p_plug_name=> 'Associations de la page parent à cette colonne de page',
  p_region_name=>'',
  p_plug_template=> 5096822001046010.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'EXISTS',
  p_plug_display_when_condition => 'select * from wwv_flow_model_pages '||chr(10)||
'where id = nvl(replace(:P11_PARENT_PAGE_ID,''%''||''null%'',0),0)'||chr(10)||
'and page_type = ''REPORT''',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'"ID",'||chr(10)||
'"ID" ID_DISPLAY,'||chr(10)||
'"MODEL_REGION_ID",'||chr(10)||
'"COLUMN_NAME",'||chr(10)||
'"COLUMN_DISPLAY_NAME",'||chr(10)||
'"DISPLAY_AS_FORM",'||chr(10)||
'"DISPLAY_AS_TAB_FORM",'||chr(10)||
'"DATATYPE",'||chr(10)||
'"ALIGNMENT",'||chr(10)||
'"FORMAT_MASK",'||chr(10)||
'"HIDDEN_COLUMN",'||chr(10)||
'"SORT_SEQUENCE",'||chr(10)||
'"DISPLAY_WIDTH",'||chr(10)||
'"MAX_WIDTH",'||chr(10)||
'"HEIGHT",'||chr(10)||
'"HELP_TEXT",'||chr(10)||
'"SECURITY_GROUP_ID"'||chr(10)||
'from "#OWNER#"."WWV_FLOW_MODEL_PAGE_COLS"'||chr(10)||
'where model_region_id = :P11_REGION_ID'||chr(10)||
'and column_name not like ''LINK$%''';

wwv_flow_api.create_report_region (
  p_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4402,
  p_name=> '&P11_COL_REGION_HEADING.',
  p_region_name=>'',
  p_template=> 5096822001046010.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 35,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P11_PAGE_TYPE',
  p_display_when_cond2=> 'BLANK',
  p_display_condition_type=> 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 27093615521778199.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '100000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'L''état n''a renvoyé aucune ligne.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6730720154658161.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_pk_col_source_type=> 'T',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_ref_schema=> 'FLOWS_030000',
  p_ref_table_name=> 'WWV_FLOW_MODEL_PAGE_COLS',
  p_ref_column_name=> 'ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6730821661658161.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID_DISPLAY',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_column_width=> '16',
  p_pk_col_source=> s,
  p_ref_schema=> 'FLOWS_030000',
  p_ref_table_name=> 'WWV_FLOW_MODEL_PAGE_COLS',
  p_ref_column_name=> 'ID_DISPLAY',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145631929464341240.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'MODEL_REGION_ID',
  p_column_display_sequence=> 17,
  p_column_heading=> 'ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731006303658162.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Nom',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_column_width=> '16',
  p_pk_col_source=> s,
  p_ref_schema=> 'FLOWS_030000',
  p_ref_table_name=> 'WWV_FLOW_MODEL_PAGE_COLS',
  p_ref_column_name=> 'COLUMN_NAME',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731132507658162.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_DISPLAY_NAME',
  p_column_display_sequence=> 4,
  p_column_heading=> 'En-tête/libellé',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '12',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731220564658162.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'DISPLAY_AS_FORM',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Type d''affichage',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_display_when_condition=> 'P483_PAGE_TYPE',
  p_display_when_condition2=> 'FORM',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>6747932423658349 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'YES',
  p_lov_null_text=> '- sélectionner un type d''élément -',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'NO',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731303016658162.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'DISPLAY_AS_TAB_FORM',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Type d''affichage',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_display_when_condition=> 'P483_PAGE_TYPE',
  p_display_when_condition2=> 'TABULARFORM',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>6763505062658374 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731428904658162.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'DATATYPE',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Type de données',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_ref_schema=> 'FLOWS_030000',
  p_ref_table_name=> 'WWV_FLOW_MODEL_PAGE_COLS',
  p_ref_column_name=> 'DATATYPE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731528464658162.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'ALIGNMENT',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Alignement',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST',
  p_display_when_condition=> 'P483_PAGE_TYPE',
  p_display_when_condition2=> 'REPORT:TABULARFORM',
  p_display_as=>'SELECT_LIST_FROM_LOV',
  p_named_lov=>6767129339658379 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_column_width=> '16',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_ref_schema=> 'FLOWS_030000',
  p_ref_table_name=> 'WWV_FLOW_MODEL_PAGE_COLS',
  p_ref_column_name=> 'ALIGNMENT',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731606940658162.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'FORMAT_MASK',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Masque de format',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT',
  p_named_lov=>6766305855658377 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_column_width=> '8',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_ref_schema=> 'FLOWS_030000',
  p_ref_table_name=> 'WWV_FLOW_MODEL_PAGE_COLS',
  p_ref_column_name=> 'FORMAT_MASK',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731722670658162.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'HIDDEN_COLUMN',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Afficher',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST',
  p_display_when_condition=> 'P483_PAGE_TYPE',
  p_display_when_condition2=> 'REPORT:TABULARFORM',
  p_display_as=>'SELECT_LIST_FROM_LOV',
  p_named_lov=>6766513696658378 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'NO',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731811895658163.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'SORT_SEQUENCE',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Séquence de tri',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_display_when_condition=> 'P483_PAGE_TYPE',
  p_display_when_condition2=> 'REPORT',
  p_display_as=>'SELECT_LIST_FROM_QUERY',
  p_inline_lov=> 'select i d, i r from wwv_flow_dual100 where i<=3',
  p_lov_show_nulls=> 'YES',
  p_lov_null_text=> ' - ',
  p_lov_null_value=> '0',
  p_column_width=> '4',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'NO',
  p_ref_schema=> 'FLOWS_030000',
  p_ref_table_name=> 'WWV_FLOW_MODEL_PAGE_COLS',
  p_ref_column_name=> 'SORT_SEQUENCE',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6731917042658164.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'DISPLAY_WIDTH',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Largeur d''élément',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'VALUE_OF_ITEM_IN_CONDITION_IN_COLON_DELIMITED_LIST',
  p_display_when_condition=> 'P483_PAGE_TYPE',
  p_display_when_condition2=> 'FORM:TABULARFORM',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '3',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6732002070658164.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'MAX_WIDTH',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Largeur maximum',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'NEVER',
  p_display_when_condition=> 'P483_PAGE_TYPE',
  p_display_when_condition2=> 'FORM',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '3',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6732122721658164.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'HEIGHT',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Hauteur',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'NEVER',
  p_display_when_condition=> 'P483_PAGE_TYPE',
  p_display_when_condition2=> 'FORM',
  p_display_as=>'TEXT',
  p_lov_show_nulls=> 'NO',
  p_column_width=> '3',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6732218198658164.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'HELP_TEXT',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Help Text',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_when_cond_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_display_when_condition=> 'P483_PAGE_SOURCE',
  p_display_when_condition2=> 'FORM',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6732309118658164.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Security Group Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_column_width=> '16',
  p_pk_col_source=> s,
  p_ref_schema=> 'FLOWS_030000',
  p_ref_table_name=> 'WWV_FLOW_MODEL_PAGE_COLS',
  p_ref_column_name=> 'SECURITY_GROUP_ID',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22898708565885414.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4402,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 5096822001046010.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 45,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_display_when_condition => 'P11_PAGE_TYPE',
  p_plug_display_when_cond2=>'BLANK',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 6732801370658186.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 11.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 6730106581658152+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:window.close();',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 11.4402,
  p_button_sequence=> 30,
  p_button_plug_id => 6730106581658152+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_EDIT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P11_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>6743722184658311.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_branch_action=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'P11_PARENT_PAGE_ID',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 08-MAR-2005 14:40 by MARC');
 
wwv_flow_api.create_page_branch(
  p_id=>28677211796677501.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_branch_action=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.::P43_ICON:&P11_PAGE_ICON.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 20,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'P11_PAGE_ICON',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 17-OCT-2006 23:23 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6733230991658200.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ID',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Numéro de page unique.';

wwv_flow_api.create_page_item(
  p_id=>6733410117658218.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PAGE_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page :',
  p_source=>'PAGE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 22,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<ul>'||chr(10)||
'<li><b>Vierge</b/> crée une page sans fonctionnalité intégrée.</li>'||chr(10)||
'<li><b>Etat</b/> crée une page contenant le résultat formaté d''une interrogation SQL. Vous pouvez choisir de construire un état à partir d''une table que vous sélectionnez ou à partir d''une instruction SQL SELECT personnalisée ou une fonction PL/SQL renvoyant une instruction SQL SELECT que vous fournissez.</li>'||chr(10)||
'<li><b>Panneau<';

h:=h||'/b/> crée un panneau permettant de mettre à jour une ligne unique dans une table de base de données.</li><li><b>Panneau tabulaire</b/> crée un panneau permettant d''effectuer des opérations de mise à jour, d''insertion et de suppression sur plusieurs lignes dans une table de base de données.</li><li><b>Etat et panneau</b/> construit une combinaison état-panneau de deux pages. Sur la première page, l';

h:=h||'es utilisateurs sélectionnent la ligne à mettre à jour. Sur la seconde, ils peuvent mettre à jour la table ou la vue sélectionnée.'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>6733911997658223.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PAGE_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Type de page :',
  p_source=>'PAGE_TYPE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_AND_SAVE_LOV',
  p_named_lov=> 'APP WIZARD PAGE TYPE',
  p_lov => '.'||to_char(6745605530658343 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Les pages peuvent être subordonnées à d''autres pages. La navigation entre une page parent et une page enfant peut être définie au moyen d''onglets, de listes de navigation et de liens de colonne. Les onglets permettent d''accéder aux pages de niveau supérieur, si un ou plusieurs niveaux d''onglets sont sélectionnés. L''accès aux pages de niveau inférieur est assuré par des liens de colonne à partir de';

h:=h||'s pages d''état parent ou par des listes de navigation, si aucun lien n''est défini. Les pages de second niveau sont également accessibles au moyen d''onglets de second niveau, si deux niveaux d''onglets sont sélectionnés.';

wwv_flow_api.create_page_item(
  p_id=>6734408058658225.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PARENT_PAGE_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page parent',
  p_source=>'PARENT_PAGE_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'COMBOBOX_WITH_SUBMIT',
  p_lov => 'select htf.escape_sc(page_name)||'' (''||page_id||'')'' p, id r'||chr(10)||
'from WWV_FLOW_MODEL_PAGES '||chr(10)||
'where model_id = :P33_MODEL_ID and id != :P11_ID'||chr(10)||
'order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Aucun parent -',
  p_lov_null_value=> '',
  p_cSize=> 22,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Les états et les panneaux sont liés au moyen de liens de colonne sur la page d''état. Lorsque l''utilisateur clique sur le lien, il accède à la page de panneau. Sur la page de panneau, les données sont extraites à l''aide des valeurs de clé primaire fournies avec le lien. Le champ de colonne 1 indique la colonne d''état à partir de laquelle est dérivée la première valeur de clé primaire.';

wwv_flow_api.create_page_item(
  p_id=>6734918325658227.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PARENT_LINK_FROM_COLUMN1',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 220,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Colonne 1',
  p_source=>'select PARENT_LINK_FROM_COLUMN1 from wwv_flow_model_page_regions'||chr(10)||
'where model_page_id = :P11_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MODEL_PARENT_PAGE_COLUMNS P11',
  p_lov => 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols  s'||chr(10)||
'where  model_region_id in ('||chr(10)||
'   select id from wwv_flow_model_page_regions'||chr(10)||
'   where model_page_id = ('||chr(10)||
'       select id '||chr(10)||
'       from   wwv_flow_model_pages '||chr(10)||
'       where  model_id = :P33_MODEL_ID'||chr(10)||
'       and    id  = :P11_PARENT_PAGE_ID'||chr(10)||
'))'||chr(10)||
'and column_name not like ''LINK$%''',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Sélectionner une colonne - ',
  p_lov_null_value=> '',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Les états et les panneaux sont liés au moyen de liens de colonne sur la page d''état. Lorsque l''utilisateur clique sur le lien, il accède à la page de panneau. Sur la page de panneau, les données sont extraites à l''aide des valeurs de clé primaire fournies avec le lien. Le champ de colonne 2 indique la colonne d''état à partir de laquelle est dérivée la deuxième valeur de clé primaire.';

wwv_flow_api.create_page_item(
  p_id=>6735430175658228.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PARENT_LINK_FROM_COLUMN2',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 240,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Colonne 2',
  p_source=>'select PARENT_LINK_FROM_COLUMN2 from wwv_flow_model_page_regions'||chr(10)||
'where model_page_id = :P11_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MODEL_PARENT_PAGE_COLUMNS P11',
  p_lov => 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols  s'||chr(10)||
'where  model_region_id in ('||chr(10)||
'   select id from wwv_flow_model_page_regions'||chr(10)||
'   where model_page_id = ('||chr(10)||
'       select id '||chr(10)||
'       from   wwv_flow_model_pages '||chr(10)||
'       where  model_id = :P33_MODEL_ID'||chr(10)||
'       and    id  = :P11_PARENT_PAGE_ID'||chr(10)||
'))'||chr(10)||
'and column_name not like ''LINK$%''',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Sélectionner une colonne -',
  p_lov_null_value=> '',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Les états et les panneaux sont liés au moyen de liens de colonne sur la page d''état. Lorsque l''utilisateur clique sur le lien, il accède à la page de panneau. Sur la page de panneau, les données sont extraites à l''aide des valeurs de clé primaire fournies avec le lien. Le champ d''élément de page indique l''élément de clé primaire qui sera initialisé au moyen de la valeur fournie via le lien de colo';

h:=h||'nne.';

wwv_flow_api.create_page_item(
  p_id=>6735927001658229.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_LINK_TO_COLUMN1',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 230,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&P11_PAGE_ITEM_LABEL.',
  p_source=>'select LINK_TO_COLUMN1 from wwv_flow_model_page_regions'||chr(10)||
'where model_page_id = :P11_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MODEL_PAGE_COLUMNS P11',
  p_lov => 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols'||chr(10)||
'where  model_region_id = :P11_REGION_ID',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Sélectionner une colonne - ',
  p_lov_null_value=> '',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Les états et les panneaux sont liés au moyen de liens de colonne sur la page d''état. Lorsque l''utilisateur clique sur le lien, il accède à la page de panneau. Sur la page de panneau, les données sont extraites à l''aide des valeurs de clé primaire fournies avec le lien. Le champ d''élément de page indique l''élément de clé primaire qui sera initialisé au moyen de la valeur fournie via le lien de colo';

h:=h||'nne.';

wwv_flow_api.create_page_item(
  p_id=>6736430699658230.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_LINK_TO_COLUMN2',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 250,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&P11_PAGE_ITEM_LABEL.',
  p_source=>'select LINK_TO_COLUMN2 from wwv_flow_model_page_regions'||chr(10)||
'where model_page_id = :P11_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MODEL_PAGE_COLUMNS P11',
  p_lov => 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols'||chr(10)||
'where  model_region_id = :P11_REGION_ID',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Sélectionner une colonne -',
  p_lov_null_value=> '',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez le nom de la page de votre application.';

wwv_flow_api.create_page_item(
  p_id=>6736927642658231.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PAGE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de page',
  p_source=>'PAGE_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez la source de la nouvelle page. Les états peuvent être basés sur des tables ou des interrogations. Les panneaux et les panneaux tabulaires ne peuvent être basés que sur des tables.';

wwv_flow_api.create_page_item(
  p_id=>6737429039658231.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_SOURCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Interrogation source :',
  p_source=>'select ''<pre>''||source||''</pre>'' from wwv_flow_model_pages where id = :P11_ID',
  p_source_type=> 'QUERY',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 255,
  p_cHeight=> 4,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P11_PAGE_SOURCE',
  p_display_when2=>'QUERY',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez la séquence d''affichage de page.';

wwv_flow_api.create_page_item(
  p_id=>6737926932658233.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_DISPLAY_SEQUENCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Séquence',
  p_source=>'DISPLAY_SEQUENCE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Identifie la source de la page. Les états peuvent être basés sur des tables ou des interrogations. Les panneaux et les panneaux tabulaires ne peuvent être basés que sur des tables.';

wwv_flow_api.create_page_item(
  p_id=>6738403658658234.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PAGE_SOURCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Source de page :',
  p_source=>'PAGE_SOURCE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_AND_SAVE_LOV',
  p_named_lov=> 'PAGE_SOURCE',
  p_lov => '.'||to_char(6744724810658339 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Identifie la source de la page. Les états peuvent être basés sur des tables ou des interrogations. Les panneaux et les panneaux tabulaires ne peuvent être basés que sur des tables.';

wwv_flow_api.create_page_item(
  p_id=>6738914217658236.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_SOURCE_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 65,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Table source :',
  p_source=>'select source from wwv_flow_model_pages where id = :P11_ID',
  p_source_type=> 'QUERY',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 255,
  p_cHeight=> 4,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P11_PAGE_SOURCE',
  p_display_when2=>'TABLE',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6739402858658237.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_COL_REGION_HEADING',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 260,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'if :P11_PAGE_TYPE in (''REPORT'',''TABULARFORM'') then'||chr(10)||
'   return wwv_flow_lang.system_message(''REPORT COLUMNS'');'||chr(10)||
'elsif :P11_PAGE_TYPE = ''FORM'' then'||chr(10)||
'   return wwv_flow_lang.system_message(''PAGE ITEMS'');'||chr(10)||
'end if;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez la colonne qui sera utilisée pour l''affichage du lien de colonne. ';

wwv_flow_api.create_page_item(
  p_id=>6739616942658239.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_LINK_COLUMN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 200,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Colonne de lien',
  p_source=>'select LINK_COLUMN from WWV_FLOW_MODEL_PAGE_REGIONS'||chr(10)||
'where MODEL_PAGE_ID = :P11_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MODEL_PARENT_PAGE_COLUMNS P11',
  p_lov => 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols  s'||chr(10)||
'where  model_region_id in ('||chr(10)||
'   select id from wwv_flow_model_page_regions'||chr(10)||
'   where model_page_id = ('||chr(10)||
'       select id '||chr(10)||
'       from   wwv_flow_model_pages '||chr(10)||
'       where  model_id = :P33_MODEL_ID'||chr(10)||
'       and    id  = :P11_PARENT_PAGE_ID'||chr(10)||
'))'||chr(10)||
'and column_name not like ''LINK$%''',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Sélectionner une colonne de lien -',
  p_lov_null_value=> 'LINK$',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Texte HTML à afficher en tant que lien. Pour afficher des images, utilisez une balise d''image.';

wwv_flow_api.create_page_item(
  p_id=>6740130126658240.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_LINK_TEXT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 210,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Texte de lien',
  p_source=>'select LINK_TEXT from wwv_flow_model_page_regions'||chr(10)||
'where model_page_id = :P11_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6740600503658240.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_USE_LINK_COLUMN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 205,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select ''LINK_COLUMN'' from wwv_flow_model_page_cols'||chr(10)||
'where model_region_id = nvl(replace(:P11_REGION_ID,''%''||''null%'',0),0)'||chr(10)||
'and column_name like ''LINK$%''',
  p_source_type=> 'QUERY',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'MODEL_LINK_EXTRA_COLUMN',
  p_lov => '.'||to_char(6746916502658348 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onClick="modelDisableItem(document.getElementById(''P11_LINK_COLUMN''), this,''LINK$'');"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6740814562658243.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_REPORT_COLUMN_LABEL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 270,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(''REPORT_COLUMN'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6741003911658244.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PAGE_ITEM_LABEL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 280,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'if :P11_PAGE_TYPE in (''REPORT'',''TABULARFORM'') then'||chr(10)||
'   return wwv_flow_lang.system_message(''REPORT_COLUMN'');'||chr(10)||
'elsif :P11_PAGE_TYPE = ''FORM'' then'||chr(10)||
'   return wwv_flow_lang.system_message(''PAGE_ITEM'');'||chr(10)||
'end if;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6741223255658244.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PARENT_REPORT_COLUM_HEADING',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 212,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(''PARENT_REPORT_COLUMN'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6741427461658245.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_REPORT_COLUMN_HEADING',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 214,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(''LINK_TO_THIS_PAGE_ITEM'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>6741624076658245.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_USE_THEME_BUTTON',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 211,
  p_item_plug_id => 6730312066658152.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'THEME',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'MODEL_USE_THEME_BUTTON',
  p_lov => '.'||to_char(6747416812658349 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => ' onClick="modelDisableItem2(document.getElementById(''P11_LINK_TEXT''), this,'''');"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<li><b>Liste non ordonnée verticale avec puces</b> affiche les pages sélectionnées sous forme de liste verticale avec des puces.</li>'||chr(10)||
'<br>'||chr(10)||
'<li><b>Liste d''images verticale</b> affiche les pages sélectionnées sous forme de liste d''images verticale.</li>'||chr(10)||
'<br>'||chr(10)||
'<li><b>Liste d''images horizontale</b> affiche les pages sélectionnées sous forme de liste d''images horizontale.</li>'||chr(10)||
'<br>'||chr(10)||
'L''option par défaut e';

h:=h||'st Liste non ordonnée verticale avec puces. La liste apparaît dans la région de navigation de la page parent.';

wwv_flow_api.create_page_item(
  p_id=>23542508469159976.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_NAVIGATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 290,
  p_item_plug_id => 22898708565885414.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Vertical Unordered List with Bullets',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Sélectionner le style de navigation :',
  p_source=>'select nvl(LIST_TEMPLATE_NAME,''Vertical Unordered List with Bullets'')'||chr(10)||
'from   wwv_mig_rev_apexapp'||chr(10)||
'where  project_id = :MW_PROJ_ID'||chr(10)||
'and    page_id = :P11_PAGE_ID'||chr(10)||
'and    security_group_id = :flow_security_group_id'||chr(10)||
'and    flow_id = :MW_APPLICATION_ID',
  p_source_type=> 'QUERY',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'HOME PAGE NAVIGATION',
  p_lov => '.'||to_char(22899924972899541 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 3,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap" class="tabledata"',
  p_tag_attributes2=> 'class="instructiontext"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 6,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez une icône de page à associer à cette page dans l''application Oracle &PRODUCT_NAME. générée. Utilisez l''icône représentant une torche pour afficher les options d''icône et sélectionner une icône.';

wwv_flow_api.create_page_item(
  p_id=>26653801782406050.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_PAGE_ICON',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 300,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Icône de page',
  p_post_element_text=>'<a href="javascript:popUp2(''f?p=4400:43:&SESSION.::&DEBUG.::P43_PREVIOUS:11'',626,655);" tabindex="999" title=#CURRENT_ITEM_NAME# class="itemlink"><img src="#IMAGE_PREFIX#flashlight2_trans.gif" border="0" width="18" height="18" alt="torche" /></a>',
  p_source=>'select LIST_ITEM_ICON'||chr(10)||
'from wwv_mig_rev_apexapp'||chr(10)||
'where page_id = :P11_PAGE_ID'||chr(10)||
'and project_id = :MW_PROJ_ID'||chr(10)||
'and security_group_id = :flow_security_group_id'||chr(10)||
'--and dbid = :P2_DBID'||chr(10)||
'and flow_id = :MW_APPLICATION_ID',
  p_source_type=> 'QUERY',
  p_display_as=> 'COMBOBOX_WITH_SUBMIT',
  p_named_lov=> 'PAGE_ICONS_2',
  p_lov => 'select icon_name d, icon_name r'||chr(10)||
'from WWV_FLOW_STANDARD_ICONS'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="htmldb_item_change(this)"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P11_PAGE_TYPE',
  p_display_when2=>'BLANK',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>28672507940647978.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_SELECTED_ICON',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 310,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_post_element_text=>'<img src="#IMAGE_PREFIX#menu/&P11_PAGE_ICON." width="64" height="64" border="1" bordercolor="black">',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P11_PAGE_TYPE',
  p_display_when2=>'BLANK',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>145638213414355723.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_REGION_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select ID from WWV_FLOW_MODEL_PAGE_REGIONS'||chr(10)||
'where model_page_id = :P11_ID'||chr(10)||
'and region_id = 1',
  p_source_type=> 'QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>148666515504542253.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_name=>'P11_IMPLEMENTATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 6729919867658132.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'INTERACTIVE',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Implémentation',
  p_source=>'select REPORT_IMPLEMENTATION '||chr(10)||
'from WWV_FLOW_MODEL_PAGE_REGIONS'||chr(10)||
'where MODEL_PAGE_ID = :P11_ID'||chr(10)||
'and security_group_id = :flow_security_group_id',
  p_source_type=> 'QUERY',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'REPORT TYPE: INTERACTIVE OR CLASSIC',
  p_lov => '.'||to_char(148634518096505157 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P47_PAGE_TYPE',
  p_display_when2=>'REPORT',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 6741913947658249.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'P11_LINK_COLUMN',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'LINK$01',
  p_compute_when => 'P11_USE_LINK_COLUMN',
  p_compute_when_type=>'ITEM_IS_NOT_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 6742130493658254.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_validation_name => 'P11_PAGE_NAME',
  p_validation_sequence=> 10,
  p_validation => 'P11_PAGE_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Vous devez indiquer un nom de page.',
  p_when_button_pressed=> 6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_associated_item=> 6736927642658231.4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:WWV_FLOW_MODEL_PAGES:P11_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 6742217414658260.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from WWV_FLOW_MODEL_PAGES',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible d''extraire la ligne.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_MODEL_PAGE_COLS:ID';

wwv_flow_api.create_page_process(
  p_id     => 6742423703658297.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'MULTI_ROW_UPDATE',
  p_process_name=> 'ApplyMRU',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible de traiter la mise à jour.',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '#MRU_COUNT# ligne(s) mise(s) à jour, #MRI_COUNT# ligne(s) insérée(s).',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'    update '||chr(10)||
'        WWV_FLOW_MODEL_PAGE_REGIONS'||chr(10)||
'    set '||chr(10)||
'        LINK_COLUMN = :P11_LINK_COLUMN,'||chr(10)||
'        LINK_TEXT = :P11_LINK_TEXT,'||chr(10)||
'        PARENT_LINK_FROM_COLUMN1 = :P11_PARENT_LINK_FROM_COLUMN1,'||chr(10)||
'        LINK_TO_COLUMN1 = :P11_LINK_TO_COLUMN1'||chr(10)||
'    where '||chr(10)||
'        MODEL_PAGE_ID = :P11_ID'||chr(10)||
'    and '||chr(10)||
'        SECURITY_GROUP_ID = :flow_security_group_id;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 150171726759383753.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Update wwv_flow_model_page_regions',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>'P11_PARENT_PAGE_ID',
  p_process_when_type=>'ITEM_IS_NOT_NULL',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'update WWV_FLOW_MODEL_PAGE_REGIONS'||chr(10)||
'    set PARENT_LINK_FROM_COLUMN2 = :P11_PARENT_LINK_FROM_COLUMN2,'||chr(10)||
'    LINK_TO_COLUMN2 = :P11_LINK_TO_COLUMN2'||chr(10)||
'    where MODEL_PAGE_ID = :P11_ID'||chr(10)||
'    and SECURITY_GROUP_ID = :flow_security_group_id;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 150172305766387130.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 23,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Update Link Column2 Information',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>'if (:P11_PARENT_LINK_FROM_COLUMN2 IS NOT NULL) and (:P11_LINK_TO_COLUMN IS NOT NULL) and (:P11_PARENT_PAGE_ID IS NOT NULL)',
  p_process_when_type=>'',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_MODEL_PAGES:P11_ID:ID|U';

wwv_flow_api.create_page_process(
  p_id     => 6742602326658298.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of WWV_FLOW_MODEL_PAGES',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible de traiter la ligne de la table WWV_FLOW_MODEL_PAGES.',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Action traitée.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'  update wwv_mig_rev_apexapp'||chr(10)||
'  set list_template_name = :P11_NAVIGATION'||chr(10)||
'  where page_id = :P11_PAGE_ID'||chr(10)||
'  and flow_id = :MW_APPLICATION_ID'||chr(10)||
'  and project_id = :MW_PROJ_ID'||chr(10)||
'  and security_group_id = :flow_security_group_id'||chr(10)||
'  and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'  if :P11_PAGE_TYPE = ''BLANK'' then'||chr(10)||
'    update wwv_mig_rev_apexapp'||chr(10)||
'    set list_item_icon = ''migration/mig_menu1.png'''||chr(10)||
'    where page_id = :P11_PAGE_';

p:=p||'ID'||chr(10)||
'    and flow_id = :MW_APPLICATION_ID'||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and owner = :P2_SCHEMA;'||chr(10)||
'  else'||chr(10)||
'    update wwv_mig_rev_apexapp'||chr(10)||
'    set list_item_icon = :P11_PAGE_ICON'||chr(10)||
'    where page_id = :P11_PAGE_ID'||chr(10)||
'    and flow_id = :MW_APPLICATION_ID'||chr(10)||
'    and project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and owner ';

p:=p||'= :P2_SCHEMA;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 23542915049161829.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 31,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Update Page Navigation setting',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'    update WWV_FLOW_MODEL_PAGE_REGIONS'||chr(10)||
'    set REPORT_IMPLEMENTATION = :P11_IMPLEMENTATION'||chr(10)||
'    where MODEL_PAGE_ID = :P11_ID'||chr(10)||
'    and SECURITY_GROUP_ID = :flow_security_group_id;'||chr(10)||
' end;';

wwv_flow_api.create_page_process(
  p_id     => 148668001436547606.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 32,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Set Report Implementation',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>'P11_PAGE_TYPE',
  p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_process_when2=>'REPORT',
  p_process_when_type2=>'',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'insert into wwv_flow_model_page_cols ('||chr(10)||
'   model_region_id,'||chr(10)||
'   column_name,'||chr(10)||
'   column_display_name,               '||chr(10)||
'   datatype,'||chr(10)||
'   display_as_tab_form'||chr(10)||
') values ('||chr(10)||
'   :P11_REGION_ID,'||chr(10)||
'   ''LINK$01'','||chr(10)||
'   ''&nbsp;'','||chr(10)||
'   ''VARCHAR2'','||chr(10)||
'   ''WITHOUT_MODIFICATION'''||chr(10)||
');';

wwv_flow_api.create_page_process(
  p_id     => 6742821137658299.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 35,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'add link column',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>'begin'||chr(10)||
''||chr(10)||
'   if :P11_USE_LINK_COLUMN is not null then'||chr(10)||
'      for c1 in ('||chr(10)||
'         select 1 from wwv_flow_model_page_cols'||chr(10)||
'         where model_page_id = nvl(replace(:P11_PARENT_PAGE_ID,''%''||''null%'',0),0)'||chr(10)||
'         and column_name like ''LINK$%'''||chr(10)||
'      ) loop'||chr(10)||
'         return false;'||chr(10)||
'      end loop;'||chr(10)||
'      return true;'||chr(10)||
'   else'||chr(10)||
'      return false;'||chr(10)||
'   end if;'||chr(10)||
''||chr(10)||
'end;',
  p_process_when_type=>'FUNCTION_BODY',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete from wwv_flow_model_page_cols'||chr(10)||
'where model_region_id = :P11_REGION_ID'||chr(10)||
'and column_name like ''LINK$%'';';

wwv_flow_api.create_page_process(
  p_id     => 6743005207658300.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 36,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete link column',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>'begin'||chr(10)||
'   if :P11_USE_LINK_COLUMN is null then'||chr(10)||
'      for c1 in ('||chr(10)||
'         select 1 from wwv_flow_model_page_cols'||chr(10)||
'         where model_region_id = nvl(replace(:P11_REGION_ID,''%''||''null%'',0),0)'||chr(10)||
'         and column_name like ''LINK$%'''||chr(10)||
'   	  ) loop'||chr(10)||
'	        return true;'||chr(10)||
'   	  end loop;'||chr(10)||
'	     return false;'||chr(10)||
'   else'||chr(10)||
'      return false;'||chr(10)||
'   end if;'||chr(10)||
'end;',
  p_process_when_type=>'FUNCTION_BODY',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'43,11';

wwv_flow_api.create_page_process(
  p_id     => 6743229743658301.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'htp.prn(''<script  language="JavaScript">''||chr(10));'||chr(10)||
'htp.prn(''v_flowid = opener.document.getElementById(''''pFlowId'''').value;''||chr(10));'||chr(10)||
'htp.prn(''v_stepid = opener.document.getElementById(''''pFlowStepId'''').value;''||chr(10));'||chr(10)||
'htp.prn(''v_sessionid = opener.document.getElementById(''''pInstance'''').value;''||chr(10));'||chr(10)||
'htp.prn(''v_redirect = ''''f?p=''''+v_flowid+'''':''''+v_stepid+'''':''''+v_sessionid;''||chr(10));'||chr(10)||
'htp';

p:=p||'.prn(''window.opener.window.location=v_redirect;''||chr(10));'||chr(10)||
'htp.prn(''window.close();'');'||chr(10)||
'htp.prn(''</script>''||chr(10));';

wwv_flow_api.create_page_process(
  p_id     => 6743403424658301.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4402,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Reload base and close',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>6733027183658198.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 11.4402
--
 
begin
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6771905958671660.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 1,
  p_query_column_name=> 'ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772001065671662.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 2,
  p_query_column_name=> 'ID_DISPLAY',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 145630406324341237.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 3,
  p_query_column_name=> 'MODEL_REGION_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772214682671662.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 4,
  p_query_column_name=> 'COLUMN_NAME',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772329426671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 5,
  p_query_column_name=> 'COLUMN_DISPLAY_NAME',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772410701671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 6,
  p_query_column_name=> 'DISPLAY_AS_FORM',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772525652671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 7,
  p_query_column_name=> 'DISPLAY_AS_TAB_FORM',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772619658671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 8,
  p_query_column_name=> 'DATATYPE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772709319671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 9,
  p_query_column_name=> 'ALIGNMENT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772828931671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 10,
  p_query_column_name=> 'FORMAT_MASK',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6772927954671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 11,
  p_query_column_name=> 'HIDDEN_COLUMN',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6773016727671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 12,
  p_query_column_name=> 'SORT_SEQUENCE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6773127043671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 13,
  p_query_column_name=> 'DISPLAY_WIDTH',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6773214094671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 14,
  p_query_column_name=> 'MAX_WIDTH',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6773325993671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 15,
  p_query_column_name=> 'HEIGHT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6773420706671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 16,
  p_query_column_name=> 'HELP_TEXT',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 6773512598671663.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 6730500881658158.4402 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 17,
  p_query_column_name=> 'SECURITY_GROUP_ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
null;
end;
null;
 
end;
/

 
--application/pages/page_12.44
prompt  ...PAGE 12.4402: Comment migrer les applications Microsoft Access
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_howmigproj.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 12.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Comment migrer les applications Microsoft Access',
  p_step_title=> 'Comment migrer les applications Microsoft Access',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 25821516221167914.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162011',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>12.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<dl id ="imap">'||chr(10)||
'<pre>'||chr(10)||
'<img usemap="#migration" src="#IMAGE_PREFIX#migration/AccessMigrationDetailed.png">'||chr(10)||
'<map name="migration">'||chr(10)||
''||chr(10)||
'<dd id="area1">'||chr(10)||
'<area id="a1" shape="rect" coords="63,57,176,76" href="f?p=4400:1:&SESSION.::NO" title="Sélectionner une base de données Microsoft Access pour la migration" >'||chr(10)||
'</area>'||chr(10)||
''||chr(10)||
'</dd>'||chr(10)||
'<dd id="area2">'||chr(10)||
'<area id="a2" shape="rect" coords="63,163,185,188" href="f?p=440';

s:=s||'0:6:&SESSION.::NO" title="Exporter les métadonnées Microsoft Access">'||chr(10)||
'</area>'||chr(10)||
'</dd>'||chr(10)||
''||chr(10)||
'<dd id="area3">'||chr(10)||
'<area id="a3" shape="rect" coords="63,281,216,302" href="javascript:popupURL(''http://www.oracle.com/technology/tech/migration/workbench/index.html'')" title="Migrer la base de données Microsoft Access vers Oracle">'||chr(10)||
'</area>'||chr(10)||
'</dd>'||chr(10)||
''||chr(10)||
'<dd id="area4">'||chr(10)||
'<area id="a4" shape="rect" coords="258,126,405,149" hr';

s:=s||'ef="f?p=4400:1:&SESSION.::NO" title="Analyser l''application Microsoft Access">'||chr(10)||
'</area>'||chr(10)||
'</dd>'||chr(10)||
''||chr(10)||
'<dd id="area5">'||chr(10)||
'<area id="a5" shape="rect" coords="258,188,405,209" href="f?p=4500:1001:&SESSION.::NO" title="Revoir le schéma de base de données migré" >'||chr(10)||
'</area>'||chr(10)||
'</dd>'||chr(10)||
''||chr(10)||
'<dd id="area6">'||chr(10)||
'<area id="a6" shape="rect" coords="491,166,568,182" href="f?p=4000:1500:&SESSION.::NO" title="Générer l''application Orac';

s:=s||'le &PRODUCT_NAME.">'||chr(10)||
'</area>'||chr(10)||
'</dd>'||chr(10)||
''||chr(10)||
'</map>'||chr(10)||
''||chr(10)||
'</pre>'||chr(10)||
'</dl>';

wwv_flow_api.create_page_plug (
  p_id=> 20146008706313215.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4402,
  p_plug_name=> 'Project Diagram',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20955921392001711.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'5994012793528903';

wwv_flow_api.create_page_plug (
  p_id=> 20957132474004840.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4402,
  p_plug_name=> 'Progression',
  p_region_name=>'',
  p_plug_template=> 244065612129731419.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 3,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 5994012793528903 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'NEVER',
  p_plug_header=> '<br><br><br><br>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'htp.p(''<span class="instructiontext">'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P12_HOWTO_STEP1''));'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P12_HOWTO_STEP2''));'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P12_HOWTO_STEP3''));'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P12_HOWTO_STEP4''));'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P12_HOWTO_STEP5''));'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P';

s:=s||'12_HOWTO_STEP6''));'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P12_HOWTO_STEP7''));'||chr(10)||
'htp.p(''</span><br />'');'||chr(10)||
'end;'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 21007416040526703.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4402,
  p_plug_name=> 'Comment migrer les applications Microsoft Access',
  p_region_name=>'',
  p_plug_template=> 86904609451444726.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 12.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_13.44
prompt  ...PAGE 13.4402: Bases de données
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_rvwdbmodpg.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 13.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Bases de données',
  p_step_title=> 'Bases de données',
  p_step_sub_title => 'Databases',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162011',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>13.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20967308503092541.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select distinct'||chr(10)||
'  WWV_MIG_ACCESS.DBID "DBID",'||chr(10)||
'  WWV_MIG_ACCESS.DBNAME "Database Name", '||chr(10)||
'  WWV_MIG_ACCESS.DBPATHNAME "Database",'||chr(10)||
'  WWV_MIG_ACCESS.ACCESSVERSION "Version",'||chr(10)||
'  WWV_MIG_ACCESS.DATABASE_SCHEMA "Schema",'||chr(10)||
'  WWV_MIG_ACCESS.DBSIZE "Size",'||chr(10)||
'  decode('||chr(10)||
'  WWV_MIG_ACCESS.LINKDBID,'||chr(10)||
'  NULL,''-'','||chr(10)||
'  LINKDBID,(select a.DBNAME '||chr(10)||
'   from wwv_mig_access a, wwv_mig_access b '||chr(10)||
'   where a.PROJECT_ID = :MW_PROJ_';

s:=s||'ID'||chr(10)||
'   and a.DBID = b.LINKDBID'||chr(10)||
'   and a.DBID <> b.DBID)'||chr(10)||
'  ) "Linked Database",'||chr(10)||
'  CREATED_BY "Owner",'||chr(10)||
'  CREATED_ON "Created",'||chr(10)||
'  (select distinct count(*) '||chr(10)||
'   from wwv_mig_acc_tables, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_tables.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_tables.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_tables.DBID = wwv_mig_access.DBID'||chr(10)||
'   group by wwv_mig_acc_tables.DB';

s:=s||'ID) "TABLES",'||chr(10)||
'  (select distinct count(*) '||chr(10)||
'   from wwv_mig_acc_queries, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_queries.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_queries.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_queries.DBID = wwv_mig_access.DBID'||chr(10)||
'   group by wwv_mig_acc_queries.DBID) "QUERIES",'||chr(10)||
'  (select distinct count(*) '||chr(10)||
'   from wwv_mig_acc_forms, wwv_mig_access'||chr(10)||
'   where wwv_mig_ac';

s:=s||'c_forms.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_forms.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_forms.DBID = wwv_mig_access.DBID'||chr(10)||
'   group by wwv_mig_acc_forms.DBID) "FORMS",'||chr(10)||
'  (select count(*) '||chr(10)||
'   from wwv_mig_acc_reports, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_reports.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_reports.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_rep';

s:=s||'orts.DBID = wwv_mig_access.DBID) "REPORTS",'||chr(10)||
'  (select count(*) '||chr(10)||
'   from wwv_mig_acc_modules, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_modules.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_modules.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_modules.DBID = wwv_mig_access.DBID) "MODULES",'||chr(10)||
'  (select count(*) '||chr(10)||
'   from wwv_mig_acc_pages, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_pages.PROJECT_ID = :MW_';

s:=s||'PROJ_ID'||chr(10)||
'   and wwv_mig_acc_pages.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_pages.DBID = wwv_mig_access.DBID) "PAGES"'||chr(10)||
'from '||chr(10)||
'  #OWNER#.wwv_mig_access '||chr(10)||
''||chr(10)||
'where '||chr(10)||
'  WWV_MIG_ACCESS.PROJECT_ID=:MW_PROJ_ID'||chr(10)||
'and'||chr(10)||
' ( WWV_MIG_ACCESS.DBID = :P2_DATABASE or nvl (:P2_DATABASE,''0'') = ''0'')';

wwv_flow_api.create_report_region (
  p_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4402,
  p_name=> 'Databases',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P2_DBCOUNT',
  p_display_when_cond2=> '1',
  p_display_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_prn_output=> 'N',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Impression',
  p_prn_units=> 'MILLIMETERS',
  p_prn_paper_size=> 'A4',
  p_prn_width=> 297,
  p_prn_height=> 210,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
 
-- maintain plug_column_width attribute for 2.2 and greater
begin
execute immediate 'begin wwv_flow_api.set_region_column_width (
  p_id=>30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_page_id=>13.4402,
  p_plug_column_width=>''nowrap="nowrap"''); end;';
exception when others then null;
end;
/
 
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434903453591213.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'DBID',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Dbid',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30433704601591211.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'Database Name',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom de base de données',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30435116838591213.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'Database',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Base de données',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30433812835591211.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'Version',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Version',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30433906494591211.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'Schema',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Schéma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30435008614591213.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'Size',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Taille',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434028826591211.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'Linked Database',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Linked Database',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434124503591211.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'Owner',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Owner',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434203623591211.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'Created',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Créé',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434310377591212.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'TABLES',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Tables',
  p_column_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:RP:P9_DBID:#DBID#',
  p_column_linktext=>'#TABLES#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'EXISTS',
  p_display_when_condition=> 'select 1'||chr(10)||
'   from wwv_mig_acc_tables, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_tables.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_tables.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_tables.DBID = wwv_mig_access.DBID'||chr(10)||
'   group by wwv_mig_acc_tables.DBID',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434412340591212.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'QUERIES',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Interrogations',
  p_column_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:RP:P10_DBID:#DBID#',
  p_column_linktext=>'#QUERIES#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'EXISTS',
  p_display_when_condition=> 'select 1 '||chr(10)||
'   from wwv_mig_acc_queries, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_queries.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_queries.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_queries.DBID = wwv_mig_access.DBID'||chr(10)||
'   group by wwv_mig_acc_queries.DBID',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434523423591212.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'FORMS',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Panneaux',
  p_column_link=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:RP::',
  p_column_linktext=>'#FORMS#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'EXISTS',
  p_display_when_condition=> 'select 1'||chr(10)||
'   from wwv_mig_acc_forms, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_forms.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_forms.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_forms.DBID = wwv_mig_access.DBID'||chr(10)||
'   group by wwv_mig_acc_forms.DBID',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434632188591212.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'REPORTS',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Etats',
  p_column_link=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:RP:P20_DBID:#DBID#',
  p_column_linktext=>'#REPORTS#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'EXISTS',
  p_display_when_condition=> 'select 1 '||chr(10)||
'   from wwv_mig_acc_reports, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_reports.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_reports.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_reports.DBID = wwv_mig_access.DBID',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434717938591213.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'MODULES',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Modules',
  p_column_link=>'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:RP::',
  p_column_linktext=>'#MODULES#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'EXISTS',
  p_display_when_condition=> 'select 1 '||chr(10)||
'   from wwv_mig_acc_modules, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_modules.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_modules.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_modules.DBID = wwv_mig_access.DBID',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 30434812038591213.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 30433531484591192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'PAGES',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Pages',
  p_column_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:RP::',
  p_column_linktext=>'#PAGES#',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_when_cond_type=> 'EXISTS',
  p_display_when_condition=> 'select 1 '||chr(10)||
'   from wwv_mig_acc_pages, wwv_mig_access'||chr(10)||
'   where wwv_mig_acc_pages.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and wwv_mig_acc_pages.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'   and wwv_mig_acc_pages.DBID = wwv_mig_access.DBID',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '6',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'DECLARE'||chr(10)||
'  q varchar2(4000);'||chr(10)||
'  v_whereclause varchar2(60);'||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'htp.p(''<table cellpadding="0" cellspacing="0" border="0" class="htmldbVerticalReport" summary="">'');'||chr(10)||
'htp.p(''<tr><td/><td align="left"><B>''||wwv_flow_lang.system_message(''F4400_P13_VERSION'')||''</B></a></td>'||chr(10)||
'<td align="left"><B>''||wwv_flow_lang.system_message(''DATABASE_USERS'')||''</B></a></td>'||chr(10)||
'<td align="left"><B>&TABLES.</B></a></td>'||chr(10)||
'<';

s:=s||'td align="left"><B>&QUERIES.</B></a></td>'||chr(10)||
'<td align="left"><B>&FORMS.</B></a></td>'||chr(10)||
'<td align="left"><B>''||wwv_flow_lang.system_message(''QUICK_APP_REPORTS'')||''</B></a></td>'||chr(10)||
'<td align="left"><B>&MODULES.</B></a></td>'||chr(10)||
'<td align="left"><B>''||wwv_flow_lang.system_message(''CONFIRM.PAGES'')||''</B></a></td>'||chr(10)||
'<td align="left"><B>Schema</B></a></td>'||chr(10)||
'<td align="left"><B>''||wwv_flow_lang.system_message(''SIZE'')|';

s:=s||'|''</B></a></td>'||chr(10)||
'<td align="left"><B>''||wwv_flow_lang.system_message(''F4400_P13_LINKED'')||''</B></a></td>'||chr(10)||
'<td align="left"><B>''||wwv_flow_lang.system_message(''F4500_P25_CREATED'')||''</B></a></td></tr>'');'||chr(10)||
''||chr(10)||
''||chr(10)||
'for c1 in '||chr(10)||
'('||chr(10)||
'  select distinct'||chr(10)||
'  WWV_MIG_ACCESS.DBID dbid,'||chr(10)||
'  WWV_MIG_ACCESS.DBNAME dbname, '||chr(10)||
'  WWV_MIG_ACCESS.DBPATHNAME pathname,'||chr(10)||
'  substr(WWV_MIG_ACCESS.ACCESSVERSION,10,length(WWV_MIG_ACCESS.ACCE';

s:=s||'SSVERSION) -1) accver,'||chr(10)||
'  WWV_MIG_ACCESS.DATABASE_SCHEMA db_schema,'||chr(10)||
'  WWV_MIG_ACCESS.DBSIZE dbsize,'||chr(10)||
'  decode('||chr(10)||
'  WWV_MIG_ACCESS.LINKDBID,'||chr(10)||
'  NULL,''-'','||chr(10)||
'  LINKDBID,(select a.DBNAME '||chr(10)||
'   from wwv_mig_access a, wwv_mig_access b '||chr(10)||
'   where a.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   and a.DBID = b.LINKDBID'||chr(10)||
'   and a.DBID <> b.DBID)'||chr(10)||
'  ) linked,'||chr(10)||
'  CREATED_BY cr_by,'||chr(10)||
'  to_char(CREATED_ON,''&DATE_TIME_FORMAT.'') cr_on'||chr(10)||
'from '||chr(10)||
'  ww';

s:=s||'v_mig_access '||chr(10)||
'where '||chr(10)||
'  WWV_MIG_ACCESS.PROJECT_ID=:MW_PROJ_ID'||chr(10)||
'and'||chr(10)||
' (WWV_MIG_ACCESS.dbid = htf.escape_sc(:P2_DATABASE) or nvl(htf.escape_sc(:P2_DATABASE),''0'') = ''0'')'||chr(10)||
''||chr(10)||
')'||chr(10)||
'LOOP'||chr(10)||
''||chr(10)||
'  htp.p(''<tr><td/><td>''||c1.accver||''</td><td>''||c1.pathname||''</td>'');'||chr(10)||
''||chr(10)||
'  for c2 in '||chr(10)||
'  ('||chr(10)||
'     select distinct count(*) cnt'||chr(10)||
'     from wwv_mig_acc_tables, wwv_mig_access'||chr(10)||
'     where wwv_mig_acc_tables.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'   ';

s:=s||'  and wwv_mig_acc_tables.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'     and wwv_mig_acc_tables.DBID = wwv_mig_access.DBID'||chr(10)||
'     and WWV_MIG_ACCESS.dbid = c1.dbid or nvl(c1.dbid,''0'') = ''0'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'    if c2.cnt > 0 then'||chr(10)||
'      htp.p(''<td align="left"><a href="f?p=4400:9:&SESSION.::&DEBUG.:RP:P9_DBID:''||c1.dbid||''" title="&TABLES.">''||c2.cnt||''</a></td>'');'||chr(10)||
'    else'||chr(10)||
'      htp.p(''<td>-</td>'');'||chr(10)||
'    end i';

s:=s||'f;'||chr(10)||
'  END LOOP;'||chr(10)||
'  '||chr(10)||
'  for c3 in '||chr(10)||
'  ('||chr(10)||
'     select distinct count(*) cnt'||chr(10)||
'     from wwv_mig_acc_queries, wwv_mig_access'||chr(10)||
'     where wwv_mig_acc_queries.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'     and wwv_mig_acc_queries.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'     and wwv_mig_acc_queries.DBID = wwv_mig_access.DBID'||chr(10)||
'     and WWV_MIG_ACCESS.dbid = c1.dbid or nvl(c1.dbid,''0'') = ''0'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'    if c3.cnt > 0 then'||chr(10)||
'      ';

s:=s||'htp.p(''<td align="left"><a href="f?p=4400:10:&SESSION.::&DEBUG.:RP:P10_DBID:''||c1.dbid||''" title="&QUERIES.">''||c3.cnt||''</a></td>'');'||chr(10)||
'    else'||chr(10)||
'      htp.p(''<td>-</td>'');'||chr(10)||
'    end if;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  '||chr(10)||
'  for c4 in'||chr(10)||
'  ('||chr(10)||
'    select distinct count(*) cnt'||chr(10)||
'    from wwv_mig_acc_forms, wwv_mig_access'||chr(10)||
'    where wwv_mig_acc_forms.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'    and wwv_mig_acc_forms.PROJECT_ID = wwv_mig_access.PRO';

s:=s||'JECT_ID'||chr(10)||
'    and wwv_mig_acc_forms.DBID = wwv_mig_access.DBID'||chr(10)||
'    and WWV_MIG_ACCESS.dbid = c1.dbid or nvl(c1.dbid,''0'') = ''0'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'    if c4.cnt > 0 then'||chr(10)||
'      htp.p(''<td align="left"><a href="f?p=4400:8:&SESSION.::&DEBUG.:RP::" title="&FORMS.">''||c4.cnt||''</a></td>'');'||chr(10)||
'    else'||chr(10)||
'      htp.p(''<td>-</td>'');'||chr(10)||
'    end if;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  for c5 in'||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt'||chr(10)||
'    from wwv_mig_acc_rep';

s:=s||'orts, wwv_mig_access'||chr(10)||
'    where wwv_mig_acc_reports.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'    and wwv_mig_acc_reports.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'    and wwv_mig_acc_reports.DBID = wwv_mig_access.DBID'||chr(10)||
'    and WWV_MIG_ACCESS.dbid = c1.dbid or nvl(c1.dbid,''0'') = ''0'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'    if c5.cnt > 0 then'||chr(10)||
'      htp.p(''<td align="left"><a href="f?p=4400:20:&SESSION.::&DEBUG.:RP:P20_DBID:''||c1.dbid||''" title=''';

s:=s||'||wwv_flow_lang.system_message(''QUICK_APP_REPORTS'')||''>''||c5.cnt||''</a></td>'');'||chr(10)||
'    else'||chr(10)||
'      htp.p(''<td>-</td>'');'||chr(10)||
'    end if;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  for c6 in '||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt'||chr(10)||
'    from wwv_mig_acc_modules, wwv_mig_access'||chr(10)||
'    where wwv_mig_acc_modules.PROJECT_ID = :MW_PROJ_ID'||chr(10)||
'    and wwv_mig_acc_modules.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'    and wwv_mig_acc_modules.DBID = wwv_mig_access.D';

s:=s||'BID'||chr(10)||
'    and WWV_MIG_ACCESS.dbid = c1.dbid or nvl(c1.dbid,''0'') = ''0'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'    if c6.cnt > 0 then'||chr(10)||
'      htp.p(''<td align="left"><a href="f?p=4400:15:&SESSION.::&DEBUG.:RP::" title="&MODULES.">''||c6.cnt||''</a></td>'');   '||chr(10)||
'    else'||chr(10)||
'      htp.p(''<td>-</td>'');'||chr(10)||
'    end if;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  for c7 in'||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt'||chr(10)||
'    from wwv_mig_acc_pages, wwv_mig_access'||chr(10)||
'    where wwv_mig_acc_pages.PROJ';

s:=s||'ECT_ID = :MW_PROJ_ID'||chr(10)||
'    and wwv_mig_acc_pages.PROJECT_ID = wwv_mig_access.PROJECT_ID'||chr(10)||
'    and wwv_mig_acc_pages.DBID = wwv_mig_access.DBID'||chr(10)||
'    and WWV_MIG_ACCESS.dbid = c1.dbid or nvl(c1.dbid,''0'') = ''0'''||chr(10)||
'  )'||chr(10)||
'  LOOP'||chr(10)||
'    if c7.cnt > 0 then'||chr(10)||
'      htp.p(''<td align="left"><a href="f?p=4400:14:&SESSION.::&DEBUG.:RP::" title=''||wwv_flow_lang.system_message(''CONFIRM.PAGES'')||''>''||c7.cnt||''</a></td>'');   '||chr(10)||
' ';

s:=s||'   else'||chr(10)||
'      htp.p(''<td>-</td>'');'||chr(10)||
'    end if;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  htp.p(''<td>''||c1.db_schema||''</td><td>''||c1.dbsize||''</td>'');'||chr(10)||
'  htp.p(''<td>''||c1.linked||''</td><td>''||c1.cr_on||''</td></tr>'');'||chr(10)||
''||chr(10)||
''||chr(10)||
'END LOOP;'||chr(10)||
''||chr(10)||
'htp.p(''</table>'');'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_plug (
  p_id=> 47842504526759714.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4402,
  p_plug_name=> 'Databases',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_BOX_BODY',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'nowrap = "nowrap"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_plug_display_when_condition => 'P2_DBCOUNT',
  p_plug_display_when_cond2=>'1',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 13.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_14.44
prompt  ...PAGE 14.4402: Pages
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_rvwdbmodpg.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 14.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Pages',
  p_step_title=> 'Pages',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162011',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>14.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 24928301539932130.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select PAGEID, PAGENAME, DATECREATED, DATEMODIFIED '||chr(10)||
'from wwv_mig_acc_pages '||chr(10)||
'where project_id= :MW_PROJ_ID '||chr(10)||
'and (:P14_PAGE is null or instr(upper(PAGENAME),upper(:P14_PAGE))>0)'||chr(10)||
'order by pageid;';

wwv_flow_api.create_report_region (
  p_id=> 24929423356938348.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4402,
  p_name=> 'Pages Summary',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 11,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Cette base de données ne contient aucun objet de page.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24929713999938350.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24929423356938348.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'PAGEID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Page ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24929811737938350.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24929423356938348.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PAGENAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom de page',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24929909885938350.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24929423356938348.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'DATECREATED',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Date de création',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24930011424938350.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24929423356938348.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'DATEMODIFIED',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Date de modification',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 111838732745593005.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4402,
  p_plug_name=> 'Barre supérieure',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_BOX_BODY',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>35681723605114785.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4402,
  p_branch_action=> 'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 07-FEB-2006 11:13 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour rechercher une page, saisissez une interrogation sans distinction entre les majuscules et les minuscules pour la page. Pour visualiser toutes les pages, laissez le champ vide et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>111839620756599079.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4402,
  p_name=>'P14_PAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 111838732745593005.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Page',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de panneaux à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>111840601147602883.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4402,
  p_name=>'P14_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 111838732745593005.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&nbsp; Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>111841311883605909.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4402,
  p_name=>'P14_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 111838732745593005.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 35680012177111494.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 14.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_15.44
prompt  ...PAGE 15.4402: Modules
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_rvwdbmodpg.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 15.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Modules',
  p_step_title=> 'Modules',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162011',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>15.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 24934712153001388.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select MODULEID, MODULENAME, COUNTOFLINES, COUNTOFDECLARATIONLINES, MODULETYPE from wwv_mig_acc_modules'||chr(10)||
'where project_id = :MW_PROJ_ID'||chr(10)||
'and (:P15_MODULE is null or instr(upper(modulename),upper(:P15_MODULE))>0)';

wwv_flow_api.create_report_region (
  p_id=> 24935719903013056.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4402,
  p_name=> 'Modules Summary',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 11,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P15_DISPLAY',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 25958309432791613.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24935719903013056.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'MODULEID',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Module ID',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24936016741013058.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24935719903013056.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'MODULENAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom de module',
  p_column_link=>'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:RP,16:P16_MODULE_ID:#MODULEID#',
  p_column_linktext=>'#MODULENAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24937829440037594.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24935719903013056.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COUNTOFLINES',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nombre de lignes',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24957706692381572.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24935719903013056.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COUNTOFDECLARATIONLINES',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Count of Declaration Lines',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 24937928891037594.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24935719903013056.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'MODULETYPE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Module Type',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 111847913923653849.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4402,
  p_plug_name=> 'Barre supérieure',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_BOX_BODY',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>111851629423677290.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4402,
  p_branch_action=> 'f?p=&APP_ID.:15:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 31-MAR-2006 06:07 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour rechercher un module, saisissez son nom sans distinction entre les majuscules et les minuscules et cliquez sur <b>OK</b>. Pour visualiser tous les modules, laissez le champ vide et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>111848630200658512.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4402,
  p_name=>'P15_MODULE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 111847913923653849.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Module',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre de module à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>111849609552662064.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4402,
  p_name=>'P15_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 111847913923653849.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&nbsp; Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>111850321327665400.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4402,
  p_name=>'P15_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 111847913923653849.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 15.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_16.44
prompt  ...PAGE 16.4402: Module
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_rvwdbmodpg.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 16.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Module',
  p_step_title=> 'Module',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162011',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>16.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 24943127053081432.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select LINES '||chr(10)||
'from wwv_mig_acc_modules'||chr(10)||
'where wwv_mig_acc_modules.PROJECT_ID = :MW_PROJ_ID '||chr(10)||
'and MODULEID = :P16_MODULE_ID';

wwv_flow_api.create_report_region (
  p_id=> 24944928223091219.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4402,
  p_name=> 'Module Summary Information',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 11,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '1000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 27097220456860008.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 24944928223091219.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'LINES',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Code Visual Basic',
  p_column_html_expression=>'<PRE>#LINES#<PRE>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>24947523160099153.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4402,
  p_name=>'P16_MODULE_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 24944928223091219.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 16.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_17.44
prompt  ...PAGE 17.4402: Attributs visuels
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/fmig_rev.htm';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 17.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Attributs visuels',
  p_step_title=> 'Attributs visuels',
  p_step_sub_title => 'Visual Attributes',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'ON',
  p_group_id => 280692031983283006+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 25821516221167914.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162011',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>17.4402,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>17.4402,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 273179131635611336.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_plug_name=> 'Barre supérieure',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'NEVER',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 273180202752611353.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_plug_name=> 'Visual Attributes',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select b.id,'||chr(10)||
'       b.name,'||chr(10)||
'       b.fontname,'||chr(10)||
'       b.fontspacing,'||chr(10)||
'       b.fontsize,'||chr(10)||
'       b.fontstyle,'||chr(10)||
'       b.fontweight,'||chr(10)||
'       InitCap(b.fillpattern),'||chr(10)||
'       InitCap(b.backcolor),'||chr(10)||
'       InitCap(b.foregroundcolor),'||chr(10)||
'       b.VisualAttribute_comment,'||chr(10)||
'       dbms_lob.substr(b.VisualAttribute_comment, 100,1)||decode( sign(10-length(b.VisualAttribute_comment)), -1, '' ...'', null) comment_snippe';

s:=s||'t,'||chr(10)||
'       b.FrameTitleBackColor,'||chr(10)||
'       b.FrameTitleFillPattern,'||chr(10)||
'       b.FrameTitleFontName,'||chr(10)||
'       b.FrameTitleFontSize,'||chr(10)||
'       b.FrameTitleFontSpacing,'||chr(10)||
'       b.FrameTitleFontStyle,'||chr(10)||
'       b.FrameTitleFontWeight,'||chr(10)||
'       b.FrameTitleForegroundColor,'||chr(10)||
'       b.ParentFilename,'||chr(10)||
'       b.ParentFilepath,'||chr(10)||
'       b.PersistentClientInfoLength,'||chr(10)||
'       b.PromptBackColor,'||chr(10)||
'       b.PromptFillPattern,'||chr(10)||
'       ';

s:=s||'b.PromptFontName,'||chr(10)||
'       b.PromptFontSize,'||chr(10)||
'       b.PromptFontSpacing,'||chr(10)||
'       b.PromptFontStyle,'||chr(10)||
'       b.PromptFontWeight,'||chr(10)||
'       b.PromptForegroundColor,'||chr(10)||
'       decode(b.SmartClass,''true'',t.y,''false'',t.n) smartclass,'||chr(10)||
'       decode(b.SubclassObjectGroup,''true'',t.y,''false'',t.n) SubclassObjectGroup,'||chr(10)||
'       b.VisualAttributeType,'||chr(10)||
'       decode(b.applicable,''Y'',t.y,''N'',t.n) applicable,'||chr(10)||
'       decode(';

s:=s||'b.complete,''Y'',t.y,''N'',t.n) complete,'||chr(10)||
'       b.priority,'||chr(10)||
'       b.assignee,'||chr(10)||
'       b.notes,'||chr(10)||
'       substr(b.notes,1,30)||decode( sign(10-length(b.notes )), -1, '' ...'', null) notes_snippet,'||chr(10)||
'       b.tags'||chr(10)||
''||chr(10)||
'from   wwv_mig_forms p, wwv_mig_frm_modules m, wwv_mig_frm_formmodules f, '||chr(10)||
'       wwv_mig_frm_rev_formmodules rf, wwv_mig_frm_visualattributes b,'||chr(10)||
'       (select wwv_flow_lang.system_message(''APEXI';

s:=s||'R_YES'') y, wwv_flow_lang.system_message(''APEXIR_NO'') n from dual) t'||chr(10)||
''||chr(10)||
'where  p.id = m.file_id'||chr(10)||
'and    m.id = f.module_id'||chr(10)||
'and    f.id = b.formmodule_id'||chr(10)||
'and    f.id = rf.formmodule_id'||chr(10)||
'and    p.id = :P17_FILE_ID'||chr(10)||
'and    p.project_id = :MW_PROJ_ID'||chr(10)||
'and    p.security_group_id = :flow_security_group_id'||chr(10)||
'and   (:P17_VISUAL_ATTRIBS is null or instr(upper(b.name),upper(:P17_VISUAL_ATTRIBS))>0)';

wwv_flow_api.create_page_plug (
  p_id=> 310700721366880725.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_plug_name=> 'Visual Attributes',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 35,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'DYNAMIC_QUERY',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> '<style type="text/css">'||chr(10)||
'table.apexir_WORKSHEET_DATA td{'||chr(10)||
'white-space:nowrap;'||chr(10)||
'}'||chr(10)||
'</style>',
  p_plug_footer=> '<br/>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
 a1 varchar2(32767) := null;
begin
a1:=a1||'select b.id,'||chr(10)||
'       b.name,'||chr(10)||
'       b.fontname,'||chr(10)||
'       b.fontspacing,'||chr(10)||
'       b.fontsize,'||chr(10)||
'       b.fontstyle,'||chr(10)||
'       b.fontweight,'||chr(10)||
'       InitCap(b.fillpattern),'||chr(10)||
'       InitCap(b.backcolor),'||chr(10)||
'       InitCap(b.foregroundcolor),'||chr(10)||
'       b.VisualAttribute_comment,'||chr(10)||
'       dbms_lob.substr(b.VisualAttribute_comment, 100,1)||decode( sign(10-length(b.VisualAttribute_comment)), -1, '' ...'', null) comment_snippe';

a1:=a1||'t,'||chr(10)||
'       b.FrameTitleBackColor,'||chr(10)||
'       b.FrameTitleFillPattern,'||chr(10)||
'       b.FrameTitleFontName,'||chr(10)||
'       b.FrameTitleFontSize,'||chr(10)||
'       b.FrameTitleFontSpacing,'||chr(10)||
'       b.FrameTitleFontStyle,'||chr(10)||
'       b.FrameTitleFontWeight,'||chr(10)||
'       b.FrameTitleForegroundColor,'||chr(10)||
'       b.ParentFilename,'||chr(10)||
'       b.ParentFilepath,'||chr(10)||
'       b.PersistentClientInfoLength,'||chr(10)||
'       b.PromptBackColor,'||chr(10)||
'       b.PromptFillPattern,'||chr(10)||
'       ';

a1:=a1||'b.PromptFontName,'||chr(10)||
'       b.PromptFontSize,'||chr(10)||
'       b.PromptFontSpacing,'||chr(10)||
'       b.PromptFontStyle,'||chr(10)||
'       b.PromptFontWeight,'||chr(10)||
'       b.PromptForegroundColor,'||chr(10)||
'       decode(b.SmartClass,''true'',t.y,''false'',t.n) smartclass,'||chr(10)||
'       decode(b.SubclassObjectGroup,''true'',t.y,''false'',t.n) SubclassObjectGroup,'||chr(10)||
'       b.VisualAttributeType,'||chr(10)||
'       decode(b.applicable,''Y'',t.y,''N'',t.n) applicable,'||chr(10)||
'       decode(';

a1:=a1||'b.complete,''Y'',t.y,''N'',t.n) complete,'||chr(10)||
'       b.priority,'||chr(10)||
'       b.assignee,'||chr(10)||
'       b.notes,'||chr(10)||
'       substr(b.notes,1,30)||decode( sign(10-length(b.notes )), -1, '' ...'', null) notes_snippet,'||chr(10)||
'       b.tags'||chr(10)||
''||chr(10)||
'from   wwv_mig_forms p, wwv_mig_frm_modules m, wwv_mig_frm_formmodules f, '||chr(10)||
'       wwv_mig_frm_rev_formmodules rf, wwv_mig_frm_visualattributes b,'||chr(10)||
'       (select wwv_flow_lang.system_message(''APEXI';

a1:=a1||'R_YES'') y, wwv_flow_lang.system_message(''APEXIR_NO'') n from dual) t'||chr(10)||
''||chr(10)||
'where  p.id = m.file_id'||chr(10)||
'and    m.id = f.module_id'||chr(10)||
'and    f.id = b.formmodule_id'||chr(10)||
'and    f.id = rf.formmodule_id'||chr(10)||
'and    p.id = :P17_FILE_ID'||chr(10)||
'and    p.project_id = :MW_PROJ_ID'||chr(10)||
'and    p.security_group_id = :flow_security_group_id'||chr(10)||
'and   (:P17_VISUAL_ATTRIBS is null or instr(upper(b.name),upper(:P17_VISUAL_ATTRIBS))>0)';

wwv_flow_api.create_worksheet(
  p_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id => 17.4402,
  p_region_id => 310700721366880725.4402+wwv_flow_api.g_id_offset,
  p_name => 'Visual Attributes',
  p_folder_id => null, 
  p_alias => '',
  p_report_id_item => '',
  p_max_row_count => '10000',
  p_max_row_count_message => 'Cette interrogation renvoie plus de 10 000 lignes. Filtrez vos données pour être sûr d''obtenir des résultats complets.',
  p_no_data_found_message => 'Aucune donnée n''a été trouvée.',
  p_max_rows_per_page    => '',
  p_search_button_label  => '',
  p_page_items_to_submit => '',
  p_sort_asc_image       => '',
  p_sort_asc_image_attr  => '',
  p_sort_desc_image      => '',
  p_sort_desc_image_attr => '',
  p_sql_query => a1,
  p_status                    =>'AVAILABLE_FOR_OWNER',
  p_allow_report_saving       =>'Y',
  p_allow_report_categories   =>'N',
  p_pagination_type           =>'ROWS_X_TO_Y',
  p_pagination_display_pos    =>'BOTTOM_RIGHT',
  p_button_template=> .4402+wwv_flow_api.g_id_offset,
  p_show_finder_drop_down     =>'Y',
  p_show_display_row_count    =>'Y',
  p_show_search_bar           =>'Y',
  p_show_search_textbox       =>'Y',
  p_show_actions_menu         =>'Y',
  p_report_list_mode          =>'TABS',
  p_show_detail_link          =>'C',
  p_show_select_columns       =>'Y',
  p_show_filter               =>'Y',
  p_show_sort                 =>'Y',
  p_show_control_break        =>'Y',
  p_show_highlight            =>'Y',
  p_show_computation          =>'Y',
  p_show_aggregate            =>'Y',
  p_show_chart                =>'Y',
  p_show_calendar             =>'N',
  p_show_flashback            =>'N',
  p_show_reset                =>'Y',
  p_show_download             =>'Y',
  p_show_help            =>'Y',
  p_download_formats          =>'CSV',
  p_detail_link              =>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.::P87_ID:#ID#',
  p_detail_link_text         =>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="">',
  p_allow_exclude_null_values =>'N',
  p_allow_hide_extra_columns  =>'N',
  p_owner                     =>'ASHISH');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315053832185336012.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ID',
  p_display_order          =>1,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'I',
  p_column_label           =>'ID',
  p_report_label           =>'ID',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'HIDDEN',
  p_heading_alignment      =>'CENTER',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 310701022805881037.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'NAME',
  p_display_order          =>2,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'A',
  p_column_label           =>'Nom',
  p_report_label           =>'Nom',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 310701120889881040.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FONTNAME',
  p_display_order          =>3,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'B',
  p_column_label           =>'Nom de police',
  p_report_label           =>'Nom de police',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 310701305497881040.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FONTSIZE',
  p_display_order          =>4,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'D',
  p_column_label           =>'Taille de police',
  p_report_label           =>'Taille de police',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'RIGHT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 310701232337881040.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FONTSPACING',
  p_display_order          =>5,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'C',
  p_column_label           =>'Espacement de police',
  p_report_label           =>'Espacement de police',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 310701415885881041.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FONTWEIGHT',
  p_display_order          =>6,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'E',
  p_column_label           =>'Epaisseur de police',
  p_report_label           =>'Epaisseur de police',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 310701613330881041.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'INITCAP(B.BACKCOLOR)',
  p_display_order          =>7,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'G',
  p_column_label           =>'Couleur d''arrière-plan',
  p_report_label           =>'Couleur d''arrière-plan',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 310701702664881042.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'INITCAP(B.FOREGROUNDCOLOR)',
  p_display_order          =>8,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'H',
  p_column_label           =>'Couleur de premier plan',
  p_report_label           =>'Couleur de premier plan',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 310701519442881041.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'INITCAP(B.FILLPATTERN)',
  p_display_order          =>9,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'F',
  p_column_label           =>'Motif de remplissage',
  p_report_label           =>'Motif de remplissage',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315054202308336014.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PRIORITY',
  p_display_order          =>13,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'M',
  p_column_label           =>'Priorité',
  p_report_label           =>'Priorité',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'NUMBER',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'CENTER',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315054304419336014.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'ASSIGNEE',
  p_display_order          =>14,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'N',
  p_column_label           =>'Destinataire',
  p_report_label           =>'Destinataire',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315054404935336014.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'NOTES',
  p_display_order          =>15,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'O',
  p_column_label           =>'Remarques',
  p_report_label           =>'Remarques',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315054500003336015.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'TAGS',
  p_display_order          =>16,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'P',
  p_column_label           =>'Balises',
  p_report_label           =>'Balises',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315674130429451643.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'APPLICABLE',
  p_display_order          =>17,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'Q',
  p_column_label           =>'Applicable',
  p_report_label           =>'Applicable',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 315674217045451643.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'COMPLETE',
  p_display_order          =>18,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'R',
  p_column_label           =>'Terminé',
  p_report_label           =>'Terminé',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 321124725125002129.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'NOTES_SNIPPET',
  p_display_order          =>19,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'S',
  p_column_label           =>'Fragment de remarques',
  p_report_label           =>'Fragment de remarques',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187789526461015136.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FONTSTYLE',
  p_display_order          =>20,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'T',
  p_column_label           =>'Style de police',
  p_report_label           =>'Style de police',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187789615158015137.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'VISUALATTRIBUTE_COMMENT',
  p_display_order          =>21,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'U',
  p_column_label           =>'Commentaire',
  p_report_label           =>'Commentaire',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'CLOB',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'N',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187789713220015137.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FRAMETITLEBACKCOLOR',
  p_display_order          =>22,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'V',
  p_column_label           =>'Couleur d''arrière-plan de titre de cadre',
  p_report_label           =>'Couleur d''arrière-plan de titre de cadre',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187789810766015137.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FRAMETITLEFILLPATTERN',
  p_display_order          =>23,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'W',
  p_column_label           =>'Motif de remplissage de titre de cadre',
  p_report_label           =>'Motif de remplissage de titre de cadre',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187789924622015138.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FRAMETITLEFONTNAME',
  p_display_order          =>24,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'X',
  p_column_label           =>'Nom de police de titre de cadre',
  p_report_label           =>'Nom de police de titre de cadre',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790001358015138.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FRAMETITLEFONTSIZE',
  p_display_order          =>25,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'Y',
  p_column_label           =>'Taille de police de titre de cadre',
  p_report_label           =>'Taille de police de titre de cadre',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790102931015138.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FRAMETITLEFONTSPACING',
  p_display_order          =>26,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'Z',
  p_column_label           =>'Espacement de police de titre de cadre',
  p_report_label           =>'Espacement de police de titre de cadre',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790208428015138.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FRAMETITLEFONTSTYLE',
  p_display_order          =>27,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AA',
  p_column_label           =>'Style de police de titre de cadre',
  p_report_label           =>'Style de police de titre de cadre',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790321027015139.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FRAMETITLEFONTWEIGHT',
  p_display_order          =>28,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AB',
  p_column_label           =>'Epaisseur de police de titre de cadre',
  p_report_label           =>'Epaisseur de police de titre de cadre',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790421993015139.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'FRAMETITLEFOREGROUNDCOLOR',
  p_display_order          =>29,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AC',
  p_column_label           =>'Couleur de premier plan de titre de cadre',
  p_report_label           =>'Couleur de premier plan de titre de cadre',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790519191015141.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PARENTFILENAME',
  p_display_order          =>30,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AD',
  p_column_label           =>'Nom de fichier parent',
  p_report_label           =>'Nom de fichier parent',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790612265015141.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PARENTFILEPATH',
  p_display_order          =>31,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AE',
  p_column_label           =>'Chemin de fichier parent',
  p_report_label           =>'Chemin de fichier parent',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790719351015142.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PERSISTENTCLIENTINFOLENGTH',
  p_display_order          =>32,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AF',
  p_column_label           =>'Persistent Client Length',
  p_report_label           =>'Persistent Client Length',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790808748015142.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROMPTBACKCOLOR',
  p_display_order          =>33,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AG',
  p_column_label           =>'Couleur d''arrière-plan de l''invite',
  p_report_label           =>'Couleur d''arrière-plan de l''invite',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187790920718015142.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROMPTFILLPATTERN',
  p_display_order          =>34,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AH',
  p_column_label           =>'Motif de remplissage de l''invite',
  p_report_label           =>'Motif de remplissage de l''invite',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791018440015142.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROMPTFONTNAME',
  p_display_order          =>35,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AI',
  p_column_label           =>'Nom de police de l''invite',
  p_report_label           =>'Nom de police de l''invite',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791131361015142.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROMPTFONTSIZE',
  p_display_order          =>36,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AJ',
  p_column_label           =>'Taille de police de l''invite',
  p_report_label           =>'Taille de police de l''invite',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791207034015143.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROMPTFONTSPACING',
  p_display_order          =>37,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AK',
  p_column_label           =>'Espacement de police de l''invite',
  p_report_label           =>'Espacement de police de l''invite',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791313221015145.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROMPTFONTSTYLE',
  p_display_order          =>38,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AL',
  p_column_label           =>'Style de police de l''invite',
  p_report_label           =>'Style de police de l''invite',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791400115015145.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROMPTFONTWEIGHT',
  p_display_order          =>39,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AM',
  p_column_label           =>'Epaisseur de police de l''invite',
  p_report_label           =>'Epaisseur de police de l''invite',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791513995015145.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'PROMPTFOREGROUNDCOLOR',
  p_display_order          =>40,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AN',
  p_column_label           =>'Couleur de premier plan de l''invite',
  p_report_label           =>'Couleur de premier plan de l''invite',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791605594015145.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'SMARTCLASS',
  p_display_order          =>41,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AO',
  p_column_label           =>'Smart Class',
  p_report_label           =>'Smart Class',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791723893015146.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'SUBCLASSOBJECTGROUP',
  p_display_order          =>42,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AP',
  p_column_label           =>'Groupe d''objets de sous-classe',
  p_report_label           =>'Groupe d''objets de sous-classe',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 187791832137015146.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'VISUALATTRIBUTETYPE',
  p_display_order          =>43,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AQ',
  p_column_label           =>'Type d''attribut visuel',
  p_report_label           =>'Type d''attribut visuel',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
begin
wwv_flow_api.create_worksheet_column(
  p_id => 269307729951725602.4402+wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4402,
  p_worksheet_id => 310700815979880725.4402+wwv_flow_api.g_id_offset,
  p_db_column_name         =>'COMMENT_SNIPPET',
  p_display_order          =>44,
  p_group_id               =>null+wwv_flow_api.g_id_offset,
  p_column_identifier      =>'AR',
  p_column_label           =>'Fragment de commentaire',
  p_report_label           =>'Fragment de commentaire',
  p_sync_form_label        =>'Y',
  p_display_in_default_rpt =>'Y',
  p_is_sortable            =>'Y',
  p_allow_sorting          =>'Y',
  p_allow_filtering        =>'Y',
  p_allow_ctrl_breaks      =>'Y',
  p_allow_aggregations     =>'Y',
  p_allow_computations     =>'Y',
  p_allow_charting         =>'Y',
  p_others_may_edit        =>'Y',
  p_others_may_view        =>'Y',
  p_column_type            =>'STRING',
  p_display_as             =>'TEXT',
  p_display_text_as        =>'ESCAPE_SC',
  p_heading_alignment      =>'LEFT',
  p_column_alignment       =>'LEFT',
  p_rpt_distinct_lov       =>'Y',
  p_rpt_show_filter_lov    =>'D',
  p_rpt_filter_date_ranges =>'ALL',
  p_help_text              =>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 313185523976028280.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4402,
  p_plug_name=> 'Attributs visuels',
  p_region_name=>'',
  p_plug_template=> 23957836075509199.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> 'Utilisez cette page pour visualiser les informations sur les attributs visuels extraits de l''application Oracle Forms.<p/>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>273183013799611405.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4402,
  p_branch_action=> 'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 11,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 04-JUN-2008 04:17 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour rechercher un attribut, saisissez son nom sans distinction entre les majuscules et les minuscules et cliquez sur <b>OK</b>. Pour visualiser tous les attributs visuels, laissez le champ vide et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>273180923457611387.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4402,
  p_name=>'P17_VISUAL_ATTRIBS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 273179131635611336.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Attributs visuels',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre d''attributs à afficher et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>273181423342611392.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4402,
  p_name=>'P17_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 273179131635611336.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>273181913075611393.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4402,
  p_name=>'P17_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 273179131635611336.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>273182124862611393.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4402,
  p_name=>'P17_FILE_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 17.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_18.44
prompt  ...PAGE 18.4402: Charger le script
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/appmgr_start.htm';

ph:=ph||'<style>	#AjaxLoading{padding:5px;font-size:18px;width:200px;text-align:center;left:50%;top:5%;position:absolute;border:2px solid #666;background-color:#FFF;}'||chr(10)||
'</style>'||chr(10)||
'<script language="JavaScript" type="text/javascript">'||chr(10)||
'function doSubmit(r){'||chr(10)||
'		html_ShowElement(''AjaxLoading'');'||chr(10)||
'	window.setTimeout(''html_GetElement("wait").src = html_GetElement("wait").src'', 100);'||chr(10)||
'	flowSelectAll();'||chr(10)||
'	document.wwv_flow';

ph:=ph||'.p_request.value = r;'||chr(10)||
'	document.wwv_flow.submit();'||chr(10)||
'} // End doSubmit()'||chr(10)||
'</script>'||chr(10)||
'';

wwv_flow_api.create_page(
  p_id     => 18.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Charger le script',
  p_step_title=> 'Créer un projet de migration',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_footer_text => '<div id="AjaxLoading" style="display:none;"><img src="#IMAGE_PREFIX#processing3.gif" id="wait" /></div>',
  p_autocomplete_on_off => 'ON',
  p_group_id => 5872827478268282+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 25821516221167914.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090528134448',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>18.4402,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>18.4402,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 27366305974203993.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'if :P3_TYPE = ''access'' then'||chr(10)||
'    wwv_mig_acc_load.display_load_confirm ('||chr(10)||
'        p_file_id          => :P18_FILE_ID,'||chr(10)||
'        p_date_time_format => ''&DATE_TIME_FORMAT.'');'||chr(10)||
'    --  p_date_time_format => ''MM/DD/YYYY HH24:MI:SSPM'');'||chr(10)||
'elsif :P3_TYPE = ''forms'' then'||chr(10)||
' --   wwv_mig_frm_load_xml.display_load_confirm ('||chr(10)||
' --       p_file_id          => :P18_FILE_ID,'||chr(10)||
' --       p_date_time_format => ''&DATE_TIME_FOR';

s:=s||'MAT.'');'||chr(10)||
''||chr(10)||
'    wwv_mig_frm_load_xml.display_load_confirm ('||chr(10)||
'       p_project_id          => :MW_PROJ_ID,'||chr(10)||
'       p_date_time_format    => ''&DATE_TIME_FORMAT.'');  '||chr(10)||
'   '||chr(10)||
'end if;';

wwv_flow_api.create_page_plug (
  p_id=> 27599720425595483.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4402,
  p_plug_name=> 'Créer un projet de migration',
  p_region_name=>'',
  p_plug_template=> 145308009821552281.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'139359500914809151';

wwv_flow_api.create_page_plug (
  p_id=> 139367206221018805.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4402,
  p_plug_name=> 'Project Progress Bar',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 90,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 139359500914809151 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 29974228020245841.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 27599720425595483+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 27368704904296961.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4402,
  p_button_sequence=> 20,
  p_button_plug_id => 27599720425595483+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_image_alt=> 'Fin',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2063416744723079.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4402,
  p_button_sequence=> 20,
  p_button_plug_id => 27599720425595483+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> 'Télécharger un autre fichier >',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:106:&SESSION.:MULTIPLE:&DEBUG.:106:P106_PROJECT_ID:&MW_PROJ_ID.',
  p_button_condition=> 'MW_MIG_TYPE',
  p_button_condition2=> 'forms',
  p_button_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>27610814603773602.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4402,
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.:LOAD:&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>27368704904296961.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':P3_TYPE = ''access''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 09-JAN-2006 16:44 by HILARY');
 
wwv_flow_api.create_page_branch(
  p_id=>259874213290130837.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4402,
  p_branch_action=> 'f?p=&APP_ID.:51:&SESSION.::&DEBUG.::MW_PROJ_NAME:&P3_MIGRATION_NAME.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>27368704904296961.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> ':P3_TYPE = ''forms''',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 27-MAY-2008 22:19 by ASHISH');
 
wwv_flow_api.create_page_branch(
  p_id=>29168925935188290.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4402,
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>29974228020245841.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 10-JAN-2006 13:20 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27398716352531699.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4402,
  p_name=>'P18_FILE_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 139367206221018805.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'File Id',
  p_source=>'declare'||chr(10)||
'  l_file_id number;'||chr(10)||
'begin'||chr(10)||
'if :P3_TYPE = ''access'' then'||chr(10)||
'  select ID into l_file_id from wwv_flow_file_objects$'||chr(10)||
'  where pathid = :MW_PROJ_ID;'||chr(10)||
'-- elsif :P3_TYPE = ''forms'' then'||chr(10)||
'--  select ID into l_file_id from wwv_mig_forms'||chr(10)||
'--  where project_id = :MW_PROJ_ID;'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'return l_file_id;'||chr(10)||
'end;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27402126226572414.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4402,
  p_name=>'P18_SCRIPT_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 139367206221018805.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27438219299338383.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4402,
  p_name=>'P18_PROJECT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 139367206221018805.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Project Id',
  p_source=>'MW_PROJ_ID',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN_PROTECTED',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>27622828408099260.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4402,
  p_name=>'P18_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 139367206221018805.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'ID',
  p_source=>'MW_PROJ_ID',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 27889420910381031.4402 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_validation_name => 'set job queue process',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
'  l_jqp varchar2(1000) := ''0'';'||chr(10)||
'begin '||chr(10)||
'  for c1 in (select value '||chr(10)||
'             from v$parameter'||chr(10)||
'             where name = ''job_queue_processes'')'||chr(10)||
'  loop'||chr(10)||
'    l_jqp := c1.value;'||chr(10)||
'  end loop;'||chr(10)||
'  '||chr(10)||
'  if l_jqp = ''0'' then'||chr(10)||
'  	return false;'||chr(10)||
'  else'||chr(10)||
'  	return true;'||chr(10)||
'  end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Les processus de file d''attente de travaux de base de données ne sont pas activés. Demandez à l''administrateur de définir le paramètre d''initialisation JOB_QUEUE_PROCESSES.',
  p_validation_condition=> ':P3_TYPE = ''access''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> .4402 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv ('||chr(10)||
'    p_schema => :P3_SCHEMA'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 27381212000991083.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Check Privileges',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erreur lors de la vérification des privilèges.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'wwv_mig_acc_load.g_projectid := :MW_PROJ_ID;'||chr(10)||
''||chr(10)||
'insert into WWV_MIG_PROJECTS (ID, MIGRATION_NAME, MIGRATION_TYPE, DESCRIPTION,DATABASE_SCHEMA) values(wwv_mig_acc_load.g_projectid, :P3_MIGRATION_NAME, :P3_TYPE, :P3_DESCRIPTION,:P3_SCHEMA);'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 37180116777782075.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ACCESS:Create Access Migration Project',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>27368704904296961.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>':P3_TYPE = ''access''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> 'Projet créé.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'  l_file_id number := null;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for c1 in (select id'||chr(10)||
'             from wwv_flow_file_objects$'||chr(10)||
'             where pathid = :MW_PROJ_ID )'||chr(10)||
'  loop'||chr(10)||
'     l_file_id := c1.id;'||chr(10)||
'     exit;'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  wwv_flow_imp_parser.parse ('||chr(10)||
'     p_file_id          => l_file_id,'||chr(10)||
'     p_parse_as_schema  => :P3_SCHEMA,'||chr(10)||
'     p_install_as_flow  => :FLOW_ID,'||chr(10)||
'     p_original_flow_id => :FLOW_ID,'||chr(10)||
'     p_adjust';

p:=p||'_offset    => FALSE '||chr(10)||
'   );'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 27380122932833385.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ACCESS:Parse Access SQL Script',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''access''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'update WWV_MIG_ACCESS'||chr(10)||
'set database_schema = :P3_SCHEMA'||chr(10)||
'where project_id = :MW_PROJ_ID;'||chr(10)||
''||chr(10)||
':MW_SCHEMA := :P3_SCHEMA;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 10666605522999729.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ACCESS:Update schema information',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''access''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'for c1 in ('||chr(10)||
'   select count(dbid) cnt from wwv_mig_access'||chr(10)||
'   where project_id = :MW_PROJ_ID'||chr(10)||
'   and security_group_id = :flow_security_group_id'||chr(10)||
')'||chr(10)||
'loop'||chr(10)||
'  :P2_DBCOUNT := c1.cnt;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 27092230927004126.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 60,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ACCESS:Set database count',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>27368704904296961.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>':P3_TYPE = ''access''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_clob        clob;'||chr(10)||
'  l_charset     varchar2(100);'||chr(10)||
'begin'||chr(10)||
'    --'||chr(10)||
'  FOR c1 in (SELECT id, file_content blob_content, file_char_set'||chr(10)||
'             FROM   wwv_mig_forms'||chr(10)||
'             WHERE  project_id = :MW_PROJ_ID'||chr(10)||
'             AND    security_group_id = :flow_security_group_id'||chr(10)||
'  ) LOOP'||chr(10)||
'      --'||chr(10)||
'      -- If no character set was specified at file upload time,'||chr(10)||
'      -- default to the DAD characte';

p:=p||'r set'||chr(10)||
'      --'||chr(10)||
'      if c1.file_char_set is null then'||chr(10)||
'          l_charset := nvl(owa_util.get_cgi_env(''REQUEST_IANA_CHARSET''), ''utf-8'');'||chr(10)||
'      else'||chr(10)||
'          l_charset := c1.file_char_set;'||chr(10)||
'      end if;'||chr(10)||
'      --'||chr(10)||
'      l_clob := wwv_flow_utilities.blob_to_clob('||chr(10)||
'                  p_blob    => c1.blob_content,'||chr(10)||
'                  p_charset => l_charset);'||chr(10)||
''||chr(10)||
'      update wwv_mig_forms'||chr(10)||
'      set    xml_con';

p:=p||'tent = XMLTYPE(l_clob)'||chr(10)||
'      where  id = c1.id;'||chr(10)||
''||chr(10)||
'      -- exit;'||chr(10)||
'      --'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 3998117240951026.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 75,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Update XML Column',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>27368704904296961.4402 + wwv_flow_api.g_id_offset,
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||chr(10)||
'  FOR c1 in (SELECT id'||chr(10)||
'             FROM   wwv_mig_forms'||chr(10)||
'             WHERE  project_id = :MW_PROJ_ID'||chr(10)||
'             AND    security_group_id = :flow_security_group_id'||chr(10)||
'  ) LOOP'||chr(10)||
''||chr(10)||
'      if (wwv_mig_frm_load_xml.is_valid_forms_xml('||chr(10)||
'                          p_file_id => c1.id,'||chr(10)||
'                          p_project_id => :MW_PROJ_ID,'||chr(10)||
'                          p_security_group_id => :flow_security_gr';

p:=p||'oup_id)) then'||chr(10)||
''||chr(10)||
'          wwv_mig_frm_load_xml.load_all_nodes('||chr(10)||
'                            p_file_id => c1.id);'||chr(10)||
'      '||chr(10)||
'      else'||chr(10)||
'          delete wwv_mig_forms where id = c1.id;'||chr(10)||
'          delete wwv_mig_projects where id = :MW_PROJ_ID;'||chr(10)||
'          commit;'||chr(10)||
'          apex_application.g_unrecoverable_error := true;'||chr(10)||
'          owa_util.redirect_url(''f?p=4400:105:&SESSION.:FMB:NO::P105_RETURN_PAGE:3'');'||chr(10)||
'  ';

p:=p||'    end if;'||chr(10)||
'      '||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  FOR c2 in (SELECT id'||chr(10)||
'             FROM   wwv_mig_rpts'||chr(10)||
'             WHERE  project_id = :MW_PROJ_ID'||chr(10)||
'             AND    security_group_id = :flow_security_group_id'||chr(10)||
'  ) LOOP'||chr(10)||
''||chr(10)||
'      if (wwv_mig_rpt_load_xml.is_valid_report_xml('||chr(10)||
'                          p_file_id => c2.id,'||chr(10)||
'                          p_project_id => :MW_PROJ_ID,'||chr(10)||
'                          p_security_gro';

p:=p||'up_id => :flow_security_group_id)) then'||chr(10)||
''||chr(10)||
'      '||chr(10)||
'          wwv_mig_rpt_load_xml.load_all_nodes ('||chr(10)||
'                            p_file_id => c2.id);'||chr(10)||
''||chr(10)||
'      else'||chr(10)||
'          delete wwv_mig_rpts where id = c2.id;'||chr(10)||
'          delete wwv_mig_projects where id = :MW_PROJ_ID;'||chr(10)||
'          commit;'||chr(10)||
'          apex_application.g_unrecoverable_error := true;'||chr(10)||
'          owa_util.redirect_url(''f?p=4400:105:&SESSION.:RPT:N';

p:=p||'O::P105_RETURN_PAGE:3'');'||chr(10)||
'      end if;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
''||chr(10)||
'  FOR c3 in (SELECT id'||chr(10)||
'             FROM   wwv_mig_frm_menus'||chr(10)||
'             WHERE  project_id = :MW_PROJ_ID'||chr(10)||
'             AND    security_group_id = :flow_security_group_id'||chr(10)||
'  ) LOOP'||chr(10)||
'      if (wwv_mig_frmmenu_load_xml.is_valid_menu_xml('||chr(10)||
'                                p_file_id => c3.id,'||chr(10)||
'                                p_project_id => :MW_PROJ_ID,'||chr(10)||
' ';

p:=p||'                               p_security_group_id => :flow_security_group_id)) then '||chr(10)||
'          '||chr(10)||
'          wwv_mig_frmmenu_load_xml.load_all_nodes ('||chr(10)||
'                            p_file_id => c3.id);'||chr(10)||
'      else'||chr(10)||
'          delete wwv_mig_frm_menus where id = c3.id;'||chr(10)||
'          delete wwv_mig_projects where id = :MW_PROJ_ID;'||chr(10)||
'          commit;'||chr(10)||
'          apex_application.g_unrecoverable_error := true;'||chr(10)||
'    ';

p:=p||'      owa_util.redirect_url(''f?p=4400:105:&SESSION.:MMB:NO::P105_RETURN_PAGE:3'');'||chr(10)||
''||chr(10)||
'      end if;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  FOR c4 in (SELECT id'||chr(10)||
'             FROM   wwv_mig_olb'||chr(10)||
'             WHERE  project_id = :MW_PROJ_ID'||chr(10)||
'             AND    security_group_id = :flow_security_group_id'||chr(10)||
'  ) LOOP'||chr(10)||
'      if (wwv_mig_frm_olb_load_xml.is_valid_olb_xml('||chr(10)||
'                                p_file_id => c4.id,'||chr(10)||
'            ';

p:=p||'                    p_project_id => :MW_PROJ_ID,'||chr(10)||
'                                p_security_group_id => :flow_security_group_id)) then '||chr(10)||
'          '||chr(10)||
'          wwv_mig_frm_olb_load_xml.load_all_nodes ('||chr(10)||
'                            p_file_id => c4.id);'||chr(10)||
'      else'||chr(10)||
'          delete wwv_mig_frm_menus where id = c4.id;'||chr(10)||
'          delete wwv_mig_projects where id = :MW_PROJ_ID;'||chr(10)||
'          commit;'||chr(10)||
''||chr(10)||
'          a';

p:=p||'pex_application.g_unrecoverable_error := true;'||chr(10)||
'          owa_util.redirect_url(''f?p=4400:105:&SESSION.:OLB:NO::P105_RETURN_PAGE:3'');'||chr(10)||
'      end if;'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'  :MW_SCHEMA := :P3_SCHEMA;'||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 6757312227913592.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 85,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Parse & Load XML into Forms (fmb) & Reports (rpt) & Menus (mmb) & Object Library (olb) Tables',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> 'Projet créé.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||chr(10)||
'  FOR c1 in (SELECT id'||chr(10)||
'               FROM wwv_mig_forms'||chr(10)||
'              WHERE project_id        = :MW_PROJ_ID'||chr(10)||
'                AND security_group_id = :FLOW_SECURITY_GROUP_ID'||chr(10)||
'  ) LOOP'||chr(10)||
'      wwv_mig_frm_utilities.load_frm_revision_tables ('||chr(10)||
'        p_file_id => c1.id);'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 14427106883395495.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 86,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Load Revision Tables',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_mig_frm_utilities.set_component_defaults(p_project_id => :MW_PROJ_ID,'||chr(10)||
'                                             p_security_group_id => :flow_security_group_id);';

wwv_flow_api.create_page_process(
  p_id     => 331103124281483603.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 90,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Set Component Applicability',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'To be moved to wwv_mig_frm_load.plb when XML parsing work is complete.');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_mig_frm_utilities.set_trigger_defaults(p_project_id => :MW_PROJ_ID,'||chr(10)||
'                                           p_security_group_id => :flow_security_group_id);'||chr(10)||
''||chr(10)||
'-- Set Form-Level Triggers across Migration Project'||chr(10)||
'wwv_mig_frm_utilities.set_formtrig_applicability('||chr(10)||
'                       p_project_id => :MW_PROJ_ID,'||chr(10)||
'                       p_security_group_id => :flow_security_group_id);'||chr(10)||
'-- Set Bl';

p:=p||'ock-Level Triggers across Migration Project'||chr(10)||
'wwv_mig_frm_utilities.set_blktrig_applicability('||chr(10)||
'                       p_project_id => :MW_PROJ_ID,'||chr(10)||
'                       p_security_group_id => :flow_security_group_id);'||chr(10)||
'-- Set Item-Level Triggers across Migration Project'||chr(10)||
'wwv_mig_frm_utilities.set_itemtrig_applicability('||chr(10)||
'                       p_project_id => :MW_PROJ_ID,'||chr(10)||
'                       p_secu';

p:=p||'rity_group_id => :flow_security_group_id);';

wwv_flow_api.create_page_process(
  p_id     => 331183118532967298.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 100,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Set Trigger Applicability',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'    l_block_id            number;'||chr(10)||
'    l_status              varchar2(4)     := null;'||chr(10)||
'    l_block_name          varchar2(255);'||chr(10)||
'    l_block_source        varchar(32676);'||chr(10)||
'    l_enhanced_query      varchar2(32676);'||chr(10)||
'    l_original_query      varchar2(32676);'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'    for c1 in ( select b.id block_id,'||chr(10)||
'                       b.name block_name,'||chr(10)||
'                       querydatasourcename block_so';

p:=p||'urce'||chr(10)||
'                from   wwv_mig_forms p, '||chr(10)||
'                       wwv_mig_frm_modules m, '||chr(10)||
'                       wwv_mig_frm_formmodules f, '||chr(10)||
'                       wwv_mig_frm_blocks b '||chr(10)||
'                where  p.id = m.file_id'||chr(10)||
'                and    m.id = f.module_id'||chr(10)||
'                and    f.id = b.formmodule_id'||chr(10)||
'                and    p.project_id = :MW_PROJ_ID'||chr(10)||
'    ) LOOP'||chr(10)||
'        l_block_id    ';

p:=p||'   := c1.block_id;'||chr(10)||
'        l_block_name     := c1.block_name;'||chr(10)||
'        l_block_source   := c1.block_source;'||chr(10)||
'        l_status         := null;'||chr(10)||
'        l_original_query := ''select ''||chr(10);'||chr(10)||
''||chr(10)||
'        IF (wwv_mig_frm_utilities.get_block_mapping('||chr(10)||
'                      p_project_id => :MW_PROJ_ID,'||chr(10)||
'                      p_security_group_id => :flow_security_group_id,'||chr(10)||
'                      p_block_id => ';

p:=p||'c1.block_id,'||chr(10)||
'                      p_schema => :MW_SCHEMA)  <> ''MASTERDETAIL'') then'||chr(10)||
''||chr(10)||
'            if l_block_source is not null then '||chr(10)||
'                for c2 in ( select i.id, '||chr(10)||
'                                   nvl(i.columnname,i.name) column_name,'||chr(10)||
'                                   i.id block_item_id,'||chr(10)||
'                                   i.databaseitem'||chr(10)||
'                            from   wwv_mig_form';

p:=p||'s p, '||chr(10)||
'                                   wwv_mig_frm_modules m, '||chr(10)||
'                                   wwv_mig_frm_formmodules f, '||chr(10)||
'                                   wwv_mig_frm_blocks b, '||chr(10)||
'                                   wwv_mig_frm_blk_items i'||chr(10)||
'                            where  p.id = m.file_id'||chr(10)||
'                            and    m.id = f.module_id'||chr(10)||
'                            and    f.id = b.formm';

p:=p||'odule_id'||chr(10)||
'                            and    b.id = i.block_id'||chr(10)||
'                            and    (upper(i.databaseitem) = ''TRUE'' or '||chr(10)||
'                (i.databaseitem is null and (i.itemtype is null or i.itemtype <> ''Push Button'')))'||chr(10)||
'                            and    p.project_id = :MW_PROJ_ID'||chr(10)||
'                            and    b.id = l_block_id'||chr(10)||
'                ) LOOP'||chr(10)||
'                    l_original_';

p:=p||'query := l_original_query || l_status ||''    "''||trim(l_block_name)||''"."''|| trim(c2.column_name) || ''"''; '||chr(10)||
'                    l_status := '',''||chr(10);'||chr(10)||
'                END LOOP;'||chr(10)||
'          -- code to check the Table name existing in in the schema, else use the upper case of that'||chr(10)||
'           if wwv_flow_builder.is_valid_table_or_view(:MW_SCHEMA, trim(l_block_source)) = ''U'' then '||chr(10)||
'                    ';

p:=p||'  l_block_source := upper(l_block_source);'||chr(10)||
'           end if;'||chr(10)||
'           l_original_query := l_original_query || chr(10) || '' from "'' || trim(l_block_source) ||''" "''|| trim(l_block_name) || ''"'';'||chr(10)||
''||chr(10)||
'                l_enhanced_query := wwv_mig_frm_utilities.trigger_parse_block_sql(:MW_PROJ_ID, l_block_id, :MW_SCHEMA);'||chr(10)||
'           '||chr(10)||
'                UPDATE wwv_mig_frm_blocks '||chr(10)||
'                SET    origin';

p:=p||'al_query = l_original_query, '||chr(10)||
'                       enhanced_query = l_enhanced_query, '||chr(10)||
'                       use_query = decode(l_enhanced_query,null,''ORIGINAL'',''ENHANCED''),'||chr(10)||
'                       complete = decode(l_enhanced_query,null,''N'',''Y''),'||chr(10)||
'                       notes = decode(l_enhanced_query,null,null,wwv_flow_lang.system_message(''F4400_ENHANCED_QRY_NOTE''))'||chr(10)||
'                WHERE  id = ';

p:=p||'l_block_id;'||chr(10)||
''||chr(10)||
''||chr(10)||
'                -- Set COMPLETE to ''Y'' for block & associated items using Enhanced Query'||chr(10)||
'                if (l_enhanced_query is not null) then'||chr(10)||
'                    -- Fix for bug 7630444 - Only update POST-QUERY trigger'||chr(10)||
'                    --UPDATE wwv_mig_frm_blk_triggers'||chr(10)||
'                    --SET    complete = ''Y'''||chr(10)||
'                    --WHERE  block_id = l_block_id;'||chr(10)||
''||chr(10)||
'               ';

p:=p||'     UPDATE wwv_mig_frm_blk_triggers'||chr(10)||
'                    SET    notes = wwv_flow_lang.system_message(''F4400_ENHANCED_QRY_TRIG_NOTE''),'||chr(10)||
'                           complete = ''Y'''||chr(10)||
'                    WHERE  block_id = l_block_id'||chr(10)||
'                    AND    name = ''POST-QUERY'';'||chr(10)||
'                    --AND    complete = ''Y'';'||chr(10)||
''||chr(10)||
'                    FOR c3 IN (select i.id item_id'||chr(10)||
'                              ';

p:=p||' from   wwv_mig_forms p, wwv_mig_frm_modules m, '||chr(10)||
'                                      wwv_mig_frm_formmodules f, wwv_mig_frm_rev_formmodules rf, '||chr(10)||
'                                      wwv_mig_frm_blocks b, wwv_mig_frm_rev_blocks rb, '||chr(10)||
'                                      wwv_mig_frm_blk_items i, wwv_mig_frm_rev_blk_items ri'||chr(10)||
'                               where  p.id = m.file_id'||chr(10)||
'                  ';

p:=p||'             and    m.id = f.module_id'||chr(10)||
'                               and    f.id = b.formmodule_id'||chr(10)||
'                               and    f.id = rf.formmodule_id'||chr(10)||
'                               and    b.id = rb.block_id'||chr(10)||
'                               and    b.id = i.block_id'||chr(10)||
'                               and    b.id = l_block_id'||chr(10)||
'                               and    i.id = ri.item_id'||chr(10)||
'             ';

p:=p||'       ) LOOP'||chr(10)||
'        '||chr(10)||
'                        UPDATE wwv_mig_frm_blk_items'||chr(10)||
'                        SET    complete = ''Y'''||chr(10)||
'                        WHERE  id = c3.item_id;'||chr(10)||
'            '||chr(10)||
'                        -- Fix for bug 76030444 - do not update Item-level Triggers'||chr(10)||
'                        --UPDATE wwv_mig_frm_blk_item_triggers'||chr(10)||
'                        --SET    complete = ''Y'''||chr(10)||
'                      ';

p:=p||'  --WHERE  item_id = c3.item_id;'||chr(10)||
'        '||chr(10)||
'                   END LOOP;'||chr(10)||
'                END IF;'||chr(10)||
''||chr(10)||
'                commit;'||chr(10)||
'            END IF;'||chr(10)||
''||chr(10)||
'        END IF;    '||chr(10)||
''||chr(10)||
'    END LOOP;'||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 72937719491257872.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 110,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Set Block Query',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'       l_block_id       number;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for c1 in ( '||chr(10)||
'       select b.id block_id'||chr(10)||
'       from   wwv_mig_forms p, '||chr(10)||
'              wwv_mig_frm_modules m, '||chr(10)||
'              wwv_mig_frm_formmodules f, '||chr(10)||
'              wwv_mig_frm_blocks b '||chr(10)||
'       where  p.id = m.file_id'||chr(10)||
'       and    m.id = f.module_id'||chr(10)||
'       and    f.id = b.formmodule_id'||chr(10)||
'       and    p.project_id = :MW_PROJ_ID'||chr(10)||
'      )'||chr(10)||
'  loop'||chr(10)||
''||chr(10)||
'    ';

p:=p||'l_block_id     := c1.block_id;'||chr(10)||
'    wwv_mig_frm_utilities.trigger_query_to_lov(:MW_PROJ_ID,l_block_id);'||chr(10)||
'    commit;'||chr(10)||
'  end loop;'||chr(10)||
'end ;';

wwv_flow_api.create_page_process(
  p_id     => 106592605139500826.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 120,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Convert POST-QUERY to LOV',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'BEGIN'||chr(10)||
'  FOR c1 in (SELECT id'||chr(10)||
'               FROM wwv_mig_forms'||chr(10)||
'              WHERE project_id        = :MW_PROJ_ID'||chr(10)||
'                AND security_group_id = :FLOW_SECURITY_GROUP_ID'||chr(10)||
'  ) LOOP'||chr(10)||
'      wwv_mig_frm_utilities.set_block_inclusion ('||chr(10)||
'        p_file_id => c1.id,'||chr(10)||
'        p_project_id => :MW_PROJ_ID,'||chr(10)||
'        p_security_group_id => :flow_security_group_id);'||chr(10)||
'  END LOOP;'||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 111087104127190429.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 130,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'FORMS:Exclude Blocks Without Database Source',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P3_TYPE = ''forms''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
''||chr(10)||
'delete from wwv_flow_file_objects$'||chr(10)||
'where id = :P18_FILE_ID;'||chr(10)||
''||chr(10)||
'delete from wwv_mig_projects'||chr(10)||
'where ID = :MW_PROJ_ID;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 28910517081996474.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 18.4402,
  p_process_sequence=> 20,
  p_process_point=> 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'clean up projects & files tables',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>29974228020245841.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 18.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_19.44
prompt  ...PAGE 19.4402: Détails de l'état nécessaires au lien de téléchargement de fichier
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'No help is available for this page.';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 19.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Détails de l''état nécessaires au lien de téléchargement de fichier',
  p_step_title=> 'Détails de l''état',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'ON',
  p_group_id => 280692031983283006+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162012',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>19.4402,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>19.4402,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 239396826523553343.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4402,
  p_plug_name=> 'Panneau sur WWV_MIG_RPTS',
  p_region_name=>'',
  p_plug_template=> 145308009821552281.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 239397104332553346.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4402,
  p_button_sequence=> 30,
  p_button_plug_id => 239396826523553343+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P19_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 239397424547553348.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 239396826523553343+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:19:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 239397004964553346.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4402,
  p_button_sequence=> 40,
  p_button_plug_id => 239396826523553343+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_image_alt=> 'Créer',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P19_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_database_action=>'INSERT',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 239397232552553346.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4402,
  p_button_sequence=> 20,
  p_button_plug_id => 239396826523553343+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_image_alt=> 'Supprimer',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> 'P19_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'DELETE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>239398007373553351.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4402,
  p_branch_action=> 'f?p=&APP_ID.:19:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>239398227422553354.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4402,
  p_name=>'P19_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 239396826523553343.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Id',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN_PROTECTED',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>239398420629553366.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4402,
  p_name=>'P19_FILE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 239396826523553343.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Nom de fichier',
  p_source=>'FILE_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>239398632444553367.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4402,
  p_name=>'P19_FILE_MIME_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 239396826523553343.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Type MIME de fichier',
  p_source=>'FILE_MIME_TYPE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>239398800645553367.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4402,
  p_name=>'P19_FILE_CONTENT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 239396826523553343.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Contenu de fichier',
  p_source=>'FILE_CONTENT:FILE_MIME_TYPE:FILE_NAME:FILE_UPDATED_ON:FILE_CHAR_SET:attachment:',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'FILE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>239399017561553367.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4402,
  p_name=>'P19_FILE_CHAR_SET',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 239396826523553343.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Jeu de caractères de fichier',
  p_source=>'FILE_CHAR_SET',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:WWV_MIG_RPTS:P19_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 239399332606553370.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 19.4402,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from WWV_MIG_RPTS',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible d''extraire la ligne.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_MIG_RPTS:P19_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 239399519451553370.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 19.4402,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of WWV_MIG_RPTS',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Impossible de traiter la ligne de la table WWV_MIG_RPTS.',
  p_process_success_message=> 'Action traitée.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'19';

wwv_flow_api.create_page_process(
  p_id     => 239399727988553371.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 19.4402,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'reset page',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>239397232552553346.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 19.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_20.44
prompt  ...PAGE 20.4402: Etats
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_recreports.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 20.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Etats',
  p_step_title=> 'Etats',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162012',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>20.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'htp.p(''<span class="instructiontext">'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P20_REPORTS_HELP''));'||chr(10)||
'htp.p(''</span><br />'');'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 6809632642830709.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4402,
  p_plug_name=> 'Etats',
  p_region_name=>'',
  p_plug_template=> 86904609451444726.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 41,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20547200926248935.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22772815566442717.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4402,
  p_plug_name=> 'SQL Query Tasks',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 51,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 22752402136643992 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 34589212398545247.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4402,
  p_plug_name=> 'Barre supérieure',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare '||chr(10)||
'  q varchar2(32767);'||chr(10)||
'begin'||chr(10)||
'  q := '||chr(10)||
''''||chr(10)||
'select distinct'||chr(10)||
'htmldb_item.checkbox(1, x.reportid,   decode(x.source_type,'||chr(10)||
'''''TABLE'''',decode(x.status_2,''''VALID'''',decode(x.stat_tab,''''INCLUDE'''',decode(x.status,''''EXCLUDE'''',null,''''INCLUDE'''',''''CHECKED''''),''''DISABLED''''),''''DISABLED''''),'||chr(10)||
'''''QUERY'''',decode(x.status_2,''''VALID'''',decode(x.stat_view,''''INCLUDE'''',decode(x.status,''''EXCLUDE'''',null,''''INCLUDE'''',''''CHECKED';

s:=s||'''''),''''DISABLED''''),''''DISABLED''''),'||chr(10)||
'''''SQL Query'''',decode(x.source_status,''''VALID'''',decode(x.status,''''EXCLUDE'''',null,''''INCLUDE'''',''''CHECKED''''),''''DISABLED'''','||chr(10)||
'null,''''DISABLED'''')),null,null,''''f01_''''||rownum,t.inc) ||'||chr(10)||
'                       htmldb_item.hidden(2,x.reportid) " ",'||chr(10)||
''||chr(10)||
''||chr(10)||
'       x.reportid,'||chr(10)||
'       x.repname,'||chr(10)||
'       x.recordsource,'||chr(10)||
'       x.dbname,'||chr(10)||
'       x.source_type,'||chr(10)||
'       x.source_name,'||chr(10)||
'decode(';

s:=s||'x.source_type,''''QUERY'''', ''''<a href="f?p=4400:30:&SESSION.::NO::P30_QUERY_NAME,P30_VIEW_NAME:''''||x.recordsource||'''',''''||x.source_name||''''">''''||htmldb_item.text_from_LOV(x.source_type,''''SOURCE TYPES'''')||''''</a>'''','||chr(10)||
'                     ''''TABLE'''', decode(x.source_name,NULL,htmldb_item.text_from_LOV(x.source_type,''''SOURCE TYPES''''), ''''<a href="f?p=4400:22:&SESSION.::NO::P22_TABLE_NAME:''''||x.source_name||';

s:=s||'''''">''''||htmldb_item.text_from_LOV(x.source_type,''''SOURCE TYPES'''')||''''</a>''''),'||chr(10)||
'                     ''''SQL Query'''',''''<a href="f?p=4400:42:&SESSION.:REP:NO:42:P42_REPORT_NAME,P42_REPORT_ID,P42_OBJECT_TYPE,P42_ACC_OBJ,P42_PREVIOUS:''''||x.repname||'''',''''||x.reportid||'''',''''||x.source_type||'''',REP,20">''''||htmldb_item.text_from_LOV(x.source_type,''''SOURCE TYPES'''')||''''</a>'''') testing,'||chr(10)||
''||chr(10)||
'       x.status,'||chr(10)||
'      ';

s:=s||' decode(x.status_2,''''VALID'''',''''VALID'''','||chr(10)||
'                         ''''INVALID'''',''''INVALID'''','||chr(10)||
'                         null,decode(x.source_status,''''VALID'''',''''VALID'''','||chr(10)||
'                                                     ''''INVALID'''',''''INVALID'''','||chr(10)||
'                                                     null,''''INVALID'''')) stat,'||chr(10)||
'''''<div onclick="showdetail(this,''''|| x.reportid ||'''')" style="cursor:hand;cursor';

s:=s||':pointer;text-decoration:underline;font-weight:bold;">show_detail</div>'''' detail'||chr(10)||
''||chr(10)||
'from('||chr(10)||
'select distinct a. reportid, '||chr(10)||
'       a.repname,'||chr(10)||
'       a.recordsource,'||chr(10)||
'       c.dbname,'||chr(10)||
'       d.mig_table_name,'||chr(10)||
'       d.status stat_tab,'||chr(10)||
'       e.mig_view_name,'||chr(10)||
'       e.status stat_view,'||chr(10)||
'       i.source_name,'||chr(10)||
'       i.source_type,'||chr(10)||
'       i.source_status,'||chr(10)||
'       i.status,'||chr(10)||
'       h.status status_2'||chr(10)||
''||chr(10)||
'       '||chr(10)||
'fro';

s:=s||'m ((((('||chr(10)||
''||chr(10)||
'       wwv_mig_acc_reports a LEFT JOIN wwv_mig_access c'||chr(10)||
'       on  a.dbid = c.dbid'||chr(10)||
'       and a.project_id = c.project_id'||chr(10)||
'       and a.security_group_id = c.security_group_id'||chr(10)||
'       and a.dbid = c.dbid )'||chr(10)||
''||chr(10)||
'      LEFT JOIN wwv_mig_rev_tables d'||chr(10)||
'       on UPPER(a.recordsource) = UPPER(d.orig_table_name)'||chr(10)||
'       and a.project_id = d.project_id'||chr(10)||
'       and a.dbid = d.dbid)'||chr(10)||
''||chr(10)||
'      LEFT JOIN wwv_mi';

s:=s||'g_rev_queries e'||chr(10)||
'       on UPPER(a.recordsource) = UPPER(e.orig_qry_name)'||chr(10)||
'       and a.project_id = e.project_id'||chr(10)||
'       and a.dbid = e.dbid)'||chr(10)||
'       '||chr(10)||
'     LEFT JOIN wwv_mig_rev_reports i'||chr(10)||
'       on a.project_id = i.project_id'||chr(10)||
'       and a.dbid = i.dbid'||chr(10)||
'       and a.reportid = i.reportid)'||chr(10)||
''||chr(10)||
'       LEFT JOIN sys.dba_objects h'||chr(10)||
'       on UPPER(h.object_name) = UPPER(i.source_name)'||chr(10)||
'       and h.owner = UPP';

s:=s||'ER(:P2_SCHEMA)'||chr(10)||
'       and h.owner = c.database_schema)'||chr(10)||
''||chr(10)||
''||chr(10)||
'where  a.project_id = :MW_PROJ_ID '||chr(10)||
'and    a.security_group_id = :flow_security_group_id'||chr(10)||
'--and    a.dbid = :P2_DBID'||chr(10)||
'and    (:P20_REPORT is null or instr(upper(a.repname),upper(:P20_REPORT))>0)'||chr(10)||
') x, (select wwv_flow_lang.system_message(''''F4400_INCLUDE_LABEL'''') inc from dual) t '';'||chr(10)||
''||chr(10)||
''||chr(10)||
'return q;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4402,
  p_name=> 'Informations récapitulatives d''état',
  p_region_name=>'',
  p_template=> 17268536952823952.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 31,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<script type="text/javascript"> '||chr(10)||
'function ToggleAll(e) '||chr(10)||
'{ '||chr(10)||
'  if (e.checked) '||chr(10)||
'  { '||chr(10)||
'    CheckAll(); '||chr(10)||
'  } '||chr(10)||
'  else '||chr(10)||
'  { '||chr(10)||
'    ClearAll(); '||chr(10)||
'  } '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function Check(e) '||chr(10)||
'{ '||chr(10)||
'  e.checked = true; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function Clear(e)'||chr(10)||
'{ '||chr(10)||
'  e.checked = false; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function CheckAll() '||chr(10)||
'{ '||chr(10)||
'  var ml = document.wwv_flow; '||chr(10)||
'  var len = ml.elements.length; '||chr(10)||
'  for (var i = 0; i < len; i++) '||chr(10)||
'  { '||chr(10)||
'    var e = ml.elements[i]; '||chr(10)||
'    if (e.name == "f01") '||chr(10)||
'    { '||chr(10)||
'      if (e.disabled == false)'||chr(10)||
'      {'||chr(10)||
'        Check(e); '||chr(10)||
'      }'||chr(10)||
'    } '||chr(10)||
'  } '||chr(10)||
'  ml.f01.checked = true; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'function ClearAll() '||chr(10)||
'{ '||chr(10)||
'  var ml = document.wwv_flow; '||chr(10)||
'  var len = ml.elements.length; '||chr(10)||
'  for (var i = 0; i < len; i++) '||chr(10)||
'  { '||chr(10)||
'    var e = ml.elements[i]; '||chr(10)||
'    if (e.name == "f01") '||chr(10)||
'    { '||chr(10)||
'      Clear(e); '||chr(10)||
'    } '||chr(10)||
'  } '||chr(10)||
'  ml.f01.checked = false; '||chr(10)||
'} '||chr(10)||
''||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
'var g_LastRowOpened = false;'||chr(10)||
'var g_LastDetailLabel = false;'||chr(10)||
'var g_ShowOnlyOne = false;'||chr(10)||
'var g_LastNewRowOpened = false;'||chr(10)||
''||chr(10)||
'function showdetail(t,i){'||chr(10)||
'	var l_TR = html_CascadeUpTill(t,''TR'');'||chr(10)||
'	var l_ThisTable = html_CascadeUpTill(t,''TABLE'');'||chr(10)||
'	if(t.innerHTML == ''hide_detail''){'||chr(10)||
'		html_GetElement(g_LastNewRowOpened).parentNode.removeChild(html_GetElement(g_LastNewRowOpened))'||chr(10)||
'		SetDetailLabel(g_LastDetailLabel);'||chr(10)||
'		g_LastDetailLabel = false;'||chr(10)||
'	  g_LastRowOpened = false;'||chr(10)||
'	  g_LastNewRowOpened = false;'||chr(10)||
'  }else{'||chr(10)||
'	  if(html_GetElement(g_LastNewRowOpened)){'||chr(10)||
'				html_GetElement(g_LastNewRowOpened).parentNode.removeChild(html_GetElement(g_LastNewRowOpened))'||chr(10)||
'  			SetDetailLabel(g_LastDetailLabel);'||chr(10)||
'  			l_ThisTable.normalize();'||chr(10)||
'	}'||chr(10)||
'	ShowHideDetailRow(t,l_ThisTable,l_TR,i);	'||chr(10)||
'	g_LastDetailLabel = t; // set the last show/hide_detail clicked'||chr(10)||
'	g_LastRowOpened = l_TR; // set the last row clicked	'||chr(10)||
'}'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function ShowHideDetailRow(pThis,pTable,pTR,pID){'||chr(10)||
'	var l_Detail = ''detail''+pID;'||chr(10)||
'	var l_NumCells = pTR.cells.length'||chr(10)||
'	if(pTR.rowIndex == pTable.rows.length-1 || pTable.rows[pTR.rowIndex+1].className != "detail"){'||chr(10)||
'		var myNewRow = pTable.insertRow(pTR.rowIndex+1);'||chr(10)||
'		g_LastNewRowOpened = myNewRow;'||chr(10)||
'		myNewRow.className = "detail";'||chr(10)||
'		var myNewCell = myNewRow.insertCell(0);'||chr(10)||
'		myNewCell.className = "t4data";'||chr(10)||
'		myNewCell.style.padding = 0;'||chr(10)||
'		myNewCell.colSpan=l_NumCells;'||chr(10)||
'                gURL = ''f?p=4400:44:&SESSION.::NO:RP:P44_REPORT_ID:''+ pID;'||chr(10)||
'		gReturn = ''<iframe src="''+gURL+''" style="border:none;width:100%;height:250px;" frameborder="0" framespacing="0" marginheight="0" marginwidth="0"></iframe>'';'||chr(10)||
'		myNewCell.innerHTML = gReturn;'||chr(10)||
'		html_ShowElement(l_Detail);'||chr(10)||
'	}else{'||chr(10)||
'		html_ToggleElement(pTable.rows[pTR.rowIndex+1]);'||chr(10)||
'	}'||chr(10)||
'	SetDetailLabel(pThis);'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function SetDetailLabel(pThis){'||chr(10)||
'	if(pThis.innerHTML == ''show_detail''){'||chr(10)||
'		pThis.innerHTML = ''hide_detail'''||chr(10)||
'	}else{'||chr(10)||
'		pThis.innerHTML = ''show_detail'''||chr(10)||
'	}'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
''||chr(10)||
'</script>',
  p_customized=> '0',
  p_query_row_template=> 27093615521778199.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_item=> 'P20_DISPLAY',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 241861511349857775.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> ' ',
  p_column_display_sequence=> 1,
  p_column_heading=> ' <input type="checkbox" name="f10" value=" " onclick="ToggleAll(this)">',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 242127617951758819.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'REPORTID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Report Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 241873405682176552.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'REPNAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Etat Access',
  p_column_link=>'f?p=&APP_ID.:21:&SESSION.:REP:&DEBUG.:21:P21_REPORT_NAME,P21_REPORT_ID,P21_OBJECT_TYPE:#REPNAME#,#REPORTID#,#SOURCE_TYPE#',
  p_column_linktext=>'#REPNAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 241873511952176552.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'RECORDSOURCE',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Record Source',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 241873632420176552.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'DBNAME',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Database',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 1699215506678727.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'SOURCE_TYPE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Source Type',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>6520502328008192 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 241873822518176553.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'SOURCE_NAME',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Nom de source',
  p_column_linktext=>'#SOURCE_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'YES',
  p_lov_null_text=> '&nbsp;',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3798913406034677.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'TESTING',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Type de source',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 241873905538176553.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Status',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 241917006271744435.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'STAT',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Statut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>237819027746437948 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 1599915344029624.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 241861315772857771.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'DETAIL',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Detail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 237426823237260339.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20.4402,
  p_button_sequence=> 50,
  p_button_plug_id => 34589212398545247+wwv_flow_api.g_id_offset,
  p_button_name    => 'SUBMIT',
  p_button_image_alt=> 'Appliquer les modifications',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>237428817612277676.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4402,
  p_branch_action=> 'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>237426823237260339.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 22-JUN-2006 04:37 by HILARY');
 
wwv_flow_api.create_page_branch(
  p_id=>21390114691090197.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4402,
  p_branch_action=> 'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 03-FEB-2006 09:22 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Pour rechercher une état, saisissez une interrogation sans distinction entre les majuscules et les minuscules pour le nom d''état et cliquez sur <b>OK</b>. Pour visualiser tous les états, laissez le champ vide et cliquez sur <b>OK</b>.';

wwv_flow_api.create_page_item(
  p_id=>20550200711258374.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4402,
  p_name=>'P20_REPORT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 34589212398545247.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Etat',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le nombre d''états à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>20551214909262464.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4402,
  p_name=>'P20_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 34589212398545247.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&nbsp; Afficher',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(5888327993309845 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>20551821489264383.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4402,
  p_name=>'P20_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 34589212398545247.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>237278426663958553.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4402,
  p_name=>'P20_DBID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'DBID:',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>237418820972146155.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4402,
  p_name=>'P20_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
''||chr(10)||
'BEGIN'||chr(10)||
'    --'||chr(10)||
'    -- First, go through all of the elements (in the 2nd array)'||chr(10)||
'    -- and set them to exclude'||chr(10)||
'    --'||chr(10)||
'    forall i in 1..htmldb_application.g_f02.count'||chr(10)||
'        update wwv_mig_rev_reports '||chr(10)||
'           set status = ''EXCLUDE'''||chr(10)||
'         where reportid = htmldb_application.g_f02(i)'||chr(10)||
'           and status <> ''EXCLUDE'''||chr(10)||
'           and project_id = :MW_PROJ_ID'||chr(10)||
'        --   and dbid = :P2';

p:=p||'_DBID'||chr(10)||
'           and security_group_id = :flow_security_group_id;        '||chr(10)||
''||chr(10)||
'    --'||chr(10)||
'    -- Then, go through the elements of the first array and update them'||chr(10)||
'    -- to include'||chr(10)||
'    --'||chr(10)||
'    forall i in 1..htmldb_application.g_f01.count'||chr(10)||
'        update wwv_mig_rev_reports '||chr(10)||
'           set status = ''INCLUDE'''||chr(10)||
'         where reportid = htmldb_application.g_f01(i)'||chr(10)||
'           and project_id = :MW_PROJ_ID'||chr(10)||
'       ';

p:=p||'--    and dbid = :P2_DBID'||chr(10)||
'           and security_group_id = :flow_security_group_id;        '||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 237380717940126375.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20.4402,
  p_process_sequence=> 22,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set report object status in wwv_mig_rev_reports',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>237426823237260339.4402 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'DECLARE'||chr(10)||
'  l_status   varchar2(32767);'||chr(10)||
'  l_ans      number;'||chr(10)||
'  l_length   number;'||chr(10)||
'  l_syntax   varchar2(32767);'||chr(10)||
'BEGIN'||chr(10)||
''||chr(10)||
'  -- '||chr(10)||
'  -- Get list of SQL Queries and associated reportids'||chr(10)||
'  --'||chr(10)||
'  for c1 in'||chr(10)||
'  ('||chr(10)||
'  	select source_syntax, reportid  from wwv_mig_rev_reports'||chr(10)||
'        where source_type = ''SQL Query'''||chr(10)||
'  	and project_id = :MW_PROJ_ID'||chr(10)||
'  	and dbid = :P2_DBID'||chr(10)||
'  	and security_group_id = :flow_security_group';

p:=p||'_id'||chr(10)||
'  	and owner = :P2_SCHEMA  '||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    if (c1.source_syntax is not null) then'||chr(10)||
''||chr(10)||
'       -- Remove trailing semi-colon from syntax'||chr(10)||
'       l_length := LENGTH(c1.source_syntax);     '||chr(10)||
'       l_ans := INSTR(c1.source_syntax,chr(59),l_length -1,1);'||chr(10)||
'       if l_ans <> 0 then'||chr(10)||
'          l_syntax := SUBSTR(c1.source_syntax,0,l_length -1);'||chr(10)||
'       else'||chr(10)||
'          l_syntax := c1.source_syntax;'||chr(10)||
'       end ';

p:=p||'if; '||chr(10)||
''||chr(10)||
'       l_status := wwv_render_report3.is_valid_query('||chr(10)||
'                       p_plug_source => l_syntax,'||chr(10)||
'                       p_plug_source_type => ''SQL_QUERY'','||chr(10)||
'                       p_owner => :P2_SCHEMA);'||chr(10)||
''||chr(10)||
''||chr(10)||
'       if length(l_status) is null then'||chr(10)||
' '||chr(10)||
'          -- Save syntax'||chr(10)||
'          update wwv_mig_rev_reports'||chr(10)||
'          set source_syntax = l_syntax'||chr(10)||
'          where reportid = c1.reportid'||chr(10)||
' ';

p:=p||'         and project_id = :MW_PROJ_ID'||chr(10)||
'          and security_group_id = :flow_security_group_id'||chr(10)||
'          and dbid = :P2_DBID'||chr(10)||
'          and owner = :P2_SCHEMA;'||chr(10)||
''||chr(10)||
'          -- Save status of syntax     '||chr(10)||
'          update wwv_mig_rev_reports'||chr(10)||
'          set source_status = ''VALID'''||chr(10)||
'          where reportid = c1.reportid'||chr(10)||
'          and project_id = :MW_PROJ_ID'||chr(10)||
'          and security_group_id = :flow_securi';

p:=p||'ty_group_id'||chr(10)||
'          and dbid = :P2_DBID'||chr(10)||
'          and owner = :P2_SCHEMA;   '||chr(10)||
''||chr(10)||
'       end if;'||chr(10)||
''||chr(10)||
'    end if;'||chr(10)||
'  end loop;   '||chr(10)||
''||chr(10)||
'END;';

wwv_flow_api.create_page_process(
  p_id     => 22770413011432434.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20.4402,
  p_process_sequence=> 60,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Compile All Invalid SQL Queries',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'COMPILE_ALL',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 20.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_21.44
prompt  ...PAGE 21.4402: Détails du contrôle d'état
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_recreports.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 21.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Détails du contrôle d''état',
  p_step_title=> 'Etat',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162013',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>21.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 1573025490464828.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4402,
  p_plug_name=> 'Top Bar3',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_footer=> '<br />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'  q varchar2(4000);'||chr(10)||
'  v_whereclause varchar2(60);'||chr(10)||
'  l_dbid number := 0;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'if :P2_DBID <> 0 then'||chr(10)||
'  l_dbid := :P2_DBID;'||chr(10)||
'else'||chr(10)||
'  for c6 in ('||chr(10)||
'    select dbid from wwv_mig_access'||chr(10)||
'    where project_id = :MW_PROJ_ID'||chr(10)||
'    and security_group_id = :flow_security_group_id'||chr(10)||
'    and linkdbid is null )'||chr(10)||
'  loop'||chr(10)||
'   l_dbid := c6.dbid;'||chr(10)||
'  end loop;'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'if'||chr(10)||
'  :P21_DISPLAY = ''-All-'' then'||chr(10)||
'   v_whereclause ';

s:=s||':= NULL;'||chr(10)||
'else '||chr(10)||
'   v_whereclause := ''and   :P21_DISPLAY = controltype'';'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'  q :=  ''select controlid, '||chr(10)||
'       controlname, '||chr(10)||
'       controltype,'||chr(10)||
'       HTMLDB_ITEM.text_from_lov(controltype,''''CONTROL_TYPE'''') LOV_type, '||chr(10)||
'       visible, '||chr(10)||
'       controlsource, '||chr(10)||
'       defaultvalue, '||chr(10)||
'       rowsource, '||chr(10)||
'       rowsourcetype,'||chr(10)||
'       ctrlcaption'||chr(10)||
'from   wwv_mig_acc_rpts_controls'||chr(10)||
'where  project_id = :M';

s:=s||'W_PROJ_ID'||chr(10)||
'and    security_group_id = :flow_security_group_id'||chr(10)||
'and    reportid = :P21_REPORT_ID'||chr(10)||
'and    dbid = '';'||chr(10)||
''||chr(10)||
'q := q || l_dbid;'||chr(10)||
'  '||chr(10)||
'if v_whereclause is not null then'||chr(10)||
'   q:= q || v_whereclause;'||chr(10)||
'  end if;'||chr(10)||
'  '||chr(10)||
'return q;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4402,
  p_name=> 'Informations sur les contrôles &P21_REPORT_NAME.',
  p_region_name=>'',
  p_template=> 111817633927197957.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 32,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_01',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2232815048214355.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CONTROLID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Controlid',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2232929576214358.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'CONTROLNAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom de contrôle',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2253107682505574.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'CONTROLTYPE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Type',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>2256220196537491 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 11709420524033908.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'LOV_TYPE',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Lov Type',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2233123113214358.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'VISIBLE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Visible',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>2268411818705410 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2233218849214358.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'CONTROLSOURCE',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Source de contrôle',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2233332369214358.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'DEFAULTVALUE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Valeur par défaut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2233429976214359.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'ROWSOURCE',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Source de ligne',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2233510032214359.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'ROWSOURCETYPE',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Type de source de ligne',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 11709525513033916.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 2231316256176864.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'CTRLCAPTION',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Légende',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'wwv_flow_sw_page_calls.do_compile(:P21_VIEW_NAME,:P2_SCHEMA,''VIEW'');';

wwv_flow_api.create_page_plug (
  p_id=> 2729028248428692.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4402,
  p_plug_name=> 'Compile',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 52,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_04',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'NEVER',
  p_plug_display_when_condition => 'COMPILE',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select recordsource from wwv_mig_acc_reports'||chr(10)||
'where reportid = :P21_REPORT_ID'||chr(10)||
'and project_id = :MW_PROJ_ID'||chr(10)||
'and dbid = :P2_DBID'||chr(10)||
'and security_group_id = :flow_security_group_id';

wwv_flow_api.create_report_region (
  p_id=> 11393718236473948.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4402,
  p_name=> 'Interrogation Access',
  p_region_name=>'',
  p_template=> 23957836075509199.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 92,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P21_OBJECT_TYPE',
  p_display_when_cond2=> 'SQL Query',
  p_display_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 1,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Aucune donnée n''a été trouvée.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
 
-- maintain plug_column_width attribute for 2.2 and greater
begin
execute immediate 'begin wwv_flow_api.set_region_column_width (
  p_id=>11393718236473948.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_page_id=>21.4402,
  p_plug_column_width=>''class="fielddatasmall"''); end;';
exception when others then null;
end;
/
 
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 11393915422474363.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 11393718236473948.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'RECORDSOURCE',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 11409726388307521.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4402,
  p_plug_name=> 'Barre supérieure',
  p_region_name=>'',
  p_plug_template=> 107734213208087396.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20564325832379192.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>11412505011358130.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_branch_action=> 'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>11410601931309986.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 21-SEP-2006 09:39 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2161411801786038.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_name=>'P21_VIEW_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 1573025490464828.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select UPPER(source_name) '||chr(10)||
'from   wwv_mig_rev_reports'||chr(10)||
'where  project_id = :MW_PROJ_ID'||chr(10)||
'and    dbid = :P2_DBID'||chr(10)||
'and    security_group_id = :flow_security_group_id'||chr(10)||
'and    reportid = :P21_REPORT_ID',
  p_source_type=> 'QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2306029517363482.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_name=>'P21_OBJECT_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 1573025490464828.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2729720414435984.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_name=>'P21_OBJECT_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 1573025490464828.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2736619815492495.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_name=>'P21_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 1573025490464828.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schema',
  p_source=>'P2_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sélectionnez le type de contrôle d''état à afficher et cliquez sur <b>OK</b>.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>11396416747690749.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_name=>'P21_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 11409726388307521.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '-All-',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Afficher',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'CONTROL_TYPE',
  p_lov => '.'||to_char(2256220196537491 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>11410601931309986.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_name=>'P21_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 11409726388307521.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'OK',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>20565908994383743.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_name=>'P21_REPORT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 1573025490464828.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Nom de l''état';

wwv_flow_api.create_page_item(
  p_id=>20566516266385894.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_name=>'P21_REPORT_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 11409726388307521.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Etat :',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 4,
  p_rowspan => 1,
  p_label_alignment  => 'CENTER-CENTER',
  p_field_alignment  => 'CENTER-CENTER',
  p_field_template => 192650113649872658.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 2162128901800467.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'OBJ_NAME',
  p_computation_point=> 'AFTER_FOOTER',
  p_computation_type=> 'ITEM_VALUE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'P21_VIEW_NAME',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 2823829866621473.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'REP_ID',
  p_computation_point=> 'AFTER_HEADER',
  p_computation_type=> 'ITEM_VALUE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'P21_REPORT_ID',
  p_compute_when => 'CC',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 2828903603717936.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_computation_sequence => 10,
  p_computation_item=> 'OBJ_NAME',
  p_computation_point=> 'AFTER_HEADER',
  p_computation_type=> 'ITEM_VALUE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'P21_VIEW_NAME',
  p_compute_when => 'CC',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 2825018400665463.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4402,
  p_computation_sequence => 20,
  p_computation_item=> 'REP_NAME',
  p_computation_point=> 'AFTER_HEADER',
  p_computation_type=> 'ITEM_VALUE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'P21_REPORT_NAME',
  p_compute_when => 'CC',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 21.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_22.44
prompt  ...PAGE 22.4402: Table Oracle
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_rectables.htm';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 22.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Table Oracle',
  p_step_title=> 'Table Oracle',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162013',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>22.4402,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>22.4402,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'htp.p(''<span class="instructiontext">'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P22_NO_TABLE''));'||chr(10)||
'htp.p(''</span><br />'');'||chr(10)||
'end;'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 2866112570785318.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4402,
  p_plug_name=> 'Table Oracle introuvable',
  p_region_name=>'',
  p_plug_template=> 244065612129731419.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 100,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'FUNCTION_BODY',
  p_plug_display_when_condition => 'declare'||chr(10)||
'  l_count number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in'||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt from sys.dba_tables'||chr(10)||
'    where table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'    and owner = UPPER(:P2_SCHEMA)'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    l_count := c1.cnt;'||chr(10)||
'  end loop;'||chr(10)||
'   '||chr(10)||
'  if (l_count = 0) then'||chr(10)||
'    return true;'||chr(10)||
'  else'||chr(10)||
'    return false;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'htp.p(''<span class="instructiontext">'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(p_name=>''F4400_P22_OBJ_CREATED'',p0=>v(''P22_RESULT'')));'||chr(10)||
'htp.p(''</span><br />'');'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 2949402179182774.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4402,
  p_plug_name=> 'Résultats',
  p_region_name=>'',
  p_plug_template=> 161911336037559740.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 90,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'REQUEST_EQUALS_CONDITION',
  p_plug_display_when_condition => 'SUCCESS',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6474023072515541.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select c.column_name,'||chr(10)||
'       case when data_type = ''CHAR'' then'||chr(10)||
'              data_type||''(''||c.char_length||'')'''||chr(10)||
'            when data_type = ''VARCHAR'' then'||chr(10)||
'              data_type||''(''||c.char_length||'')'''||chr(10)||
'            when data_type = ''VARCHAR2'' then'||chr(10)||
'              data_type||''(''||c.char_length||'')'''||chr(10)||
'            when data_type = ''NCHAR'' then'||chr(10)||
'              data_type||''(''||c.char_length||'')'''||chr(10)||
'          ';

s:=s||'  when data_type = ''NUMBER'' then'||chr(10)||
'       case when c.data_precision is null then'||chr(10)||
'              ''NUMBER'''||chr(10)||
'       else '||chr(10)||
'            data_type||''(''||c.data_precision||'',''||c.data_SCALE||'')'''||chr(10)||
'       end'||chr(10)||
'       when data_type = ''NVARCHAR'' then'||chr(10)||
'          data_type||''(''||c.char_length||'')'''||chr(10)||
'       when data_type = ''NVARCHAR2'' then'||chr(10)||
'          data_type||''(''||c.char_length||'')'''||chr(10)||
'       else'||chr(10)||
'          data_type'||chr(10)||
' ';

s:=s||'      end data_type,'||chr(10)||
'       decode(nullable, ''Y'','||chr(10)||
'              ''<img src="#IMAGE_PREFIX#check_small_black.gif" '||chr(10)||
'              alt="''||wwv_flow_lang.system_message(''F4000.YES'')||''"/>'','||chr(10)||
'              null) nullable,'||chr(10)||
'       c.DATA_DEFAULT,'||chr(10)||
'       sub.column_position pk	   '||chr(10)||
'  from sys.dba_tab_Columns c,'||chr(10)||
' (  select column_name,column_position from sys.dba_ind_columns'||chr(10)||
'    where (index_owner,index_name)';

s:=s||' = '||chr(10)||
'   (select owner,index_name from sys.dba_constraints'||chr(10)||
'    where owner = UPPER(:P2_SCHEMA)'||chr(10)||
'    and  table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'	and  constraint_type = ''P'')) sub'||chr(10)||
' where c.column_name = sub.column_name(+)'||chr(10)||
'   and  c.owner      = UPPER(:P2_SCHEMA)'||chr(10)||
'  and  c.table_name =  UPPER(:P22_TABLE_NAME) '||chr(10)||
'   and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_';

s:=s||'GROUP_ID and schema = c.owner)  '||chr(10)||
'order by sub.column_position,column_id ';

wwv_flow_api.create_report_region (
  p_id=> 6483321553701524.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4402,
  p_name=> 'Informations de colonne',
  p_region_name=>'',
  p_template=> 5096822001046010.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 120,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'declare'||chr(10)||
'  l_count number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in'||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt from sys.dba_tables'||chr(10)||
'    where table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'    and owner = UPPER(:P2_SCHEMA)'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    l_count := c1.cnt;'||chr(10)||
'  end loop;'||chr(10)||
'   '||chr(10)||
'  if (l_count = 0) then'||chr(10)||
'    return false;'||chr(10)||
'  else'||chr(10)||
'    return true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_display_condition_type=> 'FUNCTION_BODY',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 16025715508464036.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1:2',
  p_query_num_rows_type=> 'ROWS_X_TO_Y',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6490207139706859.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6483321553701524.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom de colonne',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6490317371706863.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6483321553701524.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_TYPE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Type de données',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6490405197706863.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6483321553701524.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'NULLABLE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Nullable',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6490529938706864.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6483321553701524.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_DEFAULT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Données par défaut',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 6490631785706864.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 6483321553701524.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PK',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Clé primaire',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'195741723445523826';

wwv_flow_api.create_page_plug (
  p_id=> 195743020805532567.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4402,
  p_plug_name=> 'Tâches',
  p_region_name=>'',
  p_plug_template=> 35485909554264791.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_05',
  p_plug_source=> s,
  p_plug_source_type=> 195741723445523826 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 778744506824371067.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4402,
  p_plug_name=> 'Informations de table',
  p_region_name=>'',
  p_plug_template=> 5096822001046010.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT_ESCAPE_SC',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign = "top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'FUNCTION_BODY',
  p_plug_display_when_condition => 'declare'||chr(10)||
'  l_count number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in'||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt from sys.dba_tables'||chr(10)||
'    where table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'    and owner = UPPER(:P2_SCHEMA)'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    l_count := c1.cnt;'||chr(10)||
'  end loop;'||chr(10)||
'   '||chr(10)||
'  if (l_count = 0) then'||chr(10)||
'    return false;'||chr(10)||
'  else'||chr(10)||
'    return true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'htp.p(''<span class="instructiontext">'');'||chr(10)||
'htp.p(wwv_flow_lang.system_message(''F4400_P22_TABLE_INFO''));'||chr(10)||
'htp.p(''</span><br />'');'||chr(10)||
'end;'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 778859132597057849.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4402,
  p_plug_name=> 'Table Oracle',
  p_region_name=>'',
  p_plug_template=> 86904609451444726.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'FUNCTION_BODY',
  p_plug_display_when_condition => 'declare'||chr(10)||
'  l_count number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in'||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt from sys.dba_tables'||chr(10)||
'    where table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'    and owner = UPPER(:P2_SCHEMA)'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    l_count := c1.cnt;'||chr(10)||
'  end loop;'||chr(10)||
'   '||chr(10)||
'  if (l_count = 0) then'||chr(10)||
'    return false;'||chr(10)||
'  else'||chr(10)||
'    return true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>11293007471504027.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_branch_action=> 'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>778730203050057515.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_branch_action=> 'f?p=&APP_ID.:9:&SESSION.&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>778942326539155031.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_branch_action=> 'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>779074027718878503.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_branch_action=> 'f?p=&APP_ID.:23:&SESSION.::&DEBUG.::P23_SCHEMA:&P22_TABLE_OWNER.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>779015316019062755.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 11,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 21-FEB-2006 09:37 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>966424087868930.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_OBJECT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select object_id'||chr(10)||
'from   sys.dba_objects'||chr(10)||
'where  object_name = :P22_TABLE_NAME'||chr(10)||
'and    object_type = ''TABLE'''||chr(10)||
'and    owner = :P2_SCHEMA'||chr(10)||
'   and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner);',
  p_source_type=> 'QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2966613934384824.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_RESULT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 2949402179182774.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Nom de la table.';

wwv_flow_api.create_page_item(
  p_id=>6479911354616260.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 4,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de table :',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>11273420711026100.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select database_schema from wwv_mig_access'||chr(10)||
'where project_id = :MW_PROJ_ID',
  p_source_type=> 'QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Nom du tablespace.';

wwv_flow_api.create_page_item(
  p_id=>778730010050057514.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_TABLESPACE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Tablespace :',
  p_source=>'select tablespace_name '||chr(10)||
'from   sys.dba_tables'||chr(10)||
'where  owner = UPPER(:P2_SCHEMA)'||chr(10)||
'   and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner)',
  p_source_type=> 'QUERY',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Nombre de lignes de données dans la table.';

wwv_flow_api.create_page_item(
  p_id=>778736703389247036.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_NUMROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nombre de lignes :',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 20,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Statut de la table.';

wwv_flow_api.create_page_item(
  p_id=>778739332095302643.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_TABLE_STATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Statut :',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_named_lov=> 'OBJECT STATUS',
  p_lov => '.'||to_char(237819027746437948 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'Y',
  p_cSize=> 20,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold" ',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 2,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>778741108808314897.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_TABLE_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Table Owner',
  p_source=>'P2_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT-CENTER',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>778751628996803320.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_PK_COLUMN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Colonne de clé primaire :',
  p_source=>'wwv_flow_wizard_api.get_pk (   '||chr(10)||
'    p_table_owner  => :P2_SCHEMA,'||chr(10)||
'    p_table_name   => :P22_TABLE_NAME'||chr(10)||
'    );',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov => 'select htf.escape_sc(column_name) d, column_name v'||chr(10)||
'from sys.dba_tab_columns a'||chr(10)||
'where owner = :P22_SCHEMA'||chr(10)||
'and table_name = :P22_TABLE_NAME'||chr(10)||
'and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner)'||chr(10)||
'order by column_id',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>778757808789863652.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_PK_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 35,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de clé primaire :',
  p_source=>'select decode(a.constraint_name, '||chr(10)||
'       a.constraint_name, '||chr(10)||
'       a.constraint_name , null) constraint_name '||chr(10)||
'from   sys.dba_constraints a  '||chr(10)||
'where  a.constraint_type = ''P'''||chr(10)||
'and    UPPER(a.table_name) = :P22_TABLE_NAME'||chr(10)||
'and    owner = :P2_SCHEMA'||chr(10)||
'and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner)',
  p_source_type=> 'QUERY',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>778884818884702437.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4402,
  p_name=>'P22_TEMP_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 778744506824371067.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Temporary Table',
  p_source=>'select decode(temporary, ''Y'','||chr(10)||
'              ''<img src="#IMAGE_PREFIX#check_small_black.gif" '||chr(10)||
'              alt="''||wwv_flow_lang.system_message(''F4000.YES'')||''"/>'','||chr(10)||
'              ''No'') temporary'||chr(10)||
'from   all_tables'||chr(10)||
'where  table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'and    owner = UPPER(:P2_SCHEMA)',
  p_source_type=> 'QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
''||chr(10)||
'l_constraint varchar2(30);'||chr(10)||
'l_constraint_2 varchar2(30);'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'for c1 in ('||chr(10)||
'            select constraint_type from sys.dba_constraints '||chr(10)||
'            where table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'            and constraint_type = ''P'''||chr(10)||
'            and owner = UPPER(:P2_SCHEMA)'||chr(10)||
'            and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and ';

p:=p||'schema = owner)'||chr(10)||
')'||chr(10)||
''||chr(10)||
'loop'||chr(10)||
'  l_constraint := c1.constraint_type;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'if (l_constraint is null) then'||chr(10)||
'   :P22_TABLE_STATUS := ''Invalid'';'||chr(10)||
'else'||chr(10)||
''||chr(10)||
'for c2 in ('||chr(10)||
'     select htmldb_item.text_from_lov(status,''OBJECT STATUS'') stat'||chr(10)||
'     from    sys.dba_objects'||chr(10)||
'     where object_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'     and owner = UPPER(:P2_SCHEMA)'||chr(10)||
'     and exists (select null from wwv_flow_company_schemas where';

p:=p||' security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner)'||chr(10)||
''||chr(10)||
')'||chr(10)||
'loop'||chr(10)||
'  l_constraint_2 := c2.stat;'||chr(10)||
'end loop;'||chr(10)||
'  :P22_TABLE_STATUS := l_constraint_2;'||chr(10)||
''||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 20899424727056025.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 22.4402,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Set Status field',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'declare'||chr(10)||
'  l_count number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in'||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt from sys.dba_tables'||chr(10)||
'    where table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'    and owner = UPPER(:P2_SCHEMA)'||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    l_count := c1.cnt;'||chr(10)||
'  end loop;'||chr(10)||
'   '||chr(10)||
'  if (l_count = 0) then'||chr(10)||
'    return false;'||chr(10)||
'  else'||chr(10)||
'    return true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_process_when_type=>'FUNCTION_BODY',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':P22_NUMROWS :='||chr(10)||
'wwv_flow_f4000_util.countem('||chr(10)||
'  ''select count(1) from "''||:P2_SCHEMA||''"."''||:P22_TABLE_NAME||''"'','||chr(10)||
'    :P2_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 30811324646487196.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 22.4402,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Count rows',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'declare'||chr(10)||
'  l_count number := 0;'||chr(10)||
'begin'||chr(10)||
'  for c1 in'||chr(10)||
'  ('||chr(10)||
'    select count(*) cnt from sys.dba_tables'||chr(10)||
'    where table_name = UPPER(:P22_TABLE_NAME)'||chr(10)||
'    and owner = UPPER(:P2_SCHEMA)'||chr(10)||
'    and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner)'||chr(10)||
''||chr(10)||
'  )'||chr(10)||
'  loop'||chr(10)||
'    l_count := c1.cnt;'||chr(10)||
'  end loop;'||chr(10)||
'   '||chr(10)||
'  if (l_count = 0) then'||chr(10)||
'    return false;'||chr(10)||
'  else'||chr(10)||
'    return true;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_process_when_type=>'FUNCTION_BODY',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 22.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_23.44
prompt  ...PAGE 23.4402: Créer un index 
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_rectables.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 23.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Créer un index ',
  p_step_title=> 'Créer un index ',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 25821516221167914.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162013',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>23.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 779021918059110691.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4402,
  p_plug_name=> 'Créer un index ',
  p_region_name=>'',
  p_plug_template=> 145308009821552281.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> 'Sélectionnez le type d''index à créer sur cette table.<P />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 779035420324224890.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'5333829890130844';

wwv_flow_api.create_page_plug (
  p_id=> 779036610890241084.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4402,
  p_plug_name=> 'Progress Indicator',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 779101424545473712 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 779095611413346827.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 779021918059110691+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 779098304965354434.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 779021918059110691+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> 'Suivant &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>779160526509316373.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4402,
  p_branch_action=> 'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>779098304965354434.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 11,
  p_branch_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_branch_condition=> 'P23_IND_TYPE',
  p_branch_condition_text=>'N',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 21-FEB-2006 13:37 by HILARY');
 
wwv_flow_api.create_page_branch(
  p_id=>779228610868907947.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4402,
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>779098304965354434.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_branch_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_branch_condition=> 'P23_IND_TYPE',
  p_branch_condition_text=>'T',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 21-FEB-2006 15:15 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>779022712649118563.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4402,
  p_name=>'P23_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 779021918059110691.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schéma :',
  p_source=>'select database_schema'||chr(10)||
'from   wwv_mig_access'||chr(10)||
'where  project_id = :MW_PROJ_ID;',
  p_source_type=> 'QUERY',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>779024900791134080.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4402,
  p_name=>'P23_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 779021918059110691.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'P22_TABLE_NAME',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nom de table :',
  p_source=>'P22_TABLE_NAME',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Indiquez le type d''index à créer. Pour l''indexation des nombres et des dates VARCHAR sélectionnez Normal ; pour l''indexation des colonnes CLOB, sélectionnez Texte.';

wwv_flow_api.create_page_item(
  p_id=>779028124602159833.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4402,
  p_name=>'P23_IND_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 779021918059110691.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Type d''index :',
  p_source=>'N',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'CREATE INDEX TYPES',
  p_lov => '.'||to_char(779055021223322673 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 2,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 8299228930814357.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>779081923741915157.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4402,
  p_name=>'P23_DBID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 779021918059110691.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'DBID',
  p_source=>'P9_DBID',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 23.4402
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_24.44
prompt  ...PAGE 24.4402: Créer un index 
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEMIG/apm_rectables.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 24.4402,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Créer un index ',
  p_step_title=> 'Créer un index ',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 280691928866282085+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 25821516221167914.4402+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409162014',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>24.4402,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select c.index_name,'||chr(10)||
'       c.column_name, '||chr(10)||
'       c.column_position, '||chr(10)||
'       c.column_length, '||chr(10)||
'       c.descend,'||chr(10)||
'       decode(d.uniqueness, ''UNIQUE'',''UNIQUE'','||chr(10)||
'                            ''NONUNIQUE'',''NON-UNIQUE'') "Uniqueness" '||chr(10)||
'from   sys.dba_ind_columns c, sys.dba_indexes d'||chr(10)||
'where  c.table_name = :P24_TABLE_NAME'||chr(10)||
'and    c.table_owner = :P24_SCHEMA'||chr(10)||
'and    d.index_name = c.index_name'||chr(10)||
'and    d.owner ';

s:=s||'= c.table_owner'||chr(10)||
'   and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = d.owner)'||chr(10)||
'order  by c.index_name, c.column_position';

wwv_flow_api.create_report_region (
  p_id=> 7763426154934721.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4402,
  p_name=> 'Index de table',
  p_region_name=>'',
  p_template=> 23957836075509199.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 12080117446200458.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7764628232935353.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 7763426154934721.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'INDEX_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Nom d''index',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7764719342935354.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 7763426154934721.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Colonne',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7764824491935354.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 7763426154934721.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_POSITION',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Position',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7764911730935354.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 7763426154934721.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_LENGTH',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Longueur',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7765024877935354.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 7763426154934721.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'DESCEND',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Tri',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7765128688935354.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 7763426154934721.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'Uniqueness',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Unicité',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 200582404558661820.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4402,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4994007614932454 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 11695812357642734.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 779163604894426691.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4402,
  p_plug_name=> 'Ajouter un index',
  p_region_name=>'',
  p_plug_template=> 145308009821552281.4402+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'5333829890130844';

wwv_flow_api.create_page_plug (
  p_id=> 779164025326426697.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4402,
  p_plug_name=> 'Progress Indicator',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 779101424545473712 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select column_id, '||chr(10)||
'       COLUMN_NAME COLUMN_NAME1, '||chr(10)||
'       DATA_TYPE, '||chr(10)||
'       DATA_LENGTH, '||chr(10)||
'       DATA_PRECISION, '||chr(10)||
'       DATA_SCALE, '||chr(10)||
'       NULLABLE'||chr(10)||
''||chr(10)||
'from   sys.dba_tab_columns'||chr(10)||
''||chr(10)||
'where  owner =  UPPER(:P24_SCHEMA) '||chr(10)||
'and    table_name= UPPER(:P24_TABLE_NAME)'||chr(10)||
'and exists (select null from wwv_flow_company_schemas where security_group_id = :FLOW_SECURITY_GROUP_ID and schema = owner)'||chr(10)||
'order  by column';

s:=s||'_id';

wwv_flow_api.create_report_region (
  p_id=> 779216417224843576.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4402,
  p_name=> 'Colonnes de table',
  p_region_name=>'',
  p_template=> 23957836075509199.4402+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 12080117446200458.4402+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 779216711730843595.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 779216417224843576.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '<br />',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 779216826514843599.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 779216417224843576.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_NAME1',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Nom de colonne',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 779216916308843599.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 779216417224843576.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_TYPE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Type',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 779217001208843599.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 779216417224843576.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_LENGTH',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Longueur',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 779217108685843599.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 779216417224843576.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_PRECISION',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Précision',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 779217207818843599.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 779216417224843576.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_SCALE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Echelle',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 779217304480843599.4402 + wwv_flow_api.g_id_offset,
  p_region_id=> 779216417224843576.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'NULLABLE',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Null',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 779164224841426698.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 24.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 779163604894426691+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Annuler',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 779164405041426700.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 24.4402,
  p_button_sequence=> 30,
  p_button_plug_id => 779163604894426691+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> 'Suivant &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 779174823327485733.4402 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 24.4402,
  p_button_sequence=> 10,
  p_button_plug_id => 779163604894426691+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '< Précédent',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>71396322993596375.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4402,
  p_branch_action=> 'f?p=&APP_ID.:26:&SESSION.::&DEBUG.::P26_PREVIOUS,P26_INDEX_NAME:24,&P24_INDEX_NAME.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>779164405041426700.4402+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 23-FEB-2006 11:53 by HILARY');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>779164618759426703.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4402,
  p_name=>'P24_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 779163604894426691.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schéma :',
  p_source=>'select UPPER(database_schema)'||chr(10)||
'from   wwv_mig_access'||chr(10)||
'where  project_id = :MW_PROJ_ID;',
  p_source_type=> 'QUERY',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 17397530147569836.4402+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>779164809487426710.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4402,
  p_name=>'P24_DBID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 779163604894426691.4402+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'DBID',
  p_source=>'P9_DBID',
  p_source_type=> 'ITEM',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Saisissez le nom d''index';

wwv_flow_api.create_page_item(
  p_id=>779165000812426710.4402 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4402,
  p_name=>'P24_INDEX_NAME',
  p_data_type=> 'VA