set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4413 - APEX  - System Messages
--
-- Application Export:
--   Application:     4413
--   Name:            APEX  - System Messages
--   Date and Time:   08:04 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 1
--     Items:               0
--     Computations:        0
--     Validations:         0
--     Processes:           0
--     Regions:             1
--     Buttons:             0
--   Shared Components
--     Breadcrumbs:         0
--        Entries           0
--     Items:               0
--     Computations:        0
--     Processes:           0
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             0
--     Lists:               0
--     Shortcuts:           0
--     Themes:              0
--     Templates:
--        Page:             9
--        List:            14
--        Report:           7
--        Label:            5
--        Region:          21
--     Messages:        3,702
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4413;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4413);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4413);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4413,
  p_display_id=> 4413,
  p_owner => 'APEX_030200',
  p_name  => 'APEX  - System Messages',
  p_alias => 'A198390916085442658',
  p_page_view_logging => 'YES',
  p_default_page_template=> 91626406749381989.4413 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 91626529080381989.4413 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 91632832228382001.4413 + wwv_flow_api.g_id_offset,
  p_error_template    => 91626406749381989.4413 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4411:1:&SESSION.',
  p_flow_language     => 'fr',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => '',
  p_logout_url        => '',
  p_application_tab_set=> 1,
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(91645213681389498 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_rejoin_existing_sessions   => 'N',
  p_theme_id => 1,
  p_default_label_template => 91641225667382016.4413 + wwv_flow_api.g_id_offset,
  p_default_report_template => 91638400927382012.4413 + wwv_flow_api.g_id_offset,
  p_default_list_template => 91636711305382010.4413 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 91641814330382017.4413 + wwv_flow_api.g_id_offset,
  p_default_button_template => 91626823864381990.4413 + wwv_flow_api.g_id_offset,
  p_default_chart_template => 91631622717381999.4413 + wwv_flow_api.g_id_offset,
  p_default_form_template => 91630725782381998.4413 + wwv_flow_api.g_id_offset,
  p_default_wizard_template => 91632204784382001.4413 + wwv_flow_api.g_id_offset,
  p_default_tabform_template => 91632832228382001.4413 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>91632832228382001.4413 + wwv_flow_api.g_id_offset,
  p_default_menur_template => 91633105066382001.4413 + wwv_flow_api.g_id_offset,
  p_default_listr_template => 91627727983381992.4413 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518135839',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
null;
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_1.441
prompt  ...PAGE 1.4413: Messages
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 1.4413,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Messages',
  p_step_title=> 'Messages',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 91626406749381989.4413+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409161318',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<h1>Développement APEX</h1>'||chr(10)||
'<p>'||chr(10)||
'Cette application permet de gérer les messages système APEX. Cliquez sur Composants partagés, puis sur Messages.'||chr(10)||
'</p>';

wwv_flow_api.create_page_plug (
  p_id=> 91624704892377483.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4413,
  p_plug_name=> 'System Messages',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4413
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
prompt  ...page templates for application: 4413
--
--application/shared_components/user_interface/templates/page/login_fr
prompt  ......Page template 91625820476381987.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><br /></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO#</td>'||chr(10)||
'    <td align="right" valign="top"><br /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br /></td>'||chr(10)||
' ';

c3:=c3||'   <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">';

c3:=c3||'#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625820476381987.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Login.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0"',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_template_comment => '18');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_fr
prompt  ......Page template 91625930032381988.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src=';

c3:=c3||'"#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br />#REGION_POSITION_01#</td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadd';

c3:=c3||'ing="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625930032381988.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1Notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_fr
prompt  ......Page template 91626019499381988.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="right" class="t1topbarLeft"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table border="0" cellpadding="0" cellspacing="0" su';

c3:=c3||'mmary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign';

c3:=c3||'="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626019499381988.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_with_side_bar_fr
prompt  ......Page template 91626101050381989.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/';

c3:=c3||'top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td v';

c3:=c3||'align="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1Pag';

c3:=c3||'eBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626101050381989.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs with Side Bar.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_with_side_bar_fr
prompt  ......Page template 91626232237381989.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/t';

c3:=c3||'heme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table';

c3:=c3||'></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="t';

c3:=c3||'op" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626232237381989.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs with Side Bar.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t2notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_with_side_bar_fr
prompt  ......Page template 91626321000381989.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class';

c3:=c3||'="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REG';

c3:=c3||'ION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03';

c3:=c3||'#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626321000381989.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs with Side Bar.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_fr
prompt  ......Page template 91626406749381989.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50';

c3:=c3||'%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><br /></td>'||chr(10)||
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody">';

c3:=c3||'<div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626406749381989.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
''||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comment => '12');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/printer_friendly_fr
prompt  ......Page template 91626529080381989.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top">'||chr(10)||
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>'||chr(10)||
'#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626529080381989.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Printer Friendly.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_template_comment => '3');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/popup_fr
prompt  ......Page template 91626623032381989.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top"><div class="t1messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_01##REGION_POSITION_02##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626623032381989.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Popup.fr',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
--application/shared_components/user_interface/templates/button/button
prompt  ......Button Template 91626823864381990.4413
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>'||chr(10)||
'</tr';

t:=t||'>'||chr(10)||
'</table>';

wwv_flow_api.create_button_templates (
  p_id=>91626823864381990.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button',
  p_translate_this_template => 'N',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_template_comment       => '');
end;
/
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/report_list
prompt  ......region template 91627404948381991.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr>'||chr(10)||
'<td valign="top"><img src="#';

t:=t||'IMAGE_PREFIX#themes/theme_1/report.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627404948381991.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Report List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627404948381991.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_list
prompt  ......region template 91627727983381992.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr><td valign="top"><img src="#I';

t:=t||'MAGE_PREFIX#themes/theme_1/chart.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627727983381992.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627727983381992.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_title
prompt  ......region template 91628005149381992.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1RegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628005149381992.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 11,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628005149381992.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/hide_and_show_region
prompt  ......region template 91628313436381993.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1HideandShowRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#<a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif'',''#IMAG';

t:=t||'E_PREFIX#themes/theme_1/rollup_minus_dgray.gif'');" class="t1HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif" '||chr(10)||
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body"><div class="t1Hide" id="region#REGION_SEQU';

t:=t||'ENCE_ID#">#BODY#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628313436381993.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Hide and Show Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Gray Head, white body');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628313436381993.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_without_title
prompt  ......region template 91628622914381993.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td></tr>'||chr(10)||
'</table>'||chr(10)||
'#BODY#';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628622914381993.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628622914381993.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_buttons_and_titles
prompt  ......region template 91628912641381993.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table summary="" cellpadding="0" cellspacing="0" border="0" class="t1RegionwithoutButtonsandTitles" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
''||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628912641381993.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Buttons and Titles',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628912641381993.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_alternative_1
prompt  ......region template 91629226514381996.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629226514381996.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region, Alternative 1',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 10,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629226514381996.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/borderless_region
prompt  ......region template 91629526498381997.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BorderlessRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629526498381997.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Borderless Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content without a border.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629526498381997.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_with_title
prompt  ......region template 91629802954381997.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1RegionHeader">#TITLE#</td></tr>'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##COPY##EXPAND##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /';

t:=t||'></td></tr>'||chr(10)||
'</table>#BODY#'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629802954381997.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region with Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629802954381997.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region_alternative_1
prompt  ......region template 91630115446381997.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegionAlternative1" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="';

t:=t||'10" height="20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630115446381997.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region, Alternative 1',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630115446381997.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region
prompt  ......region template 91630411450381997.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegion" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="10" height="';

t:=t||'20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630411450381997.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tl_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'          <td bgcolor="#000000" height="1"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tr_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#FF0000" height="16">'||chr(10)||
'            <table border="0" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'              <tr>'||chr(10)||
'                <td align=middle valign="top">'||chr(10)||
'                  <div align="center">'||chr(10)||
'                     <font color="#ffffff" face="Arial, Helvetica, sans-serif" size="1">'||chr(10)||
'                      <b>#TITLE# </b></font></div>'||chr(10)||
'                </td>'||chr(10)||
'              </tr>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'   <tr>'||chr(10)||
'   <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'   <td valign="top" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="146" height="1" border="0" alt="" /><br />'||chr(10)||
'            <table border="0" cellpadding="1" cellspacing="0" width="146" summary="">'||chr(10)||
'              <tr>'||chr(10)||
'                <td colspan="2">'||chr(10)||
'                  <table border="0" cellpadding="2" cellspacing="0" width="124" summary="">'||chr(10)||
'                    <tr>'||chr(10)||
'                      <td>&nbsp;</td>'||chr(10)||
'                      <td valign="top" width="106">'||chr(10)||
'                        <P><FONT face="arial, helvetica" size="1">'||chr(10)||
'                            #BODY#'||chr(10)||
'                           </font>'||chr(10)||
'                        </P>'||chr(10)||
'                      </td>'||chr(10)||
'                    </tr>'||chr(10)||
'                  </table>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'          <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'      </table>'||chr(10)||
'      <table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#bl_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'          <td bgcolor="#ffffff" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#br_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#000000" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630411450381997.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/form_region
prompt  ......region template 91630725782381998.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1FormRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="400" alt="" /><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CH';

t:=t||'ANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630725782381998.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Form Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 8,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630725782381998.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region_alternative_1
prompt  ......region template 91631001900381998.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1NavigationRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631001900381998.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region, Alternative 1',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631001900381998.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region_with_icon
prompt  ......region template 91631304733381999.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table summary="" cellpadding="0" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td valign="top"><img src=';

t:=t||'"#IMAGE_PREFIX#themes/theme_1/wizard_icon.gif" alt=""/></td>'||chr(10)||
'<td width="100%" valign="top">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631304733381999.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region with Icon',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631304733381999.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_region
prompt  ......region template 91631622717381999.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ChartRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td';

t:=t||'>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631622717381999.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 30,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631622717381999.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/bracketed_region
prompt  ......region template 91631925531382001.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BracketedRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td class=';

t:=t||'"t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td rowspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/the';

t:=t||'me_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631925531382001.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Bracketed Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content with a bracket UI.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631925531382001.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region
prompt  ......region template 91632204784382001.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632204784382001.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632204784382001.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_100_width
prompt  ......region template 91632529189382001.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion100Width" width="100%" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632529189382001.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region 100% Width',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632529189382001.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region
prompt  ......region template 91632832228382001.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632832228382001.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632832228382001.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/breadcrumb_region
prompt  ......region template 91633105066382001.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1BreadcrumbRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633105066382001.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Breadcrumb Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633105066382001.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region
prompt  ......region template 91633419116382002.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1NavigationRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633419116382002.4413 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633419116382002.4413 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist
prompt  ......list template 91633715033382002.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# / alt=""></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t6:=t6||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif"  alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91633715033382002.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML List (Image) with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 21,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_menu_with_sublist
prompt  ......list template 91634003460382007.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t6:=t6||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634003460382007.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Menu with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_tree
prompt  ......list template 91634310642382007.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634310642382007.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Tree',
  p_theme_id  => 1,
  p_theme_class_id => 22,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/wizard_progress_list
prompt  ......list template 91634602833382007.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td><div class="t1current">#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t2:=t2||'<tr><td><div>#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634602833382007.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Wizard Progress List',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_list_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" class="t1WizardProgressList">',
  p_list_template_after_rows=>'<tr><td>&DONE.</td></tr>'||chr(10)||
'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_ordered_list
prompt  ......list template 91634920736382008.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634920736382008.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Ordered List',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_list_template_before_rows=>'<ol class="t1VerticalOrderedList">',
  p_list_template_after_rows=>'</ol>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/button_list
prompt  ......list template 91635207728382008.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left_hl.gif" alt="" /></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#" style="color:#FFFFFF;">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right_hl.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2:=t2||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left.gif" alt="" /></td>'||chr(10)||
'<td class="t1NC"><a href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635207728382008.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Button List',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_list_template_before_rows=>'<div class="t1ButtonList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_links_list
prompt  ......list template 91635520047382008.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1current">#TEXT#</a>';

t2:=t2||'<a href="#LINK#">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635520047382008.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Links List',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_list_template_before_rows=>'<div class="t1HorizontalLinksList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_images_list
prompt  ......list template 91635830396382009.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</td></tr>';

t2:=t2||'<tr><td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635830396382009.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Images List',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_list_template_before_rows=>'<table cellpadding="0" cellspacing="0" border="0" summary="0" class="t1VerticalImagesList">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_sidebar_list
prompt  ......list template 91636106164382009.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1navcurrent">#TEXT#</a>';

t2:=t2||'<a href="#LINK#" class="t1nav">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636106164382009.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Sidebar List',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_list_template_before_rows=>'<div class="t1VerticalSidebarList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_without_bullet
prompt  ......list template 91636400543382009.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636400543382009.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List without Bullet',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithoutBullet">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
prompt  ......list template 91636711305382010.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636711305382010.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List with Bullets',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/tabbed_navigation_list
prompt  ......list template 91637003772382010.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a class="t1current" href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637003772382010.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Tabbed Navigation List',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_list_template_before_rows=>'<ul class="t1TabbedNavigationList">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/hierarchical_expanded
prompt  ......list template 91637324450382010.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91637324450382010.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Hierarchical Expanded',
  p_theme_id  => 1,
  p_theme_class_id => 23,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_images_with_label_list
prompt  ......list template 91637614810382010.4413
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ><br />#TEXT#</td>';

t2:=t2||'<td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></a><br /><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637614810382010.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Images with Label List',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="t1HorizontalImageswithLabelList" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/one_column_unordered_list
prompt  ......report template 91637905071382010.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91637905071382010.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'One Column Unordered List',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><ul class="t1OneColumnUnorderedList">',
  p_row_template_after_rows =>'</ul><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'NOT_CONDITIONAL',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'NOT_CONDITIONAL',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91637905071382010.4413 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'OMIT');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard
prompt  ......report template 91638400927382012.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638400927382012.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91638400927382012.4413 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_alternating_row_colors
prompt  ......report template 91638924547382013.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t1data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="t1dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638924547382013.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard, Alternating Row Colors',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table border="0" cellpadding="0" cellspacing="0" summary="" class="t1standardalternatingrowcolors">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_ppr
prompt  ......report template 91639203883382013.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639203883382013.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard (PPR)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>'||chr(10)||
'<script language=JavaScript type=text/javascript>'||chr(10)||
'<!--'||chr(10)||
'init_htmlPPRReport(''#REGION_ID#'');'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'</htmldb:#REGION_ID#>'||chr(10)||
'</div>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639203883382013.4413 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/horizontal_border
prompt  ......report template 91639730548382014.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639730548382014.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Horizontal Border',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" border="0" class="t1HorizontalBorder" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639730548382014.4413 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/value_attribute_pairs
prompt  ......report template 91640211522382014.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<tr><th class="t1header">#COLUMN_HEADER#</th><td class="t1data">#COLUMN_VALUE#</td></tr>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640211522382014.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Value Attribute Pairs',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ValueAttributePairs">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>#PAGINATION#</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640211522382014.4413 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'<tr><td colspan="2" class="t1seperate"><hr /></td></tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/borderless
prompt  ......report template 91640708921382015.4413
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640708921382015.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Borderless',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table class="t1borderless" cellpadding="0" border="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640708921382015.4413 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/optional_with_help
prompt  ......label template 91641225667382016.4413
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641225667382016.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/no_label
prompt  ......label template 91641313897382017.4413
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641313897382017.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'No Label',
  p_template_body1=>'<span class="t1NoLabel">',
  p_template_body2=>'</span>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional
prompt  ......label template 91641421336382017.4413
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641421336382017.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><span class="t1Optional">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required_with_help
prompt  ......label template 91641529261382017.4413
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641529261382017.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><a class="t1RequiredwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required
prompt  ......label template 91641600810382017.4413
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641600810382017.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><span class="t1Required">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
prompt  ......template 91641730492382017.4413
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641730492382017.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Hierarchical Menu',
  p_before_first=>'<ul class="t1HierarchicalMenu">',
  p_current_page_option=>'<li class="t1current">#NAME#</li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'',
  p_after_last=>'</ul>',
  p_max_levels=>11,
  p_start_with_node=>'CHILD_MENU',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
prompt  ......template 91641814330382017.4413
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641814330382017.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Breadcrumb Menu',
  p_before_first=>'<div class="t1BreadcrumbMenu">',
  p_current_page_option=>'<span class="t1current">#NAME#</span>',
  p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>',
  p_menu_link_attributes=>'',
  p_between_levels=>'&nbsp;&gt;&nbsp;',
  p_after_last=>'</div>',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 91642503902382024.4413
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 91642503902382024.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif',
  p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'Dialogue de recherche',
  p_page_html_head=>'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">'||chr(10)||
'',
  p_page_body_attr=>'onload="first_field()" style="margin:0;"',
  p_before_field_text=>'<div class="t1PopupHead">',
  p_page_heading_text=>'',
  p_page_footer_text =>'',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'Rechercher',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'Fermer',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'Suivant >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< Précédent',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'450',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Ligne(s) #FIRST_ROW# - #LAST_ROW#</div>',
  p_result_rows_per_pg=>500,
  p_before_result_set=>'<div class="t1PopupBody">',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
--application/shared_components/user_interface/templates/calendar/small_calendar
prompt  ......template 91641910982382018.4413
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91641910982382018.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Small Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#DY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallCalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="1" summary="" class="t1SmallCalendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallWeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="1" summary="0" class="t1SmallWeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="1" summary="0" class="t1SmallDayCalendar">',
  p_daily_month_close_format => '</table></td></tr></table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar
prompt  ......template 91642102481382020.4413
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642102481382020.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1WeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="0" summary="0" class="t1DayCalendar">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar_alternative_1
prompt  ......template 91642303533382020.4413
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642303533382020.4413 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar, Alternative 1',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th valign="bottom" class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarAlternative1Holder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top" height="100" height="100">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarAlternative1Holder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1WeekCalendarAlternative1">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="2" summary="0" class="t1DayCalendarAlternative1">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_reference_id=> null);
end;
null;
 
end;
/

prompt  ...application themes
--
prompt  ...build options used by application 4413
--
 
begin
 
null;
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4413
--
prompt  ......Message master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Maître-détail';

wwv_flow_api.create_message (
  p_id=>195420115664151123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier %0';

wwv_flow_api.create_message (
  p_id=>195420207767151123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 détail';

wwv_flow_api.create_message (
  p_id=>195420330098151123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_DETAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_empty_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne pouvez pas modifier un script SQL vide.';

wwv_flow_api.create_message (
  p_id=>195420401382151123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_EMPTY_SCRIPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_greater_than_30k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne pouvez pas modifier un script de plus de 30 000 octets.';

wwv_flow_api.create_message (
  p_id=>195420503364151123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_GREATER_THAN_30K',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création de pages maître-détail avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195420619367151123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MASTER_DETAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_3_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trois pages maître-détail';

wwv_flow_api.create_message (
  p_id=>195420722953151124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_2_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deux pages maître-détail';

wwv_flow_api.create_message (
  p_id=>195420820084151124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table maître';

wwv_flow_api.create_message (
  p_id=>195420922798151124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne(s) d''affichage maître';

wwv_flow_api.create_message (
  p_id=>195421018837151124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table détail';

wwv_flow_api.create_message (
  p_id=>195421127457151124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne(s) d''affichage détail';

wwv_flow_api.create_message (
  p_id=>195421201362151124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Atteindre l''enregistrement maître par';

wwv_flow_api.create_message (
  p_id=>195421330917151124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_SORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_include_master_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inclure l''état maître ?';

wwv_flow_api.create_message (
  p_id=>195421411270151125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INCLUDE_MASTER_REPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_detail_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Présentation maître-détail';

wwv_flow_api.create_message (
  p_id=>195421509043151125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page maître-détail. %0';

wwv_flow_api.create_message (
  p_id=>195421610838151125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_MASTER_DETAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_sql_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valide';

wwv_flow_api.create_message (
  p_id=>195421706940151125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_SQL_VALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_code_compiled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le code a été compilé avec succès';

wwv_flow_api.create_message (
  p_id=>195421827552151125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_CODE_COMPILED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référence statique';

wwv_flow_api.create_message (
  p_id=>195421901678151125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référence dynamique';

wwv_flow_api.create_message (
  p_id=>195422000067151126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de l''analyse de l''interrogation SQL :'||chr(10)||
'<p>%0</p>'||chr(10)||
'<p>%1</p>'||chr(10)||
'Certaines interrogations ne peuvent être lancées que lorsque votre application est en cours d''exécution. Si la syntaxe de votre interrogation est correcte, vous pouvez enregistrer celle-ci sans validation (voir les options sous la source de l''interrogation).';

wwv_flow_api.create_message (
  p_id=>195422125510151126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''interrogation de graphique n''est pas valide : %0<br><br>'||chr(10)||
'Utilisez la syntaxe suivante :'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Texte accompagnant la barre</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>Colonne numérique définissant la taille de la barre</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195422221946151126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Graphique Flash';

wwv_flow_api.create_message (
  p_id=>195422314647151126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.FLASH_CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les composants de la page zéro sont partagés par toutes les pages d''une application.';

wwv_flow_api.create_message (
  p_id=>195422412505151126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ZERO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Builder';

wwv_flow_api.create_message (
  p_id=>195422509135151126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILDER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''accueil';

wwv_flow_api.create_message (
  p_id=>195422608322151127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message nav_app_builder_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Naviguer vers la page d''accueil d''Application Builder';

wwv_flow_api.create_message (
  p_id=>195422705184151127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAV_APP_BUILDER_HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_nav
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''accueil d''Application Express';

wwv_flow_api.create_message (
  p_id=>195422813219151127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_NAV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195422919064151127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page de graphique Flash avec les attributs ci-après. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195423028525151127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FLASH_CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Groupe de pages';

wwv_flow_api.create_message (
  p_id=>195423130632151127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_GROUP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Panneau';

wwv_flow_api.create_message (
  p_id=>195423225340151127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_sga_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la définition de la nouvelle cible de mémoire SGA. %0';

wwv_flow_api.create_message (
  p_id=>195423326802151128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_SGA_TARGET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_pga_agg_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la définition de la nouvelle cible composite de mémoire PGA. %0';

wwv_flow_api.create_message (
  p_id=>195423421476151128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_PGA_AGG_TARGET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voir tous les groupes de pages';

wwv_flow_api.create_message (
  p_id=>195423522034151128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE GROUPS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_types
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voir tous les types de page';

wwv_flow_api.create_message (
  p_id=>195423627491151128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE TYPES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_pages_of_this_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pages de vue de ce type';

wwv_flow_api.create_message (
  p_id=>195423725405151128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_PAGES_OF_THIS_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page 0';

wwv_flow_api.create_message (
  p_id=>195423805677151128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_ZERO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset_4000
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Réinitialiser';

wwv_flow_api.create_message (
  p_id=>195423913737151128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET_4000',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message blank
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vierge';

wwv_flow_api.create_message (
  p_id=>195424000257151129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BLANK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier le groupe de pages';

wwv_flow_api.create_message (
  p_id=>195424112577151129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT PAGE GROUP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - Mise en page';

wwv_flow_api.create_message (
  p_id=>195424221143151129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Votre demande est en cours de traitement. Veuillez patienter...';

wwv_flow_api.create_message (
  p_id=>195424308755151129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_pool
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pool partagé';

wwv_flow_api.create_message (
  p_id=>195424401913151129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED POOL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buffer_cache
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cache de tampon';

wwv_flow_api.create_message (
  p_id=>195424516589151129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUFFER CACHE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Autre';

wwv_flow_api.create_message (
  p_id=>195424614057151130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OTHER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message navigation_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de navigation';

wwv_flow_api.create_message (
  p_id=>195424719572151130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAVIGATION_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Historiques des accès';

wwv_flow_api.create_message (
  p_id=>195424806127151130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_MENUS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listes';

wwv_flow_api.create_message (
  p_id=>195424924720151130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gérer les groupes de page';

wwv_flow_api.create_message (
  p_id=>195425027661151130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE PAGE GROUPS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune liste utilisée.';

wwv_flow_api.create_message (
  p_id=>195425121189151130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun historique des accès utilisé.';

wwv_flow_api.create_message (
  p_id=>195425204443151131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_MENUS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p374_pos_5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pos.5';

wwv_flow_api.create_message (
  p_id=>195425318006151131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P374.POS.5',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reassign_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Réaffecter les pages';

wwv_flow_api.create_message (
  p_id=>195425430713151131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REASSIGN_PAGES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML statique';

wwv_flow_api.create_message (
  p_id=>195425528405151131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_HTML',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_must_be_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe de ce compte doit être modifié.';

wwv_flow_api.create_message (
  p_id=>195425607952151131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MUST_BE_CHANGED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Panneau dynamique';

wwv_flow_api.create_message (
  p_id=>195425704772151131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apex_wizard_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Panneau de navigation';

wwv_flow_api.create_message (
  p_id=>195425809182151131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEX_WIZARD_FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_htmldb_user_guide
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Builder User''s Guide';

wwv_flow_api.create_message (
  p_id=>195425901376151132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.HTMLDB_USER_GUIDE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 Day Developer';

wwv_flow_api.create_message (
  p_id=>195426024967151132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DEV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 Day DBA';

wwv_flow_api.create_message (
  p_id=>195426127349151132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DBA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_referential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référentiel';

wwv_flow_api.create_message (
  p_id=>195426212949151132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_REFERENTIAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message inactive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inactif';

wwv_flow_api.create_message (
  p_id=>195426320814151132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INACTIVE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1220_script_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Résultats de %0, exécution %1';

wwv_flow_api.create_message (
  p_id=>195426409585151132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1220_SCRIPT_RESULT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dml_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Panneau DML';

wwv_flow_api.create_message (
  p_id=>195426501686151133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DML_FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cet élément est requis pour le processus d''obtention de la valeur de la clé primaire suivante ou précédente.';

wwv_flow_api.create_message (
  p_id=>195426629510151133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce bouton est requis pour le processus d''obtention de la valeur de la clé primaire suivante ou précédente.';

wwv_flow_api.create_message (
  p_id=>195426710895151133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Obtenir la valeur de la clé primaire suivante ou précédente';

wwv_flow_api.create_message (
  p_id=>195426821757151133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_show_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher/Masquer les colonnes';

wwv_flow_api.create_message (
  p_id=>195426919616151133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_SHOW_COLS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_remove_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enlever';

wwv_flow_api.create_message (
  p_id=>195427031834151133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_REMOVE_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join_hint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cliquez ici pour sélectionner une colonne pour la jointure.';

wwv_flow_api.create_message (
  p_id=>195427108276151133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN_HINT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter le processus d''obtention de la valeur de la clé primaire suivante ou précédente.';

wwv_flow_api.create_message (
  p_id=>195427203943151134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_get_next_or_prev_pk_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''obtenir la valeur de la clé primaire suivante ou précédente. %0';

wwv_flow_api.create_message (
  p_id=>195427323221151134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.GET_NEXT_OR_PREV_PK_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_check_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vérifiez de nouveau la définition de votre processus. %0';

wwv_flow_api.create_message (
  p_id=>195427406820151134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.CHECK_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_stmt_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Instruction traitée.';

wwv_flow_api.create_message (
  p_id=>195427525935151134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.STMT_PROCESSED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Script de désinstallation';

wwv_flow_api.create_message (
  p_id=>195427604802151134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne';

wwv_flow_api.create_message (
  p_id=>195427705342151134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias';

wwv_flow_api.create_message (
  p_id=>195427816587151135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_ALIAS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Objet';

wwv_flow_api.create_message (
  p_id=>195427918702151135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OBJECT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Condition';

wwv_flow_api.create_message (
  p_id=>195428025606151135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_CONDITION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type de tri';

wwv_flow_api.create_message (
  p_id=>195428106115151135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ordre de tri';

wwv_flow_api.create_message (
  p_id=>195428200763151135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT_ORDER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_output
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher';

wwv_flow_api.create_message (
  p_id=>195428314997151135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OUTPUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction';

wwv_flow_api.create_message (
  p_id=>195428424924151136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_FUNCTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Grouper par';

wwv_flow_api.create_message (
  p_id=>195428511019151136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_GROUP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message file_too_big
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce fichier texte est trop volumineux pour être modifié. Vous devez d''abord le modifier sur votre machine locale, puis le télécharger de nouveau vers le serveur.';

wwv_flow_api.create_message (
  p_id=>195428627340151136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FILE_TOO_BIG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_total_sessions2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nombre total de sessions : %0';

wwv_flow_api.create_message (
  p_id=>195428704155151136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_TOTAL_SESSIONS2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_prefs_exists_for2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il existe %0 préférences pour les utilisateurs de %1.';

wwv_flow_api.create_message (
  p_id=>195428810922151136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_PREFS_EXISTS_FOR2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_to_create_tablespace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le tablespace actuellement. Réessayez ultérieurement.';

wwv_flow_api.create_message (
  p_id=>195428903349151136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_TO_CREATE_TABLESPACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation non valide, absence d''instruction SELECT';

wwv_flow_api.create_message (
  p_id=>195429012146151137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY_REQUIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jointure';

wwv_flow_api.create_message (
  p_id=>195429104295151137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vers';

wwv_flow_api.create_message (
  p_id=>195429203162151137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_TO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_max_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Un maximum de 60 colonnes peut être sélectionné.';

wwv_flow_api.create_message (
  p_id=>195429314454151137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_MAX_COLS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message application_x
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application %0';

wwv_flow_api.create_message (
  p_id=>195429407719151137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APPLICATION_X',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_executing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'En cours d''exécution';

wwv_flow_api.create_message (
  p_id=>195429531178151137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.EXECUTING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message clear_command
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Commande CLEAR';

wwv_flow_api.create_message (
  p_id=>195429622640151137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CLEAR_COMMAND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message find_tables
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rechercher des tables';

wwv_flow_api.create_message (
  p_id=>195429731445151138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FIND_TABLES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Etes-vous sûr de vouloir quitter cette page sans l''enregistrer ?';

wwv_flow_api.create_message (
  p_id=>195429816085151138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_SHORTCUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message download
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Télécharger en local';

wwv_flow_api.create_message (
  p_id=>195429932575151138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DOWNLOAD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_for_printing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vue pour impression';

wwv_flow_api.create_message (
  p_id=>195430022988151138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_FOR_PRINTING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_developer_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun privilège de développeur';

wwv_flow_api.create_message (
  p_id=>195430131685151138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DEVELOPER_PRIV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mot de passe valide';

wwv_flow_api.create_message (
  p_id=>195430200264151138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_VALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mot de passe expiré';

wwv_flow_api.create_message (
  p_id=>195430300098151139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_EXPIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_completed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Terminé';

wwv_flow_api.create_message (
  p_id=>195430419899151139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.COMPLETED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_in_progress
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'En cours d''exécution';

wwv_flow_api.create_message (
  p_id=>195430503778151139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.IN_PROGRESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 ligne.';

wwv_flow_api.create_message (
  p_id=>195430632020151139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 lignes.';

wwv_flow_api.create_message (
  p_id=>195430728110151139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROWS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_elapsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 secondes';

wwv_flow_api.create_message (
  p_id=>195430804037151139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ELAPSED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Développeur défini';

wwv_flow_api.create_message (
  p_id=>195430927758151140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SCHEME_DESC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentification normale, réussie';

wwv_flow_api.create_message (
  p_id=>195431005507151140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_SUCCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom utilisateur inconnu';

wwv_flow_api.create_message (
  p_id=>195431107386151140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compte verrouillé';

wwv_flow_api.create_message (
  p_id=>195431225522151140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_LOCKED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compte expiré';

wwv_flow_api.create_message (
  p_id=>195431312044151140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_EXPIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_incorrect
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mot de passe incorrect';

wwv_flow_api.create_message (
  p_id=>195431401217151140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_INCORRECT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_first_use
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Première utilisation du mot de passe';

wwv_flow_api.create_message (
  p_id=>195431501077151140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_FIRST_USE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_attempts_exceeded
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nombre maximal de tentatives de connexion dépassé';

wwv_flow_api.create_message (
  p_id=>195431602526151141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ATTEMPTS_EXCEEDED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_internal_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur interne inconnue';

wwv_flow_api.create_message (
  p_id=>195431711837151141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_INTERNAL_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administration du site';

wwv_flow_api.create_message (
  p_id=>195431808971151141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_LOGIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Connexion à l''espace de travail';

wwv_flow_api.create_message (
  p_id=>195431907615151141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE_LOGIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''administration de contrôle d''accès';

wwv_flow_api.create_message (
  p_id=>195432002495151141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_confirm_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer une table';

wwv_flow_api.create_message (
  p_id=>195432105627151141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CONFIRM_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administration des applications';

wwv_flow_api.create_message (
  p_id=>195432228821151142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_ADMIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès complet à tous ; liste de contrôle d''accès non utilisée.';

wwv_flow_api.create_message (
  p_id=>195432327051151142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès restreint. Seuls les utilisateurs définis dans la liste de contrôle d''accès sont autorisés.';

wwv_flow_api.create_message (
  p_id=>195432424244151142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès public en lecture seule. Privilèges de modification et d''administration contrôlés par la liste de contrôle d''accès.';

wwv_flow_api.create_message (
  p_id=>195432521715151142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès administratif uniquement.';

wwv_flow_api.create_message (
  p_id=>195432612282151142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Identifiez le mode de contrôle d''accès à cette application.';

wwv_flow_api.create_message (
  p_id=>195432720180151142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mode d''application';

wwv_flow_api.create_message (
  p_id=>195432829456151142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_set_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Définir le mode d''application';

wwv_flow_api.create_message (
  p_id=>195432915719151143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_SET_APP_MODE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dbaccount_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compte de base de données';

wwv_flow_api.create_message (
  p_id=>195433007402151143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DBACCOUNT_AUTH_SCHEME_DESC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste de contrôle d''accès (ACL)';

wwv_flow_api.create_message (
  p_id=>195433121596151143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ldap_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP';

wwv_flow_api.create_message (
  p_id=>195433205479151143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LDAP_AUTH_SCHEME_DESC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom utilisateur';

wwv_flow_api.create_message (
  p_id=>195433330499151143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USERNAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Privilège';

wwv_flow_api.create_message (
  p_id=>195433402830151143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_PRIV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administrateur';

wwv_flow_api.create_message (
  p_id=>195433528811151143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_last_changed_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dernière modification par';

wwv_flow_api.create_message (
  p_id=>195433621528151144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_find_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Saisissez des critères d''interrogation sans distinction entre les majuscules et les minuscules, puis cliquez sur <b>OK</b>.';

wwv_flow_api.create_message (
  p_id=>195433706719151144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_FIND_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_get_app_mode_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''obtenir le mode d''administration de l''application.';

wwv_flow_api.create_message (
  p_id=>195433831039151144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous n''êtes pas autorisé à effectuer cette opération.';

wwv_flow_api.create_message (
  p_id=>195433926854151144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_NO_PRIV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de traiter la demande de définition du mode d''application.';

wwv_flow_api.create_message (
  p_id=>195434027419151144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mode d''application défini.';

wwv_flow_api.create_message (
  p_id=>195434104854151144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_util_invalid_proxy_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le moteur d''impression n''a pas pu être atteint : l''URL indiquée est incorrecte ou une URL proxy doit être indiquée.';

wwv_flow_api.create_message (
  p_id=>195434225833151145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PRINT_UTIL.INVALID_PROXY_URL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_object_browser_only_n_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les %0 premières colonnes sont affichées.';

wwv_flow_api.create_message (
  p_id=>195434332655151145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé l''exécution du script suivant. Confirmez votre demande.';

wwv_flow_api.create_message (
  p_id=>195434412300151145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RUN_SCRIPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_script_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de script';

wwv_flow_api.create_message (
  p_id=>195434510244151145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_SCRIPT_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_num_stmts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nombre d''instructions';

wwv_flow_api.create_message (
  p_id=>195434627065151145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_NUM_STMTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voir les détails';

wwv_flow_api.create_message (
  p_id=>195434727101151145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_DETAILS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enlever';

wwv_flow_api.create_message (
  p_id=>195434810361151146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEINSTALL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_31_log_count
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entrées du journal de connexions à Access';

wwv_flow_api.create_message (
  p_id=>195434916486151146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_31_LOG_COUNT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ob_compile_errors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 erreurs.';

wwv_flow_api.create_message (
  p_id=>195435031118151146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OB_COMPILE_ERRORS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Palette de couleurs';

wwv_flow_api.create_message (
  p_id=>195435119515151146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_file_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter le script. %0';

wwv_flow_api.create_message (
  p_id=>195435213928151146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_FILE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans run_statement. %0';

wwv_flow_api.create_message (
  p_id=>195435317485151146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_STMT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql_arr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans run_sql_arr. %0';

wwv_flow_api.create_message (
  p_id=>195435414495151146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL_ARR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Succès';

wwv_flow_api.create_message (
  p_id=>195435514150151147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.SUCCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_fail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreurs';

wwv_flow_api.create_message (
  p_id=>195435601836151147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.FAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier tout';

wwv_flow_api.create_message (
  p_id=>195435713668151147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_ALL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_query_limit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''instruction SELECT ne peut pas être supérieure à 32 ko.';

wwv_flow_api.create_message (
  p_id=>195435818920151147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.QUERY_LIMIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message administator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administrateur d''espace de travail';

wwv_flow_api.create_message (
  p_id=>195435925122151147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADMINISTATOR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message developer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Développeur';

wwv_flow_api.create_message (
  p_id=>195436012394151147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEVELOPER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message end_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisateur final';

wwv_flow_api.create_message (
  p_id=>195436123108151148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'END_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_nosgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''ID de groupe de sécurité est Null.';

wwv_flow_api.create_message (
  p_id=>195436206107151148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NOSGID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_rows_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 lignes sélectionnées.';

wwv_flow_api.create_message (
  p_id=>195436307709151148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ROWS_SELECTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bienvenue';

wwv_flow_api.create_message (
  p_id=>195436410087151148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_existence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la vérification d''existence';

wwv_flow_api.create_message (
  p_id=>195436506452151148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.EXISTENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Substitutions d''application';

wwv_flow_api.create_message (
  p_id=>195436625925151148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Options de construction';

wwv_flow_api.create_message (
  p_id=>195436716264151149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation';

wwv_flow_api.create_message (
  p_id=>195436832404151149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Confirmation de l''installation';

wwv_flow_api.create_message (
  p_id=>195436924101151149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Succès de la post-installation';

wwv_flow_api.create_message (
  p_id=>195437012926151149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la post-installation';

wwv_flow_api.create_message (
  p_id=>195437130673151149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_license
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Licence';

wwv_flow_api.create_message (
  p_id=>195437205467151149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.LICENSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirm_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Confirmation de la désinstallation';

wwv_flow_api.create_message (
  p_id=>195437310221151149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRM_DEINSTALL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Succès de la désinstallation';

wwv_flow_api.create_message (
  p_id=>195437417108151150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2613_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mot de passe expiré';

wwv_flow_api.create_message (
  p_id=>195437523781151150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2613_EXPIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manual
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Manuel';

wwv_flow_api.create_message (
  p_id=>195437609772151150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANUAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_flow_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compte de base de données';

wwv_flow_api.create_message (
  p_id=>195437706340151150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_FLOW.DBACCOUNT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser les informations d''identification et de connexion du compte de base de données.';

wwv_flow_api.create_message (
  p_id=>195437820026151150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DBACCOUNT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser une table existante';

wwv_flow_api.create_message (
  p_id=>195437906597151150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer un modèle d''autorisation';

wwv_flow_api.create_message (
  p_id=>195438024260151150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_script_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 : Script introuvable.';

wwv_flow_api.create_message (
  p_id=>195438109724151151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.SCRIPT_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_nest_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 : Les scripts ne peuvent pas être imbriqués de plus de %0 niveaux.';

wwv_flow_api.create_message (
  p_id=>195438211053151151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_NEST_LEVEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_cannot_run_cmd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Commande %0 bloquée. Impossible de l''exécuter à partir de SQL Workshop.';

wwv_flow_api.create_message (
  p_id=>195438301127151151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CANNOT_RUN_CMD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_dbaccount_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cliquez pour remplir Fonction d''authentification avec -DBACCOUNT-'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195438428349151151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P802.DBACCOUNT_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_dbauth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser le nom utilisateur et le mot de passe du compte de base de données pour l''authentification.';

wwv_flow_api.create_message (
  p_id=>195438517157151151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_DBAUTH_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parsing_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schéma d''analyse';

wwv_flow_api.create_message (
  p_id=>195438631975151151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARSING_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser un modèle d''autorisation existant';

wwv_flow_api.create_message (
  p_id=>195438705327151152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_rpt_region_header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Identifiez les noms utilisateur correspondant à ce modèle d''authentification de l''application.';

wwv_flow_api.create_message (
  p_id=>195438814427151152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vérifiez le nom utilisateur et le mot de passe saisis dans le panneau de connexion par rapport aux comptes de base de données Oracle. Cette pratique est utile lorsque les utilisateurs de votre application ont des comptes dans la base de données.';

wwv_flow_api.create_message (
  p_id=>195438909121151152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15A',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compte verrouillé.';

wwv_flow_api.create_message (
  p_id=>195439012744151152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_LOCKED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unknown_authentication_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Une erreur d''authentification non identifiée s''est produite.';

wwv_flow_api.create_message (
  p_id=>195439131086151152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNKNOWN_AUTHENTICATION_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_before_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Avant corps';

wwv_flow_api.create_message (
  p_id=>195439203989151152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BEFORE_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_after_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Après corps';

wwv_flow_api.create_message (
  p_id=>195439329027151153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.AFTER_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_script_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 : La sortie du script a atteint la taille maximale autorisée. Modifiez le script pour générer moins de sortie ou contactez votre administrateur afin qu''il augmente la taille maximale des résultats de script.';

wwv_flow_api.create_message (
  p_id=>195439424065151153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_SCRIPT_OUTPUT_REACHED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_workspace_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 : La sortie du script a atteint la taille maximale autorisée des résultats d''espace de travail. Supprimez les résultats existants ou contactez votre administrateur pour qu''il augmente la taille maximale des résultats d''espace de travail.';

wwv_flow_api.create_message (
  p_id=>195439517595151153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_WORKSPACE_OUTPUT_REACHED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hr_account_unlocked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compte HR déverrouillé.';

wwv_flow_api.create_message (
  p_id=>195439613155151153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HR_ACCOUNT_UNLOCKED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Express 2 Day Plus Developer Guide.';

wwv_flow_api.create_message (
  p_id=>195439704206151153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD HTMLDB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day DBA.';

wwv_flow_api.create_message (
  p_id=>195439816003151153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DBA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Developer Guide.';

wwv_flow_api.create_message (
  p_id=>195439928688151153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DEV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus Java Developer Guide.';

wwv_flow_api.create_message (
  p_id=>195440027975151154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD JAVA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.';

wwv_flow_api.create_message (
  p_id=>195440120332151154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD NET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus PHP Developer.';

wwv_flow_api.create_message (
  p_id=>195440228711151154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD PHP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce document traite des tâches d''administration courantes au jour le jour.';

wwv_flow_api.create_message (
  p_id=>195440312231151154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DBA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce document explique comment tirer parti de l''environnement Oracle Database Express Edition.';

wwv_flow_api.create_message (
  p_id=>195440400799151154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DEV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce document fournit une série de tutoriels qui décrivent comment construire des applications Web centrées sur une base de données.';

wwv_flow_api.create_message (
  p_id=>195440507885151154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG HTMLDB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce document fournit un tutoriel qui vous explique comment télécharger et installer Apache et les pilotes Zend Core PHP et comment utiliser PHP pour vous connecter à Oracle Database XE puis pour développer une application simple qui accède aux données et les modifie.';

wwv_flow_api.create_message (
  p_id=>195440610014151155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG PHP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce document fournit un tutoriel qui vous explique comment utiliser Java et JDBC pour vous connecter à Oracle Database XE et comment développer une application Java simple qui accède aux données et les modifie.';

wwv_flow_api.create_message (
  p_id=>195440721653151155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG JAVA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce document décrit les fonctionnalités-clés d''Oracle Data Provider for .NET et d''Oracle Developer Tools for Visual Studio .NET. Il traite de l''installation et de la configuration, vous explique comment construire des applications de base au moyen d''Oracle Data Provider for .NET et d''Oracle Developer Tools for Visual Studio .NET et comment créer et utiliser les procédures stockées PL/SQL et .NET.';

wwv_flow_api.create_message (
  p_id=>195440826409151155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG NET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compte créé.';

wwv_flow_api.create_message (
  p_id=>195440911074151155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_invalid_context
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette procédure doit être appelée à partir d''une session d''application.';

wwv_flow_api.create_message (
  p_id=>195441029340151155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.INVALID_CONTEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_foreign
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Etranger';

wwv_flow_api.create_message (
  p_id=>195441113862151155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_FOREIGN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_requires_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce WSDL exige des informations d''authentification. Indiquez le nom utilisateur et le mot de passe ci-dessous.';

wwv_flow_api.create_message (
  p_id=>195441221079151155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_REQUIRES_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tentative d''enregistrement de l''élément %0 dans le statut de session au cours du traitement de l''affichage. Le niveau de protection de l''élément est "%1". Aucun total de contrôle n''a été transmis ou celui qui a été transmis conviendrait à un élément de niveau de protection "%2".';

wwv_flow_api.create_message (
  p_id=>195441330584151156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_SHOW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''élément n''a pas de protection.';

wwv_flow_api.create_message (
  p_id=>195441422720151156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.UNPROTECTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_public_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''élément peut être défini lorsqu''il est accompagné d''un total de contrôle de type "signet de niveau application".';

wwv_flow_api.create_message (
  p_id=>195441525338151156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PUBLIC_BOOKMARK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_private_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''élément peut être défini lorsqu''il est accompagné d''un total de contrôle de type "signet de niveau utilisateur".';

wwv_flow_api.create_message (
  p_id=>195441613525151156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PRIVATE_BOOKMARK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''élément peut être défini lorsqu''il est accompagné d''un total de contrôle de type "session".';

wwv_flow_api.create_message (
  p_id=>195441720761151156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SESSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_internal_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''élément ne peut pas être défini par la transmission d''arguments à l''application.';

wwv_flow_api.create_message (
  p_id=>195441822215151156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.INTERNAL_ONLY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page n''a pas de protection.';

wwv_flow_api.create_message (
  p_id=>195441904479151156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.UNPROTECTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_checksum_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page peut être demandée avec des arguments si un total de contrôle est transmis à la procédure d''affichage.';

wwv_flow_api.create_message (
  p_id=>195442010457151157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.CHECKSUM_REQUIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page ne peut être accédée que sans arguments.';

wwv_flow_api.create_message (
  p_id=>195442115617151157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.NO_ARGS_ALLOWED ',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_direct_branch_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page ne peut être accédée à partir d''une autre page qu''au moyen d''un branchement de type "Branchement sur une page".';

wwv_flow_api.create_message (
  p_id=>195442204466151157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.DIRECT_BRANCH_ONLY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun total de contrôle n''a été fourni au traitement de l''affichage d''une page exigeant un total de contrôle lorsqu''une ou plusieurs demandes, suppressions de cache ou valeurs d''argument sont transmises en tant que paramètres.';

wwv_flow_api.create_message (
  p_id=>195442303695151157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISSING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_mismatch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le total de contrôle calculé sur la demande, la suppression de cache, les noms d''argument et les valeur d''argument (%0) ne concorde pas avec le total de contrôle transmis à la procédure d''affichage (%1).';

wwv_flow_api.create_message (
  p_id=>195442421418151157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISMATCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Des arguments ont été transmis à une page qui n''accepte pas d''arguments (demande, suppression de cache, valeurs d''élément).';

wwv_flow_api.create_message (
  p_id=>195442514014151157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_ARGS_ALLOWED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_url_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette page ne peut pas être appelée via une URL ou au moyen de GET ou POST vers la procédure d''affichage. Elle doit être appelée à l''aide d''un branchement de type "Branchement sur une page".';

wwv_flow_api.create_message (
  p_id=>195442616821151158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_URL_ALLOWED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tentative d''enregistrement de l''élément %0 dans le statut de session lors du traitement de l''acceptation. L''élément a une protection de niveau "Interne uniquement" ou n''est pas un élément de panneau pouvant être envoyé.';

wwv_flow_api.create_message (
  p_id=>195442709325151158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_ACCEPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_no_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Aucun total de contrôle n''a été fourni)';

wwv_flow_api.create_message (
  p_id=>195442824819151158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.NO_CHECKSUM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_invalid_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur de date non valide. Vérifiez le format de date.';

wwv_flow_api.create_message (
  p_id=>195442924394151158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.INVALID_DATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_ui_def_hint_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Builder utilise les valeurs par défaut de l''interface utilisateur pour remplir les valeurs initiales des propriétés de région et d''élément, ce qui assure une cohérence entre les pages dans une ou plusieurs applications.';

wwv_flow_api.create_message (
  p_id=>195443010657151158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_UI_DEF_HINT_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ouvrir';

wwv_flow_api.create_message (
  p_id=>195443114555151158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_OPEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verrouillé';

wwv_flow_api.create_message (
  p_id=>195443201098151159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_LOCKED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expiré';

wwv_flow_api.create_message (
  p_id=>195443330476151159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired_and_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expiré et verrouillé';

wwv_flow_api.create_message (
  p_id=>195443407571151159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED_AND_LOCKED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voulez-vous effectuer cette action de suppression ?';

wwv_flow_api.create_message (
  p_id=>195443506654151159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE_MSG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Taille';

wwv_flow_api.create_message (
  p_id=>195443611516151159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIZE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message length
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Longueur';

wwv_flow_api.create_message (
  p_id=>195443716140151159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LENGTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message lines
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lignes';

wwv_flow_api.create_message (
  p_id=>195443828062151159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendrier';

wwv_flow_api.create_message (
  p_id=>195443914934151160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_easy_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendrier simple';

wwv_flow_api.create_message (
  p_id=>195444022556151160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_EASY_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cliquez sur le lien'||chr(10)||
''||chr(10)||
'%0 '||chr(10)||
''||chr(10)||
'pour terminer le processus d''approbation et recevoir vos informations d''identification et de connexion.';

wwv_flow_api.create_message (
  p_id=>195444107542151160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.EMAIL_CLICK_ON_LINK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_accepted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DELETE';

wwv_flow_api.create_message (
  p_id=>195444215159151161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.ACCEPTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''un panneau sur une page de référence de service Web avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195444321815151162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_web_service_ref
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référence de service Web, opération';

wwv_flow_api.create_message (
  p_id=>195444411467151162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WEB_SERVICE_REF',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eléments de panneau';

wwv_flow_api.create_message (
  p_id=>195444508531151162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_ITEMS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_output_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eléments de sortie';

wwv_flow_api.create_message (
  p_id=>195444601824151162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OUTPUT_ITEMS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_no_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune vue Oracle correspondant à l''interrogation Microsoft Access n''a été trouvée. La syntaxe de l''interrogation Microsoft Access a été chargée dans la fenêtre de modification. Modifiez-la pour créer une vue Oracle.';

wwv_flow_api.create_message (
  p_id=>195444714508151162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_NO_VIEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_view_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Une vue doit avoir le statut Valide pour pouvoir être utilisée au cours du processus de migration.';

wwv_flow_api.create_message (
  p_id=>195444820169151162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_VIEW_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message storage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Stockage :';

wwv_flow_api.create_message (
  p_id=>195444916771151163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STORAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message memory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mémoire :';

wwv_flow_api.create_message (
  p_id=>195445000918151163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MEMORY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_page_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisateurs :';

wwv_flow_api.create_message (
  p_id=>195445112429151163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_PAGE_USERS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sessions :';

wwv_flow_api.create_message (
  p_id=>195445204924151163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SESSIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message active
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Actif';

wwv_flow_api.create_message (
  p_id=>195445329437151163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACTIVE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p3_find_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Localiser le fichier généré par l''outil Exporter';

wwv_flow_api.create_message (
  p_id=>195445430398151163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P3_FIND_FILE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>1. Exporter les métadonnées Microsoft Access.</b><br />'||chr(10)||
'Exécutez l''outil Exporter for Microsoft Access et extrayez les métadonnées du fichier .mdb. Les fichiers de sortie de base de données (.xml) et d''application (.sql) sont créés.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195445520190151163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>2. Migrer la base de données Microsoft Access vers Oracle.</b><br />'||chr(10)||
'Exécutez Oracle Migration Workbench et chargez les métadonnées de base de données extraites à l''étape 1. Le schéma et les données sont migrés vers Oracle.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195445600961151164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>3. Créer un espace de travail Oracle Application Express.</b><br />'||chr(10)||
'Exécutez Oracle Application Express et créez un espace de travail. Associez cet espace au schéma créé à l''étape 2.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195445729259151164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>4. Créer un projet de migration.</b><br />'||chr(10)||
'Connectez-vous à l''espace de travail créé à l''étape 3 et exécutez Application Migration Workshop. Créez un projet de migration et chargez les métadonnées d''application extraites à l''étape 1.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195445814669151164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>5. Analyser l''application Microsoft Access.</b><br />'||chr(10)||
'A partir d''Application Migration Workshop, vérifiez les métadonnées de l''application Microsoft Access et ajustez-les. Affinez l''étendue de la migration et corrigez les objets non valides. '||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195445903435151164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP5',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>6. Générer l''application Oracle Application Express.</b><br />'||chr(10)||
'Créez soit une application basée sur des panneaux et des états valides, soit une application de maintenance basée sur des tables et des vues valides.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195446023473151164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP6',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>7. Personnaliser votre application Oracle Application Express.</b><br />'||chr(10)||
'Ouvrez votre application dans la partie Application Builder d''Oracle Application Express et personnalisez votre application migrée. Vous pouvez en modifier les attributs ou y ajouter de nouvelles pages.';

wwv_flow_api.create_message (
  p_id=>195446123616151164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP7',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message internal_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interne';

wwv_flow_api.create_message (
  p_id=>195446207543151165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERNAL_USERS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message database_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Base de données';

wwv_flow_api.create_message (
  p_id=>195446301186151165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DATABASE_USERS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_obj_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La création de "%0" a réussi.';

wwv_flow_api.create_message (
  p_id=>195446427573151165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_OBJ_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p10_queries_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez la colonne à l''extrême gauche pour sélectionner les interrogations à inclure dans la migration. '||chr(10)||
'<br><br>'||chr(10)||
'Pour qu''une interrogation soit incluse, son statut doit être Valide. Par défaut, toutes les interrogations ayant le statut Valide sont sélectionnées.'||chr(10)||
'<br><br>'||chr(10)||
'Si vous ne sélectionnez pas d''interrogation à inclure, tous les panneaux et états basés sur cette interrogation seront exclus ';

h:=h||'de la migration.'||chr(10)||
'<br><br>'||chr(10)||
'Cliquez sur le lien <b>Tenter de compiler les interrogations non valides</b> pour exécuter un processus global permettant de tenter de compiler toutes les interrogations.'||chr(10)||
'<br><br>'||chr(10)||
'Cliquez sur <b>Appliquer les modifications</b> pour enregistrer vos sélections et vos mises à jour.';

wwv_flow_api.create_message (
  p_id=>195446529180151165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P10_QUERIES_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p9_tables_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez la colonne à l''extrême gauche pour sélectionner les tables à inclure dans la migration.'||chr(10)||
'<br><br>'||chr(10)||
'Pour qu''une table soit incluse, son statut doit être Valide. Par défaut, toutes les tables ayant le statut Valide sont sélectionnées.'||chr(10)||
'<br><br>'||chr(10)||
'Si vous ne sélectionnez pas de table à inclure, tous les panneaux et états basés sur cette table sont exclus de la migration.'||chr(10)||
'<br><br>Cliquez sur <b>Ap';

h:=h||'pliquer les modifications</b> pour enregistrer vos sélections ou vos mises à jour.';

wwv_flow_api.create_message (
  p_id=>195446618971151165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P9_TABLES_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_table_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'S''il n''existe aucune clé primaire pour une table, cliquez sur le lien <b>Créer une clé primaire</b> pour en ajouter une. Toutes les tables doivent comporter une clé primaire pour être migrées.';

wwv_flow_api.create_message (
  p_id=>195446713232151166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_TABLE_INFO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p8_forms_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'1. Utilisez la colonne à l''extrême gauche pour sélectionner les panneaux à inclure dans la migration.'||chr(10)||
'<br /><br />'||chr(10)||
'Pour qu''un panneau soit inclus, le statut de sa source doit être Valide. Par défaut, tous les panneaux basés sur des objets de source valide sont sélectionnés.'||chr(10)||
'<br /><br />'||chr(10)||
'2. Cliquez sur le lien <b>Tenter de compiler les interrogations SQL non valides</b> pour exécuter un processus g';

h:=h||'lobal permettant de tenter de compiler toutes interrogations SQL non valides.'||chr(10)||
'<br /><br />'||chr(10)||
'3. Dans la colonne <b>Migrer vers</b>, sélectionnez le type d''objet Oracle Application Express vers lequel vous voulez migrer votre panneau Microsoft Access :  '||chr(10)||
'<li>Panneau (option par défaut)</li>'||chr(10)||
'<li>Panneau tabulaire</li>'||chr(10)||
'<li>Etat et panneau</li>'||chr(10)||
'<br><br>'||chr(10)||
'Ces options apparaissent pour les tables et les in';

h:=h||'terrogations valides.'||chr(10)||
'<br><br>'||chr(10)||
'4. Cliquez sur <b>Appliquer les modifications</b> pour enregistrer vos sélections et vos modifications. '||chr(10)||
'<p />'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195446803980151166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P8_FORMS_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p20_reports_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez la colonne à l''extrême gauche pour sélectionner les états à inclure dans la migration.'||chr(10)||
'<br><br>'||chr(10)||
'Pour qu''un état soit inclus, le statut de sa source doit être Valide. Par défaut, tous les états basés sur des objets de source valide sont sélectionnés.'||chr(10)||
'<br><br>'||chr(10)||
'Cliquez sur le lien <b>Tenter de compiler les interrogations SQL non valides</b> pour exécuter un processus global permettant de ten';

h:=h||'ter de compiler toutes interrogations SQL non valides.'||chr(10)||
'<br><br>'||chr(10)||
'Cliquez sur <b>Appliquer les modifications</b> pour enregistrer vos sélections et vos modifications.';

wwv_flow_api.create_message (
  p_id=>195446909251151166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P20_REPORTS_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_defs_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ces valeurs par défaut sont utilisées lors de la création de nouvelles applications.';

wwv_flow_api.create_message (
  p_id=>195447022060151166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_DEFS_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tentative d''enregistrement de l''élément %0 dans le statut de session lors du traitement de l''affichage. L''élément a une protection de niveau "Interne uniquement".';

wwv_flow_api.create_message (
  p_id=>195447105600151166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_SHOW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_parser_line_exceeds_32k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nombre de lignes du script dépasse 32 767 octets.';

wwv_flow_api.create_message (
  p_id=>195447208732151167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_PARSER.LINE_EXCEEDS_32K',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv_obj
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le schéma %0 ne dispose pas de privilège de sélection sur la table ou la vue %1.';

wwv_flow_api.create_message (
  p_id=>195447316730151167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV_OBJ',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_approved_account_req_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Votre demande d''espace de travail a été approuvée et les informations d''identification et de connexion ont été adressées à %0 par courrier électronique.';

wwv_flow_api.create_message (
  p_id=>195447412387151167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.APPROVED_ACCOUNT_REQ_DISPLAY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message archivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Archivage de journaux : Activé';

wwv_flow_api.create_message (
  p_id=>195447500304151167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ARCHIVELOG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message noarchivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Archivage de journaux : Désactivé';

wwv_flow_api.create_message (
  p_id=>195447607096151167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOARCHIVELOG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_search
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rechercher';

wwv_flow_api.create_message (
  p_id=>195447725602151167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SEARCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher le graphique par';

wwv_flow_api.create_message (
  p_id=>195447807971151167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_CHART_BY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_choose_a_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Choisir une colonne';

wwv_flow_api.create_message (
  p_id=>195447902613151168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHOOSE_A_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analysis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analyse de %0';

wwv_flow_api.create_message (
  p_id=>195448018096151168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYSIS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Graphique de %0';

wwv_flow_api.create_message (
  p_id=>195448131545151168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Panneau d''insertion';

wwv_flow_api.create_message (
  p_id=>195448225772151168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer un nouveau %0';

wwv_flow_api.create_message (
  p_id=>195448326929151168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Panneau de mise à jour';

wwv_flow_api.create_message (
  p_id=>195448413855151168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE_FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mettre à jour %0';

wwv_flow_api.create_message (
  p_id=>195448502829151169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 doit comporter une valeur.';

wwv_flow_api.create_message (
  p_id=>195448621380151169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.NOT_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_is_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 doit être numérique.';

wwv_flow_api.create_message (
  p_id=>195448707282151169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.IS_NUM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de succès';

wwv_flow_api.create_message (
  p_id=>195448827377151169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les données ont été insérées avec succès.';

wwv_flow_api.create_message (
  p_id=>195448900003151169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_SUCCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_another
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'En insérer un autre';

wwv_flow_api.create_message (
  p_id=>195449024355151169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ANOTHER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_view_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voir l''état';

wwv_flow_api.create_message (
  p_id=>195449117389151169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.VIEW_REPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Retour à la page d''accueil';

wwv_flow_api.create_message (
  p_id=>195449221299151170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Succès';

wwv_flow_api.create_message (
  p_id=>195449312744151170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_help_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette page affiche l''aide sur une page.';

wwv_flow_api.create_message (
  p_id=>195449429918151170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.HELP_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_prev_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Retour à la page précédente';

wwv_flow_api.create_message (
  p_id=>195449529212151170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_PREV_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Historique des accès';

wwv_flow_api.create_message (
  p_id=>195449603999151170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.MENU',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Insérer %0';

wwv_flow_api.create_message (
  p_id=>195449728982151170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''afficher l''état.';

wwv_flow_api.create_message (
  p_id=>195449810517151171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_csv_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Feuille de calcul';

wwv_flow_api.create_message (
  p_id=>195449928181151171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CSV_LINK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_clear_cache_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''effacer le cache.';

wwv_flow_api.create_message (
  p_id=>195450011111151171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CLEAR_CACHE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_reset_pagination_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de réinitialiser la pagination.';

wwv_flow_api.create_message (
  p_id=>195450115754151171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RESET_PAGINATION_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''insérer une ligne dans %0.';

wwv_flow_api.create_message (
  p_id=>195450201184151171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analyze
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analyser';

wwv_flow_api.create_message (
  p_id=>195450308939151171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYZE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_and_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Etat et modification';

wwv_flow_api.create_message (
  p_id=>195450412866151172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_AND_EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer un nouveau';

wwv_flow_api.create_message (
  p_id=>195450531972151172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_no_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La migration de la table associée Microsoft Access vers Oracle n''a pas réussi. Pour plus d''informations, consultez le fichier journal Oracle Migration Workbench.';

wwv_flow_api.create_message (
  p_id=>195450632376151172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_NO_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisateur de base de données %0 créé avec le tablespace par défaut %1 utilisant le fichier de données %2';

wwv_flow_api.create_message (
  p_id=>195450714410151172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_validate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pour valider la syntaxe de l''interrogation SQL, cliquez sur <b>Valider</b>. La syntaxe affichée est extraite de votre base de données Microsoft Access.'||chr(10)||
'<br><br>'||chr(10)||
'Assurez-vous que l''interrogation comporte une syntaxe Oracle valide. Seules les interrogations SQL dont le statut est Valide peuvent être incluses dans le processus de migration. ';

wwv_flow_api.create_message (
  p_id=>195450820661151172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_VALIDATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_menu_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''afficher l''historique des accès.';

wwv_flow_api.create_message (
  p_id=>195450921504151172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_MENU_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_display_region_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''afficher la région de page.';

wwv_flow_api.create_message (
  p_id=>195451028066151173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DISPLAY_REGION_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_ws_entire_response_doc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Document de réponses complet';

wwv_flow_api.create_message (
  p_id=>195451104173151173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_WS_ENTIRE_RESPONSE_DOC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_invalid_wsdl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''URL indiquée n''a pas renvoyé de document WSDL valide.';

wwv_flow_api.create_message (
  p_id=>195451227299151173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.INVALID_WSDL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_min_len_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe doit contenir au moins %0 caractères.';

wwv_flow_api.create_message (
  p_id=>195451331027151173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MIN_LEN_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_differs_by_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nouveau mot de passe doit comporter au moins %0 caractères différents de l''ancien mot de passe.';

wwv_flow_api.create_message (
  p_id=>195451432609151173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_DIFFERS_BY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_alpha_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe doit contenir au moins une lettre (%0).';

wwv_flow_api.create_message (
  p_id=>195451509891151173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_ALPHA_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe doit contenir au moins un chiffre (0123456789).';

wwv_flow_api.create_message (
  p_id=>195451621528151173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_NUMERIC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_punctuation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe doit contenir au moins un signe de ponctuation (%0).';

wwv_flow_api.create_message (
  p_id=>195451707849151174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_PUNCTUATION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_upper_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe doit contenir au moins une lettre majuscule.';

wwv_flow_api.create_message (
  p_id=>195451832156151174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_UPPER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_lower_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe doit contenir au moins une lettre minuscule.';

wwv_flow_api.create_message (
  p_id=>195451903299151174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_LOWER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_username_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe ne doit pas contenir de nom utilisateur.';

wwv_flow_api.create_message (
  p_id=>195452006226151174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_USERNAME_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_workspace_name_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe ne doit pas contenir de nom d''espace de travail.';

wwv_flow_api.create_message (
  p_id=>195452120445151174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORKSPACE_NAME_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_words_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe contient un mot simple interdit.';

wwv_flow_api.create_message (
  p_id=>195452229069151175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORDS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation SQL EXISTE';

wwv_flow_api.create_message (
  p_id=>195452300044151175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXISTS_SQL_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation SQL N''EXISTE PAS';

wwv_flow_api.create_message (
  p_id=>195452431505151175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_EXISTS_SQL_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''élément dans Expression 1 est NULL';

wwv_flow_api.create_message (
  p_id=>195452524153151175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''élément dans Expression 1 est NOT NULL';

wwv_flow_api.create_message (
  p_id=>195452628332151175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NOT_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message func_ret_boolean
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction PL/SQL renvoyant une valeur booléenne';

wwv_flow_api.create_message (
  p_id=>195452721505151175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNC_RET_BOOLEAN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_eq_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur de la préférence dans Expression';

wwv_flow_api.create_message (
  p_id=>195452808225151176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_EQ_EXP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_ne_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La valeur de la préférence dans Expression 1 != Expression 2';

wwv_flow_api.create_message (
  p_id=>195452914768151176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_NE_EXP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_eq_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La valeur de l''élément dans Expression 1 = Expression 2';

wwv_flow_api.create_message (
  p_id=>195453004571151176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_EQ_EXP2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_ne_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La valeur de l''élément dans Expression 1 != Expression 2';

wwv_flow_api.create_message (
  p_id=>195453111875151176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_NE_EXP2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_page_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Effectuer l''évaluation pour chaque vue de page';

wwv_flow_api.create_message (
  p_id=>195453201317151176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Effectuer l''évaluation une fois par session';

wwv_flow_api.create_message (
  p_id=>195453320153151176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_SESSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_complexity_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe n''est pas conforme aux règles de complexité de mot de passe de ce site.';

wwv_flow_api.create_message (
  p_id=>195453400211151177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_COMPLEXITY_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_export
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exporter';

wwv_flow_api.create_message (
  p_id=>195453520784151177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.EXPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette application a été exportée à partir de l''espace de travail en cours.';

wwv_flow_api.create_message (
  p_id=>195453614757151177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_CURR_WS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_non_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette application a été exportée à partir d''un autre espace de travail.';

wwv_flow_api.create_message (
  p_id=>195453718957151177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_NON_CURR_WS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''espace de travail ne sera pas créé car il existe déjà.';

wwv_flow_api.create_message (
  p_id=>195453830158151177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_tobe_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''espace de travail sera créé.';

wwv_flow_api.create_message (
  p_id=>195453927836151177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_TOBE_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Précédent';

wwv_flow_api.create_message (
  p_id=>195454000347151178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BACK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message today
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aujourd''hui';

wwv_flow_api.create_message (
  p_id=>195454122979151178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TODAY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message forward
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suivant';

wwv_flow_api.create_message (
  p_id=>195454209078151178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORWARD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez l''authentification de base de données (utilisateur identifié par DAD).';

wwv_flow_api.create_message (
  p_id=>195454314253151178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DAD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_internal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez les informations d''identification et de connexion du compte interne %0 et la page de connexion de cette application.';

wwv_flow_api.create_message (
  p_id=>195454419642151178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_INTERNAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application échantillon';

wwv_flow_api.create_message (
  p_id=>195454519051151178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application échantillon mettant en évidence des notions de conception standard.';

wwv_flow_api.create_message (
  p_id=>195454632013151179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP.DESCR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_collect_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Découvrez les concepts du chariot d''achat.';

wwv_flow_api.create_message (
  p_id=>195454718460151179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.COLLECT.DESCR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message bytes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'octets';

wwv_flow_api.create_message (
  p_id=>195454813248151179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BYTES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rows_returned_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'lignes renvoyées dans';

wwv_flow_api.create_message (
  p_id=>195454906985151179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROWS_RETURNED_IN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message invalid_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''objet %0 n''est pas valide.';

wwv_flow_api.create_message (
  p_id=>195455011999151179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INVALID_OBJECT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Query Builder';

wwv_flow_api.create_message (
  p_id=>195455127114151179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY BUILDER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aucune liste de valeurs';

wwv_flow_api.create_message (
  p_id=>195455224317151180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aucun raccourci';

wwv_flow_api.create_message (
  p_id=>195455326067151180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_SHORTCUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_authorization_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aucun modèle d''autorisation';

wwv_flow_api.create_message (
  p_id=>195455421221151180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_AUTHORIZATION_SCHEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_reset_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Réinitialisez le statut de session si vous souhaitez exécuter l''application sans valeurs prédéfinies.';

wwv_flow_api.create_message (
  p_id=>195455528255151180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_RESET_SESSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte d''affichage du bouton Annuler';

wwv_flow_api.create_message (
  p_id=>195455602788151180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte d''affichage du bouton Fin';

wwv_flow_api.create_message (
  p_id=>195455713421151180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_previous_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte d''affichage du bouton Précédent';

wwv_flow_api.create_message (
  p_id=>195455811706151181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_next_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte d''affichage du bouton Suivant';

wwv_flow_api.create_message (
  p_id=>195455912554151181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.NEXT_BUTTON_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement du bouton Annuler';

wwv_flow_api.create_message (
  p_id=>195456004434151181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement du bouton Fin';

wwv_flow_api.create_message (
  p_id=>195456109315151181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_BRANCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 de %1';

wwv_flow_api.create_message (
  p_id=>195456232708151181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM_OF',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bouton HTML';

wwv_flow_api.create_message (
  p_id=>195456319924151181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message one
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Un';

wwv_flow_api.create_message (
  p_id=>195456409564151182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message my_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ma page';

wwv_flow_api.create_message (
  p_id=>195456528456151182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MY_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copyright
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copyright &copy; %0. Tous droits réservés.';

wwv_flow_api.create_message (
  p_id=>195456613979151182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPYRIGHT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Régions';

wwv_flow_api.create_message (
  p_id=>195456717510151182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Processus';

wwv_flow_api.create_message (
  p_id=>195456811614151182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message computations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calculs';

wwv_flow_api.create_message (
  p_id=>195456914029151182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPUTATIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message validations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validations';

wwv_flow_api.create_message (
  p_id=>195457002749151183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALIDATIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message branches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchements';

wwv_flow_api.create_message (
  p_id=>195457101214151183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BRANCHES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eléments';

wwv_flow_api.create_message (
  p_id=>195457226433151183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEMS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Boutons';

wwv_flow_api.create_message (
  p_id=>195457312741151183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - %1 de %2';

wwv_flow_api.create_message (
  p_id=>195457421877151183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z_2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Espace de travail %0 paramétré avec l''administrateur %1.';

wwv_flow_api.create_message (
  p_id=>195457508461151183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unretrievable
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le document WSDL n''a pas pu être extrait, soit parce que l''URL que vous avez indiquée n''est pas valide, soit parce que votre environnement requiert une adresse de serveur proxy valide pour les demandes HTTP et que vous n''en avez pas définie pour cette application, ou parce qu''un portefeuille (wallet) doit être configuré pour cette instance de &PRODUCT_NAME. pour les demandes HTTPS.';

wwv_flow_api.create_message (
  p_id=>195457617164151183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNRETRIEVABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_no_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le document WSDL ne contient pas de liaison pour SOAP ; elle est requise pour l''ajout de la référence.';

wwv_flow_api.create_message (
  p_id=>195457704567151184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_NO_SOAP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drillup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hiérarchisation vers le haut';

wwv_flow_api.create_message (
  p_id=>195457811017151184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLUP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drilldown
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hiérarchisation vers le bas';

wwv_flow_api.create_message (
  p_id=>195457908403151184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLDOWN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier';

wwv_flow_api.create_message (
  p_id=>195458008110151184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message generated_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette table a été créée à l''aide de l''assistant Table.';

wwv_flow_api.create_message (
  p_id=>195458116996151184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'GENERATED_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message series
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Série %0';

wwv_flow_api.create_message (
  p_id=>195458201315151185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERIES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_fetch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''extraire la ligne.';

wwv_flow_api.create_message (
  p_id=>195458312605151185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_FETCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de traiter la ligne de la table %0.';

wwv_flow_api.create_message (
  p_id=>195458422026151185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_action_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Action traitée.';

wwv_flow_api.create_message (
  p_id=>195458523003151185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.ACTION_PROCESSED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message to_many_columns_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Un maximum de %0 colonnes peut être sélectionné.';

wwv_flow_api.create_message (
  p_id=>195458602434151185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TO_MANY_COLUMNS_SELECTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_javascript_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette application requiert l''activation de JavaScript.';

wwv_flow_api.create_message (
  p_id=>195458711967151185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_JAVASCRIPT_ENABLED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_cookies_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette application requiert l''activation des cookies.';

wwv_flow_api.create_message (
  p_id=>195458815940151185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_COOKIES_ENABLED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_unauthorized
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès non autorisé.';

wwv_flow_api.create_message (
  p_id=>195458923162151186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.UNAUTHORIZED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_no_datatype
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun type de données indiqué pour %0.';

wwv_flow_api.create_message (
  p_id=>195459014561151186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P602_NO_DATATYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_multiple_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le document WSDL contient plusieurs liaisons SOAP. &PRODUCT_NAME. ne prend en charge que les documents WSDL n''ayant qu''une seule liaison SOAP. Cliquez sur Créer manuellement une référence de service Web pour continuer la création d''une référence pour ce service.';

wwv_flow_api.create_message (
  p_id=>195459117389151186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.MULTIPLE_SOAP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_html_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cliquez <a href=''%0''>ici</a> pour terminer le processus d''approbation et recevoir vos informations d''identification et de connexion.';

wwv_flow_api.create_message (
  p_id=>195459206987151186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.HTML_EMAIL_CLICK_ON_LINK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p1023_parsing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analyse du script en cours - patientez.';

wwv_flow_api.create_message (
  p_id=>195459307751151186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P1023_PARSING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_line_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Numéro de ligne';

wwv_flow_api.create_message (
  p_id=>195459404647151199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.LINE_NUMBER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_invalid_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé l''exécution d''un script contenant une ou plusieurs instructions inconnues. Enlevez la ou les instructions suivantes :';

wwv_flow_api.create_message (
  p_id=>195459506560151200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.INVALID_STMT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f400_p107_step
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Etape %0';

wwv_flow_api.create_message (
  p_id=>195459606311151200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F400_P107_STEP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4719_yn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher Oui / Non, renvoyer O et N';

wwv_flow_api.create_message (
  p_id=>195459702638151200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4719.YN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Arborescence de résultats à communiquer';

wwv_flow_api.create_message (
  p_id=>195459830161151200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array_parms
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Paramètres de résultats à communiquer';

wwv_flow_api.create_message (
  p_id=>195459921574151200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY_PARMS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_collection
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''ensemble de résultats temporaire';

wwv_flow_api.create_message (
  p_id=>195460018052151200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLLECTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de région de panneau';

wwv_flow_api.create_message (
  p_id=>195460125884151201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de région de panneau';

wwv_flow_api.create_message (
  p_id=>195460221917151201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de région d''état';

wwv_flow_api.create_message (
  p_id=>195460323177151201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de région d''état';

wwv_flow_api.create_message (
  p_id=>195460416384151201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_insert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''effectuer l''opération d''insertion. %0  %1';

wwv_flow_api.create_message (
  p_id=>195460527772151201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_INSERT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'valeur par défaut : aspect 5';

wwv_flow_api.create_message (
  p_id=>195460631865151201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME15',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Aucun affichage -';

wwv_flow_api.create_message (
  p_id=>195460708483151202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DISPLAY_VALUE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message xml_load_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de chargement XML.';

wwv_flow_api.create_message (
  p_id=>195460826546151202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'XML_LOAD_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_component
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Composant partagé';

wwv_flow_api.create_message (
  p_id=>195460901649151202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED_COMPONENT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Supprimer';

wwv_flow_api.create_message (
  p_id=>195461031403151202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.DELETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unexpired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non périmé';

wwv_flow_api.create_message (
  p_id=>195461130721151202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNEXPIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Graphique HTML';

wwv_flow_api.create_message (
  p_id=>195461226235151202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_slash_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML/Texte';

wwv_flow_api.create_message (
  p_id=>195461310612151202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_SLASH_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text_with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte HTML avec raccourcis';

wwv_flow_api.create_message (
  p_id=>195461400577151203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT_WITH_SHORTCUTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enregistrer le DDL en tant que fichier de script. %0';

wwv_flow_api.create_message (
  p_id=>195461505271151203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''élément';

wwv_flow_api.create_message (
  p_id=>195461622672151203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type d''affichage';

wwv_flow_api.create_message (
  p_id=>195461722511151203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_analyze_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analyser %0';

wwv_flow_api.create_message (
  p_id=>195461816315151203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.ANALYZE_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_view_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vue par';

wwv_flow_api.create_message (
  p_id=>195461921890151203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.VIEW_BY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_analyze_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page d''analyse. %0';

wwv_flow_api.create_message (
  p_id=>195462021704151204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_ANALYZE_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message icon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Icône %0';

wwv_flow_api.create_message (
  p_id=>195462119193151204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ICON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message check
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'sélecteur de ligne';

wwv_flow_api.create_message (
  p_id=>195462231480151204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECK$',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'lien de colonne';

wwv_flow_api.create_message (
  p_id=>195462331589151204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINK$',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message derived
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'colonne dérivée';

wwv_flow_api.create_message (
  p_id=>195462414883151204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DERIVED$',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A propos de';

wwv_flow_api.create_message (
  p_id=>195462510324151204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ABOUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement';

wwv_flow_api.create_message (
  p_id=>195462603166151205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.BRANCHING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ajouter une ligne';

wwv_flow_api.create_message (
  p_id=>195462721245151205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.ADD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier';

wwv_flow_api.create_message (
  p_id=>195462828572151205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_numeric
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page doit être numérique.';

wwv_flow_api.create_message (
  p_id=>195462924484151205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_NUMERIC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_positive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page doit être un nombre positif.';

wwv_flow_api.create_message (
  p_id=>195463029262151205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_POSITIVE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_whole_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page doit être un nombre entier.';

wwv_flow_api.create_message (
  p_id=>195463103207151205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_WHOLE_NUMBER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La collection d''applications %0 n''existe pas.';

wwv_flow_api.create_message (
  p_id=>195463200561151205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NOT_EXIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La séquence de membre %0 n''existe pas dans la collection d''applications %1'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195463302802151206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_NOT_EXIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le numéro d''attribut de membre indiqué, %0, n''est pas valide.';

wwv_flow_api.create_message (
  p_id=>195463404807151206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_outside_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le numéro d''attribut de membre indiqué, %0, n''est pas valide. Le numéro d''attribut doit être compris entre 1 et %1.';

wwv_flow_api.create_message (
  p_id=>195463515443151206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_OUTSIDE_RANGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_sequence_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La séquence de membre %0 n''existe pas dans la collection d''applications "%1"';

wwv_flow_api.create_message (
  p_id=>195463619759151206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_SEQUENCE_NUMBER_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_array_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le tableau de collection d''applications ne doit pas avoir la valeur Null.';

wwv_flow_api.create_message (
  p_id=>195463728257151206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ARRAY_NOT_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nom de collection ne doit pas avoir la valeur Null.';

wwv_flow_api.create_message (
  p_id=>195463830040151206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_NOT_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_too_large
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La longueur du nom de collection ne doit pas dépasser 255 caractères.';

wwv_flow_api.create_message (
  p_id=>195463916553151207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_TOO_LARGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La collection d''applications existe.';

wwv_flow_api.create_message (
  p_id=>195464006339151207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le curseur n''est pas encore ouvert.';

wwv_flow_api.create_message (
  p_id=>195464129487151207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.CURSOR_NOT_OPEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_translation_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de trouver la traduction %0 de l''application %1';

wwv_flow_api.create_message (
  p_id=>195464200332151207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.TRANSLATION_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur d''insertion de valeur de départ : %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>195464302268151207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_INSERT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_delete_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de suppression de valeur de départ : %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>195464423230151207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_DELETE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_translations_seed_update_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de mise à jour de valeur de départ : %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>195464514831151208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TRANSLATIONS.SEED_UPDATE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sync_translations_sync_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de synchronisation : %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>195464603090151208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SYNC_TRANSLATIONS.SYNC_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_sgid_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''ID de groupe de sécurité 20 est réservé à l''espace de travail ORACLE.';

wwv_flow_api.create_message (
  p_id=>195464731149151208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.SGID_RESERVED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_button_tab_names_not_equal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les noms de bouton ne doivent pas être identiques à des noms d''onglet existants.';

wwv_flow_api.create_message (
  p_id=>195464801448151208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.BUTTON_TAB_NAMES_NOT_EQUAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_writing_to_directory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Une erreur s''est produite lors de l''écriture dans le répertoire de fichier physique "%0". (%1: %2)';

wwv_flow_api.create_message (
  p_id=>195464908197151208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_WRITING_TO_DIRECTORY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_no_file_to_write
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas de fichier à écrire pour l''ID %0';

wwv_flow_api.create_message (
  p_id=>195465017386151208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.NO_FILE_TO_WRITE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le serveur a détecté une erreur lors de la suppression du fichier "%0"';

wwv_flow_api.create_message (
  p_id=>195465127362151208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever le fichier %0';

wwv_flow_api.create_message (
  p_id=>195465204617151209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed_with_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La version en cours des données dans la base a changé depuis que l''utilisateur a lancé le traitement de mise à jour. total de contrôle en cours = "%0" total de contrôle de l''application = "%1"'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195465321602151209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED_WITH_CHECKSUM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La version en cours des données dans la base a changé depuis que l''utilisateur a lancé le traitement de mise à jour.';

wwv_flow_api.create_message (
  p_id=>195465417110151209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_invalid_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Action %0 non valide pour l''objet. (%1)';

wwv_flow_api.create_message (
  p_id=>195465531271151209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.INVALID_ACTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle (%0) introuvable pour copie';

wwv_flow_api.create_message (
  p_id=>195465611763151209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de champ (%0) pour copie introuvable dans l''application "%1", espace de travail "%2"';

wwv_flow_api.create_message (
  p_id=>195465722401151209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès non autorisé.';

wwv_flow_api.create_message (
  p_id=>195465821952151210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle d''historique des accès (%0) pour copie introuvable dans l''application "%1", espace de travail "%2"';

wwv_flow_api.create_message (
  p_id=>195465912069151210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de bouton (%0) pour copie introuvable dans l''application "%1", espace de travail "%2"';

wwv_flow_api.create_message (
  p_id=>195466016084151210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle %0. %1';

wwv_flow_api.create_message (
  p_id=>195466100674151210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_page_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle de page. %0';

wwv_flow_api.create_message (
  p_id=>195466217384151210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.PAGE_TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_region_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle de région. %0';

wwv_flow_api.create_message (
  p_id=>195466311489151210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REGION_TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_report_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle d''état. %0';

wwv_flow_api.create_message (
  p_id=>195466408570151211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REPORT_TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_list_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle de liste. %0';

wwv_flow_api.create_message (
  p_id=>195466529254151211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.LIST_TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle de champ. %0';

wwv_flow_api.create_message (
  p_id=>195466608849151211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle d''historique des accès. %0';

wwv_flow_api.create_message (
  p_id=>195466727735151211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_popup_lov_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle de liste de valeurs (LOV) instantanée. %0';

wwv_flow_api.create_message (
  p_id=>195466821607151211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.POPUP_LOV_TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de remplacer le modèle de bouton. %0';

wwv_flow_api.create_message (
  p_id=>195466928651151211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_REPLACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p122_cal_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles de calendrier faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195467000236151211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P122_CAL_TEMPL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de page. %0';

wwv_flow_api.create_message (
  p_id=>195467115446151212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_PAGE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_region_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de région. %0';

wwv_flow_api.create_message (
  p_id=>195467230807151212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REGION_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_list_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de liste. %0';

wwv_flow_api.create_message (
  p_id=>195467314090151212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LIST_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_report_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence d''état. %0';

wwv_flow_api.create_message (
  p_id=>195467430789151212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REPORT_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_field_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de champ. %0';

wwv_flow_api.create_message (
  p_id=>195467500670151212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_FIELD_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_security_scheme_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de modèle de sécurité. %0';

wwv_flow_api.create_message (
  p_id=>195467621264151212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SECURITY_SCHEME_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de raccourci. %0';

wwv_flow_api.create_message (
  p_id=>195467712622151213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SHORTCUT_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de barre de navigation. %0';

wwv_flow_api.create_message (
  p_id=>195467827756151213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_NAVBAR_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de liste de valeurs (LOV). %0';

wwv_flow_api.create_message (
  p_id=>195467931289151213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LOV_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_popup_lov_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de modèle de liste de valeurs (LOV) instantanée. %0';

wwv_flow_api.create_message (
  p_id=>195468016490151213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_POPUP_LOV_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de modèle d''historique des accès. %0';

wwv_flow_api.create_message (
  p_id=>195468101557151213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_MENU_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_button_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de modèle de bouton. %0';

wwv_flow_api.create_message (
  p_id=>195468202150151213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_BUTTON_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws_rpt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''un panneau et d''un état sur une page de référence de service Web avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195468327415151214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_auth_setup_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de modèle d''authentification. %0';

wwv_flow_api.create_message (
  p_id=>195468415774151214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_AUTH_SETUP_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever l''ID de référence de l''aide sur un élément. %0';

wwv_flow_api.create_message (
  p_id=>195468506444151214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_ITEM_HELP_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle de page. %0';

wwv_flow_api.create_message (
  p_id=>195468617237151214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_PAGE_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle de région. %0';

wwv_flow_api.create_message (
  p_id=>195468705869151214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REGION_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle de liste. %0';

wwv_flow_api.create_message (
  p_id=>195468831443151214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LIST_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle d''état. %0';

wwv_flow_api.create_message (
  p_id=>195468921703151215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REPORT_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle de champ. %0';

wwv_flow_api.create_message (
  p_id=>195469031141151215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_FIELD_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle de liste de valeurs (LOV) instantanée. %0';

wwv_flow_api.create_message (
  p_id=>195469122351151215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_POPUP_LOV_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle d''historique des accès. %0';

wwv_flow_api.create_message (
  p_id=>195469207910151215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_MENU_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle de bouton. %0';

wwv_flow_api.create_message (
  p_id=>195469323232151215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_BUTTON_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle de sécurité. %0';

wwv_flow_api.create_message (
  p_id=>195469426233151215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SECURITY_SCHEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au raccourci. %0';

wwv_flow_api.create_message (
  p_id=>195469510508151216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SHORTCUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner à la barre de navigation. %0';

wwv_flow_api.create_message (
  p_id=>195469610617151216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_NAVBAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner à la liste de valeurs (LOV). %0';

wwv_flow_api.create_message (
  p_id=>195469730993151216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle d''authentification. %0';

wwv_flow_api.create_message (
  p_id=>195469802388151216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_AUTH_SETUP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner à l''aide sur un élément. %0';

wwv_flow_api.create_message (
  p_id=>195469908394151216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_ITEM_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle de page. %0';

wwv_flow_api.create_message (
  p_id=>195470008000151216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_PAGE_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle de région. %0';

wwv_flow_api.create_message (
  p_id=>195470132148151217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REGION_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle de liste. %0';

wwv_flow_api.create_message (
  p_id=>195470217420151217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LIST_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle d''état. %0';

wwv_flow_api.create_message (
  p_id=>195470301251151217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REPORT_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle de champ. %0';

wwv_flow_api.create_message (
  p_id=>195470427784151217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_FIELD_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle de liste de valeurs (LOV) instantanée. %0';

wwv_flow_api.create_message (
  p_id=>195470517657151217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_POPUP_LOV_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle de bouton. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195470615596151217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_BUTTON_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle d''historique des accès. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195470702175151218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_MENU_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle de sécurité. %0';

wwv_flow_api.create_message (
  p_id=>195470810760151218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SECURITY_SCHEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le raccourci %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195470908456151218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SHORTCUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier la barre de navigation. %0';

wwv_flow_api.create_message (
  p_id=>195471020777151218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_NAVBAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier la liste de valeurs. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195471125586151218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle d''authentification. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195471212268151218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_AUTH_SETUP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier l''aide sur un élément. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195471329209151219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_ITEM_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_user_no_privileges
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''utilisateur %0 ne dispose pas de privilèges sur le schéma %1.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195471409095151219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.USER_NO_PRIVILEGES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun espace de travail n''a été trouvé avec l''ID %0';

wwv_flow_api.create_message (
  p_id=>195471518007151219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_COMPANY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun schéma n''est affecté à l''espace de travail dont l''ID est  %0';

wwv_flow_api.create_message (
  p_id=>195471608992151219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_auto_provision_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La fourniture automatique d''infos de paramétrage a échoué au cours de la phase MAKE_REQUEST.';

wwv_flow_api.create_message (
  p_id=>195471704049151219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.AUTO_PROVISION_FAILURE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_user_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Une erreur s''est produite lors de l''ajout de l''utilisateur à l''espace de travail %0';

wwv_flow_api.create_message (
  p_id=>195471804940151220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_USER_ADD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette demande a été traitée ou est en cours de traitement. Le statut doit être égal à "%0"';

wwv_flow_api.create_message (
  p_id=>195471923662151220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_PROCESSED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''espace de travail %0 est un nom réservé, la demande est rejetée';

wwv_flow_api.create_message (
  p_id=>195472026842151220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_RESERVED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le schéma portant le nom %0 est un schéma réservé ; il ne peut pas faire l''objet de la fourniture d''infos de paramétrage.';

wwv_flow_api.create_message (
  p_id=>195472123838151220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_RESERVED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La demande %0 n''a pas pu être traitée. %1';

wwv_flow_api.create_message (
  p_id=>195472210085151220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_PROCESSED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La demande %0 n''a pas pu être traitée car le schéma %1 existe dans la table %2.';

wwv_flow_api.create_message (
  p_id=>195472326804151220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demande %0 introuvable';

wwv_flow_api.create_message (
  p_id=>195472411370151221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_generate_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rem Impossible de générer le DDL pour %0 %1.';

wwv_flow_api.create_message (
  p_id=>195472509078151221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.GENERATE_DDL_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''analyse du script DDL. %0';

wwv_flow_api.create_message (
  p_id=>195472614807151221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_PARSE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur Save_ddl %0';

wwv_flow_api.create_message (
  p_id=>195472710433151221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''importer les attributs d''installation d''objets de base de données ayant l''ID "%0".';

wwv_flow_api.create_message (
  p_id=>195472825414151221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_script_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du script d''installation ayant l''ID "%0".';

wwv_flow_api.create_message (
  p_id=>195472904427151221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_SCRIPT_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_next_prev_pk_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le processus d''obtention de la valeur de la clé primaire suivante ou précédente. %0';

wwv_flow_api.create_message (
  p_id=>195473028521151222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.NEXT_PREV_PK_PROCESS_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_table_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer les tables de contrôle d''accès. %0';

wwv_flow_api.create_message (
  p_id=>195473100998151222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_page_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page de contrôle d''accès. %0';

wwv_flow_api.create_message (
  p_id=>195473231569151222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message out_of_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''ensemble de lignes demandé n''est pas valide : les données source de l''état ont été modifiées.';

wwv_flow_api.create_message (
  p_id=>195473330674151222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OUT_OF_RANGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'réinitialiser la pagination';

wwv_flow_api.create_message (
  p_id=>195473418320151222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cet installeur d''application vous guide tout au long du processus de création des objets de base de données et des données de départ.';

wwv_flow_api.create_message (
  p_id=>195473516135151222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous pouvez configurer les attributs ci-après de votre application.';

wwv_flow_api.create_message (
  p_id=>195473608044151223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous pouvent choisir d''inclure les options de construction ci-après.';

wwv_flow_api.create_message (
  p_id=>195473709206151223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les validations ci-après seront effectuées pour vérifier si votre système est compatible avec cette application.';

wwv_flow_api.create_message (
  p_id=>195473820635151223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Confirmez que vous souhaitez installer les objets de prise en charge de cette application.';

wwv_flow_api.create_message (
  p_id=>195473912725151223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les objets de prise en charge de votre application ont été installés.';

wwv_flow_api.create_message (
  p_id=>195474015935151223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''installation des objets de base de données et des données de départ a échoué.';

wwv_flow_api.create_message (
  p_id=>195474128311151223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Désinstallation terminée.';

wwv_flow_api.create_message (
  p_id=>195474219487151224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Méthode';

wwv_flow_api.create_message (
  p_id=>195474314480151224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_METHOD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Détails';

wwv_flow_api.create_message (
  p_id=>195474416201151224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Logique de gestion de session intégrée, page de connexion et authentification utilisateur intégrées par rapport au référentiel de comptes internes d''utilisateur de cookie.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195474524583151224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Logique de gestion de session intégrée. L''authentification utilisateur est effectuée via la configuration DAD modplsql.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195474620389151224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette méthode a été remplacée par l''authentification SCHEME.';

wwv_flow_api.create_message (
  p_id=>195474724796151224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette méthode est obsolète.';

wwv_flow_api.create_message (
  p_id=>195474804646151225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_public_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pages publiques';

wwv_flow_api.create_message (
  p_id=>195474900711151225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PUBLIC_PAGES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Action ';

wwv_flow_api.create_message (
  p_id=>195475011667151225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Revoir ou modifier';

wwv_flow_api.create_message (
  p_id=>195475102403151225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ou modifiez';

wwv_flow_api.create_message (
  p_id=>195475201056151225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'les attributs de gestion de session';

wwv_flow_api.create_message (
  p_id=>195475316766151225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'de cette application dans la page des attributs d''application, ou utilisez l''état ci-dessus pour créer et gérer les modèles d''authentification que vous pourrez utiliser lorsque vous ferez passer la méthode d''authentification à %0.';

wwv_flow_api.create_message (
  p_id=>195475412888151226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(aucun)';

wwv_flow_api.create_message (
  p_id=>195475529834151226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_NONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_manage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gérez les modèles d''authentification à l''aide de l''état ci-dessus.';

wwv_flow_api.create_message (
  p_id=>195475602042151226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_MANAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_deactivate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Faire passer le statut à Inactif';

wwv_flow_api.create_message (
  p_id=>195475727707151226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DEACTIVATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(en cours)';

wwv_flow_api.create_message (
  p_id=>195475800476151226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_CURRENT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Faire de ce modèle le modèle en cours';

wwv_flow_api.create_message (
  p_id=>195475901975151226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'rendre en cours';

wwv_flow_api.create_message (
  p_id=>195476023544151227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_copy_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195476116620151227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_COPY_FROM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de ce modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195476208487151227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_MASTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles faisant référence à ce modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195476313282151227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_SUBSCRIBERS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_no_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas d''abonnés à ce modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195476414899151227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_NO_SUBSCRIBERS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_builtin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Intégré)';

wwv_flow_api.create_message (
  p_id=>195476504894151227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_BUILTIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195476630800151228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pg_sentry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction de sentinelle de page';

wwv_flow_api.create_message (
  p_id=>195476717274151228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PG_SENTRY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_sess_verify
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction de vérification de session';

wwv_flow_api.create_message (
  p_id=>195476832539151228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_SESS_VERIFY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_inv_sess_tgt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cible de session non valide';

wwv_flow_api.create_message (
  p_id=>195476928407151228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_INV_SESS_TGT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Processus de préauthentification';

wwv_flow_api.create_message (
  p_id=>195477022696151228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PRE_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction d''authentification'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195477102426151228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hôte LDAP';

wwv_flow_api.create_message (
  p_id=>195477229261151229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_HOST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Port LDAP';

wwv_flow_api.create_message (
  p_id=>195477321361151229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_PORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Base de recherche LDAP';

wwv_flow_api.create_message (
  p_id=>195477421288151229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_DN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modification de nom utilisateur LDAP';

wwv_flow_api.create_message (
  p_id=>195477511724151229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Processus de postauthentification';

wwv_flow_api.create_message (
  p_id=>195477607575151229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_POST_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de cookie';

wwv_flow_api.create_message (
  p_id=>195477724537151229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_path
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chemin de cookie';

wwv_flow_api.create_message (
  p_id=>195477827416151230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_PATH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_domain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Domaine de cookie';

wwv_flow_api.create_message (
  p_id=>195477904830151230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_DOMAIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_logout_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL de déconnexion';

wwv_flow_api.create_message (
  p_id=>195478024137151230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LOGOUT_URL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Authentification de base de données)';

wwv_flow_api.create_message (
  p_id=>195478104231151230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_DBAUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_flow_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID d''application';

wwv_flow_api.create_message (
  p_id=>195478228930151230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_FLOW_ID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Méthode d''authentification';

wwv_flow_api.create_message (
  p_id=>195478304226151231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_AUTH_METHOD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_scheme_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de modèle';

wwv_flow_api.create_message (
  p_id=>195478407359151231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_SCHEME_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>195478526335151231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_DESCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p822_curr_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Méthode d''authentification en cours';

wwv_flow_api.create_message (
  p_id=>195478604566151231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P822_CURR_METHOD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le modèle de liste. %0';

wwv_flow_api.create_message (
  p_id=>195478700012151231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer l''application. %0';

wwv_flow_api.create_message (
  p_id=>195478822060151231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_FLOW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le modèle de page. %0';

wwv_flow_api.create_message (
  p_id=>195478906280151232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_PAGE_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_label_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le modèle de libellé. %0';

wwv_flow_api.create_message (
  p_id=>195479026206151232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LABEL_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le modèle d''état. %0';

wwv_flow_api.create_message (
  p_id=>195479121926151232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le modèle de région. %0';

wwv_flow_api.create_message (
  p_id=>195479225768151232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REGION_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le modèle d''historique des accès. %0';

wwv_flow_api.create_message (
  p_id=>195479308684151232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le modèle de bouton. %0';

wwv_flow_api.create_message (
  p_id=>195479403813151232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_BUTTON_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le modèle de liste de valeurs (LOV) instantanée.';

wwv_flow_api.create_message (
  p_id=>195479517143151233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.POPUP_LOV_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer les onglets standard. %0';

wwv_flow_api.create_message (
  p_id=>195479612669151233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la barre de navigation. %0';

wwv_flow_api.create_message (
  p_id=>195479722512151233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NAVBAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer l''historique des accès. %0';

wwv_flow_api.create_message (
  p_id=>195479810020151233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page d''état. %0';

wwv_flow_api.create_message (
  p_id=>195479907924151233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le panneau d''insertion. %0';

wwv_flow_api.create_message (
  p_id=>195480015790151233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_INSERT_FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le panneau de mise à jour. %0';

wwv_flow_api.create_message (
  p_id=>195480121749151234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_UPDATE_FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page de graphique.';

wwv_flow_api.create_message (
  p_id=>195480207789151234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_CHART_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la configuration pour la mise à jour du nom utilisateur LDAP.';

wwv_flow_api.create_message (
  p_id=>195480303846151234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter la fonction de mise à jour de l''utilisateur LDAP.';

wwv_flow_api.create_message (
  p_id=>195480411465151234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_FN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le package SYS.DBMS_LDAP n''existe pas ou n''est pas valide.';

wwv_flow_api.create_message (
  p_id=>195480523823151234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_MISSING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_fix
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demandez à votre administrateur de base de données d''exécuter $OH/rdbms/admin/catldap.sql.';

wwv_flow_api.create_message (
  p_id=>195480616410151234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_FIX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_ldap_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''exécution de wwv_flow_custom_auth_ldap.authenticate.';

wwv_flow_api.create_message (
  p_id=>195480711613151235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_LDAP_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter le traitement de préauthentification personnalisé.';

wwv_flow_api.create_message (
  p_id=>195480815855151235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_PRE_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_setup_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la configuration pour exécution de la fonction de vérification des informations d''identification et de connexion.';

wwv_flow_api.create_message (
  p_id=>195480905509151235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SETUP_CRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter la fonction de vérification des informations d''identification et de connexion.';

wwv_flow_api.create_message (
  p_id=>195481030776151235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_CRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter le traitement de postauthentification personnalisé.';

wwv_flow_api.create_message (
  p_id=>195481110387151235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_POST_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Argument incorrect pour wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.';

wwv_flow_api.create_message (
  p_id=>195481224353151235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_null_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Argument p_session_id Null pour wwv_flow_custom_auth_std.login--p_flow_page:%0';

wwv_flow_api.create_message (
  p_id=>195481311145151236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NULL_LOGIN_ARG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Contactez l''administrateur.';

wwv_flow_api.create_message (
  p_id=>195481408305151236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_CONTACT_ADMIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'p_session interdit dans wwv_flow_custom_auth_std.login--p_flow_page : %0 p_session_id : %1.';

wwv_flow_api.create_message (
  p_id=>195481506278151236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_ARG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_invalid_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'p_session non valide dans wwv_flow_custom_auth_std.login--p_flow_page : %0 p_session_id : %1.';

wwv_flow_api.create_message (
  p_id=>195481618124151236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_INVALID_LOGIN_ARG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Argument de point d''entrée interdit pour wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.  ';

wwv_flow_api.create_message (
  p_id=>195481717977151236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_login_null_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom utilisateur Null transmis à la procédure de connexion.';

wwv_flow_api.create_message (
  p_id=>195481824887151236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LOGIN_NULL_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_partner_app_unreg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de trouver le nom d''application partenaire inscrit dans le modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195481901135151237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_PARTNER_APP_UNREG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_partner_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifiez le modèle d''authentification et ajoutez le nom d''application.';

wwv_flow_api.create_message (
  p_id=>195482016280151237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_PARTNER_APP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_wwsec_pkg_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le package WWSEC_SSO_ENABLER_PRIVATE n''existe pas ou n''est pas valide.';

wwv_flow_api.create_message (
  p_id=>195482124533151237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_WWSEC_PKG_MISSING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_wwsec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demandez à votre administrateur de configurer le moteur pour Oracle AS Single Sign-On.';

wwv_flow_api.create_message (
  p_id=>195482229495151237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_WWSEC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_sso_redir
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''exécution de wwv_flow_custom_auth_sso.portal_sso_redirect.';

wwv_flow_api.create_message (
  p_id=>195482322087151237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SSO_REDIR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_pg_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans l''argument p_flow_page de la procédure login_page.';

wwv_flow_api.create_message (
  p_id=>195482404718151237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_PG_ARG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_home_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page d''accueil. %0';

wwv_flow_api.create_message (
  p_id=>195482525154151238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_HOME_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la liste. %0';

wwv_flow_api.create_message (
  p_id=>195482619709151238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer l''élément de liste. %0';

wwv_flow_api.create_message (
  p_id=>195482714171151238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page de succès. %0';

wwv_flow_api.create_message (
  p_id=>195482815048151238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_SUCCESS_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_define_default_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Définissez des modèles par défaut pour créer l''application.';

wwv_flow_api.create_message (
  p_id=>195482908896151238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DEFINE_DEFAULT_TEMPLATES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_use_one_level_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne pouvez construire l''application qu''en utilisant un onglet à un niveau.';

wwv_flow_api.create_message (
  p_id=>195483002276151239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.USE_ONE_LEVEL_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_modules
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer les modules. %0';

wwv_flow_api.create_message (
  p_id=>195483104654151239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MODULES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur d''analyse 2 %0';

wwv_flow_api.create_message (
  p_id=>195483220797151239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ParseErr : %0';

wwv_flow_api.create_message (
  p_id=>195483306376151239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer l''état modifiable. %0';

wwv_flow_api.create_message (
  p_id=>195483403905151239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_UPDATEABLE_REPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le panneau sur sp. %0';

wwv_flow_api.create_message (
  p_id=>195483513711151239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_SP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le panneau sur table. %0';

wwv_flow_api.create_message (
  p_id=>195483622604151240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le panneau d''insertion. %0';

wwv_flow_api.create_message (
  p_id=>195483727881151240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_INSERT_FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_query_and_update_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page d''interrogation et de mise à jour. %0';

wwv_flow_api.create_message (
  p_id=>195483820687151240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_QUERY_AND_UPDATE_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page de graphique. %0';

wwv_flow_api.create_message (
  p_id=>195483921755151240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CHART_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type d''état non valide.';

wwv_flow_api.create_message (
  p_id=>195484022376151240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.INVALID_REPORT_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page d''état. %0';

wwv_flow_api.create_message (
  p_id=>195484114596151240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_REPORT_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_calendar_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page de calendrier. %0';

wwv_flow_api.create_message (
  p_id=>195484207518151241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CALENDAR_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_equijoin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le panneau sur équijointure. %0';

wwv_flow_api.create_message (
  p_id=>195484325141151241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_EQUIJOIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer l''assistant Création d''assistant. %0';

wwv_flow_api.create_message (
  p_id=>195484428741151241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_WIZARD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer l''arborescence. %0';

wwv_flow_api.create_message (
  p_id=>195484506725151241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_TREE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_excel_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le graphique Excel. %0';

wwv_flow_api.create_message (
  p_id=>195484625272151241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_EXCEL_CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page récapitulative. %0';

wwv_flow_api.create_message (
  p_id=>195484731780151241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SUMMARY_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer la page de graphique SVG. %0';

wwv_flow_api.create_message (
  p_id=>195484823138151242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SVG_CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_updateable_query_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il existe déjà une interrogation SQL modifiable. Vous ne pouvez ajouter qu''une seule interrogation SQL modifiable par page.';

wwv_flow_api.create_message (
  p_id=>195484927779151242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UPDATEABLE_QUERY_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg_handling
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gestion de page de connexion';

wwv_flow_api.create_message (
  p_id=>195485024532151242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG_HANDLING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette application (%0) utilise la page %1 comme page de connexion.';

wwv_flow_api.create_message (
  p_id=>195485128397151242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lorsque la page %0 est demandée, aucun autre contrôle d''authentification n''est effectué et la page est affichée ou acceptée. Ainsi, la page de connexion peut être affichée avant que l''authentification n''ait lieu.';

wwv_flow_api.create_message (
  p_id=>195485228887151242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentification de base de données';

wwv_flow_api.create_message (
  p_id=>195485319866151242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette application utilise la configuration DAD pour l''authentification. Si des informations de compte sont stockées avec la configuration DAD, la variable APP_USER prend pour valeur l''utilisateur associé au DAD. Si l''attribut d''application PUBLIC_USER a pour valeur le nom d''utilisateur enregistré dans le DAD, il est possible de comparer la variable APP_USER à l''attribut PUBLIC_USER dans les condit';

h:=h||'ions d''application, les évaluations de modèle de sécurité et tout autre code imbriqué. Lorsqu''il n''y a pas d''informations de compte avec le DAD, l''utilisateur doit passer l''authentification via une boîte de dialogue présentée par le navigateur. Une fois l''authentification effectuée, le moteur attribue à APP_USER le nom récupéré dans cette boîte de dialogue.';

wwv_flow_api.create_message (
  p_id=>195485406206151243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune page de connexion n''est présentée à l''utilisateur par le moteur.';

wwv_flow_api.create_message (
  p_id=>195485500337151243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_page_sentry_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction de sentinelle de page';

wwv_flow_api.create_message (
  p_id=>195485615969151243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PAGE_SENTRY_FUNCTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_pg_sentry1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez du code intégré pour effectuer les tâches de sentinelle de page. Pour chaque demande de page, la fonction de sentinelle vérifie la session et calcule une valeur de retour.';

wwv_flow_api.create_message (
  p_id=>195485717384151243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PG_SENTRY1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction de vérification de session';

wwv_flow_api.create_message (
  p_id=>195485805062151243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY_FUNCTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chk_cookie1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez du code intégré pour vérifier le cookie nommé [%0]. S''il existe et que sa valeur décodée localise une ligne dans la table des sessions interne, considérez que la session est valide.';

wwv_flow_api.create_message (
  p_id=>195485902888151243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHK_COOKIE1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez du code supplémentaire fourni par l''utilisateur pour déterminer si la session est valide. Après avoir obtenu le résultat TRUE de la vérification de session intégrée ci-dessus, exécutez le code suivant et retenez la valeur booléenne qu''il renvoie :';

wwv_flow_api.create_message (
  p_id=>195486013227151243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_compute_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calculer la valeur de retour';

wwv_flow_api.create_message (
  p_id=>195486109222151244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.COMPUTE_RETURN_VALUE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La fonction de sentinelle de page renvoie au moteur le résultat booléen de la vérification de session intégrée. Si ce résultat est TRUE, le moteur continue à afficher ou à accepter la page. Si le résultat est FALSE, le moteur effectue un réacheminement vers la page ou l''URL de session non valide indiquée dans ce modèle d''authentification (voir ci-dessous).';

wwv_flow_api.create_message (
  p_id=>195486213928151244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La fonction de sentinelle de page renvoie au moteur le résultat booléen de la vérification de session intégrée combiné par AND au résultat de la vérification de session fournie par l''utilisateur. Si le résultat est TRUE, le moteur continue à afficher ou à accepter la page. Si le résultat est FALSE, le moteur effectue un réacheminement vers la cible de session non valide indiquée dans ce modèle d''a';

h:=h||'uthentification (voir ci-dessous).';

wwv_flow_api.create_message (
  p_id=>195486304575151244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez du code personnalisé pour effectuer les tâches de sentinelle de page. Pour chaque demande de page, le moteur exécute le code suivant :';

wwv_flow_api.create_message (
  p_id=>195486429663151244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le résultat booléen du bloc ci-dessus est renvoyé au moteur. Si ce résultat est TRUE, le moteur continue à afficher ou à accepter la page. Si le résultat est FALSE, le moteur effectue un réacheminement vers la cible de session non valide indiquée dans ce modèle d''authentification (voir ci-dessous).';

wwv_flow_api.create_message (
  p_id=>195486504552151244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La méthode intégrée de vérification de session est disponible pour le développeur %0 via l''appel API suivant :';

wwv_flow_api.create_message (
  p_id=>195486615483151244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION5',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le résultat de cette fonction booléenne peut être combiné à d''autres contrôles dans la fonction de sentinelle de page fournie par l''utilisateur qui est indiquée dans le modèle d''authentification. Lorsque cette API est appelée, elle contrôle le cookie nommé %0';

wwv_flow_api.create_message (
  p_id=>195486725679151245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION6',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Si le cookie existe et que sa valeur décodée localise une ligne dans la table des sessions interne, la session est considérée comme valide et la valeur TRUE est renvoyée à la fonction de sentinelle de page l''ayant appelée..';

wwv_flow_api.create_message (
  p_id=>195486825453151245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION7',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_invalid_sess_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cible de session non valide';

wwv_flow_api.create_message (
  p_id=>195486914455151245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.INVALID_SESS_TARGET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Si la fonction de sentinelle de page renvoie la valeur TRUE, l''affichage ou le traitement de la page continue. Si elle renvoie la valeur FALSE, le moteur affiche la page %0, qui est considérée comme la page de connexion de cette application car elle est indiquée comme page de session non valide dans le modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195487010014151245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION8',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'la page de connexion intégrée';

wwv_flow_api.create_message (
  p_id=>195487130303151245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.BUILTIN_LOGIN_PG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On';

wwv_flow_api.create_message (
  p_id=>195487225883151245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SSO_SERVER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_the_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'l''URL';

wwv_flow_api.create_message (
  p_id=>195487305709151246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.THE_URL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La fonction de sentinelle de page renvoie un résultat booléen au moteur. Si ce résultat est TRUE, l''affichage ou le traitement de la page continue. Si le résultat est FALSE, le moteur effectue un réacheminement vers %0';

wwv_flow_api.create_message (
  p_id=>195487409440151246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION9',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action10
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Si la fonction de sentinelle de page renvoie la valeur TRUE, l''affichage ou le traitement de la page continue. Si elle renvoie la valeur FALSE, le moteur quitte car aucune cible de session non valide n''est indiquée dans le modèle d''authentification. Dans ce cas, on suppose que la fonction de sentinelle de page fournie par l''utilisateur a effectué un réacheminement vers une page de connexion en deh';

h:=h||'ors de l''environnement %0, éventuellement vers un portail d''authentification externe. La fonction doit également avoir défini la variable globale g_unrecoverable_error := true pour que le moteur quitte sans afficher de page d''erreur.';

wwv_flow_api.create_message (
  p_id=>195487529692151246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION10',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le moteur va exécuter le code suivant, que le modèle d''authentification désigne comme le traitement de préauthentification :';

wwv_flow_api.create_message (
  p_id=>195487629005151246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION11',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exécution en tant que bloc anonyme ne renvoyant aucune valeur.';

wwv_flow_api.create_message (
  p_id=>195487730514151246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION12',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun code de préauthentification personnalisé n''est indiqué dans ce modèle.';

wwv_flow_api.create_message (
  p_id=>195487817071151246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION13',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_credentials_verification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vérification des informations d''identification et de connexion (authentification)';

wwv_flow_api.create_message (
  p_id=>195487918966151247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CREDENTIALS_VERIFICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Toute combinaison nom utilisateur/mot de passe saisie dans le panneau de connexion sera considérée comme valide. Le nom utilisateur saisi servira de nom d''utilisateur connecté pour la durée de la session. Cette pratique est utile lorsque les applications sont en cours de développement et qu''aucun compte utilisateur véritable n''est encore défini.';

wwv_flow_api.create_message (
  p_id=>195488029591151247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION14',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vérifiez le nom utilisateur et le mot de passe saisis dans le panneau de connexion par rapport aux comptes Application Builder (utilisateur de cookie). Ce sont les mêmes comptes que ceux qui sont utilisés dans votre espace de travail pour la connexion à %0. Cette pratique est utile lorsque les utilisateurs de votre application sont des développeurs disposant de comptes %0 dans les mêmes base de do';

h:=h||'nnées et espace de travail.';

wwv_flow_api.create_message (
  p_id=>195488131414151247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vérifiez le nom utilisateur et le mot de passe saisis dans le panneau de connexion à l''aide de l''annuaire LDAP indiqué dans ce modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195488228931151247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION16',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les paramètres LDAP ont la valeur suivante :';

wwv_flow_api.create_message (
  p_id=>195488308381151247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION17',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hôte LDAP :';

wwv_flow_api.create_message (
  p_id=>195488406785151248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_HOST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Port LDAP :';

wwv_flow_api.create_message (
  p_id=>195488516719151248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_PORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Base de recherche LDAP :';

wwv_flow_api.create_message (
  p_id=>195488610571151248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_DN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le bloc suivant sert à appeler une fonction avant l''appel de DBMS_LDAP.SIMPLE_BIND_S. Le nom utilisateur du panneau de connexion est transmis à la fonction qui envoie en retour une valeur utilisée pour remplacer %LDAP_USER% dans la base de recherche LDAP (voir ci-dessus).';

wwv_flow_api.create_message (
  p_id=>195488700636151248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce bloc de code doit comporter la signature suivante :';

wwv_flow_api.create_message (
  p_id=>195488801433151248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette fonctionnalité vous permet de transformer le nom utilisateur saisi dans le panneau de connexion afin de lui donner un format correspondant à l''entrée de l''annuaire LDAP.';

wwv_flow_api.create_message (
  p_id=>195488907380151248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exécutez le code personnalisé suivant pour vérifier les informations d''identification et de connexion :';

wwv_flow_api.create_message (
  p_id=>195489016279151248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION18',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Traitement de postauthentification';

wwv_flow_api.create_message (
  p_id=>195489111510151249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.POST_AUTH_PROC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action19
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Recherchez dans la table des sessions intégrée la session utilisée par la page de connexion intégrée. Si la session existe et qu''elle n''appartient pas à un autre utilisateur, marquez-la comme appartenant maintenant à l''utilisateur authentifié (en utilisant le nom utilisateur du panneau de connexion).';

wwv_flow_api.create_message (
  p_id=>195489232191151249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION19',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action20
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Affectez au cookie nommé %0 une valeur permettant de localiser la ligne dans la table des sessions interne.';

wwv_flow_api.create_message (
  p_id=>195489324633151249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION20',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Déterminez l''URL sur laquelle effectuer le réacheminement. Si un "lien profond" a été enregistré dans le statut de session par le moteur d''affichage, utilisez-le comme URL de destination. Sinon, allez à l''URL indiquée comme attribut de lien d''accueil pour l''application.';

wwv_flow_api.create_message (
  p_id=>195489411400151249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION22',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_cust_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Traitement de postauthentification personnalisé';

wwv_flow_api.create_message (
  p_id=>195489518111151249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CUST_POST_AUTH_PROC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action23
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Après la vérification des informations d''identification et de connexion, le moteur exécute le code suivant, qui est le traitement de postauthentification défini pour ce modèle d''authentification :';

wwv_flow_api.create_message (
  p_id=>195489609132151249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION23',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action24
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exécution en tant que bloc anonyme ne renvoyant aucune valeur.';

wwv_flow_api.create_message (
  p_id=>195489710892151250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION24',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action25
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas de code personnalisé de postauthentification dans ce modèle.';

wwv_flow_api.create_message (
  p_id=>195489823413151250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION25',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action26
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Effectuez un réacheminement vers l''URL déterminée ci-dessus. Ceci marque la fin du traitement de connexion à l''aide de la page de connexion intégrée et des API qu''elle appelle.';

wwv_flow_api.create_message (
  p_id=>195489930333151250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION26',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dans une approche classique, la page contient un panneau de connexion permettant de récupérer les informations d''identification et de connexion de l''utilisateur. Ensuite, les traitements postsoumission de la page appellent un module d''authentification pour la vérification de ces informations. Après l''authentification, la page effectue les tâches d''inscription de session et de définition de cookie ';

h:=h||'appropriées. Enfin, elle effectue un réacheminement vers la page de démarrage de l''application.';

wwv_flow_api.create_message (
  p_id=>195490016581151250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''API %0 wwv_flow_custom_auth_std peut être appelée par de tels traitements postsoumission pour effectuer les tâches qui viennent d''être décrites. Deux points d''entrée sont disponibles :';

wwv_flow_api.create_message (
  p_id=>195490118737151250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous pouvez appeler la procédure login pour que le moteur effectue toutes les tâches à votre place. Il utilisera la table des sessions intégrée et effectuera pour vous l''inscription de session et la définition de cookie. Si vous fournissez du code personnalisé dans ce modèle d''authentification, il sera exécuté avant l''authentification, au moment de l''authentification et après l''authentification.';

wwv_flow_api.create_message (
  p_id=>195490218655151250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous pouvez appeler la procédure post_login si vous effectuez l''authentification vous-même mais voulez que %0 prenne en charge toutes les tâches postauthentification à votre place. Ces deux points d''entrée vous permettent d''utiliser n''importe quelle étape intégrée de traitement de connexion avec votre propre page de connexion et avec les traitements qu''elle comporte. N''oubliez pas que, si vous uti';

h:=h||'lisez le traitement de postauthentification intégré, vous pouvez tirer parti de la sentinelle de page et du traitement de vérification de session intégrés.';

wwv_flow_api.create_message (
  p_id=>195490305952151251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Traitement de connexion externe';

wwv_flow_api.create_message (
  p_id=>195490409759151251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce modèle d''authentification n''indique ni page de connexion, ni URL cible de session non valide. De ce fait, ce cas est géré par la fonction de sentinelle de page. Il y aura peut-être réacheminement vers un portail d''accès avec connexion unique ou vers un autre serveur de connexion. En outre, le modèle d''authentification ne comporte pas de valeurs de traitement de connexion. Si ce n''est pas ce qui';

h:=h||' est prévu, modifiez le modèle d''authentification et indiquez une page ou une URL de session non valide, puis réexaminez ce diagramme de flux.';

wwv_flow_api.create_message (
  p_id=>195490503418151251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce modèle d''authentification n''indique ni page de connexion, ni URL cible de session non valide. De ce fait, ce cas est géré par la fonction de sentinelle de page. Il y aura peut-être réacheminement vers un portail d''accès avec connexion unique ou vers un autre serveur de connexion. En outre, le modèle d''authentification ne comporte pas de valeurs de traitement de connexion. Si ce n''est pas ce qui';

h:=h||' est prévu, modifiez le modèle d''authentification et indiquez une page ou une URL de session non valide, puis réexaminez ce diagramme de flux.';

wwv_flow_api.create_message (
  p_id=>195490632023151251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''URL de connexion %0 semble indiquer une page d''application %1 comme cible de session non valide. Néanmoins, le modèle d''authentification ne comporte pas de valeurs de traitement de connexion. Cette page a en charge l''exécution des étapes suivantes :';

wwv_flow_api.create_message (
  p_id=>195490701566151251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pour que le moteur %0 puisse afficher ou accepter la page de connexion de votre application, vous devez sélectionner l''attribut de page Oui - Cette page est publique dans la page des attributs de page Application Builder. Si vous ne le faites pas, le moteur tentera d''exécuter la fonction de sentinelle de page avant d''afficher la page. Si vous ne vous êtes pas encore connecté, il y aura réacheminem';

h:=h||'ent vers la même URL, et donc bouclage. Si vous codez votre propre fonction de sentinelle de page, vous devrez peut-être pouvoir déterminer si la page en cours est cette page de connexion et la gérer différemment des autres. Il vous sera peut-être possible de l''identifier par un numéro. Une technique plus générique consiste à utiliser la fonction booléenne wwv_application_custom_auth.current_page_';

h:=h||'is_public pour reconnaître l''attribut public de la page de connexion ou de toute autre page du flux.';

wwv_flow_api.create_message (
  p_id=>195490817875151251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN6',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''URL de connexion %0 semble indiquer que la page d''application %1 est la cible de session non valide. Cette page a en charge la réalisation des étapes suivantes :';

wwv_flow_api.create_message (
  p_id=>195490912489151252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN7',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les valeurs définies pour le traitement de la connexion dans le modèle d''authentification figurent ci-dessous :';

wwv_flow_api.create_message (
  p_id=>195491012078151252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN8',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On effectue un réacheminement vers cette application après l''authentification de l''utilisateur. Le point d''entrée est la procédure wwv_flow_custom_auth_sso.process_success du schéma %0. %0 est inscrit en tant qu''application partenaire Oracle Application Server Single Sign-On et peut gérer à votre place toutes les interfaces avec le serveur de connexion. Toutef';

h:=h||'ois, si vous préférez inscrire votre propre application dans votre propre schéma, c''est possible. Vous pouvez écrire votre propre sentinelle de page ou simplement créer un modèle d''authentification basé sur le modèle Portal-SSO (application partenaire = mon application) de la galerie des modèles d''authentification. Le modèle résultant appellera la sentinelle de page SSO intégrée sentry wwv_flow_cu';

h:=h||'stom_auth_std.portal_sso_sentry_v1. Pour cette fonction, le modèle d''authentification en cours doit connaître le nom de votre application partenaire, sous lequel elle est inscrite auprès d''Oracle Application Server Single Sign-On. Vous pouvez l''indiquer lorsque l''assistant Création de modèle d''authentification vous le demande, ou bien vous pouvez l''ajouter ou le modifier en modifiant le modèle apr';

h:=h||'ès sa création. Le nom saisi doit être strictement identique au nom inscrit, y compris en ce qui concerne la casse. Vous devrez également écrire votre propre procédure de récepteur URLC et y appeler l''API wwv_flow_custom_auth_sso.process_success, en lui transmettant le nom de votre application sous lequel elle est inscrite auprès d''Oracle Application Server Single Sign-On. Ainsi, la session sera i';

h:=h||'nscrite auprès de %0 après l''authentification. Si vous écrivez votre propre sentinelle de page, vous pouvez y appeler l''API wwv_flow_custom_auth_sso.portal_sso_redirect pour effectuer le réacheminement vers le serveur de connexion lorsque l''authentification est requise. Vous devez transmettre à cette procédure le nom inscrit de votre application partenaire. Pour plus de détails, consultez la docum';

h:=h||'entation %0 et la documentation %1.';

wwv_flow_api.create_message (
  p_id=>195491117683151252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN9',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''URL de connexion %0 ne semble pas indiquer la page d''application %1 comme cible de session non valide. En outre, le modèle d''authentification ne comporte pas de valeurs de traitement de connexion. Cette page a en charge la réalisation des étapes suivantes :';

wwv_flow_api.create_message (
  p_id=>195491229315151252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN12',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notez que, à moins que les services appelés à cette URL n''utilisent l''API wwv_custom_auth_std %0 pour une assistance dans les tâches d''inscription de session, votre application ne pourra pas utiliser la sentinelle de page ou le traitement de vérification de session intégrés. Vous devrez effectuer ce travail par vos propres moyens.';

wwv_flow_api.create_message (
  p_id=>195491309674151252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN13',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_pre_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Traitement de préauthentification';

wwv_flow_api.create_message (
  p_id=>195491407197151252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_PRE_AUTH_PROC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Traitement de postauthentification';

wwv_flow_api.create_message (
  p_id=>195491528439151253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_POST_AUTH_PROC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''URL de connexion %0 ne semble pas indiquer une page d''application %1 comme cible de session non valide. Cette page a en charge la réalisation des étapes suivantes :';

wwv_flow_api.create_message (
  p_id=>195491628973151253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN14',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les valeurs définies pour le traitement de la connexion dans le modèle d''authentification figurent ci-dessous :';

wwv_flow_api.create_message (
  p_id=>195491728267151253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN15',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page de connexion indiquée dans ce modèle est la page [%0] de cette application. Cette page a en charge la réalisation des étapes suivantes :';

wwv_flow_api.create_message (
  p_id=>195491824118151253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN16',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Toutefois, il n''y a pas de valeurs de traitement de connexion dans le modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195491914721151253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN17',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette page étant la page de connexion de l''application, il n''est pas possible d''y effectuer certaines actions lors de son premier affichage, car l''authentification de l''utilisateur n''a pas encore eu lieu. En outre, le statut de session et certaines variables d''identification de session ne sont pas disponibles pour les calculs et traitements de la page, comme ils le seraient dans des pages ordinair';

h:=h||'es traitées après l''authentification. Pour toutes ces raisons, la désignation d''une page de connexion par un numéro dans un modèle d''authentification ne convient que pour les pages comportant peu de fonctionnalités ou aucune autre fonctionnalité que le traitement du panneau de connexion. Si vous voulez une page de connexion plus active, indiquez une URL de connexion dans l''assistant Modèle d''authe';

h:=h||'ntification ou dans la page de modification. Du moment que vous affectez à l''attribut de page publique la valeur Oui - Cette page est publique dans le panneau des attributs de page Application Builder, la page de connexion peut utiliser toutes les fonctionnalités de %0 et non servir seulement de page de connexion dans votre application.';

wwv_flow_api.create_message (
  p_id=>195492018735151253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN18',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p817_refresh_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la régénération des modèles d''authentification.';

wwv_flow_api.create_message (
  p_id=>195492122271151254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P817_REFRESH_AUTH_SCHEME_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès avec connexion unique SSO (utilisation Oracle uniquement)';

wwv_flow_api.create_message (
  p_id=>195492220682151254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (application partenaire = %0)';

wwv_flow_api.create_message (
  p_id=>195492332411151254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (application partenaire = mon application)';

wwv_flow_api.create_message (
  p_id=>195492432411151254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion intégrée : Utiliser les informations d''identification et de connexion du compte %0';

wwv_flow_api.create_message (
  p_id=>195492512242151254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion intégrée : Informations d''identification et de connexion porte ouverte';

wwv_flow_api.create_message (
  p_id=>195492619484151254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE5',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion intégrée : Utiliser les informations d''identification et de connexion de l''annuaire LDAP';

wwv_flow_api.create_message (
  p_id=>195492703463151255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Basé sur un modèle d''authentification de la galerie';

wwv_flow_api.create_message (
  p_id=>195492808894151255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE7',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_obj_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 (%1) introuvable pour copie';

wwv_flow_api.create_message (
  p_id=>195492925134151255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.OBJ_NOT_FOUND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_cannot_find_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de déterminer l''ID de groupe de sécurité pour l''ID d''espace de travail indiqué = "%0"'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195493017798151255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.CANNOT_FIND_SGID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_remove_last_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne pouvez pas utiliser cette fonctionnalité pour supprimer le dernier schéma d''un espace de travail.';

wwv_flow_api.create_message (
  p_id=>195493115186151255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REMOVE_LAST_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_reserved_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de réinitialiser le mot de passe pour le schéma %0';

wwv_flow_api.create_message (
  p_id=>195493226347151255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_RESERVED_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La réinitialisation du mot de passe pour un schéma qui n''est pas associé à votre espace de travail n''est pas autorisée. %0';

wwv_flow_api.create_message (
  p_id=>195493331886151255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nom utilisateur %0 n''existe pas dans l''espace de travail %1';

wwv_flow_api.create_message (
  p_id=>195493408170151256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_COMPANY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_page_dev_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le développeur n''est pas autorisé à créer un composant sur cette page.';

wwv_flow_api.create_message (
  p_id=>195493529014151256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_PAGE_DEV_PRIV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune mise en page d''état sélectionnée';

wwv_flow_api.create_message (
  p_id=>195493607565151256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LAYOUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''espace de travail inconnu';

wwv_flow_api.create_message (
  p_id=>195493704641151256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unhandled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le moteur d''affichage n''a pas réussi à interpréter le document WSDL. Cliquez sur Créer manuellement une référence de service Web pour continuer la création d''une référence pour ce service.';

wwv_flow_api.create_message (
  p_id=>195493814428151256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNHANDLED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_last_extended
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dernière extension de l''API :';

wwv_flow_api.create_message (
  p_id=>195493913525151256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_LAST_EXTENDED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_current_flows_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Votre version en cours :';

wwv_flow_api.create_message (
  p_id=>195494021868151257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.CURRENT_FLOWS_VERSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_import_compatible_with_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cet import est incompatible avec la version :';

wwv_flow_api.create_message (
  p_id=>195494102435151257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.IMPORT_COMPATIBLE_WITH_VERSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_missing_export_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Votre import d''application n''indique pas de version d''export.';

wwv_flow_api.create_message (
  p_id=>195494231501151257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.MISSING_EXPORT_VERSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_engine_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''a pas été possible d''établir la version de votre moteur.';

wwv_flow_api.create_message (
  p_id=>195494325555151257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_ENGINE_VERSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_api_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''a pas été possible d''établir la dernière version d''API de votre moteur.';

wwv_flow_api.create_message (
  p_id=>195494431551151257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_API_VERSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_upgrade_needed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous allez devoir effectuer une mise à niveau pour pouvoir importer cet export d''application.';

wwv_flow_api.create_message (
  p_id=>195494514007151257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UPGRADE_NEEDED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_invalid_credentials
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Combinaison nom utilisateur, mot de passe et espace de travail non valide';

wwv_flow_api.create_message (
  p_id=>195494603195151258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.INVALID_CREDENTIALS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_user_not_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''utilisateur %0 a besoin du privilège ADMIN pour réaliser cette opération.';

wwv_flow_api.create_message (
  p_id=>195494709012151258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.USER_NOT_ADMIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set_import
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La variable de package g_security_group_id doit être définie pour l''import d''une application.';

wwv_flow_api.create_message (
  p_id=>195494811635151258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET_IMPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La procédure %0 a été appelée sans valeur pour p_id -- un ID d''application doit être indiqué.';

wwv_flow_api.create_message (
  p_id=>195494923656151258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_MISSING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_not_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''application %0 n''a pas été supprimée. L''import ne va pas être tenté.';

wwv_flow_api.create_message (
  p_id=>195495021207151258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_NOT_DELETED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_templ_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du nom de modèle %0';

wwv_flow_api.create_message (
  p_id=>195495114871151258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TEMPL_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du nom d''option de construction %0';

wwv_flow_api.create_message (
  p_id=>195495211835151259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la définition de l''ID d''option de construction "%0"';

wwv_flow_api.create_message (
  p_id=>195495328768151259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID de barre de navigation %0';

wwv_flow_api.create_message (
  p_id=>195495427574151259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID d''élément de barre de navigation %0';

wwv_flow_api.create_message (
  p_id=>195495522129151259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_ITEM_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID de processus d''application = "%0"';

wwv_flow_api.create_message (
  p_id=>195495608152151259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_PROCESS_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_process_sql_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la définition de l''ID de SQL de traitement "%0"';

wwv_flow_api.create_message (
  p_id=>195495716201151260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PROCESS_SQL_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID d''élément d''application %0';

wwv_flow_api.create_message (
  p_id=>195495823036151260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_ITEM_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''élément de calcul d''application %0';

wwv_flow_api.create_message (
  p_id=>195495930446151260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_COMPUTATION_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_std_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID d''onglet standard %0';

wwv_flow_api.create_message (
  p_id=>195496030506151260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_STD_TAB_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_tabset_rename
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors du changement de nom de l''onglet, de %1 en %0';

wwv_flow_api.create_message (
  p_id=>195496119364151260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TABSET_RENAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_parent_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID d''onglet parent %0';

wwv_flow_api.create_message (
  p_id=>195496230726151260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PARENT_TAB_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lov_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID de liste de valeurs (LOV) %0';

wwv_flow_api.create_message (
  p_id=>195496330213151261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LOV_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du nom de page "%0", ID "%1"';

wwv_flow_api.create_message (
  p_id=>195496420600151261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_help_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du texte d''aide %0 de la page :';

wwv_flow_api.create_message (
  p_id=>195496501031151261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HELP_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_name_upd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la mise à jour du nom de page "%0", ID "%1"';

wwv_flow_api.create_message (
  p_id=>195496631255151261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_NAME_UPD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_button_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du nom de bouton "%0", ID "%1"';

wwv_flow_api.create_message (
  p_id=>195496729274151261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUTTON_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID de branchement %0';

wwv_flow_api.create_message (
  p_id=>195496804732151261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_args_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID d''arguments de branchement "%0"';

wwv_flow_api.create_message (
  p_id=>195496911419151262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_ARGS_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur page %0, élément "%1", ID "%2"';

wwv_flow_api.create_message (
  p_id=>195497003333151262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ITEM_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de la page de calcul de page %0, élément %1, ID "%2"';

wwv_flow_api.create_message (
  p_id=>195497104184151262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_COMPUTATION_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_validation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de la page de validation de page %0, nom %1';

wwv_flow_api.create_message (
  p_id=>195497202995151262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_VALIDATION_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de la page de traitement de page %0, nom %1';

wwv_flow_api.create_message (
  p_id=>195497306102151262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_PROCESS_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lang_map_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du mapping de traduction d''application';

wwv_flow_api.create_message (
  p_id=>195497423844151262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LANG_MAP_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_on_table_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer une page sur la table "%0"';

wwv_flow_api.create_message (
  p_id=>195497520751151262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ON_TABLE_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type d''état non valide';

wwv_flow_api.create_message (
  p_id=>195497630179151263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INVALID_REPORT_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page d''état %0 existe, une région d''état a été ajoutée.';

wwv_flow_api.create_message (
  p_id=>195497702676151263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_has_buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page %0 comporte déjà des boutons.';

wwv_flow_api.create_message (
  p_id=>195497804467151263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HAS_BUTTONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_form_added_to_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Panneau ajouté à la page existante %0 .';

wwv_flow_api.create_message (
  p_id=>195497931307151263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FORM_ADDED_TO_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page %0 n''a pas été créée car elle existe déjà.';

wwv_flow_api.create_message (
  p_id=>195498003053151263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_bug_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID de bug "%0"';

wwv_flow_api.create_message (
  p_id=>195498126300151263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUG_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_shortcut_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création de l''ID de raccourci "%0"';

wwv_flow_api.create_message (
  p_id=>195498201798151264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_SHORTCUT_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_auth_scheme_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du nom de modèle d''authentification %0';

wwv_flow_api.create_message (
  p_id=>195498319446151264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_AUTH_SCHEME_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La variable de package g_security_group_id doit être définie.';

wwv_flow_api.create_message (
  p_id=>195498407636151264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''ID d''application %0 est réservé à Oracle Corporation ';

wwv_flow_api.create_message (
  p_id=>195498531473151264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_RESERVED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_runtime_incompatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''utilisation de l''API inclut des appels qui sont incompatibles avec le runtime en cours.';

wwv_flow_api.create_message (
  p_id=>195498622707151265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_RUNTIME_INCOMPATIBLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'COMPATIBLE (vous devriez pouvoir exécuter cet import sans problèmes)';

wwv_flow_api.create_message (
  p_id=>195498732432151265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.COMPATIBLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_not_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'NON COMPATIBLE (il se peut que votre export contienne des appels non pris en charge par votre version de %0.)';

wwv_flow_api.create_message (
  p_id=>195498820238151265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.NOT_COMPATIBLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline_plus_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Incorporation+Notification';

wwv_flow_api.create_message (
  p_id=>195498903862151265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE_PLUS_NOTIFICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Incorporation';

wwv_flow_api.create_message (
  p_id=>195499032513151265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notification';

wwv_flow_api.create_message (
  p_id=>195499118348151265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_error_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''erreurs';

wwv_flow_api.create_message (
  p_id=>195499227403151266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ERROR_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_location
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Emplacement';

wwv_flow_api.create_message (
  p_id=>195499303559151266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOCATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_above_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Au-dessus de la boîte';

wwv_flow_api.create_message (
  p_id=>195499405197151266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.ABOVE_BOX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_below_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Au-dessous de la boîte';

wwv_flow_api.create_message (
  p_id=>195499524014151266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BELOW_BOX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'En bas';

wwv_flow_api.create_message (
  p_id=>195499631748151266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BOTTOM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Changement de modèle';

wwv_flow_api.create_message (
  p_id=>195499725876151266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CHANGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fermeture de modèle';

wwv_flow_api.create_message (
  p_id=>195499802366151267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CLOSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copie de modèle';

wwv_flow_api.create_message (
  p_id=>195499915362151267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_COPY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Création de modèle';

wwv_flow_api.create_message (
  p_id=>195500004101151267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suppression de modèle';

wwv_flow_api.create_message (
  p_id=>195500130912151267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_DELETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modification de modèle';

wwv_flow_api.create_message (
  p_id=>195500221868151267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Développement de modèle';

wwv_flow_api.create_message (
  p_id=>195500307392151268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EXPAND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle suivant';

wwv_flow_api.create_message (
  p_id=>195500422590151268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_NEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle précédent';

wwv_flow_api.create_message (
  p_id=>195500517978151268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_PREVIOUS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Haut';

wwv_flow_api.create_message (
  p_id=>195500628748151268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.TOP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement sur une acceptation de page';

wwv_flow_api.create_message (
  p_id=>195500727518151268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_ACCEPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement sur une page identifiée par un élément';

wwv_flow_api.create_message (
  p_id=>195500803718151268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_IDENTIFIED_BY_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_url_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement sur une URL identifiée par un élément';

wwv_flow_api.create_message (
  p_id=>195500904603151269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_URL_IDENTIFIED_BY_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement sur une fonction renvoyant une page';

wwv_flow_api.create_message (
  p_id=>195501007775151269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement sur une fonction renvoyant une URL';

wwv_flow_api.create_message (
  p_id=>195501109620151269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_URL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement sur une procédure PL/SQL';

wwv_flow_api.create_message (
  p_id=>195501219760151269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PLSQL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aucun';

wwv_flow_api.create_message (
  p_id=>195501315584151269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_unconditional
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inconditionnel';

wwv_flow_api.create_message (
  p_id=>195501424219151270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_UNCONDITIONAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_standard_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'condition standard';

wwv_flow_api.create_message (
  p_id=>195501527350151270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STANDARD_CONDITION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'jamais';

wwv_flow_api.create_message (
  p_id=>195501617683151270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NEVER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4656_default_calendar_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de calendrier par défaut';

wwv_flow_api.create_message (
  p_id=>195501707336151270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4656.DEFAULT_CALENDAR_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendrier';

wwv_flow_api.create_message (
  p_id=>195501801049151270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_no_ddl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun %0 trouvé pour la génération de DDL.';

wwv_flow_api.create_message (
  p_id=>195501913710151270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.NO_DDL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit_report_err_updating_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la mise à jour des colonnes d''état : %0';

wwv_flow_api.create_message (
  p_id=>195502032212151271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_EDIT_REPORT.ERR_UPDATING_COLS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace_colon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''espace de travail inconnu : %0';

wwv_flow_api.create_message (
  p_id=>195502129617151271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_migrate_svg_to_flash_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la migration du graphique SVG vers le graphique Flash. %0';

wwv_flow_api.create_message (
  p_id=>195502218433151271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MIGRATE_SVG_TO_FLASH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_to_flash
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la migration du graphique SVG vers un graphique Flash. Confirmez votre demande.';

wwv_flow_api.create_message (
  p_id=>195502330842151271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_TO_FLASH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''exécution de l''instruction a échoué. %0'||chr(10)||
'<pre>%1</pre>';

wwv_flow_api.create_message (
  p_id=>195502403191151271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.RUN_STMT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur GET_STMT. %0';

wwv_flow_api.create_message (
  p_id=>195502525583151272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_STMT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur GET_BLOCK. %0';

wwv_flow_api.create_message (
  p_id=>195502624499151272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_BLOCK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_file_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de trouver le fichier. %0';

wwv_flow_api.create_message (
  p_id=>195502707653151272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_FILE_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_date_picker
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sélecteur de date';

wwv_flow_api.create_message (
  p_id=>195502827686151272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DATE_PICKER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Masqué';

wwv_flow_api.create_message (
  p_id=>195502931021151272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.HIDDEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_file_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exploration de fichiers';

wwv_flow_api.create_message (
  p_id=>195503025399151272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.FILE_BROWSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_stop_and_start_html_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Arrêter et démarrer une table';

wwv_flow_api.create_message (
  p_id=>195503109225151272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.STOP_AND_START_HTML_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_list_manager
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gestionnaire de liste';

wwv_flow_api.create_message (
  p_id=>195503225920151273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.LIST_MANAGER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_check_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Case à cocher';

wwv_flow_api.create_message (
  p_id=>195503309864151273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.CHECK_BOX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_display_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher uniquement';

wwv_flow_api.create_message (
  p_id=>195503404071151273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DISPLAY_ONLY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_multiple_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sélection multiple';

wwv_flow_api.create_message (
  p_id=>195503521155151273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.MULTIPLE_SELECT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_popup_list_of_values
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste de valeurs (LOV) instantanée';

wwv_flow_api.create_message (
  p_id=>195503611941151273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.POPUP_LIST_OF_VALUES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_radio
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bouton d''option';

wwv_flow_api.create_message (
  p_id=>195503721289151273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.RADIO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste SELECT';

wwv_flow_api.create_message (
  p_id=>195503813147151274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SELECT_LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte';

wwv_flow_api.create_message (
  p_id=>195503917880151274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text_area
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zone de texte';

wwv_flow_api.create_message (
  p_id=>195504013633151274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT_AREA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_shuttle
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navette';

wwv_flow_api.create_message (
  p_id=>195504121058151274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SHUTTLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copy_list_entry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copier une entrée de liste';

wwv_flow_api.create_message (
  p_id=>195504219093151274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPY_LIST_ENTRY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne disposez pas de privilèges sur le schéma %0.';

wwv_flow_api.create_message (
  p_id=>195504319016151274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_PRIV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_images_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune image n''a été trouvée.';

wwv_flow_api.create_message (
  p_id=>195504413783151275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_IMAGES_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès non autorisé (variable de package de groupe de sécurité non définie).';

wwv_flow_api.create_message (
  p_id=>195504525164151275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_SGID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_user_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le groupe d''utilisateurs n''a pas été créé car il existe déjà.';

wwv_flow_api.create_message (
  p_id=>195504608558151275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_USER_GROUP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''espace de travail n''a pas été créé car il existe déjà.';

wwv_flow_api.create_message (
  p_id=>195504718032151275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_COMPANY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''utilisateur n''a pas été créé pour la raison suivante : %0';

wwv_flow_api.create_message (
  p_id=>195504805391151275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_FND_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_user_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''utilisateur %0 n''existe pas.';

wwv_flow_api.create_message (
  p_id=>195504903966151276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_USER_EXIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''utilisateur %0 n''a pas indiqué d''adresse électronique.';

wwv_flow_api.create_message (
  p_id=>195505032320151276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_EMAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_fetch_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''extraire les informations utilisateur FND. %0';

wwv_flow_api.create_message (
  p_id=>195505111589151276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.FETCH_FND_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur de format de total de contrôle de message de notification : %0';

wwv_flow_api.create_message (
  p_id=>195505208643151276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur de contenu de total de contrôle de message de notification : %0 : %1';

wwv_flow_api.create_message (
  p_id=>195505305521151276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur de format de total de contrôle de message de succès d''impression : %0';

wwv_flow_api.create_message (
  p_id=>195505409685151276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur de contenu de total de contrôle de message de succès d''impression : %0 : %1';

wwv_flow_api.create_message (
  p_id=>195505513839151277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''application de démonstration %0 a été créée.';

wwv_flow_api.create_message (
  p_id=>195505611654151277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_SUCCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas assez d''espace pour créer cette démonstration. Demandez de l''espace supplémentaire en allant dans la page d''administration et en cliquant sur le ligne Demander des modifications du service en cours.';

wwv_flow_api.create_message (
  p_id=>195505707347151277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4150_column_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne %0';

wwv_flow_api.create_message (
  p_id=>195505817296151277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4150_COLUMN_NUMBER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message cached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mis en mémoire cache';

wwv_flow_api.create_message (
  p_id=>195505921891151277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valide';

wwv_flow_api.create_message (
  p_id=>195506010102151277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expiré';

wwv_flow_api.create_message (
  p_id=>195506128106151277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXPIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Activé';

wwv_flow_api.create_message (
  p_id=>195506200474151278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ENABLED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mettre le type en évidence';

wwv_flow_api.create_message (
  p_id=>195506313348151278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cell
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cellule';

wwv_flow_api.create_message (
  p_id=>195506409540151278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CELL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_bgcolor
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Couleur d''arrière-plan';

wwv_flow_api.create_message (
  p_id=>195506531211151278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BGCOLOR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yellow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'jaune';

wwv_flow_api.create_message (
  p_id=>195506624272151279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YELLOW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_green
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vert';

wwv_flow_api.create_message (
  p_id=>195506707643151279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_GREEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_orange
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'orange';

wwv_flow_api.create_message (
  p_id=>195506801665151279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ORANGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_text_color
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Couleur du texte';

wwv_flow_api.create_message (
  p_id=>195506920761151279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TEXT_COLOR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_when
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mettre en évidence lorsque';

wwv_flow_api.create_message (
  p_id=>195507002347151279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_WHEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'est semblable à';

wwv_flow_api.create_message (
  p_id=>195507109941151279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_LIKE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'n''est pas semblable à';

wwv_flow_api.create_message (
  p_id=>195507207723151279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_LIKE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'est NULL';

wwv_flow_api.create_message (
  p_id=>195507325666151280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'n''est pas NULL';

wwv_flow_api.create_message (
  p_id=>195507420847151280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NOT_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'dans';

wwv_flow_api.create_message (
  p_id=>195507500414151280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'n''est pas dans';

wwv_flow_api.create_message (
  p_id=>195507603704151280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_IN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enregistrer';

wwv_flow_api.create_message (
  p_id=>195507711895151280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_ascending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Croissant';

wwv_flow_api.create_message (
  p_id=>195507831575151281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ASCENDING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_descending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Décroissant';

wwv_flow_api.create_message (
  p_id=>195507917019151281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCENDING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Sélectionner une catégorie -';

wwv_flow_api.create_message (
  p_id=>195508017121151281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_CATEGORY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195508108555151281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Séquence';

wwv_flow_api.create_message (
  p_id=>195508231617151281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SEQUENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oui';

wwv_flow_api.create_message (
  p_id=>195508303085151281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non';

wwv_flow_api.create_message (
  p_id=>195508413426151282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ligne';

wwv_flow_api.create_message (
  p_id=>195508528976151282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_blue
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'bleu';

wwv_flow_api.create_message (
  p_id=>195508627990151282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BLUE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_red
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'rouge';

wwv_flow_api.create_message (
  p_id=>195508724867151282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Affiché';

wwv_flow_api.create_message (
  p_id=>195508825681151282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Autre';

wwv_flow_api.create_message (
  p_id=>195508906957151282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_OTHER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur';

wwv_flow_api.create_message (
  p_id=>195509019772151283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VALUE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne';

wwv_flow_api.create_message (
  p_id=>195509106111151283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Annuler';

wwv_flow_api.create_message (
  p_id=>195509214477151283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CANCEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Supprimer';

wwv_flow_api.create_message (
  p_id=>195509317506151283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Sélectionner une colonne -';

wwv_flow_api.create_message (
  p_id=>195509417152151283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''installeur d''application a détecté que les objets de prise en charge de cette application ont déjà été installés. Cet assistant vous guidera tout au long du processus de mise à niveau de ces objets.';

wwv_flow_api.create_message (
  p_id=>195509510765151283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message caching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mise en mémoire cache';

wwv_flow_api.create_message (
  p_id=>195509610026151284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement=';

wwv_flow_api.create_message (
  p_id=>195509719168151284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.BRANCH=',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_menu_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entrée d''historique des accès=';

wwv_flow_api.create_message (
  p_id=>195509802174151284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.MENU_OPTION=',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les objets de prise en charge de votre application ont été mis à niveau.';

wwv_flow_api.create_message (
  p_id=>195509924256151284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_SUCCESS_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La mise à niveau des objets de prise en charge de cette application a échoué.';

wwv_flow_api.create_message (
  p_id=>195510023402151284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_FAILURE_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_confirm_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Confirmez que vous souhaitez mettre à niveau les objets de prise en charge de cette application.';

wwv_flow_api.create_message (
  p_id=>195510109859151284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_CONFIRM_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message yes_by_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oui, par utilisateur';

wwv_flow_api.create_message (
  p_id=>195510214482151285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YES_BY_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message set_binds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les valeurs de toutes les variables attachées (bind variables) doivent être définies lors du test d''une interrogation.';

wwv_flow_api.create_message (
  p_id=>195510302350151285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SET_BINDS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion nouvellement créée : utiliser les informations d''identification et de connexion de l''annuaire LDAP';

wwv_flow_api.create_message (
  p_id=>195510416733151285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6A',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion existante : utiliser les informations d''identification et de connexion LDAP';

wwv_flow_api.create_message (
  p_id=>195510529939151285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6B',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion nouvellement créée : utiliser les informations d''identification et de connexion du compte %0';

wwv_flow_api.create_message (
  p_id=>195510604676151285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4A',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion existante : utiliser les informations d''identification et de connexion du compte %0';

wwv_flow_api.create_message (
  p_id=>195510722734151285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4B',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_flash_chart_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de graphique Flash : %0';

wwv_flow_api.create_message (
  p_id=>195510809131151286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.FLASH_CHART_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message report_queries_valid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''interrogation est valide. Les variables attachées (bind variables) ont été analysées.';

wwv_flow_api.create_message (
  p_id=>195510919674151286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REPORT_QUERIES.VALID_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune page sélectionnée.';

wwv_flow_api.create_message (
  p_id=>195511031791151286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page';

wwv_flow_api.create_message (
  p_id=>195511130384151286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer';

wwv_flow_api.create_message (
  p_id=>195511218337151286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CREATE_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier';

wwv_flow_api.create_message (
  p_id=>195511313415151286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EDIT_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_copy_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copier';

wwv_flow_api.create_message (
  p_id=>195511421554151287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COPY_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_view_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vue';

wwv_flow_api.create_message (
  p_id=>195511527676151287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VIEW_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page introuvable.';

wwv_flow_api.create_message (
  p_id=>195511613178151287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195511722276151287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre';

wwv_flow_api.create_message (
  p_id=>195511822362151287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias';

wwv_flow_api.create_message (
  p_id=>195511903695151287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ALIAS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle';

wwv_flow_api.create_message (
  p_id=>195512002800151288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_invalid_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle non valide';

wwv_flow_api.create_message (
  p_id=>195512122099151288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INVALID_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets standard';

wwv_flow_api.create_message (
  p_id=>195512211792151288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TABSET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authorization
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Autorisation';

wwv_flow_api.create_message (
  p_id=>195512327697151288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHORIZATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Option de construction';

wwv_flow_api.create_message (
  p_id=>195512411779151288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BUILD_OPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentification';

wwv_flow_api.create_message (
  p_id=>195512521103151288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHENTICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Public';

wwv_flow_api.create_message (
  p_id=>195512626751151289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_PUBLIC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Obligatoire';

wwv_flow_api.create_message (
  p_id=>195512730587151289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_REQUIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Régions';

wwv_flow_api.create_message (
  p_id=>195512801545151289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display_pt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Point&nbsp;d''affichage&nbsp;';

wwv_flow_api.create_message (
  p_id=>195512901376151289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY_PT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page "%0" ne comporte pas de régions.';

wwv_flow_api.create_message (
  p_id=>195513030536151433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Boutons';

wwv_flow_api.create_message (
  p_id=>195513127017151433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eléments';

wwv_flow_api.create_message (
  p_id=>195513211511151433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calculs';

wwv_flow_api.create_message (
  p_id=>195513303551151433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page 0 n''admet pas les calculs. Les calculs à effectuer dans chaque page doivent être gérés au niveau application.';

wwv_flow_api.create_message (
  p_id=>195513427754151433 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page 0 n''admet pas les processus. Les processus à exécuter dans chaque page doivent être gérés au niveau application.';

wwv_flow_api.create_message (
  p_id=>195513507067151434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas de calculs de chargement (Onload) pour la page "%0".';

wwv_flow_api.create_message (
  p_id=>195513623278151434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_COMPUTATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Processus';

wwv_flow_api.create_message (
  p_id=>195513717741151434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas de processus de chargement (Onload) pour la page "%0".';

wwv_flow_api.create_message (
  p_id=>195513804203151434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_zero_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page 0 n''admet ni les branchements, ni les calculs, ni les processus, ni les validations. Les calculs et les processus à exécuter dans chaque page doivent être gérés au niveau application.';

wwv_flow_api.create_message (
  p_id=>195513920753151434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ZERO_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas de calculs à la soumission (onSubmit) pour la page "%0".';

wwv_flow_api.create_message (
  p_id=>195514017929151434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_COMPUTATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validations';

wwv_flow_api.create_message (
  p_id=>195514115598151435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page "%0" ne comporte pas de validations.';

wwv_flow_api.create_message (
  p_id=>195514206092151435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas de processus à la soumission (onSubmit) pour la page "%0".';

wwv_flow_api.create_message (
  p_id=>195514311974151435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement';

wwv_flow_api.create_message (
  p_id=>195514424678151435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCHING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page "%0" ne comporte pas de branchements.';

wwv_flow_api.create_message (
  p_id=>195514515978151435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BRANCHING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Onglets parent';

wwv_flow_api.create_message (
  p_id=>195514601196151435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PARENT_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun onglet de niveau parent';

wwv_flow_api.create_message (
  p_id=>195514723468151435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PARENT_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Onglets&nbsp;standard';

wwv_flow_api.create_message (
  p_id=>195514808307151436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STD_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets';

wwv_flow_api.create_message (
  p_id=>195514927525151436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page %0 ne comporte pas de jeu d''onglets.';

wwv_flow_api.create_message (
  p_id=>195515000187151436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Barre&nbsp;de&nbsp;navigation';

wwv_flow_api.create_message (
  p_id=>195515101705151436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAV_BAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''application "%0" ne comporte pas de barre de navigation.';

wwv_flow_api.create_message (
  p_id=>195515216250151436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_NAV_BAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message region_templates_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun modèle';

wwv_flow_api.create_message (
  p_id=>195515322814151436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGION_TEMPLATES_NO_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune page sélectionnée.';

wwv_flow_api.create_message (
  p_id=>195515415202151437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune région';

wwv_flow_api.create_message (
  p_id=>195515519890151437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun calcul';

wwv_flow_api.create_message (
  p_id=>195515606768151437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_COMPUTATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun processus';

wwv_flow_api.create_message (
  p_id=>195515716743151437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune validation';

wwv_flow_api.create_message (
  p_id=>195515806192151437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun branchement';

wwv_flow_api.create_message (
  p_id=>195515916935151437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_BRANCHING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'avertissement';

wwv_flow_api.create_message (
  p_id=>195516008442151437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_WARNING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer une région';

wwv_flow_api.create_message (
  p_id=>195516110595151438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un processus';

wwv_flow_api.create_message (
  p_id=>195516214728151438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un calcul';

wwv_flow_api.create_message (
  p_id=>195516301646151438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPUTATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer une validation';

wwv_flow_api.create_message (
  p_id=>195516432448151438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un branchement';

wwv_flow_api.create_message (
  p_id=>195516505541151438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BRANCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer une région';

wwv_flow_api.create_message (
  p_id=>195516613193151438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un calcul';

wwv_flow_api.create_message (
  p_id=>195516716594151439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_COMPUTATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un processus';

wwv_flow_api.create_message (
  p_id=>195516827383151439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer une validation';

wwv_flow_api.create_message (
  p_id=>195516910823151439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un branchement';

wwv_flow_api.create_message (
  p_id=>195517029502151439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BRANCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Votre mot de passe pour %0 a été modifié.';

wwv_flow_api.create_message (
  p_id=>195517124477151439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_CHANGED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message email_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''adresse électronique "%0" est introuvable.';

wwv_flow_api.create_message (
  p_id=>195517218986151439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EMAIL_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message change_pw_request
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demande %0';

wwv_flow_api.create_message (
  p_id=>195517321033151440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHANGE_PW_REQUEST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vers le bas';

wwv_flow_api.create_message (
  p_id=>195517409735151440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ARROW_DOWN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un bouton';

wwv_flow_api.create_message (
  p_id=>195517527253151440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un élément';

wwv_flow_api.create_message (
  p_id=>195517603656151440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'titre de région';

wwv_flow_api.create_message (
  p_id=>195517718795151440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un bouton';

wwv_flow_api.create_message (
  p_id=>195517811592151440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'modifier un bouton';

wwv_flow_api.create_message (
  p_id=>195517923796151440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer un élément';

wwv_flow_api.create_message (
  p_id=>195518000244151441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'modifier un bouton';

wwv_flow_api.create_message (
  p_id=>195518110029151441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'modifier un élément';

wwv_flow_api.create_message (
  p_id=>195518227216151441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_on_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''espace de travail %0 n''est pas autorisé à effectuer une analyse en tant que schéma %1.';

wwv_flow_api.create_message (
  p_id=>195518318060151441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ON_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button_w_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Boutons sans régions';

wwv_flow_api.create_message (
  p_id=>195518425608151441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON_W_NO_REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page "%0" ne comporte pas de boutons.';

wwv_flow_api.create_message (
  p_id=>195518517030151441 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BUTTON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page "%0" ne comporte pas d''éléments.';

wwv_flow_api.create_message (
  p_id=>195518628299151442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item_exceeds_max
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nombre d''éléments est supérieur au maximum, qui est 100.';

wwv_flow_api.create_message (
  p_id=>195518711161151442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM_EXCEEDS_MAX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de région';

wwv_flow_api.create_message (
  p_id=>195518805226151442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier';

wwv_flow_api.create_message (
  p_id=>195518903779151442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_reset_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notification de réinitialisation du mot de passe';

wwv_flow_api.create_message (
  p_id=>195519023532151442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_RESET_NOTIFICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Développer';

wwv_flow_api.create_message (
  p_id=>195519125543151442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EXPAND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_has_been_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Votre compte %0 a été créé.';

wwv_flow_api.create_message (
  p_id=>195519206932151443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_HAS_BEEN_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_login_instructions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous pouvez vous connecter à %0 en accédant à :';

wwv_flow_api.create_message (
  p_id=>195519319169151443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_LOGIN_INSTRUCTIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer';

wwv_flow_api.create_message (
  p_id=>195519400405151443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notification du nouveau compte %0';

wwv_flow_api.create_message (
  p_id=>195519529095151443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_NOTIFICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer';

wwv_flow_api.create_message (
  p_id=>195519622623151443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fermer';

wwv_flow_api.create_message (
  p_id=>195519708269151443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CLOSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Corps de région';

wwv_flow_api.create_message (
  p_id=>195519800201151443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ouverture de panneau';

wwv_flow_api.create_message (
  p_id=>195519903981151444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_OPEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fermeture de panneau';

wwv_flow_api.create_message (
  p_id=>195520013712151444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_CLOSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aide';

wwv_flow_api.create_message (
  p_id=>195520103290151444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Supprimer';

wwv_flow_api.create_message (
  p_id=>195520201556151444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_DELETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copier';

wwv_flow_api.create_message (
  p_id=>195520328077151444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COPY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suivant';

wwv_flow_api.create_message (
  p_id=>195520402213151445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Précédent';

wwv_flow_api.create_message (
  p_id=>195520513315151445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PREVIOUS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modification';

wwv_flow_api.create_message (
  p_id=>195520625273151445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CHANGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle';

wwv_flow_api.create_message (
  p_id=>195520723925151445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Thèmes';

wwv_flow_api.create_message (
  p_id=>195520805729151445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEMES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Barre de navigation';

wwv_flow_api.create_message (
  p_id=>195520929540151445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NAV_BAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notification';

wwv_flow_api.create_message (
  p_id=>195521004700151445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NOTIFICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_global_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notification globale';

wwv_flow_api.create_message (
  p_id=>195521126157151446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_GLOBAL_NOTIFICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_template_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Corps de modèle';

wwv_flow_api.create_message (
  p_id=>195521224213151446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TEMPLATE_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Message de succès';

wwv_flow_api.create_message (
  p_id=>195521322131151446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_SUCCESS_MSG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre';

wwv_flow_api.create_message (
  p_id=>195521430961151446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de corps';

wwv_flow_api.create_message (
  p_id=>195521532461151446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BODY_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_position
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région';

wwv_flow_api.create_message (
  p_id=>195521607857151446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_POSITION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Onglets';

wwv_flow_api.create_message (
  p_id=>195521717795151447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_STD_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Onglets parent';

wwv_flow_api.create_message (
  p_id=>195521825828151447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PARENT_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_application_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Onglets d''application';

wwv_flow_api.create_message (
  p_id=>195521926911151447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_APPLICATION_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_company_img
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Images d''espace de travail';

wwv_flow_api.create_message (
  p_id=>195522013964151447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPANY_IMG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oui';

wwv_flow_api.create_message (
  p_id=>195522103066151447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_YES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non';

wwv_flow_api.create_message (
  p_id=>195522208585151447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_header_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle d''en-tête';

wwv_flow_api.create_message (
  p_id=>195522327157151448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_HEADER_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Corps';

wwv_flow_api.create_message (
  p_id=>195522423408151448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_footer_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de pied';

wwv_flow_api.create_message (
  p_id=>195522504562151448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FOOTER_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_substitution
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Substitution';

wwv_flow_api.create_message (
  p_id=>195522609671151448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUBSTITUTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référencé';

wwv_flow_api.create_message (
  p_id=>195522723405151448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REFERENCED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'De';

wwv_flow_api.create_message (
  p_id=>195522817770151448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FROM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>195522925678151448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DESCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_onload
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chargement (Onload) de page';

wwv_flow_api.create_message (
  p_id=>195523011009151449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ONLOAD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de page';

wwv_flow_api.create_message (
  p_id=>195523121123151449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_head
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'En-tête de page';

wwv_flow_api.create_message (
  p_id=>195523217104151449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_HEAD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ouverture de panneau HTML';

wwv_flow_api.create_message (
  p_id=>195523327134151449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_OPEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Message de notification';

wwv_flow_api.create_message (
  p_id=>195523414405151449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION_MSG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Message de succès';

wwv_flow_api.create_message (
  p_id=>195523522646151449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUCCESS_MSG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Corps de page';

wwv_flow_api.create_message (
  p_id=>195523624083151450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de corps de page';

wwv_flow_api.create_message (
  p_id=>195523724054151450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fermeture de panneau HTML';

wwv_flow_api.create_message (
  p_id=>195523828088151450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_CLOSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région 1';

wwv_flow_api.create_message (
  p_id=>195523928543151450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région 2';

wwv_flow_api.create_message (
  p_id=>195524000454151450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région 3';

wwv_flow_api.create_message (
  p_id=>195524128235151450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région 4';

wwv_flow_api.create_message (
  p_id=>195524207234151451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région 5';

wwv_flow_api.create_message (
  p_id=>195524324974151451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS5',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région 6';

wwv_flow_api.create_message (
  p_id=>195524418159151451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS6',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région 7';

wwv_flow_api.create_message (
  p_id=>195524506606151451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS7',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position de région 8';

wwv_flow_api.create_message (
  p_id=>195524630069151451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS8',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_detail_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vue détail';

wwv_flow_api.create_message (
  p_id=>195524705158151451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_DETAIL_VIEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'action';

wwv_flow_api.create_message (
  p_id=>195524822926151452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ACTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'condition';

wwv_flow_api.create_message (
  p_id=>195524910508151452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CONDITION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'exp';

wwv_flow_api.create_message (
  p_id=>195525024515151452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EXP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher';

wwv_flow_api.create_message (
  p_id=>195525123930151452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'bouton';

wwv_flow_api.create_message (
  p_id=>195525208044151452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aller à la page';

wwv_flow_api.create_message (
  p_id=>195525324198151452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_redirect_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aller à la page';

wwv_flow_api.create_message (
  p_id=>195525415073151453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REDIRECT_TO_PG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_navigate_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigue vers la page';

wwv_flow_api.create_message (
  p_id=>195525505833151453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAVIGATE_TO_PG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message views2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vues';

wwv_flow_api.create_message (
  p_id=>195525603366151453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEWS2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation';

wwv_flow_api.create_message (
  p_id=>195525714893151453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Processus';

wwv_flow_api.create_message (
  p_id=>195525808310151453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calcul';

wwv_flow_api.create_message (
  p_id=>195525926615151453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Graphique par %0';

wwv_flow_api.create_message (
  p_id=>195526021881151454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_CHART_BY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Par %0';

wwv_flow_api.create_message (
  p_id=>195526127681151454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_BY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Région';

wwv_flow_api.create_message (
  p_id=>195526227913151454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Thème';

wwv_flow_api.create_message (
  p_id=>195526302157151454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application';

wwv_flow_api.create_message (
  p_id=>195526424271151454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_FLOW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(obsolète)';

wwv_flow_api.create_message (
  p_id=>195526521163151455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_DEPRECATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_convert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La méthode d''authentification %0 est obsolète. Nous vous conseillons de cliquer sur le lien Rendre en cours (figurant ci-dessus) de l''un des modèles d''authentification de l''application, ou de créer un nouveau modèle d''authentification et de le rendre en cours. Sur le plan fonctionnel, le modèle d''authentification INTERNAL-SETUP équivaut à la méthode %0.';

wwv_flow_api.create_message (
  p_id=>195526607465151455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_CONVERT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier des attributs d''authentification obsolètes';

wwv_flow_api.create_message (
  p_id=>195526728978151455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'attributs obsolètes';

wwv_flow_api.create_message (
  p_id=>195526811019151455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ou laissez-les en place jusqu''à ce que vous soyez prêt à faire passer la méthode d''authentification à %0.';

wwv_flow_api.create_message (
  p_id=>195526908057151455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Revoir ou modifier les attributs de gestion de session'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195527019166151455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW5',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilise les modèles d''authentification pour gérer l''authentification utilisateur et tous les autres aspects de la gestion de session pour votre application.';

wwv_flow_api.create_message (
  p_id=>195527115434151456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_DESC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indique un ou plusieurs attributs d''authentification obsolètes.';

wwv_flow_api.create_message (
  p_id=>195527207570151456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Revoir ou modifier ces';

wwv_flow_api.create_message (
  p_id=>195527300024151456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW6',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ou faites-les migrer vers un modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195527422352151456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED5',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message month
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mois';

wwv_flow_api.create_message (
  p_id=>195527511599151456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Version';

wwv_flow_api.create_message (
  p_id=>195527619354151456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_VERSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_dbname
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de base de données';

wwv_flow_api.create_message (
  p_id=>195527726039151457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_DBNAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_linked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lié';

wwv_flow_api.create_message (
  p_id=>195527803254151457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_LINKED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_as_app_on_exist_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'En tant qu''application dans une table de base de données';

wwv_flow_api.create_message (
  p_id=>195527908014151457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_AS_APP_ON_EXIST_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_show_xml
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher XML';

wwv_flow_api.create_message (
  p_id=>195528017079151457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.SHOW_XML',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_query_headings
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'impossible de déterminer les en-têtes d''interrogation :'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>195528118459151457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_QUERY_HEADINGS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_pagination
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la détermination de la chaîne de pagination';

wwv_flow_api.create_message (
  p_id=>195528217538151457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_PAGINATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_report_footer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur lors des remplacements de pied d''état';

wwv_flow_api.create_message (
  p_id=>195528321476151458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_REPORT_FOOTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_proc_function_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'impossible de traiter le corps de fonction renvoyant une interrogation :'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>195528429090151458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_PROC_FUNCTION_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_failed_parsing_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'échec de l''analyse de l''interrogation SQL :'||chr(10)||
'%0'||chr(10)||
'%1';

wwv_flow_api.create_message (
  p_id=>195528532733151458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FAILED_PARSING_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur d''état :'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>195528624011151458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.REPORT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_invalid_lov_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''interrogation de liste de valeurs (LOV) instantanée n''est pas valide ; une valeur d''affichage et une valeur de retour sont requises, et les noms de colonne doivent être différents';

wwv_flow_api.create_message (
  p_id=>195528724473151458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INVALID_LOV_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_new_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Nouvelle catégorie -';

wwv_flow_api.create_message (
  p_id=>195528808013151459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEW_CATEGORY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_no_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Non modifiable)';

wwv_flow_api.create_message (
  p_id=>195528905099151459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_NO_EDIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'en cours';

wwv_flow_api.create_message (
  p_id=>195529004090151459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_CURRENT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le graphique Flash. %0';

wwv_flow_api.create_message (
  p_id=>195529112157151459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FLASH_CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non valide';

wwv_flow_api.create_message (
  p_id=>195529207205151459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_included
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inclus';

wwv_flow_api.create_message (
  p_id=>195529305694151459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INCLUDED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_databases
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bases de données';

wwv_flow_api.create_message (
  p_id=>195529426041151460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_DATABASES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_lov_no_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- aucun modèle -';

wwv_flow_api.create_message (
  p_id=>195529525601151460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_LOV_NO_SCHEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message initcap_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Régénérer';

wwv_flow_api.create_message (
  p_id=>195529606567151460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INITCAP_REFRESH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message y
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'O';

wwv_flow_api.create_message (
  p_id=>195529727609151460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'Y',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_schema_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le schéma d''analyse "%0" de l''application n''existe pas dans la base de données.';

wwv_flow_api.create_message (
  p_id=>195529827672151460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SCHEMA_NOT_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ouverture :';

wwv_flow_api.create_message (
  p_id=>195529932024151460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.OPEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4790_date_timestamp_note
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(contenant la colonne Date ou Horodatage)';

wwv_flow_api.create_message (
  p_id=>195530021542151461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P4790_DATE_TIMESTAMP_NOTE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_bipub_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La prise en charge de l''impression doit être de type Standard ou Avancée';

wwv_flow_api.create_message (
  p_id=>195530107171151461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_BIPUB_OPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_first_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''enlever le premier schéma avec infos de paramétrage fournies';

wwv_flow_api.create_message (
  p_id=>195530225090151461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_FIRST_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Numéro de port non valide';

wwv_flow_api.create_message (
  p_id=>195530305006151461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_PORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wallet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le chemin de portefeuille (wallet) doit figurer dans le fichier d''application Forms : <chemin du système de fichiers>';

wwv_flow_api.create_message (
  p_id=>195530431450151461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WALLET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_parm_notfound
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Paramètre d''instance introuvable';

wwv_flow_api.create_message (
  p_id=>195530500709151461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PARM_NOTFOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion intégrée';

wwv_flow_api.create_message (
  p_id=>195530629664151462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_BUILTIN_LOGIN_PG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_page_in_this_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de cette application';

wwv_flow_api.create_message (
  p_id=>195530707080151462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_PAGE_IN_THIS_FLOW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>195530800557151462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_URL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On';

wwv_flow_api.create_message (
  p_id=>195530900678151462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_SSO_SERVER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun';

wwv_flow_api.create_message (
  p_id=>195531020363151462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_NONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_auth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser le nom utilisateur et le mot de passe du compte %0 pour l''authentification.';

wwv_flow_api.create_message (
  p_id=>195531127901151463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_AUTH_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_no_verify_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ne pas vérifier les informations d''identification et de connexion';

wwv_flow_api.create_message (
  p_id=>195531219523151463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_NO_VERIFY_CRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser un serveur LDAP pour l''authentification.';

wwv_flow_api.create_message (
  p_id=>195531304518151463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_LDAP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_custom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser ma fonction personnalisée pour l''authentification.';

wwv_flow_api.create_message (
  p_id=>195531407288151463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_CUSTOM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_scratch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entièrement nouveau';

wwv_flow_api.create_message (
  p_id=>195531502964151463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_SCRATCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'En tant que copie d''un modèle d''authentification existant';

wwv_flow_api.create_message (
  p_id=>195531621448151463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_COPY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_gallery
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Basé sur un modèle préconfiguré de la galerie';

wwv_flow_api.create_message (
  p_id=>195531715736151464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_GALLERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_use_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune authentification (utilisation de DAD)';

wwv_flow_api.create_message (
  p_id=>195531809246151464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_USE_DAD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_moc_sso
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie SSO (my.oracle.com -- Utilisation Oracle uniquement)';

wwv_flow_api.create_message (
  p_id=>195531928223151464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MOC_SSO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_account_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher la page de connexion et utiliser les informations d''identification et de connexion du compte %0';

wwv_flow_api.create_message (
  p_id=>195532017661151464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_ACCOUNT_CRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_builtin_pg_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher la page de connexion intégrée et utiliser les informations d''identification et de connexion porte ouverte';

wwv_flow_api.create_message (
  p_id=>195532100772151464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_BUILTIN_PG_OPEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher la page de connexion et utiliser les informations d''identification et de connexion de l''annuaire LDAP';

wwv_flow_api.create_message (
  p_id=>195532213995151464 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_USE_LDAP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_sso_htmldb_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (application partenaire = moteur %0)';

wwv_flow_api.create_message (
  p_id=>195532315928151465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SSO_HTMLDB_PARTNER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_my_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (application partenaire = mon application)';

wwv_flow_api.create_message (
  p_id=>195532412549151465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MY_PARTNER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nouveau';

wwv_flow_api.create_message (
  p_id=>195532505405151465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_NEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_printsvr_protocol
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le protocole du serveur d''impression doit être HTTP ou HTTPS';

wwv_flow_api.create_message (
  p_id=>195532606121151465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PRINTSVR_PROTOCOL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le schéma n''existe pas';

wwv_flow_api.create_message (
  p_id=>195532719449151465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le schéma est restreint';

wwv_flow_api.create_message (
  p_id=>195532818285151466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_RESTRICTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'contrôle d''accès - administration';

wwv_flow_api.create_message (
  p_id=>195532928287151466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_edit_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'contrôle d''accès - modification';

wwv_flow_api.create_message (
  p_id=>195533000107151466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_EDIT_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_view_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'contrôle d''accès - vue';

wwv_flow_api.create_message (
  p_id=>195533113665151466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_VIEW_AUTH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les comptes de l''espace de travail INTERNAL ne peuvent être utilisés que pour';

wwv_flow_api.create_message (
  p_id=>195533216891151466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administration du service %0';

wwv_flow_api.create_message (
  p_id=>195533319213151466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_domain_index_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il y a un index de domaine dans le %0 sélectionné. La fonction de génération de DDL ne peut pas générer du DDL pour un index de domaine.';

wwv_flow_api.create_message (
  p_id=>195533432508151467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.DOMAIN_INDEX_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_unsupported_data_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'type de données non pris en charge';

wwv_flow_api.create_message (
  p_id=>195533530980151467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_exclude_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exclure les valeurs NULL';

wwv_flow_api.create_message (
  p_id=>195533628345151467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_EXCLUDE_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonnes affichées';

wwv_flow_api.create_message (
  p_id=>195533725673151467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED_COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_all_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Toutes les colonnes';

wwv_flow_api.create_message (
  p_id=>195533817992151467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ALL_COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne pouvez pas vous supprimer.';

wwv_flow_api.create_message (
  p_id=>195533929394151468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_DELETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_remove_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne pouvez pas vous enlever le privilège d''administration.';

wwv_flow_api.create_message (
  p_id=>195534001089151468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type de graphique';

wwv_flow_api.create_message (
  p_id=>195534103347151468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHART_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_hcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne horizontale';

wwv_flow_api.create_message (
  p_id=>195534213004151468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HCOLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_vcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne verticale';

wwv_flow_api.create_message (
  p_id=>195534332236151468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VCOLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A secteurs';

wwv_flow_api.create_message (
  p_id=>195534411338151468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PIE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ligne';

wwv_flow_api.create_message (
  p_id=>195534502214151469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LINE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_3d
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'3D';

wwv_flow_api.create_message (
  p_id=>195534605372151469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_3D',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Libellé';

wwv_flow_api.create_message (
  p_id=>195534714275151469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LABEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Agréger';

wwv_flow_api.create_message (
  p_id=>195534828787151469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGGREGATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_do_not_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Ne pas agréger -';

wwv_flow_api.create_message (
  p_id=>195534914543151469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DO_NOT_AGGREGATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date';

wwv_flow_api.create_message (
  p_id=>195535002996151469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher';

wwv_flow_api.create_message (
  p_id=>195535108307151470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Sélectionner une fonction -';

wwv_flow_api.create_message (
  p_id=>195535230032151470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_FUNCTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Public';

wwv_flow_api.create_message (
  p_id=>195535332624151470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PUBLIC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voulez-vous supprimer ces paramètres d''état ?';

wwv_flow_api.create_message (
  p_id=>195535431458151470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE_CONFIRM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_reset_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Restaurer les paramètres par défaut de l''état.';

wwv_flow_api.create_message (
  p_id=>195535505215151470 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RESET_CONFIRM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_dup_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne pouvez saisir un nom utilisateur en double.';

wwv_flow_api.create_message (
  p_id=>195535612211151471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_DUP_USERNAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Saisissez votre ID utilisateur (n''importe quelle chaîne) pour cette session.';

wwv_flow_api.create_message (
  p_id=>195535728470151471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Saisissez votre nom utilisateur et votre mot de passe %0.';

wwv_flow_api.create_message (
  p_id=>195535827249151471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Saisissez votre nom utilisateur et votre mot de passe pour vérification par l''hôte LDAP : %0.';

wwv_flow_api.create_message (
  p_id=>195535923309151471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Saisissez votre nom utilisateur et votre mot de passe de schéma de base de données.';

wwv_flow_api.create_message (
  p_id=>195536000060151471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_dial_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''interrogation de graphique n''est pas valide : %0<br /><br /> Utilisez la syntaxe suivante : <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>Colonne numérique définissant la valeur de cadran.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>Colonne numérique définissant la valeur maximale de cadran.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW (facultatif)</td>'||chr(10)||
'<td';

h:=h||'>Colonne numérique définissant la valeur minimale précédente de cadran.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH (facultatif)</td>'||chr(10)||
'<td>Colonne numérique définissant la valeur maximale précédente de cadran.</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195536110135151471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_dup_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur page=%0 élément="%1" id="%2" : le nom est le même que celui d''un élément existant au niveau application.';

wwv_flow_api.create_message (
  p_id=>195536222904151472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_DUP_PAGE_ITEM_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_between
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'entre';

wwv_flow_api.create_message (
  p_id=>195536318243151472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BETWEEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''interrogation ne peut pas être analysée, le curseur n''est pas encore ouvert ou une fonction renvoyant une interrogation SQL n''a pas renvoyé de valeur.';

wwv_flow_api.create_message (
  p_id=>195536424867151472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.CURSOR_NOT_OPEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_query_cannot_be_parsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction renvoyant une interrogation SQL : l''interrogation ne peut pas être analysée dans Application Builder. Si vous pensez que la syntaxe de l''interrogation est correcte, cochez la case <b>Colonnes génériques</b> sous la source de région pour poursuivre sans qu''il y ait analyse.'||chr(10)||
'<br />'||chr(10)||
'(%0)';

wwv_flow_api.create_message (
  p_id=>195536530735151472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.QUERY_CANNOT_BE_PARSED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'la colonne d''interrogation #%0 (%1) n''est pas valide, utilisez l''alias de colonne';

wwv_flow_api.create_message (
  p_id=>195536620899151472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.USE_COLUMN_ALIAS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_html_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'la colonne d''interrogation #%0 (%1) n''est pas valide ; les colonnes utilisant le HTML doivent avoir des alias';

wwv_flow_api.create_message (
  p_id=>195536709315151472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.HTML_USE_COLUMN_ALIAS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>L''interrogation ne peut pas être analysée, vérifiez-en la syntaxe.'||chr(10)||
'(%0)'||chr(10)||
'</p>';

wwv_flow_api.create_message (
  p_id=>195536804677151473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>L''interrogation ne peut pas être analysée dans Application Builder. Si vous pensez que la syntaxe de l''interrogation est correcte, cochez la case Colonnes génériques sous la source de région pour poursuivre sans qu''il y ait analyse.'||chr(10)||
'(%0)</p>';

wwv_flow_api.create_message (
  p_id=>195536909883151473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Appliquer';

wwv_flow_api.create_message (
  p_id=>195537018146151473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_APPLY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_restriction
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La migration des graphiques SVG sera réalisée avec les restrictions suivantes :  '||chr(10)||
'<ul>'||chr(10)||
'<li>'||chr(10)||
'Seuls les formats numériques définis dans les chaînes de format des axes seront migrés. Les formats de date et d''heure seront ignorés.'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Les éléments de format numérique contenant les éléments suivants seront migrés :'||chr(10)||
'<br />'||chr(10)||
'0, 9, D, G, , (virgule), . (point), $, C, L, FM'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Le libellé de c';

h:=h||'haque série du graphique Flash sera déterminé à partir de l''alias de colonne de chaque série.  '||chr(10)||
'C''est là une différence par rapport aux graphiques SVG, où le libellé de chaque série était déterminé à partir de l''attribut Nom de série.'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Les graphiques à cadran Flash affichent les valeurs elles-mêmes et non des pourcentages.'||chr(10)||
'</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_message (
  p_id=>195537127908151473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fermeture :';

wwv_flow_api.create_message (
  p_id=>195537228525151473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.CLOSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_high
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur supérieure :';

wwv_flow_api.create_message (
  p_id=>195537330069151474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.HIGH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_low
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur inférieure :';

wwv_flow_api.create_message (
  p_id=>195537403921151474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.LOW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message monthly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mensuel';

wwv_flow_api.create_message (
  p_id=>195537501746151474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTHLY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weekly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hebdomadaire';

wwv_flow_api.create_message (
  p_id=>195537623781151474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKLY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message daily
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Quotidien';

wwv_flow_api.create_message (
  p_id=>195537717426151474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAILY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'< Précédent';

wwv_flow_api.create_message (
  p_id=>195537832616151474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.PREVIOUS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suivant >';

wwv_flow_api.create_message (
  p_id=>195537932680151474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.NEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p4111_used_on_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette liste de valeurs (LOV) est utilisée sur la ou les pages %0. Etes-vous sûr de vouloir la supprimer ? ';

wwv_flow_api.create_message (
  p_id=>195538030270151475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P4111_USED_ON_PAGES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_create_ws_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Un second appel create_company a été détecté au cours de l''installation de l''espace de travail.';

wwv_flow_api.create_message (
  p_id=>195538126458151475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.CREATE_WS_SEC_VIOLATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_to_is_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous devez indiquer un destinataire de courrier électronique.';

wwv_flow_api.create_message (
  p_id=>195538230308151475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.TO_IS_REQUIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message must_be_xsl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Assurez-vous que le type du fichier de mise en page d''état est XSL-FO, avec l''extension ''.xsl''.';

wwv_flow_api.create_message (
  p_id=>195538302027151475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MUST_BE_XSL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message your_email_iuws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Votre adresse électronique est inscrite auprès d''un utilisateur dans les espaces de travail suivants :';

wwv_flow_api.create_message (
  p_id=>195538427483151475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YOUR_EMAIL_IUWS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''accueil de l''espace de travail';

wwv_flow_api.create_message (
  p_id=>195538505415151475 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Connexion à l''espace de travail';

wwv_flow_api.create_message (
  p_id=>195538626357151476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_LOGIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Etat interactif';

wwv_flow_api.create_message (
  p_id=>195538709770151476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles';

wwv_flow_api.create_message (
  p_id=>195538814276151476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listes de valeurs (LOV)';

wwv_flow_api.create_message (
  p_id=>195538932512151476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune liste de valeurs partagée n''est utilisée.';

wwv_flow_api.create_message (
  p_id=>195539010281151476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun modèle utilisé.';

wwv_flow_api.create_message (
  p_id=>195539124563151476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message button_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Identificateur numérique de bouton';

wwv_flow_api.create_message (
  p_id=>195539208234151477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTON_ID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation de graphique non valide : %0<br /><br />'||chr(10)||
'Utilisez la syntaxe suivante :'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'Ou, pour une interrogation renvoyant plusieurs séries, utilisez la syntaxe suivante :'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE1 [, VALUE2 [, VALUE3...]]'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Texte s''affic';

h:=h||'hant le long d''un axe du graphique.</td></tr>'||chr(10)||
'<tr><td>VALUE1, VALUE2, VALUE3...</td><td>Colonnes numériques définissant les valeurs de données.</td></tr>'||chr(10)||
'</table>'||chr(10)||
'Note : Les noms de série pour les graphiques à colonnes et à courbes sont déterminés à partir des alias de colonne utilisés dans l''interrogation.';

wwv_flow_api.create_message (
  p_id=>195539330743151477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CHART_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_scatter_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation de graphique en nuage de points non valide : %0<br /><br />'||chr(10)||
'Utilisez la syntaxe suivante :'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, X_VALUE, Y_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Texte s''affichant dans les conseils.</td></tr>'||chr(10)||
'<tr><td>X_VALUE</td><td>Colonne numérique indiquant les valeurs de coordonnée X.</td></tr>'||chr(10)||
'<tr><td';

h:=h||'>Y_VALUE</td><td>Colonne numérique indiquant les valeurs de coordonnée Y.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195539406808151477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_SCATTER_CHART_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_range_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation de graphique à plages non valide : %0<br /><br />'||chr(10)||
'Utilisez la syntaxe suivante :'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN_VALUE, CLOSE_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Texte s''affichant le long d''un axe du graphique.</td></tr>'||chr(10)||
'<tr><td>OPEN_VALUE</td><td>Colonne numérique indiquant le début de la plage.</td></tr>'||chr(10)||
'<t';

h:=h||'r><td>CLOSE_VALUE</td><td>Colonne numérique indiquant la fin de la plage.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195539521496151477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_RANGE_CHART_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_candlestick_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation de graphique en chandelier non valide : %0<br /><br />'||chr(10)||
'Utilisez la syntaxe suivante :'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN, HIGH, LOW, CLOSE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Texte s''affichant le long d''un axe du graphique.</td></tr>'||chr(10)||
'<tr><td>OPEN</td><td>Colonne numérique indiquant le début du chandelier.</td></tr>'||chr(10)||
'<t';

h:=h||'r><td>HIGH</td><td>Colonne numérique indiquant le maximum du chandelier.</td></tr>'||chr(10)||
'<tr><td>LOW</td><td>Colonne numérique indiquant le minimum du chandelier.</td></tr>'||chr(10)||
'<tr><td>CLOSE</td><td>Colonne numérique indiquant la fin du chandelier.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195539608758151477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CANDLESTICK_CHART_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_dial_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation de graphique à cadran non valide : %0<br /><br /> Utilisez la syntaxe suivante :'||chr(10)||
'<pre> SELECT VALUE, MAX [, LOW, HIGH] VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>Colonne numérique définissant la valeur du cadran.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>Colonne numérique définissant la valeur maximale du cadran.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW (optionnel)</td>'||chr(10)||
'<td>';

h:=h||'Colonne numérique définissant la valeur inférieure d''une plage à afficher dans le cadran. Si cette valeur est définie, la valeur HIGH est obligatoire.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH (optionnel)</td>'||chr(10)||
'<td>Colonne numérique définissant la valeur supérieure d''une plage à afficher dans le cadran. Si cette valeur est définie, la valeur LOW est obligatoire.</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'Cette interrogation doit renvoyer';

h:=h||' une ligne.';

wwv_flow_api.create_message (
  p_id=>195539717024151477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_DIAL_CHART_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_pie_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation de graphique non valide : %0<br /><br />'||chr(10)||
'Utilisez la syntaxe suivante :'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Texte s''affichant dans les libellés de texte de légende, texte de conseil et secteur.</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>Colonne numérique définissant les valeurs de données.</td';

h:=h||'></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195539828113151478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_PIE_CHART_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drag_and_drop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Glisser-déplacer';

wwv_flow_api.create_message (
  p_id=>195539900355151478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRAG_AND_DROP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_parameter_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur NULL fournie pour le paramètre %0.';

wwv_flow_api.create_message (
  p_id=>195540017046151478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.PARAMETER_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_invalid_mail_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur non valide pour le paramètre p_mail_id : %0';

wwv_flow_api.create_message (
  p_id=>195540124500151478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.INVALID_MAIL_ID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Catégorie';

wwv_flow_api.create_message (
  p_id=>195540204613151478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CATEGORY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>195540314455151478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Appel d''API à la procédure remove_page détecté dans un bloc de grande taille du fichier d''export.';

wwv_flow_api.create_message (
  p_id=>195540425930151479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.SEC_VIOLATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_fmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le fichier que vous avez tenté de télécharger vers le projet de migration de panneaux n''est pas un fichier de module de panneaux valide (_fmb.XML). Seuls les fichiers XML du module de panneaux, générés par l''outil de conversion Forms2XML inclus dans Oracle Forms, peuvent être téléchargés.';

wwv_flow_api.create_message (
  p_id=>195540500070151479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_FMB_CONTENT_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_rpt_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le fichier que vous avez tenté de télécharger vers le projet de migration de panneaux n''est pas un fichier d''états (.XML) valide. Seuls les fichiers XML d''état, générés par la fonction de conversion de fichiers incluse dans Oracle Reports Builder, peuvent être téléchargés.';

wwv_flow_api.create_message (
  p_id=>195540608690151479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_RPT_CONTENT_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL : http(s)://domain/path/doc.(pdf)(html)(etc...)';

wwv_flow_api.create_message (
  p_id=>195540728776151479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Adresse IP';

wwv_flow_api.create_message (
  p_id=>195540807212151479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Numéro de téléphone, US: %0';

wwv_flow_api.create_message (
  p_id=>195540928388151479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Numéro de téléphone, US flexible : 999.999.9999, (999)-999-9999, 999 999 9999, etc...';

wwv_flow_api.create_message (
  p_id=>195541020755151480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Code postal : 99999';

wwv_flow_api.create_message (
  p_id=>195541132379151480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Code postal + 4 : 99999-9999';

wwv_flow_api.create_message (
  p_id=>195541206078151480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date : %0';

wwv_flow_api.create_message (
  p_id=>195541304753151480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date, flexible : %0 avec tout séparateur';

wwv_flow_api.create_message (
  p_id=>195541410758151480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL non valide';

wwv_flow_api.create_message (
  p_id=>195541527233151480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Adresse IP non valide';

wwv_flow_api.create_message (
  p_id=>195541609785151481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le numéro de téléphone doit avoir le format suivant : %0';

wwv_flow_api.create_message (
  p_id=>195541725633151481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Format de numéro de téléphone non reconnu';

wwv_flow_api.create_message (
  p_id=>195541810557151481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le code postal doit avoir le format suivant : %0';

wwv_flow_api.create_message (
  p_id=>195541923505151481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La date doit avoir le format suivant : %0';

wwv_flow_api.create_message (
  p_id=>195542027858151481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Format de date non reconnu';

wwv_flow_api.create_message (
  p_id=>195542129429151481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_curr_warn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Avertissement : vous êtes sur le point de supprimer le modèle d''authentification en cours de l''application.';

wwv_flow_api.create_message (
  p_id=>195542232745151482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_CURR_WARN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_func_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter la fonction d''authentification personnalisée dans l''application %0.';

wwv_flow_api.create_message (
  p_id=>195542323910151482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FUNC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''extraire le corps de la fonction d''authentification personnalisée dans l''application %0.';

wwv_flow_api.create_message (
  p_id=>195542418255151482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FETCH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_scheme_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''extraire authentication_scheme dans l''application %0.';

wwv_flow_api.create_message (
  p_id=>195542521752151482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SCHEME_FETCH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_pg_sentry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter la sentinelle de page dans l''application %0.';

wwv_flow_api.create_message (
  p_id=>195542602851151482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_PG_SENTRY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_sess_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter la fonction de vérification de la session plugin à partir du modèle d''authentification de l''application %0.';

wwv_flow_api.create_message (
  p_id=>195542728856151482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SESS_VERIFY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le package WWSEC_SSO_ENABLER_PRIVATE n''existe pas ou n''est pas valide.';

wwv_flow_api.create_message (
  p_id=>195542831179151482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demandez à votre administrateur %0 de configurer le moteur pour Oracle Application Server Single Sign-On.';

wwv_flow_api.create_message (
  p_id=>195542907642151483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''exécution de wwv_flow_custom_auth_sso.portal_sso_redirect.';

wwv_flow_api.create_message (
  p_id=>195543019293151483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_api_deep_link_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur inattendue dans remember_deep_link pour la session %0.';

wwv_flow_api.create_message (
  p_id=>195543112221151483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_API.DEEP_LINK_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_dup_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom utilisateur en double pour %0.';

wwv_flow_api.create_message (
  p_id=>195543208389151483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.DUP_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_load_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors du chargement des utilisateurs. Echec pour l''utilisateur %0.';

wwv_flow_api.create_message (
  p_id=>195543314732151483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.LOAD_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_mmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le fichier que vous avez tenté de télécharger vers le projet de migration de panneaux n''est pas un fichier de menu de panneau valide (_mmb.XML). Seuls les fichiers XML de menu de panneau, générés par l''outil de conversion Form2XML inclus dans Oracle Forms, peuvent être téléchargés.';

wwv_flow_api.create_message (
  p_id=>195543426633151483 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_MMB_CONTENT_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ligne(s) %0 - %1 de %2';

wwv_flow_api.create_message (
  p_id=>195543530561151484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_found_but_not_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ligne minimum demandée : %0, lignes trouvées mais non affichées : %1';

wwv_flow_api.create_message (
  p_id=>195543602928151484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FOUND_BUT_NOT_DISPLAYED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_more_than_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ligne(s) %0 - %1 de plus de %2';

wwv_flow_api.create_message (
  p_id=>195543717916151484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_MORE_THAN_Z',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application';

wwv_flow_api.create_message (
  p_id=>195543802952151484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page';

wwv_flow_api.create_message (
  p_id=>195543922372151484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de page';

wwv_flow_api.create_message (
  p_id=>195544027702151484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de région';

wwv_flow_api.create_message (
  p_id=>195544118450151485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets';

wwv_flow_api.create_message (
  p_id=>195544209045151485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Libellé d''onglet';

wwv_flow_api.create_message (
  p_id=>195544317269151485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_LABEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Propriétaire de table';

wwv_flow_api.create_message (
  p_id=>195544402958151485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_OWNER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de table';

wwv_flow_api.create_message (
  p_id=>195544522507151485 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonnes';

wwv_flow_api.create_message (
  p_id=>195544620594151486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_updateable_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonnes modifiables';

wwv_flow_api.create_message (
  p_id=>195544716781151486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATEABLE_COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Clé primaire %0';

wwv_flow_api.create_message (
  p_id=>195544826880151486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de page';

wwv_flow_api.create_message (
  p_id=>195544908277151486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_tabset_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun jeu d''onglets n''a été sélectionné pour cette page.';

wwv_flow_api.create_message (
  p_id=>195545005139151486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO.TABSET.SELECTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Un nouveau jeu d''onglets, "%0", sera créé et utilisé par cette page.';

wwv_flow_api.create_message (
  p_id=>195545104493151486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE.NEW.TABSET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_use_existing_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette page utilisera le jeu d''onglets existant "%0".';

wwv_flow_api.create_message (
  p_id=>195545230325151487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.USE.EXISTING.TABSET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabset_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Avertissement, les informations de jeu d''onglets sont incomplètes.';

wwv_flow_api.create_message (
  p_id=>195545319851151487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABSET.INCOMPLETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets parent';

wwv_flow_api.create_message (
  p_id=>195545401161151487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Libellé d''onglet parent';

wwv_flow_api.create_message (
  p_id=>195545502587151487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_LABEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun modèle';

wwv_flow_api.create_message (
  p_id=>195545622980151487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eléments';

wwv_flow_api.create_message (
  p_id=>195545718226151487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ITEMS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de région';

wwv_flow_api.create_message (
  p_id=>195545805746151487 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle d''information';

wwv_flow_api.create_message (
  p_id=>195545909913151488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte par défaut d''information';

wwv_flow_api.create_message (
  p_id=>195546024698151488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte d''affichage du bouton %0';

wwv_flow_api.create_message (
  p_id=>195546120883151488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branchement de bouton %0';

wwv_flow_api.create_message (
  p_id=>195546217951151488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_BRANCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_suggested_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom suggéré';

wwv_flow_api.create_message (
  p_id=>195546300808151488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SUGGESTED_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_actual_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom réel';

wwv_flow_api.create_message (
  p_id=>195546404586151488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ACTUAL_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_new_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nouveau modèle';

wwv_flow_api.create_message (
  p_id=>195546529211151489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NEW_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonnes d''affichage';

wwv_flow_api.create_message (
  p_id=>195546611590151489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_process_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Options de processus';

wwv_flow_api.create_message (
  p_id=>195546716380151489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PROCESS_OPTIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Propriétaire';

wwv_flow_api.create_message (
  p_id=>195546802934151489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OWNER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_stored_procedure_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de procédure stockée';

wwv_flow_api.create_message (
  p_id=>195546913072151489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STORED_PROCEDURE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation SQL';

wwv_flow_api.create_message (
  p_id=>195547020713151489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SQL_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation de graphique';

wwv_flow_api.create_message (
  p_id=>195547103200151490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Axe de graphique';

wwv_flow_api.create_message (
  p_id=>195547204892151490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_AXIS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echelle';

wwv_flow_api.create_message (
  p_id=>195547308853151490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCALE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_number_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Masque numérique';

wwv_flow_api.create_message (
  p_id=>195547413190151490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_NUMBER_MASK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type de graphique';

wwv_flow_api.create_message (
  p_id=>195547520941151490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre de graphique';

wwv_flow_api.create_message (
  p_id=>195547603140151490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Taille de graphique';

wwv_flow_api.create_message (
  p_id=>195547710465151490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SIZE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_vertical_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A barres verticales';

wwv_flow_api.create_message (
  p_id=>195547830592151491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_VERTICAL_BAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_horizontal_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A barres horizontales';

wwv_flow_api.create_message (
  p_id=>195547915141151491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_HORIZONTAL_BAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A secteurs';

wwv_flow_api.create_message (
  p_id=>195548015048151491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_PIE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A courbes';

wwv_flow_api.create_message (
  p_id=>195548104540151491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_LINE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scatter
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'En nuage de points';

wwv_flow_api.create_message (
  p_id=>195548207629151491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCATTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_insert_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Insérer';

wwv_flow_api.create_message (
  p_id=>195548306037151492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INSERT_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_update_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mettre à jour';

wwv_flow_api.create_message (
  p_id=>195548400068151492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATE_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_delete_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Supprimer';

wwv_flow_api.create_message (
  p_id=>195548525915151492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DELETE_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tabular_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page de panneau tabulaire avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195548611490151492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TABULAR_FORM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195548720683151492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''un assistant avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195548832673151492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_WIZARD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''un panneau sur une page de table avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195548927580151492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''un panneau sur une procédure stockée avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195549019419151493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_SP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''un panneau sur une interrogation SQL avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195549129493151493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_simple_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page de graphique à barres HTML avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195549221213151493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SIMPLE_CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page de graphique SVG avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195549331012151493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SVG_CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page de calendrier avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195549407663151493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_CALENDAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_date_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne de date';

wwv_flow_api.create_message (
  p_id=>195549500860151493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DATE_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_label_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne de libellé';

wwv_flow_api.create_message (
  p_id=>195549616156151494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.LABEL_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page d''arborescence avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195549723384151494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TREE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''arborescence';

wwv_flow_api.create_message (
  p_id=>195549827156151494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type d''arborescence';

wwv_flow_api.create_message (
  p_id=>195549907296151494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_max_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nombre maximum de niveaux';

wwv_flow_api.create_message (
  p_id=>195550004852151494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_MAX_LEVEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_start
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Arborescence de départ';

wwv_flow_api.create_message (
  p_id=>195550102042151494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_START',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation d''arborescence';

wwv_flow_api.create_message (
  p_id=>195550223278151495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Basée sur un nouvel élément avec liste de valeurs (LOV) instantanée';

wwv_flow_api.create_message (
  p_id=>195550305236151495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A partir d''une interrogation SQL';

wwv_flow_api.create_message (
  p_id=>195550406901151495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_SQL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_static
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur statique';

wwv_flow_api.create_message (
  p_id=>195550525957151495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_STATIC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une région d''historique des accès et d''une option d''historique des accès avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195550625342151495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MENU',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type de région';

wwv_flow_api.create_message (
  p_id=>195550708379151495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_point
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Point d''affichage';

wwv_flow_api.create_message (
  p_id=>195550822648151496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_POINT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle d''historique des accès';

wwv_flow_api.create_message (
  p_id=>195550919179151496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Séquence';

wwv_flow_api.create_message (
  p_id=>195551004360151496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SEQUENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lien d''historique des accès';

wwv_flow_api.create_message (
  p_id=>195551114563151496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_LINK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte d''historique des accès';

wwv_flow_api.create_message (
  p_id=>195551226282151496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Historique des accès parent';

wwv_flow_api.create_message (
  p_id=>195551305198151496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_query_and_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création de pages de panneau et d''état avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195551424773151496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''état';

wwv_flow_api.create_message (
  p_id=>195551512834151497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de page d''état';

wwv_flow_api.create_message (
  p_id=>195551614808151497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets de page d''état';

wwv_flow_api.create_message (
  p_id=>195551725725151497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Libellé d''onglet de page d''état';

wwv_flow_api.create_message (
  p_id=>195551821450151497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de panneau';

wwv_flow_api.create_message (
  p_id=>195551920527151497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de page de panneau';

wwv_flow_api.create_message (
  p_id=>195552009469151497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets de page de panneau';

wwv_flow_api.create_message (
  p_id=>195552129584151498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Libellé d''onglet de page de panneau';

wwv_flow_api.create_message (
  p_id=>195552224248151498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne de clé primaire';

wwv_flow_api.create_message (
  p_id=>195552318276151498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonnes d''état';

wwv_flow_api.create_message (
  p_id=>195552420873151498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_where_clause
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Clause WHERE';

wwv_flow_api.create_message (
  p_id=>195552501029151498 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WHERE_CLAUSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_drill_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page d''état de hiérarchisation vers le bas avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195552630373151499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DRILL_DOWN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page parent';

wwv_flow_api.create_message (
  p_id=>195552727666151499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de détail %0';

wwv_flow_api.create_message (
  p_id=>195552805492151499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Libellé d''onglet détail %0';

wwv_flow_api.create_message (
  p_id=>195552923357151499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TAB_LABEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de table parent';

wwv_flow_api.create_message (
  p_id=>195553019147151499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TABLE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de table détail %0';

wwv_flow_api.create_message (
  p_id=>195553102851151499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonnes d''affichage parent';

wwv_flow_api.create_message (
  p_id=>195553221380151499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_DISPLAY_COLS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonnes d''affichage de %0 détail';

wwv_flow_api.create_message (
  p_id=>195553322834151500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table parent - ORDER BY';

wwv_flow_api.create_message (
  p_id=>195553430320151500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_ORDER_BY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table détail %0 - ORDER BY';

wwv_flow_api.create_message (
  p_id=>195553510230151500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_ORDER_BY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_inc_bread_crumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inclure un historique des accès';

wwv_flow_api.create_message (
  p_id=>195553620954151500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INC_BREAD_CRUMB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_root
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Racine d''historique des accès';

wwv_flow_api.create_message (
  p_id=>195553702938151500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_ROOT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne d''historique des accès parent';

wwv_flow_api.create_message (
  p_id=>195553814101151500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU_COL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne d''historique des accès détail';

wwv_flow_api.create_message (
  p_id=>195553907031151501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_MENU_COL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page récapitulative avec les attributs suivants. Cliquez sur le bouton Ajouter d''autres pour ajouter d''autres éléments provenant d''autres pages et/ou d''autres régions. Cliquez sur Fin pour créer les éléments récapitulatifs.';

wwv_flow_api.create_message (
  p_id=>195554012995151501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SUMMARY_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_copy_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la copie d''une page avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195554122401151501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COPY_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page d''état avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195554229410151501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_REPORT_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''onglet';

wwv_flow_api.create_message (
  p_id=>195554320606151501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_easy_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page d''état avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195554431678151501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_EASY_REPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle d''état';

wwv_flow_api.create_message (
  p_id=>195554506147151502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sort_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Option de tri';

wwv_flow_api.create_message (
  p_id=>195554606993151502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SORT_OPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'valeur par défaut : HTML (standard)';

wwv_flow_api.create_message (
  p_id=>195554706507151502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'valeur par défaut : état vertical, aspect 1 (exclure les colonnes Null)';

wwv_flow_api.create_message (
  p_id=>195554822217151502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'valeur par défaut : état vertical, aspect 1 (inclure les colonnes Null)';

wwv_flow_api.create_message (
  p_id=>195554918888151502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'valeur par défaut : aspect 1';

wwv_flow_api.create_message (
  p_id=>195555014362151502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME11',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'valeur par défaut : aspect 2';

wwv_flow_api.create_message (
  p_id=>195555123295151503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME12',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name21
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'export : CSV';

wwv_flow_api.create_message (
  p_id=>195555231217151503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME21',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'export : XML';

wwv_flow_api.create_message (
  p_id=>195555309124151503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME22',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'modèle :';

wwv_flow_api.create_message (
  p_id=>195555409824151503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_col_head_sorting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser le tri d''en-têtes de colonne';

wwv_flow_api.create_message (
  p_id=>195555502172151503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COL_HEAD_SORTING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une application avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195555624857151503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_APPLICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195555713742151503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias';

wwv_flow_api.create_message (
  p_id=>195555822553151504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_ALIAS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_default_lang
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Langue par défaut';

wwv_flow_api.create_message (
  p_id=>195555911520151504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentification';

wwv_flow_api.create_message (
  p_id=>195556017929151504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.AUTHENTICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pages';

wwv_flow_api.create_message (
  p_id=>195556127584151504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Onglets';

wwv_flow_api.create_message (
  p_id=>195556208131151504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Barre de navigation';

wwv_flow_api.create_message (
  p_id=>195556332287151504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NAV_BAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Thème d''interface utilisateur';

wwv_flow_api.create_message (
  p_id=>195556400699151505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bleu et ocre';

wwv_flow_api.create_message (
  p_id=>195556503887151505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rouge';

wwv_flow_api.create_message (
  p_id=>195556621573151505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bleu foncé et gris clair';

wwv_flow_api.create_message (
  p_id=>195556713248151505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Marron clair';

wwv_flow_api.create_message (
  p_id=>195556818915151505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME5',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rouge foncé';

wwv_flow_api.create_message (
  p_id=>195556909164151505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME6',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bleu et Ocre';

wwv_flow_api.create_message (
  p_id=>195557022819151506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME7',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bleu';

wwv_flow_api.create_message (
  p_id=>195557108506151506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME8',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun';

wwv_flow_api.create_message (
  p_id=>195557225021151506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME_NONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_copied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195557315387151506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.COPIED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de ce modèle.';

wwv_flow_api.create_message (
  p_id=>195557422246151506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.MASTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles de libellé faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195557519375151506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun modèle n''est abonné à ce modèle.';

wwv_flow_api.create_message (
  p_id=>195557619739151507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_current_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Méthode d''authentification en cours';

wwv_flow_api.create_message (
  p_id=>195557708402151507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CURRENT_AUTH_METHOD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page de connexion';

wwv_flow_api.create_message (
  p_id=>195557812235151507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aucun';

wwv_flow_api.create_message (
  p_id=>195557931144151507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.NONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL de connexion';

wwv_flow_api.create_message (
  p_id=>195558003758151507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_URL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_custom_auth_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction d''authentification personnalisée';

wwv_flow_api.create_message (
  p_id=>195558126517151507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CUSTOM_AUTH_FUNCTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_confirm_migrate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous êtes sur le point de faire migrer les options d''authentification personnalisée de cette application vers un modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195558231915151508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CONFIRM_MIGRATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_value_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La valeur doit être indiquée.';

wwv_flow_api.create_message (
  p_id=>195558330705151508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.VALUE_REQUIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>195558429332151508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PLSQL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_e_val
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'élément=valeur';

wwv_flow_api.create_message (
  p_id=>195558521745151508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'élément NOT NULL';

wwv_flow_api.create_message (
  p_id=>195558607722151508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_req_e_e1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'demande=e1';

wwv_flow_api.create_message (
  p_id=>195558704023151508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'page dans';

wwv_flow_api.create_message (
  p_id=>195558802595151509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_IN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'la page n''est pas dans';

wwv_flow_api.create_message (
  p_id=>195558909623151509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'existe';

wwv_flow_api.create_message (
  p_id=>195559011812151509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'jamais';

wwv_flow_api.create_message (
  p_id=>195559127105151509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NEVER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aucun';

wwv_flow_api.create_message (
  p_id=>195559217908151509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p688_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Identifiez les composants d''application à exporter. L''export peut servir à réaliser une sauvegarde ou à charger ces composants dans une autre instance.';

wwv_flow_api.create_message (
  p_id=>195559306874151509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P688_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'existe';

wwv_flow_api.create_message (
  p_id=>195559423892151510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'n''existe pas';

wwv_flow_api.create_message (
  p_id=>195559523467151510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créez un exemple d''application pour présenter les services Web.';

wwv_flow_api.create_message (
  p_id=>195559623092151510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous êtes sur le point de (re)créer l''application de démonstration d''aspect professionnel.';

wwv_flow_api.create_message (
  p_id=>195559726218151510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_worldcup_mania
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous êtes sur le point de créer l''application de démonstration Fans de la coupe du monde.';

wwv_flow_api.create_message (
  p_id=>195559802375151510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'S''ils existent déjà, les objets de base de données suivants seront recréés';

wwv_flow_api.create_message (
  p_id=>195559922665151510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_RECREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schéma';

wwv_flow_api.create_message (
  p_id=>195560022823151510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type d''objet';

wwv_flow_api.create_message (
  p_id=>195560120818151511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195560205760151511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Existe';

wwv_flow_api.create_message (
  p_id=>195560301339151511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table';

wwv_flow_api.create_message (
  p_id=>195560412285151511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_application_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les ID d''application compris entre 3000 et 8999 sont réservés.';

wwv_flow_api.create_message (
  p_id=>195560514896151511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APPLICATION_RESERVED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Séquence';

wwv_flow_api.create_message (
  p_id=>195560623277151511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SEQUENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Déclencheur';

wwv_flow_api.create_message (
  p_id=>195560710285151512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TRIGGER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package';

wwv_flow_api.create_message (
  p_id=>195560829145151512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PACKAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_basic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous êtes sur le point de créer l''application de démo Exemples de base.';

wwv_flow_api.create_message (
  p_id=>195560918101151512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BASIC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous êtes sur le point de créer l''application de démo Vitrine de collections.';

wwv_flow_api.create_message (
  p_id=>195561009354151512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_or_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'créer ou recréer dans le schéma %0';

wwv_flow_api.create_message (
  p_id=>195561129457151512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p19_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous devez indiquer au moins un élément pour créer une validation NOT NULL.';

wwv_flow_api.create_message (
  p_id=>195561207455151512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P19.VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''objet';

wwv_flow_api.create_message (
  p_id=>195561325693151513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_basic_lexer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'BASIC_LEXER';

wwv_flow_api.create_message (
  p_id=>195561410323151513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BASIC_LEXER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_context_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'CONTEXT INDEX';

wwv_flow_api.create_message (
  p_id=>195561525023151513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CONTEXT_INDEX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''en-tête doit contenir les balises <b> &lt;head&gt;</b> et <b>&lt;/head&gt;</b>.';

wwv_flow_api.create_message (
  p_id=>195561618175151513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application';

wwv_flow_api.create_message (
  p_id=>195561729807151513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.APPLICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_need_7m
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La démonstration de l''allocution d''ouverture présidentielle requiert environ 7 Mo d''espace disque libre ; son installation dans votre schéma peut prendre jusqu''à deux minutes.';

wwv_flow_api.create_message (
  p_id=>195561825968151513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NEED_7M',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La chaîne de substitution <b>#HEAD#</b> doit figurer entre les balises <b> &lt;head&gt;</b> et <b>&lt;/head&gt;</b>.';

wwv_flow_api.create_message (
  p_id=>195561910828151514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_free_space
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il vous reste environ %0 Mo d''espace libre.';

wwv_flow_api.create_message (
  p_id=>195562022847151514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.FREE_SPACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_will_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Une erreur risque de survenir si vous ne recréez pas cette démonstration.';

wwv_flow_api.create_message (
  p_id=>195562116183151514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WILL_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p818_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous devez sélectionner au moins un schéma pour copie.';

wwv_flow_api.create_message (
  p_id=>195562218588151514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P818.VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_mand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nom de modèle doit être indiqué.';

wwv_flow_api.create_message (
  p_id=>195562331338151514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_MAND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195562420045151514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.COPIED_FROM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de liste de valeurs (LOV) instantanée';

wwv_flow_api.create_message (
  p_id=>195562502690151515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de ce modèle.';

wwv_flow_api.create_message (
  p_id=>195562607126151515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MASTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles de liste de valeurs (LOV) instantanée faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195562732256151515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun modèle n''est abonné à ce modèle.';

wwv_flow_api.create_message (
  p_id=>195562806020151515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application en cours';

wwv_flow_api.create_message (
  p_id=>195562928507151515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_APPLICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias';

wwv_flow_api.create_message (
  p_id=>195563003660151515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALIAS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mis à jour';

wwv_flow_api.create_message (
  p_id=>195563127402151516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_report_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles d''état faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195563206590151516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REPORT_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Propriétaire';

wwv_flow_api.create_message (
  p_id=>195563319206151516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OWNER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentification';

wwv_flow_api.create_message (
  p_id=>195563424708151516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_edit_this_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier ce modèle';

wwv_flow_api.create_message (
  p_id=>195563503762151516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_EDIT_THIS_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_authentication_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'page d''accueil d''authentification';

wwv_flow_api.create_message (
  p_id=>195563627676151516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_AUTHENTICATION_HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle';

wwv_flow_api.create_message (
  p_id=>195563726426151517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles d''historique des accès faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195563800205151517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MENU_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table_summary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Etat Statut d''installation de l''application de démonstration';

wwv_flow_api.create_message (
  p_id=>195563906064151517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE_SUMMARY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_demo_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application de démo';

wwv_flow_api.create_message (
  p_id=>195564017682151517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEMO_APP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_status
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Statut';

wwv_flow_api.create_message (
  p_id=>195564113730151517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.STATUS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Action ';

wwv_flow_api.create_message (
  p_id=>195564209189151517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ACTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vitrine de collections';

wwv_flow_api.create_message (
  p_id=>195564306623151518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_learn_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Découvrez les concepts du chariot d''achats %0.';

wwv_flow_api.create_message (
  p_id=>195564416822151518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.LEARN_ABOUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installé';

wwv_flow_api.create_message (
  p_id=>195564514998151518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALLED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_run
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exécuter';

wwv_flow_api.create_message (
  p_id=>195564609708151518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.RUN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_not_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non installé';

wwv_flow_api.create_message (
  p_id=>195564701824151518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NOT_INSTALLED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installer';

wwv_flow_api.create_message (
  p_id=>195564829513151518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page';

wwv_flow_api.create_message (
  p_id=>195564900789151519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre';

wwv_flow_api.create_message (
  p_id=>195565016265151519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message security
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sécurité';

wwv_flow_api.create_message (
  p_id=>195565106516151519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECURITY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message standard_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets standard';

wwv_flow_api.create_message (
  p_id=>195565224326151519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STANDARD_TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Animalerie';

wwv_flow_api.create_message (
  p_id=>195565316903151519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PETSTORE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exemple de magasin en ligne créé à l''aide de %0.';

wwv_flow_api.create_message (
  p_id=>195565423386151519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install_now
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installer maintenant';

wwv_flow_api.create_message (
  p_id=>195565527221151520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL_NOW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aspect professionnel';

wwv_flow_api.create_message (
  p_id=>195565623595151520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BUSINESS_LOOK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exemples d''états structurés et de concepts de pagination';

wwv_flow_api.create_message (
  p_id=>195565728850151520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Services Web';

wwv_flow_api.create_message (
  p_id=>195565806050151520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WEB_SERVICES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_webservices
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Apprenez à utiliser les services Web avec %0.';

wwv_flow_api.create_message (
  p_id=>195565913141151520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Allocutions d''ouverture présidentielles';

wwv_flow_api.create_message (
  p_id=>195566031814151520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PRESIDENTIAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Découvrez l''utilisation d''Oracle Text avec %0.';

wwv_flow_api.create_message (
  p_id=>195566103706151521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_select_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sélectionnez l''heure à laquelle vous voulez revenir, puis cliquez sur la source pour remplir l''élément voulu et fermer cette page.';

wwv_flow_api.create_message (
  p_id=>195566216430151521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_SELECT_TIME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_project_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suivi de projet';

wwv_flow_api.create_message (
  p_id=>195566329690151521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PROJECT_TRACKING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_flashback_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La fonctionnalité d''annulation de %0 utilise une fonctionnalité de base de données intégrée appelée "Interrogation Flashback", qui vous permet d''interroger des données à partir d''une heure donnée.';

wwv_flow_api.create_message (
  p_id=>195566427074151521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_FLASHBACK_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_proj_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exemple d''application de suivi de statut de projet créée avec %0.';

wwv_flow_api.create_message (
  p_id=>195566523518151521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_undo_retention
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Du fait de la valeur du paramètre de base de données "UNDO_RETENTION", vous ne pouvez annuler que les modifications effectuées au cours des %0 dernières heures.';

wwv_flow_api.create_message (
  p_id=>195566619592151521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_UNDO_RETENTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195566730936151522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.COPIED_FROM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de cette aide sur un élément.';

wwv_flow_api.create_message (
  p_id=>195566826801151522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.MASTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eléments faisant référence à ce texte d''aide sur un élément';

wwv_flow_api.create_message (
  p_id=>195566911439151522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun n''élément n''est abonné à ce texte d''aide sur un élément.';

wwv_flow_api.create_message (
  p_id=>195567011871151522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.NO_SUBSCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_confirm_create_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Confirmer la création de l''onglet standard dans l''application';

wwv_flow_api.create_message (
  p_id=>195567132752151522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_CONFIRM_CREATE_STD_TAB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_tabset_info_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Avertissement, les informations de jeu d''onglets sont incomplètes.';

wwv_flow_api.create_message (
  p_id=>195567226076151522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_TABSET_INFO_INCOMPLETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195567311666151522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.COPIED_FROM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_page_will_use_existng_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La page %0 utilisera le jeu d''onglets existant "%1".';

wwv_flow_api.create_message (
  p_id=>195567431798151523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_PAGE_WILL_USE_EXISTNG_TABSET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_new_tabset_will_be_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Un nouveau jeu d''onglets, %0, sera créé.';

wwv_flow_api.create_message (
  p_id=>195567530281151523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_NEW_TABSET_WILL_BE_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de ce modèle d''autorisation.';

wwv_flow_api.create_message (
  p_id=>195567616392151523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.MASTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles d''autorisation faisant référence à ce modèle d''autorisation';

wwv_flow_api.create_message (
  p_id=>195567714520151523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun modèle d''autorisation n''est abonné à ce modèle d''autorisation.';

wwv_flow_api.create_message (
  p_id=>195567817485151524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.NO_SUBSCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_not_supplied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le mot de passe et la confirmation du mot de passe sont obligatoires.';

wwv_flow_api.create_message (
  p_id=>195567902765151524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NOT_SUPPLIED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_no_match
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mots de passe non identiques, ressayez.';

wwv_flow_api.create_message (
  p_id=>195568014219151524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NO_MATCH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195568105597151524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.COPIED_FROM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_chg_only_yours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous ne pouvez modifier que votre propre mot de passe.';

wwv_flow_api.create_message (
  p_id=>195568205069151524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_CHG_ONLY_YOURS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de ce raccourci.';

wwv_flow_api.create_message (
  p_id=>195568304710151524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.MASTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur inattendue lors du traitement de votre demande de modification de mot de passe : %0';

wwv_flow_api.create_message (
  p_id=>195568412304151525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Raccourcis faisant référence à ce raccourci';

wwv_flow_api.create_message (
  p_id=>195568516767151525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun raccourci n''est abonné à ce raccourci.';

wwv_flow_api.create_message (
  p_id=>195568632311151525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.NO_SUBSCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 Erreur lors du traitement de l''expression PL/SQL. %0';

wwv_flow_api.create_message (
  p_id=>195568731065151525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_PLSQL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1026 Erreur lors du traitement de l''expression SQL : %0';

wwv_flow_api.create_message (
  p_id=>195568812455151525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_SQL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets';

wwv_flow_api.create_message (
  p_id=>195568905984151525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_orcl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur Oracle : %0';

wwv_flow_api.create_message (
  p_id=>195569012558151525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_ORCL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte d''onglet';

wwv_flow_api.create_message (
  p_id=>195569115842151526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page en cours';

wwv_flow_api.create_message (
  p_id=>195569219984151526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195569331807151526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.COPIED_FROM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de cette liste de valeurs (LOV).';

wwv_flow_api.create_message (
  p_id=>195569424515151526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.MASTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listes de valeurs (LOV) faisant référence à cette liste de valeurs';

wwv_flow_api.create_message (
  p_id=>195569512305151526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune liste de valeurs (LOV) n''est abonnée à cette liste de valeurs.';

wwv_flow_api.create_message (
  p_id=>195569627464151526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.NO_SUBSCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets parent';

wwv_flow_api.create_message (
  p_id=>195569725298151527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu d''onglets parent - Nouveau';

wwv_flow_api.create_message (
  p_id=>195569805090151527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET_NEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte d''onglet parent';

wwv_flow_api.create_message (
  p_id=>195569929412151527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Séquence d''onglets';

wwv_flow_api.create_message (
  p_id=>195570031829151527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SEQUENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Image en cours';

wwv_flow_api.create_message (
  p_id=>195570118440151527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_IMAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_page_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles de page faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195570211644151527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.PAGE_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message non_current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Image non en cours';

wwv_flow_api.create_message (
  p_id=>195570331398151528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NON_CURRENT_IMAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Attributs d''image';

wwv_flow_api.create_message (
  p_id=>195570414159151528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE_ATTRIBUTES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Condition d''affichage';

wwv_flow_api.create_message (
  p_id=>195570500637151528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message condition_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type de condition';

wwv_flow_api.create_message (
  p_id=>195570608148151528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITION_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte de condition d''affichage';

wwv_flow_api.create_message (
  p_id=>195570701159151528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195570824496151528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.COPIED_FROM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_table_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nom de table existe déjà.';

wwv_flow_api.create_message (
  p_id=>195570900317151529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.TABLE_ALREADY_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Option de construction';

wwv_flow_api.create_message (
  p_id=>195571013901151529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILD_OPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de cette barre de navigation.';

wwv_flow_api.create_message (
  p_id=>195571117277151529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.MASTER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La longueur de colonne ne peut pas être égale à zéro.';

wwv_flow_api.create_message (
  p_id=>195571206109151529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_ZERO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La longueur de colonne ne peut pas être Null.';

wwv_flow_api.create_message (
  p_id=>195571321949151529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Barres de navigation faisant référence à cette barre de navigation';

wwv_flow_api.create_message (
  p_id=>195571428052151529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les noms de colonne ne doivent pas dépasser 30 caractères.';

wwv_flow_api.create_message (
  p_id=>195571515962151530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les noms de colonne ne peuvent pas avoir la valeur Null.';

wwv_flow_api.create_message (
  p_id=>195571625844151530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_NULL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune barre de navigation n''est abonnée à cette barre de navigation.';

wwv_flow_api.create_message (
  p_id=>195571709495151530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.NO_SUBSCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_table_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les noms de table ne doivent pas dépasser 30 caractères.';

wwv_flow_api.create_message (
  p_id=>195571811529151530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.TABLE_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_not_valid_pk_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> n''est pas un nom de clé primaire valide.';

wwv_flow_api.create_message (
  p_id=>195571906958151530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.NOT_VALID_PK_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p173_no_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'il n''y a pas d''aide pour cet élément';

wwv_flow_api.create_message (
  p_id=>195572020696151530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P173_NO_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_name_already_used
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> est déjà utilisé par un objet existant.';

wwv_flow_api.create_message (
  p_id=>195572123686151530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NAME_ALREADY_USED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_err_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 Impossible de déterminer la liste de valeurs (LOV) à partir de "declare function x return varchar2 is begin %0 return null; end; begin wwv_flow_utilities.g_query := x; end;".';

wwv_flow_api.create_message (
  p_id=>195572227764151531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ERR_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_not_valid_seq_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> n''est pas un nom de séquence valide.';

wwv_flow_api.create_message (
  p_id=>195572321472151531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NOT_VALID_SEQ_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ajouter';

wwv_flow_api.create_message (
  p_id=>195572422138151531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ADD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> n''est pas un nom de table valide.';

wwv_flow_api.create_message (
  p_id=>195572517698151531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_TABLE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enlever';

wwv_flow_api.create_message (
  p_id=>195572604581151531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.REMOVE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> n''est pas un nom d''objet valide.';

wwv_flow_api.create_message (
  p_id=>195572704103151531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_OBJECT_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_table_not_found_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table <b>%0</b> introuvable dans le schéma <b>%1</b>.';

wwv_flow_api.create_message (
  p_id=>195572801131151532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.TABLE_NOT_FOUND_IN_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_no_matches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Absence de correspondances.';

wwv_flow_api.create_message (
  p_id=>195572921212151532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NO_MATCHES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_prev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Précédent';

wwv_flow_api.create_message (
  p_id=>195573005100151532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.PREV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_need_unique_execution_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Saisissez un numéro d''ordre d''exécution unique.';

wwv_flow_api.create_message (
  p_id=>195573108207151532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NEED_UNIQUE_EXECUTION_ORDER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_copied_from_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copié à partir de l''application';

wwv_flow_api.create_message (
  p_id=>195573200415151532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_COPIED_FROM_APP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suivant';

wwv_flow_api.create_message (
  p_id=>195573319132151532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_cal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendrier';

wwv_flow_api.create_message (
  p_id=>195573411258151533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fermer';

wwv_flow_api.create_message (
  p_id=>195573521897151533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CLOSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_ok
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'OK';

wwv_flow_api.create_message (
  p_id=>195573624708151533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.OK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_search_dialog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dialogue de recherche';

wwv_flow_api.create_message (
  p_id=>195573707258151533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SEARCH_DIALOG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_find
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rechercher %0';

wwv_flow_api.create_message (
  p_id=>195573809495151533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.FIND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_region_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles de région faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195573913522151533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REGION_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_js_no_support
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'JavaScript non pris en charge';

wwv_flow_api.create_message (
  p_id=>195574027715151534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.JS_NO_SUPPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_master_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ceci est la copie maître de ce modèle.';

wwv_flow_api.create_message (
  p_id=>195574102715151534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_MASTER_COPY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste';

wwv_flow_api.create_message (
  p_id=>195574204806151534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_list_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles de liste faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195574315336151534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.LIST_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_button_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles de bouton faisant référence à ce modèle';

wwv_flow_api.create_message (
  p_id=>195574423638151534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_BUTTON_TEMPL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_no_subscirbers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun modèle n''est abonné à ce modèle.';

wwv_flow_api.create_message (
  p_id=>195574532686151534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_NO_SUBSCIRBERS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_lov2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur : %0 lors de l''exécution de l''interrogation de liste de valeurs (LOV) "%1".';

wwv_flow_api.create_message (
  p_id=>195574631797151535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LOV2_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_region_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Thème';

wwv_flow_api.create_message (
  p_id=>195574714985151535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REGION_TEMPLATE.THEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_page_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Thème';

wwv_flow_api.create_message (
  p_id=>195574806731151535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_PAGE_TEMPLATE.THEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_list_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Thème';

wwv_flow_api.create_message (
  p_id=>195574910311151535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LIST_TEMPLATE.THEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_label_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Thème';

wwv_flow_api.create_message (
  p_id=>195575018346151535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LABEL_TEMPLATE.THEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_report_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Thème';

wwv_flow_api.create_message (
  p_id=>195575130605151535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REPORT_TEMPLATE.THEME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eléments de page';

wwv_flow_api.create_message (
  p_id=>195575201494151536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.PAGE_ITEMS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Région';

wwv_flow_api.create_message (
  p_id=>195575312826151536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_default_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référencé en tant que modèle par défaut d''application';

wwv_flow_api.create_message (
  p_id=>195575429226151536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.DEFAULT_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_printer_friendly_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référencé en tant que modèle d''impression facile';

wwv_flow_api.create_message (
  p_id=>195575508069151536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PRINTER_FRIENDLY_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_error_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référencé en tant que modèle d''erreur.';

wwv_flow_api.create_message (
  p_id=>195575625374151536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.ERROR_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Référencé dans les pages';

wwv_flow_api.create_message (
  p_id=>195575718842151536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_not_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ce modèle de page n''est PAS référencé.';

wwv_flow_api.create_message (
  p_id=>195575824427151537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.NOT_REFERENCED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de page ';

wwv_flow_api.create_message (
  p_id=>195575914485151537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''arborescence';

wwv_flow_api.create_message (
  p_id=>195576024385151537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type';

wwv_flow_api.create_message (
  p_id=>195576113043151537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Elément';

wwv_flow_api.create_message (
  p_id=>195576219964151537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation d''arborescence';

wwv_flow_api.create_message (
  p_id=>195576306031151537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_show_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher la source';

wwv_flow_api.create_message (
  p_id=>195576422312151538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_SHOW_SOURCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_hide_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Masquer la source';

wwv_flow_api.create_message (
  p_id=>195576506725151538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_HIDE_SOURCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195576615283151538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèle de liste';

wwv_flow_api.create_message (
  p_id=>195576704689151538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_seq
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Séquence';

wwv_flow_api.create_message (
  p_id=>195576819602151538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_SEQ',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte';

wwv_flow_api.create_message (
  p_id=>195576930499151538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cible';

wwv_flow_api.create_message (
  p_id=>195577018007151539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TARGET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eléments de page';

wwv_flow_api.create_message (
  p_id=>195577127489151539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Région';

wwv_flow_api.create_message (
  p_id=>195577213660151539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_set_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'cliquez ici pour définir une région';

wwv_flow_api.create_message (
  p_id=>195577308012151539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.SET_REGION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_prompt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invite';

wwv_flow_api.create_message (
  p_id=>195577421647151539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PROMPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_no_item_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun élément trouvé';

wwv_flow_api.create_message (
  p_id=>195577512998151539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_apply_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'appliquer des permissions';

wwv_flow_api.create_message (
  p_id=>195577604366151539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_APPLY_PERMISSIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur d''affichage';

wwv_flow_api.create_message (
  p_id=>195577725768151540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISPLAY_VALUE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Renvoyer valeur';

wwv_flow_api.create_message (
  p_id=>195577804875151540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.RETURN_VALUE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_revoke_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'révoquer des autorisations';

wwv_flow_api.create_message (
  p_id=>195577906185151540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_REVOKE_PERMISSIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur par défaut';

wwv_flow_api.create_message (
  p_id=>195578028844151540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DEFAULT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_primary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne de tri primaire';

wwv_flow_api.create_message (
  p_id=>195578123174151540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.PRIMARY_SORT_COL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_noaction_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aucune action requise';

wwv_flow_api.create_message (
  p_id=>195578204592151540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_NOACTION_REQUIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_secondary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne de tri secondaire';

wwv_flow_api.create_message (
  p_id=>195578327181151541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SECONDARY_SORT_COL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_select_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sélectionner une colonne';

wwv_flow_api.create_message (
  p_id=>195578423739151541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SELECT_COL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_disable_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Désactiver la colonne de tri';

wwv_flow_api.create_message (
  p_id=>195578507701151541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISABLE_SORT_COL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_manager_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Avertissement : La cible d''onglet parent "%0" semble faire référence à une page qui n''existe pas.';

wwv_flow_api.create_message (
  p_id=>195578603722151541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_MANAGER.WARNING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la régénération de l''aide sur l''élément suivant.';

wwv_flow_api.create_message (
  p_id=>195578716140151541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Si c''est correct, cliquez sur Régénérer tout. Sinon, cliquez sur Annuler.';

wwv_flow_api.create_message (
  p_id=>195578817809151541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_confirm_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous êtes sur le point de supprimer un modèle d''authentification pour l''application %0. Si l''application n''utilise pas actuellement l''authentification SCHEME ou si le modèle considéré n''est pas le modèle d''authentification en cours, la suppression n''a pas d''incidence sur le fonctionnement de l''application. Si l''application utilise l''authentification SCHEME et que ce modèle est le modèle d''authenti';

h:=h||'fication en cours, l''application va continuer à fonctionner avec l''authentification SCHEME, mais elle utilisera un modèle d''authentification par défaut. Ce dernier utilisera une page de connexion intégrée avec vérification des informations d''identification et de connexion "porte ouverte" (autrement dit,  tout le monde sera autorisé à exécuter l''application). ';

wwv_flow_api.create_message (
  p_id=>195578915904151542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.CONFIRM_DELETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_dup_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Les noms de colonne <b>%0</b> sont utilisés plusieurs fois dans cette table.';

wwv_flow_api.create_message (
  p_id=>195579013613151542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.DUP_COL_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_nbr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La précision de la colonne <b>%0</b> n''est pas valide (1 - 38).<br />';

wwv_flow_api.create_message (
  p_id=>195579100626151542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_NBR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''échelle de la colonne <b>%0</b> n''est pas valide (-84 - 127).<br />';

wwv_flow_api.create_message (
  p_id=>195579227106151542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_SCALE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_char
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La précision de la colonne <b>%0</b> n''est pas valide (%1 - %2).<br />';

wwv_flow_api.create_message (
  p_id=>195579307694151542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_CHAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nom de colonne <b>%0</b> n''est pas valide.<br />';

wwv_flow_api.create_message (
  p_id=>195579426476151542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_COL_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_enter_at_least_one_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Au moins un nom de colonne doit être indiqué.';

wwv_flow_api.create_message (
  p_id=>195579525758151543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.ENTER_AT_LEAST_ONE_COL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_dup_arg_names
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nom d''argument <b>%0</b> est utilisé plusieurs fois dans cette fonction.<br />';

wwv_flow_api.create_message (
  p_id=>195579624456151543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.DUP_ARG_NAMES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p232_reset_css
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Réinitialiser la feuille de style CSS';

wwv_flow_api.create_message (
  p_id=>195579728697151543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P232_RESET_CSS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_native
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Format de fichier natif';

wwv_flow_api.create_message (
  p_id=>195579821118151543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_NATIVE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_text_file_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voir le document en tant que texte';

wwv_flow_api.create_message (
  p_id=>195579926295151543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_TEXT_FILE_FORMAT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_parse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analyser ce script';

wwv_flow_api.create_message (
  p_id=>195580010898151543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_PARSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_show_all_workspaces
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher tous les espaces de travail';

wwv_flow_api.create_message (
  p_id=>195580108910151544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_SHOW_ALL_WORKSPACES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonnes';

wwv_flow_api.create_message (
  p_id=>195580225068151544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.COLUMNS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_conditions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Conditions';

wwv_flow_api.create_message (
  p_id=>195580300108151544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.CONDITIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Flèche vers le bas';

wwv_flow_api.create_message (
  p_id=>195580403729151544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_DOWN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Flèche vers la droite';

wwv_flow_api.create_message (
  p_id=>195580524006151544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_RIGHT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'AND';

wwv_flow_api.create_message (
  p_id=>195580623168151544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.AND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_or
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'OR';

wwv_flow_api.create_message (
  p_id=>195580706864151545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.OR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_preview
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aperçu de condition';

wwv_flow_api.create_message (
  p_id=>195580801567151545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.PREVIEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la régénération des modèles d''authentification suivants';

wwv_flow_api.create_message (
  p_id=>195580927043151545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.REFRESH',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_make_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cliquez sur le bouton Rendre en cours pour que votre application utilise ce modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195581010603151545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.MAKE_CURRENT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le script de création de la table %0 a été créé dans le référentiel de scripts SQL.';

wwv_flow_api.create_message (
  p_id=>195581123669151545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_repository
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accéder au référentiel de scripts';

wwv_flow_api.create_message (
  p_id=>195581203248151545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''accueil SQL Workshop';

wwv_flow_api.create_message (
  p_id=>195581308013151546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exécuter un script';

wwv_flow_api.create_message (
  p_id=>195581413237151546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RUN_SCRIPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Retour à';

wwv_flow_api.create_message (
  p_id=>195581500710151546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RETURN_TO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;Workshop';

wwv_flow_api.create_message (
  p_id=>195581609885151546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''accueil';

wwv_flow_api.create_message (
  p_id=>195581714958151546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le package "%0" a été créé dans le schéma "%1".';

wwv_flow_api.create_message (
  p_id=>195581812778151546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parcourir un package';

wwv_flow_api.create_message (
  p_id=>195581917578151547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BROWSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''accueil SQL Workshop';

wwv_flow_api.create_message (
  p_id=>195582021357151547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Retour à';

wwv_flow_api.create_message (
  p_id=>195582111052151547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.RETURN_TO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;Workshop';

wwv_flow_api.create_message (
  p_id=>195582225603151547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page d''accueil';

wwv_flow_api.create_message (
  p_id=>195582331319151547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.HOME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Retour à l''assistant Création de table';

wwv_flow_api.create_message (
  p_id=>195582422119151547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BACK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_failed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la création de la table "%0".';

wwv_flow_api.create_message (
  p_id=>195582517190151548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.FAILED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message null_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(NULL)';

wwv_flow_api.create_message (
  p_id=>195582610642151548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NULL_IN_PAREN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_instruct_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le première ligne contient des noms de colonne.';

wwv_flow_api.create_message (
  p_id=>195582701651151548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300_INSTRUCT_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(table)';

wwv_flow_api.create_message (
  p_id=>195582800342151548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE_IN_PAREN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(vue)';

wwv_flow_api.create_message (
  p_id=>195582922961151548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_IN_PAREN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_applications
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Toutes les applications';

wwv_flow_api.create_message (
  p_id=>195583018994151548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_APPLICATIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message seconds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'secondes';

wwv_flow_api.create_message (
  p_id=>195583115474151549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECONDS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'minute';

wwv_flow_api.create_message (
  p_id=>195583228060151549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minutes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'minutes';

wwv_flow_api.create_message (
  p_id=>195583317236151549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hour
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'heure';

wwv_flow_api.create_message (
  p_id=>195583431278151549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOUR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'heures';

wwv_flow_api.create_message (
  p_id=>195583516428151549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOURS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message day
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'jour';

wwv_flow_api.create_message (
  p_id=>195583620346151549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'jours';

wwv_flow_api.create_message (
  p_id=>195583714466151550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAYS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message week
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'semaine';

wwv_flow_api.create_message (
  p_id=>195583826481151550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'semaines';

wwv_flow_api.create_message (
  p_id=>195583906845151550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message year
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'année';

wwv_flow_api.create_message (
  p_id=>195584020382151550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YEAR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tous les utilisateurs';

wwv_flow_api.create_message (
  p_id=>195584101942151550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_USERS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'dernier';

wwv_flow_api.create_message (
  p_id=>195584223214151550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'fonction';

wwv_flow_api.create_message (
  p_id=>195584300162151550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'index';

wwv_flow_api.create_message (
  p_id=>195584405870151551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INDEX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'package';

wwv_flow_api.create_message (
  p_id=>195584511796151551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PACKAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'procédure';

wwv_flow_api.create_message (
  p_id=>195584614544151551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCEDURE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'séquence';

wwv_flow_api.create_message (
  p_id=>195584701297151551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SEQUENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message synonym
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'synonyme';

wwv_flow_api.create_message (
  p_id=>195584830868151551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SYNONYM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'table';

wwv_flow_api.create_message (
  p_id=>195584913599151551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'déclencheur';

wwv_flow_api.create_message (
  p_id=>195585028836151552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vue';

wwv_flow_api.create_message (
  p_id=>195585113977151552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'insérer';

wwv_flow_api.create_message (
  p_id=>195585226186151552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSERT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'mettre à jour';

wwv_flow_api.create_message (
  p_id=>195585327958151552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'supprimer';

wwv_flow_api.create_message (
  p_id=>195585408389151552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_in_data_dict
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pas dans le dictionnaire de données';

wwv_flow_api.create_message (
  p_id=>195585524827151552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_IN_DATA_DICT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nouveau jeu d''onglets';

wwv_flow_api.create_message (
  p_id=>195585606888151553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_TABSET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Not';

wwv_flow_api.create_message (
  p_id=>195585725907151553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Historique des accès';

wwv_flow_api.create_message (
  p_id=>195585800456151553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MENU',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interrogation SQL';

wwv_flow_api.create_message (
  p_id=>195585928743151553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message structured_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'interrogation structurée';

wwv_flow_api.create_message (
  p_id=>195586010027151553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STRUCTURED_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function_body_returning_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Corps de fonction PL/SQL renvoyant une interrogation SQL';

wwv_flow_api.create_message (
  p_id=>195586114469151553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION_BODY_RETURNING_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Texte HTML';

wwv_flow_api.create_message (
  p_id=>195586224745151554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message plsql_procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>195586312602151554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLSQL_PROCEDURE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message anonymous_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'bloc anonyme';

wwv_flow_api.create_message (
  p_id=>195586419655151554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ANONYMOUS_BLOCK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message help_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'texte d''aide';

wwv_flow_api.create_message (
  p_id=>195586504269151554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HELP_TEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message web_service_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Résultat de service Web';

wwv_flow_api.create_message (
  p_id=>195586613686151554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEB_SERVICE_RESULT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'graphique';

wwv_flow_api.create_message (
  p_id=>195586727352151554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message simple
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'simple';

wwv_flow_api.create_message (
  p_id=>195586821424151555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIMPLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message escape_sc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'caractères spéciaux d''échappement';

wwv_flow_api.create_message (
  p_id=>195586930199151555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ESCAPE_SC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'avec raccourcis';

wwv_flow_api.create_message (
  p_id=>195587008762151555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WITH_SHORTCUTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'état modifiable';

wwv_flow_api.create_message (
  p_id=>195587103398151555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATEABLE_REPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>195587217830151555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'arborescence';

wwv_flow_api.create_message (
  p_id=>195587319323151555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TREE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'liste';

wwv_flow_api.create_message (
  p_id=>195587426156151556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'tous les thèmes';

wwv_flow_api.create_message (
  p_id=>195587529162151556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_THEMES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML';

wwv_flow_api.create_message (
  p_id=>195587615359151556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message driven
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'piloté';

wwv_flow_api.create_message (
  p_id=>195587704691151556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRIVEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Image';

wwv_flow_api.create_message (
  p_id=>195587804377151556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucun modèle';

wwv_flow_api.create_message (
  p_id=>195587926821151556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aucun élément';

wwv_flow_api.create_message (
  p_id=>195588011193151557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'liste de valeurs (LOV) instantanée';

wwv_flow_api.create_message (
  p_id=>195588120510151557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'POPUP_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message schemes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'modèles';

wwv_flow_api.create_message (
  p_id=>195588200783151557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SCHEMES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'raccourci';

wwv_flow_api.create_message (
  p_id=>195588303856151557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHORTCUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_page_as_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisez la page %0 comme page de connexion.';

wwv_flow_api.create_message (
  p_id=>195588423488151557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_PAGE_AS_LOGIN_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_new_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créez une nouvelle page de connexion.';

wwv_flow_api.create_message (
  p_id=>195588513493151557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_NEW_LOGIN_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_builtin_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utiliser la page de connexion intégrée';

wwv_flow_api.create_message (
  p_id=>195588601099151558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_BUILTIN_LOGIN_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'espace de travail';

wwv_flow_api.create_message (
  p_id=>195588711030151558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message core
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'principal';

wwv_flow_api.create_message (
  p_id=>195588829052151558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CORE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_static_files
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'tous les fichiers statiques';

wwv_flow_api.create_message (
  p_id=>195588923341151558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_STATIC_FILES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message associated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'associé';

wwv_flow_api.create_message (
  p_id=>195589000357151558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ASSOCIATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1816 Erreur inattendue lors de la conversion de l''alias d''application p_flow_alias_or_id (%0).';

wwv_flow_api.create_message (
  p_id=>195589102385151558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_not_logged_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non connecté. Le cookie requis pour l''authentification est absent ou non valide.';

wwv_flow_api.create_message (
  p_id=>195589216286151559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOT_LOGGED_IN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_click_to_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>Cliquez <a href="%0">ici</a> pour vous connecter</a>';

wwv_flow_api.create_message (
  p_id=>195589316909151559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLICK_TO_LOGIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-99900 Impossible de créer l''ID de session unique : %0';

wwv_flow_api.create_message (
  p_id=>195589414266151559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_SESSION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_session_info_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1029 Impossible de stocker les infos de session. session=%0 élément=%1';

wwv_flow_api.create_message (
  p_id=>195589505832151559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SESSION_INFO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_save_routine_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Erreur inattendue dans le sous-programme de sauvegarde.';

wwv_flow_api.create_message (
  p_id=>195589617196151559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SAVE_ROUTINE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_deeplinking_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Erreur inattendue dans make_deeplinking_item, session=%0';

wwv_flow_api.create_message (
  p_id=>195589722225151559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DEEPLINKING_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1002 ID d''élément introuvable pour l''élément "%0" dans l''application "%1".';

wwv_flow_api.create_message (
  p_id=>195589824090151560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur inattendue, nom d''élément introuvable au niveau application ou page.';

wwv_flow_api.create_message (
  p_id=>195589913480151560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1902 L''ID d''élément est Null dans le sous-programme find_item_name.';

wwv_flow_api.create_message (
  p_id=>195590031435151560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur inattendue';

wwv_flow_api.create_message (
  p_id=>195590112447151560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNEXPECTED_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1802 ID élément "%0" introuvable';

wwv_flow_api.create_message (
  p_id=>195590205555151560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1082 Erreur lors de l''exécution du code du modèle d''authentification.';

wwv_flow_api.create_message (
  p_id=>195590300289151560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AUTH_SCHEME_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_access_denied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès refusé par le contrôle de sécurité %0';

wwv_flow_api.create_message (
  p_id=>195590401101151561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ACCESS_DENIED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_first_page_data_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous êtes déjà dans la première page de données.';

wwv_flow_api.create_message (
  p_id=>195590522088151561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIRST_PAGE_DATA_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Erreur inattendue lors de la création de l''élément : FSP_PROCESS_STATE_%0';

wwv_flow_api.create_message (
  p_id=>195590612093151561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_ITEM_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1003 Erreur lors de l''exécution d''une interrogation de calcul.';

wwv_flow_api.create_message (
  p_id=>195590704484151561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_QUERY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1030 Erreur lors de l''exécution de l''expression de calcul.';

wwv_flow_api.create_message (
  p_id=>195590811387151561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_EXP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_function_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 Impossible de calculer la fonction. computation_point=%0 computation_type=%1';

wwv_flow_api.create_message (
  p_id=>195590911138151561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_FUNCTION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_unknown_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 Type de calcul inconnu';

wwv_flow_api.create_message (
  p_id=>195591004200151562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_UNKNOWN_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_validation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1006 Erreur dans le sous-programme de validation.';

wwv_flow_api.create_message (
  p_id=>195591122938151562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VALIDATION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 Impossible d''exécuter la validation "corps de fonction renvoyant du texte".';

wwv_flow_api.create_message (
  p_id=>195591223844151562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_TEXT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_bool_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1021 Impossible d''exécuter la validation "corps de fonction renvoyant une valeur booléenne"';

wwv_flow_api.create_message (
  p_id=>195591324932151562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_BOOL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_point_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1007 Le point de branchement ne peut pas être Null : %0';

wwv_flow_api.create_message (
  p_id=>195591417794151562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_POINT_NULL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1008 Erreur lors de l''exécution du branchement sur la page %0.';

wwv_flow_api.create_message (
  p_id=>195591515431151562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_PAGE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_accept_recur_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1010 Branchement sur un traitement d''acceptation de page : limite de récursivité dépassée. %0';

wwv_flow_api.create_message (
  p_id=>195591605478151562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ACCEPT_RECUR_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_funct_ret_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 Impossible de traiter un branchement sur une fonction renvoyant une page.';

wwv_flow_api.create_message (
  p_id=>195591701571151563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_FUNCT_RET_PAGE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_func_returning_url_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 Impossible de traiter un branchement sur une fonction renvoyant une URL.';

wwv_flow_api.create_message (
  p_id=>195591802925151563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_FUNC_RETURNING_URL_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1009 Erreur dans le traitement de branchement.';

wwv_flow_api.create_message (
  p_id=>195591900352151563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sql_exp_heading_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1910 Erreur lors de l''évaluation de l''expression SQL dans le texte d''en-tête.';

wwv_flow_api.create_message (
  p_id=>195592022587151563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SQL_EXP_HEADING_TEXT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_eval_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1011 Type d''évaluation non valide : %0';

wwv_flow_api.create_message (
  p_id=>195592104107151563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EVAL_TYPE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur';

wwv_flow_api.create_message (
  p_id=>195592224001151563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_g_flow_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 Erreur inattendue lors de l''affectation de G_FLOW_ID (%0).';

wwv_flow_api.create_message (
  p_id=>195592311465151564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.G_FLOW_ID_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1412 Impossible de résoudre l''alias de page (%0).';

wwv_flow_api.create_message (
  p_id=>195592415688151564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ALIAS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_call_to_show_from_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1430 Appel au processus d''affichage à partir de la page non pris en charge : G_FLOW_STEP_ID (%0).';

wwv_flow_api.create_message (
  p_id=>195592532705151564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CALL_TO_SHOW_FROM_PROC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7620 Impossible de déterminer l''espace de travail de l''application (%0).';

wwv_flow_api.create_message (
  p_id=>195592621821151564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID de groupe de sécurité du propriétaire d''application attendu dans le cookie p_company ou wwv_flow_company.';

wwv_flow_api.create_message (
  p_id=>195592729395151564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_FOOTER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 : Application introuvable.';

wwv_flow_api.create_message (
  p_id=>195592804066151564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informations d''espace de travail';

wwv_flow_api.create_message (
  p_id=>195592930135151565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.WORKSPACE_INFO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'application=%0  espace de travail=%1';

wwv_flow_api.create_message (
  p_id=>195593025203151565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_FOOTER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195593117877151565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_justification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Justification';

wwv_flow_api.create_message (
  p_id=>195593210338151565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.JUSTIFICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_login_server_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1555 Non connecté au serveur de connexion Oracle. Aucun utilisateur public n''est identifié.';

wwv_flow_api.create_message (
  p_id=>195593322256151565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGIN_SERVER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>195593412468151565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DESCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informations d''administrateur';

wwv_flow_api.create_message (
  p_id=>195593514600151566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ADMIN_INFO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_first_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prénom';

wwv_flow_api.create_message (
  p_id=>195593627563151566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.FIRST_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_last_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195593723798151566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.LAST_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Courrier électronique';

wwv_flow_api.create_message (
  p_id=>195593815674151566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.EMAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Téléphone';

wwv_flow_api.create_message (
  p_id=>195593913480151566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.PHONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informations de schéma';

wwv_flow_api.create_message (
  p_id=>195594007417151566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_INFO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Réutiliser un schéma existant';

wwv_flow_api.create_message (
  p_id=>195594111544151567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.REUSE_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oui';

wwv_flow_api.create_message (
  p_id=>195594228309151567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.YES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non';

wwv_flow_api.create_message (
  p_id=>195594314153151567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de schéma';

wwv_flow_api.create_message (
  p_id=>195594428140151567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1333 ASFCOOKIE n''a pas pu être extrait.';

wwv_flow_api.create_message (
  p_id=>195594521225151567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_db_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Taille de base de données';

wwv_flow_api.create_message (
  p_id=>195594614423151567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DB_SIZE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1201 ID de session non défini pour authentification personnalisée';

wwv_flow_api.create_message (
  p_id=>195594708311151568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'page=%0';

wwv_flow_api.create_message (
  p_id=>195594830932151568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_FOOTER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Saisissez un code de vérification sans distinction entre les majuscules et les minuscules et cliquez sur <b>Soumettre la demande</b>.';

wwv_flow_api.create_message (
  p_id=>195594914838151568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ACCEPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unsupp_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1444 Modèle d''authentification non pris en charge.';

wwv_flow_api.create_message (
  p_id=>195595005891151568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNSUPP_AUTH_SCHEME_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la fourniture d''infos de paramétrage pour un nouveau/une nouvelle %0.';

wwv_flow_api.create_message (
  p_id=>195595116530151568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informations d''espace de travail';

wwv_flow_api.create_message (
  p_id=>195595204415151568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.WORKSPACE_INFO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom';

wwv_flow_api.create_message (
  p_id=>195595300711151569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID de groupe de sécurité';

wwv_flow_api.create_message (
  p_id=>195595428724151569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SGID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_system_assigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Système affecté';

wwv_flow_api.create_message (
  p_id=>195595510728151569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SYSTEM_ASSIGNED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>195595605824151569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DESCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_inv_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 Application introuvable. Espace de travail non valide.';

wwv_flow_api.create_message (
  p_id=>195595720248151569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_INV_COMP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informations d''administrateur';

wwv_flow_api.create_message (
  p_id=>195595808970151569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.ADMIN_INFO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_user_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom utilisateur';

wwv_flow_api.create_message (
  p_id=>195595932531151569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.USER_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Courrier électronique';

wwv_flow_api.create_message (
  p_id=>195596013826151570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.EMAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Titre';

wwv_flow_api.create_message (
  p_id=>195596124921151570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'application=%0 espace de travail en cours=%1 espace de travail demandé=%2';

wwv_flow_api.create_message (
  p_id=>195596221722151570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_FOOTER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted_to_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''accès à cette application est réservé aux développeurs d''application ; ressayez plus tard.';

wwv_flow_api.create_message (
  p_id=>195596314997151570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED_TO_DEV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informations de schéma';

wwv_flow_api.create_message (
  p_id=>195596417422151570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_INFO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''accès à cette application est limité. Ressayez plus tard.';

wwv_flow_api.create_message (
  p_id=>195596511107151571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Réutiliser un schéma existant';

wwv_flow_api.create_message (
  p_id=>195596617941151571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.REUSE_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1181 Impossible de définir le contexte de sécurité VPD à l''affichage de la page.';

wwv_flow_api.create_message (
  p_id=>195596711187151571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oui';

wwv_flow_api.create_message (
  p_id=>195596808153151571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.YES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1111 asfcookie ne doit pas être Null.';

wwv_flow_api.create_message (
  p_id=>195596910365151571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_NULL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non';

wwv_flow_api.create_message (
  p_id=>195597015225151571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de schéma';

wwv_flow_api.create_message (
  p_id=>195597109359151571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_create_tblspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le tablespace sera créé';

wwv_flow_api.create_message (
  p_id=>195597217937151572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.CREATE_TBLSPACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1016 Application "%0" Page "%1" introuvable (langue demandée = "%2")';

wwv_flow_api.create_message (
  p_id=>195597307823151572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_NOT_FND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_flow_xxx
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'FLOW_XXX';

wwv_flow_api.create_message (
  p_id=>195597418296151572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.FLOW_XXX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Contactez l''administrateur de l''application.';

wwv_flow_api.create_message (
  p_id=>195597505513151572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CONTACT_ADMIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_datafile
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fichier de données pour tablespace';

wwv_flow_api.create_message (
  p_id=>195597600809151572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DATAFILE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_required_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le rôle requis n''est pas activé.';

wwv_flow_api.create_message (
  p_id=>195597708869151572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.REQUIRED_ROLE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_logout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Déconnexion';

wwv_flow_api.create_message (
  p_id=>195597832741151573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGOUT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1013 Absence de privilège pour l''opération tentée par l''utilisateur %0. Le rôle %1 est requis, contactez votre administrateur d''application.';

wwv_flow_api.create_message (
  p_id=>195597904567151573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_clear_step_cache_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1018 Erreur lors du nettoyage du cache d''étape.';

wwv_flow_api.create_message (
  p_id=>195598028579151573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLEAR_STEP_CACHE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_resolve_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1512 Impossible de résoudre l''alias de page (%0).';

wwv_flow_api.create_message (
  p_id=>195598131911151573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_RESOLVE_ALIAS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_on_accept_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7621 Impossible de déterminer l''espace de travail pour l''application (%0) à l''acceptation de l''application.';

wwv_flow_api.create_message (
  p_id=>195598227622151573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ON_ACCEPT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_comp_for_flow_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID de groupe de sécurité du propriétaire d''application attendu dans le cookie p_company ou wwv_flow_company.';

wwv_flow_api.create_message (
  p_id=>195598331075151573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMP_FOR_FLOW_FOOTER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1182 Impossible de définir le contexte de sécurité VPD lors de l''acceptation de page.';

wwv_flow_api.create_message (
  p_id=>195598408861151574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_insufficent_info_on_req_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-9988 Les informations fournies pour cette demande sont insuffisantes. Vous n''avez probablement pas attendu le chargement complet de la page précédente. Cliquez sur les boutons Précédent et Recharger ou Actualiser de votre navigateur, ou retournez à la page d''accueil de vos applications pour poursuivre.';

wwv_flow_api.create_message (
  p_id=>195598518007151574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.INSUFFICENT_INFO_ON_REQ_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_request_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'application=%0 page=%1 demande=%2';

wwv_flow_api.create_message (
  p_id=>195598613846151574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_REQUEST_FOOTER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_save_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1022 Impossible d''enregistrer les attributs.';

wwv_flow_api.create_message (
  p_id=>195598717381151574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_SAVE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1023 Impossible d''effectuer les validations.';

wwv_flow_api.create_message (
  p_id=>195598818079151574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_VALID_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_processing_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 Impossible de réaliser le traitement.';

wwv_flow_api.create_message (
  p_id=>195598924971151574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_PROCESSING_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_to_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1777 : La page %0 n''indique aucune page sur laquelle doit s''effectuer le branchement. Signalez cette erreur à votre administrateur d''application.';

wwv_flow_api.create_message (
  p_id=>195599028409151575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_TO_BRANCH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_restart_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<a href="f?p=%0">Redémarrer l''application</a>';

wwv_flow_api.create_message (
  p_id=>195599110561151575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.RESTART_APP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune aide n''est disponible pour la page.';

wwv_flow_api.create_message (
  p_id=>195599231908151575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_HELP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1019 Erreur lors du calcul de la valeur d''élément par défaut : page=%0 nom=%1.';

wwv_flow_api.create_message (
  p_id=>195599308621151575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_VAL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_plsql_item_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1020 Erreur lors du traitement d''élément PL/SQL (fonction)';

wwv_flow_api.create_message (
  p_id=>195599427557151575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.PLSQL_ITEM_PROC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1904 Impossible de calculer le type par défaut de l''élément = Corps de fonction computation_type = %0.';

wwv_flow_api.create_message (
  p_id=>195599508995151575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_FUNC_BODY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_post_calc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1079 Erreur lors du traitement post-calcul de l''élément';

wwv_flow_api.create_message (
  p_id=>195599614694151576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_POST_CALC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_spell_chk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vérification orthographique';

wwv_flow_api.create_message (
  p_id=>195599717520151576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.SPELL_CHK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 Erreur lors du traitement de l''expression PL/SQL. %0';

wwv_flow_api.create_message (
  p_id=>195599803247151576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application=%0 Page=%1 SQLERRM=%2';

wwv_flow_api.create_message (
  p_id=>195599900984151576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_FOOTER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_func_return_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1101 Impossible de traiter un corps de fonction renvoyant une interrogation.';

wwv_flow_api.create_message (
  p_id=>195600002287151576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FUNC_RETURN_QUERY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_proc_curr_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1108 Impossible de traiter la condition en cours de l''élément.';

wwv_flow_api.create_message (
  p_id=>195600105588151576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PROC_CURR_COND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unable_set_short_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-2904 Impossible de définir la valeur de raccourci.';

wwv_flow_api.create_message (
  p_id=>195600231060151577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNABLE_SET_SHORT_VAL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_trees_root_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Avertissement : ID de racine d''arborescence "%0" introuvable';

wwv_flow_api.create_message (
  p_id=>195600307792151577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREES.ROOT_NOT_FND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message v_alias_conversion_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 Erreur inattendue lors de la conversion d''alias d''application (%0).';

wwv_flow_api.create_message (
  p_id=>195600425693151577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'V.ALIAS_CONVERSION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application :';

wwv_flow_api.create_message (
  p_id=>195600523389151577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.APPLICATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page :';

wwv_flow_api.create_message (
  p_id=>195600606889151577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_plsql_lines_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 %1 PL/SQL contient %2 lignes de code source.';

wwv_flow_api.create_message (
  p_id=>195600715378151577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PLSQL_LINES_SOURCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<span class="tiny">Aucune page n''a été trouvée.</font>';

wwv_flow_api.create_message (
  p_id=>195600801525151578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_PAGES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 <font size=-2>Pages</span>';

wwv_flow_api.create_message (
  p_id=>195600925231151578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_det_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 Impossible de déterminer la liste de valeurs (LOV) à partir de "declare function x return varchar2 is begin %0  return null; end; begin wwv_flow_utilities.g_query := x; end;".';

wwv_flow_api.create_message (
  p_id=>195601025732151578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_DET_LOV_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_js_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'JavaScript non pris en charge';

wwv_flow_api.create_message (
  p_id=>195601123199151578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.JS_NOT_SUPPORTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste';

wwv_flow_api.create_message (
  p_id=>195601226475151578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_unassigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gérer ce qui n''est pas affecté';

wwv_flow_api.create_message (
  p_id=>195601320142151578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE_UNASSIGNED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Complémentaire';

wwv_flow_api.create_message (
  p_id=>195601413036151579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_split_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fractionnement complémentaire';

wwv_flow_api.create_message (
  p_id=>195601528811151579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_triade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Triade';

wwv_flow_api.create_message (
  p_id=>195601622128151579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TRIADE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_tetrade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tétrade';

wwv_flow_api.create_message (
  p_id=>195601700436151579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TETRADE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_analogic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analogique';

wwv_flow_api.create_message (
  p_id=>195601820671151579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_ANALOGIC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_monotone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Monotone';

wwv_flow_api.create_message (
  p_id=>195601912792151579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_MONOTONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary_colors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Couleurs complémentaires';

wwv_flow_api.create_message (
  p_id=>195602019325151580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fetch_value_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur d''application dans fetch_value.';

wwv_flow_api.create_message (
  p_id=>195602115506151580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FETCH_VALUE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_button_temp_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''extraction du modèle de bouton dont l''ID est %0';

wwv_flow_api.create_message (
  p_id=>195602227362151580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BUTTON_TEMP_FETCH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trace impossible : %0';

wwv_flow_api.create_message (
  p_id=>195602304884151580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_TRACE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_set_timed_stat_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de définir  timed_statistics : %0';

wwv_flow_api.create_message (
  p_id=>195602428383151580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_SET_TIMED_STAT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_available
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application non disponible';

wwv_flow_api.create_message (
  p_id=>195602521164151580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_AVAILABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_stop_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''arrêter la trace : %0';

wwv_flow_api.create_message (
  p_id=>195602600302151581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_STOP_TRACE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_view_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''application et la page doivent être indiquées pour l''affichage de l''aide.';

wwv_flow_api.create_message (
  p_id=>195602700948151581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VIEW_HELP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_not_disp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur : L''élément "%0" n''a pas été affiché car le panneau HTML n''était pas encore ouvert.';

wwv_flow_api.create_message (
  p_id=>195602830723151581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_NOT_DISP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_unable_cast_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de faire correspondre la valeur "%0" au masque de format de date %1.';

wwv_flow_api.create_message (
  p_id=>195602903215151581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.UNABLE_CAST_VALUE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modifier l''élément %0 - %1, séquence : %2';

wwv_flow_api.create_message (
  p_id=>195603008024151581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.EDIT ITEM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_reset_pag_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de réinitialiser la pagination de région';

wwv_flow_api.create_message (
  p_id=>195603108241151581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RESET_PAG_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_print_shortcut_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''imprimer le raccourci : %0';

wwv_flow_api.create_message (
  p_id=>195603221252151582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PRINT_SHORTCUT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_render_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''affichage du graphique : %0';

wwv_flow_api.create_message (
  p_id=>195603305621151582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RENDER_CHART_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_debug
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Déboguer :';

wwv_flow_api.create_message (
  p_id=>195603427169151582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.DEBUG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_feature_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonctionnalité non prise en charge dans cette version';

wwv_flow_api.create_message (
  p_id=>195603521379151582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FEATURE_NOT_SUPPORTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_request_for_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur 4322 - La syntaxe de la demande d''aide est incorrecte. Elle est Null alors qu''un numéro de page valide est attendu.';

wwv_flow_api.create_message (
  p_id=>195603614450151582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.REQUEST_FOR_HELP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_help_request_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur 4323 - La demande d''aide ne précise pas l''ID numérique de la page pour laquelle l''aide doit être affichée.';

wwv_flow_api.create_message (
  p_id=>195603704859151582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.HELP_REQUEST_ERR2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_init_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''initialiser l''interrogation.';

wwv_flow_api.create_message (
  p_id=>195603819648151583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_INIT_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_company_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Espace de travail obligatoire.';

wwv_flow_api.create_message (
  p_id=>195603909885151583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.COMPANY_REQUIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_flow_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application obligatoire.';

wwv_flow_api.create_message (
  p_id=>195604009061151583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.FLOW_REQUIRED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom utilisateur "%0" ou mot de passe non valide.';

wwv_flow_api.create_message (
  p_id=>195604114497151583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lignes';

wwv_flow_api.create_message (
  p_id=>195604221132151583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_ROWS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Axe';

wwv_flow_api.create_message (
  p_id=>195604314600151583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AXIS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_average
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Moyenne';

wwv_flow_api.create_message (
  p_id=>195604420931151584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AVERAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_sum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Total';

wwv_flow_api.create_message (
  p_id=>195604501154151584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_SUM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_maximum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Maximum';

wwv_flow_api.create_message (
  p_id=>195604630958151584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MAXIMUM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_minimum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Minimum';

wwv_flow_api.create_message (
  p_id=>195604707875151584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MINIMUM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dernier';

wwv_flow_api.create_message (
  p_id=>195604815054151584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_LAST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_first
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Premier';

wwv_flow_api.create_message (
  p_id=>195604928630151585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_FIRST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_go
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'OK';

wwv_flow_api.create_message (
  p_id=>195605001415151585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_GO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_chart_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type de graphique non valide.';

wwv_flow_api.create_message (
  p_id=>195605108025151585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_CHART_TYPE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_sso_redirect_to_login_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Réacheminement sur le serveur de connexion pour authentification ...';

wwv_flow_api.create_message (
  p_id=>195605210225151585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_SSO.REDIRECT_TO_LOGIN_SERVER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_line_too_long
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La longueur de ligne %0 dépasse de maximum de %1 (ligne %2).';

wwv_flow_api.create_message (
  p_id=>195605314757151585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.LINE_TOO_LONG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cochez les régions que vous voulez inclure dans la page. Les régions cochées peuvent ne pas s''afficher si vous n''êtes pas dans le bon contexte applicatif ou si vous ne disposez pas des privilèges appropriés.';

wwv_flow_api.create_message (
  p_id=>195605411421151585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune région personnalisable n''a été trouvée pour cette page.';

wwv_flow_api.create_message (
  p_id=>195605504676151585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fermer';

wwv_flow_api.create_message (
  p_id=>195605623499151586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CLOSE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Appliquer les modifications';

wwv_flow_api.create_message (
  p_id=>195605709293151586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_APPLY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_cust_opt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Options de personnalisation de page';

wwv_flow_api.create_message (
  p_id=>195605805067151586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CUST_OPT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeur par défaut';

wwv_flow_api.create_message (
  p_id=>195605921634151586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DEFAULT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_disp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Affiché';

wwv_flow_api.create_message (
  p_id=>195606029565151586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DISP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Masqué';

wwv_flow_api.create_message (
  p_id=>195606116951151586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_HIDDEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_func_body_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur d''analyse : le corps de fonction ne doit pas être Null.';

wwv_flow_api.create_message (
  p_id=>195606231977151587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.FUNC_BODY_NULL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur d''analyse : %0';

wwv_flow_api.create_message (
  p_id=>195606304982151587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.PARSE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_administration_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Obsolète';

wwv_flow_api.create_message (
  p_id=>195606428209151587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMINISTRATION.DEPRECATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 sessions ont été purgées.';

wwv_flow_api.create_message (
  p_id=>195606511734151587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_SESSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_dup_sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Purge de %0 sessions en double.';

wwv_flow_api.create_message (
  p_id=>195606609530151587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_DUP_SESSIONS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_obsolete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'obsolète';

wwv_flow_api.create_message (
  p_id=>195606726881151587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.OBSOLETE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_plsql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Condition d''expression PL/SQL non valide : %0';

wwv_flow_api.create_message (
  p_id=>195606801771151588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_PLSQL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Condition de corps de fonction non valide : %0';

wwv_flow_api.create_message (
  p_id=>195606918657151588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_FUNC_BODY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_sql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Condition d''expression SQL non valide : %0';

wwv_flow_api.create_message (
  p_id=>195607009429151588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_SQL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_exists_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Condition existe/n''existe pas non valide : %0';

wwv_flow_api.create_message (
  p_id=>195607101248151588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_EXISTS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de générer la liste de valeurs (LOV) instantanée avec filtre : %0';

wwv_flow_api.create_message (
  p_id=>195607219604151588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la génération de l''interrogation : %0';

wwv_flow_api.create_message (
  p_id=>195607324273151588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_QUERY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''initialisation de la liste de valeurs : %0 ';

wwv_flow_api.create_message (
  p_id=>195607423125151589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_LOV_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de lier "%0"';

wwv_flow_api.create_message (
  p_id=>195607524393151589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.UNABLE_TO_BIND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_disp_only_list_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur : Les listes de valeurs (LOV) Afficher uniquement doivent sélectionner deux colonnes.';

wwv_flow_api.create_message (
  p_id=>195607609284151589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.DISP_ONLY_LIST_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_auth_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''authentification de la liste de valeurs (LOV) instantanée a échoué.';

wwv_flow_api.create_message (
  p_id=>195607718077151589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_AUTH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_check_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La vérification de la liste de valeurs (LOV) instantanée par total de contrôle a échoué.';

wwv_flow_api.create_message (
  p_id=>195607811973151589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_CHECK_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''initialiser l''interrogation.';

wwv_flow_api.create_message (
  p_id=>195607912481151589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_QUERY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_checkbox_query_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''évaluation d''interrogation de case à cocher : %0';

wwv_flow_api.create_message (
  p_id=>195608008655151590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CHECKBOX_QUERY_LOV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_contains
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'contient';

wwv_flow_api.create_message (
  p_id=>195608124500151590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_CONTAINS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_regexp_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'recherche une expression régulière';

wwv_flow_api.create_message (
  p_id=>195608215814151590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_REGEXP_LIKE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bold
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gras';

wwv_flow_api.create_message (
  p_id=>195608311073151590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BOLD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_italics
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Italiques';

wwv_flow_api.create_message (
  p_id=>195608425235151590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_ITALICS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_underline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Souligner';

wwv_flow_api.create_message (
  p_id=>195608501596151590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_UNDERLINE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_no_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste numérotée';

wwv_flow_api.create_message (
  p_id=>195608611778151591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_NO_LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bull_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste à puces';

wwv_flow_api.create_message (
  p_id=>195608712425151591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BULL_LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aligner à gauche';

wwv_flow_api.create_message (
  p_id=>195608822145151591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_LEFT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_cen
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Centrer';

wwv_flow_api.create_message (
  p_id=>195608923178151591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_CEN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_rt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aligner à droite';

wwv_flow_api.create_message (
  p_id=>195609017878151591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_RT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indentation à gauche';

wwv_flow_api.create_message (
  p_id=>195609100452151591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_LEFT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indentation à droite';

wwv_flow_api.create_message (
  p_id=>195609209067151592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_RIGHT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_email_address
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Votre nouvelle adresse électronique pour votre compte Application Express.';

wwv_flow_api.create_message (
  p_id=>195609330690151592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_EMAIL_ADDRESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_worksheet_show_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''affichage de l''état : %0';

wwv_flow_api.create_message (
  p_id=>195609402107151592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WORKSHEET.SHOW_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer le package PL/SQL %0 avec les procédures suivantes :'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195609509309151592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_CREATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher la spécification';

wwv_flow_api.create_message (
  p_id=>195609603725151592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_SPEC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Masquer la spécification';

wwv_flow_api.create_message (
  p_id=>195609730320151592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_SPEC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Afficher le corps';

wwv_flow_api.create_message (
  p_id=>195609826101151592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Masquer le corps';

wwv_flow_api.create_message (
  p_id=>195609930753151593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Télécharger une spécification';

wwv_flow_api.create_message (
  p_id=>195610006238151593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_SPEC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Télécharger le corps';

wwv_flow_api.create_message (
  p_id=>195610121638151593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_subprogram
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sous-programme';

wwv_flow_api.create_message (
  p_id=>195610220224151593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SUBPROGRAM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>195610314998151593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESCRIPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'à utiliser pour l''insertion de données dans %0, la clé primaire doit être indiquée';

wwv_flow_api.create_message (
  p_id=>195610413976151593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'à utiliser pour mettre à jour les données dans %0 identifié par la ou les clés primaires';

wwv_flow_api.create_message (
  p_id=>195610508984151594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'utilisé pour supprimer des données dans %0 sur la base de la ou des clés primaires';

wwv_flow_api.create_message (
  p_id=>195610612344151594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC3',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'utilisé pour extraire des données de %0 sur la base de la ou des clés primaires';

wwv_flow_api.create_message (
  p_id=>195610729594151594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC4',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- API de table pour l''application %0, %1 généré';

wwv_flow_api.create_message (
  p_id=>195610822661151594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_COMMENT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_column_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune information de colonne disponible.';

wwv_flow_api.create_message (
  p_id=>195610904469151594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_COLUMN_INFO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url_prohibited
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''URL demandée est interdite. Contactez l''administrateur.';

wwv_flow_api.create_message (
  p_id=>195611010567151594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL_PROHIBITED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Corps HTML';

wwv_flow_api.create_message (
  p_id=>195611101856151595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BODY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_help_invalid_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID d''élément non valide : %0 ';

wwv_flow_api.create_message (
  p_id=>195611208588151595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM_HELP.INVALID_ITEM_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p_valid_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Un numéro de page valide doit être indiqué, par exemple p?n=1234.';

wwv_flow_api.create_message (
  p_id=>195611313384151595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P.VALID_PAGE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nom de modèle %0 existe déjà. Saisissez-en un autre.';

wwv_flow_api.create_message (
  p_id=>195611401748151595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_ALREADY_EXISTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous avez demandé la création d''une page d''état interactif avec les attributs suivants. Confirmez vos sélections.';

wwv_flow_api.create_message (
  p_id=>195611526855151595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message htmlwithshortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML avec raccourcis';

wwv_flow_api.create_message (
  p_id=>195611601533151596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTMLWITHSHORTCUTS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message print_server_not_configured
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''impression d''état n''est pas disponible actuellement. Aucun serveur d''impression n''est configuré.';

wwv_flow_api.create_message (
  p_id=>195611709166151596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PRINT SERVER NOT CONFIGURED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Modèles de liste';

wwv_flow_api.create_message (
  p_id=>195611819690151596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST_TEMPLATES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions_list_template_override
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Remplacement du modèle de liste de régions';

wwv_flow_api.create_message (
  p_id=>195611911164151596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS_LIST_TEMPLATE_OVERRIDE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regioin_references
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Références de région';

wwv_flow_api.create_message (
  p_id=>195612013849151596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIOIN_REFERENCES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_max_row_cnt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cette interrogation renvoie plus de %0 lignes. Filtrez vos données pour être sûr d''obtenir des résultats complets.';

wwv_flow_api.create_message (
  p_id=>195612119801151596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MAX_ROW_CNT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_doesnot_contain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ne contient pas';

wwv_flow_api.create_message (
  p_id=>195612223974151597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'est dans les dern.';

wwv_flow_api.create_message (
  p_id=>195612327570151597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_IN_LAST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_isnot_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'n''est pas dans les dern.';

wwv_flow_api.create_message (
  p_id=>195612400869151597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_mins
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'minutes';

wwv_flow_api.create_message (
  p_id=>195612505126151597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MINS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'heures';

wwv_flow_api.create_message (
  p_id=>195612602084151597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_HOURS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'jours';

wwv_flow_api.create_message (
  p_id=>195612719872151597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_DAYS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'semaines';

wwv_flow_api.create_message (
  p_id=>195612811313151597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_WEEKS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_months
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'mois';

wwv_flow_api.create_message (
  p_id=>195612907355151598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MONTHS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_years
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'années';

wwv_flow_api.create_message (
  p_id=>195613002988151598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_YEARS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message interactive_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Etat interactif';

wwv_flow_api.create_message (
  p_id=>195613103611151598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERACTIVE_REPORT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'et';

wwv_flow_api.create_message (
  p_id=>195613214691151598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p33_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Générer l''application de maintenance';

wwv_flow_api.create_message (
  p_id=>195613324932151598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P33_BREADCRUMB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Générer l''application';

wwv_flow_api.create_message (
  p_id=>195613423321151599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_BREADCRUMB',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ajouter une contrainte';

wwv_flow_api.create_message (
  p_id=>195613524436151599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADD_CONSTRAINT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Créer un index';

wwv_flow_api.create_message (
  p_id=>195613623177151599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_INDEX',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_app_defs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valeurs par défaut de l''application';

wwv_flow_api.create_message (
  p_id=>195613726478151599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_APP_DEFS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p24_save_to_worksheet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enregistrer dans une feuille de calcul';

wwv_flow_api.create_message (
  p_id=>195613811403151599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P24_SAVE_TO_WORKSHEET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wksp_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID d''espace de travail non valide.';

wwv_flow_api.create_message (
  p_id=>195613904148151600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WKSP_ID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_wkspc_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''espace de travail est introuvable.';

wwv_flow_api.create_message (
  p_id=>195614027679151600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_WKSPC_NOT_FOUND',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_loading_data
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chargement des données...';

wwv_flow_api.create_message (
  p_id=>195614113699151600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.LOADING_DATA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_waiting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chargement des données. Veuillez patienter.';

wwv_flow_api.create_message (
  p_id=>195614208526151600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.WAITING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''utilisateur %0 n''a pas de privilège sur le schéma %1.';

wwv_flow_api.create_message (
  p_id=>195614314069151600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_plan_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'table de plan créée pour faciliter l''instruction de plan d''exécution';

wwv_flow_api.create_message (
  p_id=>195614405149151600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_PLAN_TABLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_error_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur à la ligne %0 : %1';

wwv_flow_api.create_message (
  p_id=>195614525736151601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ERROR_MSG',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le schéma "%0" n''existe pas dans la base de données. Contactez votre administrateur d''espace de travail pour qu''il définisse pour vous un schéma par défaut correct.';

wwv_flow_api.create_message (
  p_id=>195614604617151601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_insert_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''insertion de script dans la table des fichiers.';

wwv_flow_api.create_message (
  p_id=>195614724451151601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.INSERT_SCRIPT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_parse_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''analyse du script.';

wwv_flow_api.create_message (
  p_id=>195614808388151601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.PARSE_SCRIPT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de création de fichier de script';

wwv_flow_api.create_message (
  p_id=>195614926581151601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_SCRIPT_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_not_implemented
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non implémenté.';

wwv_flow_api.create_message (
  p_id=>195615019243151601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NOT_IMPLEMENTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_product_build
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Build du produit :';

wwv_flow_api.create_message (
  p_id=>195615130004151602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.PRODUCT_BUILD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_schema_compatibility
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compatibilité de schéma :';

wwv_flow_api.create_message (
  p_id=>195615205546151602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.SCHEMA_COMPATIBILITY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_last_ddl_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Heure du dernier DDL :';

wwv_flow_api.create_message (
  p_id=>195615326804151602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LAST_DDL_TIME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_host_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schéma d''hôte :';

wwv_flow_api.create_message (
  p_id=>195615417810151602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.HOST_SCHEMA',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_application_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Propriétaire d''application :';

wwv_flow_api.create_message (
  p_id=>195615526245151602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.APPLICATION_OWNER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID d''espace de travail :';

wwv_flow_api.create_message (
  p_id=>195615604868151602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_ID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom d''espace de travail :';

wwv_flow_api.create_message (
  p_id=>195615720764151603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisateur en cours :';

wwv_flow_api.create_message (
  p_id=>195615810110151603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_USER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_language_preference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Préférence de langue :';

wwv_flow_api.create_message (
  p_id=>195615915862151603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LANGUAGE_PREFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_time_on_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date/Heure actuelle (sur le serveur) :';

wwv_flow_api.create_message (
  p_id=>195616000820151603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_TIME_ON_SERVER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_add_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ajoutez une erreur de membre.';

wwv_flow_api.create_message (
  p_id=>195616125006151603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ADD_MEMBER_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_update_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de mise à jour de membre';

wwv_flow_api.create_message (
  p_id=>195616206582151603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.UPDATE_MEMBER_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création du script.';

wwv_flow_api.create_message (
  p_id=>195616311304151604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans portal_sso_redirect : informations d''inscription d''application absentes :';

wwv_flow_api.create_message (
  p_id=>195616414995151604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inscrivez cette application comme indiqué dans le guide d''installation.';

wwv_flow_api.create_message (
  p_id=>195616528401151604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_redir_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter la procédure portal_sso_redirect en tant que schéma %0 avec le nom d''application partenaire %1.';

wwv_flow_api.create_message (
  p_id=>195616615609151604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.REDIR_ERR1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Appelant de la procédure %0 non valide :';

wwv_flow_api.create_message (
  p_id=>195616716180151604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR1',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message please_contact_administrator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Contactez l''administrateur.';

wwv_flow_api.create_message (
  p_id=>195616830080151604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLEASE_CONTACT_ADMINISTRATOR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la détermination de l''appelant de %0';

wwv_flow_api.create_message (
  p_id=>195616908650151605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR2',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_invalid_app_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Session d''application non valide dans le token URLC : %0';

wwv_flow_api.create_message (
  p_id=>195617019367151605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.INVALID_APP_SESSION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_generic_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans %0';

wwv_flow_api.create_message (
  p_id=>195617117230151605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_bad_urlc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 non valide dans le token %1 renvoyé par SSO.';

wwv_flow_api.create_message (
  p_id=>195617224745151605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.BAD_URLC',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''exécuter la procédure %0 en tant que schéma %1 avec le nom d''application partenaire %2';

wwv_flow_api.create_message (
  p_id=>195617322335151605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PARSE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unknown_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur : type de raccourci inconnu.';

wwv_flow_api.create_message (
  p_id=>195617413232151605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNKNOWN_TYPE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_add_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ajouter un mot';

wwv_flow_api.create_message (
  p_id=>195617502202151606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ADD_WORD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_word_added
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 ajouté à votre dictionnaire.';

wwv_flow_api.create_message (
  p_id=>195617606041151606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.WORD_ADDED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_dup_word_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 figure déjà dans votre dictionnaire.';

wwv_flow_api.create_message (
  p_id=>195617731597151606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.DUP_WORD_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Terminé';

wwv_flow_api.create_message (
  p_id=>195617813502151606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_DONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Annuler';

wwv_flow_api.create_message (
  p_id=>195617902638151606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_CANCEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_apply_changes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Appliquer les modifications';

wwv_flow_api.create_message (
  p_id=>195618017795151606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_APPLY_CHANGES',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_add_to_dictionary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ajouter au dictionnaire';

wwv_flow_api.create_message (
  p_id=>195618131687151606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_ADD_TO_DICTIONARY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_pick_a_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sélectionner un mot';

wwv_flow_api.create_message (
  p_id=>195618220126151607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.PICK_A_WORD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_enter_new_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Saisissez un nouveau mot.';

wwv_flow_api.create_message (
  p_id=>195618313066151607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ENTER_NEW_WORD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_tree_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur inattendue : %0';

wwv_flow_api.create_message (
  p_id=>195618421581151607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREE.UNEXPECTED_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_window_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calculateur';

wwv_flow_api.create_message (
  p_id=>195618511409151607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.WINDOW_TITLE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Annuler';

wwv_flow_api.create_message (
  p_id=>195618603060151607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.CANCEL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Terminé';

wwv_flow_api.create_message (
  p_id=>195618714964151608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.DONE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_flow_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune application n''est sélectionnée.';

wwv_flow_api.create_message (
  p_id=>195618821984151608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_FLOW_SELECTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message vertical
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vertical';

wwv_flow_api.create_message (
  p_id=>195618915772151608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VERTICAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message horizontal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'horizontal';

wwv_flow_api.create_message (
  p_id=>195619029984151608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HORIZONTAL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom utilisateur';

wwv_flow_api.create_message (
  p_id=>195619122552151608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_USERNAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_user_api_t_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Courrier électronique';

wwv_flow_api.create_message (
  p_id=>195619205039151608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_USER_API.T_EMAIL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_password
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mot de passe';

wwv_flow_api.create_message (
  p_id=>195619306723151608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PASSWORD',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_privilege
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Privilèges';

wwv_flow_api.create_message (
  p_id=>195619414187151609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PRIVILEGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 utilisateurs auraient été chargés.';

wwv_flow_api.create_message (
  p_id=>195619518302151609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_MESSAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Historique des accès';

wwv_flow_api.create_message (
  p_id=>195619628806151609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur';

wwv_flow_api.create_message (
  p_id=>195619720646151609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_max_rows_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : le nombre maximum de lignes à afficher doit être supérieur à zéro.';

wwv_flow_api.create_message (
  p_id=>195619819574151609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MAX_ROWS_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_invalid_col_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'nombre de colonnes défini dans l''interrogation non valide, ce type de région requiert %0 colonnes';

wwv_flow_api.create_message (
  p_id=>195619922925151609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.INVALID_COL_NUM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la navigation : le maximum d''axe doit être supérieur au minimum d''axe.';

wwv_flow_api.create_message (
  p_id=>195620002197151610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_bar_width_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : la largeur de la barre doit être supérieure à zéro.';

wwv_flow_api.create_message (
  p_id=>195620123590151610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.BAR_WIDTH_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : l''intervalle d''axe doit être supérieur à zéro.';

wwv_flow_api.create_message (
  p_id=>195620211749151610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la navigation : le minimum d''axe doit être supérieur ou égal à zéro.';

wwv_flow_api.create_message (
  p_id=>195620303872151610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : le maximum d''axe doit être supérieur à zéro.';

wwv_flow_api.create_message (
  p_id=>195620415292151610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_invalid_no_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'interrogation non valide, absence d''instruction SELECT';

wwv_flow_api.create_message (
  p_id=>195620528449151610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY.INVALID_NO_SELECT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_gaps_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : l''espace entre les barres doit être supérieur ou égal à zéro.';

wwv_flow_api.create_message (
  p_id=>195620624903151611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.GAPS_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : le maximum de l''axe des Y doit être supérieur au minimum d''axe.';

wwv_flow_api.create_message (
  p_id=>195620730950151611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : l''intervalle de l''axe des X doit être supérieur à zéro.';

wwv_flow_api.create_message (
  p_id=>195620803609151611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : l''intervalle de l''axe des Y doit être supérieur à zéro.';

wwv_flow_api.create_message (
  p_id=>195620906127151611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la navigation : le minimum de l''axe des X doit être supérieur ou égal à zéro.';

wwv_flow_api.create_message (
  p_id=>195621026697151611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la navigation : le minimum de l''axe des Y doit être supérieur ou égal à zéro.';

wwv_flow_api.create_message (
  p_id=>195621122655151612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : le maximum de l''axe des X doit être supérieur à zéro.';

wwv_flow_api.create_message (
  p_id=>195621202768151612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la validation : le maximum de l''axe des Y doit être supérieur à zéro.';

wwv_flow_api.create_message (
  p_id=>195621323837151612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_get_color_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''obtenir la couleur : %0';

wwv_flow_api.create_message (
  p_id=>195621424860151612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_GET_COLOR_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_func_ret_sql_qry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction renvoyant une interrogation SQL : l''interrogation ne peut pas être analysée dans Application Builder. %0';

wwv_flow_api.create_message (
  p_id=>195621516085151612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FUNC_RET_SQL_QRY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur d''analyse : %0 ';

wwv_flow_api.create_message (
  p_id=>195621605402151612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.PARSE_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_fetch_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur d''extraction : %0';

wwv_flow_api.create_message (
  p_id=>195621711496151612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FETCH_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_calc_graph_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de calculer la position du contenant du graphique : %0';

wwv_flow_api.create_message (
  p_id=>195621825379151613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_CALC_GRAPH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_svg_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de graphique SVG : %0';

wwv_flow_api.create_message (
  p_id=>195621909144151613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.SVG_CHART_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_more_data_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'D''autres données ont été trouvées, mais seules 30 valeurs peuvent être affichées.';

wwv_flow_api.create_message (
  p_id=>195622021392151613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MORE_DATA_FND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tout en haut';

wwv_flow_api.create_message (
  p_id=>195622115357151613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_TOP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tout en bas';

wwv_flow_api.create_message (
  p_id=>195622225569151613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_BOTTOM',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_up
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Haut';

wwv_flow_api.create_message (
  p_id=>195622312989151613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_UP',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bas';

wwv_flow_api.create_message (
  p_id=>195622408634151614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_DOWN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Déplacer';

wwv_flow_api.create_message (
  p_id=>195622512144151614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Déplacer tout';

wwv_flow_api.create_message (
  p_id=>195622612323151614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE_ALL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enlever';

wwv_flow_api.create_message (
  p_id=>195622718776151614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enlever tout';

wwv_flow_api.create_message (
  p_id=>195622813267151614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE_ALL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Réinitialiser';

wwv_flow_api.create_message (
  p_id=>195622911771151614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_RESET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_unable_fnd_userid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de trouver l''ID utilisateur (USERID) dans le cookie : %0';

wwv_flow_api.create_message (
  p_id=>195623017770151615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.UNABLE_FND_USERID_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_exception
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exception';

wwv_flow_api.create_message (
  p_id=>195623125143151615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.EXCEPTION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur : %0';

wwv_flow_api.create_message (
  p_id=>195623222751151615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_invalid_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ASFCOOKIE non valide, reconnectez-vous à votre application.';

wwv_flow_api.create_message (
  p_id=>195623313432151615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.INVALID_COOKIE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_creating_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Création de l''espace de travail';

wwv_flow_api.create_message (
  p_id=>195623406043151615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CREATING_WORKSPACE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suivant';

wwv_flow_api.create_message (
  p_id=>195623527106151615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu suivant';

wwv_flow_api.create_message (
  p_id=>195623601776151616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Précédent';

wwv_flow_api.create_message (
  p_id=>195623718848151616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jeu précédent';

wwv_flow_api.create_message (
  p_id=>195623803818151616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS_SET',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom utilisateur ou mot de passe non valide, ou cookie expiré. Reconnectez-vous.';

wwv_flow_api.create_message (
  p_id=>195623914482151616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS_COOKIE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_from_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 de l''interrogation %1';

wwv_flow_api.create_message (
  p_id=>195624007604151616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FROM_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_in_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 dans l''interrogation %1';

wwv_flow_api.create_message (
  p_id=>195624127910151616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.IN_QUERY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_fetch_cal_cursor_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''extraction à partir du curseur de calendrier : %0';

wwv_flow_api.create_message (
  p_id=>195624218947151617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FETCH_CAL_CURSOR_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_no_sgid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''ID de groupe de sécurité (identité de votre espace de travail) n''est pas défini.';

wwv_flow_api.create_message (
  p_id=>195624311599151617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.NO_SGID_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur au cours de l''exécution de wwv_flow_copy : %0 >> %1';

wwv_flow_api.create_message (
  p_id=>195624402883151617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.EXECUTION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_button_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur au cours de l''exécution de wwv_flow_copy_button : %0 >> %1';

wwv_flow_api.create_message (
  p_id=>195624523886151617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_BUTTON.EXECUTION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_item_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur au cours de l''exécution de wwv_flow_copy_page_item : %0 >> %1';

wwv_flow_api.create_message (
  p_id=>195624628795151617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE_ITEM.EXECUTION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''ID de liste de valeurs (LOV) "%0" n''est pas numérique.';

wwv_flow_api.create_message (
  p_id=>195624709805151617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NUMERIC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''ID de liste de valeurs (LOV) "%0" est introuvable.';

wwv_flow_api.create_message (
  p_id=>195624816168151618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NOT_FOUND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''exécution de wwv_flow_copy_lov : %0';

wwv_flow_api.create_message (
  p_id=>195624904531151618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.EXECUTION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_unable_to_find_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de trouver le raccourci (%0) pour copie.';

wwv_flow_api.create_message (
  p_id=>195625008567151618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.UNABLE_TO_FIND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''espace de travail %0 a été créé et un courrier électronique de confirmation a été envoyé à %1 à %2.';

wwv_flow_api.create_message (
  p_id=>195625121127151618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message return_to_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Retour à la page de connexion %0';

wwv_flow_api.create_message (
  p_id=>195625206061151618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RETURN_TO_LOGIN_PAGE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_disable_work_prov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La création de l''espace de travail est désactivée temporairement.';

wwv_flow_api.create_message (
  p_id=>195625300697151618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.DISABLE.WORK.PROV',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ajouter la contrainte %0';

wwv_flow_api.create_message (
  p_id=>195625419099151619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ADD_CONSTRAINT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message created_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Création le';

wwv_flow_api.create_message (
  p_id=>195625506301151619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATED_ON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mis à jour le';

wwv_flow_api.create_message (
  p_id=>195625613676151619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED_ON',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tri des lignes';

wwv_flow_api.create_message (
  p_id=>195625707726151619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_ORDER',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_as_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il y a %0';

wwv_flow_api.create_message (
  p_id=>195625829494151619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AS_OF',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_min_ago
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 minutes';

wwv_flow_api.create_message (
  p_id=>195625903819151619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MIN_AGO',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_format_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Masque de format';

wwv_flow_api.create_message (
  p_id=>195626024851151620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FORMAT_MASK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calcul';

wwv_flow_api.create_message (
  p_id=>195626100615151620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPUTATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_choose_download_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Choisir le format de téléchargement d''état';

wwv_flow_api.create_message (
  p_id=>195626218347151620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_frm_nav_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de calculer la navigation du panneau. %0';

wwv_flow_api.create_message (
  p_id=>195626316619151620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_FRM_NAV_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_report_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&lt; Vue d''état';

wwv_flow_api.create_message (
  p_id=>195626428535151620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REPORT_VIEW',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ligne %0 sur %1';

wwv_flow_api.create_message (
  p_id=>195626523737151620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_OF',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 erreur. %1';

wwv_flow_api.create_message (
  p_id=>195626628963151621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur de vérification de %0 : %1';

wwv_flow_api.create_message (
  p_id=>195626715821151621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.VERIFY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création de la page) : %0 ';

wwv_flow_api.create_message (
  p_id=>195626820444151621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PAGE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_pg_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création du modèle de page) : %0';

wwv_flow_api.create_message (
  p_id=>195626901846151621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PG_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création du modèle de champ) : %0';

wwv_flow_api.create_message (
  p_id=>195627001393151621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_FIELD_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_create_rpt_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création des modèles d''état) : %0';

wwv_flow_api.create_message (
  p_id=>195627111349151621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW.CREATE_RPT_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création des modèles de région) : %0';

wwv_flow_api.create_message (
  p_id=>195627212419151622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_REGION_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des modèles de liste) : %0';

wwv_flow_api.create_message (
  p_id=>195627316809151622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_LIST_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création des modèles d''historique des accès) : %0';

wwv_flow_api.create_message (
  p_id=>195627406981151622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_MENU_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_popup_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création des modèles de liste de valeurs instantanée) : %0';

wwv_flow_api.create_message (
  p_id=>195627524564151622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_POPUP_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_standard_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création des onglets standard) : %0';

wwv_flow_api.create_message (
  p_id=>195627625973151622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_STANDARD_TABS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_compute_tab_target_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (calcul des cibles d''onglet) : %0';

wwv_flow_api.create_message (
  p_id=>195627708660151622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COMPUTE_TAB_TARGET_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_parent_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (création des onglets parent) : %0';

wwv_flow_api.create_message (
  p_id=>195627820117151623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PARENT_TABS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_page_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie du modèle de page) : %0';

wwv_flow_api.create_message (
  p_id=>195627911050151623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_PAGE_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie du modèle de champ) : %0';

wwv_flow_api.create_message (
  p_id=>195628032143151623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_FIELD_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_report_templates_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des modèles d''état) : %0 ';

wwv_flow_api.create_message (
  p_id=>195628105864151623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REPORT_TEMPLATES_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des modèles de région) : %0';

wwv_flow_api.create_message (
  p_id=>195628216712151623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REGION_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des modèles de liste) : %0';

wwv_flow_api.create_message (
  p_id=>195628327419151623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LIST_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des modèles d''historique des accès) : %0';

wwv_flow_api.create_message (
  p_id=>195628412751151624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_MENU_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_button_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des modèles de bouton) : %0';

wwv_flow_api.create_message (
  p_id=>195628507238151624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_BUTTON_TEMPLATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie de la barre de navigation) : %0';

wwv_flow_api.create_message (
  p_id=>195628625637151624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_NAVBAR_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des listes de valeurs) : %0';

wwv_flow_api.create_message (
  p_id=>195628702160151624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LOV_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_security_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie du modèle de sécurité) : %0';

wwv_flow_api.create_message (
  p_id=>195628806877151624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_SECURITY_SCHEME_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_crypt_key_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La clé doit être de 8, 16 ou 24 octets.';

wwv_flow_api.create_message (
  p_id=>195628930581151624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CRYPT.KEY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_css_api_unable_to_remove_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de supprimer la feuille de style CSS : %0';

wwv_flow_api.create_message (
  p_id=>195629005116151625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CSS_API.UNABLE_TO_REMOVE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_debugtab_biu_fer_invalid_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Format de date non valide.';

wwv_flow_api.create_message (
  p_id=>195629126993151625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DEBUGTAB_BIU_FER.INVALID_DATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liaison impossible de %0. Assurez-vous que la longueur de l''élément est inférieure ou égale à 30 octets. Pour faire référence à des éléments d''une longueur supérieure à 30 octets, utilisez la syntaxe v(). %1';

wwv_flow_api.create_message (
  p_id=>195629222749151625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.UNABLE_TO_BIND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message run_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exécuter uniquement';

wwv_flow_api.create_message (
  p_id=>195629307524151625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RUN_ONLY',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wizapi_delete_checked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Supprimer ce qui est coché';

wwv_flow_api.create_message (
  p_id=>195629422291151625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WIZAPI_DELETE_CHECKED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_olb_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nom de fichier XML de la bibliothèque d''objets de panneaux';

wwv_flow_api.create_message (
  p_id=>195629504448151625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_OLB_NAME',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authorization_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des modèles d''autorisation) : %0';

wwv_flow_api.create_message (
  p_id=>195629606516151626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHORIZATION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authentication_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la création d''application (copie des modèles d''authentification) : %0';

wwv_flow_api.create_message (
  p_id=>195629706881151626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHENTICATION_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cannot_determine_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur : impossible de déterminer l''ID de groupe de sécurité indiqué pour l''application et l''alias d''application.';

wwv_flow_api.create_message (
  p_id=>195629818131151626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CANNOT_DETERMINE_FLOW_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_convert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''alias d''application "%0" ne peut pas être converti en ID d''application unique.';

wwv_flow_api.create_message (
  p_id=>195629926904151626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_CONVERT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_exist_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''alias "%0" n''existe pas.';

wwv_flow_api.create_message (
  p_id=>195630010265151626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_EXIST_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_home_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de vous acheminer vers la page d''accueil';

wwv_flow_api.create_message (
  p_id=>195630107257151626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_HOME_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_update_sub_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans update_substitution_cache : %0';

wwv_flow_api.create_message (
  p_id=>195630229108151627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UPDATE_SUB_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans DML : p_rowid=%0, p_alt_rowid=%1, p_rowid2=%2, p_alt_rowid2=%3. %4';

wwv_flow_api.create_message (
  p_id=>195630327879151627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unable_proc_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de traiter le type de condition "%0" dans wwv_flow_conditions.';

wwv_flow_api.create_message (
  p_id=>195630429853151627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNABLE_PROC_COND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur inattendue dans wwv_flow_conditions.  La fonction aurait dû renvoyer une valeur.';

wwv_flow_api.create_message (
  p_id=>195630528881151627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNEXPECTED_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_rows_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas de lignes à traiter';

wwv_flow_api.create_message (
  p_id=>195630616741151627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_ROWS_TO_PROCESS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_owner_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le propriétaire de la table n''est pas indiqué';

wwv_flow_api.create_message (
  p_id=>195630715272151627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_OWNER_NOT_SPECIFIED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_name_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le nom de table n''est pas indiqué.';

wwv_flow_api.create_message (
  p_id=>195630815358151628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_NAME_NOT_SPECIFIED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_prim_key_col_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La colonne de clé primaire n''a pas été indiquée';

wwv_flow_api.create_message (
  p_id=>195630909253151628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.PRIM_KEY_COL_NOT_SPECIFIED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_fcs_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La colonne de total de contrôle ("FCS") est obligatoire ; elle n''a pas été indiquée.';

wwv_flow_api.create_message (
  p_id=>195631012608151628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.FCS_MISSING',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_invalid_prim_key_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La colonne de clé primaire identifiée ne se trouve pas dans la liste SELECT de l''interrogation.';

wwv_flow_api.create_message (
  p_id=>195631117189151628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.INVALID_PRIM_KEY_COL',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_prim_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune valeur de clé primaire n''a été indiquée. Au moins une ligne doit être indiquée pour que les mises à jour puissent avoir lieu.';

wwv_flow_api.create_message (
  p_id=>195631216232151628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_PRIM_KEY_VALS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_cal_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de s''abonner au modèle de calendrier. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195631303201151628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_CAL_TEMPLATE_REFERENCE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_cal_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de publier le modèle de calendrier. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195631424814151628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_CAL_TEMPLATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message autocommit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Instruction de validation (commit) non applicable. Toutes les instructions sont validées automatiquement.';

wwv_flow_api.create_message (
  p_id=>195631501451151629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTOCOMMIT',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rollback
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Instruction d''annulation (rollback) non applicable. Toutes les instructions sont validées (commit) automatiquement.';

wwv_flow_api.create_message (
  p_id=>195631613709151629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROLLBACK',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p254_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous devez indiquer au moins une région à créer.';

wwv_flow_api.create_message (
  p_id=>195631726397151629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P254.VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vous devez indiquer au moins une page pour création.';

wwv_flow_api.create_message (
  p_id=>195631820311151629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P295.VALIDATION',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_sec_key_col_not_in_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La colonne de clé secondaire identifiée ne se trouve pas dans la liste SELECT de l''interrogation.';

wwv_flow_api.create_message (
  p_id=>195631913551151629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_sec_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aucune valeur secondaire n''a été indiquée pour la colonne de clé secondaire identifiée';

wwv_flow_api.create_message (
  p_id=>195632025127151629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_SEC_KEY_VALS',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Colonne de calendrier.';

wwv_flow_api.create_message (
  p_id=>195632124637151630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR_COLUMN',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_menu_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Menu';

wwv_flow_api.create_message (
  p_id=>195632218893151630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_MENU_FILE_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error_in_mru
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans MRU : ligne = %0, %1, %2';

wwv_flow_api.create_message (
  p_id=>195632307713151630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR_IN_MRU',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_lost_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La version en cours des données dans la base a changé depuis que l''utilisateur a lancé le traitement de mise à jour. total de contrôle en cours = "%0" total de contrôle de l''élément = "%1"';

wwv_flow_api.create_message (
  p_id=>195632432714151630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.LOST_UPDATE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_job_unauthorized_attempt_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tentative non autorisée d''exécution du travail %0 par le schéma %1 dans l''application dont l''ID est %2';

wwv_flow_api.create_message (
  p_id=>195632508808151630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_JOB.UNAUTHORIZED_ATTEMPT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_bg_select_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Une liste de valeurs (LOV) instantanée doit commencer par "select".';

wwv_flow_api.create_message (
  p_id=>195632623417151630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_BG_SELECT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''initialisation de la liste de valeurs (LOV) instantanée : %0 %1';

wwv_flow_api.create_message (
  p_id=>195632709039151631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_INIT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''initialisation de la liste de valeurs (LOV) instantanée avec filtre : %0 %1';

wwv_flow_api.create_message (
  p_id=>195632826607151631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_INIT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_popup_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la génération de la liste de valeurs (LOV) instantanée : %0 %1';

wwv_flow_api.create_message (
  p_id=>195632918663151631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_POPUP_LOV_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas d''interrogation pour l''élément %0 de type liste modifiable.';

wwv_flow_api.create_message (
  p_id=>195633018693151631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_NO_QUERY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_js_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas d''interrogation pour l''élément %0 de type liste modifiable avec réacheminement par JS.';

wwv_flow_api.create_message (
  p_id=>195633115868151631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_JS_NO_QUERY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas d''interrogation pour l''élément %0 de type liste modifiable avec réacheminement par URL.';

wwv_flow_api.create_message (
  p_id=>195633209534151631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Il n''y a pas d''interrogation pour l''élément %0 de type liste modifiable avec réacheminement par URL sur une page.';

wwv_flow_api.create_message (
  p_id=>195633320866151632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_PAGE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_package_invalid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur : le nom de package %0 n''est pas valide ou est déjà utilisé.';

wwv_flow_api.create_message (
  p_id=>195633425738151632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.PACKAGE_INVALID_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_prog_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unité de programme';

wwv_flow_api.create_message (
  p_id=>195633518176151632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_PROG_FILE_TYPE',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generic_attr_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur';

wwv_flow_api.create_message (
  p_id=>195633623579151632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERIC_ATTR.ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_olb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Le fichier que vous avez tenté de télécharger vers le projet de migration de panneaux n''est pas un fichier de bibliothèque d''objets (_olb.XML) valide. Seuls les fichiers XML de bibliothèque d''objets, générés par l''outil de conversion Form2XML inclus dans Oracle Forms, peuvent être téléchargés.';

wwv_flow_api.create_message (
  p_id=>195633726998151632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_OLB_CONTENT_INVALID',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur';

wwv_flow_api.create_message (
  p_id=>195633817853151632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de condition d''affichage de la barre de navigation. %0';

wwv_flow_api.create_message (
  p_id=>195633932674151633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_NAVBAR_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de condition WHEN du processus d''application. %0';

wwv_flow_api.create_message (
  p_id=>195634013685151633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_PROC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de calcul de l''application. %0';

wwv_flow_api.create_message (
  p_id=>195634112730151633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_COMP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_subtitle_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de sous-titre de page. %0';

wwv_flow_api.create_message (
  p_id=>195634212886151633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_SUBTITLE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_button_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de condition de bouton de page. %0';

wwv_flow_api.create_message (
  p_id=>195634306133151633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_BUTTON_COND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_branch_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de condition de branchement de page : %0';

wwv_flow_api.create_message (
  p_id=>195634414283151634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.BRANCH_COND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de calcul de page. %0';

wwv_flow_api.create_message (
  p_id=>195634522132151634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_COMP_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de validation de page. %0';

wwv_flow_api.create_message (
  p_id=>195634617089151634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_VALID_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de mettre à jour le type de processus de page. %0';

wwv_flow_api.create_message (
  p_id=>195634711888151634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_PROC_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_misspell_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur au cours de la mise à jour des mots mal orthographiés. %0';

wwv_flow_api.create_message (
  p_id=>195634814975151634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_MISSPELL_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liaison impossible de %0. Assurez-vous que la longueur de l''élément est inférieure ou égale à 30 octets. Pour faire référence à des éléments d''une longueur supérieure à 30 octets, utilisez la syntaxe v(). %1';

wwv_flow_api.create_message (
  p_id=>195634905558151634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.UNABLE_TO_BIND_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_convert_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1711 Impossible de convertir l''ID de liste de valeurs (LOV) instantanée de la demande.';

wwv_flow_api.create_message (
  p_id=>195635003849151635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.CONVERT_ID_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1721 Elément introuvable pour la liste de valeurs (LOV) instantanée de la demande.';

wwv_flow_api.create_message (
  p_id=>195635101233151635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.FIND_ITEM_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans drop_tablespace, p_name est Null.';

wwv_flow_api.create_message (
  p_id=>195635224415151635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_TABLESPACE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de supprimer le tablespace. Erreur : %0 \nsql :\n %1';

wwv_flow_api.create_message (
  p_id=>195635304477151635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_TABLESPACE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans drop_usern, absence de l_username.';

wwv_flow_api.create_message (
  p_id=>195635428673151635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_USER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de supprimer l''utilisateur. Erreur : %0 \nsql :\n %1';

wwv_flow_api.create_message (
  p_id=>195635526163151635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_USER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_with_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur avec : %0 %1';

wwv_flow_api.create_message (
  p_id=>195635615985151636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.WITH_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer l''utilisateur. %0';

wwv_flow_api.create_message (
  p_id=>195635702284151636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_USER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible de créer le tablespace. %0';

wwv_flow_api.create_message (
  p_id=>195635808372151636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_TABLESPACE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_grant_privs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''accorder des privilèges initiaux. %0';

wwv_flow_api.create_message (
  p_id=>195635931342151636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_GRANT_PRIVS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_remove_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur dans remove_provisioned_company. L''espace de travail est Null.';

wwv_flow_api.create_message (
  p_id=>195636012287151636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.REMOVE_COMPANY_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table créée.';

wwv_flow_api.create_message (
  p_id=>195636121701151636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vue créée.';

wwv_flow_api.create_message (
  p_id=>195636219471151637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur';

wwv_flow_api.create_message (
  p_id=>195636300688151637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Déclencheur créé.';

wwv_flow_api.create_message (
  p_id=>195636424804151637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction créée.';

wwv_flow_api.create_message (
  p_id=>195636517193151637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Procédure créée.';

wwv_flow_api.create_message (
  p_id=>195636621198151637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_body_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Corps de package créé';

wwv_flow_api.create_message (
  p_id=>195636715193151637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_BODY_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package créé.';

wwv_flow_api.create_message (
  p_id=>195636807445151638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Index créé.';

wwv_flow_api.create_message (
  p_id=>195636911920151638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type créé.';

wwv_flow_api.create_message (
  p_id=>195637021924151638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisateur créé.';

wwv_flow_api.create_message (
  p_id=>195637124347151638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vue matérialisée créée.';

wwv_flow_api.create_message (
  p_id=>195637231858151638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rôle créé.';

wwv_flow_api.create_message (
  p_id=>195637327659151638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Séquence créée.';

wwv_flow_api.create_message (
  p_id=>195637420398151639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Synonyme créé.';

wwv_flow_api.create_message (
  p_id=>195637501874151639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_CREATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cmd_executed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Commande exécutée.';

wwv_flow_api.create_message (
  p_id=>195637624015151639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CMD_EXECUTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_table_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'La création de la table a échoué en raison d''une syntaxe SQL non valide.';

wwv_flow_api.create_message (
  p_id=>195637727834151639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.TABLE_CREATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 ligne(s) mise(s) à jour.';

wwv_flow_api.create_message (
  p_id=>195637819738151639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_UPDATED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_inserted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 ligne(s) insérée(s).';

wwv_flow_api.create_message (
  p_id=>195637926017151639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_INSERTED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_package_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Echec de la création du package en raison d''une syntaxe SQL non valide.';

wwv_flow_api.create_message (
  p_id=>195638023614151640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.PACKAGE_CREATE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 ligne(s) supprimée(s)';

wwv_flow_api.create_message (
  p_id=>195638111913151640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_DELETED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur';

wwv_flow_api.create_message (
  p_id=>195638202579151640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_fetch_fnd_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Impossible d''extraire les informations utilisateur FND. %0';

wwv_flow_api.create_message (
  p_id=>195638304815151640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.FETCH_FND_USER_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_delete_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la suppression du rôle de développeur. %0';

wwv_flow_api.create_message (
  p_id=>195638410912151640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.DELETE_DEV_ROLE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_user_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'L''utilisateur %0 ne dispose pas de privilèges sur le schéma %1.';

wwv_flow_api.create_message (
  p_id=>195638522575151640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.USER_NO_PRIV_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_updatable_report_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur d''analyse d''état modifiable : %0';

wwv_flow_api.create_message (
  p_id=>195638601520151641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.UPDATABLE_REPORT_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table supprimée.';

wwv_flow_api.create_message (
  p_id=>195638728384151641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package supprimé.';

wwv_flow_api.create_message (
  p_id=>195638800363151641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Utilisateur supprimé.';

wwv_flow_api.create_message (
  p_id=>195638907272151641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vue supprimée.';

wwv_flow_api.create_message (
  p_id=>195639022174151641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_execution_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de l''exécution de wwv_flow_copy_page : %0 >> %1';

wwv_flow_api.create_message (
  p_id=>195639120087151641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE.EXECUTION_PAGE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Séquence supprimée.';

wwv_flow_api.create_message (
  p_id=>195639202749151642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table modifiée.';

wwv_flow_api.create_message (
  p_id=>195639316497151642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_ALTERED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dataload_xml_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'erreur';

wwv_flow_api.create_message (
  p_id=>195639418507151642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATALOAD_XML.ERROR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fonction supprimée.';

wwv_flow_api.create_message (
  p_id=>195639529036151642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Procédure supprimée.';

wwv_flow_api.create_message (
  p_id=>195639630882151642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_credentials_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accès non autorisé (wwv_flow_api.set_credentials non défini).';

wwv_flow_api.create_message (
  p_id=>195639725029151642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.CREDENTIALS_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erreur lors de la suppression du rôle de développeur. %0';

wwv_flow_api.create_message (
  p_id=>195639805461151643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.DEV_ROLE_ERR',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Index supprimé.';

wwv_flow_api.create_message (
  p_id=>195639932425151643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vue matérialisée supprimée.';

wwv_flow_api.create_message (
  p_id=>195640012706151643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rôle supprimé.';

wwv_flow_api.create_message (
  p_id=>195640122295151643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Synonyme supprimé.';

wwv_flow_api.create_message (
  p_id=>195640217010151643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Déclencheur supprimé.';

wwv_flow_api.create_message (
  p_id=>195640300330151644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type supprimé.';

wwv_flow_api.create_message (
  p_id=>195640416271151644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type d''index supprimé.';

wwv_flow_api.create_message (
  p_id=>195640518576151644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_context_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Contexte supprimé.';

wwv_flow_api.create_message (
  p_id=>195640627424151644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CONTEXT_DROPPED',
  p_message_language=>'fr',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lien de base de données supprimé';

wwv_flow_api.create_message (
  p_id=>195640708949151644 + wwv_flo