#!/bin/sh
#
# $Header: checkOidCredentials.sh 30-jan-02.13:00:58 ggilchri Exp $
#
# checkOidCredentials.sh
#
#  Copyright (c) Oracle Corporation 2002. All Rights Reserved.
#
#    NAME
#      checkOidCredentials.sh - Check Oid Credentials
#
#    DESCRIPTION
#      Check Oid Credentials
#
#    NOTES
#    Usage:  checkOidCredentials.sh ORACLE_HOME BIND_DN BIND_PWD LDAP_PORT_NUM HOSTNAME
#
#    MODIFIED   (MM/DD/YY)
#    ggilchri    01/30/02 - dn param
#    achoudha    01/27/02 - Creation
#

ORACLE_HOME=$1
export ORACLE_HOME

BIND_PWD=$2
export BIND_PWD

PORT_NUM=$3
export PORT_NUM 

HOSTNAME=$4
export HOSTNAME

PATH=$1/bin:$PATH
export PATH

TNS_ADMIN=$1/network/admin
export TNS_ADMIN

LD_LIBRARY_PATH=$ORACLE_HOME/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH

NLS_LANG=AMERICAN_AMERICA.UTF8
export NLS_LANG

echo $ORACLE_HOME/bin/ldapbind -D "BIND_DN" -w $BIND_PWD -p $PORT_NUM -h $HOSTNAME
$ORACLE_HOME/bin/ldapbind -D "$BIND_DN" -w $BIND_PWD -p $PORT_NUM -h $HOSTNAME

echo $?

exit 0 
