#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/crs_resources.pl /st_emagent_10.2.0.4.2db11.2/3 2009/03/06 03:49:16 ajdsouza Exp $
#
# crs_resources.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      crs_resources.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajdsouza    11/11/08 - begin clock for view testing
#    ajdsouza    01/11/08 - bug fix 6723959
#    hying       03/30/05 - 4263092, review changes 
#    hying       01/10/05 - hying_crs_metrics
#    hying       12/30/04 - Creation
# 
require "emd_common.pl";
require "semd_common.pl";

my $oldOH;

BEGIN
{

 use POSIX qw(locale_h);

 my $clocale='C';

 for ( qw ( LC_ALL LC_COLLATE LC_CTYPE LC_TIME LC_NUMERIC LC_MESSAGES LC_MONETARY LANG LANGUAGE ) )
 {
   $ENV{$_}=$clocale;
 }

 setlocale(LC_ALL,$clocale) or warn "WARN:Failed to set locale to $clocale \n ";

 # save ORACLE_HOME and restore it back in END
 $oldOH = $ENV{ORACLE_HOME} if $ENV{ORACLE_HOME};

 # temporarly setting environment only in dev view env
 # this code is not avtive in production
 # !! DO NOT CHANGE THE CLUSTER NAME HERE WHEN YOU
 # CHECK IN AS THIS WILL BREAK REGRESSION
 #
 # IF YOU ARE CREATING A HAS VIEW CREATE IT 
 # WITH VIEW NAME <sa view_name>t
 # e.g. if sa view is sa3114 the has view should be sa3114t
 # the clustername is the has view should be newdb_cluster
 if ( $ENV{ADE_VIEW_ROOT} and not $ENV{HAS_USE_SHIPHOME} )
 {
  my $advrt =  $ENV{ADE_VIEW_ROOT};
  $advrt  =~ s/_ag$//;
  $advrt  = $advrt."t";

  $ENV{ORA_CRS_HOME}="$advrt/oracle";
  $ENV{CSS_CLUSTERNAME}='newdb_cluster';

  $ENV{CRS_HOME}="$ENV{ORA_CRS_HOME}";
  $ENV{CV_HOME}="$ENV{CRS_HOME}";
  $ENV{OCR_ROOT}="$ENV{CRS_HOME}/has_work/data.ocr";
  $ENV{OCR_LOC}="$ENV{CRS_HOME}/has_work/ocr.loc";
  $ENV{OCR_DEVELOPER_ENV}='TRUE';
  $ENV{HAS_DEVELOPMENT_ENVIRONMENT}='TRUE';
  $ENV{CV_JDKHOME}="$ENV{CRS_HOME}/jdk15";
  $ENV{ORA_ENVIRON_OPTS}='true';

  my $libs = "$ENV{CRS_HOME}/lib:$ENV{CRS_HOME}/has/lib:$ENV{CRS_HOME}/opsm/lib";

  $ENV{LD_LIBRARY_PATH}="$libs:$ENV{LD_LIBRARY_PATH}" if $ENV{LD_LIBRARY_PATH};
  $ENV{LD_LIBRARY_PATH}="$libs" unless $ENV{LD_LIBRARY_PATH};

  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin:$ENV{PATH}" if $ENV{PATH};
  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin" unless $ENV{PATH};

 }

}
                                                                                            
my $crs_home = shift(@ARGV); # CRSHome
if ($crs_home eq "")
{
  exit 0;
}
my $node_name = shift(@ARGV); # NodeName
                                                                                            
#################################
# View testing required ENV
#$ENV{ORA_CRS_HOME} = $crs_home;
#$ENV{LD_LIBRARY_PATH} = "$crs_home/lib:$ENV{LD_LIBRARY_PATH}";
#$ENV{OCR_LOC} = "/etc/oracle/ocr.loc";
#$ENV{OCR_DEVELOPER_ENV}="true";
#################################
                                                                                            
$cmd = "$crs_home/bin/crs_stat";
#Bug fix 6723959
$ENV{ORACLE_HOME}=$crs_home;
$result = `$cmd`;

my @lines = split(/\n/, $result);
my $i = 0;
my ($var, $val, $resource, $original_host, $current_host, $state, $on, $status);
                                                                                            
NAME_LOOP: while ($i < $#lines)
{
  ($var, $val) = split(/=/, $lines[$i]);
  if ($var eq "NAME")
  {
    $resource = $val;
    if ($val =~ /ora.(\w+).gsd$/ || $val =~ /ora.(\w+).ons$/)
    {
      if ($node_name eq $1)
      {
        while ($i < $#lines)
        {
          $i++;
          ($var, $val) = split(/=/, $lines[$i]);
          if ($var eq "TARGET")
          {
            $target = $val;
            debug("$var status: $target");
            $i++;
            ($var, $val) = split(/=/, $lines[$i]);
            $state = $val;
            debug("$var status: $state");
            if ($target eq "ONLINE" && $state eq "OFFLINE")
            {
              printf "em_result=$resource|OFFLINE NOT RESTARTING\n";
              debug("em_result=$resource|OFFLINE NOT RESTARTING\n");
            }
            else
            {
              printf "em_result=$resource|$state\n";
              debug("em_result=$resource|$state\n");
            }
            next NAME_LOOP;
          }
        }
      }
    }
    elsif ($val =~ /ora.(\w+).vip$/)
    {
      $original_host = $1;
      while ($i < $#lines)
      {
        $i++;
        ($var, $val) = split(/=/, $lines[$i]);
        if ($var eq "TARGET")
        {
          $target = $val;
          $i++;
          ($var, $val) = split(/=/, $lines[$i]);
          ($state, $on, $current_host) = split(/ /, $val);
          if ($node_name eq $current_host)
          {
            if ($target eq "ONLINE" && $state eq "OFFLINE")
            {
              printf "em_result=$resource|OFFLINE NOT RESTARTING\n";
              debug("em_result=$resource|OFFLINE NOT RESTARTING\n");
            }
            else
            {
              printf "em_result=$resource|$state\n";
              debug("em_result=$resource|$state\n");
            }
          }
          next NAME_LOOP;
        }
      }
    }
  }
  $i++;
}
                                                                                            
sub debug
{
  my ($line) = @_;
  EMD_PERL_DEBUG("$line");
}
                                                                                            
exit 0

